CDF       
      pressure  e   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P18    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.891218Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @O         data_max      @O         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     ;(  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?ffffff   data_max      @_33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      ;(  n   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        4   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?Q_p   data_max      @O
M   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       ;(      temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        (   salinity                	long_name         salinity   units         PSS-78     data_min      @@Msh   data_max      @AJ͞&   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      ;(    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       =   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @)333333   data_max      @rfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        ;( K   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?9XbN   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ;(    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ;(    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     ;( )   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       d   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( s   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( s   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d       t   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hj   data_max      @Hj   C_format      %9.4f          t   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      ab   data_max      ab   C_format      %9.4f          t   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        t   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        U   data_max        U   C_format      %4d        t@O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      @O      ?ffffff?ffffff@@      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @D@E      @E     @F      @F     @F33333@G@H@H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @Mffffff@Mfffff@N@O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T9@Tfffff@U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X&fffff@X33333@X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[y@[     @[@\@     @\     @\     @]      @]@     @]     @]     @^@     @^     @^     @_      @_@     @_     @_     @`      @`fffff@`C33333@``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a33333@b&fffff@b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @cs33333@cfffff@c@c     @d      @d      @d@     @d`     @dvfffff@d@d     @d     @e      @e#33333@e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @f@g#33333@g@     @g`     @g     @g     @g     @g     @h      @h      @h333333@h     @h     @h     @h     @i      @i      @i@     @i`     @is33333@ifffff@i     @i     @j      @j     @j@     @j`     @j     @j     @j     @j     @j@k,@k@     @k`     @k     @k     @kfffff@k陙@l      @l      @l@     @l`     @l     @l     @l     @l@mc33333@m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o@o@     @o`     @o     @o     @o     @offfff@pfffff@p     @p      @p0     @p@     @pNfffff@pd@pp     @p     @p     @p     @p     @p     @p     @p     @p     @p33333@q(     @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q@q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r33333@r     @r     @r     @r     @r     @r     @rfffff@s&fffff@s.fffff@s@     @sP     @s`     @sp     @s     @s@s@s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t|@t     @t@t@t     @t     @t     @t     @u      @u     @u      @u)@ud@up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v@vA@vP     @v`     @vp     @v     @v     @v     @v     @v     @v33333@v     @w      @w@w!@w0     @w@     @wP     @w\@wnfffff@w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x.fffff@x@     @xP     @x`     @xp     @x     @x     @x     @x@x     @x     @x     @x@y@y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @yfffff@z      @z     @z      @z0     @z@     @zP     @z`     @zp     @zy@zfffff@z     @z     @z     @z     @z     @z     @{      @{     @{33333@{Ffffff@{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|      @|0     @|@     @|P     @|`     @|p     @|     @|33333@|     @|     @|     @|     @|     @}      @}33333@}      @}0     @}@     @}P     @}`     @}p     @}|@}@}     @}     @}     @}fffff@}fffff@}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~{33333@~fffff@~33333@~     @~     @~     @~     @~     @      @     @      @0     @>fffff@Vfffff@`     @p     @     @     @     @     @     @33333@33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @T@c33333@h     @p     @x     @     @     @     @@fffff@     @     @     @     @     @     @     @33333@񙙙@33333@     @     @     @     @      @(     @0     @8     @@     @H     @P     @T     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @33333@     @      @(     @0     @8     @@     @H     @P     @U@i@p     @x     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @     @fffff@     @     @      @(     @0     @8     @@     @H     @Q@X     @`     @h     @p     @x     @33333@@     @     @     @     @     @     @     @33333@     @     @     @     @33333@33333@      @     @     @     @@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @@33333@     @     @     @      @(     @0     @8     @=@P@X     @`     @h     @p     @x     @     @@fffff@     @     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @      @%@1@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @33333@     @     @     @     @     @      @     @     @     @      @(     @.fffff@8     @@     @H     @P     @X     @`     @h@p     @x     @     @     @     @fffff@     @     @     @     @@33333@     @     @     @     @     @     @      @     @     @fffff@(@0     @8     @@     @H     @L     @X@`     @h     @p     @x     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @@@      @     @     @     @      @(     @,     @;33333@@     @H     @P     @X     @`     @h     @m@zfffff@     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @      @     @     @     @"fffff@(     @0     @8     @@     @H     @P     @X     @^fffff@l     @p     @x     @     @     @     @     @     @fffff@fffff@     @fffff@@     @     @     @     @     @     @      @     @     @     @@0@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @fffff@@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @     @     @     @      @'33333@8@@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @      @     @     @     @(@0     @8     @@     @H     @O33333@Y@`     @h     @p     @x     @     @     @     @     @@@     @     @     @     @     @     @     @     @@fffff@      @     @     @     @      @(     @0     @8@<@Q@X     @`     @h     @p     @x     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @홙@ fffff@     @     @     @     @     @     @     @      @$     @(     @,     @4@8     @<     @@     @D     @H     @L     @P     @T     @V@]@`     @d     @h     @l@o@t     @x     @|     @     @     @     @33333@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @ә@     @     @     @     @     @     @     @     @33333@@     @     @     @fffff@     @     @      @$     @(     @,     @/33333@4@8     @<     @@     @B@H@L     @P     @T     @X     @\     @`     @d     @h@l     @p     @t     @x     @|     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @fffff@@     @     @     @     @     @33333@fffff@     @     @     @     @     @fffff@     @     @      @33333@
@@@     @      @$     @(     @*@4fffff@8     @<     @@     @D     @H     @L     @P     @T     @\@_33333@c@h     @l     @p     @t     @x     @|     @@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @Ǚ@     @     @     @     @     @     @     @     @33333@     @     @fffff@     @      @     @     @     @     @     @     @     @      @$fffff@&     @-33333@0     @4     @8     @<     @@     @D     @G33333@M@P     @T     @X     @\     @`     @c@h@l     @p     @t     @x     @|     @@     @     @     @     @     @@     @     @     @     @     @33333@@     @     @33333@     @     @     @     @     @     @@뙙@@     @     @     @      @     @     @     @     @     @@!33333@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @a@d     @h     @l     @p     @t     @x     @|     @~@     @     @     @     @     @     @     @     @     @     @     @33333@     @33333@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @      @$     @(     @+@0@4fffff@8     @<     @@     @D     @G33333@N     @P     @T     @X     @\     @`     @d     @g@r     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @ᙙ@     @癙@     @     @     @     @     @      @     @@     @     @     @      @$     @(     @,     @0     @4     @8     @;@E33333@H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @x@|     @     @     @33333@@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@	33333@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @F     @M@P     @T     @X     @\     @`     @d     @h     @j@u33333@x     @zfffff@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @fffff@ fffff@     @     @     @@     @     @     @      @$     @(     @,     @0     @3@=33333@@     @D     @H     @J@Q33333@T     @X     @\     @^@e@h     @l     @p     @t     @x     @|     @     @fffff@fffff@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @@     @     @     @     @@     @      @$     @(     @,     @0     @4     @7@A@D     @H     @L     @P     @T     @X     @\     @`     @m@p     @t     @v@}33333@     @     @     @     @     @@@     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @fffff@%@(     @,     @/@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @[@e33333@h     @l     @p     @t     @x     @|     @@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @˙@     @     @     @     @     @     @33333@33333@      @     @     @     @     @     @     @33333@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @[33333@h     @l     @p     @t     @x     @|     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @㙙@fffff@     @     @     @     @     @      @     @     @
     @@     @     @      @$     @(     @,     @533333@8     @<     @@     @D     @H     @L     @O@Y33333@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @@     @@     @     @     @     @fffff@%33333@(     @,     @0     @4     @8     @<     @?@F     @H     @L     @P     @T     @X     @\     @`     @d     @h     @jfffff@p     @t     @x     @|     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @>@L     @P     @T     @X     @\     @`     @b@pfffff@t     @x     @|     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @Ù@     @     @     @     @     @     @     @     @     @@@     @     @     @      @     @     @33333@     @     @     @      @$     @(     @,     @0     @4     @8     @:@@@D     @H     @L     @P     @T     @X     @\     @_33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @zG{@z)_@z~@zG{@{J#9@{A@{~$@{A@{~$@{dZ@{A@{lC@{lC@|n.@|64@|j~#@|j~#@|PH@|쿱[@}!.H@}p
=@}<64@{m]@zxl"h
@vz@s@r-V@q-@rᰊ@t9XbN@sg@u%F
L@vFs@w3@{lC@}!.H@@IQ@~BZc @y	k~@xl"h	@w3@yD@y"`@b}V@a@N@+I@O;dZ@@R@|@)^@%@K]c@g8}@ ѷ@@~$t@~6z@|#x@{lC@{A@z)_@v_ح@u%F
L@t3@ql@k6z@fA@g,@hr Ĝ@iDg8~@iy@jd7@h@dTɆ@_vȴ9@Y|@^҈p;@_vȴ9@aGz@ao@ae@h$xG@h>BZc@h@i@p{@T@L_@zxl"h@#x@ ѷ@I^@N;@[W>6z@vE@p:~ @|?@e+a@O
M@TɆ@?@9@Dg8~@~"@"h	ԕ@e@}H@A7K@e@u%F@T`d@+I@w3@N+@Ao hی@=b@74m@2䎊q@0
(@-8Y@"}Vm@cA @u%F
@ߤ@7KƧ@>BZ@}ڹZ@rW@ilD@cwk@ae@\?@XPH@QN;5@Ks@F$/@2GE85@,<쿱@ce@74@\(@*0U2a@Mj@dZ@t@|Q@p:~@&IR@]+j@NMj@)y@&I@-V@[@ԕ*1@H@@vȴ9X@3@iB@2W@@d7@>6z@zS&@l1&y@d7@`'RT`@["`B@Vl!-@P$tT@Gݗ+@;A@8Q@12W@)*0U2a@As@S@Ǔݗ+@w1@sP@'/@o i@t֡a@B ѷ@+U=@ 4m9@S@o @Ƨ-@'RT@ߤ@@-
q@p:@$@jfB@eO
@\N;@G@@@n@@*0@Q@JL@fA@b}V@0
@,<@*0U2@qi@W'@84֡@2W@{J#9@z^5?|@tm8@g-@TE@An.@%u@N;6@	'RTa@1.@/@Ft@_F@حU@ᰉ@@쿱[@g	l@!-w@O
@"`B@y=c@y@ѷX@vȴ9X@mw1@h@a'R@V@L/{J#@2W@'RT`e@N;6@H˒:@3@e@tj@J#9@9XbN@-w1@cA \@9Xb@?@z^5?|@iDg8~@P|@K)^	@G#@Eݗ@C@Bu%F
@A:S@>"@=<64@6Fs@.1@&IQ@ce@o h@w1@|@rGE@m@_@@p:~ @k~($@T,<@=p
=@3E@,VϪ@%u@cA \@ߤ?@D@Ov_@
L/@~$@rG@GE85@~"@}Vm@*0@|?@`-
@L/{J#@H@CnP@>"@8)@5?|h@1[W>6@+a@@&A@Ft@kP|@Ʌoi@nO@`A7@/{J#@ȴ9X@@ ѷY@p:~@Q@ï@S&@C,z@R<6@S&@-
q@!R<@~
(@uXy=@m
qv@`ěT@V+J@RS&@QN;6@Ik~(@@4m@9"`@2䎊q@/iDg8@/ hۋ@%ڹ@kP|@tj@$tS@
jOv@_o@@z@oiDg8@0U2a|@-w1@'/W@W'@Fs@_o@M:@u%F
@ [7@ڹZ@YJ@Fs@|@'RT@zxl"@IQ@>@Q_@)^@C%@@YJ@nP@˒:)@}Vl!@y(@poiDg8@kP{@j~"@fA@f@de@dTɆ@dtSM@aGz@[Q@Y+@T@Mqu"@L/{J#@L~($x@JD@I'RTa@G#@GzH@F-@F
L/@E8YK@B\(@Bu%F
@@NU@?.H@=p
=@9	k~@7kP@6Fs@5sg@3ߤ@/Vϫ@'/V@#
=p@"wkQ@!-w1@쿱[W@-V@1&@wkP@]ce@]ce@Q@(\@@|@@L_@p:@S&@
@
L/{@S&@@o hی@u%F
@@\(@:S@/V@6z@ 4m@_ح@)y@lC@Xe@eں@+@W@E@	k~@l@fB@$xG@S@Z@Q_@sP@ݗ+k@Ʌoi@ңS&@а{@jOv@ʦL/{@s@oiDg@$t@#x@)_@xl"h
@rGE8@1@1@F@֡a@䎊q@GE85@s@-@iB@u!S@t@>B[@1&y@Dg8~@TɆ@	@[6@Ft@Ov_خ@Ov_خ@ݘ@y=c@@sPH@@8YJ@zG@*0U@@͞@T@Vu@@jOv@!R<@ߤ?@p:~@C%@oiD@*0@@4n@IQ@yY}@w+@sMjO@nc	@g&@dZ1@cS&@b}Vm@a.H@_o@^u@a|Q@b@4@dTɆ@ae@`҈p@_;dZ@]+j@\ߤ@@TɅoi@M5Xy>@O'/W@P@S@QN;5@N!R<@I ѷ@E@EQ@C{J#9@?@4J@-C\@1@3@5'0@333333@-(@%ڹ@#eO@ 
qu@>@=K^@vȴ@6C@@@N;5@q@
=p
@@b}V@:~ @빌~($@C,z@o@iB@$@ٳ|@ק&@a@O@̘_@]cf@|hs@rG@֡a@U2a|@B@'@n.3@h	ԕ@-
@tj@hr @bM@)^@@@|Q@y"`@v!.I@t!-w2@sPH@q@lVϪ@`d8@Y+@T,<@P{@PH@OAs@LcA \@I@H@C\N@@4m@>vȴ9X@=v@<쿱[@;5Xy@8}H@4֡a@,1&y@%zxl"h@"h	ԕ@u"@u%@0
)@@Z@bM@1&x@@$/@H˒@(@u!S@Q@lC@`A7L@C,@҈p@iB@(\@ק&@҈p:@v_ح@;5X@а{@;5X@;5X@p:~@͞%@@@&IR@vȴ9X@5Xy@n.@BZc @6z@@BZc @b@쿱[@S&@w1@tSM@.H@	k@ěT@ěT@	k@R<6@Z@I^5?@eO@ݗ+@+I@YJ@o h@tj@%2@{J#9@@hۋq@|?@yrGE8@o4֡a@g8}H@be+@_;dZ@ZQ_@Xy=c@Vt@O;dZ@HK]c@E84֡@C@ATɅo@9XbM@/O
M@-
qv@%@S&@
_ح@
{m@
\@
+a@
C,@
7@
B@
JL@
C,@
T`d@
_p@
ΤT@
;5X@
jOv@
84֡@
m\@
?@
,zxl@
64@
~($@
'RT@
/V@
@
n.3@
'RT`@
(@
|hr@
xl"h	@
tj~@
m(@
g8}H@
ae@
]+j@
Zݘ@
XU@
TɅoi@
N+@
M5Xy>@
Gy@
E@
Eo i@
>vȴ9X@
5Xy=@
0'RT@
)^@
$TɆ@
 	k@
!-w1@
@N@
~($x@
p:@˒:)@C\@F]d@:~ @Q@@%1@cA @+@֡af@&@H@@Q@C@~($@d7@-
@,<@_F@Ov_@O
M@\(@K]d@hۋq@|hr@z>B@y(@t#@lC@kC,z@h	ԕ+@bM@ZQ_@XD*@W>6z@Rm@M@J#9@=b@6C-@.2X@+6z@(\)@'/V@%S@$?@ ěT@+j@Mj@@?@H˒@VϪ@1.@e@ݗ+j@֡af@_p@ɅoiD@K]c@Ƨ-@,zxl@6@
(@K]@^5?|@rG@4m@@=K^@_F@)^@#@%2@@4n@~m\@z@u%F
L@qiB@kP{@iDg8~@g8}H@XD*@T`d@P|@M:@H˒:*@B\(@<j~#@8Q@2W@#
=p@!ae@ 	k@u@+j@n@rGE9@p:@_o@ IQ@
C\@
Ov`@
,<@
Z@
҈p;@
څݘ@
Ϫ͞@
Ϫ͞@
cA \@
ɺ^5?}@
E84@
,zxl@
vȴ9X@
64@
/V@
4֡b@
?@
U=@
TɅ@
?@
h	ԕ@
䎊r@
@
=p
@
?@
:S@
|PH@
zG{@
xl"h	@
u\(@
sE@
jfB@
^҈p;@
Y>BZ@
W&@
U2a|@
T*1@
O͞@
JD@
I^5?}@
GzH@
A7Kƨ@
;5Xy@
7Xe@
.zG@
+6z@
($xG@
#wk@
 -
@
O;d@
@
$/@	Vl!@	?@	PH@	G{@	kP@	MjO@	(@	Q@	x@	䎊qj@	e@	A7K@	Ft@	/w@	6@	Ϫ͞@	˒:)z@	?@	,zxl@	n.@	E@	m8@	g	l@	o@	v@	I^@	wk@		k@	@	S&@	hr @	@	'RTa@	#@	IQ@	}E@	{~$@	y	k~@	w1@	mC\@	d7@	a@N@	Zc	@	T*1@	L/{J#@	C\N@	>6z@	<64@	9~($@	8}H@	74m@	7Xe@	5sg@	0U2a|@	'RT`e@	"wkQ@		@	tj@	O
M@	S&@	Mj@	
qu"@	
=p
@		7KƧ@xl"h
@73@\(@oiDg8@fB@Dg8~@ڹ@䎊qj@%1@	@d8@ܑN;@bM@+@ݗ+j@y=c@2a|@W'@s@@6@m\@'RT@Vϫ@r@ ě@Vϫ@<쿱@,@S&@1&@sh@hr @ԕ*@$/@4m9@{~$@y"`@xl"h	@u!R@p:~ @mhr!@l"h	ԕ@jJL@h>BZc@g@ceO@`҈p@\(\@ZQ_@Z1'@W&@R<64@P|@N+@M:@GzH@E8YK@D2W@A7Kƨ@?|hs@=p
=@:^5?|@6C-@6}Vl@6z@2a|Q@+U=@(\)@%u@#9@"3@	@쿱[W@ߤ@@:)y@	ԕ*@ݗ@ 4m9@Q@Y|@@	k@+a@Ft@a@O@@@#9@˒:*@š@BZc @/V@D@YJ@3@?|h@zxl"@TɅ@-w1@Z@*0U2@:)y@rGE9@L/{@p:@ݗ+@JM@ ѷ@~$t@z>B@xl"h	@u!.@qu!S@jJL@eڹ@be+@^iB@^@]+j@\N;@UfA@N+@K)^	@Fs@GE84@GzH@Gy@F]cf@F-@F]cf@F]cf@F]cf@Em\@Ca@N@>vȴ9X@6E@/r@+I^@*d7@(@%S@[@tj~@@	 ѷ@tj@m]@MjO@Ov`@rGE@A@%1@]ce@Ϫ͟@ѷX@W'@\(@6z@XbM@E@m8@m\@W@TɅ@wkQ@R<6@-w1@%@@Ov_@4J@ߤ?@@q@	 @&I@JM@n.@$tS@|Q@weں@v+jg@sg@qiB@n.2@k~($@gfA@f1.@_حV@\>@\N;@[q@Zݘ@XU@W>6z@T`d@T`d@P*0U@L/{J#@JW'@H@Dg8}@A7Kƨ@>
(@7Xe@2W@,>B[@+jf@+U=@,<쿱@+6z@*0
@)@%S@$TɆ@#S&@쿱[W@e+a@*0@R<6@$/@@N@$tT@qi@I^5?@	k~(@JM@ ѷX@ 4m9@b}V@.H@s@j~@
=q@쿱[W?@rGE@@+a@	@M@|Q@
qu@Q_@ԕ*1@а{@cA \@@m\@@)_@Xe@֡a@ᰊ@
(@jf@S@-w1@[6@U=@IQ@C,zx@tj@L_@N;6@\(@qu"@ڹY@k~(@K]d@Q@@I^5@~\N<@|?@z>B@weں@v_ح@s@ql@o-V@oiDg8@m(@kP{@irGE@hۋq
@g8}H@eڹ@d7@a'R@`҈p@_;dZ@]cA @Vl!-@Np:~@I^5?}@GzH@C@As@=p
=@8)@5?|h@2-V@.zG@-V@+U=@(\)@&L/{J@"`A@u"@u"@Q@6C@+J@S&@)^@
(@	ԕ*@K]d@n/@?@%2@ ѷ@ ѷX@$tS@~$@_ح@!-w@B@8}H@fffff@@+a@Z1@e+@ce@JE@ק&@֡af@a@O@@y@Zc@<64@j~#@^5?|@ᰊ@1@jf@0U2a|@Xy=@'@S@u@[6@u@,=@C,zx@6C@@nO@'/W@Mj@(@ݗ+@o h@nP@ѷX@~"@zG{@w+@n.2@hr Ĝ@eڹ@e`A7L@e+a@c	@`A7K@_;dZ@^ ѷY@[W>6z@Y>BZ@Xy=c@U2a|@P{@N+@N;5X@M:@KƧ@J#9@As@>6z@<j~#@6}Vl@5Xy=@3|@1-@0 ě@.H@-V@,>B[@&IQ@%S@%F
L0@%u@$xF@ -
@Ov_خ@S@@@sh@@ݗ+@@4n@      @"@.H@kP@Y|@PH@@hr!@\@"h	ԕ@~"@ڹ@e@Gz@$@+@ק&@t@l!-@Ϫ͞@fA@Z@ΤT@]cA@@E84@g8}@\(@4m@[W>@)@?|h@9XbN@ߤ@W@2W@'RT@v@͞&@wk@-
@!-w1@%@1&@,<@e+a@$tS@*0@҉@Mj@I^5?@qiC@K]d@YJ@?@F]c@|?@v+jg@rs@mhr!@jJL@g@dqj@d%1@cZ@cS@b@4@^҈p;@W&@SMj@Rp:@O;dZ@MjOv@Ks@JL_@I@HK]c@ATɅo@<n.@:~@:S&@9Y}@9#w@6}Vl@7Xe@5?@12W@/r@,>B[@'-@$/@!-w1@ 'RT`@Ov_خ@}H@,<@u%F@@@Xe,@tj~@
O;dZ@C%@	 ѷ@ݗ+@oiDg@F]c@.H@!.H@~$@>B@eں@!R@%F
L@SMj@-V@VϪ@VϪ@"h	ԕ@~"@fffff@C,@
qu@y=c@ӎMj@T`d@;dZ@@D@ǮzH@,zxl@4m@n@BZc @4֡b@KƧ@KƧ@z@?|h@9XbN@m\@[W>6@q@I^@$xG@S@n.3@.H@䎊r@%@vȴ@@ݗ+k@sP@qi@=p
@&I@@$tS@}H˒@zG{@xF@x73@wkP@r{m@nt@iDg8~@c	@`A7K@_;dZ@[6@Z1'@QR@N+@JD@HK]c@E8YK@B@=p
=@<64@9D@9#w@9#w@7KƧ@5Xy=@4֡a@2m\@+a@@!R<6@-V@_o@$tS@Mj@C%@C%@xF]@'/@'/@
ڹY@	k~(@#@o h@$tS@s@=b@kP@!.I@%F
L@D@iDg8@.2@C@"h	ԕ      @rGE@`A7L@ⶮ}Vm@M@حV@ܑN;@c	@e+@fA@ѷX@]cA@)^@2W@NU@n.@/V@S&@Q@֡a@o@v@
qv@6z@\)@S@Q@ߤ@@6C@tj@u@'/@&I@M:@M:@I^5@|#x@zxl"h
@xF@u!.@mhr!@kQ@g8}H@Zݘ@UϪ͞@T`d@T,<@O͞@N;5X@N_o @M5Xy>@LcA \@KƧ@J#9@H@F-@A [7@@NU@>ߤ?@<j~#@:)_@9~($@84֡b@2ᰊ@/v@.}Vl@,<쿱@)lD@)lD@*0U2a|@)lD@)@)@(TɅ@',@%1@%u@!o@u"@_F@tj@zG@nO@n@n@$tT@rGE9@҈@	ԕ*@+I@n/@ݗ@JM@M:@{J#9@nP@$/@ \N<@ \(@ PH@ 8Y@ g	@ B@ ᰉ'@ B@ @ A@ `A7L@ Z1@ |Q@ d8@ 
qu@ ;dZ@ iB@ cA @ cA @ حU@ l!-@ `d@ Z@ R@ _p@ H@ ͞%@ /{J#@ @ @ s@ m\@ m\@ m\@ 84֡@ *0@ C@ Z@ 4֡b@ Xe@ Xy=@ ?|h@ '0@ J@ r@ zxl"@ I^@ d7@ x@ TɆ@ wkQ@ 'RT`@ 쿱[W@ u@ [@ 1&@ wkP@ S@ +j@ sh@ zG@ Fs@ \(@ o h@ @ nP@ F]c@  ѷ@ $/@ ~$t@ y"`@ x-
@ w1@ u%F
L@ tSMj@ r ě@ q@ o4֡a@ o4֡a@ o4֡a@ mhr!@ kP{@ kP{@ l"h	ԕ@ g	k@ `d8@ ]cA @ [6@ Xy=c@ XbM@ TE@ S@ Sa@O@ S&@ R<64@ R䎊@ Q@ OAs@ JD@ HK]c@ GzH@ F-@ Eo i@ @n@ >6z@ =v@ :)_@ :^5?|@ 8}H@ 1-@ 0U2a|@ /{J#:@ .H@ .zG@ -B@ ,zxl"@ +a@@ *͞&@ )y@ '/V@ #n.3@ "`A@ "wkQ@ !o@  [6@ u@ Q@ @ PH@ Xe,@ Ov_@ *0@ n@ Vu@ 
qu"@ 
qu"@ @ L_@ 	ԕ*@ ݗ+@ _o@ oiDg@ @4n@  4m9?\N<?ڹZ?!.H?~$?Y|?-V?C\?4֡a?c	?(?C,z?,<?S?ᰉ'R?u!?sPH?Z?ѷX?N;5?Ϫ͞?͞%?)^	?a@N?\(??ߤ??A?~($?)?sg?[W>6?O
M?B?U=?L/{J?3?IQ?_F??Fs?S&?hr ?!R<?p:?$/?{m]?u!R?rGE85?qiB?o hۋ?l"h	ԕ?iB?h	ԕ+?ae?\(\?W>6z?Vt?T`d?S&?R<64?QR?Q_p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@Msh@@Mn/@@Mn/@@MH˒@@MH˒@@M\(@@ME@@N ѷY@@N
(@@N@@N@@NzG@@NzG@@N@@N.2@@N.2@@N.2@@N+jg@@N8YJ@@NL/{J@@NVu@@Nfffff@@NT@@N&I@@O)^@@ORT`e@@OlC@@Oo@@OkP@@P@@P*0@@PeO@@Pn@@P@@Q [7@@Q@@R	 @@RZc@@T%1@@Uo i@@Um\@@V8YJ@@WRT`e@@W	@@XH@@Y4J@@Z@@[:)z@@\g8}@@\1&@@\/@@][@@]<64@@]zxl"h@@],=@@^5?|@@_,@@`F@@`D@@`e+@@`tj@@`{@@`҈p@@aTɅo@@aae@@ahr @@al@@b:)y@@b~"@@b@@b@@cI^@@c"`B@@c"`B@@cdZ@@c{J#9@@cA@@c%2@@eM:@@e1@@en/@@e8Y@@eS@@g_o@@g@@h$xG@@heO@@i@@n_ح@@oXe@@p4m9@@qo@@q-@@t2W@@w|hs@@}%@@1&y@@>B@@m\@@o i@@0U2a|@@D@@g@@oiDg@@n@@rGE8@@^@@wk@@tSM@@j~@@e@@S@@u!S@@9@@ ѷY@@$t@@u!S@@.H@@0
@@n@@n@@C,@@tj@@āo h@@BZc @@H˒:@@h	ԕ@@͎!R@@ϝ-V@@Кu%F@@e+a@@lD@@&IR@@҅ݘ@@,<@@tj~@@ө*0U2@@2W@@}H@@ᰉ@@ hۋ@@$tT@@#9@@6@@(@@ހIQ@@A@@Ft@@@@)@@@@9Xb@@^@@C\@@PH@@
=p@@!-w2@@C,zx@@䲕@@!-w@@84֡@@F
L0@@zxl"h@@(@@$tS@@A7K@@Xy=@@U2a|@@˒:*@@@@ѷX@@rGE@@4J@@邩@@ᰉ'@@R@@Y}@@6C@@ᰊ@@<64@@ ѷ@@c	@@S&@@nP@@u%@@m@@C,z@@qu!@@@@@@tj~@@C%@@xF]@@땁$@@Q@@@@ߤ@@E@@E@@E@@믷@@ݗ+k@@|@@a@O@@a@@@Ƨ@@a@@@m]@@E@@n.@@lC@@C]@@C]@@A [@@s@@J@@1&y@@J@@@@!-w2@@/{J#@@%1@@"h	ԕ@@\N@@/{J#@@tj@@Q@@!-w2@@L_@@@@%1@@Fs@@SMj@@?@@C,zx@@Fs@@cA \@@웥S@@!-w@@[@@Q@@!.H@@*0@@K]@@*0@@84֡@@(@@(@@!.H@@K]@@!.H@@%F
L@@Q@@[@@V@@!.H@@!.H@@V@@o i@@*0@@qu"@@V@@2a|@@84֡@@2a|@@5Xy>@@2a|@@84֡@@84֡@@F
L0@@Vl!@@IQ@@<64@@jOv@@p
=@@w1@@M:@@픯O
@@픯O
@@+j@@=K@@@@8Y@@(@@!.@@oiDg@@ᰉ@@E@@S@@(@@1.@@;5X@@?@@E@@H@@L/{J@@L/{J@@af@@&I@@ȴ9X@@ȴ9X@@ȴ9X@@t@@m\@@]cf@@쿱[W@@Mj@@ hۋ@@
=p@@Xe@@Xe@@!-w1@@)^@@1@@$tS@@iDg8@@@@?@@/V@@vȴ9@@K]d@@حV@@حV@@;dZ@@4m9@@*0@@*0@@_F@@|@@u%F@@TɅ@@ۋq
@@@@҈p@@{@@@N@@^@@hr @@x@@rGE8@@'RTa@@N;6@@ԕ*@@@@.H@@I^5@@@4n@@kP|@@qiC@@L_@@n@@C,z@@33333@@=K^@@=K^@@J#9@@]cA@@g	l@@xF]@@A@@q@@Z@@@@҈@@J@@9XbN@@`d@@N;@@j~@@@@Z@@:@@u@@(@@IQ@@@@@@b@@!.@@ ѷY@@_o @@
(@@
(@@.2@@Vu@@IQ@@2X@@ hۋ@@4֡a@@As@@|hs@@@@;dZ@@     @@*0U@@}H@@@@6@@}H@@'RT`@@1&x@@H@@K]c@@Xy=@@n@@y=c@@@@ѷX@@7KƧ@@'R@@_o@@e@@n@@1'@@T`d@@ݘ@@S&@@S&@@ڹY@@~@@'/@@/V@@F]c@@a@N@@q@@*0U2@@Z@@a@O@@a@@@C]@@"h	ԕ@@m8@@qj@@#x@@@@/w@@O
@@!R<@@R<6@@T@@m\@@A@@1@@@@)^@@As@@3@@;dZ@@@@䎊r@A 
qu@A *0U@A 6@A 1&x@A |@A tj@A @A 9Xb@A ěT@A p:@A e+@A@N@AGz@ArGE8@An.@A@A2W@Ae@A@A0U2a|@AZc@AG{@APH@A6z@A=K^@AJ#9@AW>6z@AeO@A*0U2@AE@A
=p@A@As@A@Atj@A"h	ԕ@A(\@Aj~#@AN;@A3@AO
M@A#x@A?@A/@A!.H@AVl!@Ace@A}H@A$/@AڹZ@AO
@A%@A,=@A_o @A8YJ@AE@A@Aߤ?@A҈p;@A1@AO
M@AO;d@A@@AH@Al"h	@A'RT@A'RT@Atj@A{@A)@AD@A	A [@A	n.@A	@A	y@A	ԕ*@A	e@A	s@A
I^5@A
~"@A
fB@A,zxl@A]cA@Awk@A@A1&y@A2W@A/{J#@AFs@AZ1@Ao h@A@Ahr@A
qu"@A
IQ@A
m\@A
U=@A
S@A_o @A$/@A8YJ@AE@AL/{J@AOv_خ@A_ح@A%@A@A$t@A2X@A]cf@A hۋ@AFs@AMj@A8}H@AH˒:@AXe,@Aeں@Ao@AsPH@A&@Aݗ+@AzH@Ar@Ao @A@@A+j@AbM@A ě@A'RT`@A4m9@AeO@Atj@A-
@AIQ@A9Xb@A@A [7@A*0U2a@A7KƧ@AN;5@AQ@AXbM@ArGE8@Ay@As@AI^5@A#9@A-V@A0U2a|@A=p
@AM@A^5?|@A~"@AwkQ@A@Ag	@A}Vm@AW@Am@AI^@A/V@AJ#9@Aa@N@A{J#9@AQ@AMj@A$@AU=@A@AQ@AC]@A@AxF@A!-w2@AFs@Aj~#@Aqj@Aqj@A쿱[@A1&@A#x@AɅoi@Ahr@Ao i@Aqu"@A+a@A!.H@A/w@A5Xy>@A5Xy>@A?|h@AL_@Aw1@A@A@AoiDg@ABZc @A}Vl@Aȴ9X@Aȴ9X@Aߤ?@A쿱[W@AFs@A
=p@AH˒:@Ab}V@AsPH@A	@A-V@A?@A3@Ao @A     @AH@Ahۋq@AoiDg8@Ar Ĝ@Ay=c@AYJ@A-
@A@A
=q@A{@AěT@A@A	k~@A:S@ATɅo@ArGE8@A@Ao@A@An.@A_o@As@A-@An@AI^5@A1'@A0U2a|@A6C@A)y@A3@A#9@A:)y@AM@Au%F
@A@4@AwkQ@An@A`A@A,<@Ac	@AS&@Au%@As@A	@A	@AF]c@AxF]@Aߤ@A|@A҈@AJ@A@Atj@A"h	ԕ@A2W@AzG@ATɆ@A7@AZ@A!-w@A*0@A+a@AB@AVl!@A\@Ap
=@A!R@AXy=@AXy=@A-V@Ash@A@AC\@At@A@A($x@A5?|@AE@Al!-@A+J@A$t@A6z@A@A&I@AC-@AMj@A@AFt@A,@A.H@A4֡a@A>6z@AH˒:@AXe,@A4m@A	@A-V@A@A      @A 6@A  ě@A $xG@A -
q@A A7K@A [6@A y=c@A @A -
@A tj@A 
=q@A 4m@A ěT@A ěT@A `A7@A PH@A!$/@A! ѷ@A!rGE@A!#w@A!=b@A!rGE8@A!b}@A!n.@A!B@A!X@A!^5?}@A!2W@A!_o@A!ᰉ'@A!.H@A"&IR@A"C\@A"h	ԕ@A"^5?|@A"L/{@A"@A"<64@A"@A"sP@A"m\@A#I^@A"~@A#S&@A#u%@A#҉@A#s@A#C,z@A#	@A#,zxl@A#)^	@A#S@A#n.3@A#xF]@A#q@A#q@A#6@A#6@A#5Xy@A#Q@A#A [@A$J@A$!-w2@A$(\@A$64@A$m8@A$wkP@A$?@A$*1@A$3@A$j~@A$?@A$@A$@A%/w@A%5Xy>@A%84֡@A%B@A%S&@A%fA@A%m\@A%m\@A%p
=@A%M:@A%!R@A%8Y@A%Ϫ͞@A%b@A%oiDg@A%ڹ@A&t@A&u@A&!R<@A&E@A&;5X@A&H@A&\N<@A&fffff@A&l!-@A&z@A&qi@A&T@A&'@A&m\@A&m\@A&A@A&쿱[W@A')^@A'$tS@A'+I@A';dZ@A'As@A'KƧ@A'RT`e@A'Xe,@A'sPH@A'$tS@A'&@A'&@A'͞@A'/V@A'+@A'@A'حV@A'@@A'+j@A(@A(@A(4m9@A(>BZc@A(H@A(NU@A(bM@A(tj@A(d8@A(TɅ@A(C@A(	k@A(	k@A)$/@A)rGE@A)#w@A)=b@A)Gz@A)Q@A)k~(@A)hr @A)rGE8@A)u!S@A)x@A)b}@A)R<6@A)D@A)N;6@A)iB@A*u%F@A*Ov`@A*e+@A*䎊@A*&IR@A*&IR@A*0U2a|@A*GE85@A*Q_@A*xl"h
@A*\(@A*S&@A*wkQ@A*>B@A*Y@A*n@A*͞&@A*G{@A*C,@A*D@A*m\@A+nP@A+s@A+=K^@A+g	l@A+Q@A+Mj@A+U=@A+m]@A+6@A+@A+a@@A+a@@A+
=p@A+@A,(\@A,,<@A,9XbN@A,PH@A,Z1@A,`d@A,tSM@A,~($x@A,?@A,N;@A,Ʌoi@A,@A,֡a@A,JM@A-:@A-'0@A-*0@A-*0@A-qu"@A-Q@A-(@A-5Xy>@A-B@A-F
L0@A-84֡@A-IQ@A-Vl!@A-M:@A-O
@A-hr!@A-U=@A-cA @A-?@A-
qv@A-?@A-?@A-?@A-,=@A-C\@A._o @A.!R<@A.E@A.R<6@A.}Vl@A.qi@A.af@A.'@A.Q@A.ߤ?@A.ߤ?@A.҈p;@A.C-@A.@A.@A."@A.!.I@A/
M;@A/,@A/$tS@A/.H@A/.H@A/>6z@A/KƧ@A/RT`e@A/Xe,@A/b}V@A/v_ح@A/|hs@A/4m@A/	@A/@A/$tS@A/?@A/zH@A/[W>@A/[W>@A/r@A/fA@A/fA@A/@@A/@A/rGE9@A/rGE9@A/#@A0	ԕ+@A01&x@A0A7K@A0Q@A0[6@A0l"h	@A0|@A0-
@A0@@A0@@A0@@A0ۋq
@A0\)@A0	k@A0PH@A1@A1+@A1&x@A1&x@A14J@A1:S@A1:S@A1Gz@A1hr @A1b}@A1u@A1X@A1|@A1|@A1X@A1@A12W@A1o@A1@A1"`@A1iB@A1e@A1R@A1R@A1@A1.H@A2	 @A2I^5@A2Ov`@A2s@A2䎊@A2Ov`@A20U2a|@A2:)y@A2M@A2T`d@A2kP|@A2kP|@A2kP|@A2qiC@A2u%F
@A2u%F
@A2u%F
@A2xl"h
@A2xl"h
@A2{m@A2S&@A2wkQ@A2>B@A2Y@A2Y@A2)_@A2)_@A2G{@A2D@A3u%@A3'/@A3C,z@A39@A3P{@A3jf@A3jf@A3n.3@A3tj~@A3n.3@A3qu!@A3wk@A3@A35Xy@A3
=p@A3҈@A3ݗ+k@A3lC@A3g@A3C]@A41&y@A4!-w2@A4Q@A4!-w2@A4(\@A4<쿱@A4?@A4SMj@A4j~#@A4`d@A4cA \@A4m8@A4q@A4wkP@A4?@A4C@A4_@A4zxl"@A41&@A4O
M@A4#x@A4?@A4@A4>B[@A4u"@A4e@A4E@A5o i@A5o i@A5'0@A5u@A5u@A5Q@A5Q@A5+a@A55Xy>@A5IQ@A5IQ@A5S&@A5`A7L@A5m\@A5$/@A5!R@A5@A5U=@A5Xy=@A5U=@A51@A5-V@A5n/@A58Y@A5@A5Ϫ͞@A5b@A5oiDg@A5!.@A5C\@A5C\@A6 ѷY@A6
(@A6zG@A6u@A6($x@A68YJ@A6H@A6Ov_خ@A6Ov_خ@A6Ov_خ@A6\N<@A6vȴ9X@A6+J@A6$t@A6,<@A6-@A6}Vl@A62X@A6'@A6@A6&I@A6C-@A6쿱[W@A6"@A7
M;@A7v@A7+I@A71@A7H˒:@A7O
M@A7KƧ@A7Xe,@A7\(@A7lC@A74m@A7ݗ+@A7O;d@A7@A7kP@A7͞@A7-V@A7͞@A7vȴ9@A7K]d@A7+@A7fA@A7حV@A7@A7Vϫ@A7rG@A7䎊r@A8@A8@A8}H@A8*0@A81&x@A8:~ @A8D*@A8K]c@A8D*@A8K]c@A8NU@A8[6@A8Xy=@A8bM@A8l"h	@A8oiDg8@A8˒:*@A8@A8-
@A8@A8tj@A8@A8IQ@A8-
@A8{@A84m@A8TɅ@A8ѷX@A8F@A8ۋq
@A8@A8@A8C@A84֡b@A8	k@A9$/@A9_p@A9@A9_p@A9 [7@A9-w1@A9:S@A9=b@A9JE@A9TɅo@A9[W>6@A9ae@A9e+a@A9k~(@A9k~(@A9u!S@A9x@A9oiD@A9R<6@A9X@A92W@A9y@A9y@A9_o@A9_o@A9ԕ*@A9iB@A9R@A9lD@A9lD@A:@A:@A:)y@A:6C@A:M@A:a|Q@A:a|Q@A:kP|@A:@4@A:L_@A:0
@A:0
@A:S&@A:>B@A:@A: ě@A:sP@A:sP@A:ڹY@A:G{@A:fB@A:m@A:m\@A;I^@A;S&@A;҉@A;	@A;,zxl@A;,zxl@A;6z@A;9@A;C%@A;J#9@A;g	l@A;{J#9@A;@A;q@A;Q@A;q@A;$@A;U=@A;U=@A;S@A;q@A;q@A;Z@A;a@@A;a@@A;
=p@A;Q@A;ݗ+k@A;҈@A;\N@A<J@A<xF@A<tj@A<Q@A<2W@A<64@A</{J#@A<9XbN@A<<쿱@A<C,zx@A<PH@A<VϪ@A<VϪ@A<SMj@A<]ce@A<g8}@A<m8@A<wkP@A<~($x@A<o h@A<#@A<zxl"@A<?@A<?@A<?@A<@A<@A<Z@A<hr@A<D@A<E@A=o i@A=:@A=o i@A<>@A=*0@A=qu"@A=!.H@A=2a|@A=<64@A=B@A=F
L0@A=IQ@A=IQ@A=IQ@A=O;dZ@A=ce@A=`A7L@A=fA@A=sg@A=}H@A=M:@A=ݗ@A=!R@A=v@A=U=@A=1@A=1@A=-V@A=@A=n/@A=\(@A=@A=S@A=(@A=(@A=oiDg@A=!.@A=ڹ@A> ѷY@A>
L/@A>$/@A>Ov_@A>.2@A>.2@A>5?|@A>BZc @A>H@A>L/{J@A>YJ@A>s@A>qi@A>,<@A>Fs@A>,<@A>T@A>}Vl@A>}Vl@A>}Vl@A>2X@A>Q@A>m\@A>ߤ?@A>쿱[W@A>Mj@A>!.I@A? hۋ@A?
=p@A?@A?Xe@A?Xe@A?+I@A?>6z@A?As@A?As@A?E84@A?H˒:@A?KƧ@A?O
M@A?U=@A?b}V@A?iDg8@A?v_ح@A?O;d@A?&@A?@A?$tS@A?kP@A??@A?zH@A?3@A?/V@A?/V@A?@A?+@A?;dZ@A?@A?-@A?+j@A?rGE9@A@F]d@A@bM@A@6@A@6@A@6@A@1&x@A@1&x@A@73@A@:~ @A@K]c@A@[6@A@Xy=@A@[6@A@[6@A@l"h	@A@l"h	@A@y=c@A@-
@A@
=q@A@
=q@A@U@A@4m@A@
(@A@ěT@A@F@A@ۋq
@A@e+@A@\)@A@PH@A@$tT@A@PH@A@$tT@AA ѷ@AA$/@AA@N@AA_p@AA*0U2a@AA4J@AA4J@AA7KƧ@AAA [@AA=b@AAGz@AAJE@AA[W>6@AAe+a@AAo hی@AAx@AAb}@AAoiD@AA@AAn.@AAX@AAD@AA2W@AAo@AAN;6@AA>BZ@AA@AAY}@ABI^5@ABe+@AB1'@AB1'@AB)y@AB6C@ABZc@ABa|Q@ABa|Q@ABqiC@ABu%F
@AB{m@ABS&@ABᰊ@ABᰊ@AB0
@ABvȴ@ABL/{@AB ě@AB ě@ABg	@AB͞&@ABc	@ABD@AB~@ACS&@ACs@AC&@AC)^	@AC&@AC)^	@AC,zxl@AC)^	@AC,zxl@AC6z@ACC%@ACF]c@ACZ@ACa@N@ACa@N@ACa@N@ACg	l@ACtj~@ACxF]@ACxF]@AC@AC:)z      @ACMj@ACU=@AC*0U2@ACU=@AC@ACm]@ACE@AC6@ACƧ@ACa@@AC%2@ACC]@AC$@ADJ@ADߤ@@ADtj@ADtj@AD!-w2@AD%1@AD2W@AD64@ADC,zx@ADI^5?@ADSMj@ADg8}@ADzG@AD?@AD?@ADqj@ADO
M@AD?@AD[W?@ADɅoi@AD@AD>B[@ADJM@AD!-w@ADD@AE:@AEu@AE*0@AE*0@AE5Xy>@AE84֡@AE?|h@AE?|h@AE`A7L@AE`A7L@AE\@AEfA@AEjOv@AEm\@AEsg@AEw1@AEݗ@AE+j@AE=K@AEXy=@AE1@AE1@AE1@AE1@AEsh@AE@AEH˒@AE\(@AEcA @AE?@AE(@AEᰉ@AE(@AE(@AEᰉ@AE!.@AE!.@AEC\@AE!.@AF ѷY@AF_o @AF4K@AF@AFOv_@AFu@AF!R<@AF1.@AF!R<@AF($x@AF1.@AF;5X@AFE@AFE@AFL/{J@AFL/{J@AFOv_خ@AFOv_خ@AFVu@AFfffff@AFp:~@AFvȴ9X@AF%@AF$t@AF$t@AF$t@AF$t@AFO;@AFT@AF}Vl@AF6z@AF}Vl@AF}Vl@AF2X@AF'@AF'@AF@AF@AFȴ9X@AF+@AFߤ?@AF1@AF@AFFs@AF!.I@AGFt@AG
M;@AG@AGv@AG!-w1@AG.H@AG'/W@AG.H@AG4֡a@AG4֡a@AG>6z@AG>6z@AGE84@AGH˒:@AGU=@AGXe,@AGE84@AGRT`e@AG_o@AGiDg8@AGo@AGsPH@AG|hs@AG{J#:@AGO;d@AG@AGkP@AG-V@AG-V@AG&@AG?@AG&@AG3@AGvȴ9@AG@AG@AGحV@AG䎊r@AG-@AG䎊r@AG+j@AG#@AH     @AH     @AH	ԕ+@AH*0U@AH@AH6@AH}H@AH:~ @AH:~ @AHK]c@AHH@AHH@AHK]c@AHXy=@AHNU@AH[6@AHhۋq@AHr Ĝ@AHy=c@AH˒:*@AHn@AHYJ@AHIQ@AHu%F@AHtj@AH-
@AHtj@AHIQ@AH-
@AH@AH{@AH4m@AH4m@AH4m@AH
(@AHěT@AHD@AHD@AH`A7@AH`A7@AHC@AH	k@AH	k@AHPH@AHPH@AI	k~@AI	k~@AI ѷ@AI@AIrGE@AI@N@AI*0U2a@AI7KƧ@AI=b@AIGz@AIGz@AIN;5@AITɅo@AITɅo@AI[W>6@AIae@AIe+a@AI^@AIk~(@AIx@AI@AI7Kƨ@AI7Kƨ@AI~($@AIo@AI@AIu@AIn.@AI(@AIB@AIX@AIX@AI^5?}@AIX@AID@AIo@AIԕ*@AI_o@AI_o@AIԕ*@AIN;6@AI"`@AIiB@AIe@AI>BZ@AIR@AIlD@AJn@AJ	 @AJ	 @AJI^5@AJ@AJOv`@AJ䎊@AJ䎊@AJ1'@AJ#9@AJ-V@AJ3@AJ0U2a|@AJ3@AJ=p
@AJ@4n@AJGE85@AJGE85@AJM@AJM@AJZc@AJd7@AJh	ԕ@AJnO@AJnO@AJxl"h
@AJqiC@AJ~"@AJL_@AJ\(@AJᰊ@AJvȴ@AJS&@AJwkQ@AJL/{@AJ@AJ ě@AJg	@AJY@AJn@AJW@AJW@AJ͞&@AJ͞&@AJ͞&@AJ͞&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @r~fffff@rx     @r@r@r     @r@rfffff@r     @r@r33333@r33333@r33333@r33333@r@r33333@r33333@r33333@rfffff@rfffff@rfffff@r     @r33333@r33333@r@r@r@r     @r33333@r@rfffff@r@r33333@r33333@r@r@rfffff@rfffff@rfffff@ri@ri@rl@rp     @rs33333@rx     @r     @r~fffff@ry@rs33333@rl@ri@rq@rt@rq@rk33333@rk33333@rnfffff@rffffff@rS33333@rL@rI@rC33333@rA@rI@rNfffff@rS33333@rY@r`     @ri@rl@rl@ri@r`     @r\@r\@rX     @rX     @r[33333@rc33333@rS33333@rQ@rS33333@rQ@rP     @rK33333@rI@rFfffff@rA@r&fffff@q@q     @qfffff@q@qfffff@qS33333@pᙙ@pD@oc33333@n0     @l33333@kfffff@jfffff@i33333@ifffff@ii@i,@i@ic33333@is33333@hfffff@h33333@h33333@hvfffff@h333333@g@g     @f@e33333@e@efffff@eə@e@efffff@efffff@e@eə@e     @e`     @e6fffff@d@d@d@d33333@dffffff@dY@dS33333@dVfffff@d\@dc33333@dP     @d,@c@c33333@c#33333@by@a@afffff@a     @aə@a陙@bfffff@b`     @b@b@bfffff@b33333@b@cfffff@c33333@c      @c     @c      @c#33333@c#33333@cP     @cٙ@d`     @dl@dFfffff@d0     @d333333@dVfffff@dy@d@dfffff@dfffff@e     @e@e#33333@d@d@d     @dfffff@d@d@d33333@di@d\@dL@d33333@c     @c@c33333@c     @cs33333@cl@cffffff@cffffff@cY@c@     @c9@c333333@c)@b     @b@bfffff@b@bs33333@bVfffff@b9@b,@b@b     @b33333@bfffff@bfffff@b     @b      @a@a33333@aٙ@afffff@a@a@a     @afffff@al@a`     @aVfffff@aL@aL@a<@a0     @a)@a)@a      @a@a@a@a&fffff@a#33333@a@a@a     @a      @`33333@`33333@`fffff@`@`@`     @`|@`Vfffff@`L@`C33333@`333333@`      @`@`33333@`      @_ٙ@_@_33333@_fffff@_@_y@_l@_S33333@_L@_L@_L@_Ffffff@_9@_,@^@^33333@^ffffff@^fffff@]     @]     @]Y@]Y@]S33333@]ffffff@]      @\33333@\@\     @\ffffff@\@     @\@[     @[33333@[     @[l@[S33333@[@     @[333333@[@Z     @Z     @Zffffff@ZL@Z,@Z333333@Z33333@Zfffff@Y@Y     @Yٙ@Y33333@Y     @Y33333@Yfffff@Y33333@Yfffff@YL@Y,@Y      @X     @X@Xffffff@XFfffff@X,@X33333@X@W@W     @W`     @WFfffff@W&fffff@W      @V@V     @V@Vfffff@Vffffff@Vffffff@Vs33333@V@     @V33333@Vfffff@Ufffff@U33333@U@Ufffff@U@U33333@UY@U@T@Tfffff@T     @T@     @T,@T&fffff@T      @T33333@T      @T@S33333@Sٙ@S@S33333@S     @S     @Sffffff@SL@S      @Rٙ@R     @R33333@R     @R     @Rfffff@Rfffff@Rffffff@R9@Rfffff@Q33333@Q@Q@Q     @Qfffff@Qfffff@Q     @Q@Q@Qffffff@Q9@Q@     @Q&fffff@Q      @P@P33333@P     @P     @P33333@P33333@P33333@P33333@P33333@Pfffff@P@P@P33333@P     @P@P     @PY@P&fffff@Pfffff@O     @Offfff@O@Offffff@Offfff@Offffff@O&fffff@N@N@N     @NY@N@     @NL@N&fffff@M33333@M33333@M33333@N      @Mfffff@M@M@MY@M&fffff@M@M      @L@L&fffff@K     @K@Kffffff@K@     @Ks33333@K&fffff@K      @J33333@J@Js33333@J333333@J@     @JY@JL@J333333@J@     @J333333@J333333@J@Ifffff@I     @Ifffff@Ifffff@I@Iffffff@IL@I333333@I@IL@Hfffff@Hٙ@H33333@H     @H&fffff@Gٙ@Gfffff@G@Gs33333@G@Gs33333@Gffffff@GL@GL@G333333@G&fffff@G      @F33333@F33333@G@F33333@F     @F     @F@Fs33333@Fffffff@FY@F333333@F      @E33333@Eٙ@E     @Eٙ@Efffff@Eٙ@E     @E@Es33333@E@     @E&fffff@E      @Dfffff@D33333@D@DY@D333333@D      @C@Cfffff@C     @C     @Cs33333@CY@Cs33333@CL@B33333@Bfffff@B     @BY@BL@BY@BL@B@Afffff@A@Affffff@A&fffff@A      @@ٙ@@     @@     @@fffff@@@@fffff@@@@s33333@@&fffff@@@?@?33333@?ffffff@?L@?@?      @>fffff@>33333@>@?333333@>fffff@>fffff@>@>@>33333@?      @>fffff@>@>@>     @>L@>     @>L@>     @>L@>ffffff@>     @>@>     @>ffffff@>@>     @>L@=fffff@>@>@=@=fffff@>      @=@=@=L@=ffffff@=ffffff@=L@=L@=L@=ffffff@=@<33333@<@<@<ffffff@<@<     @<     @<L@<L@<333333@;@<333333@<@;@;@;     @;33333@;@;ffffff@;L@;@;@;ffffff@;L@;333333@;@;      @:fffff@:@;@:fffff@:@:@:     @:@:     @:333333@:L@:ffffff@:     @:333333@:@:333333@:@:      @:      @9@9fffff@9fffff@9@9     @933333@9ffffff@833333@8@7fffff@733333@7@7@7@7@7ffffff@7333333@7L@7@7ffffff@6fffff@7333333@7ffffff@7333333@6@6L@6L@6ffffff@633333@6ffffff@6333333@6L@6333333@6333333@6      @6      @5fffff@5@5@5@5     @5ffffff@5@5ffffff@5L@5L@5L@5L@5L@5@5333333@5L@5L@5@5@5@5L@5333333@5@5L@5L@5L@5@4fffff@4fffff@433333@4fffff@4@4     @4     @4@4L@4L@4333333@4@3@4      @4      @3fffff@3@3     @3@3ffffff@3ffffff@3333333@3ffffff@3     @3333333@3@3@3L@3L@3333333@2fffff@2fffff@3      @2@2fffff@2fffff@3@2fffff@3@2fffff@2@2fffff@233333@233333@233333@2@2ffffff@2@2     @2ffffff@2L@2L@2@2     @2     @2L@2     @2L@2@2@2@2      @2333333@2@2ffffff@2333333@2      @2      @2      @2      @2      @2@2333333@2      @2      @1@1@1@1@1ffffff@1@1     @1@1     @1     @1     @1333333@1L@1     @1     @1ffffff@1L@1L@1L@1333333@1L@1@1@1333333@1L@1ffffff@1L@1L@1333333@1333333@1333333@1333333@1ffffff@1ffffff@1L@1333333@1L@1L@1ffffff@1333333@1L@1L@1333333@1ffffff@1L@0fffff@1ffffff@0fffff@0@0fffff@1      @0@0fffff@1      @033333@0@0@0@0fffff@0@0     @0     @033333@0@0ffffff@0     @0@0@0L@0@033333@0@0@0@0ffffff@0L@0ffffff@0ffffff@0     @0ffffff@033333@0@0333333@0     @0     @0L@0     @0     @0     @0L@0ffffff@0ffffff@0333333@0ffffff@0L@0      @0ffffff@0L@0L@0333333@0ffffff@0     @0L@0L@0L@0L@0333333@0333333@0333333@0      @/@/ffffff@/@0@0@0      @/@/@/333333@/@.@/      @/333333@/333333@.@-@.333333@.ffffff@.333333@.@.ffffff@.333333@.      @-@.333333@.      @-@-@-@-ffffff@-333333@-ffffff@-      @,@-333333@-333333@,@-333333@-      @-333333@-ffffff@-ffffff@-      @,@,@,@,@,@-333333@,@,@-@-333333@,@-333333@,@,333333@-      @,@,333333@,ffffff@,ffffff@,333333@,@+@+@+@+ffffff@+@+ffffff@+      @+      @+ffffff@+333333@+@+ffffff@+ffffff@+333333@+333333@+ffffff@+ffffff@+ffffff@+      @*@*@*@*333333@*@*@+      @*@*ffffff@*ffffff@*@*ffffff@*@*@*@*ffffff@*@*@*@*@+      @*@*@*ffffff@*@*@*333333@*@*ffffff@*333333@)333333@)@*      @)@*@*      @)@)@)@)@)@)@)@)ffffff@*      @)@)@*ffffff@)@)ffffff@*      @)@*      @*@)@)ffffff@)@)@*      @)@)@)@*      @*333333@)@)@)@*      @)@)ffffff@)@*      @*      @*      @)@)@*      @*333333@*333333@*      @*      @*333333@+333333@+      @*@)@*      @*ffffff@*ffffff@*@*333333@*      @*      @*      @*@*ffffff@+      @+      @*@*@*ffffff@+333333@+333333@+333333@+333333@+      @+      @+      @+@+@+@+      @+333333@+ffffff@+333333@,      @+@+ffffff@+@+      @+@*@+      @+333333@+      @+333333@+333333@+@,      @,      @,      @+333333@*@*@+333333@+@,333333@+@,      @+@+@+@,      @,333333@+ffffff@+@-      @,333333@,      @,@,333333@,@,@,@,@+@,@-333333@-333333@,@,333333@,ffffff@,ffffff@,@-333333@-333333@,ffffff@,ffffff@,@,@,@,@-@-      @,@-333333@-333333@,@,ffffff@-333333@,@,@,@-333333@,ffffff@,@-      @,@-333333@-333333@,@-333333@,      @-      @,@-      @,ffffff@,@,@-      @-333333@,@,333333@,ffffff@,@,@,ffffff@-333333@,@,333333@,@-      @,@,@,@,@,@,@,@-      @-333333@,@,ffffff@,@-      @,@,333333@,@,@,@,      @,@-333333@,@,      @,      @,ffffff@,@,@,@,333333@,@,333333@+@,ffffff@-ffffff@,333333@,ffffff@-      @-ffffff@,@,ffffff@,ffffff@,@,333333@,@-      @-333333@,@-      @-      @,@-      @-      @,@,@,@-333333@-      @,@,@-333333@-      @,@-      @-333333@-333333@-      @,ffffff@-ffffff@-333333@-      @-      @-      @-      @,@-ffffff@-@-333333@-ffffff@.      @.ffffff@.333333@-@-@.      @.      @.333333@/333333@.@.ffffff@.@.ffffff@.ffffff@.      @.      @.ffffff@.ffffff@.333333@.ffffff@.ffffff@.@.@-@.@/      @.ffffff@/      @/      @/333333@/ffffff@/      @.@/333333@/333333@.@.@/333333@.@.@.ffffff@/ffffff@/ffffff@/      @.@/333333@/@.ffffff@/333333@0@/@/333333@.@/      @/@.@/333333@/@0@/333333@/      @/@/@.@/ffffff@/ffffff@/@/@/@/@/@/@0      @/@0333333@0@0333333@0@0333333@0      @0@0333333@0333333@0333333@0333333@0     @0ffffff@0@0      @0ffffff@0     @0ffffff@0333333@0ffffff@0@0@0ffffff@0@0333333@0@0@0@0@0     @0@0@0fffff@0@0@0@0fffff@0fffff@0@1      @1ffffff@1     @1ffffff@1@1@1@1     @1@1     @1@1ffffff@1333333@1@1@1@1fffff@2      @1ffffff@133333@1fffff@1@1@1@1fffff@1fffff@2      @2333333@2@2L@2      @1@1fffff@1     @1fffff@2@2333333@2L@2ffffff@2L@2     @2ffffff@2ffffff@2@2@2     @2@2@2@3333333@233333@2@2fffff@2fffff@2fffff@3      @3      @3333333@2fffff@3333333@3333333@3ffffff@3     @3@4333333@3@3L@3ffffff@4      @4      @4      @3     @333333@4@4ffffff@4@3fffff@4L@4333333@4@4ffffff@4ffffff@433333@4@4@433333@4     @4ffffff@433333@4fffff@4@4@5@4@4@5ffffff@5@5333333@5L@5333333@5     @5L@5L@533333@5     @5ffffff@533333@5ffffff@533333@5fffff@5@5@6      @5@6333333@6@6      @7      @6     @6L@6333333@6ffffff@6@6@633333@6L@6fffff@6fffff@6fffff@7333333@7333333@7333333@7333333@7@7@7L@7333333@7L@7@7fffff@7fffff@7@7@733333@7ffffff@733333@733333@7fffff@8L@8@8@8@8ffffff@8     @8ffffff@8@8333333@8     @8@9@9@9@8fffff@9@9     @9L@8fffff@9      @9     @9fffff@:      @:@9fffff@9@9fffff@:     @:     @:ffffff@:@:     @:fffff@;     @;ffffff@;     @;333333@;333333@;L@;333333@;333333@;     @;     @;     @;ffffff@<@<ffffff@<33333@<@<L@<     @<33333@<@<@<33333@<@<@<@<fffff@=@=L@=ffffff@=ffffff@=     @=L@=L@=     @=      @=     @=fffff@>      @=fffff@>@>@>@>L@>L@>333333@>@>333333@>fffff@?@>fffff@?333333@?@>@?@?@?L@?ffffff@?     @?@?@?fffff@?fffff@?@@@     @@@@@@@@@     @@@@fffff@@@@@@ٙ@@ٙ@@     @@33333@A      @@fffff@A@A@A@A&fffff@A@     @Affffff@Affffff@A@     @AL@As33333@A@Afffff@A     @A     @Afffff@Afffff@A33333@A33333@Aٙ@B      @B      @Afffff@Aٙ@B      @B      @B@B@B@B333333@B&fffff@B@B333333@BY@BY@Bs33333@B     @BY@BL@B@B@Bffffff@Bffffff@B@B@B@B@B@Bfffff@Bfffff@B33333@Bfffff@B     @C      @C@B33333@C@C@CL@CY@C333333@C333333@CL@C333333@C&fffff@C333333@C@     @Cffffff@C@C@Cfffff@C     @C33333@C     @Cs33333@Cs33333@C33333@C33333@Cfffff@Cfffff@Cٙ@D      @C33333@D      @D&fffff@D333333@D333333@DY@D@     @D333333@D@     @DY@D@     @Ds33333@Dffffff@D@D     @Dffffff@D@D     @D@Dfffff@D33333@E@Dfffff@Dfffff@E@Dfffff@E@D33333@Dٙ@E@E&fffff@E@E333333@E@Dfffff@E@EL@Es33333@EY@E     @E@E@E     @E@E@E@E33333@Eٙ@Eٙ@E33333@E33333@Eٙ@E33333@F&fffff@F@     @F@E33333@F      @F@     @F@     @FL@Fffffff@Ffffff@F@F     @F@F@F@F@F33333@F@F@F33333@F33333@Ffffff@F33333@Fٙ@Fٙ@Fٙ@Fٙ@G      @G      @G@Gffffff@G@G333333@G@     @GY@Gs33333@GL@Gffffff@Gs33333@G     @G     @G33333@G33333@G     @G     @H@Gfffff@Gٙ@H      @H@H@     @G33333@H      @H&fffff@HL@H&fffff@H&fffff@H@     @H&fffff@H333333@H@     @H@     @H     @H@H     @HY@H@H     @H     @Hfffff@H33333@I      @Hٙ@H33333@H@H33333@Hfffff@Hٙ@H@Hfffff@I&fffff@I&fffff@I@I&fffff@I&fffff@I@     @I333333@Is33333@Iffffff@IY@IL@IY@I@Is33333@Is33333@Ifffff@IL@IY@I@I33333@I33333@Ifffff@Iٙ@I33333@Ifffff@Ifffff@Iٙ@Iٙ@Iٙ@Iٙ@J      @Jffffff@J     @Jffffff@J&fffff@JY@JY@J@     @JY@Jfffff@J@J@J@J@J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?+?9XbN?5?|h?E?tj?zG?m?-V?A7Kƨ?dZ1?n?zG?I^5?}?Q? ěT?lC?1&x?"`B?r ě?-V?bM?"`B?
=p?+?A7Kƨ?O;dZ?O;dZ?\(?1&?A7Kƨ?+?\(?&x?zG?l?nO;?E?ffffff?j~"?C%?Z1'? ěT?9XbM?"`B?9XbN?lC?\(?5?|h?Q?\(?7KƧ?"`B?5?|h?zG?n?o?zG?XbM?-V?r ě?      ?o?陙?/w?$/? ě?$/?ȴ9Xb?lC?bM?333333?Ƨ-? ě?nO;?-V?E?x?"`?hr Ĝ?\(?9XbM?9XbM?A7Kƨ?Vu?⟾vȴ9?5?|h?ᙙ?XbM?+J?`A7L?x?hr!?ܼj~#?Z1'?٩lD?׾vȴ9X?/v?=p
=?д9XbN?̬1&y?xF?1&x?+I^?E?Õ$/?M?nO;?° ě?vȴ9X?Q?vȴ9X? ěT?E?lC?vȴ9?+??|hs?zG{?j~#??|hs?zG{?E?tj~? ě?E?333333?E?l?-V?-V?hr Ĝ?nO;? ě?nO;?hr Ĝ?lD?lD?-V?-V?-V? ě?hr Ĝ?`A7L?lD? ě?333333?nO;? ěT?vȴ9X?bM? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?
=p?Q?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?Q?5?|h?Q?Q?5?|h?-V?5?|h?5?|h?Q? ěT?Q?;dZ?;dZ?Q?5?|h?-V?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT? ěT? ěT? ěT?Q?;dZ?vȴ9X?;dZ?Q?vȴ9X?;dZ?Q?Q?vȴ9X?vȴ9X?Q?;dZ? ěT?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X? ěT? ěT?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT? ěT?
=p? ěT?bM?vȴ9X?;dZ? ěT? ěT?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?bM?vȴ9X?
=p? ěT?`A7L? ěT? ěT?bM?bM?bM?bM?vȴ9X? ěT?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?vȴ9X? ěT?vȴ9X? ěT? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ? ěT? ěT?vȴ9X?vȴ9X?;dZ? ěT?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?bM?vȴ9X?bM?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?5?|h?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?Q?;dZ?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?5?|h?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?5?|h?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?bM? ěT?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?&x?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?Q?Q?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ? ěT?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?
=p?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?vȴ9X?Q?Q?Q?vȴ9X?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?5?|h?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?vȴ9X?Q?;dZ?5?|h?;dZ?Q?Q?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?Q?;dZ?5?|h?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X?vȴ9X?bM?bM?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?5?|h?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?5?|h?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?5?|h?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?5?|h?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?Q?5?|h?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?vȴ9X?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?Q?5?|h?Q?;dZ?Q?5?|h?Q?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?5?|h?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?vȴ9X?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?5?|h?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?5?|h?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?5?|h?Q?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?5?|h?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?Q?5?|h?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?;dZ?5?|h?Q?;dZ?Q?5?|h?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?Q?Q?-V?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?;dZ?Q?5?|h?5?|h?;dZ?;dZ?Q?Q?;dZ?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?;dZ?;dZ?5?|h?5?|h?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?5?|h?-V?Q?Q?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?Q?Q?5?|h?-V?Q?-V?-V?Q?Q?-V?-V?5?|h?5?|h?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?-V?-V?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?-V?Q?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?/v?5?|h?5?|h?Q?/v?5?|h?/v?-V?5?|h?5?|h?5?|h?-V?-V?5?|h?-V?5?|h?/v?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?/v?-V?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?-V?/v?/v?5?|h?-V?5?|h?-V?-V?/v?5?|h?-V?5?|h?5?|h?-V?5?|h?/v?5?|h?-V?-V?5?|h?-V?-V?-V?/v?-V?-V?5?|h?-V?5?|h?Q?5?|h?/v?-V?/v?-V?5?|h?5?|h?-V?/v?/v?5?|h?5?|h?-V?-V?/v?/v?/v?1&y?/v?1&y?-V?/v?/v?1&y?/v?/v?/v?/v?/v?/v?/v?-V?/v?/v?/v?/v?1&y?/v?-V?/v?1&y?5?|h?5?|h?/v?/v?1&y?1&y?1&y?1&y?/v?/v?/v?/v?/v?1&y?1&y?/v?1&y?(\)?1&y?1&y?1&y?-V?-V?/v?1&y?/v?/v?(\)?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?-V?/v?/v?-V?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?/v?/v?/v?1&y?/v?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?/v?/v?/v?/v?1&y?/v?/v?/v?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?-V?/v?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?-V?-V?1&y?/v?/v?/v?/v?1&y?1&y?/v?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?/v?/v?/v?/v?-V?/v?(\)?/v?1&y?1&y?/v?1&y?(\)?/v?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?(\)?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?(\)?1&y?1&y?(\)?1&y?1&y?S?(\)?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?(\)?1&y?1&y?1&y?1&y?(\)?1&y?(\)?(\)?1&y?1&y?1&y?1&y?(\)?(\)?(\)?(\)?/v?1&y?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?1&y?(\)?1&y?(\)?(\)?(\)?(\)?(\)?S?1&y?1&y?1&y?1&y?(\)?1&y?(\)?(\)?1&y?(\)?(\)?(\)?1&y?1&y?(\)?(\)?1&y?(\)?1&y?(\)?1&y?(\)?1&y?1&y?(\)?(\)?(\)?(\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ??                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P18                                     1                                       )BED3U