CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P4     CAST_NUMBER       5      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.666773Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @7         data_max      @7         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (x  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?   data_max      @T        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (x  [\   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
      temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @}Vl!   data_max      @#t   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (x     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
   l   salinity                	long_name         salinity   units         PSS-78     data_min      @@*#9   data_max      @A;m]   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (x     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
      oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @$333333   data_max      @q`        C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (x  $   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
     CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?1&y   data_max      ?;dZ   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      (x %   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
  N4   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      @b        C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       (x XT   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
     	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     (x    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
  d   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )ˢ   data_max      )ˢ   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HSC%   data_max      @HSC%   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _1;   data_max      _1;   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d        @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      @7      ??ffffff@ffffff@ffffff@      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @3fffff@5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @U33333@V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d33333@dfffff@d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g\@g     @g     @g     @g     @g@h&fffff@h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @rfffff@r33333@s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @tfffff@t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u@u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @vfffff@v33333@w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @xfffff@x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z@zfffff@z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}1@}8     @}Q@}`     @}p     @}     @}     @}     @}     @}     @}     @}fffff@}fffff@~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @fffff@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @33333@,     @0     @8     @@     @H     @P     @Vfffff@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @E@Q@X     @`     @h     @p     @x     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @33333@fffff@      @     @     @     @33333@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @@@     @     @     @      @(     @0     @8     @?33333@I@P     @X     @`     @h     @rfffff@x     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0@8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @      @@     @     @      @(     @0     @8     @@@H     @P     @X@a@h     @p     @x     @     @@fffff@     @33333@@     @     @     @     @     @@     @     @     @     @      @     @     @     @      @(     @-@8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @      @     @
@@      @(     @0     @8     @@     @H     @P     @U@a@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @-@9@@     @H     @P     @X     @`     @h     @p     @x     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @U@`     @h     @p     @x     @     @     @     @     @     @@@     @     @     @33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @33333@     @     @     @     @33333@     @     @     @@fffff@ᙙ@     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @733333@Bfffff@H     @P     @X     @`     @h     @p@x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @      @@fffff@     @     @     @     @      @#@)@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @ۙ@fffff@     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @733333@@     @D     @H     @L     @P     @T     @X     @\     @`     @c33333@h     @l     @p     @t     @x     @|     @33333@fffff@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0fffff@4fffff@8     @<     @@     @D     @G@L@Pfffff@T                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @"Ov`@"@"Vu@"~($x@"0
@"ۋq
@"s@"zvȴ@"rs@"l@"de@"_Ft@"Y+@"Rᰊ@"KQ@"C	@"A|Q@"@n@"@C@"B74@"BC,@"C{J#9@"Cwk@"C@"Dtj@"C
=p@"C\N@"D2W@"D2W@"DTɆ@"Do h@"BC,@"BI^5@"A-w1@"Ao@"CA [@"Kjf@"T#@"\n.@"]H˒@"Zxl"h
@"jL_@"u?|h@"y_o@"}IQ@"}K]@"{A@"s@"7Kƨ@"NU@"C@"5?|@"܄?@"C,@"\N<@"S@":)z@"-
q@"Q@"hۋq@"E@"ܞ쿱[@"ٳ|@"݊ڹZ@"*0@":)z@"vȴ9@#@#o@#4j~@#HXy=@#T#@#b74@#j=p
@#r-V@#t@#eQ@#^@#KQ@#A'R@#;=K^@#&x@"A@"T`d@"g8}@"㯷@#@#p
=@#6z@#~@#>6z@#@N@#	ԕ*@"u%F@"Q@"Vl!@"ٙ@"ٳ|@"(\@"H˒:@"_o@"@"/@"|Q@"ߗ$tS@"\N<@"ٙ@"Q_@"?|h@"$xG@"qiC@"qiC@"@"{S@"tJ@"r ě@"rnO@"r:)y@"o
M;@"jJL@"c@"`[6@"W>6z@"N_o @"LI^5?@"KC]@"KC%@"Hۋq
@"FYJ@">iB@"49XbN@"2 ě@"PH@"@!1&@!޸Q@!M@!	k@!;5X@!fA@!~u@!vOv_@!k)^	@!iB@!heO@!e+a@!YY}@!RT`d@!O;dZ@!B3@!Fx@!GfA@!B@!1o@!W>6z@!R<6@!g	l@!&x@!*0U@!'/W@!@4n@ Xe@ 쿱[W?@ I^@ @ `A7L@ ^5?|@ @ ըXy=@ ̿[W?@ S@ y=c@ C%@ x@ YJ@ IQ@ oiDg@ H˒:@ g	l@ xF]@ 	 @ *0U2a@ ˒:*@ ڹ@ }Vm@ C@ [W>@ H˒:@ }H˒@ x*0@ tZ@ o@ a:S@ ]}H@ [5Xy@ Y=b@ Nt@ D?@ 9|@ 5?|h@ 3g@ 3Z@ 2䎊@ /
M;@ +'/@ &@ I^@m]@䎊q@!-w@S@`A7L@1&y@R<6@usg@ql@Qhr @.zG@bM@RT`e@حU@)y@o4֡a@>ߤ?@Ov_خ@G#@^Ov_خ@p
=q@&I@Ϫ͟@PH@`A@GE85@3@g	l@a@@>B[@rGE8@>B@m8@A@sg@GE85@
(@v@<쿱@TɅ@S@ae@D*@@@}K]@n}Vl@Zvȴ@KƧ@F-@9~($@-
qv@!'R@]cf@r@e+a@Q@@;5X@i@`ěT@e+a@gRT`e@]-V@O\(@HK]c@En/@F
L/@C\N@CF]c@An.@9(@4D@3MjO@1u!S@'-@#n.3@!-w1@vȴ9@U=@?@$tT@$tS@@kP|@a@N@9XbN@C]@(@@4n@{lC@yD@w3@sg@o4֡a@mw1@lC@cwk@cS&@`u!@_?@]ce@W$tS@TzG@RsP@IoiD@?$tS@;/V@9rGE8@43@&A@cA @Q_@+@bM@	'RTa@S@{J#9@O
M@Xe,@˒:)z@@a|Q@C,@҈@t3@^ ѷY@\N;@X@@W+j@NVu@@NU@1@;5X@.H@tj@a@N@3@4֡a@e+@nO@J@Q@JE@u?|h@GK]d@(\)@~($x@唯O
@kP|@xYJ@iB@\wkP@<Q@@D@s@t@6@ԕ*@zxl"@@L_@v_ح@䎊r@!-w2@~($@$tS@Vu@C,zx@	ԕ+@[@x@:S@;dZ@"}Vm@/w@o@!'R@!@N@(\)@1&x@4SMj@84֡b@Ov_@$@@@JM@x)@XU@F-@.H@ ěT@(r Ĝ@*d7@6!.I@TO
M@VOv_@Zc	@be+@ae@g8}H@T`d@R䎊@QN;6@P|@P|@PH@NVu@DM:@ 
qu@*0U@eO@!.@fA@hۋq@33333@1@L/{J@1&@sPH@T`d@nO@m@%2@|Z@vC-@aae@=p
=@,>B[@8YJ@B ѷ@=p
=@@n@Iԕ*@O@GK]d@DS@N+@PbM@U=K@WO;d@T*1@R:)y@JD@:G{@ [6@kP@1&x@3@JL@T`d@     @yXbM@v_ح@nt@\wkP@P|@MjOv@F]cf@A [7@8l"h	@/O
M@%ڹ@?@
@:)z@	oiD@!R@7@C,@+@k~(@u!S@T`d@@@~m\@o4֡a@O@2ᰊ@iB@1&x@a@@>BZc@!-w1@-V@?@-w1@IQ@m\@*0@҈p@y=c@ߊ	@2a|@K]c@^@qu!S@_U=@UfA@Qhr @P$tT@P{@-B@lD@y@-V@IQ@*0U2a@O
M@O;@{J#:@A [@ȴ9X@rGE8@S&@?@m8@'RT@^@[W>6@:)y@c	@څݘ@TɆ@쿱[W@o @@ʌL_@ڹY@6z@h@ES&@:xl"h
@2{m@,VϪ@'8}H@䎊r@Ϫ͞@
(@@@8YK@n/@
#9@@O;d@zG@e+@+j@/w@$7@.1@12W@-w1@&A@$qj@$7@%zxl"h@$7@!.H@*0U@n.@C,z@]ce@S&@/V@Ňݗ@Ϫ͟@U2a|@4K@XbM@Q@64@
(@Vu@"`B@1'@p:~@6z@<쿱@҉@C@M@'/W@H˒:@O;dZ@Bu%F
@=v@6z@3g@3E@2GE85@3@2GE85@2-V@1u!S@2GE85@1[W>6@/{J#:@/@0
(@1&x@0{@0
=q@84֡b@A:S@E@U2a|@`	k@cS@cS&@b@4@cS&@ceO@^%@TE@K)^	@E84֡@D*0@Np:~@T*1@Y>BZ@^@`
qu@`҈p@_;dZ@^@^%@\1&@[q@W+j@Sa@O@RT`d@Rp:@Rm@SMj@R<64@Qu@L~($x@A7Kƨ@8F@2s@+Q@"`A@҈p;@,<@8YJ@@*0@ ѷ@F]d@@e+a@
L/@     @(@|@Vϫ@0U2a|@	@PH@Ϫ͟@2a|@Z@*0U2@u@`A7@Vu@]cA@@1&x@{J#9@{s@s33333@p'RT@mC\@cn.3@Y@TɅoi@TɅoi@MO;dZ@EQ@A:S@?@9=b@/-V@+I^@'/V@%O
@%ڹ@%`A7L@ -
@N;@]ce@C,zx@u"@>6z@@l"h	@|@C]@յsh@'/W@͸@ɅoiD@@䎊q@C@zxl"h@C,@Z1@tSM@.2@)@)_@@4n@j~#@1&y@ۋq
@TɅ@A@	ԕ+@S@1@tSM@-w1@ߤ@@
qu@M@?@Q@ ѷY@ ѷY@IQ@qu!@+@Ϫ͞@+@K]d@IQ@}b@{lC@z)_@yXbM@w4m@vE@tm8@o hۋ@hTɅ@b@4@WO;d@TFs@RT`d@P|@O͞@LcA \@G+I@Ca@N@@IQ@?$tS@;J#9@8F]d@4J@2GE85@0{@0 ě@/Vϫ@.}Vl@.zG@*fB@&fffff@$?@!.H@	@ce@N;@$@kP|@tj@sh@*0U2@nO@X@)^@\(@
5Xy>@p:@S&@tj@ 6@C@@7@ ѷY@+@@'0@m\@U=@n.3@䎊r@S@kP|@L_@L/{@}H˒@w+@p
=q@l[W?@jg	@ffffff@be+@aGz@_حV@^5?|@]ce@[W>6z@Yb}@XU@Z1'@Xe+@XU@Y>BZ@Z1'@YJE@W@OAs@Gy@D2W@BZc@A [7@>ߤ?@>6z@<n.@4֡a@/r@#
=p@u%@ᰉ@-
q@
	 @u%F@$/@n/@xl"h
@F@73@Fs@@fA@ӎMj@]cf@n@v@<64@Xy=@?@@}H˒@tSMj@sPH@rs@l[W?@fA@b}Vm@_Ft@]ce@[W>6z@Y|@XD*@S&@DS@<j~#@;/V@7Xe@.1@,<쿱@!ae@Z@eO@%2@	 ѷ@
=p
@
ڹY@	ԕ*@eO@@?@%2@I^5@      @
H˒@
rGE8@
E@
1.@
Ft@
$@
+@
+@
y=c@
@
Ϫ͟@
&@
Ϫ͞@
cA \@
*0@
Q@
{@
[6@
@
@N@
u@
@
'/@
1&x@
qiB@
eO
@
]+j@
S@
TɅoi@
TE@
M5Xy>@
D*0@
D*0@
Eo i@
D*0@
D2W@
B@
8)@
-U=@
"h	ԕ@
?@kP@%F
L@#@PH@@쿱[W?@Ov`@8}H@@4@ce@JE@fA@ӎMj@䎊@N;5@p:~@˒:)z@n@n@m\@C@v@XbM@rG@Xe@KƧ@Xy=@-V@O
M@jf@0U2a|@@@@*0U2a@@&@&@/V@$xG@@@@*0U2a@0U2a|@0
@<쿱@U=@<쿱@V@>B[@V@zxl"@>B[@Xy=@-w1@IQ@wkP@e+a@$tT@u%F@$/@y"`@sE@p@mC\@jOv`@UϪ͞@A7Kƨ@<n.@9D@7rG@7KƧ@4m8@2a|Q@%S@+J@S&@@b}V@!.H@PH@J#9@F@#@P{@Z@e@حV@ۋq@`d@@,<@a@O@&@҈p:@@˒:)z@Ƨ-@4K@*0U2a@2X@r@U=@Vϫ@O;d@S&@o hی@~m\@|Q@zG{@{J#9@wkP@iᰉ'@Vt@T*1@P{@N;5X@K]cA@Jn@I@H9Xb@H@HK]c@H˒:*@H9Xb@H@Gy@Fs@F
L/@ATɅo@=<64@9~($@1o@/{J#:@&x@!-w1@$tS@@u%F
@
Fs@
4֡a@
ۋq
@
ߤ?@
՛=K@
а{@
;5X@
˒:*@
@
@
@
BZc @
K]@
n.@
A@
~@
/V@
^5?|@
D@
)@
3@
Q@
?@
?|h@
m8@
9XbN@
[W>6@
r@
{J#:@
}Vl@
>B[@
d7@
^@
,@
n.3@
vȴ9@
=K^@
L_@
'/@
y=b@
iDg8~@
dqj@
d%1@
_حV@
[q@
[$@
YJE@
U=K@
T,<@
Q_p@
N+@
Em\@
:^5?|@
5?|h@
2-V@
2-V@
2-V@
 ěT@
N;6@

(@
	 ѷ@
 hۋq@	oiDg8@	7@	@4@	@4@	Ʌoi@	ȴ9Xb@	?@	]cf@	@	6z@	b@	dZ@	33333@	=K^@	-
q@	%2@	u%F
@	ѷX@	}ڹZ@	z@	vȴ9X@	u\(@	s@	qiB@	m8Y@	de@	Vl!-@	N_o @	F-@	Em\@	C$@	A7Kƨ@	?[W>@	9~($@	4m8@	-B@	%zxl"h@	@	O;d@	@	ᰉ@	_F@	$/@	
M:@	 ѷ@#@:~ @(@Q@빌~($@	ԕ+@҈p;@ۋq@ۋq@W>6z@څݘ@1'@ٳ|@
=p@E@`d@jOv@˒:)z@Q@,zxl@TɅo@@p
=@E@ᰊ@@R<6@u@Q@kP|@$/@hr @@Mj@ڹY@n/@˒:)@o4֡a@hۋq
@`d8@^iB@\(\@[W>6z@Vaf@P*0U@IQ@F?@DS@C\N@B74@B\(@ATɅo@?@>BZc @6}Vl@*d7@,=@vȴ@n@'/@lC@lC@ק&@As@@D@6z@BZc @6z@[W>@1&y@'RT`@	@1&@u"@ߤ@@Q@qu!@=K^@*0@$/@Xe,@0
)@6C@@0
)@e+a@kP|@e+a@PH@*0@Xe,@@Ov_@nO@sP@S&@:)y@҉@҉@!R<@=p
@1&x@7KƧ@n/@?@F]c@~\N<@}Vl!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @@*#9@@*d7@@*͞&@@+m]@@,64@@,cA \@@,C@@,N;@@,N;@@,*1@@,O
M@@,*1@@,7@@-84֡@@-S@@.&I@@.Fs@@/As@@/sPH@@0>BZc@@01&x@@0[6@@0YJ@@0
=q@@0{@@0d8@@0ѷX@@0$tT@@0$tT@@0PH@@04֡b@@0ѷX@@0`A7@@0e+@@0{@@1#w@@1X@@2{m@@3u%@@3)^	@@2C,@@4g8}@@5Y|@@5E@@6;5X@@6L/{J@@6@@61@@7
M;@@7\(@@8@@:䎊@@?H˒:@@AJE@@AR@@Bᰊ@@Ca@@@D1&@@EϪ͞@@FE@@F҈p;@@HU2a|@@H4֡b@@I'RTa@@Jm@@LJ@@Nvȴ9X@@O;dZ@@P     @@SxF]@@U!.@@W>6z@@X{@@YiB@@[҉@@]1@@`A7K@@`ěT@@ao@@d>@@fH@@hYJ@@j3@@jY@@k@@t?@@N;5@@
M;@@	k~@@6C@@Z@@j~@@C@@
=q@@U=@@s@@eO@@-w1@@k~(@@ݘ@@H˒@@,@@F]d@@-
@@@N@@ڹY@@+j@@0
)@@Mj@@ ѷY@@O;@@D*@@n@@Z@@u"@@Ϫ͞@@iB@@Q@@Vϫ@@	k~@@GE85@@W@@a@O@@Ĺ#x@@JM@@:@@E@@u@@!.H@@+jg@@Ǡ	k@@;dZ@@u%F@@6z@@/w@@ ě@@C,z@@e@@֡af@@ח$tS@@d7@@n.@@m8@@ܞ쿱[@@7@@hr@@5Xy>@@S&@@ݫU=@@H˒:@@~($@@C\@@⒣S&@@u%@@㯷@@%1@@PH@@zG@@N;@@hr@@!R@@5?|@@)^@@!-w1@@1@@RT`e@@sPH@@*0U@@
=q@@e+@@[W>6@@^5?}@@lD@@~"@@sP@@m\@@33333@@빌~($@@j~#@@(@@L_@@Vl!@@p
=@@ڹZ@@Ϫ͞@@(@@@@1.@@p:~@@@@.H@@	@@@@6@@}H@@[6@@҈p@@&x@@u@@e@@>BZ@@R@@.H@@3@@nO@@͞&@@S&@@,<@@'/@@6z@@]cA@@ߤ@@A [@@@4@@u%F@@L/{@@=p
@@񰉠'R@@҈p@@H@@u%F@@+j@@As@@@@)^@@oiDg8@@ [7@@R@@\(@@/V@@a@N@@lC@@S@@j~@@j~@@1&@@Z@@e@@E@@e@@K]@@*0@@(@@84֡@@?|h@@S&@@m\@@zxl"h@@}H@@U=@@
qv@@ ѷY@@($x@@c	@@%@@,<@@$t@@T@@6z@@ȴ9X@@ȴ9X@@
=p@@>6z@@;dZ@@.H@@Ϫ͟@@&I@@@@As@@eں@@_o@@iDg8@@o@@{J#:@@ݗ+@@/V@@˒:)@@     @@6@@$xG@@-
@@4֡b@@	k~@@+@@ [7@@ [7@@&x@@=b@@^@@oiD@@N;6@@s@@lD@@R@@@@3@@W'@@W'@@C\@@h	ԕ@@{m@@~"@@vȴ@@L/{@@vȴ@@S&@@vȴ@@wkQ@@@@S&@@L/{@@G{@@74@@m\@@I^@@I^@@)^	@@33333@@33333@@@N@@J#9@@MjO@@a@N@@g	l@@MjO@@6z@@F]c@@eO@@:)z@@U=@@*0U2@@@@@@~($@@6@@a@O@@A [@@(\@@L_@@C]@@5Xy@@Q@@
=p@@*0U2@@{J#9@@=K^@@xF]@@ ě@@\(@@<64@@s@@'R@@7Kƨ@@@N@@oiDg8@@4m@@)^@@'/W@@Xe@@}Vl@@E@@L_@@qu"@@84֡@@Y|@@@@#@@tSM@@j~#@@#x@@ce@@
L/@@;5X@@IQ@@t@@v@@sPH@@\(@@	k@@r Ĝ@@hr @@@@@@u@@u@@(@@_o@@-@@n@@0U2a|@@@@YJ@@حV@@)^@@Ft@@@@-@@qi@@\N<@@H@@Q@@+@@+I@@6@@1&x@@bM@@@@@@@~($@@u%F@@#9@@1'@@䎊@@#9@@&IR@@䎊@@-@@|@@o@@|@@rGE8@@@N@@)@@hۋq@@A7K@@eO@@˒:*@@)@@ѷX@@D@@D@@|@@hۋq@@_F@@_F@@@@@-V@@)@@e+a@@b}@@s@@u%F
@@/V@@$@@M:@@?@@/@@o i@@[@@84֡@@<64@@O;dZ@@F
L0@@2a|@@O
M@@#@@TɆ@@N;@@@@#x@@Ʌoi@@>@@/w@@L_@@O
@@@@b@@C\@@t@@_o @@
L/@@
(@@
L/@@zG@@@@$/@@iB@@p:~@@p:~@@s@@R<6@@($x@@8YJ@@L/{J@@@@@@YJ@@!R@@F
L0@@F
L0@@F
L0@@$/@@sh@@,=@@?@@}Vl@@"@A 1&x@A F@A&x@A@Al@AD@AoiD@A$/@A {@A U@A `A7@A {@A4J@A$/@A }H@@iDg8@@@@쿱[W@@ݗ+@A 	ԕ+@A A7K@A eO@A IQ@A$/@ATɅo@A7Kƨ@Aԕ*@A>BZ@AlD@A	 @Ah	ԕ@AS@Awk@AE@Ag@A9XbN@A,<@AQ@AFs@AC@AZ@A@AxF]@AMjO@A33333@A"`B@A҉@AS&@A)^	@AC,z@A)^	@A6z@A@N@Aqu!@A~($@A1&y@A2W@A]ce@ATɆ@A2a|@AU=@A8YJ@A}Vl@A6z@AQ@AA@A]cf@A@AFt@A!-w1@A.H@A'/W@Ay@A	k@ArG@AU2a|@A$tT@A	e@A
@A
C,@As@A33333@AF]c@A{J#9@Atj@AI^5?@A`d@AI^5?@A9XbN@A(\@A$@A%2@AƧ@A|@A*0U2@A@A%2@A"h	ԕ@A%1@AQ@A!-w2@A(\@A%1@A2W@A2W@A<쿱@A9XbN@A<쿱@Ag8}@Aq@AwkP@AzG@A3@A֡a@A
}H@A!R<@AT@Avȴ9@A|@A-
@A-
@A-
@A@A
=q@A@A@AYJ@A'RT@Ad8@A#w@AoiD@AiB@A&IR@AkP|@Avȴ@AfB@As@AW>6z@Aq@A
=p@A"h	ԕ@Aqj@A#x@A*0@AZ@AV@AB@AY|@A-V@AVu@Aߤ?@AFt@A4֡a@A$tS@A͞@A˒:)@A@A ě@A$xG@A-
q@AeO@A{@AF@A\)@A@A_p@A-w1@AA [@AXbM@AoiD@A@A'RTa@A(@Al@A^5?}@A2W@Ao@AR@A.H@An@AOv`@A3@AT`d@A{m@Aᰊ@AS&@AY@AfB@AS&@AS&@AeO@A~($@A@Aa@@Ag@A$@As@AxF@A@AC,zx@AVϪ@AcA \@AwkP@AwkP@A?@Ao h@A1&@Au@AS&@AVl!@A+j@Azxl"h@Azxl"h@AM:@AO
@A=K@Av@A=K@A!R@Aݗ@A@A\(@A
L/@A%@A+@A+I@AKƧ@AXe,@Aeں@Ab}V@Aeں@A_o@AiDg8@Ao@AsPH@A{J#:@AzH@A@@A      @A 4m9@A bM@A eO@A u!@A @A e+@A!	k~@A!4J@A!k~(@A!^5?}@A"n@A"s@A"䎊@A"0U2a|@A"3@A"C\@A"T`d@A"a|Q@A"ݘ@A" ě@A"C,@A#6z@A#@N@A#MjO@A#S@A#Z@A#tj~@A#ߤ@A#Z@A#5Xy@A#Q@A#@A$@A$2W@A$?@A$I^5?@A$SMj@A$VϪ@A$cA \@A$?@A$wkP@A$S@A$O
M@A$j~@A$*0@A$u"@A$u"@A$@A$!-w@A%:@A%*0@A%!.H@A%+a@A%/w@A%<64@A%F
L0@A%Vl!@A%m\@A%!R@A%+j@A%Xy=@A%?@A%(@A%E@A&t@A&8YJ@A&R<6@A&@A&Fs@A&}Vl@A&ȴ9X@A&+@A&1@A&1@A&!.I@A'KƧ@A'O
M@A'b}V@A'y@A'&@A'ݗ+@A'?@A'vȴ9@A'o @A'@A'fA@A'@@A'rG@A'rGE9@A'rGE9@A'rGE9@A(@A(F]d@A(F]d@A(F]d@A(	ԕ+@A(bM@A(-
q@A(H@A(Q@A(U2a|@A(bM@A(hۋq@A(l"h	@A(r Ĝ@A(tj@A(IQ@A()^@A(ѷX@A(e+@A(4֡b@A(\)@A({@A(PH@A(4֡b@A(	k@A(	k@A($tT@A(\)@A(	k@A(PH@A(\)@A)@N@A)Q@A)Dg8~@A)N;5@A)[W>6@A)k~(@A)o hی@A)oiD@A)l@A)@A)N;6@A)>BZ@A)Y}@A).H@A*s@A*s@A*1'@A*#9@A*)y@A*:)y@A*W'@A*~"@A*@4@A*\(@A*>B@A*Y@A*C,@A+S&@A+,zxl@A+:)z@A+S@A+E@A+@A+ݗ+k@A+C]@A,n.@A,@A,ߤ@@A,,<@A,64@A,I^5?@A,SMj@A,cA \@A,*1@A,1&@A,7@A,?@A,Ʌoi@A,*0@A,*0@A,Z@A,u"@A-:@A,e@A-'0@A-84֡@A-F
L0@A-jOv@A-M:@A-ڹZ@A-hr!@A-=K@A-%@A-@A-b@A-oiDg@A-C\@A-ڹ@A-C\@A. ѷY@A-ڹ@A.
L/@A.
(@A.
(@A.
(@A.4K@A.4K@A.zG@A.Ov_@A.$/@A.z@A.6z@A.'@A.Q@A.@A.A@A.ߤ?@A.@A/@A/)^@A/.H@A/E84@A/Xe,@A/\(@A/eں@A/iDg8@A/v_ح@A/{J#:@A/{J#:@A/{J#:@A/kP@A/[W>@A/r@A/@A/˒:)@A/@A/+@A/@A/@A/-@A/rGE9@A0	ԕ+@A0     @A0F]d@A0@A0	ԕ+@A0	ԕ+@A0bM@A0bM@A0bM@A0bM@A0bM@A0
qu@A0bM@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0	ԕ+@A0@A06@A01&x@A0:~ @A0A7K@A0H@A0bM@A0r Ĝ@A0YJ@A0-
@A0ěT@A0)@A0)@A0@@A1 ѷ@A1=b@A1JE@A1JE@A1Q@A1TɅo@A1e+a@A1^@A1|Q@A1B@A1^5?}@A12W@A1>BZ@A1@A1@A1-@A1lD@A2u%F@A2Ov`@A20U2a|@A2@4n@A26C@A2=p
@A2Q_@A2Q_@A2M@A2W'@A2Zc@A2T`d@A2W'@A2d7@A2u%F
@A2\(@A2g	@A2@A2L/{@A2L/{@A2L/{@A2`A@A2m\@A3u%@A3'/@A3PH@A3C,z@A3C,z@A3&@A3C%@A3xF]@A3~$@A3eO@A3q@A3A@A3A@A3U=@A3U=@A3S@A3*0U2@A3wk@A3S@A3*0U2@A3q@A3@A3@A36@A3|@A3Q@A3g@A3C]@A3\N@A4@A4"h	ԕ@A42W@A4VϪ@A4j~#@A4~($x@A4C@A43@A4?@A47@A4Ʌoi@A4>B[@A4Z@A4>@A4>@A4>@A5:@A5K]@A5V@A5u@A5[@A5qu"@A5Q@A5!.H@A5!.H@A5(@A5+a@A5(@A5+a@A52a|@A5<64@A5?|h@A5B@A5F
L0@A5L_@A5Vl!@A5Vl!@A5\@A5fA@A5jOv@A5w1@A5M:@A5=K@A5\(@A5ᰉ@A5C\@A5!.@A6t@A64K@A6
(@A6zG@A6u@A6Ov_@A6($x@A6+jg@A6;5X@A6Ov_خ@A6YJ@A6c	@A6fffff@A6fffff@A6qi@A6T@A6'@A6Q@A6m\@A6@A7
=p@A7v@A7@A7!-w1@A7>6z@A7As@A7;dZ@A7E84@A7H˒:@A7KƧ@A7O
M@A7RT`e@A7iDg8@A74m@A7kP@A7ݗ+@A7$tS@A7-V@A7	k@A7&@A7zH@A7͞@A7[W>@A7vȴ9@A7o @A7;dZ@A7rG@A7-@A7+j@A7rGE9@A8     @A8F]d@A8
qu@A8*0U@A8}H@A8*0@A8:~ @A8>BZc@A8A7K@A8D*@A8A7K@A8A7K@A8NU@A8U2a|@A8l"h	@A8r Ĝ@A8u!@A8|@A8y=c@A8n@A8@A8tj@A8@A8@A8@A8tj@A8tj@A8@A8IQ@A8@A8@A8@A8d8@A8{@A89Xb@A8)@A84m@A8ěT@A8)^@A9	k~@A9rGE@A9 [7@A9-w1@A9-w1@A9Dg8~@A9ae@A9rGE8@A9u!S@A9|Q@A9~($@A9o@A9'R@A92W@A9N;6@A9@A9iB@A9ᰉ'@A9>BZ@A9R@A9-@A:n@A:s@A:@A:I^5@A:@A:s@A:e+@A:e+@A:&IR@A:C\@A:^5?|@A:Zc@A:nO@A:xl"h
@A:ᰊ@A: ě@A:ڹY@A:C,@A:c	@A;nP@A;u%@A;҉@A;'/@A;҉@A;)^	@A;C%@A;J#9@A;S@A;S@A;Z@A;Z@A;Z@A;a@N@A;a@N@A;g	l@A;jf@A;a@N@A;]cA@A;g	l@A;g	l@A;g	l@A;g	l@A;jf@A;jf@A;jf@A;n.3@A;qu!@A;n.3@A;xF]@A;xF]@A;xF]@A;{J#9@A;~$@A;~$@A;@A;eO@A;:)z@A;Mj@A;A@A;ߤ@A;S@A;m]@A;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @qNfffff@qFfffff@qQ@qNfffff@qP     @qNfffff@qH     @qL@qS33333@qT@qY@q^fffff@q[33333@q\@q`     @q`     @q^fffff@q\@qT@qT@qQ@qP     @qQ@qY@q[33333@qY@qY@q^fffff@q^fffff@q`     @q^fffff@qY@q[33333@qY@q\@q\@qX     @qQ@qP     @qQ@qVfffff@qI@q@     @qA@q>fffff@q>fffff@q@     @q>fffff@q>fffff@q@     @q333333@q@p33333@p     @py@pd@pFfffff@p&fffff@p@pfffff@p     @o@oC33333@n     @n33333@ns33333@nS33333@n\@nc33333@n\@nS33333@nI@nFfffff@n9@n33333@mfffff@mffffff@m#33333@l@lI@k@kfffff@kL@k&fffff@j     @ifffff@i@h      @g     @g33333@g33333@gfffff@g6fffff@fə@fp     @f,@f33333@f@f<@fs33333@f33333@f@f33333@f33333@f@fp     @f9@e     @eC33333@dfffff@d|@d#33333@c     @cٙ@c33333@cfffff@cٙ@c     @c     @c33333@c@c陙@cfffff@c@c     @c     @c     @cs33333@c`     @cP     @c6fffff@c      @c33333@b     @b@bP     @b      @b33333@afffff@afffff@ai@a)@a	@afffff@a     @a@a     @afffff@`     @`     @`s33333@`&fffff@_     @_fffff@_y@_Y@_L@_L@_`     @_s33333@_&fffff@^@^33333@^33333@^fffff@^fffff@^     @^33333@^s33333@^Ffffff@^      @^,@^@     @^      @]33333@]@]@]l@]Ffffff@]&fffff@\@\@\33333@\@\     @\ٙ@\33333@\33333@\33333@\@\@\y@\@     @\&fffff@\33333@[33333@[33333@[@[     @[33333@[@[fffff@[s33333@[s33333@[ffffff@[l@[@[@\fffff@\33333@\fffff@[fffff@\ffffff@]@^S33333@^s33333@^     @_9@_fffff@`6fffff@`i@`     @a      @a@     @a333333@`ٙ@`ffffff@`fffff@_ffffff@^     @^fffff@^      @]`     @]@]@]@]      @\fffff@\@\33333@\33333@\fffff@\@\33333@\s33333@\S33333@\9@\      @\      @[@[@[@[fffff@[@[fffff@[fffff@[@[@[ffffff@[Ffffff@[&fffff@[fffff@Z     @Zs33333@Y@Yl@Y@Y@Y      @Y&fffff@Y@X@X@Y@Y      @Y@     @YY@Yl@Yffffff@Y`     @YY@YY@Yl@Y     @Ys33333@Yy@Yfffff@Yy@YS33333@Y9@Y      @Xfffff@X     @X     @X@X33333@X@X     @X     @X     @X@X@Xs33333@Xs33333@Xy@Xy@Xy@Xs33333@Xfffff@Xy@Xs33333@X`     @XY@XL@X@     @X333333@X,@X@X33333@Xfffff@Xfffff@Xfffff@W@W     @Wٙ@W33333@Wfffff@WY@Vfffff@V@Vs33333@VFfffff@V333333@V      @V@V@V@V,@VS33333@V@V33333@Vfffff@Wfffff@W&fffff@WS33333@Wy@W33333@Xfffff@X33333@X      @X,@X@X     @Y,@Y     @Z33333@[&fffff@[9@[9@[ffffff@[fffff@\&fffff@\s33333@\@\fffff@\33333@]@]      @]fffff@\@\333333@[@[      @Zٙ@Zfffff@Z,@Y@Yfffff@Y@Y,@Xy@X      @W@W     @W@Wfffff@W@W@Ws33333@Ws33333@W@XL@Yfffff@Y@Z@Z&fffff@ZS33333@Zy@Zfffff@Zffffff@Z9@Z      @Y@X@X@XY@X@W33333@WS33333@Vٙ@V     @V`     @VY@VY@VS33333@V`     @V     @V@V33333@V@V@Vfffff@W,@Wl@W@W@Wy@W9@Wfffff@W      @V@W      @W&fffff@W,@W@     @Wffffff@Wl@W      @VL@U@U     @U      @Tfffff@T&fffff@S@SY@S&fffff@R@R33333@R@R     @R@Rfffff@R33333@S@S&fffff@S      @Sfffff@R     @Rfffff@R@R33333@Rs33333@R@     @Rfffff@Q@Q     @Qfffff@Q     @Qs33333@Ql@Qffffff@Ql@Qffffff@Q`     @Q@     @Q9@Qfffff@Pfffff@P     @P@P@P@P@Ps33333@PFfffff@PFfffff@Py@P@P     @P@P@Ps33333@PL@P33333@Oٙ@Os33333@Nfffff@M33333@M@L@Lffffff@L&fffff@L@LY@Lfffff@L33333@Lfffff@L@Lfffff@Lfffff@Lٙ@ML@M33333@M33333@Mfffff@M@Lfffff@L     @L@     @L      @K@K333333@J33333@J33333@J33333@J@Jffffff@J@I     @Hfffff@H     @Hs33333@HY@H     @Hs33333@HL@H@H@     @Hٙ@Hfffff@H33333@I@Hfffff@Hfffff@Hٙ@H33333@H33333@Hfffff@Hٙ@H@HY@H      @Gfffff@G@Gfffff@G333333@Ffffff@F&fffff@Efffff@E33333@E@E     @E     @E@Es33333@Es33333@EL@E&fffff@E&fffff@Dٙ@D@DL@C     @C      @BL@A33333@Afffff@A33333@A@A@A     @@fffff@@33333@@@@33333@A@A&fffff@A@A@     @AL@A@     @AY@A333333@A      @A      @A      @A      @@fffff@@ٙ@@@@ٙ@@ٙ@@@@@@@@     @@33333@@     @@@@s33333@@&fffff@?@>@<fffff@;ffffff@:33333@:33333@:33333@:fffff@:@:33333@:@;      @;      @:@:@:333333@9@9L@8fffff@8ffffff@8L@8      @7@7@7L@6fffff@6333333@6@5@5     @5L@5L@5333333@5@4@4@3L@2@2@2ffffff@2L@2ffffff@2333333@2@2@2@1@1@1     @1L@1L@1ffffff@1ffffff@1L@1L@1L@1ffffff@1ffffff@1L@1333333@1L@0fffff@0@0fffff@0fffff@1      @1      @1@0@1@0fffff@0     @0     @033333@0@0ffffff@0ffffff@0ffffff@0@0@0L@/@/333333@/@/@0      @0@/333333@/333333@/ffffff@/ffffff@/333333@/333333@/      @.@.      @-@-@-@-@,@-      @,@,@-      @,@,@,@-      @,@,@,@,@,ffffff@,      @+@+@+ffffff@+ffffff@+ffffff@+@+333333@*@+ffffff@+333333@*@+      @*@*ffffff@*@*@*ffffff@*333333@*      @*333333@*333333@*333333@)@*333333@*      @*      @*      @*      @)@*      @)@)      @(@(@)ffffff@(@(ffffff@)      @(@(@(333333@(ffffff@(333333@(      @(333333@(      @(      @(      @(      @(333333@(      @'@(333333@(333333@'@(      @(      @(333333@'@(      @'@'@'@(      @(      @'ffffff@'333333@'@'333333@'ffffff@'@(      @'@(      @'ffffff@'ffffff@'333333@'ffffff@'333333@'@'@'333333@'      @'333333@'ffffff@&@&ffffff@&@'333333@&@&@&      @%@%ffffff@%@&      @%ffffff@%@%333333@%      @%333333@%ffffff@%@%@%333333@%333333@%ffffff@%      @%ffffff@%333333@%333333@%333333@%      @%ffffff@%333333@$@%      @%ffffff@%ffffff@$@$@$333333@$@%      @$@$@%333333@$ffffff@$@%@%333333@$@%333333@$@$ffffff@$@%@$@$@$@$@$@%      @$@$@$@$@$@$@$@$@$333333@$@%333333@$@%      @$@$333333@$@$@$333333@%333333@%      @$@$@$@$@$@$@$@%      @%ffffff@$@$@%@%      @%ffffff@%333333@%      @%333333@%      @%@&      @%      @%@%ffffff@%      @$@%      @%ffffff@%333333@%333333@%      @%333333@%333333@%      @%      @%@%333333@$@%333333@%ffffff@%333333@%333333@%333333@%      @%333333@%333333@%      @%333333@%333333@%      @%333333@%@%ffffff@$@%ffffff@%@%@%@%@%@%ffffff@&      @&333333@%ffffff@%@&333333@&ffffff@&      @&ffffff@%@%@&ffffff@&      @&      @&333333@&333333@%@&      @&      @&333333@&333333@&      @&333333@&333333@&      @&      @&333333@&      @&      @&ffffff@&ffffff@&      @&      @&333333@&      @&333333@&      @&      @&      @&333333@&      @%@&      @&333333@%@&333333@&ffffff@&333333@&ffffff@&      @&333333@&      @&333333@&ffffff@&ffffff@&ffffff@&333333@&ffffff@&@&@&@&@&@&@'333333@&@'      @&@'      @'      @'333333@&@'      @'333333@'333333@'ffffff@'ffffff@'333333@'ffffff@'@'333333@'333333@&@'333333@'@'ffffff@'@'333333@'@(      @'@'ffffff@'@'@'@(ffffff@(ffffff@(333333@(ffffff@(ffffff@)      @(ffffff@(333333@(@(@(@(@(@(@(ffffff@(@)      @(@(ffffff@(@(ffffff@(@(@(@(@(@(@)      @(@(@(@(ffffff@)      @)333333@(@(@)333333@)ffffff@)333333@)ffffff@)@)@)333333@)@)@*333333@)@)333333@)@)@)@)@)333333@)@)@)@)@*      @)@)@*ffffff@)@)@*      @)@)@)@*333333@*      @*333333@*      @*      @)@*ffffff@+333333@*@*ffffff@+      @*@*ffffff@*@+ffffff@*@+333333@+333333@+      @*@+      @+ffffff@+333333@+      @+333333@+333333@+@+@+@+@,333333@,ffffff@+@,333333@,@,333333@+@,ffffff@,ffffff@,ffffff@,ffffff@+@+@,@-333333@,@,@,@,@,@-      @,@,@-      @-ffffff@,@-333333@-      @-      @-@-@-333333@-      @-ffffff@-ffffff@-@-      @-333333@-ffffff@-@-@-@-@-@-333333@.ffffff@.      @-333333@-ffffff@.ffffff@.333333@.      @.      @.333333@.ffffff@-@-@-@-@.333333@.      @-@.ffffff@.333333@.333333@.      @-@.333333@.333333@.@.ffffff@.@/333333@/      @/333333@0@0@0ffffff@0      @/@0333333@0@0L@0@0L@0ffffff@0ffffff@033333@033333@0@0@0@0fffff@0@0@0fffff@0@0fffff@1      @1333333@0fffff@1      @1@1@0fffff@1333333@1     @1L@133333@1@1fffff@1@1fffff@1@1fffff@2      @1fffff@1@2333333@2@2      @2333333@2      @2      @2@2333333@2@2333333@2      @2      @1@2333333@2@1fffff@2L@2@2333333@2      @2333333@2@2333333@2L@2      @2333333@2333333@2333333@2333333@2      @2@2     @2ffffff@2L@2     @2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ??C%?+J?Vu?\(?E?
=p
?bM?E?7KƧ?Vt?$/?;dZ?\(?E?Q?"`B?lD?p
=q?7KƧ?&x?O;dZ??A7Kƨ?\(?Ƨ-?+?;dZ?bM?ěS?O;dZ??j~#?ȴ9Xb?$/?~"?-V?ěS?A7Kƨ?bM? ěT?I^5?}?"`A?GzH?9XbN?tj?+?|hr?ܬ1&y?
=p?I^5??`A7L?S?Ձ$/?n?Q?A7Kƨ?ΗO;d?Vu??Vu?hr!?1&x?"`B?+?ǮzG?\(?\(?/w?9XbM?S?ěS?l?S?333333?l?l?-V?nO;?-V?I^5??GzH?Z1'?n?GzH?I^5??A7Kƨ?A7Kƨ?;dZ?E?vȴ9X?5?|h?p
=q?hr!?S?dZ1?^5?|?"`A?(\)?S?(\)?/v?-V?      ?|hr?Q?hr!?1&y?j~"?j~"?vȴ9?+J?+J?tj~?O;dZ?+?bM?KƧ?tj~?KƧ?$/?ȴ9Xb?tj??|hs?tj?E?E?\(?\(??|hs??|hs?E?zG{?9XbM?+?tj~?333333?Q?lD?&x?`A7L?
=p?bM?bM?bM?vȴ9X? ěT? ěT?
=p?bM?;dZ? ěT?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?5?|h?;dZ?;dZ?Q?Q?Q?Q?Q?5?|h?Q? ěT?Q?;dZ?5?|h?/v?Q?-V?Q?5?|h?5?|h?-V?5?|h?-V?Q?-V?5?|h?/v?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?-V?5?|h?Q?vȴ9X?5?|h?/v?/v?/v?/v?-V?-V?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?5?|h?Q?-V?1&y?-V?/v?-V?-V?-V?/v?Q?Q?/v?/v?5?|h?Q?Q?-V?1&y?-V?-V?1&y?/v?-V?/v?-V?5?|h?-V?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?Q?5?|h?-V?/v?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?Q?Q?5?|h?5?|h?5?|h?Q?;dZ?5?|h?5?|h?5?|h?Q?-V?Q?-V?5?|h?-V?Q?Q?5?|h?5?|h?-V?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?Q?Q?5?|h?5?|h?-V?5?|h?5?|h?Q?Q?Q?;dZ?vȴ9X?5?|h?5?|h?Q?5?|h?5?|h?Q?Q?Q?;dZ?5?|h?Q?Q?5?|h?-V?Q?;dZ?Q?Q?Q?Q?Q?5?|h?5?|h?Q?vȴ9X?Q?Q?Q?-V?Q?5?|h?5?|h?5?|h?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?5?|h?5?|h?5?|h?Q?Q?;dZ?Q?5?|h?-V?Q?;dZ?Q?5?|h?-V?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?5?|h?Q?5?|h?vȴ9X?;dZ?Q?vȴ9X?Q?5?|h?;dZ?;dZ?Q?-V?Q?;dZ?Q?Q?5?|h?;dZ?Q?Q?5?|h?Q?;dZ?;dZ?5?|h?Q?Q?Q?Q?;dZ?;dZ?Q?5?|h?Q?Q?5?|h?5?|h?Q?Q?;dZ?Q?Q?;dZ?5?|h?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?5?|h?Q?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?Q?Q?Q?;dZ?Q?Q?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?5?|h?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?
=p?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ? ěT?vȴ9X?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X? ěT?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?vȴ9X?Q?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?vȴ9X?Q?vȴ9X?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?Q?vȴ9X?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @b     @X@S33333@Mffffff@J&fffff@G     @D@B33333@@33333@<33333@9L@733333@6@4@2     @0     @-ffffff@*@)@(      @&      @$ffffff@"@!333333@       @      @      @      @      @      @@@ffffff@333333@      @ffffff@      @	@      @ffffff@@      @ffffff@@ ?ffffff??333333??      ?ffffff??333333?333333?񙙙?      ?      ???陙?陙?ffffff?ffffff?333333?333333?      ?      ?      ?ٙ?ٙ?ٙ?333333?333333?333333?333333?333333?ə?ə?ə?ə?ə?ə?????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P4                                      5                                       )ˢBBV/3 