CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P26    CAST_NUMBER       5      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.943500Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @H        data_max      @H        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     <  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?         data_max      @D        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      <  j   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      ,     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?C\N   data_max      @ H9Xb   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       <     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      ,  p   salinity                	long_name         salinity   units         PSS-78     data_min      @@7[W>   data_max      @AJu%F
   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      <    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      , ?D   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%333333   data_max      @rL   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        < Np   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      ,    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+I   data_max      ?         C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      < D   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      ,    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       <    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      , "   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @&   data_max      @Q&fffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     < 1   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      , n   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( }   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( }   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       ~   latitude               	long_name         latitude   units         	degrees_N      data_min      @H/ek   data_max      @H/ek   C_format      %9.4f          ~   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      b6;%   data_max      b6;%   C_format      %9.4f          ~   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        ~   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        :   data_max        :   C_format      %4d        ~ @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     @H     ?      @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @(     @0     @8     @@     @H     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @0     @8     @@     @H     @P     @X     @`     @h     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @\     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @,     @0     @4     @8     @<     @@     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @0     @4     @8     @<     @@     @D     @H     @L     @T     @X     @\     @`     @d     @h     @l     @p     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @(     @,     @0     @4     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @@     @D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @ BZc@ B@4n@ A@ A@ BZc@ B@4@ D?@ Eu@ D%1@ D%1@ @n@ ATɅo@ BI^5@ DTɆ@ F@ FIQ@ F1.@ F]cf@ F]cf@ FA@ Fx@ FA@ FFs@ G@ G8}H@ GRT`e@ GRT`e@ GlC@ GRT`e@ G8}H@ G+I@ GE84@ GRT`e@ GRT`e@ GlC@ G&@ Gݗ+@ G	k@ G/V@ GfA@ G@@ G@@ G-@ G#@ H@ H@ GzH@ G@@ H@ H>BZc@ G-@ GzH@ G-@ G/V@ Gy@ GfA@ GK]d@ HK]c@ Hr Ĝ@ H9Xb@ G@@ H	ԕ+@ H>BZc@ Gݗ+@ ES&@ Dtj@ D?@ C%2@ Cwk@ @A7K@ ?@ ?;dZ@ >6z@ <hr@ ;5Xy@ ;S@ :ݘ@ :xl"h
@ :Y@ :,<@ 9~($@ -@ *0@ +I@@u%F
L@'0@oiD@:C\@Ov`@[W>@L_@4֡a@%O
@oiDg8@5?|@.1@hۋq@n1@=b@}Vl!@:^5?|@ 	k@@ݗ@a@N@nP@m\@ce@BZc @	ԕ+@?@cZ@Y+@S&@Jn@@b}V@s@lD@&@rGE8@PH@E84@wrG@u\(@sg	l@l"h	ԕ@i^@]/w@\]ce@^Ov_خ@\]ce@TFs@R<64@d7@b@4@Nqi@Ao hی@8Q@.t@+Q@/r@+C,z@!|Q@$@Mj@
qu"@Q@lC@#@A [@%@|@%2@v4K@^쿱[W@C@
=p@ݗ+@S&@tj@"@\N<@~@C\@@4@ݲ-V@Ϫ͞@ï@>B@iDg8@@Z@+@l!-@˒:)@dxF@X*0@U*0@P-
q@.O;@ 	k@+@o h@m8@B@4֡a@J@㢜wk@p:@_ح@?@@tj~@T`d@_@\N@$@@{J#9@x}H@tj~@tJ@[W>@oiD@YJ@ [7@NU@TɅo@TɅo@weں@z~@n.@|Q@~($x@z)y@z)_@qj@<쿱@ڹ@/@@I^5?@i*0U2a@X*0@g	k@be+@]-V@_Ft@cS&@zC\@Vu@As@zG@>@\)@0U2a|@o@@~ߤ?@74@84֡@+I@1&x@s@L_@@4m@$/@˒:)@{5Xy@y#w@w1@tm8@u!R@w1@vȴ9X@t!-w2@rm\@rW@r䎊q@sE@tSMj@uXy=@w+@vC-@weں@w4m@x4֡b@z~@zG{@z)y@v+jg@s33333@x}H@z)_@x73@sߤ@m
qv@hۋq
@g	k@ffffff@\ߤ@@[W>6z@[6@[qu!@Y@VR<6@\?@ZkP|@5sg@LL_@`ěT@a.H@_حV@_U=@[u%@UϪ͞@G_o@C@As@BI^5@A7Kƨ@@n@@4m@@     @<hr@=p
=@?b}V@?.H@=H˒@=E@>$t@<64@6z@5Y|@6+jg@:@2䎊q@49XbN@0
(@,q@)lD@(TɅ@'	k@(TɅ@%S@-hr!@*0U2a|@$tSM@!e@!-w1@!Gz@!@N@ 'RT`@u@tj@:)y@hr @C%@@4n@A [@빌~($@!-w@!R@%F
L@\@e@
qu@W>6z@e+@Ϫ͟@l!-@8YJ@Ϫ͞@fA@8YJ@
=p@>6z@څݘ@+@lC@E@+jg@A [@cA @䎊q@?@"`@`A7L@S@Q@@:~ @(@hr!@t@@D@!.I@kP@=b@73@ȴ9X@D@%F
L@+jg@g@4֡a@8Y@!-w@C@!-w@!-w@!-w@t@u!S@D@ hۋ@ hۋ@GE85@s@GE85@GE85@
=q@g	@,<@P{@\@iDg8@O;@rGE8@*0U@{@T`d@sP@҉@*0U@o @$tT@N;6@:)y@n@p:@@O;d@sPH@a@O@҉@F]c@ [7@?@oiDg@a@N@@
=p
@~($x@qi@)^@u@҉@*0U2@u@a@N@ n@l@`A7L@+a@Z@ ѷY@1'@b}@ק&@҈p@b}@84֡@84֡@Õ$@Õ$@\(@@ߤ?@ߤ?@s@cA @fA@Q@P{@JL@Dg8~@sPH@,zxl@sg@-@u%@u%@sh@L_@Z@R<6@@@@@Ov_@L_@u%F
@u!R@nO;@k~($@gfA@cS@`
qu@^@\]ce@["`B@W&@T,<@Np:~@JD@K)^	@LcA \@N;5X@IQ@A7Kƨ@<j~#@=K]@<n.@8}H@5'0@2a|Q@,q@.H@*͞&@%@$tS@*0U2@N;6@N;6@rGE9@\(@
M:@@m\@!.@iB@
=q@Q@ᰉ'@fA@ڹ@`A7L@JL@C@rGE@;dZ@>BZ@sPH@՛=K@m@jOv@@?|h@
qv@y@R<6@%@,=@u%@nO@M:@ݗ+@ ѷ@@hۋq@}!.H@x-
@v_ح@x-
@jOv`@[6@U2a|@SZ@Vt@\]ce@^ ѷY@^@_;dZ@_Ft@[q@[q@\?@[q@\?@\?@\?@]+j@^҈p;@`
qu@_حV@_;dZ@^5?|@_حV@_حV@_حV@_Ft@^iB@XU@UfA@SMj@O͞@MjOv@KƧ@Jn@I@G@@E@D2W@C,zxl@?[W>@<64@5'0@&L/{J@Z@Mj@\(@@+I@
b}V@
C@
а{@
@
y@
@
:@
*0U@
+@
ɺ^5?}@
s@
*0@

(@
ߤ@
/V@
-
@
@
@
ߤ?@
(@
O;dZ@
L_@
I^5?@
҈@
L_@
'/@
~($x@
1&x@
~\N<@
nc	@
e@
d%1@
`҈p@
Zc	@
Rp:@
KƧ@
K:)z@
A@
3ߤ@
(TɅ@
"wkQ@
kP|@
@
zG@
n/@C\@C]@`A7L@Gz@?@o i@)y@?@u@tj@S&@@Fs@eO@#@:S@?@:S@x73@y	k~@xF@weں@kC,z@[W>6z@SMj@GzH@@C@:)_@7Xe@5?@43@3g	l@1&x@/Vϫ@/O
M@/r@*0
@(TɅ@$TɆ@"h	ԕ@ -
@Ov_خ@
@	ԕ*@	 ѷ@1&x@	7KƧ@+I@ݗ+@K]d@ IQ@?@#x@ڹZ@G{@\(@+jg@%F
L@j~@JL@Ov`@~"@ߤ?@+@䎊@s@n@Õ$@|hs@[W>@ߤ?@Xe@6z@-@@1@/@S&@wkQ@h	ԕ@`A@wkQ@S&@o@-w1@-
@-V@S&@@{J#9@z@n.2@_حV@XU@Rm@JD@DS@:^5?|@6z@12W@0U2a|@/r@*d7@u%F@ݗ+k@u@hr @bM@
qu"@
O;dZ@@S&@
Q@
t@
C\@
VϪ@
B@
	k@
,<@
|Q@
֡af@
|@
ɅoiD@
[W>@

(@
~($@
Xy=@
'RT@
y@
1@
,=@
@
O
M@
L/{@
|hr@
x73@
u\(@
s@
pD@
kC]@
f,<@
ffffff@
hۋq
@
a'R@
^iB@
Xy=c@
Sa@O@
Q@
O;dZ@
N;5X@
KƧ@
HK]c@
C@
?[W>@
>
(@
=K]@
;A@
:)y@
8Q@
2a|Q@
+a@@
$tSM@
-V@
@
@
'/@
eO@
#@
&I@
o hی@	$t@	#x@	F@	hr!@	ۋq
@	Z1@	e+@	d8@	u!@	cA @	sPH@	5Xy>@	)^@	b@	~@	)_@	KƧ@	-V@	{@	v@	jf@	zxl"h@		k@	,=@	u%@	tj@	+j@	sh@	n@	@	qu"@	ݗ+@	?@	~\N<@	{s@	tj~@	r ě@	poiDg8@	jfB@	dqj@	`҈p@	[W>6z@	W>6z@	NT@	Gy@	?[W>@	=b@	:S&@	49XbN@	-w1@	&'@	!R<6@		@	Q@	-V@	S@	_F@	)^@		k~(@	nP@PH@E@D@s@4֡a@빌~($@ۋq
@Z1@e@;dZ@ce@e+@t@R@+@]cA@˒:*@s@*0@@K]@)@'RT@y@`A@R<6@_o@tj~@n@hr @!R<@&I@S&@@4n@}!.H@xF@v+jg@o@m(@irGE@dZ1@\>@V8YJ@TE@R䎊@Ks@GE84@A [7@>vȴ9X@<n.@;/V@9#w@7rG@64K@4m8@1o@-B@)lD@)y@(\)@%1@$/@ 'RT`@Q@_F@*0@n@Vu@
=p
@ݗ+@%2@n.@"@(@73@kP@SMj@ hۋ@쿱[W?@JL@	ԕ+@ڹ@䎊qj@ݗ+j@c	@D*@Ϫ͞@v_ح@)^	@ȴ9Xb@\(@n.@)@'0@'RT@zxl"h@.H@䎊r@%@Q@0
)@҉@4J@rGE9@I^5?@L_@~($x@q@p:@YJ@u%F
@     @|?@{lC@y"`@v_ح@sg@t!-w2@r䎊q@qu!S@nt@kC,z@iDg8~@dZ1@`A7K@^ ѷY@Y+@V8YJ@T`d@QX@OAs@M5Xy>@L_@IoiD@F-@B74@B74@B\(@As@@C@>6z@;dZ@6C-@1[W>6@*0
@(\)@&IQ@"3@쿱[W@}H@u%@e+a@PH@@@Ov_@*0@zG@sP@
@oiDg@o hی@g@s@-V@빌~($@~"@B@	ԕ+@,<@C,@M@
qu@ٳ|@`d@;dZ@cA \@ʌL_@ɺ^5?}@ȴ9Xb@)^@Ƨ-@ [7@~($@9XbN@-@{@Vϫ@1&y@jf@@1@}H@*0@ݗ+k@u@\(@N;6@7KƧ@~$t@}E@x73@sg@ql@q@kC]@eO
@bC,@_o@Z1'@QN;5@O
M;@P{@P|@PH@O
M;@K)^	@I@H@IoiD@F?@DS@Dg8}@Ca@N@;5Xy@73@6}Vl@4m8@3g	l@1&x@.zG@"wkQ@u"@4J@҈@n/@($x@_ح@A [@@C]@@@+a@e+@cA @(\@1'@֡af@䎊@ɅoiD@,zxl@|hs@'0@
qv@a@@6z@^@[@Xe,@$tS@0
)@u%F@e+a@_o@0
)@S&@u@ݗ+k@(@qiC@#@{J#9@y=b@rGE85@poiDg8@fA@b@4@^@_?@a@N@_;dZ@[q@W>6z@SMj@P{@L@HK]c@Ca@N@@n@=v@:S&@4J@0U2a|@.1@,zxl"@+a@@*͞&@'-@$/@$?@#S&@"`A@&L/{J@"3@U=@u%F@*0@@rGE9@
O;dZ@xF]@	7KƧ@Fs@+I@Q@?@+@%F
L@u!S@\@C,z@	ԕ+@@+a@Gz@ޞ@ݗ+j@(\@Q_@e+@sPH@l!-@ӎMj@;dZ@D@s@84֡@74@s@@ [7@n@ߤ?@n.@Y}@YJ@Xe@2X@U=@0
@&@L/{J@IQ@n.3@-w1@	@%@[@C,zx@u%@@@@ᰉ@tj~@ߤ?@L/{@ݗ+@?@˒:)@|hr@u\(@nc	@l[W?@l[W?@m(@l[W?@kC,z@jOv`@hۋq
@aGz@\]ce@["`B@Zc	@Xe+@S@N_o @K]cA@K)^	@IQ@Gy@Eo i@Em\@Fs@C@B&IR@@C@@n@@6@>6z@=<64@BZc@BZc@@n@<Z@;dZ@9D@3|@-B@*0
@&IQ@#wk@!R<6@ 'RT`@-V@ߤ@@S@vȴ@kP|@_o@0
)@$tS@tj~@@qi@@eO@oiDg@{J#9@n.@$tS@Vl!@!.H@!.H@#x@Q@~$@+jg@j~@g@u!S@t@.2@VϪ@ۋq
@@ۋq
@fA@fffff@ⶮ}Vm@ߤ?@"`B@Ϫ͞@fA@`d@_p@ɺ^5?}@K]c@K]c@E84@\N@|hs@BZc @@YJ@U2a|@jf@d7@@9@R<6@C,zx@,<@_o@@@@zG@nO@$tT@\(@~($x@Q@%2@u%F
@IQ@.H@~"@~\N<@}ڹZ@{~$@u!R@o@l[W?@iᰉ'@hۋq
@fA@ceO@a@N@_;dZ@\N;@Zc	@W&@R䎊@Ov_ح@O;dZ@P*0U@OAs@N;5X@L_@I@F-@E8YK@E@Em\@D*0@ATɅo@>ߤ?@=v@9XbM@8Q@43@2m\@.}Vl@-V@+jf@*0U2a|@%F
L0@"3@!.H@ ěT@쿱[W@IQ@u%F@_F@$tS@$/@tj~@
(@
ڹY@p:@_o@1&x@1&x@ݗ+@@S&@tj@Q@JM@o h@F]c@ ѷX@ 4m9@.H@H˒@~$@(@Fs@E@4֡a@!-w@Ov`@	k@A [@eO@eO@e+@;dZ@>BZ@y=c@sPH@֡af@t@fA@a@O@N;5@As@5Xy>@cA \@@]cA@n@@@š@g8}@74@@b@K]@dZ@S&@Q@4K@g	l@2X@\)@F
L0@?@o@u@C,zx@qu!@u%@PH@@sh@Fs@sP@hr @)^@!R<@@C%@'RTa@ݗ+@@~"@{~$@v!.I@v+jg@u%F
L@sMjO@r䎊q@q@o4֡a@lC@hۋq
@dqj@cS@bM@_?@^iB@\(\@ZQ_@Xe+@WsPH@T`d@SZ@Rm@P{@M%@Ks@IoiD@GzH@GE84@GzH@F]cf@E@D2W@B&IR@?@:~@8}H@7rG@6E@6E@64K@43@2W@1[W>6@-V@(@%1@!.H@	@U=@u"@,<@e+a@Xe,@sh@O
M@O
M@ݗ+k@:)y@!R<@
L/{@1&x@Fs@?@:S@Vl!@~$@+jg@iB@@.2@C]@g	@rGE@@@7@A [@A7K@ ѷY@ڹY@e+@֡af@R@
M;@@]cA@˒:*@@@y@
L/@m\@)^@]cf@]cf@Õ$@|hs@v@5Xy@S&@4֡b@C-@E@'0@3@g	l@-@
(@'RT@ ě@1@w1@0U2a|@x@`A@Q@S@u%@kP|@_o@@@@zG@zG@*0U2@S&@sP@S&@n@u@u@@rGE9@O;dZ@҈@qiC@k~(@p:@&I@M:@ѷX@     @.H@~$t@|hr@|PH@{lC@{m]@z>B@x-
@r ě@p:~ @o hۋ@l!-w@jOv`@h	ԕ+@e+a@cA [@bC,@b}Vm@bM@`d8@^҈p;@]+j@\?@UϪ͞@MjOv@JD@H@B74@ATɅo@A [7@@6@>ߤ?@=p
=@:^5?|@7Xe@6z@5?|h@333333@2W@2a|Q@2a|Q@2-V@1-@0 ě@/Vϫ@0'RT@.}Vl@,>B[@,q@'RT`e@$tSM@#n.3@#S&@#9@"wkQ@!R<6@!R<6@-V@qu!@u%@,<@PH@*0@@+J@@N@o @Mj@'/W@Vu@I^5?@
qiC@ݗ+@?@$/@ "@ ڹZ@ m]@ G{@ -
@ !.I@ !.@ Y|@ @ @ (@ fB@ 	ԕ+@ M@ iB@ >@ څݘ@ ק&@ `d@ ӎMj@ 䎊@ R@ ҈p:@ ҈p:@ H@ @ /{J#@ ʌL_@ ɅoiD@ ǮzH@ 8YK@ @ @ @ Zc@ ߤ?@ /V@ #w@ 4K@ O
M@ H@ U=@ w1@ U=@ V@ lD@ x@ F
L0@ .H@ wkP@ u%F@ e+a@ @@ @ R<6@ O
M@ *0U2@ ҉@ N;6@ -
q@ \(@ ߤ?@ xF]@  ѷ@ #@ +I@ YJ@ %2@ o hی@      @ ~$t@ ~\N<@ ~\N<@ ~($x@ |#x@ x73@ v+jg@ tD@ r䎊q@ pD@ poiDg8@ o@ nt@ mhr!@ lVϪ@ ix@ h>BZc@ g	k@ ffffff@ ceO@ be+@ ae@ _?@ ]cA @ [q@ WsPH@ UfA@ SMj@ Rm@ O;dZ@ Np:~@ L_@ K]cA@ H@ Fs@ E84֡@ D*0@ Dg8}@ A7Kƨ@ >6z@ <64@ <n.@ 84֡b@ 64K@ 5sg@ 4m8@ 4m8@ 333333@ 1&x@ 0{@ 0U2a|@ /r@ /{J#:@ /Vϫ@ ,zxl"@ (TɅ@ '/V@ '/V@ '/V@ '&@ '&@ %u@ 䎊r@ U=@ U=@ Ov_خ@ [@ C,zx@ Q@ _o@ PH@ Xe,@ +J@ Fs@ nO@ $tT@ \(@ !R<@ 
qu"@ '/@ #@ &I@ nP?.H?ڹZ?lC?>B?	k~?+?eں?Y|?䎊q?hr!?rGE?,<?`A7L?@4?u!?>BZ?fA?ԕ*1?ѷX?N;5?`A7?As?s?cA \?s?74?)_?)?4m?rG?E? ě?}Vl?͞&?-?S&?vȴ9?'RT`?wkP?=K^?0
)?O;d?$tS?$tS??$tS??:)y?qi?ڹY?ڹY?'RTa?+I?oiDg?@4n?}Vl!?xF]d?tSMj?oiDg8?m8Y?l"h	ԕ?kP{?fA?e+a?ceO?ae?_حV?^5?|?Vl!-?NT?GE84?C\N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@7@@7@@7@@7K]d@@7@@7fA@@7K]d@@7o @@7K]d@@7@@7fA@@7@@7@@7˒:)@@7@@7K]d@@7K]d@@7K]d@@7o @@7K]d@@7˒:)@@7K]d@@7o @@7o @@7@@7@@7K]d@@7K]d@@7K]d@@7K]d@@7K]d@@7@@7o @@7o @@7K]d@@7o @@7o @@7o @@7@@7o @@7o @@7@@7K]d@@7@@7@@7@@7K]d@@7@@7@@7K]d@@7o @@7o @@7@@7@@7@@7@@7o @@7@@7vȴ9@@7K]d@@7vȴ9@@7@@7o @@7@@73@@7[W>@@7[W>@@73@@7[W>@@7@@7o @@7@@7@@7@@7@@7@@@7rG@@7-@@7Vϫ@@7rG@@7+j@@8D*@@8D@@90
)@@9'R@@;nP@@<zG@@=ce@@>@@>Mj@@@$xG@@Bh	ԕ@@Dzxl"@@H-
@@K/V@@K
=p@@Lu"@@N}Vl@@Pu!@@Q*0U2a@@Rs@@R}Vm@@SC,z@@S*0U2@@T%1@@Tzxl"@@Uu@@UB@@V+J@@W!-w1@@W	k@@Y:S@@Z1'@@Zd7@@Zݘ@@ZsP@@\Ʌoi@@^_ح@@_)^@@_[W>@@aGz@@b ѷ@@d!-w2@@ie@@ka@N@@kwk@@k@@m-V@@o>6z@@qᰉ'@@tQ@@uE@@}%@@TɅ@@O
M@@iB@@$t@@U@@/V@@`A7L@@@@$tT@@/V@@F
L0@@˒:*@@iB@@\N@@%F
L@@A [@@[W?@@.H@@Dg8~@@u%@@K]@@Fs@@A@@ڹZ@@z@@҈p;@@x@@Fs@@E84@@E84@@>6z@@_o@@$xG@@F@@0
)@@@4n@@/V@@L_@@hr@@őhr!@@S@@Ϫ͟@@Fs@@o @@0
)@@	 @@ʩ@@u@@vȴ9X@@1@@lC@@     @@@@*0@@ěT@@ќu@@C%@@C%@@n.3@@j~#@@ԯO
M@@JM@@[@@fA@@ա@@՗+j@@ըXy=@@fffff@@֔Fs@@֫6z@@־ߤ?@@As@@ؐ-
@@	k@@\)@@@@4J@@x@@D@@~@@qu!@@1&y@@ܿ[W?@@2a|@@ݲ-V@@,@@ߚkP@@ߍO;d@@@@F]d@@@@ߧ&@@ߠ	k@@4m9@@ව4m@@C@@@@=b@@@@ⶮ}Vm@@G{@@'/@@qu!@@@@/{J#@@64@@\N@@J@@?@@]ce@@~($x@@*1@@?@@>B[@@>B[@@o i@@sh@@_o @@p:~@@,<@@滘@@x@@\(@@r@@@@
qu@@73@@U2a|@@eO@@hۋq@@hۋq@@oiDg8@@@@@$/@@*0U2a@@XbM@@u!S@@D@@iB@@e@@u%F@@T`d@@@@F]c@@eO@@m]@@C]@@I^5?@@q@@_@@e@@ce@@}H@@1@@oiDg@@5?|@@IQ@@@@BZc @@t@@KƧ@@zH@@Vϫ@@6@@4m9@@tj@@\)@@	k~@@rGE@@4J@@x@@|@@@@s@@:)y@@\(@@m@@6z@@n.3@@a@O@@\N@@tj@@C,zx@@zG@@qj@@@@@@$/@@!R<@@$/@@+jg@@;5X@@R<6@@p:~@@vȴ9X@@t@@Ϫ͟@@&I@@Ϫ͟@@x@@
=p@@'/W@@4֡a@@As@@\(@@lC@@3@@䎊r@@ ě@@F]d@@bM@@*0@@r Ĝ@@@@-
@@-
@@ѷX@@\)@@#w@@"`@@3@@M@@a|Q@@qiC@@L_@@@@C,z@@Z@@qu!@@U=@@A [@@!-w2@@9XbN@@]ce@@j~@@D@@E@@[@@2a|@@zxl"h@@ᰉ@@+jg@@5?|@@H@@YJ@@fffff@@,<@@&I@@C-@@.H@@U=@@lC@@|hs@@@@fA@A 6@A :~ @A >BZc@A >BZc@A :~ @A 73@A >BZc@A NU@A |@A d8@A )^@A e+@A `A7@A$/@ArGE@ArGE@A@A [7@Ab}@A2W@AY}@A&IR@AkP|@AwkQ@A)_@AeO@Aߤ@A|@As@AQ@Ag8}@Aq@A?@AN;@A_@ATɆ@Ae@AY|@Ap
=@AM:@AڹZ@A!R@A=K@A@A ѷY@A.2@A;5X@A%@At@A
=p@AE84@Ao@A{J#:@AkP@A3@A@A˒:)@A@ArG@A+j@A-@AF]d@A73@AbM@A-
@A)@Ae+@A$tT@A	k@A	_p@A	A [@A	u!S@A	7Kƨ@A	u@A	@A	@A	R@A
nO@A
L/{@A
͞&@A
C,@A
D@As@A6z@A)^	@A,zxl@A"`B@An.3@Aq@AƧ@AQ@A%2@A@AL_@A"h	ԕ@A(\@A,<@A,<@Am8@AZ@A
'0@A
V@A
Q@A
B@A
ce@A
M:@A
n/@A
8Y@A
b@A
,=@A
ڹ@A@A_ح@Avȴ9X@As@Aqi@A@A!.I@A@A)^@A+I@A;dZ@AO
M@AXe,@A|hs@A	k@A˒:)@ArG@A@A$xG@A:~ @AK]c@AbM@AYJ@AF@A	k@A@N@A&x@A:S@Ao hی@An.@AN;6@A@AOv`@AC\@A{m@A\(@AY@An@An@A)_@A ѷ@AI^@A	@AMjO@AdZ@Atj~@A~$@A:)z@Aߤ@Am]@Aa@@A
=p@Aݗ+k@A@AxF@AL_@AQ@A/{J#@Aq@A#@A1&@A֡a@AV@A(@A<64@A!R@Ash@Ab@AE@A_o @A
L/@A!R<@A5?|@A;5X@Ac	@A}Vl@A]cf@AFs@A!.I@A)^@A$tS@A'/W@A'/W@A.H@A.H@A>6z@AKƧ@AlC@A?@A@A˒:)@A@A;dZ@A@@ArG@A䎊r@A@A@A$xG@A*0@AK]c@AeO@AIQ@Ae+@A\)@A	k~@A#w@A4J@A0
)@A7KƧ@A7KƧ@A@A-w1@A@A@AiB@A	 @A#9@AQ_@A@4@A\(@A ě@A͞&@AC,@A҉@A=K^@Aa@N@Ajf@Ag	l@Ajf@AdZ@Ag	l@Ajf@Atj~@AxF]@A~$@A$@A@A~($@A|@A\N@A/{J#@AVϪ@Aj~#@Ao h@AC@A1&@AZ@AD@A'0@A[@A[@A[@A<64@Ace@A$/@A=K@A1@An/@A@AH˒@Aᰉ@AoiDg@A!.@At@A
L/@A1.@ABZc @A\N<@Ap:~@A@A-@A2X@At@AA@Aߤ?@AXe@AO
M@AU=@A\(@AlC@A&@A?@Ar@Avȴ9@AK]d@A@A-@A#@A      @A }H@A $xG@A 73@A A7K@A NU@A NU@A _F@A eO@A r Ĝ@A u!@A u!@A |@A YJ@A tj@A -
@A IQ@A -
@A 
=q@A IQ@A 
=q@A IQ@A IQ@A IQ@A U@A 9Xb@A 9Xb@A )^@A e+@A {@A!@A!	k~@A!&x@A!7KƧ@A!:S@A!:S@A!TɅo@A!|Q@A!oiD@A!o@A!o@A!R<6@A!u@A!n.@A!(@A!'RTa@A!n.@A!u@A!(@A!n.@A!(@A!'R@A!N;6@A!@A!-@A"s@A":)y@A"nO@A"~"@A"S&@A">B@A")_@A"fB@A"D@A#S&@A#҉@A#҉@A#)^	@A#Z@A#g	l@A#qu!@A#n.3@A#tj~@A#Q@A#eO@A#eO@A#wk@A#Ƨ@A#C]@A#@A#\N@A$xF@A$@A$ߤ@@A$!-w2@A$I^5?@A$`d@A$wkP@A$N;@A$S@A$O
M@A$j~@A$*0@A$@A$D@A%'0@A%!.H@A%!.H@A%`A7L@A%$/@A%!R@A%!R@A%O
@A%+j@A%U=@A%@A%@A%n/@A%Ϫ͞@A%b@A%ᰉ@A%C\@A%ڹ@A&t@A&
L/@A&4K@A&$/@A&($x@A&8YJ@A&BZc @A&H@A&H@A&R<6@A&Ov_خ@A&fffff@A&}Vl@A&O;@A&6z@A&ȴ9X@A&ߤ?@A&@A&"@A' hۋ@A' hۋ@A'v@A'!-w1@A'+I@A'.H@A'U=@A'eں@A'y@A'{J#:@A'{J#:@A'{J#:@A'@A'͞@A'+@A';dZ@A(F]d@A(6@A(*0U@A( ě@A(1&x@A(73@A(A7K@A(H@A(bM@A(u!@A(y=c@A(YJ@A(tj@A(@A(u%F@A(@A(9Xb@A(4m@A(p:@A(ۋq
@A({@A(PH@A)@N@A)+@A)#w@A)4J@A)N;5@A)[W>6@A)rGE8@A)|Q@A)u@A)X@A)_o@A)_o@A)ᰉ'@A)-@A*@A*&IR@A*0U2a|@A*6C@A*6C@A*@4n@A*GE85@A*Q_@A*kP|@A*@4@A*0
@A* ě@A*`A@A* ѷ@A*sP@A*䎊q@A*fB@A*~@A+S&@A+'/@A+PH@A+C,z@A+33333@A+C%@A+P{@A+W>6z@A+Z@A+jf@A+{J#9@A+@A+Q@A+eO@A+wk@A+a@O@A+
=p@A+g@A+A [@A,ߤ@@A,!-w2@A,%1@A,(\@A,2W@A,SMj@A,SMj@A,`d@A,q@A,o h@A,C@A,zxl"@A,O
M@A,[W?@A,@A,Z@A,>@A,E@A-K]@A-Q@A-+a@A-IQ@A-L_@A-S&@A-S&@A-\@A-ce@A-m\@A-sg@A-$/@A-hr!@A-=K@A-=K@A-%@A-1@A-@A-cA @A-?@A-S@A-oiDg@A._o @A.u@A..2@A.;5X@A.H@A.L/{J@A.YJ@A.p:~@A.s@A.p:~@A.IQ@A.@A.Fs@A.-@A.Q@A.&I@A.t@A.Fs@A.!.I@A/Ft@A/
M;@A/!-w1@A/.H@A/1@A/H˒:@A/O
M@A/eں@A/y@A/4m@A/@A/kP@A/ݗ+@A/kP@A/zH@A/r@A/@A/حV@A/䎊r@A0     @A0F]d@A0F]d@A0*0U@A0'RT`@A073@A0NU@A0_F@A0oiDg8@A0-
@A0-
@A0ěT@A0D@A0ѷX@A0ۋq
@A0e+@A0C@A0$tT@A1	k~@A1rGE@A1 [7@A1*0U2a@A10
)@A17KƧ@A1A [@A1JE@A1XbM@A1ae@A1^@A1rGE8@A1b}@A1o@A1@A1@A1R<6@A1u@A1'RTa@A1'R@A12W@A1@A1s@A1lD@A2n@A2s@A2䎊@A2Ov`@A2#9@A23@A23@A2:)y@A26C@A2C\@A2GE85@A2JL@A2Q_@A2h	ԕ@A2L_@A2wkQ@A2sP@A2ڹY@A2fB@A274@A2D@A2~@A2m\@A3҉@A3'/@A3s@A3C,z@A333333@A3C%@A3P{@A3W>6z@A3a@N@A3g	l@A3qu!@A3qu!@A3tj~@A3q@A3U=@A3q@A3E@A3~($@A3Z@A3Ƨ@A3|@A3a@@A3҈@A3s@A3s@A4ߤ@@A4!-w2@A4%1@A4"h	ԕ@A42W@A4SMj@A4VϪ@A4j~#@A4o h@A4C@A4*1@A43@A4@A4?@A4j~@A4Ʌoi@A4u"@A4hr@A4D@A4D@A4e@A4E@A5o i@A5o i@A5V@A5K]@A5V@A5*0@A5Q@A52a|@A5/w@A5/w@A52a|@A5/w@A52a|@A584֡@A5F
L0@A5ce@A5m\@A5ݗ@A5hr!@A5%@A51@A5-V@A5sh@A5\(@A5Ϫ͞@A5
qv@A5oiDg@A5E@A5C\@A6 ѷY@A6 ѷY@A6t@A6
L/@A6zG@A6u@A6@A64K@A6($x@A6;5X@A6Ov_خ@A6YJ@A6\N<@A6fffff@A6l!-@A6p:~@A6vȴ9X@A6%@A6qi@A6@A6-@A6ߤ?@A6@A62X@A6ȴ9X@A6t@A6t@A6+@A6+@A6+@A6]cf@A6Fs@A6Fs@A7 hۋ@A7Ft@A7@A7v@A7$tS@A7v@A7,@A7'/W@A71@A74֡a@A7H˒:@A7O
M@A7RT`e@A7\(@A7lC@A7y@A74m@A7	@A7@A7O;d@A7$tS@A7	k@A7?@A7&@A7zH@A7@A7Vϫ@A7+j@A8F]d@A8@A8
qu@A86@A8$xG@A8$xG@A8'RT`@A8*0@A8-
q@A8'RT`@A8A7K@A8K]c@A8U2a|@A8Xy=@A8eO@A8oiDg8@A8u!@A8n@A8u!@A8n@A8@A8-
@A8@A8IQ@A8-
@A8
=q@A8
=q@A8d8@A89Xb@A8@@A8p:@A8F@A8F@A8D@A8҈p@A8`A7@A8`A7@A84֡b@A8PH@A9 ѷ@A9@A9@A9 [7@A9#w@A9-w1@A9:S@A9A [@A9:S@A9N;5@A9TɅo@A9TɅo@A9e+a@A9hr @A9o hی@A9k~(@A9u!S@A9b}@A9|Q@A9~($@A9@A9n.@A9l@A9|@A9@A9_o@A9ᰉ'@A9.H@A9-@A:u%F@A9.H@A:n@A:I^5@A:I^5@A:Ov`@A:0U2a|@A:@4n@A:C\@A:C\@A:JL@A:Zc@A:nO@A:u%F
@A:xl"h
@A:~"@A:ݘ@A:\(@A:ᰊ@A:wkQ@A:S&@A:@A:>B@A:@A:@A: ě@A:g	@A:L/{@A:@A:>B@A:g	@A:}Vm@A:n@A:`A@A:c	@A:74@A:~@A;u%@A;'/@A;PH@A;	@A;	@A;"`B@A;)^	@A;&@A;)^	@A;/V@A;9@A;C%@A;MjO@A;W>6z@A;g	l@A;n.3@A;{J#9@A;~$@A;Q@A;q@A;Mj@A;Mj@A;:)z@A;:)z@A;A@A;A@A;q@A;q@A;@A;~($@A;a@O@A;5Xy@A;5Xy@A;
=p@A;Q@A;a@@A;Q@A;҈@A;A [@A;s@A<1&y@A<Q@A<%1@A<!-w2@A<,<@A<I^5?@A<I^5?@A<M:@A<PH@A<VϪ@A<g8}@A<m8@A<g8}@A<o h@A<3@A<O
M@A<@A<#x@A<@A<֡a@A<@A<JM@A<hr@A<hr@A<D@A<E@A=K]@A=K]@A=u@A=Q@A=5Xy>@A=?|h@A=F
L0@A=L_@A=O;dZ@A=O;dZ@A=O;dZ@A=S&@A=Y|@A=jOv@A=}H@A=ݗ@A=+j@A==K@A=Xy=@A=-V@A=n/@A=H˒@A=@A=cA @A=b@A=(@A=!.@A=E@A=oiDg@A=E@A=!.@A> ѷY@A>
(@A>@A>$/@A>Ov_@A>Ov_@A>!R<@A>.2@A>5?|@A>5?|@A>E@A>L/{J@A>YJ@A>_ح@A>l!-@A>p:~@A>}Vl@A>}Vl@A>qi@A>O;@A>,<@A>@A>-@A>}Vl@A>Q@A>m\@A>m\@A>t@A>҈p;@A>1@A>쿱[W@A>Fs@A>!.I@A>"@A>Fs@A?@A?@A?@A?
M;@A?Ft@A?Ft@A?
M;@A?)^@A?Xe@A?Xe@A?,@A?$tS@A?.H@A?4֡a@A?;dZ@A?H˒:@A?Xe,@A?Xe,@A?iDg8@A?o@A?|hs@A?4m@A?4m@A?&@A?@A?	k@A??@A?[W>@A?[W>@A?[W>@A?[W>@A?3@A?vȴ9@A?K]d@A?@A?@A?+@A?@A?fA@A?@A?-@A?-@A?rGE9@A@     @A@@A@	ԕ+@A@*0U@A@bM@A@6@A@ ě@A@*0@A@:~ @A@NU@A@Xy=@A@Xy=@A@eO@A@l"h	@A@r Ĝ@A@u!@A@|@A@YJ@A@n@A@@A@@A@-
@A@IQ@A@IQ@A@U@A@U@A@9Xb@A@9Xb@A@
(@A@)^@A@F@A@`A7@A@4֡b@A@\)@A@	k@A@$tT@AA@AA@AA@N@AA+@AA#w@AA0
)@AA-w1@AA0
)@AA:S@AAA [@AAGz@AAN;5@AAXbM@AAXbM@AAhr @AAk~(@AAo hی@AArGE8@AA@AA@AAo@AAR<6@AAu@AAo@AAR<6@AA@AAn.@AAn.@AA'R@AA@AAo@AAo@AA_o@AA_o@AA_o@AAԕ*@AAiB@AAᰉ'@AA@AA-@ABu%F@ABs@AB1'@ABOv`@AB&IR@AB&IR@AB-V@AB3@AB:)y@AB=p
@AB:)y@AB=p
@ABGE85@ABT`d@AB^5?|@ABh	ԕ@ABnO@AB@4@ABp:@ABᰊ@AB0
@AB>B@ABY@AB<64@AB͞&@AB͞&@ABsP@AB ѷ@ABG{@ABG{@AB䎊q@ABfB@ABD@ABm\@ACu%@AC҉@ACs@AC"`B@AC6z@AC9@AC=K^@ACJ#9@ACF]c@ACJ#9@ACMjO@ACP{@ACP{@ACS@ACS@ACW>6z@ACdZ@ACjf@ACtj~@AC{J#9@AC~$@AC@ACeO@ACq@ACMj@ACMj@AC$@ACA@ACߤ@ACߤ@ACwk@ACq@ACZ@AC6@AC5Xy@AC
=p@AC҈@AC%2@ACC]@ACg@ACC]@AC$@AC\N@AC@AC\N@ADn.@ADn.@ADJ@ADxF@ADxF@AD1&y@ADߤ@@AD@ADQ@AD!-w2@AD!-w2@AD(\@AD(\@AD2W@AD9XbN@ADC,zx@ADFs@ADI^5?@ADI^5?@ADM:@ADSMj@ADSMj@ADVϪ@ADZ1@AD`d@ADq@ADwkP@ADzG@AD?@ADC@AD쿱[@ADS@AD3@ADzxl"@ADTɆ@ADzxl"@AD1&@ADO
M@AD#x@AD#x@AD*0@AD@AD!-w@ADE@AE'0@AEu@AEV@AE[@AEqu"@AE!.H@AE(@AE5Xy>@AE<64@AE?|h@AEF
L0@AEB@AEIQ@AEF
L0@AEIQ@AEIQ@AEVl!@AEO;dZ@AEO;dZ@AEVl!@AE\@AE`A7L@AEsg@AE}H@AE$/@AE}H@AE$/@AE$/@AEM:@AEݗ@AEhr!@AE+j@AE=K@AE+j@AE@AEv@AE@AEU=@AE-V@AE\(@AE@AEH˒@AE\(@AE@AE@AE?@AES@AEoiDg@AEE@AEC\@AF ѷY@AFt@AF_o @AFzG@AF@AF@AFu@AF($x@AF1.@AF?@AFE@AFVu@AFfffff@AFvȴ9X@AFz@AFIQ@AF+J@AFqi@AF@AF+J@AFqi@AFqi@AF$t@AFaf@AFT@AF-@AFT@AF}Vl@AF'@AFߤ?@AFQ@AFߤ?@AF&I@AFA@AF+@AFC-@AF쿱[W@AG@AG
=p@AGFt@AG
M;@AG)^@AG
M;@AGXe@AG$tS@AG$tS@AG1@AG>6z@AGH˒:@AGKƧ@AGKƧ@AGO
M@AGRT`e@AGXe,@AG\(@AG_o@AGiDg8@AGo@AGiDg8@AGo@AGy@AG4m@AG&@AG&@AG{J#:@AGO;d@AGݗ+@AG$tS@AGkP@AGkP@AGkP@AG-V@AG?@AG3@AGr@AGvȴ9@AGvȴ9@AGK]d@AGK]d@AG˒:)@AGfA@AGحV@AGحV@AG@@AG@AG-@AG-@AG#@AG#@AG#@AHF]d@AH
qu@AHbM@AH ě@AH}H@AH$xG@AH*0@AH4m9@AH:~ @AH73@AH>BZc@AHH@AHNU@AHU2a|@AHQ@AHXy=@AHbM@AHl"h	@AHr Ĝ@AHr Ĝ@AH˒:*@AHn@AHYJ@AH'RT@AH-
@AH@AHIQ@AH@AHu%F@AHIQ@AHIQ@AHu%F@AHd8@AH4m@AH9Xb@AH)@AH
(@AH
(@AH
(@AH@@AHD@AHѷX@AHD@AHۋq
@AHۋq
@AH҈p@AHe+@AH@AHC@AH{@AH	k@AHPH@AI ѷ@AI ѷ@AIrGE@AI+@AI+@AI_p@AI [7@AI&x@AI7KƧ@AI:S@AIA [@AIDg8~@AIA [@AIDg8~@AIN;5@AIJE@AIQ@AIXbM@AI[W>6@AIe+a@AIe+a@AIhr @AIo hی@AIo hی@AI|Q@AI@AIb}@AI7Kƨ@AIoiD@AIoiD@AI~($@AI@AI~($@AIo@AI'RTa@AIB@AI|@AI^5?}@AIB@AIX@AID@AI2W@AI_o@AI@AI"`@AIᰉ'@AIᰉ'@AIᰉ'@AIe@AI>BZ@AI@AIe@AIR@AI@AIR@AI>BZ@AIlD@AI.H@AJ	 @AJu%F@AJn@AJ	 @AJ	 @AJOv`@AJOv`@AJ䎊@AJ#9@AJ-V@AJ0U2a|@AJ6C@AJ3@AJ=p
@AJ:)y@AJ@4n@AJGE85@AJGE85@AJGE85@AJW'@AJd7@AJqiC@AJu%F
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @rfffff@r     @r     @rfffff@r@r@rfffff@r33333@r33333@r@r@r     @r33333@r33333@r@r@r@rfffff@r     @r     @r@r@r33333@r     @r@r@rfffff@r33333@r@r33333@r     @r@r@r33333@rfffff@r     @r@r      @r@r     @rfffff@r     @r     @r@r     @r@r@r	@r33333@qfffff@qfffff@r     @rfffff@rfffff@r@r33333@r     @r@rfffff@r	@r33333@rfffff@r@r33333@r@rfffff@r      @r33333@qfffff@r@rfffff@r@r33333@rfffff@q@r@r@r33333@r     @q     @qfffff@qfffff@q33333@q33333@q     @q     @q33333@q33333@q     @q{33333@q&fffff@q9@qffffff@qvfffff@qq@qfffff@q     @qfffff@q񙙙@rfffff@r333333@rA@rC33333@r@     @r8     @r)@rC33333@rL@r@     @r9@r,@q33333@q33333@q     @qfffff@q@q33333@qfffff@qə@q@q@q33333@q33333@p@pfffff@p33333@p33333@p@p33333@p     @p@q@o33333@nL@n	@m33333@mi@m      @m33333@l@l33333@ly@l<@lfffff@kfffff@l	@l@l33333@jp     @jI@i@j33333@i@ifffff@h     @hS33333@hc33333@h\@hvfffff@hfffff@hfffff@i      @hP     @hfffff@h33333@h     @g33333@h33333@gfffff@h#33333@gI@g33333@g	@g33333@f     @f     @fp     @f     @e@ey@e0     @e9@eVfffff@e333333@eY@e&fffff@d@dp     @d      @cfffff@cfffff@c33333@c     @c@c33333@c@cs33333@c      @c@b33333@bfffff@b@b@b33333@b@bfffff@b     @b@     @b@aٙ@afffff@a@aVfffff@aL@afffff@`ٙ@`     @`P     @`33333@`	@_33333@_@_@_s33333@_33333@^fffff@^     @^l@^Ffffff@^,@^y@^@]     @\@\,@\L@[@\      @[@[@[fffff@[33333@[ٙ@[@[ffffff@[ffffff@[S33333@[fffff@Z     @Z,@Y@Y@Yy@YS33333@Y      @Y      @Xfffff@X@X@Xy@Xs33333@X     @Xffffff@W33333@Wٙ@Wfffff@Wfffff@W33333@W     @Wy@W9@W&fffff@Wfffff@Vy@V9@U@U@Us33333@UL@U33333@T@U      @T33333@TS33333@T@S33333@S     @S33333@S     @Sfffff@SY@S333333@R@Rfffff@Rfffff@Rfffff@R@R9@R      @R33333@Q33333@Q33333@Q33333@Q33333@Qfffff@Qfffff@Qffffff@Q`     @Q,@Q333333@Q@     @Q333333@Q,@Q&fffff@QFfffff@Q33333@P33333@Pfffff@P`     @Pl@Py@PS33333@PFfffff@PY@PS33333@P333333@PS33333@P&fffff@P&fffff@P,@PFfffff@P      @O33333@P33333@O@P33333@Offfff@O@Os33333@O33333@O     @Oٙ@O@N33333@Nfffff@O@N@O@     @N33333@O      @Ns33333@M33333@M@M@Mfffff@Ms33333@Mffffff@M333333@M333333@L33333@M@M@L     @L     @L&fffff@K33333@Ls33333@L     @LL@LL@Kfffff@K     @Ks33333@K@Kffffff@K&fffff@K&fffff@K@J33333@K&fffff@J33333@JL@J     @Jfffff@Js33333@J@Iٙ@J@J@Is33333@J      @Iٙ@I     @J&fffff@I     @I33333@Is33333@I     @Iffffff@Ifffff@I&fffff@IY@I@     @I@     @I      @H33333@I&fffff@Hٙ@Gfffff@HL@G33333@G@Fٙ@F     @Fffffff@E33333@Fٙ@Ffffff@FY@Efffff@F&fffff@Efffff@F@Efffff@EY@E@Es33333@E@EL@E     @E333333@D33333@EL@D@DY@D@D&fffff@C33333@Cfffff@C@D@C     @C@Cs33333@C33333@C33333@C33333@C33333@Ds33333@C     @C@Cfffff@Cfffff@Cs33333@D     @B33333@Cs33333@C&fffff@C      @B@C@CL@C@Afffff@B      @B      @As33333@B      @A@Afffff@A@A33333@A     @BL@BL@B      @A@Afffff@BY@A33333@A     @AY@B      @Afffff@A33333@A@B@A&fffff@A@Afffff@A&fffff@AY@AY@A@AL@@     @A@     @Affffff@@33333@A      @@fffff@@     @@33333@@L@@@@s33333@@@@ffffff@@fffff@@@@Y@@Y@@Y@@s33333@@&fffff@@@?     @@@@ffffff@?fffff@@@?      @?fffff@>ffffff@>fffff@=fffff@?ffffff@>fffff@>@>fffff@=L@=@=L@=fffff@<333333@=ffffff@<fffff@=@<L@:@=@<L@;ffffff@;fffff@;fffff@;@;33333@;     @;@;fffff@;fffff@;fffff@;      @;     @;@;@;@;      @;@;L@:fffff@;@:fffff@:L@:ffffff@9@:@:     @9ffffff@:33333@9@8@:      @9      @9@9fffff@7ffffff@933333@9@733333@9333333@9ffffff@9fffff@8      @8fffff@8@9333333@7fffff@8      @8ffffff@8@8     @8L@8      @7@7fffff@8ffffff@8ffffff@8ffffff@8ffffff@7@7@6fffff@8     @733333@7ffffff@8@7@8@8@8@7@8L@7L@7@6@9333333@7L@633333@7333333@7      @733333@6@6fffff@633333@6@633333@6fffff@7333333@7ffffff@6fffff@7333333@5@7L@7      @6fffff@6@6fffff@6fffff@6fffff@6@6@6@6     @4333333@7     @6@7@6L@6L@7L@7ffffff@6@8L@7ffffff@6@7L@7L@7@9333333@9      @8@8@8fffff@8L@9L@8@8@8      @7fffff@7fffff@7L@7@7      @7@733333@7@7@733333@733333@7     @7fffff@7@7L@6fffff@7333333@6     @9     @6@5     @8@5ffffff@7      @6ffffff@8@5@7ffffff@7     @6333333@5ffffff@633333@7333333@6@6@6     @6@7      @7@6@6@733333@7L@7      @7      @7fffff@8      @7@733333@7333333@7L@7L@7L@7L@7ffffff@7333333@7L@7L@6333333@6@733333@5fffff@8      @6fffff@7@7@7@6@7ffffff@7@7      @6@7     @7      @7333333@6fffff@6fffff@7      @6L@7333333@6@7@6@6@6fffff@633333@7L@633333@633333@633333@6@7@6     @6@6ffffff@6333333@633333@6@8L@5@6333333@5fffff@6@6L@6ffffff@6333333@533333@6333333@5@4@633333@5333333@533333@6@4@5@6ffffff@5fffff@5fffff@5fffff@5fffff@6333333@6333333@6L@5fffff@5     @6fffff@7      @6      @6     @6L@6     @7      @5@6fffff@7ffffff@6333333@6     @5fffff@7@6333333@6333333@6@6@6@6333333@5@6@633333@6      @6      @7      @5fffff@6@6333333@6@5fffff@5fffff@6333333@5@6ffffff@6333333@6      @6333333@5fffff@5@6@6@433333@6      @5@533333@5@5@4fffff@533333@5333333@5     @5@4@5     @4@5     @5      @4      @5@4      @5L@4fffff@5@5@5@5@5     @4fffff@5@5@5@5@4333333@6      @4L@5333333@5      @4      @4     @4L@4      @4      @4@4@4     @4     @4@4     @4L@5fffff@6333333@4     @3L@5fffff@2@433333@4@4ffffff@4ffffff@3@3@4ffffff@333333@4@4@5      @3fffff@4@4      @3fffff@4L@4333333@333333@3@4L@2L@3@4     @3L@333333@333333@3fffff@3@3fffff@4fffff@3ffffff@3@3fffff@4ffffff@3@3@3     @2@3fffff@3@3@3@3@3L@3fffff@3@3333333@4     @3      @4      @2@3      @3333333@2     @2     @233333@2fffff@1333333@4      @1L@0ffffff@2@2L@2     @133333@2L@2333333@2L@1      @1@1ffffff@233333@1333333@1fffff@.@2333333@0fffff@/333333@1fffff@1     @0fffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@1ffffff@2ffffff@4      @1fffff@1fffff@2     @1ffffff@2L@3333333@1@1333333@0fffff@1333333@1333333@/      @0@0@0L@/333333@.@,@,@-@-@-333333@,333333@.@-333333@,333333@-333333@-@-@-@,@-333333@.@-ffffff@+@-@.333333@-      @.333333@*@-333333@,ffffff@-333333@-@,333333@-333333@-333333@,@,@+@.      @,      @.ffffff@+      @,@,@,@,333333@,ffffff@+333333@-      @+      @*ffffff@-333333@*@.@+@+ffffff@*ffffff@*333333@+@+333333@&@*ffffff@*@+@)@,      @+@,      @(@,      @%333333@.333333@+ffffff@-333333@*333333@+333333@)@+@*@+333333@*      @,333333@-333333@)333333@/      @+@)@,333333@+@*@,      @(@/@+@+@,@*@-@*@+@+@+333333@,333333@*      @+@-      @'333333@0333333@+@)@-      @,ffffff@+      @+ffffff@/333333@-333333@-333333@+ffffff@.@+@/333333@,333333@)      @.      @/333333@.@,333333@.@-@2@,@0L@/@0333333@/      @/      @0fffff@1      @.      @0fffff@0     @1      @1     @1fffff@2@1333333@1fffff@2fffff@1fffff@2@233333@1fffff@1     @2@0@2     @1L@1@0     @2L@2      @2      @133333@4      @2@1fffff@4L@3     @2@2fffff@3@3fffff@3@4333333@3@3     @5      @3@4L@5@5@4     @3fffff@4fffff@5      @3ffffff@4L@5@3fffff@533333@3333333@3ffffff@5ffffff@4@5333333@4      @3     @2@3@3fffff@3      @3@4333333@333333@3ffffff@4@4     @4      @4333333@5     @4@4     @4      @5     @4     @433333@4fffff@5      @4     @5L@5333333@433333@5      @4     @5      @5333333@5333333@5@5333333@4fffff@533333@4fffff@5     @5@3@5fffff@433333@5333333@5     @5@4fffff@7      @4@5     @5      @5ffffff@4fffff@533333@5fffff@4@6333333@4L@5333333@533333@4fffff@5@4fffff@533333@5     @5@5@6      @533333@5333333@5L@6@5     @5     @5     @5     @5     @5     @5     @5L@533333@5@5@5@5@5ffffff@5      @6L@5ffffff@5     @5fffff@5@5ffffff@5fffff@5     @3@7333333@5@5@5ffffff@4@6@5@4@633333@5ffffff@4     @6      @5L@6      @5L@5@5ffffff@5fffff@5ffffff@5@6ffffff@5      @5ffffff@4fffff@6L@6      @533333@4@5@7@5333333@7ffffff@5ffffff@5fffff@5@5@533333@533333@533333@533333@5@5fffff@5@5ffffff@5@5     @6333333@5ffffff@5@5fffff@533333@5fffff@5fffff@533333@5fffff@5     @5     @6333333@5fffff@5fffff@5fffff@6333333@6@6ffffff@5fffff@6@6@5fffff@5     @6333333@6fffff@4ffffff@5fffff@5@5fffff@633333@6@6      @6L@6333333@6L@6ffffff@6333333@6     @6333333@6     @6      @6333333@6L@6fffff@6      @6     @6@5fffff@7      @7     @6333333@6fffff@6@7333333@6     @6     @6fffff@6      @733333@6ffffff@633333@6fffff@6L@6fffff@6@6ffffff@7      @5     @7      @633333@7@6L@7L@6L@6@6@6@633333@633333@8      @533333@7333333@733333@7     @5fffff@7@6     @733333@6333333@6ffffff@6fffff@6fffff@7L@7333333@6fffff@6@7     @6fffff@7333333@9@5L@8333333@7     @8@7      @7      @7333333@7@6     @8     @6ffffff@733333@733333@7L@5@733333@8@7333333@7333333@733333@733333@7L@7fffff@7     @7fffff@7     @7     @7     @7     @8      @7     @733333@8L@7     @8fffff@8ffffff@7@7      @8ffffff@8     @7@8     @8ffffff@7L@8ffffff@8      @9@8333333@7fffff@8333333@7fffff@9      @9      @7@8     @9ffffff@8     @8@8@9      @9ffffff@9@8333333@9L@9333333@8@:ffffff@9ffffff@:@;333333@933333@;L@9     @:      @;      @:@9@=@:333333@9@:@;L@:@:@:@:fffff@:     @:     @:33333@:L@:     @:@;ffffff@:     @:L@;     @;@:@;ffffff@;L@:@;ffffff@;@;33333@:fffff@;ffffff@;      @;ffffff@;ffffff@;@;@;@;     @;ffffff@<     @<L@;ffffff@=ffffff@=333333@;@>@<@<@=      @<333333@<ffffff@=L@=L@<333333@=ffffff@=@=L@=@<ffffff@<@=     @=fffff@<@>      @>L@=33333@=ffffff@=ffffff@=ffffff@=33333@?@<      @=     @=fffff@=@@@     @<333333@>333333@?L@>@>      @=@?fffff@=@>     @?fffff@?@>     @<fffff@?     @@@?@=      @?fffff@?@?     @?L@?ffffff@?@?@@@     @>L@@@?333333@?333333@?333333@?     @>fffff@?fffff@@33333@?333333@?333333@@@@@@s33333@@     @@@@333333@?fffff@@@@@?     @@@@&fffff@@Y@@@A@?L@A&fffff@@333333@@@     @@Y@@fffff@@     @@33333@@@@ffffff@@33333@@33333@@33333@@@@@B@@@A@     @A33333@@     @@ٙ@@ٙ@As33333@A      @B&fffff@A@Aٙ@@ٙ@Affffff@A33333@AY@A@A      @B&fffff@Aٙ@BY@B@A@B     @Affffff@B@     @B@A     @Afffff@Aٙ@Aٙ@B@B      @B@BL@Bffffff@B@B&fffff@B@B333333@A@B333333@C      @A@     @C@A33333@B33333@BY@Aٙ@A33333@B@C&fffff@A33333@Bfffff@C      @Bffffff@Bffffff@B33333@C&fffff@BY@CL@B     @B@Bfffff@Cfffff@Bffffff@C@C@     @B@C333333@Cs33333@C&fffff@C&fffff@C333333@Cffffff@D@CL@C&fffff@B33333@Cfffff@C@     @C33333@D     @C@C333333@E     @D     @D@Cs33333@C33333@Cs33333@C@C@C33333@C     @Ds33333@Cfffff@Cٙ@E333333@D@D@     @D&fffff@D@Dffffff@D      @DY@E333333@C33333@D@D@DY@Dfffff@D33333@C     @D@E     @D     @D@D     @DY@FY@D@D     @EL@E@E      @EL@Dٙ@Dffffff@F&fffff@EY@E     @E&fffff@E&fffff@Effffff@E@Eٙ@E@     @F      @F      @E@FY@E33333@E@Efffff@Efffff@F@Eٙ@Efffff@F      @F@FY@F      @F@     @F@Dٙ@F     @F     @F333333@F333333@FY@F     @F     @G@Fffffff@F     @F@F     @F@G@Ffffff@G&fffff@G@G@     @Ffffff@GY@G@F33333@F33333@G333333@G      @Gfffff@G333333@GL@GY@HL@G333333@G@Gfffff@G@G     @G     @G@H@G33333@G@G@G     @H@     @H      @G     @G     @G     @G           @Gs33333@H@H      @HL@G@G33333@H@H333333@H     @G@HY@H     @HY@HY@HY@H      @I      @HY@H@H@I     @G33333@I&fffff@H     @H     @H@Hfffff@Hfffff@I@I333333@I@H33333@I@Gٙ@H33333@H33333@I@IY@JL@Hٙ@Ifffff@I@Is33333@J&fffff@I@     @I     @I@I33333@I@Ifffff@H@J333333@Iٙ@I@I@I@H     @Iٙ@I     @J@I     @Iٙ@J&fffff@J@I     @Jٙ@J@J      @I&fffff@J      @Iٙ@Ifffff@Jfffff@Ifffff@J@     @J     @Jٙ@Jffffff@H     @K      @I@J@K@     @JL@J     @J@Jfffff@K@J@J     @Jfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ?I^5??x?x?I^5??S?Q?Q? ě?j~"?j~#?vȴ9X?vȴ9X?Vt? ě?\(?;dZ?|hr?KƧ?\(?lC?E?-?7KƧ?vȴ9?vȴ9X?vȴ9X?~"?1&y?+?nP?/w?      ?nO?Gz?j~#?n?nP?tj?-V?QR?QR?M?r ě?/w?
=p?+?(\)?bM?-V?lC?lC?(\)?5?|h?Vt?zG?vȴ9X?j~"?|hr?zG?n?vȴ?nO;??vȴ9?1&y?tj~?Z1'?񙙙?5?|h?
=p?홙?Q?tj?E?zG?E?      ?zG?bM?xF?1&??|hs?Vt?o?tj~?"`?XbM?j~"?;dZ? ě?XbM?\(?߾vȴ9X?+?l?tj?tj~?7KƧ?p
=q?ɺ^5?|?tj??|hs?I^5??n?"`?n?(\)?lC?$/?Q?lC?lC?$/?QR?(\)?hr Ĝ?p
=q?p
=q?hr!?p
=q?Gz?^5?|?lC?lC?bM?tj~?+J?lC?lC?tj~?E?lC?lC?vȴ9?+?dZ1?lC?lC?lC?dZ1?S?XbM??E?dZ1?lC?+J?1&?QR?lC?lC?vȴ9?O;dZ?^5?|?XbM?"`A?+?+?"`B?-V?lC?lC?hr!?lC?lC?E?1&?lC?lC?E?"`A?Gz?XbM?lC?lC?lC?lC?lC?lC?lC?/v?p
=q?lC?E?"`A?1&y?1&y?lC?Q?/v?-V?lC?lC?S?lC?5?|h?lC?"`?"`?lC?lC?lC?lC?(\)?j~"?hr!?lC?;dZ?lC?lC?lC?lC?lC?lC?/v?(\)?p
=q?lC?lC?lC?lC?lC?lC?-V?nP?      ?vȴ9X?lC?lC?j~"?      ?1&y?lC?(\)?/v?vȴ9X?-V?lC?lC?lC?lC?p
=q?j~"?lC?-V?5?|h?vȴ9X?-V?-V?hr!?"`?lC?lC?lC?^5?|?1&?E?lC?lC?p
=q?|hr?Q?5?|h?vȴ9X?lC?vȴ9X?lC?p
=q?-V?E?lC?lC?p
=q?-V?p
=q?      ?j~"?1&y?-V?lC?lC?-V?lC?Q?      ?1&y?lC?lC?lC?lC?vȴ9X?/v?      ?E?lC?/v?E?j~"?p
=q?/v?      ?p
=q?vȴ9X?hr!?lC?5?|h?E?/v?;dZ?      ?      ?hr!?/v?hr!?E?lC?lC?/v?|hr?/v?hr!?hr!?"`?lC?lC?lC?5?|h?A7Kƨ?lC?lC?lC?hr!?p
=q?lC?Q?lC?lC?lC?lC?lC?E?lC?lC?vȴ9X?hr!?Q?lC?hr!?E?lC?/v?lC?lC?lC?vȴ9X?vȴ9X?-V?-V?lC?lC?lC?/v?      ?5?|h?lC?lC?lC?lC?"`?      ?lC?hr!?      ?
=p?vȴ9X?E?1&y?hr!?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?;dZ?lC?lC?E?lC?lC?lC?lC?Q?lC?lC?-V?hr!?p
=q?lC?-V?E?      ?      ?(\)?vȴ9X?lC?|hr?|hr?lC?lC?lC?|hr?      ?/v?E?vȴ9X?E?/v?"`?1&y?-V?lC?lC?lC?lC?-V?hr!?lC?;dZ?p
=q?      ?
=p?j~"?lC?E?lC?"`?Q?lC?
=p?bM?vȴ9X?lC?lC?E?      ?hr!?"`?      ?j~"?|hr?lC?lC?lC?lC?/v?-V?lC?lC?Q?(\)?lC?;dZ?lC?lC?lC?lC?"`?      ?1&y?lC?-V?E?E?lC?      ?      ?      ?hr!?;dZ?      ?"`?p
=q?j~"?lC?lC?1&y?"`?;dZ?(\)?j~"?Q?lC?lC?lC?/v?1&y? ěT?lC?E?nP?1&y?-V?-V?vȴ9X?E?1&y?vȴ9X?lC?lC?lC?"`?lC?lC?(\)?vȴ9X?lC?1&y?      ?/v?1&y?-V?p
=q?Q?      ?hr!?lC?j~"?      ?p
=q?lC?lC?      ?vȴ9X?lC?-V?lC?|hr?      ?Q?/v?"`?lC?vȴ9X?-V?vȴ9X?lC?lC?lC?5?|h?lC?      ?"`?E?lC?p
=q?/v?`A7L?      ?lC?lC?lC?lC?E?p
=q?j~"?lC?(\)?;dZ?lC?/v?      ?      ?;dZ?/v?5?|h?lC?lC?lC?1&y?-V?1&y?p
=q?lC?|hr?5?|h?5?|h?j~"?      ?vȴ9X?lC?lC?lC?lC?lC?vȴ9X?vȴ9?/v?      ?lC?hr!?5?|h?5?|h?p
=q?lC?lC?lC?Q?      ?Q?      ?      ?E?hr!?      ?lC?vȴ9X?hr!?lC?lC?|hr?lC?hr!?p
=q?;dZ?-V?      ?      ?5?|h?lC?lC?lC?5?|h?vȴ9X?lC?lC?lC?lC?      ?      ?7KƧ?`A7L?lC?(\)?      ?"`?lC?"`?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?vȴ9X?`A7L?/v?E?lC?vȴ9X?"`?lC?5?|h?E?ěS?      ?;dZ?lC?lC?lC?E?5?|h?      ?      ?      ?&x?j~"?      ?      ?lC?lC?;dZ?1&y?      ?      ?      ?p
=q?E?/v?&x?-V?lC?vȴ9X?vȴ9X?lC?lC?vȴ9X?/v?p
=q?/v?lC?lC?|hr?hr!?-V?lC?/v?|hr?p
=q?-V?Q?      ?      ?(\)?lC?
=p?ěS?(\)?lC?vȴ9X?(\)?lC?E?      ?      ?lC?/v?j~"?lC? ěT?ěS?5?|h?lC?E?lC?lC?j~"?p
=q?lC?"`?E?vȴ9X?      ?5?|h?p
=q?/v?      ?vȴ9X?vȴ9X?lC?(\)?      ?p
=q?      ?      ?(\)?Q?hr!?vȴ9X?1&y?-V?hr!?lC?lC?vȴ9X?lC?lC?vȴ9X?lC?;dZ?p
=q?lC?E?      ?      ?      ?      ?      ?1&y?lC?"`?      ?lC?;dZ?lC?Q?vȴ9X?
=p?lC?lC?lC?hr!?(\)?lC?|hr?lC?lC?lC?lC?vȴ9X?lC?(\)?vȴ9X?lC?lC?Q?lC?      ?/v?vȴ9X?5?|h?vȴ9X?hr!?E?lC?5?|h?lC?lC?lC?j~"?Q?lC?hr!?      ?      ?;dZ?5?|h?hr!?      ?E?lC?;dZ?
=p?lC?;dZ?      ?      ?hr!?lC?Q?-V?vȴ9X?lC?E?
=p?lC?lC?lC?vȴ9X?      ?Q?lC?"`?Q?      ?7KƧ?ěS?"`?lC?lC?/v?      ?      ?p
=q?      ?hr!?lC?Q?      ?hr!?lC?lC?"`?      ?      ?5?|h?/v?5?|h?bM? ěT?(\)?vȴ9X?5?|h?(\)?      ?5?|h?p
=q?      ?|hr?lC?lC?1&y?      ?      ?      ?lC?lC?"`?j~"?vȴ9X?-V?p
=q?vȴ9X?(\)?|hr?p
=q?p
=q?lC?lC?-V?vȴ9X?lC?lC?      ?(\)?Q?(\)?lC?lC?E?lC?bM?$/?(\)?vȴ9X?lC?(\)?      ?      ?      ?-V?lC?-V?vȴ9X?5?|h?lC?&x?      ?lC?lC?E?      ?      ?-V?"`?lC?lC?"`?      ?Q?-V?      ?lC?lC?lC?j~"?
=p?lC?j~"?/v?lC?lC?lC?/v?      ?lC?lC?vȴ9X?p
=q?lC?lC?(\)?nP?n?(\)?      ? ěT? ěT?vȴ9X?hr!?|hr?(\)?lC?lC?lC?lC?5?|h?;dZ?p
=q?      ?      ?lC?(\)?nP?-V?;dZ?lC?E?      ?p
=q?(\)?      ?      ?      ?      ?1&y?lC?lC?lC?|hr?A7Kƨ?p
=q?vȴ9X?vȴ9X?lC?lC?lC?/v?j~"?      ?5?|h?hr!?vȴ9X?lC?lC?lC?lC?vȴ9X?      ?(\)?j~"?E?lC?      ?      ?p
=q?-V?      ?      ?      ?lC?1&y?      ?vȴ9X?(\)?      ?vȴ9X?5?|h?      ?      ?-V?lC?lC?p
=q?-V?p
=q?-V?Q?/v?Q?|hr?lC?lC?lC?lC?lC?"`?      ?p
=q?"`?(\)?;dZ?|hr?lC?      ?p
=q?lC?lC?lC?vȴ9X?      ?5?|h?lC?p
=q?      ?      ?      ?      ?vȴ9X?(\)?lD?      ?      ?      ?1&y?lC?lC?E?      ?vȴ9X?5?|h?      ?1&y?lC?hr!?      ?      ?E?vȴ9X?hr!?lC?lC?|hr?      ?      ?      ?-V?lC?lC?5?|h?Q?lC?p
=q?|hr?lC?E?1&y?      ?vȴ9X?E?`A7L?(\)?      ?5?|h?lC?lC?p
=q?p
=q?lC?lC?lC?lC?lC?5?|h?hr!?Q?      ?5?|h?lC?lC?lC?lC?lC?lC?Q?vȴ9X?lC?&x?      ?      ?1&y?E?E?E?      ?-V?E?vȴ9X?1&y?      ?j~"?5?|h?/v?Q?      ?|hr?lC?"`?      ?Q?/v?      ?p
=q?lC?lC?-V?p
=q?      ?      ?p
=q?Q?(\)?vȴ9X?lC?1&y?vȴ9X?-V?|hr?5?|h?5?|h?"`?vȴ9X?5?|h?-V?/v?hr!?lC?/v?"`?lC?1&y?vȴ9X?lC?Q?vȴ9X?lC?lC?      ?1&y?`A7L?/v?hr!?"`?-V?/v?vȴ9X?lC?;dZ?vȴ9X?lC?;dZ?      ?hr!?Q?vȴ9X?/v?p
=q?5?|h?1&y?lC?lC?lC?5?|h?lC?lC?lC?"`?lC?lC?lC?lC?lC?lC?Q?E?1&y?lC?lC?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?      ?Q?lC?lC?vȴ9X?1&?-V?;dZ?"`?5?|h?lC?p
=q?/v?lC?vȴ9X?lC?j~"?5?|h?/v?E?lC?lC?lC?      ?      ?p
=q?Q?lC?A7Kƨ?lC?lC?lC?;dZ?      ?lC?vȴ9X?hr!?-V?lC?lC?lC?lC?j~"?E?lC?lC?lC?E?lC?lC?      ?;dZ?lC?lC?;dZ?hr!?      ?      ?5?|h?lC?lC?lC?Q?|hr?lC?lC?lC?5?|h?vȴ9X?-V?      ?|hr?1&y?      ?;dZ?lC?lC?lC?lC?"`?p
=q?-V?E?lC?1&y?hr!?E?lC?lC?lC?lC?lC?lC?;dZ?lC?lC?j~"?      ?      ?vȴ9X?p
=q?E?lC?hr!?E?      ?lC?1&y?Q?lC?"`?vȴ9X?"`?Q?lC?vȴ9X?lC?lC?lC?1&y?-V?lC?lC?(\)?vȴ9X?p
=q?hr!?j~"?      ?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?j~"?      ?(\)?hr!?      ?vȴ9X?lC?lC?E?|hr?lC?Q?j~"?lC?lC?lC?lC?5?|h?"`?lC?lC?lC?lC?vȴ9X?lC?vȴ9X?E?p
=q?E?-V?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?"`?      ?1&y?lC?/v?hr!?j~"?Q?p
=q?      ?      ?      ?;dZ?lC?|hr?/v?lC?lC?lC?lC?lC?lC?lC?      ?(\)?lC?      ?|hr?lC?1&y?vȴ9X?j~"?E?      ?-V?lC?hr!?vȴ9X?lC?lC?      ?-V?vȴ9X?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?5?|h?(\)?(\)?hr!?lC?lC?E?j~"?lC?lC?lC?lC?lC?lC?-V?lC?-V?-V?1&y?lC?lC?E?      ?lC?lC?lC?lC?lC?lC?-V?p
=q?lC?vȴ9X?lC?lC?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?/v?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?lC?lC?-V?lC?lC?lC?;dZ?(\)?lC?lC?lC?hr!?Q?lC?lC?lC?p
=q?j~"?E?lC?lC?/v?5?|h?(\)?|hr?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?"`?|hr?lC?Q?E?lC?lC?lC?lC?-V?E?A7Kƨ?lC?lC?lC?lC?lC?lC?hr!?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?lC?"`B?vȴ9?lC?lC?lC?lC?lC?Q?lC?-V?lC?lC?lC?lC?lC?lC?lC?;dZ?lC?lC?lC?"`?lC?E?/v?      ?      ?p
=q?Q?(\)?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?1&y?/v?lC?(\)?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?-V?      ?+J?lC?E?E?lC?(\)?/v?lC?A7Kƨ?"`?lC?lC?-V?Q?lC?lC?E?lC?lC?lC?lC?lC?lC?lC?-V?-V?hr!?lC?"`A?E?lC?lC?lC?lC?lC?vȴ9X?lC??1&?lC?5?|h?j~"?p
=q?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?p
=q?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?vȴ9X?p
=q?lC?lC?hr!?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Gz?lC?lC?lC?lC?lC?j~"?      ?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?^5?|?hr!?lC?/v?XbM?lC?QR?lC?lC?j~"?5?|h?lC?lC?lC?lC?lC?lC?lC?lC?1&?lC?lC?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?lC?XbM?+I?lC?lC?lC?lC?lC?lC?lC?+?Q?lC?+J?1&?lC?lC?lC?lC?vȴ9?tj~?lC?lC?lC?lC?+J?lC?-V?lC?lC?lC?lC?5?|h?j~"?lC?lC?lC?+J?lC?S??lC?lC?lC?j~"?-V?p
=q?lC?lC?lC?lC?E?vȴ9?lC?lC?(\)?-V?lC?Gz?"`B?lC?E?"`A?S?+J?lC?lC?lC?lC?1&y?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?"`B??lC?lC?"`?j~"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@&@Cfffff@M33333@O@O33333@Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@Pfffff@P@P@P@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P      @P@P@P@P      @P&fffff@P333333@P,@P,@P9@P9@P@     @P@     @P@     @PFfffff@PFfffff@PFfffff@PFfffff@PFfffff@PFfffff@PFfffff@PFfffff@PL@PS33333@PS33333@PY@Pffffff@Ps33333@P     @P     @P@P@P     @Pfffff@P@Pfffff@P@P@P33333@P33333@Pٙ@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P     @P     @Pfffff@P@P@P@P@P@P@P@P@P@P@P@P     @Pfffff@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P@P@Pfffff@Pfffff@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@Q      @Q      @P@P33333@Q      @Qfffff@Qfffff@Qfffff@Q@Qfffff@Q      @Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q@P     @Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Qfffff@Q@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q      @Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q@Q      @Q      @Q@Q@Q@Q      @Q@Q@Q      @Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q@Q      @Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q      @Q      @Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q@Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q      @Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@P@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     P26                                     5                                       BG3P: