CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P12    CAST_NUMBER       2      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:41.041094Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R         data_max      @R         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >p  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @H        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >p  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        ,   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?+J   data_max      @ G_o   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >p     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        8   salinity                	long_name         salinity   units         PSS-78     data_min      @@6 ѷY   data_max      @AKU=   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >p    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       GD   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @"   data_max      @r;33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        >p V   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       P   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+   data_max      ?hr    C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >p    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       \   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       >p    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       1h   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @O        data_max      @Q&fffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     >p A   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       t   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( 8   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       `   latitude               	long_name         latitude   units         	degrees_N      data_min      @H{   data_max      @H{   C_format      %9.4f          d   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `UO;dZ   data_max      `UO;dZ   C_format      %9.4f          h   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        l   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        p@R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @R      @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ CZ@ CA [@ C@ C@ C\N@ D%1@ D2W@ DM:@ D2W@ Dqj@ D?@ Eu@ EF
L0@ E84֡@ EF
L0@ E84֡@ Eu@ Eu@ EQ@ E84֡@ EF
L0@ EF
L0@ E`A7L@ E`A7L@ E8YK@ ES@ EO
@ Em\@ E84֡@ ES@ F
L/@ ES@ Eڹ@ Fs@ Fs@ FA@ G)^@ G8}H@ G,@ G)^@ Fx@ FFs@ F]cf@ FFs@ G@ GE84@ G8}H@ G)^@ G+I@ G_o@ G_o@ G_o@ GE84@ GRT`e@ FFs@ FL/{J@ F
L/@ F-@ F@ FFs@ FFs@ Ezxl"h@ En/@ Eڹ@ F$/@ F?@ Fs@ FIQ@ Eڹ@ EF
L0@ E`A7L@ Em\@ D7@ DtSM@ D%1@ DS@ DM:@ Cwk@ C	@ CA [@ B}Vm@ Bh	ԕ@ A'R@ AGz@ ?U=@ :6C@ 1hr @D@$/@][@-w1@7Kƨ@MjOv@+U=@Xy=@jJL@
D@ɠ'RTa@ۋq
@C%@O\(@R<6@p@]ce@E84@fA@$tT@IQ@F@%S@\(@2X@ⶮ}Vm@u%F@s@=b@fB@Ϫ͟@YJ@}ڹZ@Yb}@I'RTa@>"@;A@84֡b@7rG@5?@3g	l@1o@$?@ȴ9X@)@D@I^5@
jOv@Fs@*0@@n@'/@8YK@YJ@C\@C\@@:~ @{@{@-@E@PH@!-w2@6z@1&y@.2@}H@~($@xl"h
@#x@6z@ NU@2W@u@@,<@y=c@+J@Z@Vu@H˒@s@rGE8@9XbN@PH@p:@]ce@Q_@oiDg@!@N@Ca@N@T,<@\N;@`-
@[qu!@^҈p;@Zݘ@T,<@@N@o i@64K@>vȴ9X@ ҈p@
n@s@zG@6z@^@ڟvȴ@˒:*@?@O;d@Xe,@wkP@	@S@ae@+j@+@:)z@y	k~@ov@rs@kI^@lVϪ@pU2a|@I^5@NU@t3@kI^@`҈p@I^5?}@A:S@7KƧ@5\(@3E@4#@5?|h@3g@+Q@$tSM@1&x@s@y=c@L_@˒:*@84֡@n@PH@)@t@tSM@҈p;@N;6@@s33333@dZ1@>"@TɅo@xF@4J@ʌL_@<64@YJ@wXe@s|@ov@iy@f,<@[$@Q@H9Xb@<?@2ᰊ@,>B[@@TɆ@յsh@Mj@>B@O
M@	k@/@n.3@S@M@҈p;@E@qi@u%F@+I@2W@@IQ@4m@6@}H˒@sg@`-
@a|Q@KƧ@G#@B@@IQ@5sg@0oiDg8@*0
@&'@$/@#S&@!|Q@)^@K]c@@33333@S@c	@bM@8YK@!.@'@zxl"h@
qu@U=@o@q@qu"@z^5?|@ov@g/V@cS&@a.H@XPH@X_F@W$tS@V+J@U$/@S@N@O;dZ@C@:G{@84֡b@5\(@4J@1l@1-@2䎊q@1-@"C,@+J@'/W@
W'@?@7Kƨ@\N<@ڹZ@!.H@j~#@Y}@䎊q@TɅ@;dZ@R<6@n@Țu%F@F]c@©@C@PH@'0@JL@`d@\(@T@;5X@Vu@qi@@҈@ ѷ@{dZ@bwkQ@B@>6z@<n.@6}Vl@1l@-hr!@+~($@)^@'@%+a@ 
qu@_F@@@N@&@p:@
jOv@ C@+@a|Q@zxl"h@,<@8YJ@&@N;6@As@&I@$/@E@	k~@r@I^@xF@	@ݘ@Z@@~($x@tSMj@p'RT@mhr!@hۋq
@\N;@W&@TFs@P@NT@Ks@Iԕ*@I@F]cf@A:S@9rGE8@4#@333333@/-V@)*0U2a@$tSM@"}Vm@حV@ce@ݘ@+@*0@l!-@O
M@@N@
O;dZ@
D@˒:*@y@S@@4n@ߤ?@hr@J#9@)_@@D@l"h	@KƧ@z@PH@&x@Vϫ@2X@~"@F
L0@ߤ?@(\@0
)@,<@`A7@Ίqi@]cf@:S@\N<@Z@^5?|@!.I@SMj@r@c	@(@zxl"@~($@lD@,<@`A@d8@ce@$@1'@+J@@;5X@@|?@r ě@r{m@rs@p{@nc	@l"h	ԕ@fL/{J@bh	ԕ@]ce@[qu!@Y>BZ@SMj@L/{J#@F@Dg8}@A:S@@4m9@@     @:~@4m8@1@/{J#:@.O;@-U=@,[W?@+~($@*0
@%u@"3@ d8@cA @}H@/w@]ce@_F@Z@As@
jOv@]cf@ IQ@?@?@-@
=q@zG@Z1@wkP@
=p@`d@Ж@xF]@ɺ^5?}@E84@]cf@m\@©@@!.@-V@{@oiDg8@@hr!@0
@0U2a|@rGE@,<@tSM@e+@u@1'@hr @
L/@NU@~BZc @xl"h	@or@m\@ix@gfA@f1.@eڹ@eu@dZ1@_حV@[Q@Z6C@X*0@VR<6@TzG@Sa@O@P$tT@Qu@P`A7@P{@Q@Nߤ?@MjOv@En/@Ao hی@?H˒:@>BZc @<j~#@:@8YJ@8}H@873@71@6!.I@6C-@6C-@6C-@5Y|@43@4#@49XbN@3|@0@.}Vl@-U=@-\@,VϪ@+U=@*g	@'RT`e@0
)@҉@4J@
@s@
	 @u%F
@G{@SMj@iDg8@fA@e+@o@"`B@D*@՛=K@&@а{@ɺ^5?}@7Kƨ@64@-@L/{J@wkQ@Q@u"@6C@sh@҈@y=b@p@mhr!@lVϪ@jg	@ix@e@\?@XbM@PH@Fs@?[W>@.}Vl@+I^@)^@$xF@qu!@@xF]@G{@g	@ݗ+j@*0U@@쿱[@a|Q@v@x@/@[6@}H@ߤ@@&x@KƧ@#w@)y@,zxl@@YJ@)@64@@R@*0U@y@Ƨ-@s@84֡@j~#@֡a@
(@,@x@0
@6z@/V@zG{@@?@@hۋq@o@nt@lVϪ@]+j@W
=p@P{@OAs@OAs@I@@C@2W@'-@#S&@%@$tS@*0@Fs@zG@zG@ᰉ@u@'/W@
(@
O;dZ@'/W@҈@
ڹY@
=p
@
	 @
	 @
qiC@C%@
qu"@\(@
(@q@@C%@C%@
M:@
qiC@%2@
E@
hr@
hr@
"`@
_ح@
@
iB@
O;@
>BZc@
,<@
+a@
1.@
e@
C,@
Ϫ͞@
b}@
MjO@u@hr @u%F@%S@;A@K]cA@UϪ͞@Vaf@Rm@WsPH@Y>BZ@d%1@t#@O;d@}Vl@-@3@=K^@ᰉ@ߤ?@:S@x-
@fA@cZ@`d8@]/w@Vt@T,<@K]cA@C,zxl@=K]@4֡a@/r@/Vϫ@0'RT@,1&y@,q@5'0@;/V@=v@?H˒:@BZc@D*0@F]cf@C,zxl@;5Xy@9D@1o@-B@)@&IQ@$xF@O
M@$/@
+jg@
ȴ9X@
eں@
_ح@
kP@
eں@
D@
O;@
+a@
d8@
ce@
Ϫ͟@
/{J#@
C@
64@
dZ@
#w@
'0@
{@
'RT@
U2a|@
1@
^@
Ov_خ@
@
eO@
@
~"@
{~$@
u%F
L@
u%F
L@
sMjO@
s@
qiB@
qu!S@
pD@
p@
o4֡a@
l!-w@
l!-w@
irGE@
cZ@
\>@
XbM@
Sa@O@
O;dZ@
L@
H@
@4m@
333333@
'-@
䎊r@
Xe,@

(@
	'RTa@E@%F
L@s@`A7L@E@_p@ѷX@ɺ^5?}@K]c@H˒:@<쿱@%@Xe,@Ov_@N;6@	 @@|hr@sMjO@qu!S@nc	@kQ@e`A7L@_;dZ@^ ѷY@\]ce@XbM@SMj@OAs@I@H9Xb@F-@Dg8}@8YJ@+a@@(@$xF@}H@e+a@R<6@L_@O
M@
O;dZ@Fs@YJ@ ѷ@73@O;@빌~($@ hۋ@`A7L@Ϫ͟@ҽ<64@ӎMj@K]c@@D@}H@4m@KƧ@3@4m@C-@C-@?@E@sg@ᰊ@ae@$/@O
M@*0@$/@ᰉ@O;dZ@}!.H@u!.@o-V@jOv`@g@a'R@b@4@Em\@?@9~($@-U=@(TɅ@!.H@ 'RT`@%@[@nO@
E@
!-w2@
D@
@
҈p@
څݘ@
حU@
e+@
b}@
(\@
c	@
JE@
@
`d@
ǮzH@
 [7@
ߤ?@
b@
5Xy@
}H@
J@
6z@
vȴ9@
@
Mj@
ԕ*@
oiDg@
@
zG{@
vFs@
n.2@
f1.@
W@
O͞@
K]cA@
E84֡@
@C@
7Xe@
$tSM@
vȴ@
ݗ+k@
ߤ?@

	 @
oiDg@
o hی@	"`@	F]d@	_ح@	E@	@		ԕ+@	ⶮ}Vm@	e@	حV@	/w@	Z@	@	H˒:@	TɅo@	Zc@	2W@	Õ$@	BZc @	Xy=@	g	l@	g	l@	ߤ@	2W@	3@	3@	Q@	3@	W@	v@	V@	-w1@	O
M@	:)y@	N;6@	'RTa@	@	     @	~"@	~"@	~m\@	u%F
@	JM@	ݗ@	JM@	o h@	nP@	@	n.@	v+jg@	sg@	sPH@	pD@	a|Q@	E84֡@	:)y@	7Xe@	+I^@	Q@	@	S&@	!R<@	I^5?@	C%@	I^5@@䎊q@O;@B@	ԕ+@+a@Z1@C,@ݗ+j@jOv@@4m@6@p
=@}H@a|Q@'RT@m8@33333@U2a|@͞&@	@u@4J@R<6@dZ@/{J#@s@sg@U2a|@U2a|@ᰊ@2W@a|Q@-@o@H@q@@F
L0@IQ@S@*0@+j@@҉@Mj@u%F@Fs@n/@%2@@4n@}Vl!@zG{@x73@x-
@\>@U=K@Sa@O@TɅoi@PH@P*0U@O
M;@Ov_ح@Ov_ح@O͞@OAs@N+@NT@O
M;@O
M;@Ov_ح@O;dZ@N+@Ks@E@B@ATɅo@?@@NU@=p
=@:)y@7KƧ@333333@2m\@1-@-U=@*͞&@*͞&@'-@"3@!-w1@Q@Q@tj@*0@nO@u@bM@!R<@q@u%F@$tS@@Y|@%F
L@Y|@!.@\(@D@s@:~ @:~ @-V@ hۋ@\@,<@W>6z@sPH@m@т@;dZ@p:~@D@Q@84֡@
(@XbM@TɅ@3@Ov_@q@@&I@&I@@+I@+I@4m9@t#@o4֡a@ix@fA@f1.@glC@ix@lC@d%1@[6@Xe+@XD*@Vl!-@T`d@TE@TE@T*1@T,<@Rp:@P{@NT@KƧ@Eo i@A7Kƨ@@4m@@n@@NU@@6@;A@/Vϫ@)^@#n.3@,=@ߤ@@e+a@Xe,@)^@L_@1&x@S&@"@ȴ9X@.2@P{@ޞ@b}@m@)^	@8YK@\N@\(@&IR@~@g	l@U=@F
L0@TɅ@`A@wkP@Xe,@*0U2@k~(@t!-w2@o@l"h	ԕ@iᰉ'@gfA@d%1@be+@ae@a|Q@\?@Sa@O@L/{J#@H@As@84֡b@5Xy=@+a@@&L/{J@#wk@"wkQ@ 'RT`@wkP@vȴ@@@zG@*0@zG@sP@M:@rGE8@_ح@#@hr!@Z@#9@KƧ@zG@?@tj@4J@C%@}Vl!@rs@kQ@iB@`҈p@Vl!-@JD@E8YK@>ߤ?@0{@,>B[@&IQ@$xF@ ěT@O
M@_o@@:S@b}V@E@hr@"`@J#9@#x@#x@ȴ9X@䎊q@:~ @~"@+a@7@@唯O
@@4@ޞ@حU@a@O@ΤT@g8}@ߤ?@z@m\@?|h@3@m8@֡a@|@3@J@q@ae@-V@,<@C,zx@6C@@L_@rGE9@q@K]d@@4n@$tS@~$t@zxl"h
@u!R@uY|@v+jg@u!R@t!-w2@p@mhr!@hۋq
@c	@a'R@`҈p@`d8@_;dZ@]cA @Yb}@P|@NT@NT@M5Xy>@K)^	@Em\@?H˒:@=K]@84֡b@8)@3g	l@/O
M@($xG@IQ@+j@Ov_@ݗ+k@O
M@Fs@*0U2@S&@sP@'/W@)^@qi@nO@Mj@u%F@o h@iB@r Ĝ@fA@S@ߤ?@ޞ@]ce@$@ۋq@W>6z@c	@>BZ@y=c@fA@ԕ*1@т@v_ح@Ƨ@Q@@4m@@vȴ9X@~@3@?|h@|@U2a|@TɅ@1@-w1@*0@)^@bM@rGE9@\(@Vu@qu"@@҈@'/@qiC@k~(@K]d@Q@F]c@$/@~"@}!.H@z@tD@nc	@kC]@jg	@ix@gfA@ffffff@e`A7L@dZ1@]cA @XD*@TE@R䎊@Q_p@QN;5@R䎊@R<64@SZ@SZ@Q@OAs@M@K]cA@JD@IoiD@Fs@C@B74@@C@;5Xy@9XbM@8)@7Xe@2-V@.H@.zG@-B@'RT`e@%S@#wk@-V@@@tj@$tS@:)y@@~($x@u%F@{J#9@ 4m9@$tS@$tS@.H@"`@-V@Q@ڹ@e@C,@|Q@҈p@حV@ޞ@"`B@+@b}@ٳ|@+@ӎMj@+@W'@@@ߤ?@64@#w@E@?@֡a@ᰊ@H@q@jf@\)@$xG@@S&@䎊r@Ov_خ@ߤ@@,<@u%@u%@sh@$tT@!R<@@S&@}!.H@w+@r䎊q@kC,z@iB@h@hۋq
@glC@e@bC,@[6@M@Em\@B\(@B&IR@@C@<j~#@74m@4֡a@0
(@-B@*d7@&x@$xF@#n.3@!-w1@Ov_خ@u%F@e+a@0
)@O;d@O;d@R<6@$/@O
M@@@*0U2@u@bM@u%F@@"@ڹZ@G{@@-
@-
@	k~@73@eں@!.I@1@!.@ ě@4֡a@g	@>BZc@fffff@7@@N@
qu@iB@ce@D*@ӎMj@а{@v_ح@As@As@ΤT@:@cA \@s@˒:)z@]cA@W'@ʌL_@#9@ɺ^5?}@˒:*@s@\N@[W>@Z@~($@}Vl@z@|@1@V@y@,@tSM@o@쿱[W@,=@wkP@u%F@O;d@Z@҉@u@@rGE9@C%@k~(@p:@_o@ݗ@{J#9@n.@     @~"@~$t@~m\@~$t@}E@}!.H@{~$@v!.I@sg@sg@q@o-V@nt@kP{@hr Ĝ@f1.@bC,@a@N@_حV@_Ft@[W>6z@Yb}@W&@U2a|@OAs@K]cA@HK]c@G)^@F?@C,zxl@A [7@=<64@9~($@8Q@73@43@1-@0
(@0 ě@0 ě@/Vϫ@.1@-
qv@-w1@-B@*͞&@&L/{J@$?@#wk@!R<6@vȴ9@Q@Q@Q@IQ@C,zx@,<@Xe,@4J@
@I^5?@
qiC@p:@Fs@S&@o h@ ѷ@o hی@ .H@ #x@ 	k~@ !.I@ Y|@ SMj@ !-w2@  ě@ -V@ "h	ԕ@ P{@ Dg8~@ 	k@ 	k@ @4@ حV@ 5?|@ ۋq@ e+@ @ 8YJ@ ӎMj@ @ ]cA@ ]cA@ W'@ E84@ @ 6@ [W>@ ߤ?@ b@ <64@ dZ@ XbM@ 3@ g	l@ r@ 1&y@ Xy=@ &@ '@ F
L0@ /@ wk@ `A@ `A@ h	ԕ@ o@ o@ -
@ ,=@ S@ _o@ e+a@ _o@ u%F@ +j@ O
M@ nO@ @ qu"@ xF]@ k~(@ 7KƧ@ 1&x@ K]d@ oiDg@ ?@ {J#9@ n.@ $tS@ b}V@ ~\N<@ {m]@ y"`@ x73@ u!R@ t!-w2@ rs@ poiDg8@ oiDg8@ nt@ l!-w@ kP{@ hۋq
@ h	ԕ+@ gfA@ gfA@ glC@ g	k@ hr Ĝ@ f,<@ a'R@ _;dZ@ ^ ѷY@ ]/w@ [6@ WsPH@ R<64@ N+@ M:@ L/{J#@ KƧ@ JD@ H˒:*@ F-@ D*0@ C$@ B\(@ A@ ?@ >6z@ =b@ =<64@ =p
=@ <쿱[@ :~@ 8)@ 8}H@ 7Xe@ 6C-@ 6C-@ 6z@ 5Xy=@ 5'0@ 4J@ 2a|Q@ /v@ -U=@ -B@ -w1@ ,zxl"@ ,q@ +I^@ *͞&@ +I^@ )lD@ (\)@ '-@ #S&@  'RT`@ ,=@ e+a@ _F@ $tS@ tj~@ n@ @ Vu@ Vu@ 
(@ 
@ 
@ 
(@ ~($x@ L_@ 	7KƧ@ $/@ Q@ @ nP@ I^5@ $/@       ?ڹZ?~$?+?eں?E?oiDg8?rGE?C,?u!?ݗ+j?Q_?,<?p:~?p:~?)^	??@?ěS?74?C?[W>?H˒:?)_?r?*0U2a?TɅ?zxl"h?3?-
?%?R<6?:)y?N;6?$tT?S&?Mj?ݗ+?ݗ?nP?4m9?|hr?zxl"h
?zxl"h
?w1?p
=q?n.2?iDg8~?d7?_حV?[W>6z?W>6z?R<64?PH?P{?Ov_ح?L/{J#?GzH?E84֡?E84֡?C$???>6z?=b?8}H?6C-?5Xy=?4֡a?0U2a|?-
qv?-V?,<쿱?*0
?'/V?&?$xF?!.H?	?6C?*0?+J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @@6zG@@6zG@@6u@@6@@6zG@@6u@@6@@6@@6u@@6@@6u@@6zG@@6@@6zG@@6u@@6@@6zG@@6zG@@6@@6zG@@6zG@@6zG@@6zG@@6zG@@6zG@@6@@6@@6@@6@@6@@6zG@@6@@6@@6u@@6@@6u@@6@@6@@6u@@6u@@6@@6u@@6u@@6@@6u@@6@@6@@6@@6@@6@@6@@6zG@@6zG@@6@@6@@64K@@6
(@@6
(@@64K@@64K@@6zG@@6zG@@6@@64K@@64K@@64K@@64K@@64K@@6zG@@6zG@@6zG@@6zG@@6@@6zG@@6zG@@6zG@@64K@@6
L/@@6_o @@6
L/@@6_o @@6 ѷY@@6_o @@6t@@6
(@@6($x@@6Vu@@8eO@@:h	ԕ@@;%2@@? hۋ@@A4J@@Bxl"h
@@Cg	l@@FFs@@HeO@@Jᰊ@@K҈@@LC,zx@@L7@@McA @@Ov_ح@@P
=q@@Qo hی@@QoiD@@Qn.@@Qe@@Rc	@@Tm8@@T@@US&@@U(@@V;5X@@V@@W8}H@@W@@X[6@@Y0
)@@Ys@@Z~"@@\#@@]%F
L@@]+j@@]8Y@@]oiDg@@^t@@^@@^.2@@^Ov_خ@@_\(@@dzG@@f+@@g	k@@h*0U@@h
=q@@kP{@@mXy=@@m8Y@@moiDg@@nfffff@@okP@@q ѷ@@w4m@@
qu@@n@@`A@@@@-@@|@@u@@ڹY@@RT`e@@~($x@@3@@C]@@$t@@@@@@C\@@$@@F
L0@@F]d@@C-@@-
@@)y@@@4n@@C\@@GE85@@~"@@n/@@ݘ@@W@@a@N@@Ʌoi@@iB@@y@@$tS@@1&x@@ÎMj@@t@@+j@@Ⱥ)@@ ѷ@@u%F@@PH@@PH@@u@@@@m\@@P{@@Ʌoi@@)^@@     @@@@@ُo@@#9@@C,@@tSM@@ݛ=K@@@@@e+@@:S@@"`@@C\@@W@@9@@jf@@Z@@㹌~($@@A@@Z@@*0@@/w@@帺@@BZc @@eں@@@@[6@@
=q@@4֡b@@@@y@@lD@@u%F@@e+@@s@@	 @@1'@@@4@@)_@@dZ@@*0U2@@"h	ԕ@@]ce@@j~#@@tSM@@C@@쿱[@@1&@@*0@@u"@@!-w@@V@@(@@L_@@zxl"h@@H˒@@S@@!.@@t@@
(@@8YJ@@E@@H@@\N<@@iB@@s@@IQ@@}Vl@@qi@@Fs@@,<@@,<@@af@@ȴ9X@@"@@!.I@@ hۋ@@Ft@@ hۋ@@)^@@@@v@@,@@,@@+I@@4֡a@@;dZ@@KƧ@@RT`e@@b}V@@o@@v_ح@@4m@@{J#:@@	@@@@[W>@@zH@@#@@bM@@'RT`@@'RT`@@D*@@K]c@@Xy=@@[6@@_F@@bM@@hۋq@@𖻘@@@@d8@@ěT@@҈p@@\)@@@@+@@Dg8~@@k~(@@k~(@@񂩓@@7Kƨ@@|Q@@@@@@ᰉ'@@-@@I^5@@e+@@Ov`@@6C@@3@@@4n@@GE85@@JL@@h	ԕ@@~"@@sP@@PH@@)^	@@6z@@=K^@@@N@@@N@@@N@@F]c@@qu!@@Mj@@wk@@~($@@Ƨ@@a@@@Q@@%2@@Q@@%2@@g@@\N@@tj@@2W@@<쿱@@?@@SMj@@`d@@]ce@@cA \@@q@@qj@@[W?@@@@hr@@e@@E@@o i@@o i@@u@@*0@@!.H@@p
=@@Ϫ͞@@Ov_@@1.@@BZc @@l!-@@}Vl@@]cf@@ߤ?@@x@@!.I@@)^@@1@@eں@@	@@@@$tS@@kP@@@@@@Q@@u!@@d8@@e+@@[W>6@@b}@@~($@@n.@@iB@@n@@Ov`@@:)y@@@4@@ᰊ@@>B@@Y@@n@@`A@@҉@@W>6z@@q@@C]@@1&y@@64@@TɆ@@Z@@!-w@@[@@%F
L@@?|h@@L_@@L_@@jOv@@+j@@?@@_o @@4K@@5?|@@fffff@@@@@@'@@ȴ9X@@C-@@x@@Fs@@
=p@@v@@'/W@@_o@@v_ح@@@@$tS@@3@@+@@䎊r@A      @A 	ԕ+@A bM@A @A @A $xG@A 1&x@A 4m9@A Xy=@A oiDg8@A |@A 'RT@A {@A ҈p@A@N@A0
)@AJE@A|Q@Au@A'R@A.H@A3@AQ_@AZc@Au%F
@AS&@A>B@AsP@A䎊q@Am@A74@A74@AS&@A&@AJ#9@A]cA@A~$@Aq@AA@A@A@A!-w2@ASMj@Aj~@A[@Au@A[@A!.H@AB@AO;dZ@A!R@Ash@A,=@A ѷY@A
(@AYJ@A6z@AC-@A"@A)^@A,@A.H@AO
M@AO;d@A͞@Ar@Avȴ9@AK]d@A@AحV@A@A@A-
q@A4m9@AH@AH@AQ@AU2a|@Al"h	@An@AU@A{@A`A7@A	@A	Q@A	@A	'R@A	^5?}@A	o@A
n@A
@4n@A
W'@A
qiC@A
L_@A
g	@A
n@A
䎊q@A
c	@AI^@APH@AZ@An.3@AeO@Aq@AMj@A$@AS@Aa@O@A|@AQ@A$@A1&y@AQ@A<쿱@AcA \@A_@AD@A
qu"@A
+a@A
jOv@A
8Y@A

qv@A_o @Au@A.2@A1.@A;5X@ABZc @Ap:~@A,<@A}Vl@Aȴ9X@AϪ͟@AMj@A!.I@AXe@A)^@AXe@A,@A@A1@AE84@A@A/V@AfA@ArG@A
qu@A73@AK]c@AU2a|@AXy=@AeO@AeO@AoiDg8@Al"h	@Ar Ĝ@AYJ@A-
@Atj@A@AIQ@Ap:@AD@Ae+@A҈p@AC@A4֡b@A{@ArGE@ArGE8@A(@A|@Ao@A@A@AJL@Ap:@A@AY@AsP@Am@AI^@AC,z@A/V@A9@AC%@AP{@AxF]@AA@Am]@A%2@A!-w2@A/{J#@AFs@AM:@A]ce@Am8@AS@A!-w@A%F
L@A/w@A/w@A?|h@AB@AY|@A$/@AO
@A1@A8YK@A ѷY@A?@AOv_خ@AYJ@Al!-@A@A2X@AA@A
M;@AKƧ@A4m@A3@A@ArGE9@A ě@A1&x@AU2a|@AXy=@AoiDg8@A˒:*@AIQ@ArGE@A4J@AXbM@A@A-@A3@A=p
@Ad7@A{m@AG{@AQ@A\N@AxF@AxF@A1&y@Aߤ@@A(\@A<쿱@A2W@A?@AM:@A]ce@A`d@AwkP@A#x@Aqu"@A84֡@AB@AF
L0@AIQ@AjOv@Asg@AM:@A=K@A-V@A1@A@AcA @A?@Ab@A\(@AH˒@A8Y@A@Aᰉ@AoiDg@AC\@Aڹ@A
L/@A@AOv_@AOv_@AOv_@AOv_@A($x@A+jg@A!R<@A@AzG@A@Au@A
(@A
L/@A
(@A4K@A
(@Au@A!R<@A@A$/@AE@Afffff@AiB@AiB@Avȴ9X@A+J@A$t@A,<@A-@A2X@A@A&I@A&I@Aߤ?@Am\@A+@A@AkP@A D*@A d8@A @A!@A![W>6@A!^5?}@A!Y}@A"@A"1'@A":)y@A"M@A"{m@A"}Vm@A#,zxl@A#~($@A#a@O@A#@A$Q@A$C@A$쿱[@A$@A$[W?@A$쿱[@A$_@A$S@A$*1@A$qj@A$?@A$o h@A$wkP@A$tSM@A$g8}@A$m8@A$m8@A$wkP@A$wkP@A$?@A$#x@A%'0@A%Q@A%(@A%Vl!@A%`A7L@A%p
=@A%ݗ@A%O
@A%+j@A%1@A%8Y@A%Ϫ͞@A%,=@A&t@A&?@A&H@A&_ح@A&_ح@A&p:~@A&Fs@A&6z@A&ȴ9X@A&t@A&Ϫ͟@A&x@A&Mj@A&Mj@A&@A&ߤ?@A&]cf@A&C-@A&@A'Xe@A'.H@A'As@A'H˒:@A'H˒:@A'O
M@A'_o@A'	@A'+@A'-@A'#@A(*0U@A(bM@A(*0U@A(bM@A(*0U@A(*0U@A(@A(@A(6@A(}H@A( ě@A( ě@A(}H@A(-
q@A(4m9@A(:~ @A(H@A(NU@A(Xy=@A(_F@A([6@A(oiDg8@A('RT@A(IQ@A(d8@A(
(@A()^@A(p:@A(e+@A(\)@A(	k@A)@N@A):S@A)XbM@A)e+a@A)u!S@A)u@A)N;6@A*e+@A*6C@A*a|Q@A*h	ԕ@A*{m@A*\(@A*S&@A*>B@A*)_@A*W@A*`A@A*sP@A*fB@A*m\@A*74@A*m\@A+S&@A+'/@A+'/@A+PH@A+s@A+PH@A+)^	@A+@N@A+dZ@A+jf@A+tj~@A+~$@A+eO@A+ߤ@A+q@A+@A+6@A+Ƨ@A+@A+|@A+lC@A+C]@A+C]@A+lC@A+A [@A+$@A,n.@A,1&y@A,(\@A,64@A,Z1@A,]ce@A,`d@A,g8}@A,q@A,tSM@A,zG@A,zG@A,?@A,?@A,C@A,_@A,1&@A,?@A,*0@A,*0@A,Z@A,>B[@A,D@A-V@A-*0@A-*0@A-*0@A-qu"@A-qu"@A-qu"@A-o i@A,>@A-'0@A-qu"@A-(@A-?|h@A-B@A-S&@A-Vl!@A-m\@A-M:@A-=K@A-=K@A--V@A-8Y@A-Ϫ͞@A-?@A-?@A-S@A-E@A.!R<@A.5?|@A.?@A.;5X@A.E@A.Vu@A.c	@A.c	@A.vȴ9X@A.O;@A.ߤ?@A.t@A.쿱[W@A/)^@A/!-w1@A/+I@A/;dZ@A/8}H@A/H˒:@A/RT`e@A/b}V@A/|hs@A/?@A//V@A/o @A/@A/@A/Vϫ@A06@A04m9@A0:~ @A0A7K@A0NU@A0_F@A0eO@A0u!@A0y=c@A0˒:*@A0˒:*@A0'RT@A0@A0-
@A0-
@A0@A09Xb@A0ěT@A0ۋq
@A0	k@A0\)@A0PH@A0@A04֡b@A1$/@A1+@A1+@A1_p@A1+@A1+@A1$/@A0\)@A0	k@A0PH@A1$/@A1rGE@A1@N@A14J@A1A [@A1=b@A1Gz@A1TɅo@A1^@A1k~(@A1rGE8@A1k~(@A1k~(@A1~($@A1@A1'RTa@A1B@A1'R@A1D@A1y@A1"`@A1ᰉ'@A1e@A1R@A1R@A1@A2I^5@A2Ov`@A21'@A2C\@A2^5?|@A2xl"h
@A2~"@A2@4@A2p:@A2\(@A2vȴ@A2vȴ@A2Y@A2)_@A2`A@A2`A@A2,<@A2ڹY@A2 ѷ@A2sP@A2͞&@A2G{@A274@A2m@A274@A2m\@A3"`B@A3/V@A3xF]@A3Mj@A3$@A3A@A3:)z@A3{J#9@A3Q@A3*0U2@A4(\@A4zG@A4TɆ@A4?@A4?@A4>B[@A5:@A5*0@A5Q@A5%F
L@A5!.H@A5IQ@A5Y|@A5Vl!@A5`A7L@A5S&@A5Vl!@A5O;dZ@A5O;dZ@A5m\@A5ڹZ@A5=K@A5=K@A5=K@A5@A5%@A5=K@A5O
@A5hr!@A5hr!@A5!R@A5w1@A5p
=@A5$/@A5=K@A58YK@A5E@A6
(@A6zG@A6u@A6Ov_@A6!R<@A6($x@A68YJ@A68YJ@A6;5X@A6;5X@A6?@A6E@A6Ov_خ@A6l!-@A6}Vl@A6%@A6+J@A6+J@A6O;@A6af@A6}Vl@A6ߤ?@A6&I@A6m\@A6҈p;@A6]cf@A6ߤ?@A6C-@A6Mj@A6"@A6"@A7@A7@A7'/W@A74֡a@A7;dZ@A7As@A7H˒:@A7O
M@A7O
M@A7\(@A7\(@A7iDg8@A7iDg8@A7v_ح@A7y@A7y@A74m@A7	@A7O;d@A7	@A7O;d@A7@A7@A7-V@A7[W>@A7r@A7o @A7حV@A7Vϫ@A7+j@A7+j@A7rGE9@A8@A8*0U@A8}H@A8*0@A81&x@A873@A873@A8Xy=@A8oiDg8@A8r Ĝ@A8u!@A8oiDg8@A8y=c@A8YJ@A8@A8ěT@A8@@A8
(@A8
(@A8TɅ@A8ѷX@A8C@A8\)@A8`A7@A84֡b@A8C@A8\)@A9 ѷ@A9rGE@A9+@A9#w@A9&x@A9&x@A9-w1@A9=b@A9Q@A9ae@A9u!S@A9|Q@A9|Q@A9b}@A9@A9~($@A9'RTa@A9l@A9'R@A9X@A9^5?}@A9@A9D@A9y@A9_o@A9@A9ᰉ'@A9R@A9lD@A:u%F@A:u%F@A:Ov`@A:1'@A:#9@A:6C@A:3@A:6C@A::)y@A::)y@A:C\@A:M@A:Q_@A:Zc@A:M@A:Zc@A:^5?|@A:d7@A:kP|@A:xl"h
@A:p:@A:p:@A:L_@A:S&@A:\(@A:\(@A:S&@A:ᰊ@A:vȴ@A: ě@A: ě@A:g	@A:n@A:W@A:,<@A:`A@A:G{@A:m\@A;S&@A;u%@A;S&@A;'/@A;s@A;'/@A;PH@A;s@A;s@A;s@A;&@A;@N@A;C%@A;J#9@A;J#9@A;MjO@A;g	l@A;xF]@A;A@A;*0U2@A;Ƨ@A;a@O@A;Ƨ@A;a@@A;@A;ݗ+k@A;҈@A;҈@A;Q@A;ݗ+k@A;C]@A;A [@A;\N@A<1&y@A<n.@A;s@A<n.@A<ߤ@@A<@A<@A<!-w2@A<(\@A<,<@A<9XbN@A<2W@A<<쿱@A<M:@A<VϪ@A<`d@A<g8}@A<zG@A<N;@A<쿱[@A<@A<j~@A<?@A<Z@A<Z@A<@A<!-w@A<!-w@A=:@A=K]@A<E@A<E@A=V@A=!.H@A=5Xy>@A=/w@A=2a|@A=84֡@A=5Xy>@A=?|h@A=O;dZ@A=Vl!@A=Y|@A=ce@A=\@A=m\@A=w1@A=$/@A=hr!@A=+j@A=@A=@A=H˒@A=8Y@A=b@A=E@A=C\@A=E@A=C\@A> ѷY@A>zG@A>@A>!R<@A>;5X@A>E@A>L/{J@A>Ov_خ@A>Vu@A>\N<@A>s@A>qi@A>@A>Fs@A>,<@A>af@A>'@A>m\@A>A@A>C-@A>C-@A>Mj@A>Fs@A? hۋ@A?)^@A?,@A?!-w1@A?+I@A?$tS@A?+I@A?1@A?8}H@A?8}H@A?8}H@A?;dZ@A?>6z@A?As@A?>6z@A?8}H@A?1@A?.H@A?8}H@A?.H@A?>6z@A?H˒:@A?H˒:@A?KƧ@A?KƧ@A?O
M@A?RT`e@A?U=@A?U=@A?Xe,@A?_o@A?eں@A?iDg8@A?o@A?4m@A?	@A?$tS@A?	k@A??@A??@A?[W>@A?vȴ9@A?o @A?K]d@A?+@A?;dZ@A?;dZ@A?rG@A@     @A@*0U@A@
qu@A@*0U@A@6@A@ ě@A@-
q@A@-
q@A@-
q@A@1&x@A@4m9@A@73@A@H@A@NU@A@Q@A@Xy=@A@bM@A@eO@A@bM@A@oiDg8@A@|@A@n@A@YJ@A@n@A@n@A@'RT@A@tj@A@@A@d8@A@)@A@ěT@A@p:@A@p:@A@p:@A@D@A@҈p@A@F@A@҈p@A@`A7@A@C@A@\)@AA	k~@AArGE@AA [7@AA+@AA&x@AA0
)@AA:S@AADg8~@AADg8~@AAQ@AAQ@AAhr @AAu!S@AAu!S@AA|Q@AA7Kƨ@AA~($@AA~($@AAR<6@AAu@AAu@AA'RTa@AA(@AAl@AAB@AAX@AAD@AAy@AAy@AAy@AA2W@AA_o@AAe@AA@AA.H@AAlD@ABu%F@AB	 @AB	 @AB	 @ABI^5@ABs@AB1'@AB1'@AB䎊@AB)y@AB3@ABJL@ABT`d@ABd7@ABkP|@ABnO@ABqiC@ABxl"h
@AB~"@ABxl"h
@AB~"@ABp:@ABS&@ABS&@ABᰊ@ABwkQ@ABwkQ@ABL/{@ABg	@AB ě@AB}Vm@ABY@ABY@ABY@AB<64@ABW@ABڹY@ABG{@ABG{@ABc	@ACS&@ACnP@ACPH@AC/V@AC33333@AC6z@AC33333@AC6z@AC9@ACC%@ACMjO@ACjf@AC~$@ACQ@ACeO@AC:)z@ACA@ACS@AC@ACZ@AC6@AC@AC5Xy@AC
=p@ACQ@AC҈@ACg@AC\N@ACs@AC\N@AD1&y@ADJ@ADJ@ADߤ@@ADxF@AD@ADߤ@@ADߤ@@ADtj@ADtj@AD2W@AD?@ADI^5?@ADI^5?@ADM:@ADPH@ADSMj@ADM:@ADPH@ADVϪ@ADZ1@AD`d@ADZ1@AD]ce@ADq@ADj~#@ADwkP@AD~($x@AD?@AD#@ADN;@ADS@ADS@AD3@AD@AD?@AD@AD֡a@AD֡a@AD>B[@ADu"@AD@AD@ADZ@ADJM@AD@ADhr@ADJM@ADD@ADD@ADe@ADE@ADE@AEV@AE*0@AE%F
L@AE2a|@AE5Xy>@AE<64@AE?|h@AEF
L0@AEY|@AES&@AE\@AE`A7L@AEm\@AEsg@AEw1@AE}H@AEM:@AEڹZ@AEhr!@AEO
@AE=K@AE%@AE@AEH˒@AEH˒@AE8Y@AEcA @AEϪ͞@AEb@AE?@AEb@AE?@AEb@AE?@AES@AEᰉ@AE(@AEڹ@AF ѷY@AEڹ@AF
L/@AFzG@AF@AF$/@AF+jg@AF1.@AF8YJ@AF;5X@AFBZc @AFE@AFR<6@AFYJ@AF\N<@AF_ح@AFs@AFz@AF@AF%@AFqi@AF$t@AFO;@AF@AF}Vl@AF'@AF2X@AF@AFm\@AFt@AFA@AFt@AFA@AFA@AF+@AFϪ͟@AFߤ?@AFC-@AF쿱[W@AF@AFFs@AG hۋ@AG@AG@AG@AG@AG
=p@AG
M;@AG
M;@AGv@AG$tS@AG+I@AG.H@AG;dZ@AG;dZ@AGH˒:@AGH˒:@AGKƧ@AGRT`e@AGU=@AG_o@AGeں@AGiDg8@AGo@AGy@AG|hs@AG4m@AG{J#:@AG@AG$tS@AGkP@AG?@AGzH@AG͞@AGr@AGvȴ9@AG/V@AGK]d@AG+@AG@AGحV@AG;dZ@AG䎊r@AG+j@AG-@AG+j@AH@AHbM@AH@AH*0U@AH6@AH6@AH}H@AH$xG@AH*0@AH-
q@AH:~ @AH>BZc@AHD*@AHU2a|@AHNU@AHQ@AH[6@AHXy=@AH_F@AHeO@AHeO@AHbM@AHhۋq@AHeO@AHl"h	@AHr Ĝ@AH|@AHn@AH˒:*@AH˒:*@AHn@AH'RT@AH-
@AHtj@AHIQ@AH
=q@AHd8@AH{@AHU@AH4m@AH)@AHTɅ@AHTɅ@AHěT@AH)^@AHѷX@AHp:@AHF@AHD@AHe+@AHe+@AHC@AHC@AH4֡b@AH	k@AH	k@AHPH@AH$tT@AI$/@AI@AI@N@AI+@AI@N@AI+@AI+@AI@N@AI@AI*0U2a@AI0
)@AI4J@AI:S@AI7KƧ@AIGz@AIQ@AI[W>6@AI[W>6@AI^@AIe+a@AIhr @AIk~(@AIo hی@AIu!S@AIx@AI|Q@AIx@AI@AI~($@AI7Kƨ@AIo@AI~($@AI7Kƨ@AIR<6@AI@AIR<6@AIu@AIu@AI'RTa@AIn.@AIl@AI'RTa@AIB@AIB@AIX@AI@AIX@AI^5?}@AI^5?}@AI@AID@AI2W@AI@AIy@AIo@AIN;6@AI"`@AIiB@AI>BZ@AIY}@AI-@AI-@AI.H@AJ	 @AJ@AJ@AJs@AJOv`@AJs@AJOv`@AJ@AJe+@AJe+@AJ#9@AJ&IR@AJ)y@AJ-V@AJ-V@AJ6C@AJ:)y@AJ:)y@AJ=p
@AJ=p
@AJGE85@AJGE85@AJM@AJT`d@AJZc@AJh	ԕ@AJd7@AJkP|@AJqiC@AJxl"h
@AJ@4@AJ{m@AJݘ@AJݘ@AJp:@AJS&@AJS&@AJᰊ@AJᰊ@AJᰊ@AJwkQ@AJ>B@AJg	@AJg	@AJY@AJn@AJn@AJ)_@AJ,<@AJsP@AJsP@AJG{@AJsP@AJ ѷ@AJC,@AJc	@AJm@AJD@AJm\@AJm\@AJm\@AKS&@AK҉@AK'/@AKs@AKC,z@AK&@AK,zxl@AK/V@AK9@AKC%@AK9@AK@N@AKJ#9@AKMjO@AKMjO@AKMjO@AKP{@AKW>6z@AKS@AKS@AK]cA@AKdZ@AKg	l@AKdZ@AKn.3@AKtj~@AKn.3@AKn.3@AKxF]@AK{J#9@AK~$@AK@AKQ@AKeO@AKMj@AK:)z@AKU=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @r6fffff@r4@r6fffff@r6fffff@r4@r9@r4@r6fffff@r0     @r6fffff@r333333@r6fffff@r8     @r6fffff@r1@r1@r0     @r0     @r6fffff@r9@r6fffff@r1@r6fffff@r1@r8     @r;33333@r,@r1@r,@r1@r333333@r6fffff@r6fffff@r4@r4@r+33333@r+33333@r,@r8     @r6fffff@r333333@r9@r+33333@r4@r1@r8     @r1@r333333@r0     @r6fffff@r+33333@r1@r0     @r4@r6fffff@r4@r333333@r4@r4@r1@r1@r0     @r6fffff@r333333@r,@r     @r,@r.fffff@r;33333@r1@r8     @r,@r0     @r,@r1@r333333@r333333@r333333@r.fffff@r.fffff@r@r#33333@r#33333@r@q@q33333@q@q     @q@q33333@q@q33333@qx     @qT@qd@q|@q33333@qs33333@qffffff@qa@q^fffff@qh     @qvfffff@q|@ql@qd@qh     @qffffff@qc33333@q^fffff@qh     @qx     @qs33333@qh     @qk33333@qa@qS33333@qFfffff@q;33333@q.fffff@q@q.fffff@q.fffff@q33333@q33333@q+33333@q&fffff@q33333@p33333@p@p     @p@pfffff@p33333@py@pc33333@pd@pffffff@pS33333@p9@p@oC33333@nfffff@n     @nfffff@n@nFfffff@n@mfffff@my@m@l@lffffff@ll@l     @k33333@k33333@ks33333@k`     @k&fffff@jٙ@j@jFfffff@j&fffff@j@j@j)@iٙ@iffffff@iI@i@i&fffff@i      @h     @hfffff@h@h     @hvfffff@hi@hY@hP     @h6fffff@h#33333@h      @g33333@gY@g	@f33333@f@fvfffff@f,@f33333@eٙ@e     @e     @e<@e	@d33333@dp     @dS33333@d@     @dI@dFfffff@dC33333@dC33333@d@d	@d@d	@cfffff@c     @c@c33333@c@cy@cS33333@cFfffff@c0     @c     @b陙@bfffff@bfffff@bfffff@b     @bfffff@bə@b@b33333@bi@bFfffff@b33333@afffff@a     @aٙ@aٙ@afffff@aə@afffff@afffff@a@afffff@ay@a|@a,@a@     @a      @`33333@`fffff@`@`@`     @`Y@`\@`L@`Vfffff@`L@`S33333@`9@`9@`@`@`     @_     @_@_     @_Y@_ffffff@_33333@_@_fffff@^@^ٙ@^33333@_fffff@^     @^33333@^fffff@^fffff@^33333@^33333@^s33333@^@^`     @^     @^Y@^333333@]33333@]@]s33333@]ffffff@]     @]&fffff@]&fffff@\     @\ٙ@\     @\@\33333@\`     @\S33333@\333333@\&fffff@\@[fffff@[@[fffff@[S33333@[33333@Z     @Z@Z33333@Zٙ@Z33333@Zfffff@Zs33333@Z,@Y33333@Yfffff@Yٙ@Y@Y@Y@Yfffff@Y33333@Y@Yl@Y@     @X@X     @X@X@X@X     @X`     @X33333@Xy@X&fffff@X@W33333@W33333@W33333@W33333@W33333@Wfffff@W     @W@Wl@Wl@Wfffff@W9@W9@Wfffff@W      @V@Vfffff@V     @V33333@V@V33333@Vy@V@     @VS33333@VL@V@     @VFfffff@V&fffff@V      @Vfffff@V@UY@T@Tfffff@Tfffff@T@T     @Tffffff@TY@T`     @TL@TS33333@T33333@T@S33333@Sfffff@S33333@S@S@SY@S     @Sfffff@S      @R33333@R@Rfffff@Rٙ@R@R33333@RY@Rffffff@R333333@R33333@R      @Q@Rfffff@Qfffff@Q@Q     @QL@Qffffff@Q9@Q33333@Q@P33333@P     @P@P33333@Pfffff@Pfffff@P     @PY@P`     @P,@PL@P      @O33333@P      @O33333@Offfff@O@Offfff@O     @OL@Os33333@OL@O&fffff@O333333@Nfffff@Nٙ@O&fffff@N33333@O@Ns33333@N&fffff@N     @ML@N@     @N&fffff@N333333@M33333@N@M33333@M33333@M     @M33333@M     @M@MY@M&fffff@Lٙ@L33333@Lfffff@Ls33333@K33333@K@LL@Kfffff@KL@K@K&fffff@J     @K@     @JY@J33333@Jfffff@Jٙ@Jfffff@J@JY@J&fffff@J333333@I33333@Ifffff@I@Is33333@I@I&fffff@Hٙ@H      @H&fffff@G33333@G     @Gٙ@H333333@Gfffff@G&fffff@G333333@Fٙ@G      @F@Fffffff@FL@Efffff@E33333@E@F@F@E     @E333333@E333333@E      @E@D@E333333@Dfffff@Dfffff@Dٙ@Dfffff@DY@DY@D     @D@DY@D&fffff@DY@DL@DL@C@C33333@CL@C     @Bfffff@B33333@B     @C&fffff@B     @B     @BY@BY@B&fffff@BY@Bffffff@B@A33333@B      @Afffff@A@A@As33333@A     @A@Afffff@Affffff@AL@A     @A&fffff@A&fffff@AL@A      @AL@@     @@fffff@@L@@Y@?fffff@?33333@?@?33333@?     @?@?333333@?33333@>@?ffffff@>@?L@>fffff@?L@=fffff@?333333@>@>L@>L@>@>ffffff@>      @>L@=33333@<fffff@=ffffff@=@=33333@=@=33333@=L@<fffff@=ffffff@=@=L@=ffffff@=ffffff@=@=@<ffffff@=33333@=      @<33333@<     @<@<@<L@<333333@<@;fffff@:fffff@:@:L@;L@:      @:@:33333@9fffff@9ffffff@9L@:@9@9L@9L@9     @8fffff@9333333@9L@8@9     @9333333@9      @8ffffff@8     @8333333@8fffff@8      @8L@7@7fffff@7@8L@7ffffff@7333333@7@7333333@7fffff@6@7      @7L@7L@6ffffff@7333333@6L@6     @6@6fffff@633333@6     @6L@5@5fffff@5fffff@533333@6      @5ffffff@5@5     @5333333@5@5L@4ffffff@4@4L@4      @3L@3333333@3@3L@2fffff@2@1fffff@1@2      @1ffffff@1     @1ffffff@1333333@2      @133333@1     @2      @2      @1333333@1ffffff@1L@1333333@0fffff@1      @0@1      @0@1@1@0@0fffff@0@0fffff@0@0     @1333333@0fffff@1      @0@0fffff@0fffff@0fffff@0fffff@0fffff@0fffff@033333@033333@1      @0@1333333@0ffffff@0fffff@0fffff@0     @1333333@0      @033333@133333@/@1L@0fffff@0     @0@0@1333333@0@0     @0@0ffffff@033333@0@/@0@0@0333333@0L@0     @0     @0L@0@0      @0     @0333333@/333333@.ffffff@.ffffff@*@,@*@,333333@*ffffff@*@*@,      @*      @*333333@)@)ffffff@&@(@&@)333333@'333333@'ffffff@'@&@&@'@(      @(ffffff@'@(      @(      @(      @(      @'@(ffffff@(ffffff@(333333@'@(@'ffffff@(      @'333333@'      @&@'333333@&333333@&333333@&@&@&@'      @'      @&@'      @&      @&@&@&      @%@&@&      @&      @%333333@'@&      @&      @%333333@&      @'@&333333@&      @&@%333333@&      @'333333@$ffffff@%@&      @%@$@&ffffff@%@&      @&      @&      @&      @%@%@&333333@%      @&@%333333@&ffffff@%ffffff@&      @%@%333333@%@%@%ffffff@&ffffff@%      @&333333@&      @$@&333333@&      @%333333@%@&@&ffffff@&      @'      @#      @(333333@$@&333333@$@%@&ffffff@$@$@%@%@%333333@%ffffff@%333333@%@%333333@&      @$333333@&      @$@&333333@%333333@%333333@%@%@%333333@$      @%@&@$      @%@%333333@$@'      @$      @&@%333333@$@%ffffff@%@&ffffff@$@%@%ffffff@$@%333333@%ffffff@&@%ffffff@$@&ffffff@#@&      @%ffffff@%@%ffffff@$@%@%ffffff@%@&      @$ffffff@$@&@#@%333333@%333333@%      @&333333@$@$@%333333@%333333@%      @%333333@%@%@$ffffff@%@%333333@%333333@'      @$@&      @%ffffff@%      @&      @&@$@&@$      @%ffffff@&      @&333333@$@&      @%333333@'      @$@%ffffff@&      @%ffffff@%@$@&333333@%@$@'@$333333@%333333@%@&@$@&      @%333333@&      @%333333@%@&      @&333333@$ffffff@%      @&@$@(333333@$333333@&      @'333333@$ffffff@&      @&ffffff@&333333@&333333@$@(333333@"@'333333@&@&      @&ffffff@&      @$@'333333@'ffffff@%@&@&333333@%@&@&      @'@&ffffff@&333333@'      @%@&333333@&ffffff@&ffffff@&ffffff@&333333@&ffffff@&@&333333@&      @&ffffff@&ffffff@&      @&@&ffffff@&@&333333@&ffffff@&ffffff@&@&      @'333333@&      @'      @'@%      @%@(333333@&      @&333333@'ffffff@&ffffff@%ffffff@)333333@&      @&@'@$@'@'ffffff@'@&333333@(      @%@'@'333333@'333333@'333333@'@&@'      @'333333@(      @%ffffff@(      @'ffffff@&@'333333@'ffffff@'ffffff@(ffffff@'ffffff@'      @'@)@&@'@'@(      @(@(      @(333333@'@(@)333333@&@)      @'333333@(      @)@(@(ffffff@(      @(@(@(@(ffffff@(@(@(@(@(ffffff@*333333@(      @*      @)@)333333@(@(@(333333@'@*@(      @)333333@)ffffff@'@*      @*333333@)333333@)333333@)@(@*333333@)      @*@(      @+@'@)333333@+@)333333@(@*@)@*ffffff@*333333@)@)@)@)@*ffffff@+      @*ffffff@)@*ffffff@)333333@+@)@*@)333333@+333333@*@+333333@*@*@*      @+ffffff@*@,@)333333@,@)@*333333@,@+333333@+      @,      @*@+@+      @+@+333333@+333333@*@+@+333333@+333333@,      @*@*@,@,ffffff@+      @,@+333333@,333333@,@,      @,ffffff@,333333@,      @,@,@*@-@-@,@-      @,@-      @-      @,ffffff@-ffffff@-      @+333333@.@,@-@-      @.      @-@-333333@-@,@-@-@-      @.      @/@.@.333333@,@.@.@.      @.      @.ffffff@-@/@.333333@.@-@/@/@-@/ffffff@.@.@.@0      @,      @,333333@1      @.@0ffffff@/333333@/@/333333@0@/@/333333@/ffffff@/ffffff@0      @0L@/ffffff@/@/333333@033333@0333333@0@0333333@0333333@0333333@/@0@.@0     @/@0333333@2     @-@1ffffff@0@0ffffff@0ffffff@0ffffff@0ffffff@0     @1333333@0333333@1@0@0333333@1@0@1@0     @033333@0fffff@0fffff@4     @1333333@1      @.@4@0fffff@133333@1@2L@1fffff@1@2@1@2fffff@033333@3      @1fffff@1333333@1@1fffff@1ffffff@2L@1@2@1fffff@1@2      @1fffff@2333333@1fffff@1fffff@1fffff@1fffff@1fffff@233333@3333333@133333@1fffff@2333333@2fffff@2fffff@2@2     @2     @3@233333@233333@3@2@233333@3333333@3@3@3@2@3@3333333@3333333@3L@3333333@3fffff@4      @3fffff@3     @333333@3@4@4@3     @3@4fffff@3fffff@4L@4fffff@4     @5333333@4     @4fffff@5333333@4@3@5L@4fffff@4333333@5333333@5ffffff@5@533333@5L@6333333@5ffffff@5333333@6333333@6333333@533333@5@6@633333@6333333@6      @5fffff@5fffff@7@6L@7     @6      @633333@5ffffff@7333333@533333@6@7     @7      @6333333@6L@6@6@5ffffff@6@5@5@633333@6@6fffff@7@5fffff@7     @6333333@633333@6fffff@6L@7ffffff@633333@633333@733333@6     @7     @7ffffff@733333@6@7@8ffffff@7@733333@7     @7ffffff@7     @7fffff@8      @8      @8     @8333333@8@7@8ffffff@8L@833333@7ffffff@8@9@9      @9@8333333@8@8     @8@9ffffff@9333333@9      @8@8@8fffff@8@8@9@9ffffff@9     @9fffff@9333333@9333333@9     @9fffff@:333333@9333333@:333333@9     @9     @9     @9fffff@:     @:L@:ffffff@:@;@:333333@:333333@:333333@;@;L@;@:fffff@;     @;ffffff@:fffff@;333333@;333333@=      @:ffffff@<@;L@;ffffff@;fffff@;333333@;ffffff@<333333@<ffffff@;@;@;@;@<@;33333@<ffffff@;     @<fffff@<      @<ffffff@;@<333333@=     @;333333@<@<L@<L@<ffffff@>ffffff@;@>     @=333333@=     @=33333@=      @=      @=333333@=L@=33333@>33333@<fffff@<fffff@>L@=33333@=     @=33333@=@>ffffff@>L@=     @>333333@=L@>      @>@>@=33333@?      @?@>L@>fffff@@@?@>     @>fffff@>L@@      @?@>@?      @@      @@333333@?333333@@&fffff@@@     @@     @>@@@@@@@     @@     @@@@Y@@@     @@ffffff@@@@ffffff@@@@@@@@fffff@@fffff@@@@@@     @@fffff@AL@@@@@@33333@@fffff@@33333@@@A@     @A&fffff@@33333@@fffff@A&fffff@@     @A@     @A      @@33333@A@AL@A@A@@fffff@A@     @A@A@Afffff@Affffff@B&fffff@A@A@B@A     @A     @Afffff@A     @Bffffff@B      @A@A@B@A@Afffff@A@BY@Aٙ@B@     @B333333@A33333@Bffffff@Bs33333@Bfffff@B&fffff@B&fffff@B     @BY@Bfffff@BY@B     @C333333@Bfffff@B     @B@Bٙ@CY@Bٙ@B     @C      @C333333@C&fffff@CY@Cffffff@C     @Bfffff@C333333@C@C@C@C333333@CL@C@     @C@     @Cffffff@Cffffff@Cfffff@Cfffff@C@Cfffff@C@     @Dٙ@C33333@C     @Cfffff@D&fffff@D&fffff@C@D333333@C     @E      @D      @D333333@D&fffff@D@D333333@DY@E&fffff@DY@D@Dfffff@D     @D33333@E      @D@E@Dٙ@D@D@Dٙ@Dٙ@Dٙ@E      @D     @E     @EL@E@D@Dfffff@Es33333@E@     @E@E      @E@     @E@E@E@E     @E33333@EL@E@Efffff@E     @E33333@E@E     @E33333@Efffff@F@E@F333333@F@F&fffff@Efffff@Eٙ@Efffff@F     @F@     @F&fffff@F@F@     @FY@F     @FL@F@FY@F@     @G333333@F@     @F33333@F@G     @F33333@F@Fٙ@G@Ffffff@G      @Ffffff@G333333@G333333@G333333@G333333@G@G333333@G@G@F33333@GY@GY@G&fffff@H@Gs33333@G     @Gs33333@Gs33333@GY@G@H@GY@Gٙ@G33333@G@G     @G     @G33333@H      @H@Gٙ@G@Gٙ@H@G@HL@G     @Hs33333@G     @H@     @Hs33333@HL@H     @H@H     @H@H@H@HY@HY@H@H@H@H     @Hfffff@H     @H@H@Hٙ@H33333@H33333@I@     @Hs33333@IY@H33333@H33333@I      @I     @I@H33333@I333333@I@     @I33333@I@Ifffff@I333333@IY@Iffffff@I33333@I     @IY@I     @I@Is33333@I     @I     @J333333@I     @Ifffff@Ifffff@Iffffff@I     @Ifffff@J&fffff@IL@Ifffff@J@I@I     @Iٙ@Iٙ@Iٙ@J@I@Iٙ@Jffffff@J@I@JY@Iٙ@J@Jffffff@JY@JL@JY@Jfffff@Iٙ@K@Jffffff@J33333@Jffffff@Jfffff@K@J333333@J33333@Jffffff@Jfffff@Jfffff@J@Jfffff@J     @K&fffff@J@K@     @K      @J33333@J33333@K      @J@K@     @K@K@     @KY@K      @Kffffff@K&fffff@K&fffff@K333333@K333333@Kffffff@K33333@K33333@Kfffff@Kffffff@Kffffff@Kffffff@K     @K&fffff@L      @Kfffff@Kfffff@K@K@K     @LL@Kfffff@Kٙ@L@LL@L      @L     @L&fffff@L&fffff@L333333@LL@Lfffff@L@Ls33333@L333333@Lffffff@LL@L33333@LY@Lٙ@Lfffff@L@Lٙ@M     @Ls33333@L     @L33333@M&fffff@Lٙ@Mfffff@L@Lfffff@L33333@M      @Ms33333@L@M     @L     @ML@M&fffff@M&fffff@M@M      @M@M     @Ms33333@Lfffff@Ms33333@M     @M@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?nO?vȴ9?I^5?}?tj~?$/?S?"`A?ffffff?$/?"`A?-V?/w?&x?ȴ9Xb?=p
=?=p
=?=p
=?C%?+I^?^5?|?Z1'?tj~?9XbN?zG?tj~?$/?-V?vȴ9X?tj?$/?bM?Q?-V?Gz?+?+?\(?j~#?A7Kƨ?Q? ěT?tj~??|hs?\(?9XbM?QR?Q?&x?j~#?^5?|?5?|h?ȴ9Xb?
=p?r ě?-V?E?M?\(\?O;d?hr ?hr!?-V?+?r ě?KƧ?7KƧ?$/?`A7?      ?
=p
?O;d?-V?=p
=?zG?Vt?
=p?\(?bM?`A7L?C$?ffffff?`A7?S?5?|h?zG??|hs?o?\(?A7Kƨ?;dZ?&x?I^5??bM?j~"?؃nP?/v?-V?GzH?/v?ȓtj~?Ƈ+I?Õ$/?9XbM?`A7?Q?Q?;dZ?vȴ9X?Q? ěT?Q?hr!?/v?"`?S?vȴ9?S?lC?^5?|?"`B??dZ1?lC?Gz??+J?1&?dZ1?S?hr!?j~"?vȴ9?vȴ9?bM?lC?lC?"`B?"`A?\(?"`B?S?Gz?E?+?E?Gz?1&?E??E?
=p
?ȴ9Xb?E?+?+?^5?|?XbM?+?+?tj~?lC?+J?1&?+?ȴ9Xb?+?"`B?ȴ9Xb?1&?tj~?E?O;dZ?+I?"`B?+J?O;dZ?E?E?^5?|?^5?|?+J?E?Gz??|hs?KƧ?"`B?dZ1??+?+?"`B?E?"`B?
=p
?E?+?+?dZ1?lC??lC?XbM?lC?lC?XbM?lC?lC?lC?lC?lC?dZ1?dZ1?"`B?S?1&?vȴ9?lC?lC?"`A?tj~?bM?"`B?"`B?E?lC?lC?lC?lC??lC?lC?lC?lC?dZ1?+J?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?lC?^5?|?^5?|?lC?lC?lC?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?lC?lC?-V?lC?lC?lC?p
=q?"`B?p
=q?dZ1?1&?lC?dZ1?1&?lC?lC?lC??lC?lC?lC?lC?lC?lC?lC?/v?j~"?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?^5?|?Gz?lC?vȴ9?dZ1?lC?lC?lC?lC?lC?lC?lC?lC? ěT?Gz?1&?lC?lC?1&y?/v?lC?-V?lC?(\)?^5?|?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?p
=q?lC?lC?vȴ9X?E?j~"?(\)?/v?hr!?^5?|?E?lC?vȴ9X?lC?lC?-V?lC?lC?-V?lC??E?(\)?E?lC?lC?hr!?(\)?vȴ9X?lC?lC?lC?lC?lC?lC?lC?Q?/v?vȴ9X?-V?lC?lC?lC?1&?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?p
=q?lC?lC?5?|h?lC?1&y?hr!?lC?lC?lC?lC?^5?|?j~"?1&y?lC?lC?lC?lC?lC?lC?-V?1&y?      ?;dZ?hr!?;dZ?lC?hr!?hr!?E?lC?lC?vȴ9X?lC?1&y?;dZ?lC?lC?lC?lC?lC?7KƧ?j~"?lC?vȴ9X?-V?1&y?lC?-V?lC?Gz?"`B?lC?-V?lC?lC?lC?lC?p
=q?1&y?lC?j~"?E?/v?lC?lC?E?(\)?/v?1&y?lC?E?lC?lC?E?lC?E?lC?1&y?hr!?p
=q?j~"?1&y?lC?lC?lC?lC?XbM?;dZ?(\)?-V?lC?Q?lC?/v?j~"?lC?lC?lC?-V?p
=q?/v?lC?1&y?p
=q?lC?|hr?hr!?-V?1&y?lC?j~"?/v?E?lC?(\)?p
=q?-V?lC?lC?E?lC?lC?lC?-V?(\)?      ?      ?vȴ9X?lC?E?lC?-V?lC?lC?lC?-V?lC?lC?E?lC?lC?-V?1&y?lC?1&y?E?Q?/v?E?lC?j~"?      ?(\)?p
=q?lC?;dZ?lC?lC?Q?Q?lC?Q?E?5?|h?-V?(\)?lC?lC?(\)?      ?lC?lC?-V?(\)?lC?lC?lC?p
=q?lC?lC?hr!?`A7L?E?lC?lC?lC?lC?p
=q?"`?lC?      ?-V?lC?lC?5?|h?5?|h?/v?p
=q?-V?lC?Q?-V?lC?lC?lC?lC?Q?p
=q?p
=q?lC?1&y?-V?1&y?/v?lC?lC?vȴ9X?1&y?lC?lC?|hr?lC?p
=q?p
=q?-V?      ?-V?E?p
=q?-V?p
=q?      ?      ?E?vȴ9X?j~"?lC?p
=q?(\)?vȴ9X?lC?lC?5?|h?lC?E?;dZ?lC?5?|h?lC?lC?1&y?      ?      ?E?(\)?5?|h?Q?      ?-V?-V?E?;dZ?(\)?E?;dZ?j~"?lC?lC?lC?lC?p
=q?-V?A7Kƨ?lC?E?1&y?      ?      ?-V?hr!?(\)?      ?(\)?lC?/v?/v?j~"?      ?vȴ9X?lC?lC?|hr?(\)?-V?lC?5?|h?-V?|hr?      ?      ?      ?-V?&x?E?vȴ9X?ěS?lC?lC?5?|h?5?|h?1&y?-V?E?hr!?      ?p
=q?j~"?;dZ?-V?p
=q?E?-V?"`?      ?1&y?/v?p
=q?j~"?-V?lC?E?;dZ?lC?lC?nP?ěS?-V?      ?;dZ?E?-V?lC?
=p?E?1&y?lC?|hr?j~"?vȴ9X?A7Kƨ?ěS?/v?hr!?p
=q?      ?vȴ9X?      ?      ?5?|h?vȴ9X?      ?      ?nP?|hr?E?p
=q?lC?lC?lC?lC?lC?"`?-V?A7Kƨ?Q?vȴ9X?/v?-V?j~"?bM?E?E?|hr?-V?vȴ9X?p
=q?-V?lC?lC?E?vȴ9X?|hr?5?|h?E?vȴ9X?lC?hr!?Q?p
=q?5?|h?E?E?ěS?"`?vȴ9X?|hr?E?      ?5?|h?|hr?5?|h?p
=q?      ?Q?|hr?/v?-V?1&y?lC?1&y?      ?      ?5?|h?      ?/v?-V?hr!?
=p?5?|h?hr!?"`?/v?      ?      ?;dZ?lC?vȴ9X?lC?E?E?lC?5?|h?lC?|hr?vȴ9X?|hr?lC?E?lC?E?1&y?(\)?      ?/v?      ?lC?lC?-V?/v?5?|h?      ?Q?vȴ9X?5?|h?5?|h?E?5?|h?1&y?/v?vȴ9X?p
=q?"`?      ?      ?      ?/v?nP? ěT?vȴ9X?vȴ9X?E?-V?5?|h?p
=q?-V?5?|h?      ?|hr?j~"?E?5?|h?1&y?/v?lC?1&y?      ?hr!?|hr?lC?lC?5?|h?p
=q?lC?5?|h?/v?      ?5?|h?vȴ9X?      ?vȴ9X?hr!?vȴ9X?p
=q?vȴ9X?E?lC?E?      ?bM?nP?      ?E?;dZ?vȴ9X?Q?/v?p
=q?E?lC?Q?GzH?j~"?|hr?-V?|hr?-V?vȴ9X?      ?;dZ?-V?/v?      ?5?|h?E?7KƧ?GzH?/v?-V?lC?lC?lC?lC?/v?bM?Q?E?/v?/v?lC?/v?|hr?hr!?j~"?lC?lC?E?-V?5?|h?vȴ9X?5?|h?&x?      ?p
=q?Q?lC?vȴ9X?      ?j~"?|hr?Q?-V?lC?lC?lC?1&y? ěT?(\)?vȴ9X?lC?hr!?|hr?lC?      ?      ?(\)?lC?E?(\)?vȴ9X?      ?      ?$/?/v?p
=q?E?-V?lC?-V?/v?p
=q?|hr?-V?1&y?      ?"`?-V?|hr?hr!?E?Q?-V?E?&x?      ?j~"?Q?lC?vȴ9X?j~"?GzH?5?|h?5?|h?j~"?vȴ9X?/v?/v?lC?vȴ9X?E?      ?      ?      ?(\)?      ?"`?p
=q?-V?lC?lC?vȴ9X?1&y?p
=q?vȴ9X?j~"?lC?lC?|hr?vȴ9X?5?|h?hr!?      ?p
=q?-V?nP?lC?bM?;dZ?vȴ9X?"`?5?|h?A7Kƨ?      ?-V?lC?lC?lC?Q?      ?/v?|hr?1&y?"`?      ?vȴ9X?vȴ9X?      ?      ?p
=q?-V?lC?"`?p
=q?vȴ9X?5?|h?j~"?      ?Q?(\)?      ?lC?(\)?5?|h?;dZ?&x? ěT?1&y?lC?lC?      ?E?5?|h?;dZ?lC?-V?hr!?;dZ?lC?-V?E?5?|h?
=p?bM?      ?-V?-V?lC?Q?/v?      ?-V?p
=q?vȴ9X?5?|h?vȴ9X?      ?p
=q?vȴ9X?      ?vȴ9X?|hr?      ?vȴ9X?lC?lC?1&y?|hr?-V?/v?      ?hr!?lC?vȴ9X?Q?j~"?E?lC?E?;dZ?      ?Q?Q?E?      ?p
=q?lC?p
=q?p
=q?hr!?lC?"`?/v?lC?lC?vȴ9X?-V?j~"?vȴ9X?E?lC?      ?nP?      ?      ?E?lC?vȴ9X?5?|h?1&y?"`?A7Kƨ?lC?ěS?5?|h?5?|h?p
=q?lC?E?5?|h?p
=q?|hr?      ?(\)?vȴ9X?"`?p
=q?;dZ?lC?;dZ?;dZ?lC?lC?j~"?p
=q?lC?E?p
=q? ěT?lC?|hr?/v?lC?;dZ?vȴ9X?hr!?      ?lC?E?-V?hr!?vȴ9X?j~"?;dZ?E?-V?1&y?lC?;dZ?bM?|hr?      ?p
=q?1&y?"`?5?|h?lC?"`?vȴ9X?-V?1&y?vȴ9X?|hr?lC?lC?/v?      ?      ?"`?lC?lC?5?|h?j~"?/v?-V?      ?      ?      ?;dZ?lC?lC?lC?"`?ěS?p
=q?/v?E?5?|h?5?|h?&x?      ?      ?vȴ9X?lC?/v?p
=q?lC?(\)?vȴ9X?|hr?lC?lC?lC?lC?lC?E?5?|h?lC?lC?lC?lC?lC?lC?5?|h?p
=q?lC?1&y?"`?lC?lC?lC?lC?Q?      ?j~"?vȴ9X?      ?"`?lC?lC?lC?E?(\)?vȴ9X?vȴ9X?(\)?      ? ěT?$/?lC?lC?"`?lC?lC?lC?1&y?Q?/v?5?|h?lC?lC?lC?lC?lC?E?p
=q?-V?      ?      ?      ?5?|h?5?|h?lC?lC?lC?lC?lC?lC?lC?-V?j~"?5?|h?lC?lC?lC?lC?lC?"`?      ?j~"?hr!?-V?j~"?      ?      ?p
=q?;dZ?"`?/v?/v?lC?lC?p
=q?;dZ?lC?lC?lC?|hr?bM?      ?      ?hr!?(\)?E?/v?lC?j~"?5?|h?j~"?-V?lC?lC?lC?lC?lC?lC?lC?lC?(\)?;dZ?lC?lC?lC?lC?lC?lC?vȴ9X?"`?Q?/v?p
=q?lC?lC?lC?lC?lC?hr!?1&y?lC?1&y?p
=q?;dZ?/v?lC?lC?lC?1&y?-V?lC?lC?p
=q?lC?lC?lC?lC?lC?lC?"`?j~"?j~"?      ?/v?E?j~"?j~"?5?|h?1&y?p
=q?lC?lC?-V?lC?lC?lC?lC?lC?lC?E?p
=q?-V?"`?5?|h?lC?lC?lC?E?vȴ9X?lC?lC??j~"?      ?E?lC?lC?      ?5?|h?j~"?lC?lC?lC?lC??-V?lC?lC?Q?/v?lC?lC?lC?lC?j~"?-V?-V?vȴ9X?hr!?hr!?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?hr!?j~"?lC?E?lC?/v?(\)?5?|h?lC?lC?lC?lC?lC?lC?lC?5?|h?lC?lC?lC?lC?lC?;dZ?5?|h?lC?lC?p
=q?p
=q?-V?p
=q?E?;dZ?lC?lC?E?j~"?lC?/v?(\)?lC?lC?lC?Q?lC?lC?p
=q?5?|h?lC?lC?lC?lC?lC?lC?lC?lC?-V?lC?E?      ?p
=q?lC?E?-V?(\)?/v?5?|h?lC?lC?lC?lC?5?|h?lC?lC?5?|h?p
=q?lC?-V?5?|h?lC?lC?lC?"`?lC?lC?lC?lC?p
=q?lC?hr!?p
=q?/v?/v?lC?lC?j~"?E?lC?lC?-V?hr!?lC?5?|h?lC?lC?lC?5?|h?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?lC?lC?dZ1?j~"?lC?/v?/v?lC?lC?lC?lC?lC?vȴ9X?"`?lC?"`A?vȴ9?/v?vȴ9X?lC?lC?lC?/v?1&y?lC?+J?lC?lC?p
=q?lC?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?j~"?vȴ9X?5?|h?lC?lC?/v?lC?lC?lC?Gz?"`B?E?lC?lC?lC?lC?lC?lC?lC?(\)?E?lC?S?lC?lC?E?lC?lC?XbM?lC?lC?lC??lC?lC?lC?lC?Gz?^5?|?lC?lC?lC?lC?lC?lC?lC?lC?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?5?|h?lC?lC?lC?lC?/v?(\)?lC?lC?-V?E?vȴ9?vȴ9?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?j~"?lC?Gz?vȴ9?      ?S?Gz?lC?lC?lC?lC?lC?lC?lC?1&?lC?lC?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?lC?lC?lC?lC?lC?/v?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?+J?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?lC?lC?lC?1&?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?-V?lC?lC?lC?"`B?"`A?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?-V?lC?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?XbM?lC?lC?lC?lC?lC?lC?lC?lC?lC?1&?hr!?S?bM?lC?1&y?vȴ9?lC?lC?lC?lC?"`A?vȴ9?lC?lC?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?dZ1?+J?"`A?Gz?1&?lC?1&?lC?lC?lC?lC?lC?lC?lC?lC?lC?1&?lC?lC?-V?lC?"`?lC?lC?lC?lC?/v?/v?lC?lC?lC?lC?lC?lC?lC?-V?lC?lC?lC?lC?lC?lC?"`B?lC?lC?lC??S?lC?E?"`B?dZ1?lC?lC?p
=q?lC?lC?lC?lC?+J?lC?vȴ9?Gz?lC?Gz?1&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@O@Offfff@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O@Offfff@Offfff@O@Offfff@O@O@O@O@Offfff@Offfff@Offfff@Offfff@O@Offfff@O@O@O@Offfff@O@Offfff@O@Offfff@O@O@Offfff@Offfff@O@Offfff@O@O@Offfff@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O@O     @Offfff@O@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O33333@O33333@Offfff@O33333@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O33333@O     @O     @O@Offfff@P      @P9@PY@Pffffff@Pfffff@P@Pfffff@Pfffff@P@Pfffff@Pٙ@Pfffff@Pfffff@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Qfffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@P@P@Q      @P@P@P@P@P@P@Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Qfffff@Qfffff@Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q      @P@Qfffff@Qfffff@Q@Qfffff@Qfffff@Q@Q      @Q      @Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q33333@P@Q      @Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q@Q@Q@Q33333@Q@Q33333@Q@Q@Q33333@Q@Q33333@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q      @Q@Q      @Q33333@Q33333@Q      @Q      @Q@Q@Q      @Q      @Q@Q33333@Q@Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q@Q@Q      @Q@Q@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q33333@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@P@Qfffff@Q@Q@Q@Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@P33333@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q33333@Q@Q      @Q@Q      @Q      @Q      @Q33333@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q      @Q&fffff@Q      @Q@Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q      @Q      @Q&fffff@Q      @Q      @Q      @Q&fffff@Q&fffff@Q      @Q@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q33333@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q&fffff@Q      @P`     @Q      @Q&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              P12                                     2                                       BC߾3P