CDF       
      pressure  '   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P3     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.630623Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @(         data_max      @(         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     8  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?         data_max      @8        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      8  G   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      P  `   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @Gݗ+   data_max      @ sPH   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       8  g   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      P  D   salinity                	long_name         salinity   units         PSS-78     data_min      @@0U2a|   data_max      @A%U=   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      8     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      P     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @%   data_max      @rD   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        8     	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      P  T   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?+   data_max      ?bM   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      8  Ť   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      P     PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       8  ,   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      P  d   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @Lffffff   data_max      @Qfffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     8    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      P    station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( $<   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( $d   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min         data_max         C_format      %10d       $   latitude               	long_name         latitude   units         	degrees_N      data_min      @HPbM   data_max      @HPbM   C_format      %9.4f          $   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _?|h   data_max      _?|h   C_format      %9.4f          $   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        $   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        $@(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      @(      ?      @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @m\@MjO@䎊q@W@PH@|@g@|@J@SMj@m8@!-w2@9XbN@#@#@3@#@Y|@C-@)_@"@ï@?@&IR@K]d@Q@а{@a@O@ۥS@>@3@O;@{J#:@x@޸Q@PH@_F@ٙ@D*@ߤ?@ڹ@o@1@/V@#@e@wkQ@<쿱@rG@&@4j~@ZY@tj@y@ S&@ 
\@ jf@ @ E@ sPH@ <64@ T`d@ R@ 1&y@ 	oiD@ zxl"h@ &IR@p
=@<64@ڹZ@v@Z@Q@~$@s@)y@F@1@33333@VϪ@rGE@1.@3@}H@1'@8YJ@As@#9@F]c@eں@U=@y=c@ᰉ@zH@}<64@rᰊ@d%1@X_F@S@N@O͞@O\(@NMj@ES&@B\(@Bu%F
@A7Kƨ@@C@@6@=p
=@/4֡a@,<쿱@*0U2a|@',@%F
L0@$/@U=@S&@͞@
@@
L/@YJ@
L/@
L/@g8}@,zxl@@$/@ IQ@      @˒:)@m\@[W>@Zc@@8F]d@]+j@:@W'@?@ѷX@vFs@kC,z@glC@jOv`@p:~ @kQ@kQ@oO
M@cA \@A7K@jf@Fs@Q@ȴ9X@%F
L@SMj@sg@Y|@hr!@TɅ@RT`e@Mj@p@h	ԕ+@1-@
%@ ѷ@[W>@($x@!.H@j~#@9XbN@w1@,@@N@յsh@҈@ ѷ@O;dZ@)^	@k~(@nP@\N<@64@z@
=q@a@@hr!@JL@
=p@vȴ9@Ov_خ@>@	@ěT@h	ԕ@\)@	ԕ+@fA@e@
=p@eO@}Vm@TɆ@xF@ěT@$@m@qiC@I^5@|hr@iDg8~@LL_@=b@2-V@(@(Xy=@(	ԕ+@'lC@$Z1@>6z@Q@m8@ᰊ@O;@쿱[W?@fB@+a@$tS@ԕ*@7Kƨ@1@~($@O;d@s@q&x@cS&@>BZc @1l@/O
M@$%1@Fs@ⶮ}Vm@*0U@+j@t֡a@g-@eS@bwkQ@ae@`	k@\?@NT@@     @=ڹZ@>BZc @>($x@3|@
=p@sP@H@oiDg@s@?|h@Ж@"h	ԕ@xF]@S&@zxl"h
@y#w@yXbM@wXe@v}Vl@s|@sMjO@jg	@cS&@_U=@TO
M@K'/@EQ@8F]d@,>B[@&'@$e@#A [@"e+@ d8@حV@@1&@@?@J@@@՛=K@sP@Ƨ-@!.H@@͞&@VϪ@6z@RT`e@@`A7L@M@A7K@쿱[W@-V@"`B@|@|@D*@e+@,<@:)y@@:@w3@W>6z@0{@)y@'	k@"`A@@Mj@'/W@_o @
:@	7KƧ@ 4m9@YJ@Fs@@q@qu!@s@+a@ae@@VϪ@@
=q@+a@6@Mj@+@\(@xF]@}<64@o@lzxl"@eO
@P{@.t@<64@-@TɅo@%F
L@ԯO
M@̘_@ǮzH@z@|@-V@U=@0U2a|@B@ᰉ'@^@@ ѷ@|PH@zC\@{~$@lzxl"@QN;5@3g	l@-(@ce@c	@D*@)^@)^	@]cf@$/@v@֡a@fA@-w1@Ov_@}Vl@@v@"h	ԕ@0U2a|@	k@S@@@n@͞@qi@@jOv@@@ ѷ@˒:)@|쿱[@y#w@t3@o@mw1@lC@jfB@h	ԕ+@glC@de@_U=@SMj@5?|h@'lC@!e@u@vȴ@8YJ@p:@*0U@+I@}Vl@/@ߤ?@cA @C,zx@6C@PH@҈p:@\(@̈́M:@L_@I^5?@s@˒:)z@p:@s@M:@s@˒:)@|hs@6z@G{@YJ@@H@\)@`A7L@Z@ae@iB@>6z@{@?@z)y@q2W@jd7@ezxl"h@bwkQ@a@N@_حV@[W>6z@WsPH@QN;5@I7KƧ@A$/@49XbN@.t@..2@-
qv@쿱[W@PH@@@@N;6@N;6@|@xF]@Zc@:S@v@Q@~@m]@PH@PH@PH@PH@(@kP@1@+jg@E@A [@A [@ ě@2X@
(@.2@JL@N;6@/{J#@E84@©@Zc@K]@@1@.2@@Q@W>6z@y=c@Z@@oiD@@@JM@NU@}K]@{A@{~$@{A@}p
=@|64@v_ح@s33333@q[W>6@o hۋ@kQ@j~"@j0
@h@cS&@O@C,zxl@<PH@<PH@8Q@7eں@6C-@6+jg@5%F
L@3E@2GE85@#S&@
L_@}Vl@빌~($@	k@Z1@Z@
=p@n.3@M@[6@ޞ@u@5?|@/w@"`B@حU@ѷX@bM@;dZ@*0U@H@*0U@O;dZ@:@'/W@?@?@[W?@,<@tSM@e+@A7K@Q@Q@b}@+@&@_F@O;d@&@p:@N;6@䎊@v_ح@)^	@9Xb@)^@Fs@M:@Zc@ [7@.H@|?@yD@sߤ@lC@e1@b}Vm@_	@^iB@\N;@U=K@FFs@8)@0'RT@%zxl"h@$tSM@"M@ ҈p@1&@2a|@T`d@Vu@	 ѷ@-@$t@\(@-@6@՛=K@_p@)^	@1@.2@&@e@u@qj@)^@~($x@wrG@w+@u!.@t9XbN@q2W@pU2a|@l>B[@h@c
=p@a-w1@[Q@Sa@O@P$tT@NT@MjOv@H9Xb@As@6ȴ9X@5'0@1&x@-C\@,>B[@,VϪ@$xF@;dZ@c	@
L/{@$/@m\@E@>B@?@s@
qv@P{@	k@S@,=@n@qu"@@v@1@GE85@
qv@	k@qu!@t@n@T@K]d@*0@@vȴ9X@t3@o-V@m
qv@kU=@cn.3@P{@>\N<@/O
M@&@wkP@|@_o@YJ@@H˒@#x@^5?|@E@m\@ hۋ@"h	ԕ@~"@~"@B@TɅ@@\)@ۋq
@@lC@,<@@zxl"h@+a@/@C,@M@ae@ae@n.3@A [@C,@W>6z@$/@~$@^@	@-
@@=K@_p@rGE9@As@_@^5?}@Fs@}K]@n}Vl@m8Y@lq@l"h	ԕ@ix@V@QX@N!R<@K:)z@Jn@HK]c@Eo i@A@>6z@<64@;dZ@;lC@4SMj@+P{@䎊r@!-w1@$@u%@@*0U@,@ܬ1&@_o@Ϫ͟@+@~($@d7@@>@)^@	 @L/{@{5Xy@n1@h@ezxl"h@dZ1@]+j@\?@T@LcA \@Gݗ+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @@kP|@@{m@@{m@@^5?|@@T`d@@ᰊ@@@@ ě@@Y@@@@,<@@@@nO@@@4n@@6C@@0U2a|@@0U2a|@@ᰊ@@74@@1&y@@!.H@@E@@1@@Ϫ͞@@sPH@@@@	.H@@
m\@@
\(@@ ѷY@@qi@@bM@@7KƧ@@n@@{m@@sP@@q@@SMj@@zG@@/@@!.H@@cA @@1.@@@@1@@4֡a@@)^@@xl"h
@@6z@@,<@@" ѷ@@+q@@7v_ح@@O;dZ@@X1&x@@fx@@jg	@@l֡a@@pp:@@wkP@@}1@@:~ @@*1@@p:~@@o@@/w@@S&@@IQ@@^@@b}@@)y@@74@@C%@@@@
=p@@s@@2W@@_@@8YJ@@|@@*1@@n/@@2X@@-@@`A7@@R@@@@(@@6z@@TɅo@@8YK@@T@@Ft@@@@2a|@@Ft@@'R@@!-w2@@Ÿ@@Ϫ͟@@
=p@@.H@@˒:*@@\)@@$/@@N;5@@ɓ@@ɰ'R@@s@@SMj@@?@@qu"@@fA@@͊ڹZ@@͔O
@@zG@@,@@lC@@+@@ ѷ@@ѽ@@o@@I^5@@)y@@ҟvȴ@@I^@@jf@@ӹ~($@@%2@@M:@@ԇ#@@\@@p:~@@"@@$tS@@y=c@@ٜu@@ۥS@@Z1@@ܘ_@@?@@ܢ3@@V@@u@@ލ@@\(@@ߍO;d@@-@@Q@@u!S@@=p
@@⒣S&@@҉@@	@@MjO@@]cA@@tj~@@Q@@Z@@Fs@@Ʌoi@@>@@ce@@jOv@@C\@@@@\@@fA@@=K@@,=@@$/@@
=p@@索3@@حV@@1&x@@l"h	@@p:@@*0U2a@@XbM@@2W@@)y@@m\@@&@@Z@@@@6@@\N@@M:@@#@@u"@@K]@@'0@@*0@@fA@@ ѷY@@Ov_خ@@T@@쿱[W@@$tS@@U=@@o@@$tS@@@@@@>BZc@@u!@@u%F@@ѷX@@	k~@@ [7@@-w1@@=b@@k~(@@Y}@@a|Q@@p:@@ ě@@,<@@ ѷ@@C,@@I^@@xF]@@>@@Q@@/w@@fA@@ڹZ@@U=@@S@@fffff@@t@@
=p@@As@@lC@@o @@	ԕ+@@A7K@@_F@@_F@@Q@@H@@[6@@r Ĝ@@hۋq@@K]c@@oiDg8@@-
@@@@@@{@@\)@@@N@@0
)@@^@@rGE8@@rGE8@@o hی@@o hی@@|@@:)y@@JL@@T`d@@kP|@@qiC@@L_@@n@@,<@@s@@,zxl@@P{@@Z@@Z@@a@N@@a@N@@~$@@@@@@Z@@Ƨ@@C]@@ߤ@@@"h	ԕ@@PH@@wkP@@C@@*1@@_@@3@@TɆ@@O
M@@?@@j~@@֡a@@'0@@/w@@ce@@}H@@zxl"h@@ݗ@@!R@@@@1@@sh@@@@cA @@8YK@@8YK@@?@@?@@
qv@@?@@S@@
qv@@S@@S@@oiDg@@ᰉ@@!.@@ڹ@@C\@@
L/@@+jg@@BZc @@_o @@E@@oiDg@@S@@S@@(@@oiDg@@E@@E@@t@@u@@@@Ov_@@$/@@5?|@@8YJ@@IQ@@A@@C-@@
=p@@H˒:@@\(@@o@@eں@@-V@@o @@˒:)@@@@K]d@@vȴ9@@;dZ@A bM@A @@rG@@+@@3@@?@@$tS@@kP@@ݗ+@@	@@ݗ+@@-V@@-V@@-V@@?@@&@@&@@	k@@͞@@r@@zH@@ݗ+@@O;d@@O;d@@{J#:@@v_ح@@$tS@@kP@@kP@@?@@͞@@?@@kP@@ݗ+@@$tS@@ݗ+@@kP@@+@@Vϫ@A 1&x@A IQ@A )@A @@A TɅ@A ѷX@A `A7@A {@AA [@Au@A|@AiB@As@A䎊@A6C@A@4n@A=p
@A@4n@A0U2a|@A&IR@A&IR@A3@A@4n@AGE85@AJL@AJL@AQ_@Ah	ԕ@AS&@A,zxl@AA [@A"h	ԕ@A9XbN@ASMj@Aj~#@A#@A@A*0@A>@A5Xy>@A?|h@AO;dZ@AO;dZ@A`A7L@Ace@Ap
=@AO
@AXy=@A\(@A(@AoiDg@At@A
(@A@A$/@A($x@A+jg@A5?|@A5?|@A8YJ@AL/{J@AR<6@Afffff@Al!-@As@Az@A%@A$t@A$t@AO;@A@Am\@A@A4֡a@A_o@Aeں@AsPH@Av_ح@A{J#:@AK]d@A@A#@AK]c@AbM@Atj@A4m@A4m@A
(@A	@N@A	+@A	-w1@A	4J@A	4J@A	-w1@A	7KƧ@A	A [@A	k~(@A	o@A	@A	n.@A	l@A	l@A	(@A	(@A	l@A	l@A	l@A	X@A	^5?}@A	D@A	2W@A	N;6@A	ᰉ'@A	ᰉ'@A	e@A	s@A	e@A	s@A
u%F@A
nO@A
{m@A
S&@A
>B@A
g	@A
`A@AS&@Au%@AnP@A	@A6z@A9@A@N@AP{@Ag	l@Atj~@AQ@AQ@Aq@A*0U2@Aq@Am]@A@Am]@Aq@A~($@A|@A҈@AlC@Ag@A@As@As@A1&y@A%1@Aj~#@Aqj@AS@AS@A3@A1&@A3@ATɆ@AO
M@AO
M@A?@Ahr@A
!.H@A
p
=@A
ڹZ@A
hr!@A
Xy=@A
v@A
%@A
@A
v@A
U=@A
1@A
n/@A
@A
\(@A
Ϫ͞@A
?@A
E@A
(@A
ᰉ@A
ᰉ@A
(@A
ᰉ@A ѷY@A
!.@A
E@A8YJ@Ac	@As@A%@Aqi@AFs@AFs@AO;@Aaf@A6z@A}Vl@A6z@A2X@A@Am\@AA@A&I@Am\@AϪ͟@Aߤ?@Ax@A@Ax@A쿱[W@AMj@AFs@A hۋ@A
=p@A@A+I@AAs@ART`e@Ab}V@Ay@Ay@A{J#:@AzH@A-@AbM@A'RT`@AK]c@AH@AQ@AXy=@Al"h	@An@A-
@Au%F@Ad8@A9Xb@Ap:@A	k@A&x@ATɅo@Ak~(@A@A@AlD@A#9@AC\@AT`d@AM@AkP|@A ѷ@A&@As@AC,z@AC,z@APH@A	@A6z@AS@A]cA@A{J#9@AQ@Aߤ@AƧ@A|@AQ@Aݗ+k@A@A@AM:@ASMj@Ag8}@AzG@AzG@A~($x@A@A7@A֡a@A!.H@A84֡@A\@A\@AjOv@Aݗ@A%@A\(@AH˒@AS@AE@A4K@AOv_خ@AVu@AIQ@A,<@A&I@A+@A@A,@AlC@AO;d@Aݗ+@A͞@AK]d@A+@A@AbM@A'RT`@AK]c@A[6@Al"h	@A
=q@A@A|Q@Ao@A@Ae+@AW'@AL_@AL_@A ě@An@AW@A͞&@Am@Am\@A	@A)^	@A33333@A,zxl@A9@A=K^@A@N@A@N@A@N@AF]c@AJ#9@AMjO@AP{@AW>6z@AS@AW>6z@Aa@N@AdZ@Ajf@An.3@AdZ@Aa@N@Ajf@A$@AL_@AZ1@A1&@A?@AɅoi@A*0@A*0@A2a|@A84֡@A84֡@AO;dZ@Ap
=@A!R@AS@A+jg@A!R<@A!R<@A!R<@A5?|@AQ@AA@A쿱[W@AFs@A"@AFt@Av@A4֡a@AE84@AXe,@A_o@Aeں@A	k@A@@A -
q@A $xG@A A7K@A >BZc@A hۋq@A u%F@A!R<6@A!o@A!"`@A!@A":)y@A"Y@A#nP@A#,zxl@A#Z@A#m]@A#Q@A#҈@A$<쿱@A$3@A$@A$/@A$hr@A%[@A%qu"@A%Vl!@A%$/@A%U=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @r6fffff@r8     @r4@r6fffff@r<@r8     @r4@r0     @r8     @r;33333@r)@r)@r8     @r333333@r>fffff@rD@r1@r@     @r4@r9@r@r9@r4@rD@r;33333@r(     @r333333@r333333@r)@rfffff@r      @r&fffff@r$@r     @r&fffff@r      @r,@r#33333@r!@r     @rfffff@qfffff@r      @qfffff@q@qٙ@q@qFfffff@p33333@o@mvfffff@kvfffff@iٙ@h@h@g33333@g@g@     @f     @f@fS33333@e@e@e      @d@d333333@d@d      @d	@d      @d      @d33333@d@d      @c@cffffff@c@b@b@b@b33333@b@b33333@bfffff@bFfffff@a@a33333@a     @a,@`@`33333@`     @`\@`L@`Vfffff@`Ffffff@`fffff@_fffff@_ffffff@_@^@^l@^S33333@^@^9@^,@^      @^,@]ٙ@\@\fffff@\l@\@\l@\s33333@\,@\@\      @[@[fffff@\@[33333@[     @[     @[@[@[@[     @[     @[s33333@[y@[y@[fffff@[     @[fffff@\      @[33333@[     @[9@[ffffff@[y@[333333@Z@[S33333@Z@Z33333@Z     @Z33333@Z33333@Z@Z     @Z     @Zfffff@Z     @Z@Z@Z33333@[      @Z@Zffffff@Z,@Y33333@Y,@Xfffff@X33333@Y      @YS33333@Y33333@Xfffff@X@     @X      @X&fffff@W@X33333@X33333@W@W@Wfffff@W33333@W33333@Wfffff@W@Wfffff@Wy@W33333@W@W     @Wfffff@W     @W33333@W@W33333@W33333@XL@Xffffff@X@X@X@Xfffff@X@X     @X33333@Xfffff@X     @X     @X@Y33333@Y9@Yy@YFfffff@Y@Yfffff@Y@Yfffff@Yfffff@Yy@Yffffff@Ys33333@Y9@X@X33333@W     @Wy@W`     @WL@WFfffff@W33333@V     @V@V@V33333@V     @Vy@VY@V@     @V`     @V@V33333@V33333@V@Vfffff@V33333@Ws33333@W33333@W@W33333@Wy@Ws33333@Ws33333@Wffffff@WL@W333333@V     @W      @Vٙ@Vfffff@V@V@VY@V@     @VFfffff@V9@V@     @V,@V9@Vfffff@Vfffff@Uٙ@U33333@U33333@V@U33333@U     @U@U333333@UL@Ul@U,@U`     @U@     @U      @T     @T@T@Tfffff@T33333@T@T33333@Ts33333@T@Tffffff@Ty@TY@TY@Tffffff@S@S33333@S33333@Sfffff@SY@SY@SS33333@Ss33333@Sy@Sffffff@Sffffff@S9@Sfffff@SY@Ss33333@S@     @S,@S9@SL@SL@S@S,@Rfffff@R@Sfffff@Sl@Rfffff@S,@Sfffff@S      @Sfffff@S,@S@S333333@S@S      @S&fffff@S      @R33333@R@Rٙ@Rfffff@R@Rٙ@Rffffff@R9@R@Qfffff@R      @Q     @R&fffff@Qfffff@Q     @Q     @Qfffff@Q@Q     @Q     @QY@Q`     @Qy@Q333333@QY@Q,@Q9@QS33333@QY@Q      @Q@Q9@Q&fffff@Q33333@Q9@Q9@Q      @Q      @Q      @Q@Pfffff@Q      @Q      @P33333@P@P@P33333@Pfffff@Pfffff@P33333@Pl@P`     @Py@Py@Py@Pffffff@PS33333@P33333@P      @O33333@O33333@N     @N@Nffffff@Ns33333@N@Nffffff@NY@M@Lٙ@Lfffff@Lfffff@M333333@L@Lfffff@L33333@Lٙ@M      @L33333@Lٙ@L@L@Lfffff@L@LY@LL@Kfffff@KY@Jfffff@J&fffff@J&fffff@I     @Is33333@Iٙ@Is33333@I@     @H@Hٙ@H     @H@Hٙ@HY@H@H     @Hs33333@H     @H&fffff@H&fffff@H      @G33333@G33333@H@Gffffff@H      @G     @G33333@G     @GL@G@GL@G333333@G     @Gٙ@F33333@G@G333333@G@G@     @Ffffff@Ffffff@FY@F&fffff@E@E     @E33333@Efffff@E33333@E     @E@E@EL@Effffff@E&fffff@D@D@D     @Dfffff@D&fffff@C33333@D@Cٙ@D33333@Dffffff@D333333@C     @Cfffff@Cٙ@C     @C33333@Cfffff@CY@C     @C     @C@Cfffff@C     @Cs33333@C33333@CL@Cfffff@C33333@C@C@C@CL@C@Bٙ@Bٙ@C      @Bٙ@B     @B@B@B@B     @A@B@Afffff@BL@B@     @Aٙ@B&fffff@Afffff@A@Afffff@B@A33333@Aٙ@A@A33333@A@A@A33333@A33333@A33333@Affffff@Afffff@A@AL@A33333@A@A@@@A      @@fffff@A&fffff@@s33333@A@@     @@@@fffff@@@@@@@@ٙ@?ffffff@@Y@?@?fffff@@      @?333333@?33333@?@?33333@@&fffff@?      @@      @?L@?ffffff@?     @?L@@      @@      @?33333@>@?@?@>@?ffffff@?      @<@?333333@>     @>33333@<ffffff@>L@>@=     @>L@>333333@=@>333333@>333333@=     @=@=@<@=33333@=@>L@=@=@>@=L@>L@>L@>@=fffff@=333333@=ffffff@=@=L@=      @<fffff@<     @<     @:ffffff@<33333@:@:33333@;     @;@:33333@;      @;      @:@;      @:@:ffffff@:     @:      @:ffffff@:333333@9     @:      @9@:L@9      @9L@:333333@8333333@9      @9L@633333@8L@8@6333333@8L@8     @6@8@7@6fffff@7      @7@7@7fffff@6ffffff@6fffff@7      @6      @733333@7333333@5@6ffffff@6@6      @6      @5333333@6@5L@5     @6L@6ffffff@533333@433333@6      @533333@3@5@433333@4      @4@4L@5333333@4333333@4@4      @4@4      @3L@3ffffff@2L@3@3fffff@3fffff@3      @2     @2@3@3      @2fffff@1ffffff@2      @2333333@1fffff@0@033333@2     @1      @133333@0L@0@1fffff@033333@0333333@0333333@1L@.ffffff@0L@0@1      @0     @0@0@0L@0     @0      @0@0333333@0L@0      @/@0@/@0333333@0@0333333@/@033333@/333333@0      @/333333@-333333@-      @.@/@,      @,@,      @.@+@-@,ffffff@-333333@-333333@,@*333333@/ffffff@+333333@*333333@.      @*@,333333@+@+@,333333@)333333@+      @,333333@+333333@*@+@+333333@)333333@,      @*ffffff@+333333@+333333@+333333@*@.@(@'@)@)ffffff@*333333@)      @)@(@(ffffff@(@(@'ffffff@)@(      @'333333@)@'@&ffffff@)ffffff@%@(333333@(ffffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ?333333?1&?vȴ9?QR?tj?S?vȴ9X?`A7K?"`A?I^5??lC?5?|h?l?Vt?O;d?+J?7KƧ?I^5?}?$/?Q?A7Kƨ?+?\(?vȴ9X?vȴ9?ffffff?I^5??vȴ9X?bM?xF?
=p?hr!?/w?lD?/v?-V?tj~?`A7K?1&y?땁$/?+?\(\?+?x?;dZ?A7Kƨ?E?j~"?(\)?
=p?lC?\(?x?1&x?`A7?ȴ9Xb?և+I?      ?$/?+?/w?Լj~#?ӕ$/?`A7?l?S?M?E? ěT?Ͳ-V??̬1&y?j~"?zG?p
=q?5?|h?Gz?1&?˥S?Gz?I^5?Gz?bM?bM?
=p
?+?tj?ěS?zG{?/w?+?A7Kƨ?tj~?-V?S?`A7L?7KƧ?/v?ěS?      ?/v?      ?      ?p
=q?lC?lC?vȴ9X?      ?      ?lC?lC?p
=q?      ?      ?"`?j~"?      ?      ?      ?hr!?vȴ9X?"`?      ? ěT?Q?lC?lC?"`?;dZ?lC?      ?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Gz?+??lC?lC?lC?lC?lC?S?S?(\)?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?1&y?1&y?lC?-V?lC?lC?lC?lC?lC?lC?lC?p
=q?^5?|?lC??dZ1?lC?vȴ9X?p
=q?|hr?lC?lC?lC?lC?lC?lC?S?"`B?lC?lC?lC?lC?lC?tj~?^5?|?lC?1&?lC?lC?QR?lC?Gz?"`A?lC?lC?E?lC?Gz??lC?vȴ9?"`A?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?5?|h??S?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?^5?|?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?(\)?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?Q?1&y?Q?lC?"`B?lC?lC?lC?lC?lC?hr!?5?|h?lC?lC?j~"?E?-V?vȴ9X?p
=q?(\)?lC?1&?lC?lC?lC?lC?lC?hr!?lC?lC?lC?lC?1&y?lC?5?|h?lC?lC?XbM?S?lC?lC?|hr?1&y?Gz?lC?lC?lC?1&?lC?lC?lC?lC?lC?lC?lC?+J?lC?-V?(\)?vȴ9X?lC?lC?p
=q?lC?lC?5?|h?-V?(\)?vȴ9X?(\)?E?1&y?      ?E?lC?XbM?"`B?lC?lC?lC?lC?lC?lC?lC?E?lC?p
=q?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?lC?5?|h?j~"?lC?E?5?|h?(\)?-V?lC?-V?      ?(\)?hr!?p
=q?lC?lC?lC?lC?lC?lC?-V?j~"?(\)?vȴ9X?lC?lC?lC?lC?lC?/v?-V?-V?p
=q?"`?lC?lC?lC?lC?-V?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?-V?vȴ9?dZ1?lC?"`?j~"?5?|h?      ?1&y?Q?5?|h?lC?lC?vȴ9X?vȴ9X?(\)?lC?lC?lC?lC?p
=q?|hr?lC?/v?1&y?hr!?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?p
=q?lC?lC?      ?vȴ9X?"`?`A7L?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?dZ1?E?lC?lC?lC?lC?lC?|hr?vȴ9X?lC?lC?      ?1&y?lC?lC?-V?      ?-V?vȴ9X?vȴ9X?-V?-V?lC?lC?lC?lC?p
=q?      ?      ?lC?"`?      ?      ?j~"?      ?Q?/v?"`?lC?      ?vȴ9X?j~"?vȴ9X?-V?5?|h?lC?lC?lC?lC?E?p
=q?lC?lC?lC?vȴ9X?1&y?lC?lC?lC?lC?lC?lC?|hr?/v?lC?|hr?`A7L?-V?lC?p
=q?vȴ9X?lC?lC?"`?      ?      ?      ?lC?lC?lC?5?|h?vȴ9X?E?1&y?E?"`?lC?lC?;dZ?      ?-V?lC?lC?dZ1?+?;dZ?(\)?lC?Q?E?j~"?lC?;dZ?1&y?      ?p
=q?;dZ?1&y?      ?      ?      ?5?|h?lC?lC?lC?(\)?      ?;dZ?lC?lC?/v?      ?-V?lC?      ?      ?      ?lC?lC?j~"?      ?lC?lC?lC?-V?      ?Q?1&y?5?|h?lC?5?|h?      ?Q?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?E?Q?(\)?(\)?      ?j~"?5?|h?      ?Q?lC?      ?;dZ?lC?lC?/v?p
=q?5?|h?lC?lC?&x?hr Ĝ?      ?      ?hr!?lC?      ?      ?(\)?lC?lC?lC?lC?lC?E?S?
=p?&x?      ?      ?      ?lC?vȴ9X?lC?-V?A7Kƨ?5?|h?/v?lC?lC?p
=q?|hr?p
=q?      ?|hr?hr!?j~"?|hr?      ?/v?Q?lC?|hr?-V?vȴ9X?      ?j~"?lC?;dZ?(\)?vȴ9X?(\)?lC?lC?      ?lC?;dZ?      ?7KƧ?-V?lC?5?|h?Q?lC?|hr?1&y?Q?      ?p
=q?hr!?      ?E?vȴ9X?&x?lC?5?|h?vȴ9X?-V?      ?-V?lC?lC?lC?hr!?      ?      ?      ?vȴ9X?lC?Q?p
=q?      ?      ?hr Ĝ? ěT?bM?;dZ?&x?      ?      ?Q?p
=q?      ?      ?"`?lC?lC?GzH?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@N33333@N@N@N@N@N@N@N@N@Nٙ@N@N@N@N@N@N@N     @N     @N@N@N@N@N@N33333@N     @N@N@Nٙ@Nٙ@N33333@N33333@N33333@N33333@N33333@N33333@N33333@O@O@O333333@OY@OY@OY@OL@OL@Offffff@Os33333@O33333@Oٙ@Offfff@O33333@P@P@P&fffff@P333333@P9@P333333@P,@P&fffff@P&fffff@P      @P@P      @P      @P@P@P33333@P33333@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P      @Offfff@Oٙ@Offfff@Oٙ@Oٙ@Oٙ@O     @O     @O33333@Offfff@Offfff@Offfff@O@O     @Os33333@Os33333@Offffff@OY@OL@O@     @O@     @O333333@O@O      @Nfffff@Nfffff@NY@M@M      @Lٙ@L     @L@L@L@Lfffff@L33333@L33333@M@Lٙ@Lfffff@L@L     @L     @L     @Ls33333@Lffffff@Lffffff@Lffffff@Lffffff@Lffffff@Ls33333@L     @L     @Lfffff@Lfffff@Mffffff@M@NY@Nٙ@Nٙ@N@N@Nffffff@N     @N@N@N     @N     @N     @N33333@O      @O333333@Offffff@Os33333@Os33333@OY@OY@O33333@O     @O     @O     @O     @O     @O@O@N@N     @NY@N333333@N&fffff@N&fffff@N&fffff@N@N@N@N333333@NL@NL@NY@Ns33333@N@N@N@N@N@Nfffff@N     @Nٙ@N33333@N33333@N33333@N33333@O@OL@O@O@P      @P@P@P      @P      @P&fffff@P&fffff@P&fffff@P,@P,@P,@P333333@P@     @P@     @P@     @PY@Pl@Pl@Py@P     @Py@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Py@Py@Pfffff@P     @Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P33333@P     @Pfffff@Pfffff@P33333@P33333@P     @P@P33333@Pfffff@Pfffff@Pfffff@P@P@P@P33333@P33333@P@P     @P     @P     @Pfffff@Pfffff@P@P@P33333@P     @P     @P     @P     @P     @P@Pٙ@Pfffff@P@P@Pfffff@P     @Pٙ@Pfffff@P@Pfffff@Pfffff@Pfffff@Pٙ@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P33333@P     @P     @P     @P     @P     @P33333@P@P@P33333@Pٙ@Pٙ@Pٙ@P     @Pٙ@P@Pfffff@P     @P33333@P33333@P@P@P@P33333@Pٙ@Pٙ@P33333@P@P     @P     @P33333@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@P@P@P@Pfffff@P@P@Pfffff@P@P@Pfffff@Pfffff@P33333@P@P@P@Pfffff@P33333@P33333@P33333@Pٙ@P     @P     @Pٙ@Pٙ@P33333@Pٙ@P     @Pٙ@Pٙ@Pٙ@P     @Pfffff@P@P@P@P@P@P@P@P33333@Pfffff@P@P@P@P33333@P33333@P@Q      @P@P@Q      @Qfffff@Q      @Q      @Q      @P@Q      @P@Q      @Qfffff@P@P@P@Q      @Q      @Q      @P33333@P@P@P@P@P33333@P33333@Q      @P@P@P33333@P33333@P@P@P@P33333@P@Pfffff@Pٙ@P33333@P33333@P@P@P@Pfffff@P     @P@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @P33333@P33333@P33333@P@P@P33333@P33333@P@Pfffff@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P     @P,@P@P33333@Pfffff@P@P@P@Pfffff@P     @P     @P@P     @P@P@P33333@P@P@P@P@P     @P     @P33333@Pfffff@P@P@P33333@P33333@P33333@P     @P33333@P@P@P@Pٙ@P     @P     @Pfffff@P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P33333@P33333@P33333@P33333@Pٙ@P     @P     @P     @Pٙ@P33333@P33333@P33333@Pfffff@P     @Pfffff@P     @P     @Pfffff@P@Pfffff@Pfffff@Pfffff@P     @P     @P     @Pfffff@P@P     @P     @P     @P     @P     @P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P@P     @P     @P     @P     @P     @P     @P33333@P@P     @P     @P     @P     @P@P@P     @Pfffff@P     @Pfffff@P     @P@P33333@P33333@P@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P@P@P@P@P     @P@P33333@P@P33333@P@P@P33333@P@P@Pfffff@Pfffff@Pfffff@P     @P@Pfffff@P     @P@P     @Pfffff@P     @P     @P@P@P@P33333@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P33333@Pfffff@P     @Py@Py@Py@Py@Py@Py@Py@Py@Py@P     @Pl@Ps33333@Ps33333@Py@Py@Pl@Pl@Pl@Pl@Pffffff@P`     @P`     @P`     @Pffffff@Pffffff@Pffffff@Pl@Pl@Pffffff@P`     @P`     @P`     @PS33333@PS33333@PY@PY@PS33333@PL@PS33333@PY@PY@PS33333@PS33333@PY@PY@PS33333@PL@P9@PL@PS33333@PFfffff@PS33333@PS33333@PS33333@PS33333@PS33333@PY@PY@PY@P9@PFfffff@PFfffff@PL@PL@PS33333@PS33333@PS33333@PS33333@PL@P9@P,@P9@PFfffff@PL@PS33333@PS33333@PL@PFfffff@P9@PFfffff@PS33333@PY@PS33333@PFfffff@PS33333@PS33333@PS33333@PY@PY@PS33333@P`     @PY@P`     @P`     @PY@PY@PY@PY@P`     @Pffffff@PY@PL@P`     @Pffffff@Pl@P     @Pfffff@Py@Py@P33333@P@P     @P     @P     @P     @P33333@P@P33333@P33333@P@Pfffff@Py@Py@Py@Py@P     @Py@P     @Pffffff@P`     @Pl@P`     @P`     @Pffffff@Pl@Pl@Pffffff@PS33333@PY@PY@P9@P@     @P9@P&fffff@P&fffff@P,@P,@P&fffff@P      @P      @P@Oٙ@P      @P      @P@Pfffff@P      @Pfffff@Pfffff@O33333@Offfff@Offfff@O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       P3                                      1                                       BB3P