CDF       
      time      pressure     latitude      	longitude         string_dimension   (         EXPOCODE      29AJ20160818   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    WOCE_ID       TAlPro     	DATA_TYPE         WOCE CTD   STATION_NUMBER        41     CAST_NUMBER       1      BOTTOM_DEPTH_METERS          
Creation_Time         2020-03-19T19:50:22.565995Z    ORIGINAL_HEADER      CTD,20200319CCHSIO
# Converted CTDOXY from ML/L to UMOL/KG using the following:
#     https://github.com/TEOS-10/GSW-Python, downloaded 2019-06-26
#     gsw.sigma0:  Calculates potential density anomaly with reference pressure of 0
#     dbar, this being this particular potential density minus 1000 kg/m^3.
#     This function has inputs of Absolute Salinity and Conservative
#     Temperature.  This function uses the computationally-efficient
#     75-term expression for specific volume in terms of SA, CT
#     and p (Roquet et al., 2015).
#     http://www.teos-10.org/pubs/gsw/html/gsw_sigma0.html 
#     Python equation used:
#         oxy_UMOL_per_KG = oxy_ML_per_L * 44.660 / ( (1000 +  gsw.sigma0(SA,CT)) / 1000. ) 
# Data source:  https://doi.pangaea.de/10.1594/PANGAEA.902330
# SHIP: RV Angeles Alvarino
# Cruise: MedSHIP cruise TalPro
# Region: Mediterranean Sea and Catalan Basin
# Ports: Palermo, Italy to Barcelona, Spain
# DATES: 20160818 - 20160829
# Chief Scientist: L.Jullion
# 43 stations
# Original file in AWI format. CCHDO Converted to Exchange format
# EVENT_CODE=unknown
# DATE: YYYYMMDD
# TIME: HHMM
# LATITUDE: degrees_North
# LONGITUDE: degrees_East
# STNNBR:  removed leading 0s from STNNBR
# CASTNO: not supplied by originator - CCHDO assigned all CASTNO=1 or CASTNO=2 for stations 11, 29
# CTDSAL: changed units from Practical to PSS-78.  Data values remain unchanged.
# CTDFLUOR: changed units from UG/L to MG/M3 as they are they are equivalent
# CCHDO added flags=2 for all parameters, as T.Tanhua notes all params are calibrated and CTDOXY calibrated with bottle samples
# Removed two test sample depths from event/station 004, dTalpro_Stn04_test_1db
# Data precision preserved as submitted.
# CTD: Who - T.Tanhua; Status - calibrated,final
#     Includes: CTDSAL, CTDOXY
#     CTDTMP NOTE: Used first occurrence of primary temperature sensor in original data file
#     CTDSAL NOTE: Used first occurrence of primary salinity sensor in original data
#     NOTE: Physical parameters temperature, salinity, oxygen, density, turbidity, chlorophyll, fluorescence are published on PANGAEA, DOI above.
# Fluorescence (CTDFLUOR): Who - T.Tanhua; Status -final
#        Instrument: WET Labs ECO-AFL/FL, FLNTURTD-2526
#        ScaleFactor: 1.00000000e+001
#        Dark Output: 0.0760
# Turbidity (CTDTURBDTY): Who - T.Tanhua; Status - final
#        Instrument: FLNTURTD-2526
#        ScaleFactor: 5.000000
#        Dark output Voltage: 0.070000
#
# Reference: Cruise report: https://epic.awi.de/id/eprint/49725/1/TAlPro_EUROFLEETS_cruise_report_V2.pdf
# CCHDO page: https://cchdo.ucsd.edu/cruise/29AJ20160818
# Metadata from original file
#     Event(s):     TAlPro-2016_041 (41) * LATITUDE: 40.810000 * LONGITUDE: 2.200000 * DATE/TIME: 2016-08-27T00:00:00 * CAMPAIGN: TAlPro-2016 * BASIS: Angeles Alvarino (URI: http://www.eurofleets.eu/np4/285.html) * DEVICE: CTD/Rosette (CTD-RO)
#     Citation: Tanhua, Toste (2019): Physical oceanography during MedSHIP cruise Talpro. PANGAEA, https://doi.org/10.1594/PANGAEA.902330
#     Abstract: The TAlPro cruise (Palermo - Barcelona, RV Angeles AlvariÃ±o, 18/-8/2016 - 29/08/2-16) occupied three hydrographic transects across the Tyrrhenian Sea, the western Mediterranean Sea and the Catalan Basin (Fig. 1) as part of the MedSHIP programme (Mediterranean Ship-based Hydrographic Investigations Program). A total of 43 stations were occupied during which physical (temperature, salinity, pressure, velocity), biogeochemical (oxygen, nutrients, carbonate system, dissolved Barium, oxygen and nitrogen isotopes) and anthropic (CFCs, SF6) parameters were measured in order to monitor the physical and biogeochemical state of the Mediterranean Sea.
#     Related to: Jullion, Loic (2016): TAlPro-2016: A Tyrrhenian Sea & Alger- provencal component of the MedSHIP Programme. hdl:10013/epic.5a866780-1f8a-45cf-8111-47b2b5dc29db
#     Parameter(s):
#         Event label (Event) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Sample code/label (Sample label) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Date/Time of event (Date/Time) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Latitude of event (Latitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Longitude of event (Longitude) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de)
#         Pressure, water [dbar] (Press) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Digiquartz
#         Temperature, water [Â°C] (Temp) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: ITS-90
#         Oxygen, dissolved [ml/l] (DO) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 43
#         Turbidity (Nephelometric turbidity unit) [NTU] (Turbidity) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO
#         Fluorescence, chlorophyll [Âµg/l] (Fluores) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: WET Labs ECO-AFL/FL
#         Salinity (Sal) * PI: Tanhua, Toste (https://orcid.org/0000-0002-0313-2557, ttanhua@geomar.de) * METHOD: CTD, SEA-BIRD SBE 9 * COMMENT: Practical
#     License: Creative Commons Attribution 4.0 International (CC-BY-4.0)
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            pressure               	long_name         pressure   positive      down   units         decibar    data_min      @         data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      /  '   pressure_QC                	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        V   temperature                	long_name         temperature    units         ?C (ITS-90)    data_min      @*K]cA   data_max      @:p|   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       /  b   temperature_QC                 	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity               	long_name         salinity   units         PSS-78     data_min      @Co   data_max      @CG䎊r   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      /     salinity_QC                	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d        Π   oxygen                 	long_name         oxygen     units         ?mol/kg    data_min      @f
Zc   data_max      @qq,=   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        /  ژ   	oxygen_QC                  	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       
x   CTDFLUOR               	long_name         CTDFLUOR   units         MG/M^3     data_min      6C-   data_max      ?/{J#:   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      / p   CTDFLUOR_QC                	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       FP   	CTDTRBDTY                  	long_name         	CTDTRBDTY      units         NTU    data_min      ?   data_max      ?   C_format      %f     WHPO_Variable_Name        	CTDTRBDTY      OBS_QC_VARIABLE       CTDTRBDTY_QC     / RH   CTDTRBDTY_QC               	long_name         CTDTRBDTY_QC_flag      units         
woce_flags     C_format      %1d       (   time                	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      &+   data_max      &+   C_format      %10d           latitude               	long_name         latitude   units         	degrees_N      data_min      @DgzH   data_max      @DgzH   C_format      %9.4f          $   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      @   data_max      @   C_format      %9.4f          (   	woce_date                   	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3;   data_max      3;   C_format      %8d        ,   	woce_time                   	long_name         	WOCE time      units         hhmm UTC   data_min             data_max             C_format      %4d        0   station                	long_name         STATION    units         unspecified    C_format      %s        ( 4   cast               	long_name         CAST   units         unspecified    C_format      %s        ( \@      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @:p|@:`:~ @:ݗ+k@9
(@9i ѷ@9TJM@90A7K@8I^5?@8\q@7ҏ\(@7u'0@7K"`B@7bM@6@664@6A@6 hۋ@6a@O@6~($x@61.@6Vl!@6-V@6]U=@6PH@6@|@64o h@6%!R@5ᰊ@5"`@5D*@5O@56x@5e@4iB@4?@4-@4mڹZ@4C&@4W@3Dg8~@3u@3	x@2 ѷY@2CZ@1Ʌoi@1vC-@1'RTa@0쿱[W@0?|h@0L/{J@0UoiDg@04E@0/䎊r@0"e+@/ܑN;@/>BZc @/%Q@/$@.Ǔݗ+@.`[6@.
=q@-&x@-t@-wk@-t!-w2@-Qhr @-CF]c@-
O;dZ@,zH@,'@,D*@,a@O@,@,n}Vl@,Z)_@,Gy@,1u@,3*0U2@,/Vϫ@,)y@,!o@,~$@,J@,	oiD@+!-w1@+Y}@+MjO@+첕@+҈p;@+`A7@+m\@+-w1@+($x@+N;5@+'RTa@+[6@+<64@+4m9@+(\@+D@+}Vl@+{J#:@+@+s&@+c,zxl@+cwk@+gy@+g&@+dTɆ@+[q@+WkP@+Uᰉ@+Sݗ+k@+Q_p@+NzG@+@4m9@+0H@+!TɅo@++J@+o @+͞@+.2@+C]@+@+F@+#x@+N;@+4֡b@+z@+Vϫ@+	k@+qj@+2W@+A [@+7Kƨ@*t@*Fs@*o@**0U@*U=@*n/@*{J#9@*حV@*}H@*ce@*64@*"`B@*֡af@*oiDg8@*4֡a@*iDg8@*t@*'/@*eO@*Ǔݗ+@*L/{J@*$/@*+a@*A [@*@*	k@*'RT`@*U=@*҈p;@*-V@*u"@*wkP@*n.@*A@*~@*c	@*Y@*Y}@*XbM@*F@*)@*Q@*+@*ȴ9X@*,<@*o@*Vϫ@*@*{J#:@*\(@*-V@**0U@*͞@*T@*Vu@*c	@*jOv@*@*"h	ԕ@*L_@*9Xb@*#@*#@*@*ԕ*@*0
@*)^	@*Q@*s@*<쿱@*[W?@*U=@*ߤ?@*ߤ?@*@*)^	@*'RTa@*1&x@*/V@*,@*IQ@*$/@*m\@*e@*qj@*@*a@N@*S&@*\(@*3@*ae@*ae@*o hی@*7Kƨ@*s@*3@*&IR@*@N@*b}V@*b}V@*A7K@*-w1@*h	ԕ@*%2@*1@*ݗ@*e@*g8}@*@*nP@*@*4m9@*@*
qu@*IQ@*-
@*䎊r@*˒:)@*@*$/@*ae@*@*%2@*g8}@*S&@*oiDg@*@*84֡@*2W@*n.3@*n.3@*?@*-@*Dg8~@*Q@*k~(@*'RTa@*ԕ*@*@*B@*ᰉ'@*P{@*(@*v@*\(@*v_ح@*o @*:~ @*$tT@*A [@*_p@*_p@*a|Q@*ݗ+k@*73@*IQ@*6@*o hی@*TɅo@*o@*e@*e+@*@4@* ѷ@*{J#9@*Z1@*ĵ?@*zxl"h@*]cf@*ǮzH@*1&x@*eO@*Ȍ@*\)@*^@*ᰉ'@*0U2a|@*	 @*=p
@*ᰉ'@*eO@*]cf@*@*K]c@*p:@*ᰉ'@*)^	@*˹~($@*s@*cA \@*~($x@*̋C@*qu"@*8Y@*+@*Ϸr@* ě@*У
=q@*_p@*N;5@*ѩl@*-V@*Ұ ě@*ӎMj@*@*9XbN@*Fs@*ӶE@*҉@*2W@*D@*)^@*)^@*iB@*@*E@*t@*֮}Vl@*׍O;d@*Q_@*ۘA@*J#9@*>BZ@*rGE8@*؆YJ@**0@*rGE8@*b}@*+@*+@*غ)@*׍O;d@*׍O;d@*ךkP@*@*؆YJ@*0
)@*_o@*^5?|@*6@*,=@*NU@*	k@*R<6@*3@* ѷ@*%2@*䎊qj@*7@*u@*+a@*o i@*@*Z@*A [@*䎊qj@*+a@*凓ݗ@*oiDg@*u@*tSM@*
=p@*,zxl@*n@*p
=@*qu!@*ڒS&@*Y}@*e+a@*ٌ~($@*ٙ@*ٙ@*ٌ~($@*b}@*rGE8@*#w@*+@*+@*	k~@*PH@*+@*#w@*0
)@*JE@*e+a@*b}@*_o@*>BZ@*>BZ@*6C@*)_@*"`B@*s@*s@*ۋq@*Q@*$@*$@*(\@*PH@*64@*Q@*64@*PH@*wkP@*܄?@*u"@*cA @* ѷY@*($x@*E@*ݲ-V@*ݥv@*cA @*E@*ރ%@*H˒:@*n@*@N@*R<6@*n.@*ὥ@*e@*&IR@*3@*u%F
@*wkQ@*C,@*{J#9@*@*?@*o h@*o i@*zxl"h@*1@*ڹ@*YJ@*YJ@*`A7L@*F
L0@*o i@*e@*e@*+a@*o h@*tj@*	@*e+@*䎊r@*|hs@*m\@*ސ$t@*ce@*۲m]@*G{@*Y}@*)y@*u%F@*e+a@*y=c@*sPH@*E@*MjO@*&@*҉@*PH@*g	l@*ӶE@*@*!-w2@*m8@*Վ!R@*E@*@*ק&@*@*ק&@*ק&@*״3@*׍O;d@*@*}H@*+j@*+j@*ךkP@*$tS@*z@*֡af@*8YJ@*Ϫ͞@*֡a@*g@*Ӂ@*Ұ ě@*n@*-@*hr @*A [@*[W>6@*@*U2a|@*:~ @*ϐ@*O
M@*4֡a@*ΤT@*Ίqi@*
qv@*@*C\@*C\@*
qv@*\@*~($x@*I^5?@*"h	ԕ@*C]@*]cA@*ʳg	@*~"@*Ov`@*x@*Dg8~@*7KƧ@*ۋq
@*˒:*@*>BZc@*@*ǆ&@*x@*ƀIQ@*ڹ@*+a@*o i@*7@**0@**0@*ěS@*ěS@*tj@*C,@*u%F
@* [7@*C@*C@*n@*u!@*u!@*n@*u!@*
qu@*@*U=@*@*Ft@*ߤ?@*6z@*$t@*%@*%@*\N<@*\N<@*iB@*\N<@*BZc @*BZc @*5?|@*b@*cA @*v@*<64@*$@*q@*ݘ@*kP|@*6C@*)y@*"`@*_o@*PH@*e+@*4֡b@*)@*tj@*4֡b@*-
@**0@*eں@*O
M@*u!S@*v_ح@*v@*\(@*v_ح@*iDg8@*1@*p:~@*c	@*c	@*c	@*}Vl@*Vu@*c	@*Vu@*c	@*c	@*H@*;5X@*_o @*(@*8Y@*M:@*5Xy>@*:@*:@*>B[@*zxl"@*q@*VϪ@*C,z@*0U2a|@*JL@*0U2a|@*0U2a|@*ԕ*@*@*u%F@*u%F@*˒:*@*	ԕ+@*s@*ڹ@*e@*JM@*%2@*u%F
@*vȴ9@*
(@*ce@*IQ@*ڹZ@*}H@*b@*u@*BZc @*BZc @*%@*Q@*@*%@*vȴ9X@*Ov_خ@*($x@*Ov_خ@*IQ@*>@*N;@*N;@*j~#@*,<@*xl"h
@*_F@*KƧ@*Fs@*L_@*Z@*Z@*Z@*֡a@**1@*m8@*@*<64@*2W@*o@*o@*[W>6@*A [@*`A7@*'RT@*iDg8@*v@* hۋ@*1@*H@*@*/{J#@*Ƨ@*q@*:)z@*Q@*xF]@*D@*n@*JL@*0U2a|@*#9@*@*ᰉ'@* ѷ@*Xy=@*zH@*,@*@*L/{J@*$/@*n/@*O
@*F
L0@*7@*g8}@*
=p@*74@* ѷ@*`A@*u%F
@*@*$/@*u!@*˒:)@*@*     @*
qu@*
qu@*䎊r@*˒:)@*H˒:@*!-w1@*Ft@*~"@*~҈p;@*~$t@*}b@*}Vl!@*}<64@*|hr@*|hr@*|1&@*{A@*{W>6z@*{s@*z,<@*z^5?|@*z)y@*y(@*xF@*x_F@*xD*@*x73@*xF]d@*w@*w&@*w4m@*wXe@*w1@*w$tS@*w$tS@*vȴ9X@*vl!-@*ush@*tZ@*tO
M@*tm8@*tO
M@*tSMj@*t9XbN@*s|@*s*0U2@*tJ@*s|@*sMj@*sߤ@*stj~@*s@N@*rW@*rnO@*r-V@*q2W@*qu@*qhr @*q[W>6@*q&x@*q@*q_p@*q&x@*qA [@*qN;5@*q[W>6@*qhr @*qu!S@*qN;5@*qA [@*q&x@*qN;5@*q[W>6@*q4J@*q4J@*q&x@*qN;5@*qN;5@*qA [@*qA [@*qN;5@*qN;5@*q[W>6@*q&x@*q4J@*q@*p{@*p{@*p`A7@*p`A7@*pD@*p
=q@*pU2a|@*p ě@*o'/W@*nO;@*np:~@*m(@*mM:@*l@*lcA \@*lL_@*l1&y@*ks@*kƧ@*kƧ@*ks@*kƧ@*k~($@*kq@*kU=@*kU=@*kP{@*jd7@*jOv`@*j	 @*j0U2a|@*jOv`@*ilD@*ilD@*iy@*i'RTa@*iDg8~@*i7KƧ@*i*0U2a@*ioiD@*iB@*iᰉ'@*i'RTa@*i7KƧ@*irGE@*h@*hTɅ@*h9Xb@*hTɅ@*hp:@*hp:@*hTɅ@*hTɅ@*h9Xb@*h@*heO@*hK]c@*h˒:*@*h@*hu%F@*h@*hXy=@*h$xG@*h	ԕ+@*gfA@*gK]d@*gK]d@*gK]d@*g/V@*gzH@*g/V@*g	k@*g_o@*g@*fFs@*g@*g)^@*g,@*g)^@*fFs@*g)^@*g)^@*g+I@*g+I@*g,@*g)^@*g@*g@*f&I@*f-@*f@*fs@*f,<@*f@*fs@*fIQ@*fIQ@*f,<@*f&I@*f'@*f'@*fYJ@*ffffff@*fIQ@*f,<@*f&I@*f-@*f-@*f'@*f,<@*f@*fs@*ffffff@*ffffff@*f1.@*f@*f
L/@*eS@*e@*e@*e1@*em\@*eQ@*de@*de@*eo i@*eQ@*eu@*eu@*eu@*e84֡@*e84֡@*e+a@*eu@*e+a@*eS&@*e`A7L@*e`A7L@*e`A7L@*em\@*eݗ@*eO
@*e1@*e@*en/@*e@*e@*e84֡@*eQ@*eo i@*eo i@*eu@*d/@*d/@*dJM@*d/@*d*0@*dxF@*c@*c@*cwk@*cwk@*ca@N@*c,zxl@*b`A@*be+@*a@*aR<6@*a7Kƨ@*aTɅo@*aae@*a:S@*a-w1@*a$/@*`	k@*`	k@*`҈p@*`҈p@*`҈p@*`IQ@*`u!@*`A7K@*`A7K@*`4m9@*`     @*_@*_vȴ9@*_vȴ9@*_˒:)@*_˒:)@*_	@*^Q@*^Ov_خ@*^ ѷY@*],=@*],=@*]b@*]+j@*\>@*\C,zx@*[lC@*[dZ@*Z,<@*Zݘ@*Z^5?|@*Z6C@*Z@*Y>BZ@*Z@*Y_o@*Y@*Y|@*Y(@*Y|@*Y@*Ye+a@*YJE@*Y+@*XPH@*Y#w@*Y	k~@*XPH@*Y#w@*Y+@*XF@*Xtj@*Xl"h	@*Xy=c@*Xe+@*X4֡b@*XPH@*Y	k~@*Y+@*Y	k~@*X4֡b@*X_F@*X73@*XbM@*W+@*WsPH@*W1@*V}Vl@*V8YJ@*Uᰉ@*UfA@*U?|h@*U2a|@*U%F
L@*U2a|@*U2a|@*T֡a@*T֡a@*TO
M@*T*1@*T*1@*T`d@*T@*T9XbN@*SZ@*S҉@*RsP@*R ě@*RW@*Rm@*Rp:@*Q2W@*Q&x@*P
(@*PbM@*PoiDg8@*PoiDg8@*PbM@*PU2a|@*P@*OVϫ@*Oo @*O@*O@*Oo @*O;dZ@*OVϫ@*OrGE9@*P@*O;dZ@*O4֡a@*NMj@*N1@*Nt@*NO;@*Nc	@*NH@*NH@*MC\@*M@*M(@*MC\@*M5Xy>@*M(@*M(@*L!-w@*L@*LC@*Lq@*L@*L!-w@*M(@*M(@*MB@*MjOv@*Mw1@*Mhr!@*MU=@*Mhr!@*MB@*L@*M:@*L@*L@*L@*L@*L>B[@*L[W?@*L@*L[W?@*Lzxl"@*L~($x@*LcA \@*Lq@*LcA \@*LI^5?@*LI^5?@*L<쿱@*LL_@*Ka@@*Kq@*KU=@*K:)z@*KU=@*KU=@*K:)z@*KQ@*KxF]@*K]cA@*K]cA@*KxF]@*K:)z@*KU=@*Kq@*Kq@*Kq@*Kq@*K~($@*KU=@*K:)z@*KQ@*KQ@*KQ@*KQ@*KQ@*KQ@*KQ@*KQ@*K:)z@*KU=@*K:)z@*K:)z@*KU=@*Kq@*KU=@*KƧ@*K҈@*KC]@*LL_@*L/{J#@*L"h	ԕ@*LL_@*L1&y@*Ks@*KC]@*KC]@*KC]@*KC]@*K~($@*Kq@*Kq@*K~($@*KƧ@*K~($@*K:)z@*KU=@*K~($@*KƧ@*K~($@*Kq@*K:)z@*K:)z@*KQ@*K:)z@*Kjf@*KxF]@*K:)z@*K:)z@*K:)z@*KQ@*KQ@*K:)z@*Kq@*K~($@*K~($@*K~($@*K~($@*Ka@@*K҈@*KC]@*Ks@*K҈@*KC]@*Ks@*L1&y@*LL_@*L"h	ԕ@*L/{J#@*L/{J#@*Ks@*LL_@*L1&y@*KC]@*KC]@*Ks@*L1&y@*Ks@*Ks@*LL_@*L1&y@*L"h	ԕ@*L"h	ԕ@*L"h	ԕ@*LL_@*LL_@*KC]@*Ka@@*K:)z@*KQ@*K:)z@*K:)z@*KU=@*K:)z@*K:)z@*KU=@*Kq@*K~($@*K~($@*K~($@*KƧ@*Ka@@*K҈@*Ka@@*K҈@*KC]@*Ks@*K҈@*K~($@*K~($@*KƧ@*KƧ@*Ka@@*KƧ@*Ka@@*K҈@*KC]@*K҈@*K҈@*Ka@@*K҈@*KC]@*Ks@*LL_@*L"h	ԕ@*L/{J#@*L/{J#@*L<쿱@*LVϪ@*LcA \@*Lq@*Lq@*L~($x@*Lq@*LcA \@*LcA \@*Lq@*L~($x@*L~($x@*LC@*L_@*L_@*Lzxl"@*Lzxl"@*Lzxl"@*L[W?@*L@*L@*L@*Lzxl"@*L~($x@*LC@*L_@*Lzxl"@*L@*L_@*Lzxl"@*L@*L@*L@*L>B[@*L@*L!-w@*M:@*MV@*Mqu"@*M(@*M5Xy>@*Mqu"@*Mqu"@*Mqu"@*M(@*M(@*M5Xy>@*MO;dZ@*M\@*MjOv@*MjOv@*Mw1@*M\@*MB@*MV@*Mqu"@*Mqu"@*MV@*MV@*MV@*MV@*MV@*MV@*Mqu"@*M(@*M5Xy>@*MB@*MO;dZ@*MjOv@*Mw1@*MM:@*Mhr!@*MU=@*M8Y@*M@*M@*M(@*M(@*MC\@*M(@*M(@*MU=@*M\@*MV@*MV@*Mqu"@*M(@*M5Xy>@*M5Xy>@*MO;dZ@*MB@*M(@*Mqu"@*M:@*LC@*L~($x@*LC@*L@*L[W?@*L@*L@*L[W?@*L>B[@*L!-w@*M:@*L@*L@*L@*L!-w@*Mqu"@*MV@*M(@*L@*L@*L>B[@*L>B[@*MV@*M:@*M:@*MV@*Mqu"@*Mqu"@*Mqu"@*M(@*Mqu"@*M5Xy>@*MB@*MO;dZ@*MB@*M5Xy>@*M(@*M(@*M5Xy>@*M(@*M5Xy>@*MB@*M5Xy>@*MV@*MV@*L!-w@*L>B[@*L@*Lzxl"@*LcA \@*L~($x@*LcA \@*L"h	ԕ@*LL_@*L"h	ԕ@*L<쿱@*LI^5?@*LVϪ@*LVϪ@*LVϪ@*LVϪ@*LI^5?@*LI^5?@*LI^5?@*LVϪ@*LI^5?@*LI^5?@*LVϪ@*LcA \@*LcA \@*LcA \@*LVϪ@*LVϪ@*LI^5?@*LcA \@*Lq@*Lq@*L~($x@*L_@*Lzxl"@*L@*L[W?@*L@*L_@*L@*L[W?@*L@*L@*L@*L[W?@*L[W?@*L@*L>B[@*L!-w@*Mqu"@*M5Xy>@*M5Xy>@*M5Xy>@*MB@*MO;dZ@*M\@*M\@*M\@*MO;dZ@*M\@*M\@*Mw1@*MM:@*Mhr!@*MU=@*M8Y@*M
qv@*M
qv@*M(@*NzG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @Co@Cq@C~($@Cae@Cd8@CϪ͟@CIQ@C,<@C7Kƨ@C)^@Cu%F@CTɅo@C҉@C	@C33333@CI^@Cᰉ'@C	@C#x@CcA \@Cs@CMjO@Cu%F@CS&@C@C0
@C@C-
@C
@C
@Cu"@C7@C	Y}@C
͞&@C
1@Cߤ?@CJL@CZ@C\)@C
p
=@CNU@CI^5@Cs@CM:@CF
L0@COv_@C'RT@C&IR@CPH@C`A7@Cqi@CT@C6z@Caf@C5?|@CA@C4֡a@C 'RT`@C U2a|@Cݗ@Ctj@C@N@CC,zx@C7@C,<@C2W@C͞@C }H@C 6@C 	ԕ+@C K]c@C *0@C F]d@C *0@C )^@C!4J@C!@C"~@C#J#9@C#q@C$9XbN@C$S@C$hr@C%sg@C%cA @C%8YK@C&E@C',@C'_o@C'@C'3@C(-
@C)rGE@C)@C*u%F@C*Y@C+m]@C,m8@C,j~@C-L_@C-Ϫ͞@C.8YJ@C.YJ@C.4K@C-8YK@C.z@C.Fs@C.Mj@C.ߤ?@C.x@C/)^@C/@C/4֡a@C/o@C/˒:)@C/-V@C.@C.4K@C--V@C-Xy=@C-!.@C._o @C. ѷY@C.L/{J@C/#@C0y=c@C0-
@C0r Ĝ@C1@C1:S@C1_p@C1@C1$/@C1 ѷ@C0@C0TɅ@C0F@C0@C0`A7@C1 ѷ@C0$tT@C0`A7@C0e+@C1*0U2a@C1oiD@C2	 @C2䎊@C2vȴ@C2 ѷ@C3I^@C3nP@C3MjO@C3W>6z@C3:)z@C3*0U2@C3m]@C3
=p@C3%2@C4ߤ@@C4?@C4?@C42W@C4C,zx@C4VϪ@C4]ce@C4q@C4TɆ@C4[W?@C4?@C4>B[@C5'0@C5+a@C52a|@C5F
L0@C5\@C5!R@C5@C5C\@C6u@C6+jg@C6Ov_@C6($x@C6BZc @C6YJ@C6IQ@C6-@C6x@C6"@C7
=p@C7!-w1@C71@C7>6z@C7As@C7;dZ@C7;dZ@C78}H@C7E84@C7\(@C7sPH@C7&@C7vȴ9@C7˒:)@C7fA@C7@C7;dZ@C7Vϫ@C8F]d@C8}H@C8-
q@C8H@C8H@C8A7K@C8:~ @C81&x@C8*0@C8'RT`@C8 ě@C8$xG@C8$xG@C873@C8>BZc@C8>BZc@C873@C873@C8H@C8U2a|@C8bM@C8eO@C8l"h	@C8y=c@C8@C8u%F@C8tj@C8@C8-
@C8d8@C8ěT@C8ۋq
@C8$tT@C9*0U2a@C9A [@C9A [@C9Dg8~@C9=b@C94J@C97KƧ@C94J@C9=b@C9XbM@C9k~(@C9u!S@C9rGE8@C9x@C9@C9|@C9@C9ᰉ'@C9-@C:u%F@C:䎊@C:)y@C:-V@C:)y@C:#9@C:䎊@C:=p
@C:ᰊ@C:n@C:c	@C:~@C;nP@C;C,z@C;&@C;)^	@C;9@C;F]c@C;qu!@C;Ƨ@C;g@C;A [@C;$@C<n.@C<tj@C<64@C<Fs@C<M:@C<`d@C<*1@C<?@C=%F
L@C=M:@C=@C> ѷY@C>E@C>\N<@C>_ح@C>c	@C>vȴ9X@C>+J@C>-@C>Ϫ͟@C>쿱[W@C?
M;@C?As@C?lC@C?{J#:@C?ݗ+@C?	k@C?3@C?@C?حV@C?@@C?+j@C@ ě@C@*0@C@'RT`@C@ ě@C@K]c@C@{@C@ěT@C@\)@CA*0U2a@CA=b@CADg8~@CAQ@CAQ@CAQ@CAae@CArGE8@CAR<6@CAB@CA@CAy@CAN;6@CA@CAe@CA-@CBs@CB3@CB@4n@CBGE85@CBM@CBQ_@CBM@CBGE85@CBJL@CBJL@CBW'@CBL_@CB`A@CBD@CCnP@CC9@CCdZ@CCa@O@CCC]@CD1&y@CDJ@CDxF@CDL_@CD<쿱@CD~($x@CD쿱[@CD@CD֡a@CD֡a@CD֡a@CDZ@CDhr@CDE@CEqu"@CE(@CE?|h@CEO;dZ@CEw1@CEsh@CEE@CF
(@CFOv_@CF+jg@CFBZc @CF_ح@CFp:~@CFs@CF}Vl@CFIQ@CF}Vl@CFz@CF%@CFFs@CFT@CF'@CF&I@CFȴ9X@CFA@CF҈p;@CFt@CF&I@CFT@CF+J@CFs@CFfffff@CFc	@CFp:~@CFp:~@CFz@CFvȴ9X@CFz@CFIQ@CFIQ@CFqi@CF@CFqi@CF@CF@CF$t@CF,<@CF,<@CF,<@CF,<@CF@CF6z@CF}Vl@CF-@CFQ@CFȴ9X@CF҈p;@CFA@CFt@CF]cf@CFC-@CFC-@CFC-@CFC-@CFx@CFC-@CFߤ?@CFC-@CFߤ?@CFߤ?@CFߤ?@CFx@CG hۋ@CG hۋ@CF!.I@CF!.I@CFMj@CFMj@CFMj@CFFs@CG hۋ@CG@CG1@CG>6z@CGH˒:@CGH˒:@CGKƧ@CGU=@CG_o@CG_o@CGb}V@CGb}V@CGsPH@CG&@CGݗ+@CG?@CG[W>@CGvȴ9@CG@CGحV@CG@CGrG@CG䎊r@CGVϫ@CGrG@CGrG@CGVϫ@CGrG@CGrG@CG-@CG䎊r@CG䎊r@CG@CG@CG˒:)@CG@CG/V@CGzH@CG$tS@CGݗ+@CG	@CG&@CG&@CG4m@CG|hs@CGsPH@CGiDg8@CGeں@CGo@CGv_ح@CG|hs@CG{J#:@CGO;d@CG@CGkP@CG	k@CG/V@CGK]d@CGحV@CG@CGVϫ@CGrG@CGrG@CGrG@CGrG@CGVϫ@CG䎊r@CG-@CG䎊r@CG-@CG@CG@CGrG@CG@@CG;dZ@CGحV@CG@CGfA@CG@CGfA@CG+@CG@CGfA@CG@CG+@CGfA@CGfA@CGfA@CGfA@CG@CGحV@CGfA@CG@CG@CG@CG@CG@CG˒:)@CG˒:)@CGo @CGo @CGo @CGo @CGvȴ9@CGr@CG3@CG[W>@CGzH@CGzH@CG͞@CG&@CG?@CG&@CG-V@CGkP@CGݗ+@CG@CG&@CG&@CG&@CG{J#:@CG&@CG4m@CG|hs@CGsPH@CGo@CGiDg8@CG\(@CG\(@CGXe,@CGU=@CGRT`e@CGRT`e@CGO
M@CGO
M@CGKƧ@CGE84@CGAs@CG>6z@CG>6z@CG8}H@CG4֡a@CG4֡a@CG4֡a@CG1@CG+I@CG.H@CG.H@CG+I@CG'/W@CG'/W@CG$tS@CG$tS@CG!-w1@CG!-w1@CGXe@CG
M;@CGFt@CF!.I@CF!.I@CFFs@CF"@CFMj@CF@CF1@CF1@CF1@CFC-@CF]cf@CFC-@CF]cf@CF+@CFA@CF2X@CFqi@CFz@CFvȴ9X@CFp:~@CFs@CFl!-@CFiB@CFfffff@CF_ح@CF\N<@CF\N<@CF_ح@CF\N<@CFYJ@CFYJ@CFYJ@CFYJ@CFVu@CFOv_خ@CFOv_خ@CFL/{J@CFH@CFE@CFBZc @CF?@CF?@CF?@CF;5X@CF8YJ@CF8YJ@CF($x@CF!R<@CF!R<@CFOv_@CFOv_@CFu@CF
(@CF
(@CF_o @CFt@CF ѷY@CE!.@CEᰉ@CE
qv@CE
qv@CE@CE\(@CEv@CEڹZ@CEM:@CE$/@CE$/@CE}H@CEM:@CEM:@CEM:@CEݗ@CEM:@CEM:@CEݗ@CE$/@CE$/@CEzxl"h@CEzxl"h@CEzxl"h@CEm\@CEjOv@CEce@CEce@CE\@CEL_@CE?|h@CE+a@CEQ@CE[@CEo i@CD>@CD>@CDe@CD!-w@CDhr@CDhr@CDZ@CDZ@CDɅoi@CD?@CD7@CDj~@CD#x@CDO
M@CD1&@CDS@CD_@CD*1@CDN;@CD?@CDq@CDj~#@CDcA \@CD`d@CD`d@CD]ce@CD]ce@CDSMj@CDM:@CDFs@CDC,zx@CDC,zx@CD<쿱@CD9XbN@CD(\@CD"h	ԕ@CDtj@CDxF@CD1&y@CDn.@CC\N@CC@CCA [@CCC]@CClC@CC%2@CCQ@CC5Xy@CC@CC@CC6@CCE@CC*0U2@CCwk@CCߤ@CCA@CC$@CCA@CCA@CC$@CCMj@CCeO@CCQ@CC@CC~$@CC{J#9@CCxF]@CCjf@CCg	l@CCa@N@CC]cA@CCZ@CCW>6z@CCF]c@CCC%@CC=K^@CC6z@CC33333@CC/V@CC&@CCPH@CCnP@CCnP@CC'/@CC҉@CCS&@CCI^@CCI^@CB74@CB~@CB74@CB74@CBm@CBC,@CB ѷ@CB,<@CB͞&@CB͞&@CBW@CB)_@CB@CB<64@CBY@CB<64@CBY@CBg	@CBvȴ@CB@CB>B@CBS&@CBvȴ@CBwkQ@CBᰊ@CBS&@CBL_@CBp:@CBݘ@CBݘ@CBݘ@CBݘ@CBݘ@CB~"@CB~"@CB@4@CB~"@CB{m@CB{m@CB{m@CB{m@CBxl"h
@CBu%F
@CBxl"h
@CBqiC@CBqiC@CBu%F
@CBqiC@CBqiC@CBnO@CBnO@CBnO@CBh	ԕ@CBh	ԕ@CBh	ԕ@CBa|Q@CBa|Q@CB^5?|@CB^5?|@CB^5?|@CBW'@CBW'@CBM@CB=p
@CB:)y@CB6C@CB)y@CB&IR@CBe+@CBs@CB@CB	 @CB	 @CBn@CBn@CBu%F@CA.H@CA.H@CAlD@CAlD@CAlD@CAY}@CA>BZ@CAᰉ'@CAᰉ'@CAᰉ'@CA"`@CA"`@CA"`@CAԕ*@CAԕ*@CAy@CAo@CA2W@CAo@CA_o@CAN;6@CAy@CA2W@CAD@CA@CA^5?}@CA^5?}@CA^5?}@CAX@CAX@CA|@CA'R@CA'R@CAB@CAl@CA(@CA(@CAl@CA(@CA(@CAu@CAu@CA@CAR<6@CAR<6@CAR<6@CAo@CA@CAo@CAo@CA~($@CA7Kƨ@CAoiD@CAb}@CAb}@CAb}@CAb}@CAb}@CA|Q@CA|Q@CAx@CA|Q@CAx@CAx@CAu!S@CArGE8@CArGE8@CArGE8@CAk~(@CAk~(@CAhr @CAe+a@CAhr @CAe+a@CAae@CAe+a@CA^@CAae@CAae@CAae@CA[W>6@CA[W>6@CA[W>6@CA[W>6@CA[W>6@CAXbM@CAXbM@CAXbM@CATɅo@CATɅo@CAQ@CAJE@CAJE@CAGz@CAGz@CADg8~@CAA [@CAA [@CA=b@CA:S@CA4J@CA-w1@CA-w1@CA-w1@CA-w1@CA0
)@CA-w1@CA&x@CA*0U2a@CA*0U2a@CA*0U2a@CA&x@CA&x@CA&x@CA&x@CA#w@CA&x@CA [7@CA#w@CA#w@CA#w@CA#w@CA [7@CA#w@CA#w@CA#w@CA_p@CA_p@CA_p@CA+@CA@N@CArGE@CArGE@CArGE@CArGE@CA	k~@CA ѷ@C@PH@C@	k@C@	k@C@	k@C@\)@C@C@C@C@C@҈p@C@ۋq
@C@F@C@ѷX@C@p:@C@p:@C@p:@C@)^@C@ěT@C@ěT@C@TɅ@C@
(@C@
(@C@
(@C@4m@C@4m@C@{@C@{@C@U@C@U@C@d8@C@d8@C@
=q@C@
=q@C@-
@C@IQ@C@-
@C@'RT@C@YJ@C@n@C@n@C@˒:*@C@|@C@r Ĝ@C@eO@C@bM@C@Q@C@NU@C@H@C@D*@C@A7K@C@>BZc@C@:~ @C@:~ @C@73@C@4m9@C@4m9@C@1&x@C@4m9@C@1&x@C@*0@C@*0@C@'RT`@C@$xG@C@$xG@C@ ě@C@ ě@C@ ě@C@}H@C@6@C@@C@*0U@C@bM@C@*0U@C@*0U@C@@C@@C@*0U@C@bM@C@
qu@C@@C@F]d@C@     @C?#@C?rGE9@C?䎊r@C?@C?@@C?;dZ@C?@C?@C?+@C?˒:)@C?˒:)@C?˒:)@C?o @C?@C?vȴ9@C?/V@C?r@C?3@C?[W>@C?zH@C??@C?-V@C?kP@C?$tS@C?$tS@C?$tS@C?@C?{J#:@C?|hs@C?v_ح@C?lC@C?iDg8@C?iDg8@C?eں@C?iDg8@C?_o@C?_o@C?Xe,@C?\(@C?Xe,@C?Xe,@C?Xe,@C?U=@C?U=@C?Xe,@C?RT`e@C?H˒:@C?E84@C?>6z@C?>6z@C?8}H@C?8}H@C?4֡a@C?4֡a@C?+I@C?+I@C?.H@C?'/W@C?,@C?v@C?,@C?@C?@C?
M;@C?
M;@C?)^@C?)^@C?@C?)^@C?)^@C?@C?@C?@C?@C?@C?
M;@C?Ft@C?Ft@C? hۋ@C?@C? hۋ@C? hۋ@C>!.I@C>!.I@C>"@C>!.I@C>"@C>Fs@C>Mj@C>Mj@C>@C>@C>@C>쿱[W@C>x@C>1@C>1@C>C-@C>C-@C>ߤ?@C>ߤ?@C>ߤ?@C>]cf@C>]cf@C>]cf@C>]cf@C>]cf@C>+@C>+@C>]cf@C>+@C>+@C>+@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>Ϫ͟@C>҈p;@C>҈p;@C>҈p;@C>A@C>A@C>t@C>A@C>A@C>t@C>t@C>t@C>ȴ9X@C>m\@C>t@C>ȴ9X@C>t@C>A@C>t@C>t@C>t@C>ȴ9X@C>m\@C>ȴ9X@C>m\@C>m\@C>&I@C>m\@C>&I@C>&I@C>ߤ?@C>ߤ?@C>&I@C>@C>Q@C>@C>@C>Q@C>@C>@C>@C>Q@C>'@C>'@C>'@C>'@C>Q@C>2X@C>'@C>'@C>'@C>2X@C>2X@C>2X@C>2X@C>'@C>'@C>'@C>2X@C>2X@C>2X@C>}Vl@C>2X@C>2X@C>2X@C>2X@C>2X@C>2X@C>2X@C>}Vl@C>}Vl@C>6z@C>6z@C>}Vl@C>6z@C>-@C>-@C>-@C>-@C>-@C>T@C>T@C>T@C>T@C>T@C>af@C>@C>,<@C>@C>,<@C>,<@C>O;@C>,<@C>O;@C>,<@C>,<@C>O;@C>O;@C>,<@C>O;@C>Fs@C>Fs@C>$t@C>Fs@C>Fs@C>O;@C>Fs@C>$t@C>$t@C>@C>@C>$t@C>@C>$t@C>@C>@C>$t@C>@C>@C>@C>@C>qi@C>@C>qi@C>@C>qi@C>@C>qi@C>+J@C>qi@C>qi@C>qi@C>qi@C>qi@C>+J@C>+J@C>+J@C>+J@C>+J@C>%@C>+J@C>%@C>%@C>+J@C>IQ@C>%@C>%@C>%@C>IQ@C>}Vl@C>}Vl@C>IQ@C>}Vl@C>z@C>z@C>z@C>vȴ9X@C>z@C>z@C>z@C>z@C>vȴ9X@C>vȴ9X@C>z@C>vȴ9X@C>vȴ9X@C>vȴ9X@C>s@C>s@C>s@C>s@C>p:~@C>s@C>s@C>p:~@C>p:~@C>l!-@C>l!-@C>l!-@C>iB@C>fffff@C>iB@C>iB@C>c	@C>c	@C>c	@C>c	@C>c	@C>\N<@C>_ح@C>_ح@C>_ح@C>_ح@C>c	@C>_ح@C>_ح@C>_ح@C>\N<@C>_ح@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>\N<@C>R<6@C>R<6@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>L/{J@C>Ov_خ@C>L/{J@C>Ov_خ@C>H@C>H@C>H@C>?@C>?@C>;5X@C>BZc @C>BZc @C>BZc @C>?@C>BZc @C>?@C>?@C>;5X@C>;5X@C>;5X@C>;5X@C>;5X@C>?@C>;5X@C>8YJ@C>8YJ@C>8YJ@C>5?|@C>5?|@C>5?|@C>1.@C>5?|@C>5?|@C>1.@C>.2@C>1.@C>.2@C>.2@C>1.@C>1.@C>.2@C>.2@C>.2@C>1.@C>.2@C>.2@C>.2@C>($x@C>($x@C>($x@C>$/@C>$/@C>$/@C>!R<@C>!R<@C>!R<@C>Ov_@C>Ov_@C>u@C>u@C>@C>u@C>@C>@C>@C>u@C>zG@C>4K@C>@C>4K@C>zG@C>4K@C>4K@C>4K@C>4K@C>4K@C>
(@C>
(@C>
L/@C>
L/@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
(@C>
L/@C>
L/@C>
(@C>
(@C>
L/@C>
L/@C>_o @C>
L/@C>
L/@C>_o @C>_o @C>
L/@C>_o @C>_o @C>
L/@C>t@C>_o @C>_o @C>t@C>_o @C>t@C>t@C> ѷY@C>t@C>t@C> ѷY@C>t@C>t@C>t@C> ѷY@C> ѷY@C> ѷY                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @iz-@i(\@iߤ@j[E@jj~"@j}@j*0U2@jL_@k'-w1@k5m\@kIݗ@k>Ov`@kA˒:)@kb`A7@k{_o@ktO
M@kߤ@kp:@k~($@kI^@ke@k@k=K@kS&@k($x@k#@kױ[W>@lBN;@l@4n@ln.@l\(@l)^@mUrGE9@mo @m`A7@m)^@m2X@mߤ@@n ѷ@ofA@pD*@p+a@pITɅ@p
E@pIL/{@p*0@pK]@p|@pmn/@oߤ?@opJL@pzU=@qq,=@qEGz@q%|@q.&@q;dZ@p­B@p[Y@pߤ?@onO@o+jg@oD@oce@o#|Q@n'/W@nv ѷ@mm\@lwkQ@j
1&y@ir@j">@jR<6@kX ě@k@k8Fs@j_o@j@j#x@jiB@j@j~($@j [7@jp-
q@ji0
)@jpOv_@j_jOv@jMMjO@j @jZ@jZ@iZ@iYJ@i&@iA7K@i#@iO;dZ@id1@i}ᰉ'@iiB@im@ix@j=w1@j@N@j~($@jd=p
@j7K]d@j)%2@jR+jg@jzl"h	@jL/{J@jXbM@j{y@je7Kƨ@jaXe,@j
L/@jj~#@jL/{J@jtSM@jG{@jrGE9@j&@j@jW'@jpxl"h
@jm1@jo)^@jeW>6z@jcR@jisg@jp`d@jq\(@jm8@jQ_@j3@j-
q@j@j=K@j}Vl@jy=c@j%@jU@jr Ĝ@jB@jxFs@jqiC@jm\@jo i@jZ@j9Xb@j ѷ@jwk@jD@jF
L0@j-@jC,zx@jO;dZ@j+J@j/V@j$/@jϪ͟@jrGE8@j*0U2a@j4m@jo hی@j~@j?@jiB@j!.@j˒:)@jIQ@j6z@jǀ4m@j~$@j˨Xy=@jĴ9Xb@j1.@j>BZ@jD@jī6z@jF
L0@jҌL_@jҊqi@j{J#9@j҇#@jjOv@j҃%@j	@jsg@j hۋ@jU2a|@j֩@jϷX@jo@jnO@k3@js@j#@jp:@jݔO
@jwkP@j"`@j ě@j!.H@j@jL_@jhۋq@jo i@j/w@jrGE@jݎ!R@j
qu@jᰉ'@jI^5@j6C@jZ@jS&@je+@j_ح@j(@kC@kl"h	@jO;dZ@k2a|@k_o@kiB@kS&@j*0U@js@jv_ح@j%@jJ#9@ku%F@kH@je+a@jn.@jr Ĝ@jd7@jĀIQ@jwkQ@j
qu@jS@jڶ}Vm@jE@k!.I@k_F@jXe@jm]@j-V@j-@jL_@jiB@jFs@jh	ԕ@jӽ@jϒ:)z@jt@j@jXe,@j䎊@jU=@jn@j@jڬ1&@je@ju@jQ@j|73@juE84@j|64@jC]@ja@O@j&@j_F@j^5?|@jVϫ@jeC\@j:JM@j<M@jN[6@jV ě@jUL_@j?@N@j$O
M@j*=p
@j@u%F
@j2$t@jQ@jOv_@i:@i-
@iVl!@iQ@i64@iqi@iߤ?@i(@i	k~@i_F@i2W@ip:@iM@iuwk@ii!.H@i_g	l@ii [7@ign/@ib-V@i^u%F@ib,<@iMW>6z@iJ\(@iYfA@iDm\@iC=K@iXoiDg8@ifQ_@iF^5?|@iN;5@i
jOv@iݗ+@i
hr @i
g	l@inP@h/w@iK]c@i [7@i	<64@h+@h	@hfA@h؞쿱[@hW'@h@h>B@htSM@hE@h,@h{@hߤ@@hƎqj@hy@hʸQ@hp:~@h(\@h_p@h`A7L@hʵ?@hL/{@hP{@h|쿱[W@hs4J@hw\@hix@hQ"`@hA/V@hA/w@h^Xy=@hisg@hs+a@hX)_@hCoiDg@hERT`e@h6	ԕ+@h;+j@hIzxl"h@hEO
M@h>]ce@h<	k@h;$@h#-@hN;5@hwk@h?@h>6z@g?@gn@gt@gד@gJ@g.2@gfB@g>B[@gŃ{J#:@gɮzH@gŃ{J#:@gfA@g@gD@g!-w@g@4@g@g,@g
=p@g'/@gIQ@gce@g*0@gb}V@gTɆ@g@g-@go hی@gPH@gC]@g|@gڹZ@g7@g{m@g`A@gPH@g4J@g^@g쿱[W@gl!-@g쿱[W@g$/@gu%@g ѷ@g$/@g]cA@g@gO;dZ@g@gw|@gp&I@gmC\@gwm]@gy+@giϪ͞@g`@gmC\@gvOv_خ@gwm]@gtC@gvOv_خ@giϪ͞@gpTɅ@gvOv_خ@gy+@gk33333@gb ѷ@g`@gZp:@gZp:@gdA7K@gr$/@ghl"h	@gazxl"h@gdA7K@ghl"h	@gOlC@g@$/@gBC@g7Ϫ͞@g933333@g5u%@g)Vϫ@g/zxl"h@g@$xG@g92a|@g7+@g)R@g+@g@N@g_o @g@N@gn@g*1@gn.@f6@f1.@fۋq
@g@N@ghr @gcA @fݗ+@fݘ@gZ@gfB@g-
@g0D@g;E@gB䎊q@gB䎊q@g:\(@g9+a@gI8YK@gLwkQ@gIfA@g;s@gDGE85@gP?@gHq@gBC-@g6bM@g+E84@g,-@g)
qv@g	-@g'/W@g	@f҈p;@g@fo hی@fu%F@f֌L_@fo @fae@fe+@f~($@fSMj@f@f@f҈@fq@f6z@foiDg8@fq@fěT@fu%F@f@f#@f5Xy>@fC@f'/W@f|Q@f'@fڹZ@flD@f*0@f{m@f	 @fhr@fN;6@f	k~@fs(@fdL/{@fl>@fk$tS@fh*0@fk$tS@f]m]@fQ4J@fX$/@f]m]@fdT@fdT@fk$@fgjf@fgjf@fX$xG@fJ@4n@fH/@fSrGE9@fS-@fH]cf@f9$@f4_o @f=6@fS@fVߤ?@f+-V@f+@f4@f=H˒@f/@f1?|h@f1?|h@f&"h	ԕ@f]cf@f'oiD@f?!.H@fArG@f?!.H@f1>6z@f1=b@f4J@f*L/{J@f-@N@f.vȴ9X@f2af@f@%@fCJE@f1=b@f$
(@fS&@fcA @f S&@f#Y|@f S&@f& ě@f(fB@fh	ԕ@f
Zc@fvȴ9@fv_ح@f	k@f/w@f	k@fo i@fO
M@f=p
@f	k@fh	ԕ@f/w@f(@f1<64@f<W'@f4u%F@f1;dZ@f=/V@f<W'@f8-V@f1;dZ@f*I^5?@f8-V@f:!-w@f:!-w@f2쿱[@f.tSM@f@o h@fK-V@fGrGE8@fKߤ@fL$tT@fJ73@fSA [@fL$tT@f?C,z@f<U2a|@f@˒:*@fJ8YJ@fCF]c@fGqu!@fUS@f]*0U2@fY~$@fF
(@f=@fCF]c@f?C,z@fDd8@fGp
=@fF
qu@fO8Y@fLm\@fK=K@fK=K@fD@f9O;d@fCF
L0@fR@f\D*@fS-@fCE84@fGo@fHZ@fFI^5@fNa|Q@fK@fGo hی@fN`d@fQ'/W@fK@fA҈@f3ڹ@f@|@fHѷX@fJ5?|@fX@fg]cA@fd@fX@fQ%F
L@f_u%@feC\@f\A7K@fUO;dZ@fQ%F
L@fQ%F
L@fK+j@fH`A@fF	ԕ+@fL~@fRp:@fX@fQ%F
L@fUO;dZ@fSVϫ@fYzxl"h@fg\@ferGE9@fc33333@fdᰊ@fdᰊ@fs@fu?|h@fk&@fv3@fyiDg8@fyiDg8@f~e@f|1&x@fvS&@fnM@fnM@fo'R@fZc@f	k@f!.H@f!.H@fxn@fZc@f>B[@f>BZ@fo i@fs@fO
M@f/w@f>B[@f	k@f@fF]d@fJL@fJL@fXe,@fO
M@f@fJL@fJL@f@f<쿱@f.H@fzH@fIQ@fW'@fJL@f@fɅoi@fu%F@f/V@fɅoi@f@f!-w@fQ@fe@fH˒:@fVϪ@f^5?}@f@f䎊r@f@f1&@fy@fU=@f}H@f+a@fe@fVϪ@fMj@fcA \@fqiC@fGE85@f+I@fȎqj@fȎqj@fU=@fπ4m@fπ4m@f?@fڜwkQ@fZ@f.H@fb}V@fӪ͞@fq@fڛS@fԕ*@fԕ*@fD@fD@fT`d@fD@f)y@f~($x@f?@fv@fڛS@fm\@fv@fᰉ'@f~($@fTɆ@f6C@f@f?@fC@fkP@fᰉ'@fᰉ'@f6C@f2W@fᰉ'@fm\@fSMj@fL_@g|hs@f󙙙@f󙙙@fRT`e@f2W@f2W@fC@f@gnO@g e+@fo hی@f64@f-@f2W@f64@f@f?@f2W@gC\@gu"@g|Q@gC,zx@f@g e+@g_@g
lD@f'/W@f_p@fxF@fRT`e@g e+@g	N;6@g
lD@g	N;6@gm8@g(@gm8@g tj@g(@gm8@g	N;6@g	N;6@g
=p@gm8@ghr@g_@gm8@g	@gXe@gzG@gAs@g7Kƨ@g%1@gzG@g$3@g$3@g 	 @g%1@g|@g+%F
L@g$3@g쿱[W@g%1@g&"@g-R@g"A@gzG@gzxl"@gAs@gAs@g&"@giB@g7Kƨ@g%R<6@g(]ce@g&"@g)D@g&"@g+$tS@g2Ov`@g0@g+$tS@g(]ce@g(]ce@g3y@g"A@gݗ+k@g+$tS@g&"@g 1&y@g/O
M@g7?@g>ᰊ@g4/@g&"@g2Ov`@g3y@g"A@g,#@g4/@g;_o@g:j~#@g-R@g(]ce@g)D@g:j~#@g?-@g?-@g>*1@g"A@g3x@g?-@g;_o@g/N;5@g-g@gA\(@g7n.@g,#@g6?@gA\(@g:j~#@g,+J@gD#9@gFJM@gLwkP@gLxl"h
@g?-@g>*1@g=1@gA\(@g;_o@g7n.@gFJM@gD#9@g;_o@g?-@gFJM@gA\(@gB[W?@gHM@gD#9@g?-@g6?@g:j~#@g4]cf@gHM@gK@gE&@g>*1@g:j~#@g=1@g6?@gB[W?@gEoiD@g6?@gA\(@gFx@gRn@gP3@g:j~#@g>Fs@gK@g[vȴ9@gV0U2a|@gWݗ+@gM"`@g?@gBߤ?@gK@gI'R@gM"`@gSiDg8@gT@gRn@gLwkP@gEoiD@gRn@gM"`@gEoiD@g>Fs@gRn@gT@gaKƧ@gXe@gM"`@gO=b@gI'R@gK@gV/{J#@gV/{J#@gShr @gPaf@gLwkP@g^?@gZZ1@gPaf@gPaf@gTt@gRJ@gRJ@g]!-w1@gk@gf+@g_>BZ@gaKƧ@gk@glg8}@gf+@gd@gmo@glg8}@gb}Vl@g]!-w1@gb}Vl@geu!S@gd@glg8}@gk@gi'RTa@gi'RTa@gh<쿱@gd@geu!S@gqY}@gx@gqY}@gf+@gsXe,@g@gzI^5?@gq$@g})^@g;dZ@g쿱[@g@g{B@gt@go-w1@g{B@gMj@g,@g,@ge@g,@gVϪ@gMj@gVϪ@g,<@gȴ9X@gMj@gMj@gMj@ge+a@g:@gH˒:@gn.@gMj@go@gVϪ@g֡a@gsPH@ge+a@g:S@g@g1&@g^5?}@go h@g,<@gVϪ@g1&@g֡a@gH˒:@g^5?}@grGE8@g9XbN@g9XbN@gϪ͟@g9XbN@g+I@gFs@gZ@g
M;@g1'@g hۋ@g9XbN@g%2@gϪ͟@g4m@gs@g+I@gGE85@g?@gb}V@gD@gD@gb}@gq@g?@gb}V@gQ@gl@gD@g~($x@gƨTɆ@gO;d@gO;d@go@gƨTɆ@gƨTɆ@gƨTɆ@gX@gZ@g-@g͚kP@gE84@gᰉ'@gI^5@g6@g-@gᰉ'@gI^5@g-@gG{@g}H@g}H@g'0@g@g(@gᰉ'@gZ@g͚kP@go @gc	@g`A7L@g'0@ge+@g'0@g0
@g5Xy>@g@g5Xy>@g'/W@g|hs@g`A7L@ge+@g|hs@g5Xy>@g`A7L@gߧ&@gߧ&@g#@g@gc	@g`A7L@g@g#@g'RT`@g'0@gC\@gB@gL/{@gQ_@g5Xy>@g&IR@gm\@gL/{@g+j@gB@g*0@h&@g4m9@g`A@gQ_@g{m@ghr@g;dZ@gm\@g$tS@hp:@g*0@gzG@hp:@h^5?|@gXe@g	 @hA7K@hA7K@hVϫ@g	 @gzxl"@g3@g*0@glC@gzG@g	 @h@hl"h	@hᰊ@h/@h%F
L@hrGE9@h\@g*0@giB@hR@hp:@h	O
M@hkP|@h2a|@h?@hK]@hᰊ@h2a|@h+@hK]@h?@hK]@h2a|@hn@h2a|@hkP|@h C,@h#[W>@h+@h@4n@h[W?@h[W?@h&xl"h
@h)?|h@h&xl"h
@h JM@h'@h1O
@h&xl"h
@h#[W>@h%[@h&xl"h
@h#9@h"M@h%[@h\(@h\(@h&xl"h
@h1ݗ+@h JM@h-iDg8@h'"`@h#'R@h*3@h)>6z@h&wkP@h,n@h.@h4Zc@h"M:@hߤ?@h,n@h&wkP@h-iDg8@h,n@h"M:@hߤ?@h"M:@h'"`@h%@h-iDg8@h-iDg8@h1ݗ+@h<O
M@hEo i@hEo i@h-iDg8@h2e@h7!-w1@h)>6z@h4Z1@h8?@h.t@h7!-w1@h<O
M@hEo i@h9>BZ@h5@h8?@h7!-w1@h,J@h-hr @h>s@hFg8}@hE@h;KƧ@h<O
M@h7!-w1@h0/{J#@h8?@h5@h"L/{J@h*af@hE@hC'RTa@hFg8}@hMXe,@hE@hE@hKY}@hGo@h8%@h>@hGo@hGo@hMXe,@hB<쿱@h@+@hXtSM@h\쿱[@hP䎊@hGo@hP䎊@hY@hTI^5?@hUB@hUB@hTI^5?@hK$@hUB@hUB@hI-w1@hQ@hR1@hGo@hQ@h`Ʌoi@hTI^5?@hCU=@hP!-w2@hY@h`Ʌoi@hXtSM@hR1@hW)^@hW)^@hW)^@hUB@hb-V@hco@h_e+a@hY@hQ@hN@hTI^5?@hP!-w2@hJ$t@hY@h[:S@hTI^5?@h_e+a@h`ȴ9X@hP!-w2@h<U@h@D@hMXbM@hW)^@h^n.@hK$@h@D@h;J#9@hJ$t@hP!-w2@hN@hI-w1@hCU=@hG@hPOv_@hQ@hPOv_@hN)@hKE@hMW>6z@hTH@hR`A7@h@D@h2D@h8n@h8n@hCU=@h?tj~@h;J#9@hCU=@hTH@hR`A7@hE ѷ@h@D@hFfffff@hUq@hWrGE@hMW>6z@hI,zxl@h?tj~@hFeO@hEI^@hC%@hEI^@hKE@h[:S@hUq@hFeO@hG@hMW>6z@hFeO@hFeO@hB:~ @hMVl!@hKE@hTH@hTH@hEI^@hI,zxl@hNY@hMVl!@hFeO@hEI^@hI+a@hK䎊r@hJ\(@hQ$/@hNY@hR䎊q@hW'/@hY8YK@hW'/@hK䎊r@hQ$/@h[9@hP}H@h`)_@h_dZ@hJ\(@hNY@hUU=@hUU=@hGK]d@hNY@h^     @h[9@hY8YK@hTH@hMVl!@h_ce@hYfA@hTGE85@hj˒:*@hdm@hXqiC@hTGE85@hYfA@h[84֡@hXqiC@hQ4m@hTGE85@hXqiC@h^     @h_ce@h].H@h].H@h_b}V@h\wkQ@h[84֡@hb)y@hTFs@h_b}V@h^     @hTFs@h].H@h[8}H@hRZ@h].H@h].H@hW
M;@hUl@hQ4m@hJqj@hKs@hQb}@h[8}H@hTFs@hW
M;@h[8}H@h`?@hgr@hYԕ*@h[8}H@h].H@hYԕ*@hYԕ*@h[8}H@hTFs@hRC-@hI*0U2a@hNQ@h[8}H@hXq@hYa@@hXq@hFc	@hMTɅo@hW
M;@hXq@hYa@@h\S@hXq@hNQ@hQb}@hB8YJ@h1!R@hI*0U2a@hJ@hJ@hKA [@hXq@hKA [@hXp:~@hMTɅo@hMTɅo@hRC-@hPQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ?zG{?MjOv?N;5?|?+jg?z?b}V?oiDg8?o hۋ?حU?"`B??-
qv?S?D?*0U2a?9D?D??}H?ᰉ'?7KƧ?}Vl?n.?C,?
L/{?	 ѷ?Ϫ͞?Vt?8YK?VϪ͟?@?n/?)^	?T`d?ĕ*0?oiDg8?/v?ڹY?2a|Q?1o?GE84?L_?$tSM??БN;6?"`B?҇+I?ҧ-?lC?䎊r?Fs?fA?_Ft?JM?	k~(?#x??y(?KƧ?0
(?ח$tS?حU?L_?z?䎊?{m]?a@O?/{J#:?ߧ&?6C?޹Y}?I^5??ܹ#w?m\?g8}H?C\?\(\?ڹZ?l!-w?}H˒?l?c	?ѭB?
=p
? ѷX?l!-w?$?ЃnP?ͫU=?-V?!.H?\(\?H?Vu?9XbM?C,z?4m?䎊?@?*0
?B?7KƧ?s?:)y?\N;?C\?)^?r ě?p
=q?%2?QR?_F??>BZc ?#x?Fs?O
M?kP|?7KƧ?Q_?1&y?^?-V?͞%?*0?}H?/Vϫ?+j?a@N???8}H?S?JL?GzH?4m8??r?-?ݗ+j?C,z?n?n/?-w1?u?IQ?H˒:?o hۋ?$tT?<64?1&y?_o?:)y?<64?'RTa?!-w1?!.H?!-w1?
(?JD?u%F
?ᰉ'?6C-??u%F?䎊q?)^	?oiDg8?|??&??e+?ᰉ'?ᰉ'?Ov_ح?쿱[W??tj?Ov_ح?'RTa?N;5?:)y?D*0?!-w1?U2a|?vȴ9X?*0?ݗ+j?tj~?@NU?A?S&?htj~m}H˒?kP{?fA?(\)?Y}?*0?%2?N;5?Xe+?n/??䎊r?~Q?{u%F?J6C-?@NU?S&?bM?$tS?N;5?N;5?=K^?Ϫ͞?u!?`d8?qu!S?o!-w1?䎊q?ie+ahtj~pbMl1&yhtj~?6C-?a@N?+I?Z?*0U2a?a@N?Z?sPH?$tS?bM?Q?,<?Q?Ϫ͞?ᰉ'?$tSM6C-?O;dZ?N;5X?_Ft?$tS?y_o eL_?S&?Mj?zG{?tj~?tj~?IQ?쿱[W?@bM?}H˒?sg?vȴ9?4J?6C-?$tS?e+a?1&y?kQ_?"`AF??|1&yUL_?}}H˒m}H˒?x*0
?|C,zxl?},<?zvȴ9?{Q_?n?,<?sPH?3*0U2a?!-w1?pbMUL_?s@NUbsPH?{qu!S?	 ?ye+aeL_htj~??*0?:)y?0
(6C-??0
(?~Ov_ح?qu!S?H?$/?E?U=KtzG{kQ_?vǿ:6C-?Y}?J6C-??3*0U2a?kP{?rnO;?eL_?J6C-nOv_ح?V?}H˒?Ov_خ6C-?zvȴ9?$/?:)y?rsPHm}H˒o!-w1ſc*0U2a?~Ov_ح?Mj?Sٿf?q4J?$tS?$tSM?)^	?@NU?p:?Ϫ͞?IQ?J6C-?hr Ĝ?Ϫ͞?hr Ĝ?-
qv?{u%F?]}H˒,<Rn/?Fs?Z?Ov_خ?Mj?zG{?u"?N;5X?tzG{o䎊q޿tZ?+jg?U=Ks@NU?ku%F?$tS?hr Ĝ?usgeL_?}}H˒?@NU?a@N?sPH?sPH?*0J6C-?uL_?:6C-rsPH?V?a@N?*0U2?kQ_?SٿpbMf?v+I@bM?4JS*0U2a?tn?~Q?~Q?<64?qu"?m}H˒?N;5?3*0U2a?PbM?o!-w1?{Q_?	 ?w?kQ_q4Jm}H˒?$tS?a@N?	 ?p)^	ie+ap)^	?_o ?C,zxl?n/?䎊q?Ϫ͞?ᰉ'?Ov_خ?w?_o?O;dZ?N;5?w?$tS?zG{?fA?*0U2afOv_خ₿3*0U2a?zvȴ9?!-w1?tzG{?v?}Z?+jg?ᰉ'*6C-?-
qv?O
M?T`d?o䎊q޿a4J?ݗ+j?*0?Fs?u"bn/?Z?]ce?JD?sg?vȴ9?+I?u!?xPH?usg?|C,zxl?n/?Q?z6C-?n/?*0?1&y?O;dZ?n/?L_?~Ov_ح?}}H˒?~Q?}Z?PbM6C-?uL_?Ov_خ?}H˒kQ_Rn/?u"?Z?O
M?҈?,<쿱?O
M?sPH?Q?Ϫ͞?qu!S?3*0U2a?!-w1?zG{?Ϫ͞?ᰉ'?ᰉ'?ᰉ'?zG{?S?S*0U2a?aeq4J?䎊q?(\)??p:?PbMs@NUtnpbM?UL_@bM?~Q?Z?s@NU?)^	?o!-w1ſq4J?M}H˒?$tSbn/?s*0U2ap)^	?v+I[Q_?vȴ9X?zG{?zG{?6C-?u"?C,zxl?J6C-?z6C-?*0U2?䎊q?tzG{kQ_:6C-?ye+a[Q_??hr Ĝ?4J?n?*0U2a?zvȴ9@bM?s@NU?{?u!?*6C-?UL_?PH?=K]        ?htj~Xtj~?{u%FXtj~?4J?p:a4J?{?fOv_خ?C,zxl?fA?Ϫ͞?C,zxl?wXe+?UL_tZ?6C-?bM?xtj~?fOv_خRn/?o!-w1ſku%F?rn/?wXe+?҈?~Q?hr Ĝ?R<64`bM?n?@?qu!S?_Ft@bMwXe+Կbn/?usg?uL_?rnO;?`bM?҈οkQ_?N;5?{u%F?bM?Zݘ?}}H˒?4J?ɅoiD?*0
F?_!-w1?`bM?uL_?}H˒?|1&y?g]}H˒?zvȴ9?v+I?vOv_خrsPHx*0
usg?gqu"o䎊q?kP{?*0?+jg?wXe+?x*0
?,<?wkP?|1&y?x*0
ie+a?q4Jj6C-?usg]}H˒?Xe?$tSq4JtZrn/?$tSM?wXe+?V?u%F?$/Z6C-?+I?Q?o䎊q޿c*0U2a?ݗ+j?]ce?npbM?|1&y?䎊q?PH?-
qv??R<64?|1&y?$tS?|1&y?$tS?y_o ?-
qv?w?dzG{p)^	?}Z?_oҿhtj~?bsPH?tn?s@NU?o䎊q?rn/p)^	3*0U2a?l1&y?q4J?v+I?m}H˒?[Q_?$/?1&y        ?p:?	 ?y_o ?xtj~?wbsPHv?Z6C-?-
qv?2a|Q?+jg?3*0U2a?tzG{?U=K?	 ?|C,zxl?y_o ?rn/l1&y?rsPHs*0U2a?s@NUo!-w1?dzG{PbM?!-w1ſZ6C-rn/3*0U2a?w?usg6C-vOv_خ?F?Z?n/?kQ_ku%F?n?IQ?2a|Q?)^	?{u%F?`A7L?e+a?H?ᰉ'?Q_?tZ?hr Ĝ?$tSM?,<쿱S*0U2a?s@NUkQ_?vOv_خ?{qu!S?z6C-?kP{?kQ_qu"?s*0U2a?~Q?|1&y?₿PbM?s*0U2a?ɅoiD?	 ?sPH?*0U2V??T`drnO;?q4J?zvȴ9?vOv_خ?tzG{?x*0
?u!?ǿZ6C-y_o ?p)^	?S?҈?Z?ݗ+j?q4JtZm}H˒?wXe+?v+IkQ_?|??sg?L_gM}H˒?F?J6C-??,<?Ϫ͞?1&yie+a?tj~?L_?ndzG{?kQ_?u"?C*0U2a?htj~?!-w1ſS*0U2a?-V??kP{?Z?ye+a?bsPH?a4J?`d8?ݗ+j?~Ov_ح?s*0U2abn/?sPH?nO;?S&?ݗ+j?v+I?{?1&y?1&y?IQ?[Q_Z6C-?y_o ?)^	?T`d?*0?a@N?n?4J?S&?+?fA?O
M?|C,zxl?{qu!S?y_o ?xtj~?}H˒?_o ?~Ov_ح*6C-?[Q_?S?SٿC*0U2a?o䎊q?Q?n/?H?~Q?tzG{fOv_خ?u"?&Xtj~?tn?},<?)^	?	 ?{qu!S?3*0U2ao!-w1?y_o ?҈?w?{?hr Ĝ?U=Kqu"@bM?ɅoiD?L_?`bM?vOv_خ?+?sg?u%F
?u%?bM?!-w1?	 ?V?kQ_?C,zxll1&yie+a?bM?Mj?҈?Mj?}Z?y_o ]}H˒?tj~?n?,<?e+a?o!-w1?w?s@NU?wXe+?sg?!-w1?},<?-
qvS*0U2a?{ſj6C-?wbn/??,<UL_?ᰉ'?PH?w?w?rn/?+I?T`d?xtj~?s*0U2anOv_ح?ye+as@NUz6C-usg?o!-w1?nOv_ح?ye+a?_o?A?~Q?y_o ?x*0
?nOv_ح?Xe+?{?}Z?*0?䎊q޿o!-w1ſeL_?Xe??䎊r?S&?|C,zxl?䎊q?u%F
??u%?fA?ᰉ'?U=K?gPbM?}}H˒?rnO;UL_?@NU?*0?$tS?hr Ĝ?4J?$tS?nOv_ح?bn/C*0U2a?6C-:6C-?usg?wkP?x*0
?o!-w1ſye+a?J6C-?M}H˒	 ҿuL_??Z?S&?rsPH?	 ?gwXe+?Rn/?v+I?y_o ?hr Ĝ?!-w1?xPH?l1&yuL_?	 ?xPH?$tS?+?~Ov_ح?N;5?bn/?fǿJ6C-o!-w1?_!-w1?zvȴ9?}Z?~Ov_ح?|C,zxl?z6C-?}}H˒?~Ov_ح?|C,zxl?{qu!S?ye+arn/?q4J?vǿnOv_ح?fOv_خ?}Z?*0U2a?u"`bMuL_?ye+a?D*0?~Ov_ح?pbM?rn/?s@NU?tzG{?y_o ?p:?J6C-[Q_?S*0U2a?wXe+Կ`bM?}Z?Z?Q_?䎊q?wXe+?eL_V?҈?*0U2a?L_?$/?fA?fA?!-w1ſPbM?S?0
(?qu"PbMS*0U2a?Ov_خ?Ov_ح?Z??@NU?߿zvȴ9f?4J?l?Xe+?}}H˒?{u%Fm}H˒?+jg?,<??}}H˒?,<?	 ?zG{?2a|Q?+??:)y?҈?sPH?q4JuL_?U=K?߿gv+Iqu"?l1&y??tZ?sPH?E?䎊q?f?@bM?o!-w1ſwtZ?vǿpbMrsPHpbMhtj~?l1&y?{u%F?}ZUL_?sPH?e+a?C,zxl?ᰉ'?fA?IQ?dzG{?L_?N;5X]}H˒?@NU?+?}}H˒tZ}Z?f?)^	?V?O;dZ?wkP?@bMp)^	?6C-?}}H˒?@?u"?Ov_خ?O
M?O
M?2a|Q?Z?u"?nO;?2a|Q?eL_p)^	usg?u%?,<?bM?S*0U2a?o䎊q޿rsPHj6C-??+j?Z?$tSm}H˒z6C-uL_p)^	?m}H˒S*0U2a?c*0U2a?}}H˒]}H˒PbM?Xe+?Zo!-w1ſJ6C-?-
qv?|C,zxl?v+I?4J?xPH?{u%Fc*0U2a?bn/?vOv_خ?o!-w1?bsPH*6C-?-
qv?Z?tZ?M}H˒ku%F?kQ_?V?)^	?tzG{g?vOv_خ?	 ҿeL_?Xe?A?}}H˒?tn?zvȴ9?usg?ߤ??@NUJ6C-?}}H˒?zG{?䎊r?}}H˒?usgo!-w1?!-w1?}Z?&?sgF?_o ?,<?bM?Q?fA?=K^?zG{s@NUz6C-?a4J?N;5?x*0
q4J?tn?!-w1?zG{?Z?S&¿J6C-nOv_ح?_o ??{qu!S?x*0
?m}H˒uL_x*0
Z6C-?*0U2a?fA?@NUV?tzG{?}Z?ye+a?䎊q?6C-o䎊q޿htj~?R<64?u%?|1&y?nO;??_!-w1?bn/?u"?rnO;rsPH?wZ6C-?tzG{?	 ?)^	?}}H˒?}}H˒?wg?Fs?e+a?rnO;?}Z?)^	?L_?vȴ9XPbM?	 ?$tS?nO;?@NUPbM?rnO;?|1&y?v?z6C-?u%?!-w1ſrsPHv?xPH?$tSM?F?	 ?A?ᰉ'?u%FPbM?ie+a?QfOv_خv?dzG{?wXe+?!-w1?tZ?n?$/?䎊q?j6C-*6C-?$/?*0?<64?)^	?$tS?~Ov_ح?{ſs@NU?s*0U2a?}}H˒?vOv_خ?z6C-dzG{?htj~Z6C-?f?}}H˒??{u%F?Rn/uL_?vOv_خ?U=K?{Q_?~Q?q4JnOv_ح?ku%Fo!-w1?o!-w1?|1&y?|C,zxlUL_?o䎊q?N;5X?Ϫ͞?ߤ??Fǿp)^	?nOv_ح?|??z6C-?w?bsPH*6C-?hr Ĝ?v?lS*0U2a?z6C-htj~kQ_kQ_?@NU?*0
?%2?vȴ9?}Z?zvȴ9?j6C-eL_?rnO;?m}H˒?s*0U2a?:)y?6?Ϫ͞?ᰉ'?E?N;5?vȴ9X?dzG{x*0
?F?+jg?Fs?L_?N;5?rnO;kQ_?x*0
?j6C-o!-w1?<64?|1&y?tj~?Q_p?Xe+?!-w1?}Z?*6C-?+I?Fs?*0
?ݗ+jrsPHZ6C-?qu"        ?$tSrn/?Xe?E?S&?xPHj6C-s@NU?m}H˒?wXe+ԿRn/kQ_?eL_?n/?sPH?f?ku%F?vOv_خ?@bM?Z?$tS?dzG{?҈?*0U23*0U2a??u"?c*0U2avOv_خ?	 ?!-w1?N;5X?q4JbsPH?=K]?₿Rn/?{qu!S?fA?+?z6C-?3*0U2a?dzG{?n/?_Fthtj~?y_o V?s*0U2aJ6C-?v+IZ6C-?6C-?:6C-?Z?zG{?bsPHC*0U2aj6C-?rnO;rnO;?n?Xtj~a4J?SٿC*0U2a?wXe+?xtj~?bM        ?y_o ?ye+a?ye+a?qu!S?_o ?usg?n/?+?s*0U2ax*0
v?	 ?,<?xtj~F?䎊q?[Q_?kP{?o䎊q޿pbM?S*0U2aRn/o!-w1?!-w1?4J?nOv_حJ6C-?_o ?$/?*0?ᰉ'?|?]}H˒s@NUv?6C-?xtj~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            &+B#=q@3;  41                                      1                                       