CDF       
      pressure  g   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P23    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.320847Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @Q        data_max      @Q        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     ;8  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @   data_max      @c   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      ;8  iX   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d           temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?   data_max      @ރ%   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       ;8  `   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@Q   data_max      @AKW>6z   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      ;8  h   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       8   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @,   data_max      @sfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        ;8 Gp   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?"`A   data_max      ?m   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      ;8 x   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       ̰   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       ;8 ۀ   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d          	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @NL   data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     ;8 %   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       `   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( o   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( o   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      (z   data_max      (z   C_format      %10d       o   latitude               	long_name         latitude   units         	degrees_N      data_min      @H2f<u   data_max      @H2f<u   C_format      %9.4f          o   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aD<   data_max      aD<   C_format      %9.4f          o   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        o   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min            data_max            C_format      %4d        o@Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @Q     @@      @      @      @ffffff@ @"      @$      @&      @(333333@*      @,333333@.      @0      @1      @2      @2@3fffff@5      @6      @7      @8      @9      @:      @<333333@=      @>      @?@@      @@     @A      @AY@B@B     @C      @C     @D      @D     @Dfffff@E@F      @F@G      @Gs33333@H      @H     @I@I     @J      @Js33333@K      @K     @L      @L     @M      @M     @N      @Ns33333@O      @O     @P      @P9@P     @P     @Q      @Q@     @Qs33333@Qfffff@Q@R@     @R     @R     @S      @S,@S     @T      @T9@Ty@T     @U      @U@     @U     @U     @V      @V333333@Vy@V     @W      @W@     @W     @W     @X      @X@     @X     @X@X@Y@     @Y     @Y     @Z      @Z@     @Zs33333@[      @[@     @[     @[     @\      @\@     @\     @\     @]fffff@]@]     @^      @^@     @^     @^     @_fffff@_&fffff@_fffff@`      @`      @`@     @`\@`@`     @`     @`     @a	@a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c\@c     @c33333@c@c     @d      @d      @d@     @dc33333@ds33333@d33333@d@e      @e      @e@     @ec33333@es33333@efffff@e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g#33333@g0     @gl@g     @g     @g     @g     @h      @h      @h333333@h33333@h     @h     @h33333@i      @i      @i@     @ic33333@i     @ifffff@i33333@i     @j      @j      @j@     @j\@j     @j     @j     @j     @k      @k@kI@k`     @k     @k     @k     @k     @l33333@l#33333@l@     @l`     @l     @l     @l33333@l     @l@m      @m@     @mS33333@m@m     @m     @m     @n      @n#33333@nC33333@n`     @n     @n     @n     @n     @o      @o#33333@oC33333@o`     @o|@o     @o     @o     @p      @p     @p      @p0     @p>fffff@pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @pfffff@qfffff@q      @q0     @q@     @qP     @q`     @qp     @q     @qfffff@q     @q     @q     @q     @q     @q     @r      @r     @r0     @r@     @rP     @r`     @rp     @r@rfffff@r     @r     @rfffff@r     @r     @r     @s      @s     @sfffff@sA@sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t!@t.fffff@t@     @tQ@t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u>fffff@uP     @u`     @up     @u     @u     @ufffff@u@ufffff@u     @u     @u     @v      @v     @v      @v.fffff@v@     @vP     @va@vp     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w.fffff@w<@wP     @w`     @wp     @w     @w     @w     @w     @w@wfffff@w     @w     @x      @x     @x      @x.fffff@xC33333@xNfffff@x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @ya@yp     @y~fffff@y     @y     @y     @y     @y     @y     @y     @z      @z33333@z$@z0     @z@     @zP     @z`     @zp     @z     @zfffff@z@z33333@z     @z     @z     @z     @{      @{$@{0     @{@     @{P     @{`     @{p     @{     @{@{fffff@{     @{     @{     @{     @{     @|      @|     @|      @|1@|Ffffff@|P     @|`     @|p     @|     @|     @|     @|     @|33333@|     @|     @}      @}     @}      @},@}A@}P     @}`     @}p     @}~fffff@}     @}     @}     @}     @}     @}     @}񙙙@~      @~     @~      @~,@~C33333@~P     @~`     @~p     @~     @~     @~     @~33333@~     @~     @~     @~     @      @     @0     @@     @P     @a@q@~fffff@fffff@     @     @     @     @33333@@      @     @     @     @      @%@0     @8     @@     @H     @P@X@`     @h     @o33333@w33333@     @     @     @     @     @33333@@     @@     @     @     @     @     @ @@     @     @      @(     @0     @8     @@     @H     @O33333@jfffff@p     @x     @     @     @     @@fffff@     @     @     @     @     @33333@fffff@     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @W33333@`     @h     @p     @x     @     @fffff@     @     @     @     @     @33333@fffff@     @     @     @     @     @      @33333@fffff@      @(     @0     @8     @@     @Ffffff@c33333@h     @p     @x     @     @     @@@     @     @     @     @fffff@     @     @     @@33333@     @     @      @     @     @     @      @(     @/33333@@     @H     @P     @X     @`     @h     @p     @x     @~fffff@33333@33333@     @     @     @     @     @33333@     @     @     @@陙@     @     @      @     @     @33333@!@(     @0     @8     @@     @H     @O33333@X     @`     @h     @p     @u@@     @     @     @     @33333@@@     @     @     @     @     @@@ @     @     @     @      @(     @.fffff@733333@@     @H     @P     @X@c33333@h     @p     @x     @     @     @     @     @fffff@@     @     @     @     @     @     @@@     @     @      @     @     @     @      @(     @0     @@@H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @ř@fffff@     @     @     @@      @@@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @@33333@     @     @      @(     @0     @8     @@     @H     @P@T     @h     @p     @x     @     @     @33333@     @     @     @     @     @     @     @@@񙙙@     @      @     @@     @ @'33333@0     @8     @@     @H     @P@`@h     @p     @x     @33333@33333@     @     @@     @@     @     @     @     @     @fffff@陙@     @     @      @     @     @fffff@ @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @@     @     @     @     @     @     @fffff@33333@     @      @     @     @fffff@(     @0     @8     @@@D@P@X     @`     @h     @p     @x     @33333@     @     @     @     @     @@@fffff@     @     @     @     @     @     @      @@     @      @(     @0     @8     @@     @P     @X     @`     @e@rfffff@x     @     @     @     @     @     @     @@     @     @fffff@     @     @     @     @     @     @      @@fffff@      @(     @0     @733333@C33333@H     @Rfffff@X     @`     @h     @p     @x     @@     @     @33333@33333@     @     @     @     @     @33333@񙙙@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @t@@     @     @@     @     @33333@     @     @     @     @fffff@@     @     @     @      @     @     @     @fffff@fffff@@     @      @$     @(     @,     @0     @4     @6@@     @D     @H     @L     @P     @T     @X     @Z     @e33333@h     @l     @p     @t     @x     @|     @fffff@@     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @˙@@     @     @     @     @     @癙@33333@     @     @     @     @@@     @     @     @     @     @     @      @"@(@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @S@X     @\     @`     @d     @f@l     @p     @t     @w33333@|@     @     @fffff@     @     @     @     @     @     @@@     @     @     @     @     @     @     @Ǚ@     @     @     @     @     @     @     @fffff@홙@     @33333@     @     @ fffff@@     @     @     @33333@     @     @      @$     @(     @,     @0     @2@8     @<     @@     @D     @G@M33333@P     @T     @X     @\     @_33333@dfffff@h     @l     @p     @t     @x     @|     @@@     @     @     @     @33333@33333@fffff@     @     @33333@fffff@     @     @fffff@     @י@     @     @     @     @fffff@fffff@fffff@     @      @     @fffff@     @33333@@     @     @      @$     @&@,@0     @5@8     @<     @@     @D     @H     @L     @N@U@X     @\     @`     @d     @h     @k33333@r     @t     @x     @|     @     @     @     @     @fffff@fffff@fffff@     @     @     @     @     @     @     @     @     @     @Ù@fffff@     @     @     @     @     @ߙ@33333@     @     @     @     @fffff@@@     @     @     @     @     @      @$     @&@-33333@0     @4     @8     @<     @@fffff@Bfffff@H     @L     @P     @T     @X     @\     @`     @c33333@j     @l     @p     @t     @x     @zfffff@     @     @     @     @@@     @     @     @fffff@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @fffff@@     @     @     @      @fffff@@     @     @     @     @     @      @#@)33333@,     @0     @4     @8     @<     @@     @D     @H     @Lfffff@O33333@T     @X     @\     @`     @dfffff@h     @l     @p     @t     @x     @|     @     @@     @     @     @     @     @33333@@     @     @     @33333@     @     @Ǚ@@     @     @     @     @fffff@     @@fffff@     @     @     @      @     @     @     @33333@     @      @$     @(fffff@*     @4@8     @<     @@     @E@H     @L     @P     @Rfffff@Y33333@\     @`     @d     @h     @l     @o33333@xfffff@|     @     @     @@     @     @33333@fffff@     @     @     @33333@     @     @fffff@     @     @fffff@     @     @     @     @     @     @ۙ@@     @@     @     @     @     @     @      @     @@
33333@     @     @     @     @      @$     @(     @*fffff@4     @8     @<     @@     @D     @I33333@L     @P     @T     @Xfffff@Zfffff@a33333@d     @h     @l     @p     @r@x     @zfffff@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @ř@     @     @     @     @     @     @噙@     @     @     @     @     @     @ fffff@     @@     @     @     @     @     @      @,fffff@0     @4fffff@7@;@@     @D     @H     @Q33333@T     @X     @\     @`     @d     @h     @q33333@t     @x     @|fffff@@     @     @     @     @     @@     @     @     @     @     @33333@fffff@     @     @     @     @     @@33333@     @     @     @     @     @     @@     @      @     @     @     @     @fffff@@      @$     @(     @,     @0     @333333@=@@     @D     @H     @L     @N@Y@\     @`     @d     @h     @l     @xfffff@|     @     @     @     @     @     @     @     @@     @     @     @@@     @     @     @     @@     @     @@     @     @@     @     @     @     @     @@     @      @     @fffff@
     @@     @     @@%@(     @,     @0     @4     @7@A33333@D     @H     @L     @P     @T     @X     @\     @e33333@h     @l     @p     @t     @xfffff@33333@     @     @     @     @     @     @     @@     @     @     @     @     @     @@fffff@     @     @33333@㙙@fffff@     @     @     @     @ fffff@     @     @     @     @     @@!33333@$     @(     @,     @0     @4     @8fffff@:fffff@A33333@D     @H     @L     @P     @T     @X     @[@e@h     @l     @p     @s33333@     @     @     @     @33333@fffff@     @     @fffff@33333@     @@     @     @     @     @     @     @˙@     @     @     @     @     @fffff@홙@     @     @     @33333@@     @     @     @33333@33333@     @     @$     @(     @,     @0     @4fffff@6fffff@=33333@@     @C@Hfffff@L     @P     @T     @X     @\     @^fffff@hfffff@l     @p     @t     @x     @|     @     @fffff@33333@     @     @     @     @     @     @@     @     @     @     @     @     @33333@ՙ@     @fffff@@陙@     @@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @/@8@<     @@     @D     @H     @K@U33333@W@\     @`     @d     @h     @l     @n@u@x     @|fffff@@     @     @     @     @     @     @     @     @33333@     @     @     @@@     @     @     @fffff@33333@     @     @     @     @     @     @fffff@     @     @      @33333@@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @C33333@H@L     @P     @S33333@Y@\     @`     @dfffff@ffffff@lfffff@p     @s@x     @|     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @     @33333@     @     @Ù@@     @     @     @     @ᙙ@     @     @     @     @󙙙@     @      @     @     @     @     @     @     @@$@(     @,     @0     @4     @7@<     @@     @Dfffff@F     @Lfffff@O@T@X     @\     @`     @c                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @ܑN;@ރ%@/w@6@qu!@v_ح@m\@VϪ@@N@=p
@˒:)@Ik~(@4m8@,q@*g	@&fffff@$%1@!Gz@ A7K@@>@ߤ@@_o@U@Ϫ͞@,<@S&@)^@@T@
qu"@
:@'/@˒:*@Q@      @zG@a@O@+@ݗ+@mhr!@|@*0@~$t@P*0U@8F@$%1@m\@B@[@dZ@N;@f'@>"@
L/@حV@ʦL/{@S@9~($@@Fs@D*@7@u!.@Vt@Q@-@1@r{m@SMj@8YJ@XbM@6E@"}Vm@A@C,z@Vϫ@n@E84@z)y@Zu%F@N;5X@@6@:>B@43@(TɅ@$%1@Q_@&@@$/@$/@E@4֡a@8}H@	@e@҈p@҈p;@W>6z@bM@sP@_p@jOv@n@/{J#@@@͸@n@>6z@R<6@Xy=@J@Xe@#x@Zc@cA \@@E@#n.3@Jn@u%F@GE84@ǮzH@Fs@fA@͞&@lD@ u!@Np:~@*0@[W>@o hی@wkP@oiDg8@U$/@tSM@)^	@$?@64@*0U2a@u%@	 @s@a|Q@g	l@TɅ@fA@:)y@w+@mV@lC@l"h	ԕ@dqj@b3@a.H@\N;@gfA@@#w@+@4m9@uY|@HeO@<Z@.zG@%@af@p:@@4n@iDg8@8}H@6@A@33333@Vϫ@rGE@tj@u@S&@a'R@JL/{@<PH@7+@"}Vm@!Gz@N;@!-w1@qu!@>BZ@qu!@5?|h@Nߤ?@Gy@@dZ@}Vl@1.@ڹ@&@`A7L@Gz@IQ@*0U@e+@Ʌoi@Ϫ͞@5Xy>@#@C@74@ [7@|hs@ߤ?@!.H@b@<64@PH@J#9@s@!.H@+I@
(@LcA \@T*1@p
(@|쿱[@y=b@s33333@hXy=@irGE@i*0U2a@ffffff@dqj@dtSM@iᰉ'@kQ@j~"@iDg8~@f@c9@a'R@_;dZ@^ ѷY@Xe+@W>6z@RT`d@P-
q@M@K:)z@I@Eo i@D?@As@=<64@5sg@2 ě@6C-@=Vl!@@6@BZc      @Em\@ES&@DJM@C$@@     @4D@*0
@S@*0U@N;5@|@#Z@%zxl"h@%+a@6@_p@?@O
M@U=@1&y@zxl"@VϪ@a@@JL@JL@6z@c	@a|Q@9XbN@ᰊ@iDg8@.2@P{@Ov`@ᰉ'@@@^@rGE@@e@ݲ-V@5?|@Gz@RT`e@Dg8~@a@@&x@{@U=@x@}H@Ϫ͞@̘_@s@o hی@@Fs@Ňݗ@@p
=@ěS@D@j~@1@}Vl@VϪ@Ov`@>B[@U=@iDg8@ᰊ@[W>6@Dg8~@PH@`A7@\(@H@@$tT@$tT@)^@4J@n@@Ʌoi@Ʌoi@:)y@qu"@]cA@xF]@@zH@\N@F]c@o h@g8}@o i@D@@;dZ@n@:)y@R@u@bM@;dZ@'/W@p:~@5Xy>@/{J#@eO@2W@TɅo@$tS@|Z@n@o i@Q@~vȴ9X@v}Vl@t!-w2@p'RT@m\@lC@kP{@j0U2a|@irGE@glC@c
=p@b3@bh	ԕ@_حV@\wkP@XU@Vt@TzG@SZ@QN;5@QN;5@P)^@O;dZ@N_o @MO;dZ@LL_@J#9@G@@FYJ@Do h@C%2@B ѷ@BZc@=p
=@G@@QN;6@Ca@N@4!-w2@0'RT@)x@,q@?.H@Bu%F
@B74@?$tS@<Z@5?@0
=q@-C\@0'RT@3@-B@#n.3@e+a@	Q@	^5?}@	k~(@?@hr@>B@ [7@@ ѷY@ߤ@@=K^@+j@L_@Z@_p@bM@As@
M;@\(@
M;@p:~      @K]c@?@S&@M:@a@N@Zc@@ ě@VϪ@,<@e@҈p;@l!-@&@|@@ɺ^5?}@)^@[W>6@@_o@S&@1&x@hr @4J@'/W@I^5?@ ѷ@	 @'RTa@ ѷ@JM@w1@p:~ @irGE@bM@TɅoi@Dg8}@6C-@4J@0
(@*d7@'RT`e@%1@Ov_خ@O
M@I^5?@ݗ+@@4n@"`@j~@s@A [@A@Gz@?@>6z@fA@n@j~#@)@4K@sg@Xy=@4K@9XbN@1@kP|@_F@҉@(@O;dZ@C%@:S@xF@kQ@[$@QN;5@F-@Dg8}@B@>BZc @64K@/{J#:@(@}H@	 ѷ@JM@@4n@:S@
!.H@
-
@
E@
:~ @
8}H@
ޞ@
Q_@
l!-@
Ϫ͞@
Ƨ@
]cf@
a@N@
\(@
s@
@
H˒:@
XbM@
rG@
?|h@
H@
I^@
$xG@
/V@
U=@
O
M@
Mj@
҈@
L/{@
I^5@
r ě@
nt@
l"h	ԕ@
eO
@
^ ѷY@
Z1'@
Xy=c@
Q@
K]cA@
E84֡@
@n@
>BZc @
<n.@
0 ě@
'-@
#S&@
!-w1@
%@
wkP@
hr @
I^5?@
	ԕ*@
=p
@
F]c@($x@j~@C\@fB@hr!@@ce@l!-@E@As@ȴ9Xb@g8}@n@j~#@?@'RT@L/{J@u%@ݗ+k@$/@~"@zG{@u%F
L@m(@ix@glC@dZ1@`d8@XbM@RT`d@M5Xy>@GzH@A [7@=v@=b@;dZ@,<쿱@!-w1@_o@e+a@+j@+j@+J@'/W@Q@G{@"h	ԕ@lC@eO@@4@@N@҈p;@ۋq@bM@&@#9@*0@@v@)@sg@-V@r@zxl"@@'RT`@1&@0
)@Xe,@҉@!R<@'RTa@S&@     @{m]@y(@u!.@p@ix@fA@W
=p@R<64@OAs@JW'@Fs@A [7@84֡b@8YJ@8)@84֡b@9D@:^5?|@9Y}@9D@9~($@8Q@64K@4J@2m\@3g	l@1[W>6@/O
M@,q@'RT`e@$xF@!.H@!o@ ěT@wkP@zG@L_@+I@tj@@ 4m9@
	k~@
g@
C]@
ڹ@
>@
څݘ@
حU@

=p@
҈p:@
Ϫ͞@

M;@
s@
s@
a@N@
)@
 ě@
a@@
^@
@
wkP@
ᰉ@
zG@
\(@
oiDg@
F]c@
:S@
     @
{~$@
v!.I@
v_ح@
u\(@
u\(@
u%F
L@
rGE85@
n.2@
k~($@
hr Ĝ@
e@
dZ1@
aGz@
ZY@
YJE@
W&@
SMj@
Dg8}@
@NU@
>ߤ?@
>BZc @
=v@
<64@
8Q@
5?@
0{@
,<쿱@
䎊r@
PH@

M:@
oiDg@
 ѷX@	Q@	PH@	c	@	JE@	`d@	&@	R@	@	#9@	Y}@	֡a@	 ě@	Xy=@	-V@	,<@	$/@	@	I^5?@	qiC@	@	v!.I@	kC,z@	cS@	`҈p@	\?@	Zc	@	Xe+@	UfA@	Q_p@	M@	GzH@	GzH@	Eo i@	A [7@	;5Xy@	333333@	0U2a|@	+I^@	&L/{J@	U=@	쿱[W@	u@	IQ@	S@	@	N;6@	ߤ?@		7KƧ@	ݗ@ڹZ@@+@ ě@빌~($@@e@S@Ft@ٳ|@䎊@@˒:)z@ȴ9Xb@\(@Õ$@vȴ9X@}H@?|h@ߤ@33333@-@r@<쿱@,@IQ@ᰉ@@Vu@ ѷ@YJ@S&@{J#9@:S@~\N<@{J#9@u!.@g8}H@b}Vm@`A7K@^iB@^5?|@\N;@\?@]ce@["`B@H9Xb@=<64@8YJ@.1@*d7@(Xy=@"3@,<@PH@tj@O;d@@o @L_@@
ڹY@@\N<@F]d@!-w2@PH@ ě@l@C\@Q@@eO@ޞ@ܑN;@"`B@څݘ@ٳ|@e+@>6z@Ϫ͟@֡af@Ϫ͞@ԕ*1@ӎMj@а{@Ϫ͞@͞%@]cA@K]c@ěS@[W>@Z@)y@)@Y}@C-@ߤ@ ě@B@͞&@x@L/{J@?@䎊r@%@u"@Q@O;d@n@4J@rGE9@Mj@O;dZ@L/{@=p
@k~(@eO@F]c@{m]@yrGE8@weں@tSMj@oiDg8@l!-w@jg	@iᰉ'@ix@glC@aGz@^iB@Xe+@S&@QR@OAs@LcA \@H˒:*@Fs@<Z@8)@7rG@74m@7KƧ@74m@7Xe@6C-@6z@2ᰊ@-w1@'/V@$/@"wkQ@!R<6@ ěT@䎊r@IQ@PH@_F@_F@*0U2@u@o @
(@I^5?@xF]@
ڹY@	 ѷ@u%F@%2@I^5@n.@$/@      @!.H@=b@ȴ9X@{m@
=q@O;@"h	ԕ@C,z@x@,<@@唯O
@S@]ce@Ϫ͟@ѷX@n@y@š@*0@*0@ěS@a@N@C@64@Q@Xy=@[W>6@Vϫ@r@'RT@>B[@y@$xG@@h	ԕ@%@[@C,zx@S@=K^@sh@Z@*0@O
M@*0U2@hr @o @ߤ?@'/@p:@@|Q@v!.I@p:~ @mC\@l!-w@eO
@ae@`d8@_;dZ@^ ѷY@[$@[6@XD*@Q@P|@Ov_ح@Ov_ح@K:)z@HK]c@B@@C@A7Kƨ@@n@>6z@;A@333333@+jf@ 'RT`@,=@C,zx@kP|@R<6@O
M@u@-
q@rGE9@
O;dZ@K]d@S&@o h@%2@n/@\N<@#@s@
=q@(@B@ۋq
@lC@ڹ@fffff@ޞ@>BZ@Ϫ͞@т@*0U@_o @ɅoiD@y@84֡@7Kƨ@ߤ?@b@p
=@<64@5Xy@}H@C-@'0@?|h@'RT@}Vl@2X@2X@<쿱@TɆ@3@R<6@3@n.3@h	ԕ@u@u"@}H@ߤ@@@@0
)@O;d@zG@hr @ԕ*@IQ@l"h	ԕ@eڹ@dZ1@be+@`d8@SZ@N;5X@I^5?}@GE84@F
L/@Ca@N@A [7@>6z@=v@8YJ@0
(@-B@+a@@'/V@#S&@u"@@Fs@n@qi@
ڹY@	 ѷ@Fs@n.@!.H@lC@s@?@rGE8@SMj@:~ @!-w@Ov`@`A7L@Z1@%1@
qu@ce@Q_@حU@֡af@`d@|@;dZ@Ϫ͞@Ϫ͞@@/{J#@D@
L/@n@dZ@a|Q@'RT@
qv@jf@͞&@d7@^@&@1@vȴ9@u"@C,zx@u"@S@Xe,@L_@*0U2@n@bM@bM@@ߤ?@@L/{@Fs@M:@$/@|?@yrGE8@w1@u\(@t#@sMjO@q@nc	@p:~ @gfA@cS@aGz@`A7K@_حV@_Ft@_?@^@^5?|@]ce@Vaf@Ks@B74@A@E8YK@?@:)_@6z@,1&y@(TɅ@%F
L0@$?@#n.3@#9@#9@$xF@#n.3@!o@vȴ9@!-w1@_o@+j@ݗ+k@@
=p
@K]d@%2@@ ѷX@H˒@rGE8@SMj@@VϪ@ۋq
@,<@ᰉ'R@/w@ٳ|@
=p@ѷX@
M;@
M;@;5X@@W'@ɺ^5?}@ɺ^5?}@K]c@y@y@o i@Zc@@K]@)y@#w@3@'0@m\@ᰊ@o@{J#:@d7@h	ԕ@Q@Ov_خ@!-w1@!-w1@U=@,=@wkP@Q@wkP@qu!@e+a@_F@sh@Z@ݗ+k@҉@(@u%F@u%F
@     @x-
@tSMj@sPH@rs@o-V@n.2@l!-w@j~"@irGE@h@hr Ĝ@f1.@`
qu@^iB@^ ѷY@Zc	@Xy=c@VϪ͟@U=K@TɅoi@T`d@S@PH@M5Xy>@L_@Np:~@Jn@E8YK@D*0@D*0@C,zxl@@n@=p
=@<j~#@<64@:)y@8}H@64K@4֡a@49XbN@4m8@3g	l@1-@.1@-B@-V@+U=@(\)@($xG@&'@$?@ 	k@䎊r@vȴ9@!-w1@IQ@u"@wkP@S@u%F@$tS@Ov_@Z@n@Vu@҈@	'RTa@+I@o h@{J#9@{J#9@u%F
@m\@s@kP@g@PH@䎊q@ ě@8Y@+a@ᰉ'R@҈p@;dZ@ܑN;@c	@څݘ@E@|@jOv@:@@5Xy>@˒:)z@?@C@vȴ9X@j~#@D@4m@E@sg@|@m\@W@[W>6@}Vl@TɅ@x@zxl"h@u@TɆ@
=p@`A@o@3@IQ@vȴ@ᰉ@n@)^@@hr @Mj@L_@u%F@ݗ@tj@@˒:)@{lC@y=b@x-
@v!.I@t#@q@mhr!@n.2@l!-w@iB@cA [@_حV@]cA @\]ce@Z1'@Sa@O@Rm@Q@PH@LcA \@E84֡@Dg8}@B74@B@B&IR@A7Kƨ@A@@C@?@;dZ@84֡b@64K@5sg@43@3g	l@/{J#:@+6z@+I^@)@(\)@&L/{J@%u@$/@$/@$tSM@#
=p@#9@!.H@wkP@,<@+j@O
M@҉@:)y@	'RTa@M:@u%F
@:S@$/@ ѷX@      @I^5@($x@F@!.I@\(@#@iB@@O;@쿱[W?@ᰉ'@ڹ@ᰉ'R@ޞ@5?|@ce@e+@>6z@2a|@T`d@Ϫ͞@а{@ɅoiD@2W@Zc@TɅo@j~#@4K@ߤ@ᰊ@{@U2a|@r@O
M@zxl"@͞&@@,@1@9@R<6@!-w1@1&@,<@PH@Xe,@R<6@@\(@	 @#@tj@IQ@|?@zxl"h
@z@y	k~@u\(@p:~ @kC,z@iᰉ'@h	ԕ+@cA [@bM@cS@a'R@^ ѷY@ZY@VϪ͟@T`d@Rm@Q@P|@N;5X@LcA \@K]cA@Jn@I@H@Fs@A [7@>6z@<64@9#w@74m@6E@4֡a@4J@333333@12W@0 ě@-U=@+U=@&L/{J@!o@ -
@u%F@+J@@N@
O;dZ@u%F@+I@n/@o h@      @ s@ rGE8@ 73@ iB@ 
=q@ C\@ !-w@ P{@ >BZc@ 1.@ |Q@ حV@ ݗ+j@ Q_@ D*@ Ϫ͟@ *0U@ p:~@ p:~@ 
M;@ v_ح@ Ϫ͞@ 
M;@ @ /{J#@ @ \N@ Zc@ H˒:@ @ ߤ?@ vȴ9X@ K]@ A@ ~@ ^5?|@ ~($@ ?|h@ g	l@ Vϫ@ B@ q@ ͞&@ TɅ@ '@ xF@ ae@ ,=@ u%F@ Xe,@ Ov_@ $/@ L_@ nO@ \(@ C%@ ݗ+@ @ ݗ@ o h@ tj@ tj@ ?@ o h@ M:@ %2@ {J#9@ ?@ u%F
@ IQ@ .H@ }E@ }Vl!@ |hr@ {s@ zG{@ v!.I@ r䎊q@ p
=q@ o-V@ nO;@ n.2@ kC,z@ ix@ h>BZc@ e+a@ a|Q@ \?@ ZQ_@ Y|@ Yb}@ Y>BZ@ Xy=c@ W&@ VϪ͟@ V8YJ@ U=K@ Rp:@ O;dZ@ OAs@ NT@ NT@ Jn@ H@ F]cf@ F?@ G)^@ F-@ DS@ C$@ B@ ?@ =K]@ <n.      @ 9~($@ 6E@ 5'0@ 4֡a@ 2ᰊ@ 1o@ 0
(@ 0 ě@ 0U2a|@ .}Vl@ -V@ *0
@ +jf@ '-@ &'@ %S@ %u@ $?@ $xF@ #n.3@ #S&@ "3@  	k@  [6@ ,=@ Q@ ,<@ _o@ @ $/@ ݗ+k@ bM@ @ eO@ _o@ 	7KƧ@ K]d@ +I@ oiDg@ tj@ F]c@  IQ?PH?+?+jg?VϪ?x?fA?䎊qj?Gz?iB?Q_?ԕ*1?W'?)^?74??&IR?&IR?TɅo?[W>?v?^5?|?sg???-V?'RT?O
M?}Vl??ߤ@?O
M?S&?-
q?qi?O;dZ?L_?eO?M:?b}V?}Vl!?{J#9?y(?y=b?y=b?u%F
L?o?j~"?g8}H?fA?e+a?c	?a@N?^?[6?XbM?VϪ͟?TɅoi?S?S&?N;5X?L/{J#?GzH?Fs?B?A [7?>6z?:~?6C-?2W?/Vϫ?-V?,zxl"?/{J#:?-w1?+I^?&IQ?#9?Q?vȴ??Ov_??'/W?
M:?
=p
?1&x??$/? hۋq?#x?C\?C\?	k~?-
?eں?Fs?oiDg8?c	?g	??`A7L?e?C,?ݗ+j?
=p?E?+?W'?ȴ9Xb?Ƨ-?8YK??                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @@Q@@QR<6@@QX@@Q2W@@Q|@@R䎊@@Rxl"h
@@Rg	@@R>B@@RwkQ@@Rᰊ@@R>B@@RwkQ@@R\(@@R\(@@R\(@@RL_@@RS&@@R0
@@R0
@@R0
@@RwkQ@@RwkQ@@RS&@@RS&@@RL/{@@Rvȴ@@RwkQ@@R0
@@Rvȴ@@RwkQ@@R0
@@RwkQ@@RL/{@@R>B@@Rg	@@R)_@@R ѷ@@Stj~@@Uhr!@@Vvȴ9X@@V]cf@@V}Vl@@V]cf@@WU=@@WlC@@W@@W@@X
qu@@X73@@Xtj@@X@@@YQ@@Yo hی@@YR<6@@Y(@@Z@@Zn@@[~$@@[@@[*0U2@@[$@@\64@@\?@@\7@@]+a@@]*0@@]w1@@]
qv@@^҈p;@@_ݗ+@@_$tS@@_&@@_v_ح@@_@@_Vϫ@@`A7K@@`$xG@@`Xy=@@`n@@`-
@@`u%F@@`
=q@@`u%F@@`@@`
(@@`@@@``A7@@`\)@@a$/@@a@@a&x@@aGz@@a[W>6@@aoiD@@an.@@aX@@ay@@a-@@b0U2a|@@bwkQ@@b<64@@cߤ@@cQ@@d#@@f@@g@@gXe,@@g#@@i ѷ@@iy@@k@@m8YK@@p ě@@p@@@rOv`@@sa@N@@v@@xۋq
@@}oiDg@@lD@@@@Q@@`A@@eO@@@@)^@@~($@@U=@@oiDg8@@&@@qu!@@($x@@u!@@xl"h
@@u%@@1.@@2W@@>BZ@@Y|@@;dZ@@	ԕ+@@Ȗ@@rGE8@@@@ʏ\(@@u%F
@@m\@@=K^@@/{J#@@̈́M:@@!R<@@Ov_@@+jg@@As@@0
)@@ѣn.@@ӹ~($@@Թ#x@@֤T@@ذ{@@u!S@@o@@ڒS&@@n.3@@Ƨ@@J@@cA \@@ܕ*1@@ܲ@@?|h@@ݿH˒@@C\@@+jg@@vȴ9X@@l!-@@s@@;dZ@@RT`e@@ߠ	k@@ ě@@NU@@*0@@6@@*0U@@C@@u%F@@^5?|@@P{@@eO@@㋬q@@U=@@`d@@jOv@@=K@@凓ݗ@@1@@凓ݗ@@$/@@凓ݗ@@Xy=@@t@@l!-@@Vu@@ hۋ@@sPH@@v_ح@@4m@@	k@@@@	ԕ+@@U2a|@@bM@@NU@@K]c@@eO@@蠐-
@@
=q@@
=q@@9Xb@@9Xb@@p:@@{@@Ov`@@1&y      @@O
M@@Vl!@@U=@@n/@@(@@@@p:~@@Q@@m\@@]cf@@;dZ@@lC@@ݗ+@@[W>@@حV@@}H@@K]c@@y=c@@-
@@@@@@@@-
@@
=q@@
(@@	k@@ae@@@@X@@"`@@@@#9@@C\@@kP|@@~"@@\(      @@@@W@@c	@@	@@@N@@n.3@@~($@@a@O@@6@@Q@@@@VϪ@@~($x@@zxl"@@Z@@hr@@!-w@@E@@?|h@@O;dZ@@Vl!@@p
=@@ڹZ@@1@@oiDg@@ ѷY@@($x@@R<6@@}Vl@@ȴ9X@@@@4֡a@@	@@-V@@&@@/V@@/V@@vȴ9@@/V@@vȴ9@@	ԕ+@@l"h	@@-
@@ѷX@@@@ [7@@7KƧ@@rGE8@@u@@X@@y@@@@D@@X@@n.@@^5?}@@s@@@@s@@M@@M@@ݘ@@kP|@@a|Q@@qiC@@Zc@@T`d@@Q_@@@4@@ ě@@n@@m\@@nP@@"`B@@'/@@6z@@Mj@@@@!-w2@@Fs@@tSM@@?@@zxl"@@#x@@hr@@[@@?|h@@Vl!@@zxl"h@@8Y@@E@@8YJ@@\N<@@p:~@@6z@@'@@A@@C-@@;dZ@@RT`e@@sPH@@-V@@@@˒:)@@vȴ9@A F]d@A A7K@A l"h	@A )@A @A$/@ADg8~@Ao@Ay@A@An@A#9@Aa|Q@Aᰊ@AL_@A{m@AY@Ac	@AD@A'/@A33333@AP{@Aqu!@A~$@A~($@A|@Ag@A%1@ASMj@Aq@AS@A1&@A?@A֡a@AZ@AJM@Au@A2a|@Am\@AڹZ@Ash@AϪ͞@A8YK@A,=@A4K@A.2@AOv_خ@Aqi@AA@AAs@A@A@A!-w1@Ao@A[W>@AD*@AYJ@A)@ATɅ@ATɅ@Ae+@AC@AC@A	=b@A	u!S@A	@A	u@A	~($@A	R<6@A	^5?}@A	_o@A	lD@A	e@A	>BZ@A	.H@A
{m@A
 ě@A
 ѷ@A
D@APH@A=K^@AW>6z@A{J#9@A{J#9@A:)z@Aߤ@Aq@AQ@Ag      @AC,zx@AtSM@A?@A#@AN;@A쿱[@A/@A
u@A
O;dZ@A
fA@A
p
=@A
+j@A
n/@A
Ϫ͞@A

qv@A
(@A
!.@A ѷY@A8YJ@Ac	@Avȴ9X@A%@A2X@A"@A)^@AXe@A@AXe@A@AXe@A$tS@AH˒:@AiDg8@Av_ح@A$tS@A	k@A@@ArGE9@A     @A ě@AA7K@Ar Ĝ@An@AIQ@Aۋq
@A	k~@A0
)@A=b@A^@A7Kƨ@A(@AD@A>BZ@A-@An@A#9@A6C@AJL@A@4@A,<@Am\@A	@A)^	@A,zxl@A)^	@A6z@An.3@AMj@A:)z@A*0U2@A@A@AZ@AC]@A(\@AtSM@A7@A@A?|h@AL_@AVl!@A}H@A1@A\(@A1@A!.@A8YJ@AR<6@AYJ@Ac	@A+J@A6z@Aߤ?@AA@Ax@A
M;@A!-w1@A4֡a@A4֡a@Av_ح@AO;d@AzH@A/V@A/V@Avȴ9@AK]d@A+j@A*0U@A4m9@AU2a|@Ahۋq@Ay=c@Ar Ĝ@A4m@A҈p@A\)@A	k@A$tT@A#w@Ao hی@Ax@A@AB@A2W@Aԕ*@A"`@AY}@A6C@A@4n@AM@AW'@Aa|Q@Aᰊ@A@A`A@AڹY@A ѷ@AڹY@A҉@A&@A)^	@AF]c@A]cA@Atj~@AA@Aq@Aq@AZ@A|@AA [@An.@AJ@A!-w2@A9XbN@AFs@AZ1@Aq@AN;@Azxl"@A>B[@A:@A!.H@AY|@AfA@Azxl"h@A+j@AH˒@AcA @AϪ͞@A8YK@A(@A4K@A.2@AE@A_ح@As@As@Ap:~@A@AϪ͟@A hۋ@AFt@A
=p@A)^@A)^@Av@A;dZ@A_o@A	@Avȴ9@A+@A;dZ@A;dZ@A@@ArG@A      @A *0U@A *0@A NU@A [6@A Xy=@A YJ@A tj@A 
=q@A U@A 4m@A 
(@A F@A PH@A! ѷ@A!	k~@A!@N@A!&x@A!7KƧ@A!A [@A!XbM@A!k~(@A!|Q@A!oiD@A!u@A!|@A!y@A!y@A"I^5@A"䎊@A"0U2a|@A"GE85@A"JL@A"qiC@A"ݘ@A"ݘ@A"@4@A"~"@A"@4@A"@4@A"@4@A"~"@A"ݘ@A"p:@A"S&@A"wkQ@A"vȴ@A"vȴ@A">B@A">B@A"}Vm@A")_@A"ڹY@A"䎊q@A"䎊q@A"fB@A#I^@A#&@A#F]c@A#MjO@A#a@N@A#a@N@A#a@N@A#Q@A#ߤ@A#6@A#Q@A#@A#s@A#s@A$%1@A$%1@A$,<@A$(\@A$64@A$C,zx@A$Fs@A$_@A$3@A$1&@A$zxl"@A$#x@A$/@A$JM@A$hr@A%o i@A%(@A%5Xy>@A%<64@A%?|h@A%S&@A%\@A%\@A%ce@A%`A7L@A%jOv@A%w1@A%$/@A%O
@A%%@A%Xy=@A%1@A%@A%cA @A%@A%8YK@A%oiDg@A&($x@A&1.@A&.2@A&1.@A&;5X@A&BZc @A&H@A&Ov_خ@A&iB@A&s@A&Q@A&҈p;@A'@A')^@A'!-w1@A''/W@A'As@A';dZ@A'?@A'͞@A'͞@A'zH@A'r@A'vȴ9@A(F]d@A(
qu@A( ě@A(73@A(oiDg8@A(u!@A(YJ@A(
=q@A(-
@A(TɅ@A(`A7@A)+@A)4J@A)Dg8~@A)Gz@A)XbM@A)hr @A)k~(@A)b}@A)o@A)u@A)B@A)|@A)y@A)_o@A)>BZ@A)-@A*e+@A*䎊@A*0U2a|@A*@4n@A*:)y@A*@4n@A*JL@A*M@A*h	ԕ@A*u%F
@A*{m@A*L_@A* ě@A*͞&@A*ڹY@A* ѷ@A*m@A*~@A+I^@A+'/@A+PH@A+&@A+=K^@A+W>6z@A+dZ@A+qu!@A+{J#9@A+Mj@A+:)z@A+S@A+E@A+Ƨ@A+Ƨ@A+5Xy@A+a@@A+Q@A+҈@A,J@A,%1@A,?@A,PH@A,SMj@A,g8}@A,j~#@A,wkP@A,zG@A,?@A,qj@A,_@A,TɆ@A,u"@A,D@A,e@A,e@A,e@A-o i@A-o i@A-o i@A-[@A-\@A-zxl"h@A-%@A-sh@A-H˒@A-@A-
qv@A-ڹ@A-C\@A-oiDg@A.t@A.
(@A.Ov_@A.$/@A.($x@A.;5X@A.Ov_خ@A.\N<@A.vȴ9X@A.}Vl@A.IQ@A.qi@A.@A.@A.af@A.ߤ?@A.m\@A.+@A.Ϫ͟@A.]cf@A.C-@A.ߤ?@A.ߤ?@A.쿱[W@A.Mj@A.Mj@A.Fs@A.Fs@A."@A/@A/@A/v@A/'/W@A/1@A/E84@A/U=@A/U=@A/b}V@A/b}V@A/sPH@A/v_ح@A/&@A/&@A/O;d@A/	@A/	k@A/&@A/3@A/o @A/K]d@A/+@A/+@A/@A/Vϫ@A/䎊r@A/䎊r@A0	ԕ+@A0bM@A0*0U@A0*0U@A0@A0 ě@A0-
q@A0K]c@A0NU@A0U2a|@A0_F@A0oiDg8@A0y=c@A0˒:*@A0n@A0YJ@A0@A0d8@A04m@A0p:@A0҈p@A0ۋq
@A0@A0\)@A1 ѷ@A1@N@A17KƧ@A1A [@A1=b@A1=b@A1=b@A1=b@A1JE@A1Gz@A1JE@A1[W>6@A1k~(@A1|Q@A1~($@A1@A1'RTa@A1'RTa@A1n.@A1|@A1@A1^5?}@A1X@A1"`@A1iB@A1e@A1@A1s@A1Y}@A1Y}@A1-@A1-@A2e+@A2䎊@A21'@A21'@A2&IR@A20U2a|@A2=p
@A26C@A2Zc@A2^5?|@A2a|Q@A2h	ԕ@A2h	ԕ@A2nO@A2u%F
@A2u%F
@A2xl"h
@A2ݘ@A2vȴ@A2Y@A2`A@A2C,@A2m@A274@A274@A2m@A2D@A2m\@A3҉@A3C,z@A3&@A3/V@A3@N@A3@N@A3=K^@A3F]c@A3W>6z@A3a@N@A3g	l@A3g	l@A3qu!@A3~$@A3q@A3Mj@A3:)z@A3:)z@A3wk@A3U=@A3wk@A3wk@A3q@A3@A3E@A3~($@A3@A3|@A3
=p@A3\N@A4ߤ@@A4"h	ԕ@A4"h	ԕ@A4"h	ԕ@A4C,zx@A4M:@A4M:@A4M:@A4SMj@A4]ce@A4]ce@A4wkP@A4#@A4C@A4C@A4#@A4쿱[@A41&@A4#x@A4#x@A4j~@A4j~@A4?@A4@A4@A5:@A5!.H@A5+a@A55Xy>@A584֡@A5B@A5L_@A5Vl!@A5Vl!@A5Y|@A5fA@A5zxl"h@A5M:@A5$/@A5}H@A5!R@A5Xy=@A5n/@A5H˒@A5\(@A5@A5b@A5b@A5,=@A5,=@A5,=@A5C\@A6
L/@A6zG@A6$/@A6.2@A61.@A6BZc @A6H@A6L/{J@A6_ح@A6l!-@A6l!-@A6l!-@A6fffff@A6p:~@A6vȴ9X@A6%@A6qi@A6@A6@A6,<@A6@A6,<@A6-@A6&I@A6ȴ9X@A6m\@A6t@A6m\@A6A@A6]cf@A6x@A6ߤ?@A6쿱[W@A6쿱[W@A6Fs@A6Fs@A7@A7
M;@A7'/W@A7>6z@A7O;d@A7O;d@A7@A7$tS@A7-V@A7@A7fA@A7rG@A7rG@A7Vϫ@A7rGE9@A8@A8bM@A8*0U@A8-
q@A8D*@A8D*@A8NU@A8[6@A8l"h	@A8|@A8'RT@A8@A8tj@A89Xb@A84m@A84m@A8ěT@A8F@A8D@A8ۋq
@A8ۋq
@A8e+@A8`A7@A8\)@A9 ѷ@A9rGE@A9@A9*0U2a@A9&x@A9-w1@A9:S@A9Dg8~@A9JE@A9Q@A9XbM@A9ae@A9o hی@A9o hی@A9k~(@A9o hی@A9x@A9@A9@A9@A9n.@A9D@A9N;6@A9"`@A9e@A9R@A9@A9@A9s@A9Y}@A:@A:Ov`@A:e+@A:e+@A:e+@A:#9@A:3@A::)y@A:@4n@A:C\@A:GE85@A:T`d@A:T`d@A:W'@A:W'@A:a|Q@A:h	ԕ@A:u%F
@A:u%F
@A:\(@A:S&@A:wkQ@A:S&@A:S&@A:>B@A:g	@A:Y@A:@A:ڹY@A:䎊q@A:fB@A:C,@A:䎊q@A:fB@A:C,@A:C,@A:C,@A:m@A;nP@A;9@A;J#9@A;J#9@A;P{@A;Z@A;a@N@A;n.3@A;q@A;Mj@A;S@A;*0U2@A;m]@A;S@A;wk@A;@A;@A;~($@A;E@A;m]@A;@A;a@@A;%2@A;@A;@A<n.@A<@A<ߤ@@A<(\@A<,<@A<?@A<I^5?@A<Z1@A<j~#@A<j~#@A<m8@A<#@A<_@A<S@A<zxl"@A<O
M@A<?@A<#x@A<[W?@A<?@A<@A<*0@A<Z@A<֡a@A<Z@A<֡a@A<u"@A<Z@A<JM@A<>@A=K]@A='0@A=V@A=u@A=u@A=[@A=!.H@A=+a@A=B@A=S&@A=Vl!@A=S&@A=S&@A=Vl!@A=`A7L@A=`A7L@A=m\@A=fA@A=`A7L@A=p
=@A=sg@A=zxl"h@A=ݗ@A=M:@A=M:@A=hr!@A=@A=1@A=H˒@A=8YK@A=S@A=ᰉ@A=ᰉ@A=!.@A=ڹ@A> ѷY@A>
L/@A>
(@A>
(@A>
L/@A>
L/@A>@A>.2@A>1.@A>8YJ@A>H@A>L/{J@A>R<6@A>R<6@A>Ov_خ@A>YJ@A>_ح@A>iB@A>l!-@A>iB@A>s@A>}Vl@A>+J@A>%@A>qi@A>@A>,<@A>@A>af@A>}Vl@A>'@A>Q@A>ߤ?@A>&I@A>ߤ?@A>ߤ?@A>ȴ9X@A>A@A>+@A>+@A>Ϫ͟@A>ߤ?@A>x@A>x@A>@A? hۋ@A?
=p@A?Ft@A?
=p@A?
M;@A?@A?@A?
M;@A?)^@A?v@A?+I@A?+I@A?1@A?;dZ@A?E84@A?KƧ@A?RT`e@A?\(@A?eں@A?b}V@A?iDg8@A?o@A?y@A?&@A?ݗ+@A?kP@A?$tS@A?$tS@A?&@A?3@A?@A?fA@A?@A?rG@A?@A?Vϫ@A?rG@A@	ԕ+@A@*0U@A@@A@@A@*0U@A@}H@A@*0@A@:~ @A@H@A@K]c@A@K]c@A@hۋq@A@hۋq@A@oiDg8@A@hۋq@A@r Ĝ@A@l"h	@A@oiDg8@A@oiDg8@A@n@A@@A@@A@-
@A@-
@A@
=q@A@@A@d8@A@@A@4m@A@@@A@)^@A@D@A@e+@A@`A7@A@҈p@A@4֡b@A@$tT@AA ѷ@AA$/@AA	k~@AA	k~@AA@AA#w@AA0
)@AA:S@AA:S@AA=b@AAGz@AAQ@AAQ@AAJE@AAk~(@AAhr @AAoiD@AAo@AAo@AA@AA@AAl@AAl@AAB@AA'R@AA_o@AAiB@AAiB@AAᰉ'@AAe@AAR@AA@AAR@AAs@AA-@AAlD@AB@ABOv`@ABe+@ABOv`@ABe+@AB)y@AB3@AB0U2a|@AB3@AB6C@AB@4n@ABM@ABT`d@ABQ_@ABT`d@ABW'@ABQ_@AB^5?|@ABnO@ABu%F
@AB~"@ABp:@ABL_@ABp:@ABg	@AB}Vm@AB<64@ABn@ABn@ABn@ABn@AB͞&@AB ѷ@ABc	@ABm@ABm@ABc	@ABm@AB74@ACu%@ACnP@AC	@AC&@AC33333@AC9@AC/V@ACZ@ACW>6z@ACW>6z@ACa@N@ACa@N@ACg	l@AC:)z@ACQ@AC$@ACߤ@ACU=@AC*0U2@AC6@ACa@O@AC6@ACa@O@ACa@O@AC@AC|@AC
=p@ACQ@AClC@ACA [@AC@ACs@AC\N@ADxF@AD@ADQ@AD!-w2@AD%1@AD"h	ԕ@AD,<@AD9XbN@ADI^5?@ADSMj@ADVϪ@ADg8}@ADwkP@AD~($x@AD~($x@ADo h@AD#@AD1&@AD?@AD?@AD[W?@AD7@AD@AD@ADZ@AD>B[@ADu"@AD>@AE:@AEo i@AEo i@AEo i@AEK]@AEV@AEV@AEqu"@AEQ@AEQ@AE/w@AE<64@AE84֡@AEY|@AE\@AE\@AEY|@AE\@AEY|@AEce@AEm\@AEsg@AE}H@AEݗ@AEO
@AE=K@AE=K@AEcA @AEcA @AEb@AE,=@AEE@AE!.@AEC\@AE!.@AFu@AF!R<@AFOv_@AF!R<@AF?@AF8YJ@AFBZc @AFE@AFH@AFOv_خ@AFYJ@AFiB@AFs@AFIQ@AF@AF@AFqi@AFT@AF-@AFT@AF-@AF-@AFT@AF6z@AF}Vl@AF'@AFm\@AFt@AFϪ͟@AFߤ?@AFߤ?@AF]cf@AF]cf@AFMj@AFFs@AF@AF@AFx@AG hۋ@AG
=p@AG@AGXe@AG)^@AG$tS@AG+I@AG1@AG1@AG>6z@AGAs@AGRT`e@AG\(@AGb}V@AG_o@AG_o@AGlC@AGv_ح@AG4m@AGkP@AGݗ+@AGkP@AG-V@AG$tS@AG$tS@AG&@AG?@AG	k@AG	k@AGkP@AG-V@AG͞@AGzH@AG3@AGzH@AG3@AGr@AG/V@AGK]d@AGfA@AG@@AG@AGrG@AG@@AGrG@AG-@AG-@AGrGE9@AH	ԕ+@AH6@AH$xG@AH'RT`@AH'RT`@AH$xG@AH-
q@AH4m9@AH:~ @AH:~ @AH4m9@AH>BZc@AHD*@AHD*@AHK]c@AHU2a|@AHU2a|@AHeO@AHhۋq@AHl"h	@AHeO@AHl"h	@AHr Ĝ@AH|@AHy=c@AH˒:*@AH-
@AH-
@AH      @AH-
@AH@AH@AH@AH{@AH4m@AH4m@AH4m@AH{@AH
(@AH
(@AHTɅ@AHěT@AHp:@AHD@AHD@AH҈p@AH`A7@AH`A7@AH`A7@AH҈p@AH{@AH{@AH\)@AHPH@AHPH@AH$tT@AHPH@AI	k~@AIrGE@AI_p@AI#w@AI4J@AI7KƧ@AI7KƧ@AIDg8~@AI=b@AI=b@AI=b@AIGz@AIGz@AITɅo@AI[W>6@AI[W>6@AIae@AIrGE8@AIu!S@AI@AI~($@AIo@AIo@AI@AIn.@AIB@AI'R@AI'R@AIB@AI@AI^5?}@AI@AID@AIy@AIy@AIԕ*@AIy@AI"`@AI"`@AIԕ*@AIԕ*@AIᰉ'@AIY}@AJu%F@AJu%F@AJn@AJu%F@AJn@AJ	 @AJs@AJe+@AJ1'@AJ#9@AJ)y@AJ)y@AJ0U2a|@AJ)y@AJ6C@AJ@4n@AJGE85@AJGE85@AJT`d@AJQ_@AJQ_@AJT`d@AJW'@AJZc@AJ^5?|@AJa|Q@AJh	ԕ@AJd7@AJd7@AJqiC@AJxl"h
@AJ~"@AJ{m@AJ@4@AJ@4@AJL_@AJS&@AJwkQ@AJvȴ@AJS&@AJS&@AJS&@AJ>B@AJ ě@AJg	@AJg	@AJY@AJn@AJW@AJ͞&@AJW@AJ䎊q@AJG{@AJڹY@AJfB@AJfB@AJG{@AJC,@AJ74@AJ~@AJm\@AJm\@AKI^@AKI^@AJm\@AJm\@AK҉@AK҉@AKnP@AKs@AKPH@AKPH@AK"`B@AK)^	@AK33333@AK33333@AKC%@AKF]c@AKMjO@AKS@AKS@AKW>6z@AKS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @s0     @s4@s8     @s9@s9@s1@s1@s0     @s,@s&fffff@s)@s4@s;33333@sA@sFfffff@sD@s<@s;33333@sC33333@sFfffff@sD@s@     @s>fffff@s@     @s8     @s6fffff@s8     @s9@s;33333@sA@s@     @s<@s&fffff@s+33333@s9@s@     @s>fffff@s     @r@sS33333@s^fffff@sy@sfffff@s@s     @s@sfffff@sfffff@sfffff@s|@ss33333@s     @s@s@s33333@s@s~fffff@s~fffff@s@s|@si@sl@s33333@s     @s{33333@sx     @s{33333@sC33333@s`     @s     @sfffff@sfffff@s33333@svfffff@sp     @sl@ss33333@snfffff@sk33333@sq@s~fffff@s33333@s~fffff@sx     @st@sp     @si@sffffff@sh     @si@sk33333@sl@snfffff@sq@sd@sS33333@sT@sT@sX     @s\@sc33333@sh     @s@r@rfffff@rfffff@r@r33333@r陙@r@s33333@r@q     @q     @q33333@r     @r<@r\@ri@pfffff@p     @pnfffff@p`     @o33333@mS33333@mfffff@l     @l@l333333@k@j@     @ifffff@i@i|@i33333@h     @hfffff@g33333@ffffff@f33333@f     @f33333@fFfffff@f      @e33333@ffffff@f@f33333@e      @d     @d33333@d|@d33333@d     @dfffff@d@efffff@ci@c     @cfffff@c@c33333@c@c33333@b33333@afffff@a     @a@a|@a333333@a@     @aVfffff@a\@ai@as33333@as33333@al@`Vfffff@``     @`l@`y@`@`@`@`fffff@_@     @_&fffff@_33333@_      @_      @^@^ٙ@]@]@     @]33333@\@\33333@]33333@]333333@]      @[fffff@[     @[fffff@[@[fffff@[33333@[@Zfffff@Z33333@Z     @Zfffff@[      @[33333@[      @Z@Z33333@Z@Z@Z@Zfffff@Z     @Z      @Z,@Z@     @Z,      @Y      @Y      @Y@Y@X@XS33333@X&fffff@X      @W@Wfffff@Wfffff@W     @W33333@W33333@WS33333@W@W@W33333@W33333@W33333@W      @V@Vfffff@Vfffff@Vy@V`     @VS33333@V@     @V&fffff@Vfffff@U33333@U@U@U     @Uٙ@Ufffff      @U33333@Ufffff@US33333@UL@UY@Uffffff@Uy@T33333@T@Tfffff@T@T@T33333@T     @T@T33333@T33333@T33333@T33333@T@T@T33333@Tfffff@Sٙ@S@S33333@S     @Sfffff@S33333@S@Sfffff@Sfffff@S33333@S33333@S@S@S@S33333@Sfffff@R33333@R33333@Rfffff@Ry@Rl@Rs33333@Rffffff@RS33333@R9@R&fffff@R      @Rfffff@Q@Q@Q@Q     @Q@Q@Q     @Q33333@Qfffff@Qfffff@Qy@Qfffff@Qfffff@Ql@Qffffff@QY@QS33333@QY@QY@QFfffff@Q@P@Pfffff@P@P@P33333@P33333@P33333@Pl@Pl@Pffffff@PY@P@     @P&fffff@P@P33333@P      @P,@O     @Offffff@Offffff@Offffff@OY@OL@OL@Nfffff@N     @N33333@N     @N@Nٙ@N33333@O      @Mfffff@Mٙ@M33333@M33333@M33333@M33333@Mfffff@M333333@L33333@Lfffff@Ls33333@Ls33333@Lffffff@Ls33333@Ls33333@Lffffff@L@     @L&fffff@L@K@K     @K@K@K@K     @Kffffff@Ks33333@K&fffff@Jٙ@J@J     @Jfffff@J@J@Jfffff@J     @Jfffff@I33333@Iٙ@Ifffff@I33333@J@J&fffff@J333333@J@     @H@H333333@H@H@     @Hffffff@H@H@Gٙ@G@     @F33333@F     @Fs33333@F     @F@F@Fs33333@FL@F&fffff@F@F&fffff@F@     @F     @Ffffff@F33333@F@F333333@E33333@E@E@E@E33333@Eٙ@F@E@D33333@D33333@E      @D33333@E@E@DY@DL@DL@Ds33333@D      @Cfffff@Cfffff@Cfffff@Cfffff@Cfffff@C@C333333@C      @C      @B33333@B     @Bfffff@Bfffff@B@B@Bٙ@Bٙ@Bfffff@B@Bfffff@B@B33333@B     @B@B&fffff@B333333@B&fffff@B&fffff@B&fffff@B@B@B&fffff@B&fffff@B333333@B333333@B&fffff@Bs33333@Bs33333@BL@BL@BL@BL@B@     @A@Aٙ@A33333@A33333@Afffff@A33333@A@As33333@As33333@Affffff@As33333@As33333@As33333@As33333@As33333@A     @@fffff@@@@ffffff@@Y@@ffffff@@s33333@@@@s33333@@     @@@@     @@Y@@333333@@&fffff@@333333@@L@@Y@@ffffff@@s33333@>@>fffff@?@?L@?@?33333@?@>L@>333333@>@>L@>     @>@>33333@=@=fffff@=fffff@=fffff@=fffff@=fffff@=fffff@=@<fffff@<33333@<33333@<@<33333@<@;L@;@;@;333333@;L@;ffffff@;     @:      @:      @:L@:@:33333@:33333@9L@9333333@9333333@9     @9@9@9@9@8@833333@8fffff@9@9      @9@9L@8@8ffffff@8L@8L@8333333@8L@8ffffff@8      @7fffff@7fffff@8      @8@8@7@7@7@7@7L@7L@7L@7333333@7      @7@7@7@7L@7L@633333@6@6@6@6@6@6@6     @6@6     @6ffffff@6L@6     @6     @6     @6     @6     @6L@6L@6L@6333333@6333333@6@6@6333333@6@6333333@6333333@5fffff@6      @6      @6      @6      @5fffff@5fffff@6333333@5fffff@5fffff@5fffff@6@5@5@5     @5     @5@5@5     @5     @5ffffff@5ffffff@5@5     @5ffffff@5     @5L@5333333@5@5@5333333@5@5      @5      @4fffff@4fffff@4fffff@4@4fffff@433333@4fffff@4@4@433333@433333@4@433333@4@433333@4@433333@4@433333@4@433333@433333@4@4     @4     @4     @4ffffff@4L@4L@4333333@4     @4@4333333@3fffff@3@4      @3fffff@3fffff@3fffff@4      @4      @4      @4@4@3fffff@3fffff@4      @4      @3fffff@3fffff@3fffff@3fffff@3@3@3fffff@3@3@3@3@3@3     @3     @3@3ffffff@3     @3ffffff@3     @3     @3ffffff@3ffffff@3L@3L@3L@3L@3@3333333@3333333@3333333@3@3      @3      @3      @2fffff@2fffff@3      @2fffff@3      @3      @3      @2@233333@233333@2@233333@2@2@233333@2     @2     @2@2@2@2@2ffffff@2ffffff@2L@2     @2333333@2333333@2333333@2ffffff@2L@133333@1@1@1fffff@1fffff@1fffff@1@133333@1fffff@133333@133333@1@1@1@133333@1@1@133333@1     @1@1@1@1     @1     @1L@1     @1ffffff@1     @1     @1     @1333333@1L@1L@1     @1L@1L@1L@1333333@1333333@1@1@1@1333333@1@1@1@1333333@0fffff@1      @1@0fffff@1      @1@0fffff@1@0fffff@0fffff@0fffff@0fffff@0fffff@0fffff@0fffff@0@0@033333@0@0@033333@0@033333@0@0@0@0@0@0@0@0@0@0     @0L@0ffffff@0L@0L@0L@0     @0ffffff@0333333@0333333@0333333@0L@0333333@0L@0L@0333333@0333333@0333333@0@0@0333333@0L@0333333@0@0      @0@0333333@0@0      @/@/@/@0      @/@/@0      @0      @/@0      @/@/@/@/@/@/@/@0      @/@/@/@/@/ffffff@/333333@/@/333333@/ffffff@/@/ffffff@/333333@/333333@/333333@/333333@/333333@/@/333333@/333333@/333333@/333333@/333333@/333333@/333333@.@.@/333333@.@.@.@/      @.@/      @.@.@.@.ffffff@.ffffff@.@.@.@.ffffff@.333333@.333333@.ffffff@.333333@.333333@.      @.333333@.333333@.333333@.333333@.      @.333333@.      @-@-@-@-@.      @-@.      @.      @-@-@-@-@-@.      @.      @-@-@-@-@-@-@-ffffff@-ffffff@-ffffff@-@.ffffff@-ffffff@-ffffff@-@-@-333333@-ffffff@-ffffff@-ffffff@-ffffff@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-333333@-ffffff@-333333@,@-ffffff@-      @-333333@-333333@-      @-333333@-333333@-333333@-333333@-333333@-333333@-      @-      @-      @-ffffff@-333333@-      @,@-      @-333333@-333333@-333333@-333333@-333333@-      @-ffffff@-      @-333333@-      @-ffffff@-333333@-      @-ffffff@-333333@-333333@-333333@-      @-ffffff@-ffffff@-333333@-333333@-333333@-333333@-ffffff@-ffffff@-ffffff@-ffffff@-ffffff@-@-333333@-333333@-ffffff@-ffffff@-@-ffffff@-ffffff@-@-@-@-@-@-@-ffffff@-@-@-@-@-@-ffffff@-@-@-@-ffffff@-@-@-@-@-@-@-@-@-@-@-@-@-@-@-@.      @-@-@-@.      @-@-@-@.      @.      @-@.333333@.      @-@.      @.      @-@.      @-@-@-@.      @.      @.      @.ffffff@.      @.      @.      @.      @.333333@.      @.ffffff@.ffffff@.@.@.333333@.@.@.@.@.@.@.@/      @.@.@.ffffff@.@/      @/333333@/      @.@/      @/333333@/      @/ffffff@/333333@/      @/@/@/ffffff@/333333@/ffffff@/ffffff@/@/@/@/@/@/@/@0      @0      @/@0@0      @/@/@/@0      @0      @0      @0@0@0@0@0@0L@0@0333333@0L@0L@0333333@0ffffff@0333333@0L@0L@0     @0     @0333333@0L@0@0     @0@0ffffff@0ffffff@0     @0ffffff@0     @0@0     @0     @0@0     @0@033333@0@0@0@0@033333@033333@033333@0fffff@0fffff@033333@0fffff@1@0fffff@0fffff@0fffff@1      @0fffff@1333333@1333333@1333333@1@1      @1L@1     @1@1ffffff@1L@1L@1     @1     @1     @1     @1@1@1@1@1ffffff@1     @133333@1@1fffff@1fffff@2      @1fffff@1@2      @2      @2@2333333@2333333@2333333@2L@2333333@2@2ffffff@2@2     @2@2@2@233333@233333@233333@233333@233333@2@2@2@233333@2@2fffff@2@2fffff@3@2fffff@3      @3      @3      @3      @3333333@3ffffff@3     @3ffffff@3ffffff@3ffffff@3ffffff@3L@3     @3     @3L@3ffffff@3ffffff@3ffffff@3ffffff@3     @3     @3     @3     @3fffff@3fffff@3     @3ffffff@3@4      @4      @3fffff@4333333@4333333@4      @4      @4333333@4@4333333@4@4L@4L@4L@4@4@4ffffff@4     @4     @4     @433333@4@433333@4     @4@4@4@4fffff@433333@4@5@4fffff@4fffff@5      @5333333@5333333@5333333@5@5@5      @5@5ffffff@5@5L@5333333@5333333@5     @5L@5L@5     @5     @5L@5     @533333@533333@5     @533333@5     @533333@5@533333@533333@5@6@6@5fffff@5fffff@5fffff@6@6333333@6@6ffffff@6     @6     @6ffffff@6ffffff@6     @6L@6fffff@6fffff@6@6fffff@7@7@7      @6fffff@6@7L@7ffffff@7ffffff@7L@7333333@7     @7@7@7     @7ffffff@7     @7@7fffff@7fffff@7fffff@7fffff@7@7fffff@7fffff@8333333@8L@8333333@8ffffff@8L@8     @8ffffff@8L@8L@8@8fffff@8@8@8fffff@8@8@9333333@9@9333333@9333333@9333333@9L@9@9ffffff@9ffffff@9@933333@9@9@9@9     @9@:333333@:333333@:@:333333@:333333@:333333@:@:     @:@:     @:@:33333@:fffff@:fffff@:@;333333@;@;@;      @;      @;333333@;333333@;      @;333333@;L@;L@;     @;@;33333@;33333@;@;fffff@;@<      @<      @<@<@<@<@<ffffff@<ffffff@<ffffff@<ffffff@<ffffff@<     @<333333@<33333@=      @=@<fffff@=      @<fffff@<fffff@=     @=@=ffffff@=     @=     @=ffffff@=333333@=L@>      @>@>@>      @>      @=fffff@=fffff@>     @>L@>ffffff@>ffffff@>L@>L@?      @?@?@>fffff@?      @?      @?     @?@?33333@?@?33333@?@?fffff@@      @?fffff@@@@&fffff@@333333@@@@@@333333@@@     @@Y@@@     @@@     @@@     @@ffffff@@ffffff@@fffff@@@@s33333@@33333@@33333@@@@ٙ@@     @@33333@A@A@A@A@A@A@A@     @A333333@A333333@A@A@A@A@Affffff@AY@Affffff@A@A@A     @A     @A@A     @A33333@A33333@B@B@B@A33333@B      @A33333@B@     @BL@B@     @B333333@B@     @BY@B333333@B333333@B33333@B     @Bfffff@Bfffff@B@B@Bٙ@B33333@B33333@B33333@Bٙ@Bfffff@CY@Cs33333@Cffffff@Cffffff@C     @CL@C33333@C33333@Cٙ@C@C     @C33333@C33333@C33333@C33333@D      @D@D@D@D@D@DY@D@     @DY@Dffffff@DY@DY@DY@D@     @Dffffff@Ds33333@Dffffff@DY@Dffffff@D33333@D@D     @D@D@Dٙ@Dٙ@D@D@E@E@E333333@E333333@E333333@E333333@EY@Effffff@EL@EY@E@E     @Efffff@E@E@E     @E33333@E33333@Efffff@E@E@E33333@E@E33333@E33333@E33333@Efffff@Eٙ@E     @F      @F@E33333@F@E33333@F      @F&fffff@F333333@F&fffff@FY@Fffffff@Fs33333@Fs33333@F     @Fffffff@FL@F@F@F     @F     @Fٙ@F     @F@Ffffff@Ffffff@Fٙ@Fٙ@F33333@Fٙ@Fٙ@Fٙ@G@G@G&fffff@G&fffff@G@G@G@G&fffff      @G333333@G@G@GY@G@     @G@Gs33333@G     @G@G@Gfffff@G@G33333@G     @G     @G33333@Gfffff@Gfffff@G@G     @Gٙ@G33333@H@H@G33333@Gٙ@Gfffff@H&fffff@H333333@HL@HY@Hffffff@Hs33333@Hs33333@H@     @HY@HY@HY@H@H@H@H     @H     @H     @Hٙ@H@H@H33333@I@I@I      @Hٙ@I333333@IL@IY@IL@I&fffff@IY@Is33333@I     @I     @I     @I     @Is33333@I     @I@I@I@I@I@Iٙ@Ifffff@J      @J      @J@I33333@J@J&fffff@J&fffff@J&fffff@J333333@JL@JL@J@     @J&fffff@Jffffff@J     @Js33333@JL@J33333@J@J     @J@J@Jfffff@Jfffff@J     @J33333@J33333@Jٙ@Jٙ@Jٙ@Jٙ@J@J33333@K      @K      @K@     @K333333@K&fffff@K&fffff@K&fffff@K@K333333@K333333@KL@K@     @Kffffff@K     @Ks33333@Kffffff@Ks33333@K@K@K33333@K33333@K@K@K@Kfffff@Kfffff@Kٙ@Kfffff@Kٙ@Kfffff@Kfffff@K@L@L      @L333333@L@L&fffff@L@     @L@     @LL@L333333@L&fffff@Lffffff@LL@Lfffff@L@L     @L@L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ?\(\?vȴ?o?+?睲-V?vȴ9X?E?畁$/?-V?C%?r ě? ěT?Vu?S?;dZ?I^5?dZ1?      ?`A7?      ?I^5?}?/w??|hs?j~#?1&x?zG?E?XbM?lD?n?Q?n?=p
=?n?\(?Vt?Q?"`B?ȴ9Xb?xF?Gz?Vt?Q?j~#?/w?S?dZ1?hr ?m?Vu?tj?M?$/?
=p?E?S?lC?~"?I^5??-V?r ě?dZ1?`A7?"`B?;dZ?-V?-V?vȴ?-V?Q?^5?|?Q?\(?"`A?      ?睲-V?QR?E?`A7?m?-V?I^5?}?nP?tj?m?ߝ-V?hr!??|hs?n?GzH?٩lD?+?E?tj~?
=p?n?vȴ?ϝ-V?ЃnP?vȴ9X?˅Q?hr!?j~"?dZ1?ǍO;dZ?+?r ě?+?ȴ9Xb?1&x?ȓtj~?Õ$/?zG{?Ƈ+I?ffffff?E?Z1'?/w?9XbM?`A7?tj?öE?`A7?nO;?S?`A7?+?GzH?zG{??|hs?Ł$/?Q?šo?tj?-V?Z1'?\(?ěS?hr Ĝ?7KƧ?
=p?7KƧ?n?nP?&x?I^5??Q?\(?-V?nP?$/?|hr?j~"?I^5??GzH?|hr?tj~?7KƧ?E?      ?Q?A7Kƨ?l?$/?$/?$/?-V?nO?I^5??° ě?hr Ĝ?&x?lD?GzH?7KƧ?M?A7Kƨ?vȴ9X?M?n?nP?"`A?I^5??-V?$/?\(?
=p?hr Ĝ?-V?$/?&x?hr Ĝ?333333?&x?-V?Q?7KƧ?lD?I^5??&x?333333?
=p?\(?`A7L?-V?nO?Z1'?GzH?nO;?GzH?Q?hr Ĝ?\(?l?Q?nO;?l?-V?S?nO?nO;?nO;?n?&x?Q?-V?ěS?7KƧ?lD?7KƧ?Q?n?333333?A7Kƨ?A7Kƨ?M?hr Ĝ?`A7?nP?GzH?Q?n?n?Z1'?tj~?lD?n?S?nO;?öE?° ě?&x?`A7K?nO?n?nO?`A7?M?Õ$/??|hs?\(?tj~?7KƧ?lD?l?-V?\(?A7Kƨ?`A7L?7KƧ?tj?nO;?\(?\(?GzH?7KƧ?lD?nO?I^5??šo?lD?S?Õ$/?Q?° ě?I^5??tj~?\(?lD?n?° ě?ěS?9XbM?öE?E?M?° ě?+?Q?9XbM?M?|hr?lD?hr Ĝ?lD?hr Ĝ?° ě?333333?\(?333333?nO?Q?tj~?° ě?lD?S?+?I^5??nO?
=p?nO;?+?`A7L?$/?`A7?
=p?S?n?lD?zG{?7KƧ?öE?vȴ9X?M?bM?333333?Q?lD?nP?n?Õ$/?n?S?333333?$/?333333?`A7L?`A7?l?Q?öE?nO;?° ě?tj?9XbM?I^5??Q?GzH?GzH?nO;?333333?nO;?`A7L?M?° ě?7KƧ?nO?9XbM?S?7KƧ?`A7L?lD?M?tj~?lD?7KƧ?nO;?\(?I^5??tj~?nO?l?nO?hr Ĝ?$/?7KƧ?tj?-V?tj~?\(?tj?° ě?hr Ĝ?7KƧ?333333?zG{? ěT?-V?° ě?-V?tj~?
=p?333333?I^5??-V?Q?333333?l?nO?S?`A7?tj~?-V?`A7K?9XbM?ěS?nO;?$/?S?zG{?GzH?l?333333?333333?nO;?`A7?7KƧ?
=p?l?333333?M?\(?tj?`A7?nO;?$/?° ě?333333?S?Q?n?Q?-V?/w?° ě?n?Õ$/?° ě?E?ěS?E?
=p?Q?° ě?n?S?`A7K?E?S?M?tj~?° ě?nO;?333333?nO?° ě?lD?333333??|hs?° ě??|hs?° ě?-V?bM?S?9XbM?-V?bM?nO?
=p?n?\(?/w?nO;?nO?+?
=p?333333?333333?`A7L?7KƧ?7KƧ?Q?
=p?-V?333333?lD?ěS?$/?lD?M?Õ$/?I^5??tj?öE?S?`A7L?`A7?-V?tj?n?7KƧ?n?A7Kƨ?A7Kƨ?9XbM?`A7?I^5??-V?zG{?S?M?nO?Q?&x?-V?-V?`A7L?öE?7KƧ?l?hr Ĝ?° ě?Z1'?+?
=p?E?9XbM?7KƧ?nO;?`A7?tj?
=p?E?333333?-V?
=p?`A7K?Õ$/?-V?-V?tj?ěS?tj?nO?M?° ě?öE?-V?333333?öE?° ě?GzH?333333?n?° ě?      ?GzH?-V?`A7?&x?GzH?Õ$/?ffffff?$/?öE?ěS?
=p?Q?\(?/w?Z1'?ļj~#?\(?`A7K?öE?tj?333333?nP?+?° ě?lD?A7Kƨ?S?tj~?9XbM?`A7?\(?\(?l?S?tj~?
=p?nO;?° ě?A7Kƨ?Õ$/?tj?hr Ĝ?S?nP?öE?nO?+?M?nO?`A7K?° ě?S?$/?ěS?nO?° ě?l?333333?lD?l?9XbM?öE?nO?Õ$/?S?I^5??tj~??|hs?$/?-V?S?tj~?öE?S?9XbM?tj?ěS?-V?tj~?S?šo?Z1'??|hs?-V?+?zG{?\(?Q?tj~?nO;?I^5??`A7K?° ě?M?nO?tj?nO;?nO?9XbM?M?zG{?° ě?$/?nO?zG{?9XbM?7KƧ?Õ$/?ěS?Õ$/?Ł$/?/w?tj~?+?zG{?° ě?lD?l?-V?+?zG{?n?tj~?
=p?Õ$/?A7Kƨ?l?nO;?Q?`A7?ļj~#?`A7?333333?° ě??|hs?
=p?S?l?Ł$/?ěS?E?\(?Q?S?nO?l?GzH?
=p?\(?l?l?zG{?`A7?tj~?nO;?lD?E?Õ$/?-V?
=p?\(?° ě?`A7?9XbM?S?ěS?9XbM?\(??|hs?Õ$/?I^5??S?\(?tj?\(?Õ$/?9XbM?333333?ěS?zG{?nO;?Õ$/?ěS?
=p?`A7?n?ļj~#?333333?Õ$/?nO?tj?`A7?I^5??l?\(?9XbM?tj~?333333?S?ěS?S?GzH?tj~?333333?9XbM?Ł$/?`A7K?9XbM?M?ěS?-V?9XbM?lD?nO;?tj?9XbM?
=p?Z1'?333333?tj~?GzH?`A7?Q?Z1'?Z1'?zG{?ěS?n?öE?° ě?lD?`A7?Z1'?333333?° ě?zG{?tj~?n?ěS?-V?zG{?tj?E?öE?Ł$/?Ł$/?Õ$/?Q?
=p?ļj~#?° ě??|hs?
=p?zG{?nO?GzH?nP?&x?l?`A7?Z1'?tj?
=p?
=p??|hs?Ł$/?$/?nO?nO?9XbM?-V?S?-V?S?\(?l?333333?lD?Z1'?l?öE?öE?ěS?hr Ĝ?S?I^5??l?öE?öE?9XbM?ļj~#?öE?`A7?Q?Q?Q?Z1'?`A7?$/?Õ$/?nO;?tj~?ȴ9Xb?nO?333333?tj~?° ě?nO;?öE?I^5??öE?7KƧ?ěS?n?hr Ĝ?öE?ěS?+??|hs?Ł$/?\(?tj~?l?$/?nO;?tj~?S?lD?/w?333333?öE?M?+?-V?tj~?\(?nO;?öE?hr Ĝ?+?-V?tj?7KƧ?$/?S?bM?
=p?
=p?GzH?l?° ě?A7Kƨ?7KƧ?&x?&x?l?\(?lD?\(?9XbM?° ě?Q?-V?`A7L?öE?zG{?7KƧ?nO?\(?9XbM?öE?
=p?
=p?nP?I^5??S?M?nO?333333?S?hr Ĝ?&x?nO?E?E?\(?9XbM?° ě?öE?° ě?tj~?zG{?9XbM?
=p?-V?E?/w?+?l?
=p?ěS?\(?nO;?° ě?I^5??-V?Z1'?\(?M?l?\(?\(?S?Õ$/?`A7L?
=p?-V?333333?S?ěS?/w?GzH?ěS?M?9XbM?Q?
=p?
=p?ěS?
=p?tj?Õ$/?-V?šo?Õ$/?`A7?S?öE?9XbM?° ě?`A7?vȴ9X?333333?333333?-V?I^5??Z1'?
=p?+?ļj~#?S?-V?nO?nO;?`A7?333333?`A7K?Z1'?M?tj~?öE?`A7?`A7?Z1'?nO?° ě?+?
=p?
=p?+?Z1'?l?
=p?333333?I^5??tj?Ł$/?333333?/w?/w?`A7?öE?
=p?I^5??\(?l?hr Ĝ?\(?-V?tj?Õ$/?333333?\(?333333?Q?° ě?n?zG{?hr Ĝ?-V?l?Õ$/?/w?Q?7KƧ?ěS?hr Ĝ?Q?ěS?Z1'?Õ$/?n?° ě?Q?\(?S?öE?+?\(?ļj~#?+?Q?Q?9XbM?Ƈ+I?333333?nO?
=p?S?l?7KƧ?-V?-V?Q?333333?tj~?öE?Q?° ě?lD?Õ$/?öE?`A7?333333?S?zG{?öE?Õ$/?nO?zG{?
=p?tj~?Q?A7Kƨ?-V?`A7?M?\(?\(?hr Ĝ?ěS?I^5??&x?° ě?9XbM?9XbM?l?öE?Õ$/?-V?333333?nO?° ě?333333?S?/w?
=p?Z1'?° ě?GzH?\(?nO;?° ě?M?Q?/w?9XbM?GzH?öE?I^5??$/?`A7L?Õ$/?Q?n?n?l?/w?-V?-V?\(?I^5??\(?lD?n?nO?l?hr!?\(?
=p?-V?`A7L?hr Ĝ?`A7L?A7Kƨ?-V?Q?l?&x?\(?333333?Õ$/?E?tj?tj~?l?nO;?\(?\(?° ě?-V?GzH?`A7L?\(?`A7?I^5??I^5??333333?
=p?lD?9XbM?zG{?/w?° ě?Õ$/?\(?hr Ĝ?bM?nO;?7KƧ?&x?n?\(?nO?9XbM?7KƧ?nO?-V?-V?-V?\(?nO;?&x?tj~?\(?\(?GzH?A7Kƨ?ěS?° ě?tj~?tj~?tj?l?
=p?Õ$/?° ě?zG{?-V?
=p?l?\(?9XbM?
=p?nO?tj?`A7?$/?ěS?`A7?nO;?-V?
=p?lD?\(?° ě?`A7L?+?7KƧ?nO;?E?ěS?ěS?I^5??° ě?ěS?/w?A7Kƨ?-V?hr Ĝ?`A7?9XbM?° ě?9XbM?`A7?\(?+?
=p?I^5??7KƧ?Õ$/?9XbM?$/?ěS?333333?° ě?I^5??-V?+?S?° ě?nO;?&x?tj~?ļj~#?-V?hr Ĝ?Q?ěS?&x?`A7?-V?+?S?Õ$/?333333?zG{?Ł$/?&x?&x?M?/w?Õ$/?öE?
=p?tj?Q?Q?-V?\(?n?$/?-V?-V?° ě?
=p?tj~?9XbM?Q?ěS?GzH?`A7?/w?M?nO;?nO;?M?M?9XbM?zG{?7KƧ?l?tj~?tj~?9XbM?9XbM?\(?A7Kƨ?
=p?      ?tj?I^5??333333?-V?Q?nO;?nP?hr Ĝ?9XbM?Õ$/?-V?E?\(?hr Ĝ?zG{?
=p?I^5??`A7?vȴ9X?GzH?/w?
=p?`A7K?Q?lD?nO?-V?nO;?n?l?Q?Q?`A7?l?zG{?nO;?7KƧ?n?`A7?I^5??Q?`A7L?l?hr Ĝ?333333?7KƧ?$/?$/?`A7L?$/?ěS?° ě?l?      ?\(?n?`A7?° ě?zG{?/w?l?nO;?`A7?Q?`A7?Q?333333?Õ$/?-V?nO;?-V?Ł$/?zG{?-V?hr Ĝ?$/?ěS?`A7?nO;?-V?n?333333? ěT?I^5??A7Kƨ?-V?-V?-V?-V?&x?Z1'?tj~?lD?7KƧ?&x?-V?S?ěS?A7Kƨ?n?l?hr Ĝ?hr Ĝ?n?I^5??M?333333?Q?M?-V?E?l?l?I^5??tj?l?tj~?bM?lD?333333?\(?\(?öE?&x?Õ$/?p
=q?`A7?° ě?Õ$/?GzH?hr Ĝ?öE?öE?Q?tj~?n?n?Q?° ě? ěT?° ě?l?\(?lD?nO;?7KƧ?Q?nO?\(?9XbM?A7Kƨ?nO;?333333?-V?7KƧ?      ?Q?A7Kƨ?ěS?Õ$/?M?9XbM?I^5??\(?A7Kƨ?I^5??7KƧ?\(? ěT?S?lD?`A7?9XbM?9XbM?9XbM?° ě?n? ěT?
=p?-V?l?GzH?Q?zG{?;dZ?A7Kƨ?;dZ?A7Kƨ?1&y?333333?$/?Q?      ?7KƧ?I^5??M?-V?\(?hr Ĝ?7KƧ?I^5??
=p?bM?n?`A7?\(?nO?S?n?-V?Õ$/?lD?lD?hr Ĝ?333333?ěS? ěT?M?&x?\(?I^5??-V?nO?l?ěS?ěS?7KƧ?A7Kƨ?-V?&x?-V?n?-V?7KƧ?I^5??`A7K?M?333333?S?-V?S?nO;?lD?M?333333?-V?333333?° ě?I^5??|hr?Q?-V?\(?9XbM?`A7?Q?nO?;dZ?
=p?&x?7KƧ?lD?\(?$/?`A7L?
=p?nO;?nP?-V?Q?S?ļj~#?-V?lD?$/?ěS?tj~?7KƧ?l?`A7L?GzH? ěT?S?tj~?Q?Q?vȴ9X? ěT?$/?bM?;dZ?lD?-V?7KƧ?`A7L?9XbM?n?ěS?M?A7Kƨ?`A7L?A7Kƨ?A7Kƨ?A7Kƨ?;dZ?|hr?n?hr Ĝ?GzH?`A7L?I^5??bM?Õ$/?Q?5?|h?-V?&x?7KƧ?&x?l?GzH?tj?-V?Õ$/?
=p?lD?$/?nP?GzH?GzH?&x?j~"?E?I^5??lD?nO;?9XbM?ěS?-V?Q?ěS?\(?I^5??Q?
=p?vȴ9X?° ě?vȴ9X?&x?A7Kƨ?7KƧ?\(?ěS?° ě?Q?GzH?S?Q?n?ěS?$/?M?öE?n?|hr?Q?I^5??tj~?° ě?nP?° ě?nO?° ě?A7Kƨ?333333?$/?-V?
=p?`A7L?lD?-V?tj?p
=q?j~"?bM?hr Ĝ?&x?7KƧ?&x?&x?`A7L?nP?nO;? ěT?$/?`A7?hr Ĝ?l?hr!?-V?Q?E? ěT?GzH?\(?nO;?\(?vȴ9X?lD?Q? ěT?Q?&x?nO?tj~?nP?$/?$/?`A7L?A7Kƨ?S?ěS?hr Ĝ?;dZ?`A7L?Q?7KƧ?lD?Q?l?vȴ9X?j~"?lD?`A7?öE?nO?tj~?$/?`A7L?Q?lD?
=p?hr Ĝ?Q?S?-V?-V?lD?Q?ěS?`A7?7KƧ?|hr?-V?;dZ?bM?-V? ěT?
=p?nP?tj~?"`?ěS?GzH? ěT?Q?nP?-V?Q?-V?nO;?-V?Q?A7Kƨ?I^5??lD?-V?-V?Q?n?-V?hr Ĝ?GzH? ěT?nP?bM?      ?\(?Q? ěT?I^5??"`?A7Kƨ?
=p?M?nO?7KƧ?/v?° ě?lD?nO;?bM?nP?M?° ě?`A7L?vȴ9X?n?M?"`?GzH?Q?-V?-V?p
=q?Q?ěS?7KƧ?333333?I^5??Õ$/?M?7KƧ?$/?ěS?
=p?nP?l?Q?A7Kƨ?A7Kƨ?ěS?M?° ě?9XbM?bM?tj~?M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@Ns33333@N@N@NL@N@N@N@N@N@Nfffff@N@N@Ns33333@Ns33333@N     @N@N@N@N@N@N@N@N@N@N@N@N@N@N@Nfffff@Nfffff@N@N@N@Nfffff@Nfffff@N33333@Nٙ@Nfffff@O@O&fffff@OL@Os33333@Os33333@O     @O@O@Offfff@O33333@O33333@O     @O33333@Oٙ@O33333@Offfff@Oٙ@O     @Offfff@O33333@P      @Pfffff@P@P@P@P@P@P33333@P@P33333@P      @P,@P,@P9@P@     @P@     @P      @Offfff@PY@P`     @Pl@Ps33333@Ps33333@P     @Pfffff@P     @Pfffff@P@P33333@P33333@P@P     @P     @P     @Pfffff@P@P33333@P33333@P33333@P33333@P33333@P@P@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @P     @P     @P@P33333@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P33333@P33333@P33333@Pfffff@P@P@P33333@P@P33333@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P     @Pfffff@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@Pfffff@P@P33333@P33333@P33333@P33333@Pfffff@P@P33333@Pٙ@Pٙ@P33333@P33333@Pٙ@P33333@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@Pfffff@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @Pٙ@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P@Pfffff@P     @P     @Pfffff@Pfffff@P     @P     @P     @P     @Pٙ@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@P     @Pfffff@P@P@P@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P     @P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@Pfffff@Pfffff@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P     @Pfffff@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P33333@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P33333@P33333@P@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       P23                                     1                                       (zBG
(3 ʀ