CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P8     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.961434Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @6         data_max      @6         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =8  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @bfffff   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =8  kX   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      P     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?3   data_max      @%<1&   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =8     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      P     salinity                	long_name         salinity   units         PSS-78     data_min      @@ \)   data_max      @ALZ1   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      =8 h   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      P A   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @#         data_max      @s   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        =8 P   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      P (   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?Gz   data_max      ?\(   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      =8 x   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      P ڰ   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       =8     PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      P '8   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @J33333   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     =8 6   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      P s   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( 8   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      c   data_max      c   C_format      %10d       `   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hh}^_1   data_max      @Hh}^_1   C_format      %9.4f          d   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `GX   data_max      `GX   C_format      %9.4f          h   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        l   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        p@6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @6      @333333@      @@@       @"333333@#@%@(      @*      @,333333@.333333@0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @:fffff@<      @=      @>      @?@?fffff@@     @A      @A     @B      @B     @B@D@D     @E      @E     @F      @F     @G@Gs33333@H      @H     @I      @I@J      @J     @K      @K     @L      @L     @M      @M     @N      @N@N@O@P      @P@     @P     @P     @P@QL@Q     @Q     @R      @R@     @Rs33333@Rٙ@S      @S@     @S     @S     @Tfffff@T&fffff@Tfffff@T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @Wy@W     @X      @XFfffff@X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[Ffffff@[fffff@[@\      @\@     @\     @\33333@]fffff@]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`33333@`      @`@     @``     @`     @`     @`33333@`@a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@d@d     @e      @e      @e<@ei@e     @e     @e33333@e     @e@f      @f@     @fc33333@f     @f     @f     @f     @g      @g      @g@     @g`     @gy@g     @g     @g     @h      @h      @h9@hi@h     @h     @h     @h     @i      @i33333@iFfffff@i`     @i     @i     @i33333@ifffff@j      @j      @j@     @j`     @j     @j     @j     @jٙ@k	@kfffff@ki@k@k     @k     @k     @l      @l      @lC33333@l\@l     @l     @l     @l     @m      @m@m@     @m`     @m     @m     @m     @m     @n      @n      @nC33333@n\@n     @n     @n     @n     @o     @o#33333@o@     @o`     @o     @o33333@o     @o@p      @p     @p33333@p@     @pNfffff@p`     @pq@p     @p     @p     @pfffff@p     @p     @p     @p     @q      @q@q      @q0     @q@     @qP     @qa@qnfffff@q     @q     @q     @q@q     @q     @q     @q     @r      @r     @r!@r.fffff@r@     @rP     @r`     @rp     @r|@rfffff@r     @r     @r     @rљ@rٙ@r33333@s      @s     @s      @s0     @sA@sP     @s`     @sp     @s     @s     @s     @s     @s@s     @s     @s     @t      @t     @t@tA@tP     @t`     @tp     @t     @t@t33333@t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @ul@u~fffff@u     @u     @u     @u     @u     @u@u񙙙@v      @v     @v      @v.fffff@vA@vS33333@v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @wC33333@wP     @w`     @wp     @w     @w     @w@wfffff@w     @w     @w     @w     @x@x     @xfffff@x0     @x@     @xP     @x`     @xnfffff@x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y,@yFfffff@yP     @y`     @yp     @y     @y     @yfffff@y     @y     @y     @y     @y     @y@z!@z0     @z@     @zP     @z`     @zq@z     @z     @z     @z     @z     @z     @z     @{@{fffff@{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{@{     @{     @{     @|      @|@|fffff@|0     @|@     @|K33333@|d@|p     @|     @|     @|     @|@|@|     @|     @|     @}@}     @}      @}0     @}@     @}P     @}`     @}nfffff@}@}     @}     @}     @}     @}     @}33333@}fffff@~      @~     @~      @~0     @~<@~P     @~`     @~p     @~     @~     @~     @~     @~fffff@~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @33333@      @(     @0     @8     @@     @G33333@Q@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @ @     @33333@     @      @(     @0     @8@@@H     @P     @X     @`     @h     @p     @w33333@@     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @      @@33333@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h@p@x     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @ @33333@     @     @      @(     @0     @8     @A@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @fffff@@     @     @     @     @     @fffff@fffff@     @      @     @     @     @      @(     @/33333@8     @@     @H     @P     @X     @_33333@jfffff@p     @x     @     @     @     @     @33333@     @     @@33333@     @     @     @     @     @     @fffff@      @     @     @     @fffff@)@0     @8     @@     @H@P@W33333@`     @h     @p     @x     @     @     @     @33333@     @     @@33333@     @     @     @     @     @33333@     @     @      @     @@     @      @(     @0     @8     @@     @H     @Nfffff@X     @`@h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @ٙ@     @     @     @     @33333@@     @     @      @(     @0     @8     @@     @H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @@@     @     @     @     @@33333@     @      @     @     @@33333@(     @0     @8     @@     @H     @P     @X     @`@h     @p     @x     @     @     @@     @     @     @@33333@     @     @     @fffff@33333@     @     @     @      @33333@     @     @33333@(     @0     @8     @?33333@L     @P     @X     @`     @h@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @fffff@"fffff@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@     @      @     @     @@      @(@/33333@8     @@     @H     @P@T     @a@h     @p     @x     @     @@33333@     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(@0     @8     @@     @H     @P     @d     @h     @p     @x     @     @@@     @     @     @     @     @ə@     @     @     @     @     @fffff@ @     @     @     @fffff@(     @0     @8     @@@H     @P     @X     @`     @h     @p     @x     @     @fffff@     @     @     @     @     @@33333@     @     @@@     @     @     @      @     @     @     @      @(     @0     @8     @?33333@H@P     @X     @`     @h     @p     @x     @|@     @     @     @@@33333@     @     @     @     @     @33333@      @     @     @@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @@     @@fffff@      @$     @(     @+33333@0     @4     @8     @<     @?33333@F     @H     @L     @P     @T     @Xfffff@Z@a33333@d     @h     @l     @p     @t     @x     @{33333@     @     @     @     @     @     @@     @     @fffff@@fffff@     @     @     @33333@     @     @     @     @     @     @33333@陙@     @     @     @     @     @      @fffff@	33333@     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @;@A@D     @H     @L     @P     @T     @X     @\fffff@^fffff@d     @h     @l     @p     @t     @x     @zfffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @fffff@     @     @     @     @@     @     @     @     @     @     @     @@@     @     @      @     @     @
fffff@@     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @Hfffff@L     @P     @T     @W@\     @`     @dfffff@g@l     @p     @t     @xfffff@|     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @@fffff@     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @ fffff@fffff@     @     @     @     @     @fffff@!33333@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @S@X     @\     @`     @c@h@l     @p     @t     @x     @|     @fffff@     @     @     @     @     @fffff@fffff@     @     @fffff@@     @     @     @fffff@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @@fffff@      @$     @(     @,     @0     @4fffff@8     @<     @?@D     @H     @L     @O@T     @X     @\     @`     @dfffff@h     @l     @p     @t     @x     @{33333@     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @fffff@fffff@     @     @     @     @ߙ@     @fffff@@@     @     @     @ fffff@@
     @     @     @     @fffff@     @@$     @(     @,     @0     @4fffff@6fffff@=@@     @D     @H     @L     @Pfffff@T     @X     @\     @`     @d     @hfffff@l@p     @t     @x     @|fffff@~fffff@@     @     @     @     @     @     @     @     @     @@     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @@     @ fffff@33333@     @     @     @33333@33333@     @      @$     @'@,fffff@0     @4     @8     @<     @@     @D     @G33333@Pfffff@T     @X     @\     @_33333@hfffff@l     @p     @s33333@x     @|     @fffff@@     @     @fffff@33333@@     @fffff@@     @     @     @33333@@     @     @     @     @fffff@33333@33333@     @     @     @     @     @     @@     @     @      @fffff@@fffff@     @     @     @     @ fffff@$     @'@,     @0     @4     @8     @:@@     @D     @H     @L     @P     @T     @X     @`fffff@d     @h     @l     @n@xfffff@|     @     @     @     @33333@fffff@     @     @     @     @     @fffff@@     @     @     @     @fffff@     @Ǚ@     @     @     @י@     @     @     @     @@fffff@     @     @     @ fffff@33333@     @
@     @     @     @     @      @$fffff@-@0     @4     @8     @<     @@@D     @H     @L     @P     @T     @X     @\     @`     @d     @g@l     @p     @t     @x     @{@     @     @     @     @     @     @     @fffff@     @     @     @fffff@fffff@     @     @     @     @˙@33333@     @     @     @fffff@fffff@fffff@     @     @     @ fffff@@     @     @fffff@     @%33333@(     @,     @0     @3@=33333@@     @D     @H     @L     @O@U@X     @\     @`     @d     @g33333@m33333@p     @t     @x     @|     @     @33333@fffff@     @     @     @     @33333@@     @     @     @     @     @fffff@fffff@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@      @     @fffff@@     @     @     @     @      @#@)33333@,     @0     @4     @8fffff@;@@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h@l     @p     @t     @x     @|     @     @33333@     @     @     @     @     @33333@@     @     @fffff@     @     @     @     @     @fffff@@     @     @     @     @     @     @@     @     @      @     @@@     @     @     @     @      @"@(     @,     @0     @4     @:     @<     @@     @D     @H     @K@U33333@X     @\     @`     @d     @f@m@p     @t     @x     @|     @     @     @     @     @     @33333@     @     @fffff@@     @     @     @@     @     @     @fffff@     @     @     @     @     @33333@     @     @뙙@33333@     @     @     @      @33333@@     @     @     @33333@@      @$     @(     @+33333@0fffff@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`@d     @h     @l     @p     @t     @x     @|     @     @     @     @33333@     @     @     @     @     @@@     @     @     @     @fffff@     @     @     @     @     @33333@ᙙ@     @     @     @@fffff@     @      @     @
     @     @     @     @     @fffff@ @$     @'@,     @0     @4     @8     @;33333@D     @H     @L     @P     @Tfffff@Vfffff@]33333@`     @d     @h     @l     @p     @t     @x     @{@     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @33333@     @     @ϙ@     @     @     @     @     @     @     @     @@     @     @      @     @fffff@
fffff@@     @     @     @      @#@-33333@0     @4     @8     @<fffff@E33333@H     @L     @P     @S33333@Y@\     @`     @d     @h     @l     @p     @s33333@xfffff@|     @     @     @     @33333@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @33333@@     @     @     @     @@      @$     @(     @0fffff@4     @8     @:fffff@A33333@D     @H     @L     @Nfffff@U33333@X     @\     @`fffff@bfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @%;Q@%<n.@%<PH@%<(\@%<64@%<ߤ@@%<C,zx@%<1&@%<?@%;A@%:1'@%3&@%)B@% ě@$V@$*0@$M:@$ -
@#R@#i ѷ@#-:@"q@"L/{J@"&I@"y@"I^@"84֡@"D@"D@"#x@"?|h@"ce@"{~$@"NO;@"&x@!h@! u!@ ?@ W@ (	ԕ+@ 
@ -w1@?@-@[@}E@mV@Rp:@@     @Ov`@o@TɅo@P@4m8@ C@4֡a@e+a@?@6z@@[u%@@a|Q@@N@C@E@˒:)@j~@ݗ+k@+@*0@}!.H@W>6z@S@N@ix@ceO@^Q@Ik~(@<64@'/V@ݘ@y=c@bM@Y@*Ov`@5sg@?[W>@]ce@E84֡@JL/{@dTɆ@jfB@ql@n}Vl@_	@\wkP@\1&@^Ov_خ@hXy=@rGE85@b`A@\]ce@p'RT@qiB@ݗ+k@ae@a.H@H@qj@m@zG@tSM@,zxl@%S@M:@H˒:*@I ѷ@Ft@u"@g8}@Y}@Fs@ᰊ@g	@xF@-V@,<@tj~@D@?@[W>@ix@["`B@P*0U@9Y}@(r Ĝ@',@'lC@@v@ hۋ@p:~@Q@Xe@-V@,@M@M@h	ԕ@|Q@`d@v}Vl@cn.3@S҉@A@)Dg8~@&IQ@$TɆ@$?@#
=p@!ae@쿱[W@[@
jOv@}Vl@|Q@0
)@`d@\(@'/@Q@_o@āo h@r@?@$@@o i@~BZc @f'@[Q@H1&x@8)@/v@(Xy=@#S&@cA @_F@
M;@nP@4֡a@o@+@W'@E84@<쿱@,<@I^5@r䎊q@j͞&@_?@B\(@;dZ@3E@.H@+~($@%ڹ@"@4@>BZ@
=p@ߤ?@o hی@oiDg8@Fs@@?@͞&@쿱[W@u%F@c
=p@]cA @UϪ͞@ES&@,!-w@Ϫ͞@K]d@4֡b@e@ěT@߾vȴ9@͸@$t@)@D@
qv@[6@af@@@4n@yrGE8@pU2a|@Z6C@@n@-C\@Mj@_o@B@C,zx@ݗ+k@ƍ@M@UϪ͞@1[W>6@xF]@@-
q@%F
L0@&'@%zxl"h@#A [@@2 ě@'fA@*0U2a|@/iDg8@@     @Ik~(@G@@A:S@;/V@4SMj@2s@'lC@<64@g8}@@z@e+a@/{J#@1@fffff@}Vm@Z@%1@7@zxl"h@`A7L@.H@U=@bM@\(@@w3@pD@UL_@K:)z@DM:@Eo i@@C@C%2@JqiC@Vaf@^iB@b`A@fx@ceO@]/w@Qhr @Iԕ*@Ik~(@LcA \@#	@C@R<6@N;6@qu"@7KƧ@%2@ߤ?@{J#:@}Vm@vȴ@)^@?@oiDg@Q@K]c@]cf@~vȴ9X@kjf@ae@_;dZ@\1&@[S@\u"@bC,@iᰉ'@h	ԕ+@ao@PbM@N!R<@Nߤ?@Q4J@M5Xy>@JL_@G@@@4m9@%F
L0@ -
@kP|@D*@&@
qu"@Vu@s@	7KƧ@p:@ ѷ@A@\(@|@
=q@"h	ԕ@fA@e+@*0@ǮzH@o i@쿱[@ᰊ@,<@tj~@TɆ@'R@&@*0@,<@+@|64@}ڹZ@ݗ+@&I@}<64@˒:)@Vu@!R<@L_@wXe@i^@b3@],=@Xy=c@]-V@eS@S&@43@0D@0:~ @6!.I@;dZ@5sg@6Fs@,[W?@8YJ@q@ߤ@@6@;dZ@*0@Ϫ͟@@@D*@O
M@@;dZ@
L_@ݗ@F]c@@7Kƨ@$/@TɅo@o hی@I^5@@o h@,zxl@@4n@\N@@@/V@m8@iB@2X@x@@,@>BZc@VϪ@a|Q@C@TɆ@)^	@L_@ʦL/{@Q@ߤ?@%2@-
@_ح@E@hۋq@=b@*0U2a@Z@@b}@&@cA \@u%F@JM@     @y"`@xl"h	@u!.@@zH@84֡@@@$/@}<64@z^5?|@x)@vFs@qu!S@g,@dtSM@`d8@_?@^5?|@YJE@NVu@I7KƧ@H1&x@G_o@Eݗ@?˒:)@9"`@4SMj@.zG@*JL@%S@#S&@҈p;@|@fA@@N@bM@
@
jOv@/{J#@]cA@eO@Zc@ 4m9@ߤ?@+@ᰊ@O;@I^@@思IQ@e+@޸Q@bM@Ϫ͞@#@Ňݗ@JM@tj@n@.H@<64@G{@4֡b@ߤ@6z@ae@,=@e+@
=p@=K@n@M:@}K]@xYJ@v+jg@sPH@nzG@kI^@h>BZc@cZ@[W>6z@Vl!-@Rm@Oo @N!R<@N!R<@L~($x@IQ@F
L/@An.@=H˒@<j~#@:^5?|@74m@2{m@/Vϫ@.t@*͞&@&,<@#A [@!|Q@"`B@+j@l!-@Z@*1@E@tj~@rGE9@Vu@
jOv@L_@	@S@%2@,zxl@&IR@<64@Xy=@2W@-V@t@C\@U=@zxl"@@S@Q@֡af@fA@ќu@qu"@ԕ*@˒:*@*0@E@eں@ᰊ@O;@A@䎊r@1&@q@>BZ@&@I^5?@@_o@n/@JM@,zxl@4m9@}v@{~$@x}H@sg@p ě@kC]@h@c	@be+@_U=@]}H@["`B@UϪ͞@N+@F-@C$@@C@;lC@4!-w2@.t@*fB@)Dg8~@',@%@#	@ u!@쿱[W@%@cA @ce@,<@1'@y=c@@Z@
W'@@KƧ@^5?|@{m@}Vl@Ϫ͟@~($x@ʦL/{@jOv@F]c@C,z@,@Țu%F@҈@Ίqi@'/W@]cA@'/@{J#9@j~#@g@T`d@L/{@tSMj@p:~ @qA [@X*0@>($x@(Xy=@ݗ+k@~($x@L_@_@
qu"@*1@6C@e+a@1'@,q@2W@>m\@F&I@VOv_@k~($@m(@V@KƧ@G_o@=E@<PH@;~$@3E@+j@D*@b}@*0@zG@@q@حV@,=@0
)@E@_p@҈@?@J#9@!R@\(@J#9@xl"h
@b}V@:S@74@a@N@S@{J#9@˒:)@F@73@1@SMj@MjO@u!S@Z@>@ٳ|@sPH@
=p@ԕ*1@T`d@*0U@]cA@2W@͞&@RT`e@zG@zG@B@*0U2a@
=p@!-w1@IQ@C,zx@Z@ix@?@0
(@)^@*͞&@+I^@)*0U2a@%1@[@@@sP@
=p
@?@ hۋq@F]c@n/@@u%F
@@Q@7@ⶮ}Vm@>BZ@8YJ@C@|@zG@@1@	k@Ov_خ@_F@hr @	 @@o h@}H˒@t!-w2@kP{@irGE@h>BZc@irGE@f1.@c	@ae@aGz@`҈p@`d8@_?@ZQ_@Vl!-@P|@M5Xy>@L@I^5?}@Dg8}@As@?@<Z@;dZ@5Xy=@.H@)@#n.3@u%@u@$/@I^5@
hr@
s@
	k~@
kP@
䎊q@
D*@
Ƨ@
D@
s@
vȴ9X@
V@
RT`e@
!-w1@
*0@
N;6@
-
q@
!R<@
'RTa@
$tS@
|#x@
x73@
kQ@
d%1@
ceO@
ae@
Y>BZ@
P{@
M@
KƧ@
F-@
:~@
1&x@
.H@
-V@
+U=@
)lD@
'/V@
#
=p@
 [6@
 'RT`@
qiC@
u%F
@
$/@
 hۋq@˒:)@ڹZ@Q@~$@~$@Q@Vl!@b}V@
 ѷ@
ݗ+@
+I@
qu!@
-B@
8YJ@
;A@
>ߤ?@
?@
@n@
@n@
@4m@
@4m@
@C@
E@
Ov_ح@
N+@
N_o @
H9Xb@
.1@
+jf@
(TɅ@
 [6@
Q@
zG@
o @GE85@!-w@fA@Z1@|Q@т@䎊@)^@s@NU@C@j~#@4֡b@?@֡a@&x@H@<쿱@	k@Z@@|Q@^҈p;@Zc	@Z1'@Vt@Ks@F]cf@B\(@BZc@@C@>6z@=v@<j~#@:)_@84֡b@12W@$xF@u@tj@ᰉ@:)y@ 4m9@E@PH@!R@@4֡a@4֡a@P{@빌~($@j~@      @"@ڹZ@#x@s@kP@j~@D@O;@>BZc@`A7L@;dZ@@64@Z@n.@n.@~@)y@'RT@`A@'/W@YJ@{m]@w+@g8}H@ZQ_@U2a|@P*0U@L@J#9@H˒:*@GE84@Fs@D*0@C@Ca@N@A [7@?[W>@7rG@'/V@IQ@*0@ᰉ@Ov_@
O;dZ@
!.I@
䎊q@
~"@
ܑN;@
y=c@
l!-@
H@
D@
8YK@
,zxl@
7Kƨ@
b@
YJ@
?@

(@
@
IQ@
R<6@
!-w1@
u"@
,<@
R<6@
:)y@
o @
ԕ*@
:S@
vFs@
o@
glC@
d%1@
^ ѷY@
YJE@
VϪ͟@
Q_p@
N;5X@
JL_@
C\N@
?[W>@
B74@
;/V@
1-@
-w1@
($xG@
#S&@
+j@
҈@
o h@	.H@	Vl!@	@	P{@	1.@	Z1@	
qu@	u!@	
qu@	iB@	cA @	c	@	*0U@	y@	g8}@	@	4֡b@	C-@	g	l@	q@	!-w1@	L_@	nO@	L_@	YJ@	ѷX@	{s@	u\(@	qiB@	k~($@	gfA@	cA [@	`
qu@	^5?|@	\(\@	Zc	@	XU@	Vl!-@	U=K@	T*1@	QX@	J#9@	H˒:*@	H@	GE84@	F]cf@	Fs@	F
L/@	?[W>@	4m8@	2a|Q@	2a|Q@	43@	.H@	)^@	%S@	sP@	҈@	#@	S&@	{J#9@	 IQ@ڹZ@J#9@	k~@%F
L@䎊q@t@fffff@ߤ?@@s@W'@D@)^	@)^	@˒:)z@s@/{J#@D@ɺ^5?}@8YK@g8}@,zxl@Zc@TɅo@[W>@|hs@
(@64@Z@
(@6@NU@n@NU@ߤ?@v@z@Vϫ@w1@O
M@U2a|@&x@{@r@H@U=@<쿱@d7@d7@x@R<6@u@wkP@wkP@:)y@L/{@b}V@sE@o@t#@|hr@xF@m(@de@_;dZ@Zc	@YJE@Yb}@Yb}@Xe+@WsPH@W&@XD*@Vaf@UfA@T`d@Rp:@Rp:@P|@M%@M:@K:)z@J#9@H˒:*@E@Dg8}@B@>vȴ9X@:S&@74m@43@/Vϫ@(TɅ@',@*0
@',@-V@n@K]d@ hۋ@%1@>6z@@ǮzH@š@[W>@BZc @64@|@v@6z@&@\)@
=p@}H@	@[6@@nO@Mj@k~(@$/@weں@qu!S@p
=q@p@kQ@hۋq
@g@ffffff@dZ1@a'R@a@N@`A7K@aGz@\N;@UfA@K]cA@?@7Xe@3ߤ@%F
L0@˒:)@J#9@\(@A [@D@Z1@"`B@@ҽ<64@䎊@ɺ^5?}@C@ [7@A@g	l@2X@6z@^@&@&@IQ@zxl"h@S@'RT`@kP|@Ov_@4J@1&x@o hی@}Vl!@{lC@t!-w2@nc	@n.2@m\@e`A7L@WsPH@O;dZ@NT@LcA \@OAs@JD@IoiD@F-@A@<j~#@1[W>6@%zxl"h@kP|@N;6@	'RTa@@oiDg8@Z@حV@;dZ@ޞ@iB@b}@a@O@As@/{J#@]cA@5Xy>@ȴ9Xb@ěS@7Kƨ@C@6@BZc @sg@I^@
qv@?@[6@+J@)^@@S&@IQ@~"@{lC@v!.I@q@n.2@k~($@e@YJE@SZ@QX@P`A7@P*0U@Np:~@Jn@H@B\(@9#w@6E@4J@2-V@,<쿱@!o@*0@*0@R<6@S&@\(@Mj@bM@rGE9@4J@N;6@bM@o @Vu@
@xF]@eO@F]c@I^5@u%F
@@      @xl"h
@\(@l@-V@8Y@VϪ@B@fffff@M@$@ԕ*1@D@2W@\(@[W>@)_@ߤ@'RT@{J#:@v@V@>B[@V@a@@wk@,@1@,<@)^@u%F@oiDg@@4n@~m\@y(@tD@s@m8Y@m(@lC@l[W?@l"h	ԕ@m(@lVϪ@kQ@jfB@glC@fA@fA@\>@Yb}@UfA@Sa@O@T,<@R<64@Q_p@O͞@O͞@O͞@O͞@O
M;@M5Xy>@LcA \@J#9@F
L/@A [7@9Y}@49XbN@2a|Q@1o@0'RT@.H@%u@Q@S@=K^@6C@$tS@*0U2@u@
qu"@$/@u%F
@E@?@C\@	k~@E@t@빌~($@	@ߤ?@cA @?@(\@ڹY@8YJ@*0U@_o @š@Z@ߤ@zG@a@@@*0U2a@$xG@	k@,=@=K^@Z@sP@bM@Vu@$tT@C%@1&x@hۋq@u!R@q@nO;@m(@lC@k~($@jJL@jfB@h@b}Vm@bM@_o@\?@Xy=c@OAs@M%@F]cf@@NU@=K]@5'0@12W@0
(@.}Vl@+U=@*0
@($xG@%1@#n.3@!-w1@qu!@_o@*0@*0@$tT@
O;dZ@	7KƧ@1&x@_o@S&@{J#9@u%F
@ IQ@˒:)@Q@%F
L@A [@(@A@ߤ?@y=c@
M;@@#9@˒:*@\N@~($@Xy=@|@g	l@33333@ ě@y@TɅ@L/{J@tSM@wk@u@wkQ@U=@=K^@n@@N;6@hr @Mj@@qiC@u%F@Fs@nP@˒:)@$tS@|?@tSMj@lVϪ@dZ1@`
qu@^ ѷY@[W>6z@Y>BZ@W&@S&@OAs@O͞@KƧ@DS@ATɅo@<Z@:^5?|@8YJ@5?@2ᰊ@12W@1[W>6@1[W>6@0
(@0'RT@0U2a|@(@	@$/@@N@n@
qu"@	7KƧ@#@ݗ+@@ݗ@ݗ@Q@F]c@:S@E@%F
L@@.2@fffff@?@حU@Ϫ͟@l!-@֡af@l!-@Ϫ͞@՛=K@,<@@`d@ԕ*1@`d@`d@m@jOv@)^@&IR@ߤ?@Z@|@'RT@O
M@zG@0
@\)@@-@u@
=p@tSM@n.3@3@ěT@-
@䎊r@'RT`@쿱[W@kP|@Z@I^5?@&I@hۋq@zC\@o@m(@kC,z@jg	@m(@jg	@hr Ĝ@eڹ@aGz@]cA @\(\@Xe+@UfA@T,<@QX@P*0U@M@K]cA@JW'@I@H9Xb@E@B&IR@@n@<n.@8}H@8YJ@6}Vl@3g	l@.2X@,>B[@,1&y@+I^@*0U2a|@(\)@'-@&x@%u@%u@"3@Q@@@sP@Mj@K]d@JM@%2@ ѷ@ H˒@ =b      @ iDg8@ ۋq
@ 	k@ 8}H@ 唯O
@ e@ @ iB@ Ʌoi@ Z@ _p@ Ϫ͞@ ;dZ@ As@ ;5X@ ΤT@ @ :@ D@ K]c@ s@ 84֡@ TɅo@ j~#@ ~@ D@ KƧ@ |@ -@ w1@ y@ IQ@ @ L/{J@ zxl"h@ F
L0@ u@ /@ 
=p@ h	ԕ@ R<6@ o@ 	@ u"@ =K^@ @ @ *0@ n@ hr @ )^@ qu"@ =p
@ qiC@ 7KƧ@ oiDg@ o h@ u%F
@ |Q@ {J#9@ z>B@ y=b@ x-
@ x-
@ y	k~@ xF@ xl"h	@ w+@ tj~@ qiB@ poiDg8@ nt@ mC\@ m8Y@ l!-w@ kQ@ jg	@ jOv`@ ffffff@ bM@ `A7K@ XD*@ TE@ TɅoi@ T*1@ SZ@ P{@ M5Xy>@ Jn@ IoiD@ H@ H@ G)^@ F
L/@ B\(@ As@ @C@ ?@ @6@ >6z@ >vȴ9X@ >ߤ?@ >6z@ <Z@ <64@ ;dZ@ 9D@ 74m@ 4m8@ 3g	l@ 1-@ 0
(@ /{J#:@ /v@ .}Vl@ -w1@ +6z@ *d7@ %@ S@ u%@ u%F@ PH@ _F@ O;d@ O;d@ Xe,@ R<6@ ҉@ I^5?@ ݗ@ $/?.H?73?Y|?D?!-w2?c	?(?Q?rGE?@4?
qu?
qu?
qu?Q_??Z?5Xy>??3?d7?u?S&?쿱[W?kP|?R<6??ڹY?YJ?o hی?4m9?{J#9?k~($?a|Q?]ce?YJE?W>6z?M?H?E?As??|hs?84֡b?4J?2W?1&x?/Vϫ?/{J#:?,zxl"?&IQ?!.H?}H?qu!?n?4J?'/W?'/W?ߤ??xF]?
L/{?
=p
?	 ѷ?_o?F]c?      ?#x?lC?>B?"`?-
?+?eں?!.I?Fs?!.I?\(?MjO?hr!?C]?C]?C,z?lC?䎊qj?C,?Gz?ߤ??҈p;?҈p;?iB?ݗ+j???sPH?䎊??8YK?2W?\(?TɅo?H˒:?)_???[W>6?}Vl?1?>B[?q?1&y?͞&?d7?L/{J?n.3?3?3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @@@@@@rGE@@ ѷ@@ $tT@@$/@@ ѷ@@ \)@@$/@@Dg8~@@'RTa@@s@@K]@@
{m@@"`@@sh@@(eO@@=L_@@F8YJ@@L@@Lg8}@@LS@@Lqj@@M:@@M!.@@P@@Qae@@Q	k~@@PTɅ@@P1&x@@Pl"h	@@P:~ @@Qu@@R䎊@@Rc	@@TVϪ@@Tj~@@T>B[@@TwkP@@Sa@@@Swk@@S~($@@T@@T9XbN@@T?@@TFs@@T9XbN@@TSMj@@T~($x@@U84֡@@UB@@UY|@@UڹZ@@U8YK@@V@@V!R<@@V
(@@VOv_@@V;5X@@VL/{J@@Vu@@UU=@@U=K@@Uw1@@UoiDg@@VϪ͟@@W@@Vߤ?@@V5?|@@V2X@@W,@@W;dZ@@WAs@@WXe@@X	ԕ+@@XeO@@Xl"h	@@X-
@@Xp:@@YDg8~@@Z-V@@Z@4n@@ZM@@ZS&@@[C]@@\hr@@^}Vl@@a&x@@dZ@@g[W>@@lPH@@o hۋ@@pTɅ@@rwkQ@@vYJ@@wحV@@x
qu@@y0
)@@|j~@@\(@@H@@Vl!@@0
)@@ڹY@@
qv@@~@@m8@@tj~@@qu"@@_p@@O
M@@sPH@@>BZ@@fA@@@@ńM:@@eO@@~($x@@vȴ9X@@ύO;d@@=b@@ҩ@@ӅQ@@`d@@+a@@8YJ@@sPH@@>BZc@@&x@@ڦL/{@@lC@@5?|@@y@@˒:*@@9Xb@@l@@:)y@@Q_@@Z@@Fs@@D@@R<6@@;dZ@@	@@fA@@U2a|@@˒:*@@n@@YJ@@tj@@&x@@)y@@Y@@	@@ߤ@@<쿱@@]ce@@zG@@~($x@@#@@*1@@zxl"@@7@@S&@@Ov_@@E@@IQ@@O;@@}Vl@@Q@@'@@m\@@C-@@H˒:@@b}V@@o@@	k@@o @@@@$xG@@H@@r Ĝ@@IQ@@𭫟U@@TɅ@@)^@@҈p@@`A7@@$tT@@$tT@@&x@@Dg8~@@4J@@_p@@@N@@JE@@ae@@n@@&IR@@3@@W'@@d7@@W'@@^5?|@@W'@@a|Q@@d7@@qiC@@xl"h
@@n@@`A@@s@@҉@@I^@@S&@@~@@D@@D@@s@@s@@'/@@PH@@F]c@@a@N@@n.3@@tj~@@eO@@A@@ߤ@@U=@@g@@J@@n.@@J@@Q@@L_@@xF@@%1@@C,zx@@VϪ@@tSM@@?@@TɆ@@:@@qu"@@:@@O;dZ@@w1@@U=@@8Y@@$/@@tSM@@L_@@҈@@6@@C]@@]ce@@tSM@@zG@@m8@@cA \@@IQ@@@@@@R<6@@v@@	@@3@@rGE9@@@@6@@ ě@@'RT`@@A7K@@>BZc@@U2a|@@
(@@Dg8~@@^@@D@@lD@@)y@@@4n@@GE85@@W'@@{m@@ᰊ@@L/{@@`A@@m@@)^	@@=K^@@9@@=K^@@u%@@䎊q@@PH@@C%@@S@@g	l@@$@@1&y@@tSM@@@@e@@IQ@@L_@@O;dZ@@S&@@\@@ݗ@@H˒@@qu"@@>@@'0@@*0@@p
=@@p
=@@Xy=@@ڹZ@@`A7L@@?|h@@qu"@@V@@+a@@}H@@@@Xy=@@%@@@@8Y@@cA @@?@@ᰉ@@(@@+jg@@,<@@A@@Fs@@Mj@@Mj@@!.I@@!.I@@,@@v@@,@@$tS@@Ft@@Ft@@ hۋ@@Ft@@)^@@)^@@1@@eں@@iDg8@@o@@v_ح@@sPH@@-V@@fA@@-@@@@;dZ@@;dZ@@rGE9@@@@@#@@-@@حV@@K]d@@@A YJ@A-w1@A@A$/@A$/@A	k~@A$/@A&x@An.@Au%F@A1'@AJL@AC,@Am\@A~@A ě@Au%F
@AQ_@A3@A6C@A~"@AI^@AI^@A,<@A͞&@A)_@As@AZ@AdZ@A]cA@An.3@A]cA@A*0U2@Aa@@A
=p@As@A9XbN@A`d@A_@ATɆ@A7@AQ@A%F
L@A5Xy>@A2a|@A?|h@AL_@Ace@A%@Ab@A
L/@As@A-@A&I@A@A&I@A쿱[W@AXe@A.H@AKƧ@ART`e@AXe,@AlC@A3@AحV@A#@A ě@AK]c@A҈p@A	*0U2a@A	@A	 ѷ@A	-w1@A	hr @A	hr @A	u!S@A	X@A	D@A	.H@A
u%F@A
Zc@A
ᰊ@A
@4@A
@A
sP@A
fB@Au%@AF]c@A]cA@AQ@A~($@A|@Aߤ@@A2W@A*1@A@AE@A
u@A
*0@A
m\@A
Xy=@A
O
@A
+j@A
b@A.2@Ac	@Avȴ9X@AO;@A@A2X@A҈p;@AFs@A!.I@A@A"@A
=p@AAs@A|hs@A[W>@A@A6@A-
q@AD*@AbM@Ar Ĝ@A˒:*@A@Au%F@AU@AU@A
(@Ae+@ArGE@ArGE@A@N@A0
)@A^@A|Q@Ab}@Al@AN;6@A-@A3@AZc@Au%F
@A`A@AC,@Ac	@AD@A~@A҉@A҉@APH@A&@A/V@AS@AQ@A*0U2@AZ@AƧ@A|@AƧ@A5Xy@As@A2W@A`d@AzG@ATɆ@A7@A@A/@AD@AV@A+a@A84֡@AB@AF
L0@AO;dZ@AfA@Aݗ@Av@AϪ͞@A(@Aڹ@A
L/@A($x@AOv_خ@A_ح@Afffff@A}Vl@AO;@A}Vl@Aȴ9X@A@A!.I@AFt@Av@A,@Av@A8}H@AXe,@A_o@Ab}V@AsPH@A	@A͞@A͞@A͞@A3@AK]d@AحV@AfA@A;dZ@A;dZ@AVϫ@AVϫ@ArGE9@A	ԕ+@A1&x@A-
@A@A9Xb@A9Xb@A)@AF@A҈p@A ѷ@AGz@A7Kƨ@An.@A|@A@A.H@A@AOv`@A)y@A-V@A^5?|@Aݘ@Aᰊ@AS&@A ě@A@AsP@AC,@A~@APH@A/V@AW>6z@AxF]@AMj@Awk@Aq@A6@A@A\N@A,<@AcA \@AN;@AS@AO
M@A*0@A>@A>@AK]@A'0@AV@Aqu"@A+a@AF
L0@AVl!@A`A7L@AjOv@Aݗ@A=K@A=K@AXy=@An/@AS@Au@A5?|@A1.@A+J@A}Vl@AQ@AIQ@A_ح@AiB@A@AϪ͟@A-@A,<@A|hs@A-V@Ar@ArG@A @A bM@A#@A;dZ@A@@AlC@AH˒:@A)^@AFs@Av@Ax@A6z@A1.@A!.@A8YK@Ab@A
qv@A(@AYJ@AQ@Aߤ?@A!.I@Aeں@A[W>@A @A >BZc@A @A!4J@A!u!S@A!k~(@A!JE@A!Dg8~@A!@A!@N@A!+@A!@N@A {@A \)@A!@A!@A!-w1@A!TɅo@A!@A!ᰉ'@A!.H@A"Ov`@A"#9@A"#9@A"1'@A"s@A"	 @A"@A"&IR@A"C\@A"W'@A"qiC@A"p:@A"\(@A"@A"ڹY@A"74@A#S&@A"m\@A"~@A#҉@A#	@A#&@A#)^	@A#33333@A#=K^@A#a@N@A#~$@A#@A#:)z@A#ߤ@A#@A#ݗ+k@A$1&y@A$M:@A$VϪ@A$g8}@A$~($x@A$?@A$N;@A$zxl"@A$O
M@A$?@A$?@A$#x@A$zG@A$Fs@A$?@A$Fs@A$Z1@A$cA \@A$g8}@A$zG@A$*1@A$zxl"@A$j~@A$/@A$Z@A$hr@A%K]@A%%F
L@A%5Xy>@A%84֡@A%O;dZ@A%S&@A%\@A%p
=@A%zxl"h@A%}H@A%U=@A%v@A%Xy=@A%1@A%8Y@A%@A%cA @A%?@A%b@A%S@A%,=@A%ᰉ@A&
(@A&8YJ@A&fffff@A&l!-@A&iB@A&z@A&z@A&IQ@A&%@A&IQ@A&}Vl@A&IQ@A&IQ@A&Fs@A&T@A&Q@A&Q@A&@A&m\@A&Ϫ͟@A&]cf@A&x@A&Mj@A&Mj@A'Ft@A'Xe@A''/W@A'>6z@A'Xe,@A'|hs@A'-V@A'&@A'vȴ9@A'r@A'vȴ9@A'o @A'@A(@A('RT`@A($xG@A(73@A(NU@A(|@A(n@A(-
@A(4m@A(ѷX@A(ѷX@A(҈p@A($tT@A)0
)@A)4J@A)7KƧ@A)[W>6@A)k~(@A)k~(@A)x@A)7Kƨ@A)R<6@A)'RTa@A)'R@A)y@A)N;6@A)e@A)>BZ@A)>BZ@A)R@A)s@A)-@A*u%F@A*n@A)lD@A*nO@A*@4@A*ݘ@A*@4@A*ݘ@A*\(@A*ᰊ@A*g	@A*)_@A*sP@A*䎊q@A*m@A+u%@A+&@A+/V@A+Q@A+҈@A,%1@A,64@A,M:@A,M:@A,PH@A,PH@A,SMj@A,PH@A,SMj@A,m8@A,O
M@A,#x@A,Z@A,E@A-L_@A-fA@A-+j@A-@A-%@A-=K@A-O
@A--V@A-@A-H˒@A-@A-n/@A-@A-cA @A-@A-@A-b@A.zG@A.+jg@A.5?|@A.H@A.\N<@A.c	@A.l!-@A.l!-@A.@A.$t@A.}Vl@A.Fs@A.qi@A.qi@A.$t@A.,<@A.-@A.-@A.af@A.T@A.T@A.-@A.-@A.}Vl@A.2X@A.2X@A.Mj@A.x@A/@A/@A/ hۋ@A/
M;@A/+I@A/+I@A/+I@A/1@A/1@A/4֡a@A/;dZ@A/KƧ@A/U=@A/y@A/	k@A/vȴ9@A/@A/@@A/Vϫ@A0F]d@A0@A0 ě@A06@A0Xy=@A0bM@A0˒:*@A0|@A0l"h	@A0r Ĝ@A0|@A0n@A0@A0-
@A09Xb@A09Xb@A0@A0{@A0ѷX@A0@A1_p@A1&x@A1*0U2a@A17KƧ@A17KƧ@A1Gz@A1JE@A1N;5@A1XbM@A1^@A1ae@A1ae@A1ae@A1o hی@A1b}@A1@A1n.@A1n.@A1(@A1'RTa@A1'R@A1e@A1lD@A2n@A1.H@A1Y}@A1-@A2s@A21'@A2)y@A2)y@A20U2a|@A2@4n@A2C\@A2M@A2^5?|@A2kP|@A2qiC@A2u%F
@A2@4@A2p:@A2L_@A20
@A20
@A2@A2 ě@A2͞&@A2C,@A2~@A3S&@A3҉@A3"`B@A3)^	@A3)^	@A39@A3C%@A3P{@A3g	l@A3jf@A3A@A3ߤ@A3q@A3~($@A3a@O@A3Ƨ@A4n.@A4"h	ԕ@A4/{J#@A49XbN@A4,<@A4]ce@A4#@A4qj@A4qj@A4N;@A4_@A4쿱[@A4쿱[@A43@A4TɆ@A4@A4֡a@A4@A4!-w@A5:@A5o i@A5K]@A5Q@A5?|h@A5IQ@A5S&@A5fA@A5m\@A5w1@A5$/@A5$/@A5ڹZ@A5=K@A5%@A5U=@A5@A5@A5H˒@A5@A5@A5cA @A5@A5@A58YK@A5ᰉ@A5(@A5,=@A5S@A5(@A5(@A5oiDg@A6
(@A6$/@A6!R<@A6@A6($x@A65?|@A6?@A6H@A6s@A6vȴ9X@A6z@A6IQ@A6+J@A6+J@A6$t@A6O;@A6@A6T@A6T@A6@A6҈p;@A6C-@A7@A7,@A7!-w1@A7!-w1@A7!-w1@A7$tS@A7'/W@A7'/W@A7'/W@A7$tS@A7$tS@A74֡a@A71@A78}H@A78}H@A7>6z@A7H˒:@A7U=@A7o@A7	k@A7zH@A7r@A7@A7Vϫ@A7حV@A7;dZ@A7#@A84m9@A8U2a|@A8l"h	@A8r Ĝ@A8˒:*@A8u!@A8˒:*@A8n@A8n@A8˒:*@A8|@A8n@A8@A8u%F@A8D@A8$tT@A8$tT@A9 ѷ@A9 ѷ@A9*0U2a@A9e+a@A9^@A9Q@A9TɅo@A9o@A9ᰉ'@A:I^5@A:#9@A:0U2a|@A:3@A:JL@A:JL@A:GE85@A:M@A:JL@A:Q_@A:M@A:Q_@A:W'@A:^5?|@A:a|Q@A:d7@A:^5?|@A:kP|@A:xl"h
@A:qiC@A:{m@A:ݘ@A:L_@A:ᰊ@A:ᰊ@A:0
@A:@A:}Vm@A:)_@A:`A@A:fB@A:D@A:C,@A:c	@A:m@A;u%@A;PH@A;PH@A;)^	@A;&@A;33333@A;9@A;6z@A;C%@A;F]c@A;C%@A;J#9@A;MjO@A;MjO@A;F]c@A;@N@A;F]c@A;J#9@A;F]c@A;P{@A;Z@A;Z@A;a@N@A;n.3@A;Q@A;ߤ@A;~($@A;a@O@A;|@A;
=p@A;g@A;s@A;\N@A<n.@A<L_@A<tj@A<Q@A<"h	ԕ@A<"h	ԕ@A<`d@A<#@A<_@A<S@A<3@A<1&@A<@A<g8}@A<VϪ@A<M:@A<M:@A<PH@A<C,zx@A<,<@A<%1@A<!-w2@A<,<@A</{J#@A<2W@A<9XbN@A<M:@A<C,zx@A<M:@A<PH@A<VϪ@A<Z1@A<`d@A<m8@A<m8@A<g8}@A<m8@A<tSM@A<zG@A<?@A<N;@A<*1@A<S@A<3@A<O
M@A<O
M@A<1&@A<O
M@A<j~@A<Z@A<@A<@A<*0@A<֡a@A<Z@A<*0@A<>B[@A<>B[@A<Z@A<>B[@A=qu"@A=V@A=!.H@A=Q@A=!.H@A=\@A=p
=@A=p
=@A=jOv@A=fA@A=\@A=zxl"h@A=zxl"h@A=$/@A=}H@A=w1@A=M:@A==K@A=v@A=Xy=@A=Xy=@A=Xy=@A=Xy=@A=U=@A=v@A=@A=@A=@A=\(@A=H˒@A=@A=\(@A=@A=b@A=C\@A> ѷY@A=ڹ@A=!.@A> ѷY@A>
(@A>@A>4K@A>4K@A>4K@A>@A>!R<@A>($x@A>($x@A>1.@A>?@A>L/{J@A>Ov_خ@A>Vu@A>fffff@A>}Vl@A>+J@A>qi@A>@A>@A>'@A>@A>ߤ?@A>C-@A>C-@A>C-@A>C-@A>C-@A>쿱[W@A>@A>Mj@A>Fs@A?Ft@A?
=p@A?
M;@A?
M;@A?Xe@A?E84@A?U=@A?\(@A?eں@A?eں@A?eں@A?iDg8@A?lC@A?iDg8@A?y@A?{J#:@A?|hs@A?4m@A?&@A?O;d@A?$tS@A?$tS@A?	k@A??@A?͞@A?vȴ9@A?/V@A?@A?@A?K]d@A?fA@A?+j@A?+j@A?rGE9@A?#@A@	ԕ+@A@bM@A@*0U@A@}H@A@}H@A@*0@A@4m9@A@*0@A@'RT`@A@$xG@A@'RT`@A@'RT`@A@-
q@A@1&x@A@73@A@4m9@A@-
q@A@>BZc@A@bM@A@bM@A@r Ĝ@A@y=c@A@|@A@n@A@˒:*@A@@A@tj@A@@A@@A@IQ@A@
=q@A@-
@A@U@A@)@A@
(@A@ѷX@A@F@A@D@A@ѷX@A@ѷX@A@`A7@A@{@A@\)@A@{@A@4֡b@A@\)@A@	k@A@$tT@AA ѷ@AA ѷ@AA$/@AA@AA_p@AA_p@AA [7@AA [7@AA0
)@AA4J@AA:S@AAJE@AATɅo@AAXbM@AA^@AA^@AAae@AA|Q@AA@AA@AA'RTa@AAl@AA@AAD@AAD@AA2W@AAy@AAy@AAN;6@AA@AA@AAR@AA@AA-@AAY}@AB1'@ABs@AB1'@AB6C@AB=p
@AB=p
@AB@4n@ABC\@ABGE85@ABJL@ABGE85@ABC\@ABM@AB^5?|@ABZc@ABh	ԕ@ABd7@ABxl"h
@AB@4@ABݘ@AB0
@AB0
@ABwkQ@AB ě@ABg	@ABY@AB<64@AB͞&@ABn@AB͞&@AB͞&@ABڹY@AB䎊q@ABfB@ABC,@ABfB@ABD@ABm\@ACu%@AC'/@AC҉@AC'/@ACs@ACC,z@ACC,z@AC"`B@ACC,z@AC,zxl@AC@N@ACP{@ACg	l@ACtj~@ACA@ACU=@ACU=@ACU=@ACwk@AC*0U2@AC*0U2@AC@AC|@AC5Xy@AC@ACa@O@ACݗ+k@AC%2@ACC]@ACC]@ACA [@ACC]@AC@ACs@ACs@ADxF@ADQ@ADxF@AD(\@AD(\@AD9XbN@AD2W@AD?@AD9XbN@ADSMj@ADVϪ@ADM:@ADM:@ADg8}@ADq@ADwkP@ADC@AD?@AD*1@ADS@ADS@ADS@AD쿱[@ADzxl"@AD?@AD?@AD7@ADɅoi@ADZ@AD*0@AD>B[@AD@ADD@AD!-w@AD!-w@AD!-w@ADhr@ADe@ADe@AE[@AE!.H@AE/w@AE%F
L@AE/w@AE5Xy>@AE<64@AE?|h@AEF
L0@AEF
L0@AEF
L0@AE?|h@AEL_@AEL_@AEIQ@AEO;dZ@AEVl!@AEVl!@AEݗ@AEhr!@AE+j@AEO
@AEhr!@AEhr!@AEO
@AE=K@AE+j@AE+j@AE@AE@AE=K@AE%@AE%@AE%@AEU=@AE-V@AE\(@AE@AE@AE
qv@AEE@AEC\@AEoiDg@AEE@AFt@AF_o @AFt@AF_o @AF4K@AF4K@AF
(@AFu@AFu@AFu@AF!R<@AF$/@AF!R<@AF$/@AF1.@AF8YJ@AFL/{J@AFYJ@AFp:~@AFqi@AFaf@AFaf@AF-@AFaf@AF@AF2X@AF'@AFߤ?@AFߤ?@AF@AFA@AF+@AFϪ͟@AF҈p;@AF+@AF]cf@AFߤ?@AFC-@AFx@AF쿱[W@AF쿱[W@AF"@AG hۋ@AG@AG
M;@AG)^@AG@AG@AGv@AG!-w1@AG$tS@AG'/W@AG$tS@AG'/W@AG1@AG1@AG1@AG4֡a@AGH˒:@AGH˒:@AGRT`e@AGlC@AGv_ح@AGsPH@AGݗ+@AGݗ+@AG$tS@AGkP@AG?@AG?      @AG@AG;dZ@AG;dZ@AG@@AGrG@AG@@AGVϫ@AH@AHbM@AH
qu@AH*0U@AH6@AH*0U@AH}H@AH}H@AH6@AH}H@AH ě@AH*0@AH1&x@AH4m9@AH4m9@AHD*@AHNU@AHQ@AHU2a|@AHU2a|@AHeO@AHhۋq@AHu!@AHy=c@AHn@AH˒:*@AHn@AHYJ@AHYJ@AHn@AH'RT@AH-
@AHtj@AH-
@AH@AHu%F@AH@AHd8@AHU@AH@AH4m@AHTɅ@AHěT@AHěT@AHD@AHD@AHѷX@AHۋq
@AH@AH`A7@AH4֡b@AH	k@AH\)@AHPH@AH$tT@AHPH@AH	k@AHPH@AHPH@AHPH@AH$tT@AI$/@AI	k~@AI	k~@AI@N@AI@AI@AI#w@AI#w@AI [7@AI-w1@AI0
)@AI:S@AI=b@AIQ@AIQ@AIDg8~@AITɅo@AITɅo@AIe+a@AIk~(@AIo hی@AI|Q@AIx@AIx@AIx@AIx@AIoiD@AI7Kƨ@AIoiD@AIoiD@AI@AI@AI@AIR<6@AIR<6@AIR<6@AI@AI@AIu@AI(@AID@AID@AIy@AIy@AIԕ*@AIԕ*@AI"`@AI"`@AI"`@AIԕ*@AI.H@AJu%F@AJn@AJn@AJ	 @AJ	 @AJ@AJ@AJ@AJ䎊@AJ-V@AJC\@AJQ_@AJT`d@AJZc@AJh	ԕ@AJkP|@AJh	ԕ@AJkP|@AJu%F
@AJ@4@AJ~"@AJ@4@AJL_@AJp:@AJ@4@AJp:@AJ\(@AJL_@AJwkQ@AJS&@AJ@AJ)_@AJ`A@AJڹY@AJڹY@AJG{@AJ䎊q@AJm@AKI^@AKI^@AKI^@AKS&@AKS&@AK"`B@AK,zxl@AK=K^@AK@N@AK@N@AK@N@AKW>6z@AKZ@AK]cA@AKa@N@AKa@N@AKtj~@AKtj~@AKxF]@AK{J#9@AKtj~@AK~$@AK{J#9@AKeO@AKq@AK:)z@AK:)z@AKU=@AKߤ@AKS@AKS@AKS@AK@AK@AK*0U2@AKm]@AKE@AK6@AKƧ@AKƧ@AK6@AKa@O@AKa@O@AK@AK5Xy@AK5Xy@AK5Xy@AK|@AK5Xy@AK|@AK
=p@AKݗ+k@AK҈@AKݗ+k@AK҈@AKC]@AKA [@AK@AK@AK@AK$@AK$@AK@AK@AL1&y@AL1&y@ALxF@ALL_@ALQ@AL"h	ԕ@AL%1@AL%1@AL(\@AL64@AL<쿱@AL<쿱@ALC,zx@ALC,zx@ALFs@ALC,zx@ALFs@AL?@ALZ1@ALPH@ALVϪ@ALPH@ALI^5?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       @rP     @rL@rP     @rT@rS33333@rP     @rI@rNfffff@rNfffff@rI@rD@r8     @r(     @r@rfffff@r@rfffff@rS33333@r     @rfffff@r@rfffff@r@rfffff@rə@rə@rə@r33333@rfffff@r@r33333@rfffff@s@r񙙙@r@r@rfffff@s     @s     @s@s@r     @r@r@r     @r     @r33333@r     @r     @rə@r@r     @rfffff@r     @r     @r33333@r@r33333@r@r@rљ@rљ@rə@r@r33333@r     @r33333@r@r@r@rfffff@r     @r@r33333@r     @r     @r@rY@rY@rX     @rT@rQ@r>fffff@rfffff@q@q33333@q{33333@qT@pfffff@p@p     @p@pfffff@py@pi@pNfffff@p!@offfff@offfff@o9@n@nvfffff@n33333@mfffff@l@     @i@i33333@i陙@i     @ifffff@i6fffff@e@eə@e@eY@e#33333@e<@e)@e	@d33333@dfffff@dfffff@də@d     @dl@dL@d333333@d@d      @c33333@c@c33333@c     @c@c     @c33333@cy@cp     @c\@c@b@bfffff@b     @bl@bi@bl@b`     @b<@b33333@afffff@a33333@afffff@a@a@a@ay@as33333@as33333@ap     @al@aY@a,@a      @a      @a@a@`33333@`fffff@`33333@`     @`@`     @`@`fffff@`@`33333@`     @`ٙ@`     @`@`@`@`@`@`33333@`33333@`     @`     @`@`ə@a	@afffff@a@afffff@a@`@`@_     @_33333@`	@`	@`      @_ٙ@_     @_ffffff@_@     @_      @_,@_@     @_@     @_      @_@_fffff@^fffff@^Ffffff@^L@^@     @^9@^333333@^,@]     @]@]S33333@]9@]&fffff@]@]fffff@\@\y@\S33333@\Ffffff@\333333@\,@\,@\&fffff@\fffff@[@[33333@[@[fffff@[     @[l@Yٙ@Y@Y@Ys33333@Y`     @Y@Ys33333@Zy@Zfffff@Z33333@Zٙ@Z@Z@Z@     @Z@     @Z@     @Z@     @Y@Xfffff@X@     @W@W@V@Vy@V@     @V@U@U@U33333@Uٙ@U33333@T@Tfffff@T     @TS33333@S33333@Sfffff@SY@SFfffff@SFfffff@S@     @S@Rfffff@R     @R@R@R@Rl@RY@Rl@Rs33333@Rs33333@Rs33333@Rl@Q     @Q     @Q@Q     @Q@Q      @P     @P@P     @Pfffff@P@P@Pfffff@P@Ps33333@P     @P@P@P33333@Pfffff@P33333@P@P      @P&fffff@P&fffff@P&fffff@Offfff@O@Offffff@OY@OY@OL@O@N33333@N33333@N33333@N33333@Nfffff@N@M@Ms33333@M     @M@M     @Mٙ@Mٙ@M@M@M&fffff@M333333@M333333@M@L33333@L33333@Lٙ@Lfffff@L     @Ls33333@Ls33333@Lffffff@LY@L@Kfffff@Kfffff@K33333@L      @K33333@K33333@K33333@K     @K@K@K@Kfffff@J@Jffffff@JY@Jffffff@Jffffff@JY@JL@I@IL@IY@Iffffff@I@     @Hٙ@H@HL@Hffffff@H     @H33333@H@H33333@HL@H@     @HL@HL@HL@G     @Gfffff@G33333@G     @Gٙ@Gfffff@Gfffff@G@G      @F33333@Fٙ@F@Fٙ@F      @E33333@F@F&fffff@FL@FL@Es33333@Effffff@EY@EL@E@Dٙ@Dfffff@D333333@Cfffff@Cfffff@C33333@D      @Cٙ@C33333@Cffffff@C@     @C333333@C&fffff@C@B33333@Bfffff@B     @B     @Bffffff@B@A@Aٙ@Aٙ@Aٙ@A&fffff@A@A@A@A      @@fffff@@ffffff@@L@@@     @@333333@@      @?33333@?     @?333333@?      @?      @?      @>     @=     @=333333@<fffff@<fffff@=@=ffffff@=     @;@;@;@;@;@;ffffff@:@:333333@:@:      @:      @:      @9@9L@9L@9333333@9L@9@8fffff@8@8L@8      @733333@733333@7@7ffffff@7ffffff@7L@7L@7333333@7@7      @6@633333@6@6@6     @6L@6@6@6333333@6333333@6      @5L@5333333@5@5      @433333@4     @4     @4     @4ffffff@4ffffff@4ffffff@4333333@4333333@4@4@4      @4      @3@3     @3     @3     @3     @3ffffff@3@2fffff@2@233333@2@2@2@2L@2L@2      @2      @2@2@2@2333333@1@1     @1@1@1     @1ffffff@1333333@1333333@1@1333333@1      @1@0fffff@0@0     @0     @0@0     @0     @0ffffff@0ffffff@0ffffff@0L@0L@0L@0333333@0333333@0@0@0      @0      @0      @0      @0      @0      @0      @/@/ffffff@/ffffff@/333333@/333333@.@.@.@.333333@.ffffff@.ffffff@.@.      @-ffffff@-ffffff@-ffffff@,@-      @-333333@-      @,@,ffffff@,ffffff@,ffffff@,333333@,333333@,333333@,      @+@+@+@+@+@+@+@+      @+      @+      @+      @+333333@+333333@+ffffff@*      @*      @*      @*333333@)@)@)@)ffffff@)@)@)ffffff@)@)@)@)ffffff@)      @)      @)      @)      @)      @)      @(@(@(@(@(@(      @(333333@(@(@(@(@(ffffff@(333333@(      @(      @(      @(      @(      @'      @'      @'333333@'333333@'ffffff@'ffffff@(      @(@(@(@(@)333333@)333333@)@*      @*333333@*333333@*      @)@)333333@)      @(@(@(@(333333@&@&@&ffffff@&      @&333333@&ffffff@&333333@&333333@&ffffff@&ffffff@&333333@&@&@&ffffff@&@&ffffff@&333333@&      @&ffffff@&      @&      @%@%@%@%@&      @%@%@%@%@%@%@%ffffff@%ffffff@%@%ffffff@%333333@%ffffff@%333333@%333333@%ffffff@%333333@%333333@%333333@%ffffff@%333333@%333333@%333333@%333333@%      @%333333@$@$@$@%      @$@$@$@$ffffff@$ffffff@$@$ffffff@$@$@$@$@%      @$@%      @$@$@%      @$@$@$@$@$@$@$@$@$@$ffffff@$@$@$ffffff@$ffffff@$@$@$ffffff@$@$@$@$ffffff@$333333@$@$@$ffffff@$ffffff@$ffffff@$@$ffffff@$ffffff@$333333@$ffffff@$@$ffffff@$333333@$      @$      @$      @$ffffff@$ffffff@$333333@$ffffff@$      @$333333@$      @$333333@$      @$333333@$333333@$333333@$      @$333333@$      @$      @$      @$333333@$      @$      @$      @#@$333333@$      @$      @$      @$      @#@#@$      @#@$      @#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#ffffff@#@#@#@#@#@$      @#@#ffffff@#@#@$      @#@#@#@#@#@#@#@#@#@#@#@#@#@#@#ffffff@#ffffff@#@#ffffff@#@#ffffff@#333333@#@#ffffff@#ffffff@#333333@#ffffff@#333333@#ffffff@#ffffff@#ffffff@#333333@#333333@#333333@#ffffff@#@#333333@#333333@#      @#@#@#ffffff@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@$      @#@#@$      @#@$      @$      @#@$      @#@#@#@#@$      @$333333@$      @#@$333333@$      @$333333@$333333@$      @$333333@$333333@$      @$333333@$@$      @$333333@$333333@$ffffff@$333333@$ffffff@$333333@$333333@$ffffff@$ffffff@$333333@$ffffff@$@$@$ffffff@$@$@$@$ffffff@$ffffff@$@$@$@$@$@$@$@$@$@$@$@$@%      @%      @%333333@%333333@$@%333333@%      @%333333@%333333@%333333@%333333@%      @%333333@%333333@%ffffff@%333333@%333333@%333333@%333333@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%@%ffffff@%@%@%@%@%ffffff@&      @&      @%@%@%@%@%@&      @%@&ffffff@&      @&333333@&      @&333333@&      @&      @&333333@&333333@&ffffff@&@&333333@&333333@&ffffff@&ffffff@&@&@&333333@&@&@&@'      @&@&@&@&@'333333@'333333@'ffffff@'333333@'333333@'333333@'ffffff@'@'@'ffffff@'@'ffffff@'@'@'@'@'@(      @'@'@(      @(333333@(333333@(333333@(333333@(333333@(ffffff@(ffffff@(@(ffffff@(ffffff@(@(@(ffffff@(@(@(@(@(@(@(@(@(@(@(@)      @(@(@(@(@)      @)333333@)ffffff@)333333@)333333@)ffffff@)333333@)@)ffffff@)@)@)@)@)@)@*333333@*333333@*ffffff@*333333@*333333@*333333@*@*333333@*@*ffffff@*333333@*ffffff@*ffffff@*ffffff@*@*@*@*@*@*@*@+ffffff@+333333@+ffffff@+ffffff@+333333@+333333@+ffffff@+@,      @,333333@,ffffff@,ffffff@,ffffff@,333333@,      @,ffffff@,@,ffffff@,@,ffffff@,@,ffffff@-      @-ffffff@-      @-333333@-ffffff@-@-@-@.333333@.ffffff@.@/      @/@/ffffff@/@/ffffff@/333333@/@0      @/@0      @/@/@/@0@0      @0@0      @0@0333333@0@0333333@0@0333333@0333333@0L@0L@0L@0L@0L@0@033333@033333@0@0     @0@0@033333@0@0fffff@0@0fffff@1@0fffff@1@1@1@1@1      @1@1      @1@1@1      @1@1@1@1@1333333@1@1L@1     @1@133333@133333@1@133333@1fffff@2      @2      @2@2      @2333333@2333333@2      @2333333@2ffffff@2     @233333@2@2@2@2@2@2     @2ffffff@2L@2     @2L@2333333@2333333@2333333@2333333@2ffffff@2ffffff@2L@2L@2ffffff@2L@2     @2     @2@2ffffff@233333@2@2@2@2@2@2@233333@2@2@2fffff@3      @2fffff@2fffff@3@3@3      @3333333@3@3      @3      @3333333@3@3      @3@3333333@3L@3ffffff@3     @3     @3ffffff@3L@3333333@4333333@4@4      @3fffff@3fffff@3fffff@4@4@4@4      @4333333@4333333@4L@4     @4     @4ffffff@4L@4     @4     @4ffffff@4     @4@4@4@4@4@4@5      @4fffff@5      @5      @4fffff@4@5      @5      @5      @5      @5333333@5@5333333@5333333@5L@5L@5L@5L@5     @5@533333@533333@5@5@6@6@6333333@6@6L@6L@6     @6     @6ffffff@6     @6     @6@6     @6@6@6@6fffff@7      @7      @7L@7333333@7     @7ffffff@7L@7ffffff@7     @7ffffff@7@7@733333@733333@733333@7@7@7@7@7fffff@8@8333333@8@8333333@8333333@8ffffff@8ffffff@8ffffff@833333@8     @8@8@8     @9      @8@8@8@8@9@9333333@9      @9@9@9      @9333333@9@9@9@9333333@9333333@9     @9     @9@933333@933333@9@:      @933333@9fffff@:      @:      @:      @:      @9fffff@:@:ffffff@:ffffff@:L@:     @:     @:     @:ffffff@:333333@:@:@:33333@:33333@:@:@:fffff@;      @;      @;      @;333333@;333333@;L@;333333@;L@;ffffff@;L@;     @;@;@;@;@;@;@;33333@<      @<@<@<@<      @<33333@<@<fffff@<@<33333@<@=@=333333@=333333@=@=@=333333@=333333@=33333@=@=@=fffff@>      @>      @>      @>      @>@>@=@>      @>333333@>333333@>333333@>333333@>@>@>@>@>33333@>33333@?      @>@>fffff@?ffffff@?ffffff@?333333@?333333@?L@?333333@?@?     @?     @?@?@?@@      @@@@@@      @@@@@@@@@@@@&fffff@@L@@ffffff@@ffffff@@L@@Y@@fffff@@     @@33333@@     @@     @@     @@fffff@@33333@@33333@@33333@@33333@@fffff@A@A@A&fffff@A&fffff@A@A@A333333@A333333@A@     @A&fffff@A&fffff@A333333@Affffff@AL@Affffff@AY@A@     @A@     @Affffff@As33333@As33333@A     @A@A     @A33333@Afffff@A33333@A33333@A33333@Afffff@Afffff@Aٙ@Afffff@B333333@B333333@B@     @B@B@B&fffff@BY@Bs33333@Bs33333@Bffffff@Bffffff@B     @Bffffff@B33333@B@Bfffff@Bfffff@B@B33333@Bfffff@Bfffff@B33333@Bfffff@C      @Bfffff@Bfffff@B33333@Bfffff@C      @C      @C      @C      @B33333@CY@Cffffff@Cs33333@Cs33333@Cffffff@C     @Cs33333@Cs33333@Cffffff@C     @Cs33333@C     @Cs33333@Cs33333@C     @C@C@Cfffff@C33333@C@C33333@Cfffff@C33333@C33333@Cfffff@D@D@D@D&fffff@D@D&fffff@D@D333333@D&fffff@D@D&fffff@D@     @D333333@DY@Dffffff@Dffffff@Ds33333@DY@D@Dٙ@Dfffff@Dٙ@Dfffff@D     @D     @Dfffff@Dfffff@D33333@E      @E@E@E333333@E&fffff@E@E@Effffff@EY@Es33333@Es33333@Effffff@Es33333@Effffff@E33333@Efffff@E@E@E@Efffff@E     @E@E@Eٙ@Eٙ@E     @E     @E@Efffff@F@Efffff@F&fffff@F@     @F&fffff@F&fffff@F333333@F333333@F@F@F@F@Fffffff@Fffffff      @Ffffff@Ffffff@Ffffff@F@Fٙ@F33333@G      @G      @G&fffff@GY@G@     @G@     @GY@GL@Gffffff@G     @Gffffff@G333333@G     @G     @Gs33333@G@G     @G@G@G     @Gfffff@G33333@H      @G33333@Gٙ@H@H      @H@H@H@H@H&fffff@H&fffff@H&fffff@H@H333333@HY@Hffffff@HY@H@     @HL@Hffffff@H     @Hfffff@H@H@H@H@H33333@H@H@H     @Hٙ@H33333@Hٙ@H33333@Hٙ@H33333@H33333@H33333@I      @I@I      @I@I@I@I333333@I&fffff@I@I&fffff@I&fffff@IY@I     @Is33333@Is33333@Iffffff@IY@IY@I33333@Ifffff@Ifffff@I@I@Ifffff@I@Iٙ@Iٙ@I33333@I33333@Ifffff@Ifffff@Iٙ@I33333@J      @J      @J@J@J@J@J@J&fffff@J@     @J@     @J@     @J333333@J333333@Jffffff@JY@JY@JL@JY@JY@Jfffff@J     @J33333@J@J@J33333@J     @J     @Jٙ@K      @K@K@K@K@KY@KY@Kffffff@Kffffff@K@     @K@     @K     @K@Kffffff@K     @K@K@K@K@K@K@Kfffff@L      @L@L&fffff@L@L&fffff@L      @LL@LY@LL@LL@Ls33333@L     @LL@L33333@L     @L33333@Lٙ@L     @L@M@M&fffff@M@M@M      @M@     @M@     @M333333@M@     @M@     @M     @ML@M     @M@Mfffff@M@M@M@M33333@Mfffff@M     @M     @M33333@M33333@Mٙ@Mfffff@Mٙ@Mfffff@M33333@M33333@M33333@M33333@M33333@M33333@N@N      @M33333@N      @N@N&fffff@N&fffff@N&fffff@N333333@N@     @N&fffff@N@NL@NY@NL@NY@NL@NL@NL@Ns33333@N@N@N     @Ns33333@N@Nfffff@Nfffff@Nfffff@N@N@N@Nfffff@Nfffff@Nfffff@Nfffff@Nٙ@Nٙ@O@O@O@O      @N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ?nP?hr Ĝ? ě?tj~?GzH?x?+J?E?+J?Ƨ-?vȴ9X?$/?I^5?}?-V?QR?vȴ9X?~"?tj?      ?ffffff?GzH?333333?I^5?}?hr!?tj?nP?r ě?Q?S?j~#?^5?|?\(?^5?|?|hr?\(?E?`A7L?S?E?Vt?-V?nO;?GzH?=p
=?A7Kƨ?-V?+I?/v?Ƨ-?/v?E?^5?|?lC?l?tj?Vu?GzH?Q?n?E?7KƧ?;dZ?1&x?;dZ?
=p?9XbN?M?O;dZ?hr ?o?n? ě?E?S?I^5??E?$/?vȴ9X?7KƧ?O;dZ?7KƧ?I^5??ȴ9Xb?Q?$/?m?E?zG{?ݑhr ?Q?"`?|hr?ěS?|hr?Ցhr ?Լj~#?zG{?zG{?Ƨ-?Z1'?C$?д9XbN?zG?vȴ?Ͼvȴ9X?Ͳ-V?lC?ǮzG?ǮzG?7KƧ?I^5?}?ʟvȴ9?+I^?ǍO;dZ?r ě?ǍO;dZ?x?Ƨ-?$/??|hs?öE?zG{?ļj~#?ffffff?
=p?9XbM?Z1'?öE?$/?/w?\(?Õ$/?/w?öE?nO?I^5??`A7?Q?I^5??M?M?&x?
=p?tj~?\(?
=p?Q?n?I^5??° ě?-V?`A7?
=p?hr Ĝ?lD?7KƧ?`A7?`A7?7KƧ?`A7L?I^5??M?GzH?
=p?-V?+I^?ěS?zG{?`A7?/w?\(?nO?`A7?7KƧ?hr Ĝ?7KƧ?$/?n?I^5??\(?nP?I^5??ěS?\(?nO;?tj~?öE?bM?I^5??Z1'?tj~?nP?nO;?A7Kƨ?\(?° ě?Õ$/?nO;?9XbM?n?nP?M?n?\(?333333?9XbM?A7Kƨ?ěS?\(?ěS?\(?
=p?j~"?j~"?bM?GzH?`A7L?&x?7KƧ?l?bM?tj~?7KƧ?$/?GzH?lD?tj?&x?nP?`A7?ěS?A7Kƨ?7KƧ?7KƧ?° ě?&x?+?ěS?`A7L?\(?-V?Õ$/?A7Kƨ?I^5??I^5??ěS?7KƧ?nO?nO;?nO?lD?° ě?tj~?I^5??-V?&x?M?Q?n?M?S?° ě?S?öE?hr Ĝ?nO;?lD?`A7?ěS?
=p?zG{?l?ěS?-V?
=p?333333?l?Õ$/?Q?
=p?+?M?\(?333333?vȴ9X?hr Ĝ?+?5?|h?&x?n?Õ$/? ěT?° ě?S?tj~?9XbM?lD?7KƧ?I^5??7KƧ?° ě?333333?lD?nO;?S?-V?
=p?\(?|hr?n?$/?`A7L?bM?\(?Q?-V?"`?A7Kƨ?-V?-V?nP?$/?-V?tj~?° ě?+?tj~?`A7?-V?tj~?-V?\(?
=p?I^5??nO?tj~?Ł$/?
=p?&x?nO?7KƧ?-V?nO;?`A7L?öE?`A7?nO?nO?lD?nO?nO;?
=p?Q?Q?nO?ěS?n?n?° ě?-V?nO;?S?Õ$/?lD?Õ$/?lD?`A7?A7Kƨ?\(?vȴ9X?Õ$/?$/?Q?
=p?`A7?tj~?ěS?\(?\(?n?° ě?tj~?9XbM?öE?ěS?333333?nO?n?`A7?tj~?Q?l?M?nO;?tj~?A7Kƨ?lD?333333?/w?Õ$/?$/?
=p?Q?GzH?9XbM?333333?nO?° ě?hr Ĝ?/w?šo?lD?Õ$/?M?+?9XbM?333333?nO?ļj~#?nO;?`A7L?nO;?l?-V?tj?nO;?`A7?nO;?M?\(?ěS?° ě?öE?nO?+?Õ$/?$/?tj?-V?nO?&x?-V?nO;?Õ$/?nO?hr Ĝ?&x?Q?ěS?S?I^5??I^5??tj?nO?° ě?`A7?S?7KƧ?M?S?\(?I^5??7KƧ?-V?+?+?bM?öE?9XbM?333333?333333?+?öE?tj?Z1'?n?\(?`A7L?l?`A7L?hr Ĝ?Q?-V?$/?nP?S?&x?GzH?`A7L?öE?l?nO;?ěS?Õ$/?S?l?`A7L?\(?Õ$/?Z1'?hr Ĝ?S?nO?Q?M?lD?\(?/v?M?-V?nO;?S?333333?l?      ?\(?nO;?° ě?S?nO?l?ļj~#?öE?333333?zG{?\(?M?\(?+?nO?lD?\(?-V?nO?\(?nO?zG{?`A7?333333?
=p?l?M?I^5??E?\(?S?S?-V?hr Ĝ?lD?Q?$/?° ě?Õ$/?l?l?bM?E?l?Õ$/?I^5??l?ěS?Õ$/?9XbM?ěS?7KƧ?9XbM?$/?öE?öE?tj~?333333?333333?nO;?lD?GzH?+?zG{?S?S?-V?7KƧ?Õ$/?zG{?M?-V?9XbM?ļj~#?9XbM?tj?tj~?tj~?-V?zG{?tj?Q?Õ$/?Z1'?`A7?Õ$/?Õ$/?nO?l?l?`A7?I^5??7KƧ?hr!?S?ěS?-V?zG{?`A7?ěS?9XbM?-V?° ě?l?nO?Õ$/?
=p?7KƧ?nO;?tj?Q?n?-V?bM?\(?M?\(?\(?° ě?l?I^5??9XbM?nO?M?E?Õ$/?nP?$/?hr Ĝ?I^5??GzH?-V?nO;?öE?I^5??\(?l?tj~?° ě?n?Q?
=p?ļj~#?333333?n?° ě?S?`A7?+?333333?-V?tj~?+?Z1'?lD?M?\(?M?333333?° ě?tj~?`A7?Q?S?l?\(?-V?Z1'?Õ$/?l?
=p?S?S?GzH?333333?\(??|hs? ěT?GzH?Q?\(?° ě?Q?öE?nO?n?öE?I^5??\(?\(?M?nO;?° ě?`A7?-V?l?S?`A7?l?l?nO?+?l?+?/w?Q?hr Ĝ?\(?tj~?E?tj?l?ļj~#?\(?7KƧ?tj?ļj~#?Q?lD?l?ěS?I^5??A7Kƨ?ěS?° ě?E?ļj~#?ěS?GzH?vȴ9X?333333?7KƧ?hr!?M?zG{?`A7L?-V?n?Õ$/?lD?Q?Z1'?E?Z1'?S?tj~?nO?n?n?S?hr Ĝ?tj~?\(?-V?zG{?nO;?-V?E?ffffff?333333?Q?öE?Q?ěS?I^5??\(?
=p?° ě?° ě?Õ$/?tj?\(?M?bM?`A7L?
=p?lD?\(?° ě?-V?ěS?nO?-V?9XbM?&x?\(?lD?lD?l?7KƧ?Q?M?&x?nO?
=p?tj?S?nO??|hs?Õ$/?I^5??I^5??° ě?S?Õ$/?° ě?333333?zG{?S?M?5?|h?l?`A7?\(?n?Z1'?nO?\(?Q?+?zG{?-V?+?tj?tj?Q?ļj~#?M?333333?333333?GzH?M?+?ěS?+?Q?ěS?E?l?333333?9XbM?l?Z1'?Õ$/?333333?öE?E?ěS?ěS?šo?
=p
?+?$/?nO?nO?l?333333?9XbM?M?Z1'?nP?
=p?-V?Z1'?tj?333333?M?n?tj~?333333?-V?S?
=p?° ě?lD?M?° ě?I^5??`A7?GzH?tj~?9XbM?öE?nO?7KƧ?9XbM?333333?n?-V?-V?° ě?\(?+?9XbM?-V?šo?333333?M?n?Õ$/?tj?öE?`A7??|hs?nO?`A7?&x?9XbM?tj~?öE?E?\(??|hs?$/?tj~?+?`A7?A7Kƨ?M?Ł$/?M?zG{?° ě?n?-V?9XbM?nO?S?nO;?nO?öE??|hs?`A7?öE?öE?I^5??;dZ?M?öE?ļj~#?l?tj~?tj~?Q?n?I^5??-V?lD?ěS?/w?Q?I^5??`A7?9XbM?E?\(?/w?
=p?vȴ9X?+?S?nO;?Õ$/?333333?I^5??&x?&x?nO?\(?-V?M?9XbM?333333?-V?333333?Z1'?9XbM??|hs?9XbM?\(?M?
=p?tj~?öE?nO;?+?M?I^5??zG{?-V?° ě?n?nO?tj?$/?l?333333?S?M?tj~?E?n?333333?nO;?Ł$/?+?Z1'?+??|hs?9XbM?nO;?M?E?S?ǮzG?E?l?333333?\(?S?nO?ļj~#?ěS?`A7?-V?-V?lD?-V?Q?öE?ļj~#?tj~?333333?-V?šo?S?ffffff?E?Z1'?° ě?-V?hr Ĝ?ěS?tj~?I^5??nP?`A7?7KƧ?$/?tj~?+?I^5??`A7L?ěS?`A7K?+?+?ěS?Õ$/?Q?Õ$/?ěS?9XbM?ěS?öE?
=p?$/??|hs?9XbM?A7Kƨ?l?Q?S?M?\(?nO;?zG{?9XbM?l?° ě?$/?9XbM?tj?nO?vȴ9X?Õ$/?n?S?nO?° ě?Õ$/?tj?zG{?l?-V?hr Ĝ?l?`A7?ļj~#?-V?-V?nO?öE?/w?9XbM?`A7L?7KƧ?tj?Õ$/?tj~?I^5??I^5??öE?Õ$/?I^5??
=p?-V?S?
=p?l?l?-V?\(?öE?-V?+?/w?öE?`A7?S?
=p?-V?Õ$/?-V?tj~?I^5??nO?Z1'?n?tj?öE?&x?9XbM?S?tj?+?/w?Z1'?\(?nP?tj~?$/?M?E?+?zG{?l?Q?"`?Õ$/?tj?ļj~#?`A7?`A7K?`A7K?° ě? ěT?Ł$/?Z1'?n?\(?nO?-V?+?Z1'?tj?n?Q?n?Õ$/?-V?`A7?Õ$/?\(?7KƧ?`A7?E?lD?hr Ĝ?l?I^5??lD?tj~?-V?l?° ě?tj~?n?/w?Z1'?Q?lD?-V??|hs?Z1'?tj?Q?
=p?Õ$/?° ě?öE?-V?`A7?-V?-V?GzH?-V?tj~?° ě?I^5??M?ffffff?Q?öE?lD?° ě?7KƧ?9XbM?/w?nO;?° ě?I^5??9XbM?hr Ĝ?ěS?° ě?Õ$/?333333?nO?
=p?&x?l?M?-V?bM?bM?Q?ěS?° ě?E?`A7?9XbM?Q?+?M?I^5??`A7?l?7KƧ?
=p?
=p?n?9XbM?ěS?Q?S?-V?nO?\(?+?tj?M?Q?nO?Õ$/?bM?nO?tj~?-V?I^5??° ě?S?`A7L?GzH?9XbM?S?I^5??M?333333?-V?"`?ěS?/w?nO;?+?l?9XbM?Q?Õ$/?° ě?A7Kƨ?zG{?&x?n?`A7?GzH?lD?I^5??n?9XbM?Z1'?333333?lD?hr Ĝ?nO;?\(?° ě?n?Q?l?Q?|hr?l?ěS?Z1'?tj~?S?Õ$/?l?\(?Õ$/?Õ$/?nP?n?nO?\(?nO?° ě?hr Ĝ?° ě?A7Kƨ?$/?Z1'?333333?
=p?nO;?S?S?-V?I^5??I^5??ěS?`A7?nO?hr Ĝ?hr Ĝ?M?-V?lD?Õ$/?l?öE?tj~?nO;?I^5??S?hr Ĝ?hr Ĝ?I^5??nO;?M?Õ$/?+?-V?`A7?-V?-V?-V?-V?`A7L?n?\(?bM?-V?nO?333333?l?+?nO;?GzH?bM?7KƧ?l?° ě?\(?;dZ?nO?° ě?$/?-V?M?\(?+?M?n?öE?Q?333333?GzH?M?Q?E?GzH??|hs?333333?\(?&x?zG{?9XbM?`A7?ļj~#?öE?tj?n?GzH?tj~?zG{?tj~?nO?&x?M?M?
=p?+?7KƧ?Õ$/?Q? ěT?7KƧ?M?Q?lD?I^5??
=p?ļj~#?lD?Q?$/?-V?
=p?öE?I^5??&x?&x?ěS?&x?bM?nP?`A7?l?nO;?° ě?lD?-V?\(?nO;?Q?&x?-V?öE?ěS?$/?9XbM?9XbM?zG{?nO;?S?lD?\(?`A7L?Q?;dZ?&x?7KƧ?bM?Z1'?;dZ?lD?nP?bM?-V?`A7L?ěS?Q?Õ$/?l?M?`A7?I^5??A7Kƨ?Q?-V?7KƧ?° ě?9XbM?M?GzH?Õ$/?$/?&x?`A7L?-V?333333?-V?nP?-V?I^5??nO;?
=p?7KƧ?S?GzH?;dZ?n?
=p?I^5??nO?M?ěS?-V?nO;?I^5??Õ$/?`A7?lD?hr Ĝ?Q?A7Kƨ?n?n?M?Q?nO;?-V?-V?M?öE?I^5??hr Ĝ?A7Kƨ?"`?° ě?S?$/?
=p?&x?bM?333333?333333?`A7?`A7?`A7?° ě?|hr?nO?9XbM?nP?nO;?nO;?° ě?A7Kƨ? ěT?nP?\(?Q?tj~?+?hr Ĝ?S?nO?l? ěT?
=p?tj~?-V?M?\(?nO;?$/?"`?hr Ĝ?S?I^5??\(?I^5??° ě?9XbM?n?5?|h?tj?$/?`A7?333333?333333?Z1'?$/?;dZ?9XbM?M?I^5??I^5??M?lD?° ě?° ě?
=p?7KƧ?\(?\(? ěT?bM?n?|hr?E?
=p?p
=q?`A7L?Q?333333?öE? ěT?S?lD?`A7L?-V?7KƧ?A7Kƨ?7KƧ?I^5??\(?\(? ěT?-V?&x?hr Ĝ?&x?hr Ĝ?bM?° ě?&x?ļj~#?I^5??I^5??Õ$/?&x?-V?9XbM?tj?-V?-V?-V?l?lD?Q?I^5??lD?n?nO?ěS?nO?l?Z1'?n?&x?ěS?
=p?bM?I^5??n?-V?Õ$/?\(?nP?ěS?
=p?l?7KƧ?A7Kƨ?
=p?nP?nO?Õ$/?° ě?ěS?n?ěS?`A7K?+?+?A7Kƨ?bM?lD?-V?tj~?
=p?-V?-V?&x?vȴ9X?zG{?° ě?-V?A7Kƨ?&x?      ?GzH?n?-V?|hr?`A7?S?zG{?7KƧ?nO;?"`A?`A7?`A7?-V?° ě?S?nO?A7Kƨ?bM?7KƧ?&x?`A7L?`A7L?n?nO;?lD?&x?° ě?n?hr Ĝ?;dZ?Q?A7Kƨ?|hr?-V?&x?Q?`A7?&x?nP?$/?7KƧ?Q?
=p?n?GzH?nO;? ěT?&x?&x?nP?nO;?$/?
=p?
=p?$/?ěS?hr Ĝ?-V?7KƧ?n?      ?`A7?`A7L?GzH?l?n?I^5??$/?tj~?vȴ9X?5?|h?1&y?&x?-V?/w?9XbM?n? ěT?hr Ĝ?-V??|hs?ěS?M?A7Kƨ?-V?\(?M?M?`A7L?+?7KƧ?lD?7KƧ?&x?
=p?-V?$/?-V?lD?bM?ěS?A7Kƨ?E?p
=q?p
=q?E?M?Q?bM?7KƧ?bM?° ě?M?M?A7Kƨ?n?hr Ĝ?hr Ĝ?Õ$/?nP?nO;?`A7L?nO;?vȴ9X?&x?ěS?`A7?tj?M?      ?Q?M?&x?GzH?|hr?GzH?;dZ?tj~?hr Ĝ?7KƧ?S?GzH?(\)?7KƧ?1&y?"`?j~"?9XbM?`A7L?nP?\(?"`A?Gz?nP?nP?"`?p
=q?hr Ĝ?A7Kƨ?A7Kƨ?-V?7KƧ?n?-V?"`?;dZ?l?I^5??lD?-V?      ?;dZ?\(?1&y?
=p?
=p?bM?Q?`A7?&x?-V?$/?ěS?nO;?bM?A7Kƨ?
=p?-V?\(?öE?      ?7KƧ?nP?GzH?ěS?$/?      ?&x?A7Kƨ?-V?öE?nP?bM?&x?7KƧ?\(?l?I^5??ěS?n? ěT?° ě?° ě?n?A7Kƨ?vȴ9X?A7Kƨ?\(?-V?\(?&x?lD?tj?A7Kƨ?p
=q?nO?bM?I^5??j~"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@K@K@     @K     @K     @KL@K     @Kfffff@K     @K     @K@K@KL@K@Kٙ@J33333@K@K33333@KL@M@     @Ms33333@M33333@Mfffff@N@NL@NL@N@Mfffff@M     @M     @M@Mfffff@N      @N      @M33333@Mٙ@M     @N      @N&fffff@NL@N     @O      @O@O@O@O@O&fffff@O@O@O333333@O333333@O@O@O@     @OY@OY@Offffff@Offffff@Os33333@Offffff@OY@OY@Offffff@Offffff@Os33333@Offffff@O@Offfff@Oٙ@Offfff@O33333@P@P33333@P33333@P33333@P33333@P      @P&fffff@P,@P&fffff@P333333@P@     @PL@PL@PS33333@PFfffff@PS33333@PY@P`     @Pffffff@Pl@Pl@Ps33333@Pl@Ps33333@Py@Py@Py@Py@Py@P     @P     @P     @Py@P@P33333@P@P@P33333@P33333@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@P33333@P33333@P@P33333@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P     @P@P     @P     @P     @P     @P33333@P@P     @P     @P@P@P@P@P     @P@P     @P     @P     @P@P@P     @P@P@P@P     @P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P@Pfffff@P33333@P33333@Pfffff@Pfffff@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P     @P@P     @P     @P@P     @P@P@P33333@P@P     @P     @P     @P     @P     @P@P@P@P@P     @P@P     @P     @P     @P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P33333@P     @P@P     @P     @P     @P     @P     @P     @P33333@P@P     @P     @P     @P@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P33333@P@Pfffff@P     @P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P33333@Pٙ@P     @P     @P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @P     @P     @P     @Pfffff@P     @Pfffff@Pٙ@P     @Pfffff@P     @Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @Pٙ@P     @Pfffff@P     @Pٙ@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P33333@P     @P     @P     @P     @P     @P     @P     @P     @P@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P33333@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P     @P     @Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P33333@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@Pfffff@P     @P     @Pٙ@P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@P     @P     @Pٙ@P     @P     @P     @P     @P     @Pfffff@P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P33333@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @Pٙ@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@Pٙ@P     @P@Pfffff@Pfffff@P@P@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pٙ@Pfffff@P@P@P@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@Pfffff@P@P@P@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@P@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@Pfffff@P@Pfffff@P@Pfffff@P@P@Pfffff@P@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@Pfffff@P@P33333@P33333@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@Pfffff@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P@P33333@P33333@P@P@P@P@P33333@P33333@P@P33333@P33333@P@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       P8                                      1                                       cBCC =3À