CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P12    CAST_NUMBER       3      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:41.054584Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R        data_max      @R        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     @  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @          data_max      @P        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      @  M   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        l   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @
Mj   data_max      @ @IQ   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       @  t   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@5+j   data_max      @A0Xy=   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      @     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d           oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @#         data_max      @r>fffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        @  ¼   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d           CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?ȴ9Xb   data_max      ?vȴ9   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      @     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d       	   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       @    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       0   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @OY   data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     @ 7   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d       W,   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( ^   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( _$   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      	f   data_max      	f   C_format      %10d       _L   latitude               	long_name         latitude   units         	degrees_N      data_min      @H|%   data_max      @H|%   C_format      %9.4f          _P   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `UGX   data_max      `UGX   C_format      %9.4f          _T   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        _X   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        _\@R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @R     @       @      @      @      @      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             @ ?H˒:@ >"@ >ߤ?@ ?.H@ ?b}V@ ?U=@ ?U=@ ?U=@ >쿱[W@ >ߤ?@ ?!-w1@ ?!-w1@ >쿱[W@ ?b}V@ ?$tS@ ??@ ??@ ?˒:)@ ?˒:)@ ?˒:)@ ?[W>@ ?[W>@ @     @ ?˒:)@ ?vȴ9@ ?[W>@ ?vȴ9@ ?˒:)@ ?vȴ9@ ?˒:)@ ?$tS@ ??@ ?@ >u@ =ڹZ@ =ڹZ@ > ѷY@ >ߤ?@ >%@ ?|hs@ >($x@ >"@ ?	@ @hۋq@ @n@ @IQ@ @NU@ >"@ >Ov_خ@ =}H@ =<64@ <hr@ <?@ <#x@ <>@ <>@ <>@ <ߤ@@ ;lC@ <(\@ <C,zx@ <1&@ <(\@ <(\@ ;m]@ ;q@ ;6@ ;qu!@ ;dZ@ ;=K^@ ;q@ ;A@ ;q@ ;A@ ;6@ ;s@ :^5?|@ :u%F@ 9@ 9|@ 9_o@ 8PH@ 8y=c@ 7&@ 6Fs@ 4֡a@ 3tj~@ /Vϫ@ / hۋ@ ,I^5?@ )7KƧ@ (ۋq
@ '/V@ }Vl@@A [@D@]/w@Ca@N@6E@"`B@䎊q@eں@iᰉ'@tj@D@W'@V8YJ@fB@Fs@r Ĝ@{J#9@g@8Q@kP@҈@,zxl@<?@1.@E@2W@Q@7@cA \@|쿱[@u%F
L@nzG@hXy=@ae@U2a|@:S&@#A [@[@?@޸Q@&x@Zc@
(@Vu@$tS@4J@\N@r Ĝ@䎊qj@@(\@ѷX@_o @R<6@>6z@*0@,<@6@|@K]d@Mj@ҽ<64@5Xy>@@rGE@ NU@xF]@҉@U=@"wkQ@"e+@'-@+jf@1o@A@W@Stj~@S҉@VR<6@^ ѷY@h@i*0U2a@h	ԕ+@NT@HeO@Eo i@C{J#9@BI^5@B ѷ@>vȴ9X@Dtj@Z6C@EQ@)rGE@7KƧ@1l@PH@R@%2@1@唯O
@S&@[6@E@@ [7@E@z@-V@hr!@$xG@IQ@L_@kP{@h	ԕ+@l<쿱@n/@p
=q@ov@a-w1@Rm@Hp:@<hr@6_ح@2m\@-(@#
=p@X@)_@M@N;6@%2@}Vl@Ov`@ڹ@҈p@q@a@O@@S@sPH@fIQ@[q@KxF]@9=b@JE@	'RTa@JM@8YK@s@@64@MjO@C@U=@m\@!-w1@(@@}b@lq@a'R@MjOv@G_o@A:S@;J#9@5!R@43@,VϪ@	^5?}@MjO@ڹY@#9@E@(\@p:~@ [7@xl"h	@dZ1@P|@4j~@&L/{J@o@6C@p:~@m\@u%F
@H˒:@F@@*0U2a@Fs@2W@e@3@tj@@rGE9@
M;@p:~@L_@ԕ*@o h@sPH@g/V@Xy=c@S҉@P)^@@4m@5Y|@1A [@0D@0@/r@/4֡a@/{J#:@/4֡a@/v@.1@/4֡a@+C]@N;@fA@Fs@?@ ě@U2a|@Z@,<@l!-@sP@cA \@@@?@s@\N<@64@j~@zxl"@VϪ@P{@\)@,@,@A [@;dZ@Ov_خ@u"@JE@=K@Z@;5X@oiD@Q@-@o h@yD@poiDg8@jJL@],=@Y@W
=p@TE@Sa@O@O͞@L~($x@H˒:*@H˒:*@C@An.@=K]@49XbN@.O;@&x@%O
@$/@$TɆ@$e@$%1@@)^	@?@TɅo@H˒@}H@|@PH@2W@*0U2a@
qu@ce@sPH@v_ح@M:@I^5@?@<쿱@,@Gz@qu!@e+@O;d@<64@o h@ѷX@     @.H@~6z@{/V@vz@r䎊q@q2W@or@kjf@dtSM@`ěT@^Ov_خ@U*0@Hu%F@Ca@N@BZc@@ѷX@?.H@<j~#@73@3|@/iDg8@+I^@)Dg8~@($xG@&1.@!e@حV@Q@ce@]ce@@@t@_p@@o i@ݗ@      @j~#@YJ@!.I@䎊q@P{@,@S@@4@޸Q@kP|@`d@o @Ƨ@'/@ɠ'RTa@Ǔݗ+@<64@SMj@MjO@-V@O;@ۋq
@fffff@`A7L@9@!-w1@JE@$tS@E@I^5?@I^5@hۋq@b}V@.H@.H@|PH@z)_@z@yXbM@wXe@k~($@bC,@\N;@O͞@K]cA@I@D2W@;/V@9rGE8@9XbM@84֡b@8l"h	@8Q@8Q@6Fs@3@1l@1&x@0
=q@0:~ @-w1@',@!-w1@C,zx@+J@Z@m@n@)^@As@@)y@SMj@Vϫ@q@0
@RT`e@wkQ@fA@ԕ*@oiDg@āo h@&IR@$t@n.@9XbN@@\@"h	ԕ@B@8}H@|Q@/w@D*@͞@^5?}@@@Q@$/@{lC@y(@wkP@vFs@v_ح@u\(@uXy=@t֡a@r{m@k~($@c9@Y0
)@U=K@U=K@UL_@R:)y@MO;dZ@LI^5?@LI^5?@L/{J#@LL_@JW'@I^5?}@I@J#9@J=p
@Hp:@G+I@F]cf@Fs@E8YK@E84֡@Eo i@EQ@Dg8}@C@B74@B\(@B\(@B\(@Bu%F
@BZc@A@?@>
(@=!.H@:>B@5!.@0:~ @,>B[@(@&A@%S@%+a@"`A@?@Q_@PH@*0@@҈@oiDg@$t@1@!.I@%F
L@!-w2@{m@{m@.2@Dg8~@A@	ԕ+@Dg8~@fA@,<@M@u!@Ft@iB@ ѷY@+@ק&@|@ǮzH@H˒:@m8@
(@q@Xy=@S&@-
@Q@$tS@I^5@zxl"h
@wkP@u\(@sg@r{m@nc	@hr Ĝ@d7@M%@JW'@I@H@E84֡@A [7@>BZc @=K]@:^5?|@5?@.2X@"`A@-V@_o@$/@rGE9@
	 @eO@@F]c@$t@m]@xl"h
@%F
L@!-w@䎊qj@
qu@?@"`B@D*@H@]cf@2W@<64@3@q@IQ@-
@S@Xe,@+j@2X@)@Z@n@ ě@'RT@r@v@Ƨ@)^@@~@	k@g@a@N@W@(TɅ@Ov_@@'/V@2ᰊ@@n@As@?@9#w@1[W>6@䎊r@N;6@Mj@
ڹY@I^5@
s@
%F
L@
 hۋ@
!-w@
쿱[W?@
Q@
	ԕ+@
,<@
+a@
%1@
`A7L@
`A7L@
eO@
(\@
@
Zc@
@@
@
|hs@
rG@
ᰊ@
^@
0U2a|@
q@
W@
g	l@
64@
ק&@!R<@8)@8YJ@P|@_حV@`҈p@_حV@h@kQ@sMjO@w1@p:~ @mC\@r{m@tj~@v!.I@u%F
L@u!R@vȴ9X@v_ح@uY|@r䎊q@ql@o hۋ@k~($@kP{@kC,z@jOv`@e@`҈p@^@_;dZ@`A7K@^҈p;@Xe+@Q@A7Kƨ@4J@49XbN@2W@0{@49XbN@)^@Mj@
MjO@
	@
JE@
s@
6z@
2W@
͞&@
TɅ@
jf@
v@
9XbN@
)y@
D@
W'@
zxl"@
Q@
L_@
xF]@
!R<@
nO@
҈@
L/{@
$tT@
@
e+a@
,=@
zxl"h@
L/{J@
@
'@
&@
Xy=@
d7@
<쿱@
	k@
@
 ѷ@
}E@
x-
@
tj~@
rs@
o4֡a@
lVϪ@
hr Ĝ@
ceO@
_;dZ@
^@
\>@
[q@
ZY@
Y+@
W>6z@
W&@
XbM@
W>6z@
VϪ͟@
Vt@
RT`d@
P|@
HK]c@
B74@
8}H@
*0
@
#9@
S@
zG@
bM@
҈@
#@
 IQ@>B@Fs@g@hr!@	k@7@d8@]ce@"`B@څݘ@ٳ|@R@74@?|h@W@{@v@>B[@y@&@u@%@_o@ݗ+k@qiC@Fs@ѷX@|Q@w+@t#@p:~ @g	k@Vl!-@O;dZ@N+@M%@L_@HK]c@As@?[W>@=b@7rG@2a|Q@#n.3@ 'RT`@u"@S@kP|@*0@u%F@E@PH@@(@l@Dg8~@+a@Z@	@Z1@Gz@ޞ@]ce@ٳ|@e+@2a|@а{@
M;@@,zxl@b@rG@|@[W>6@
qv@'@wk@/@@-
@+J@u%F@~"@nc	@bC,@VϪ͟@S@I^5?}@4m8@0U2a|@/v@*0
@'&@%zxl"h@#S&@IQ@_F@@:)y@@C%@1&x@%2@
$t@
	k~@
#@
iB@
A@
(\@
Ʌoi@
T`d@
`A7@
*0U@
s@
@
m\@
4֡b@
1&y@
͞&@
͞&@
d7@
,@
0
)@
sh@
zG@
S&@
4J@
\(@
u%F@
YJ@
{~$@
qiB@
cA [@
^҈p;@
[$@
YJE@
Vl!-@
TE@
P|@
Ks@
JW'@
H˒:*@
=<64@
-B@
Fs@
Mj                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @@6_o @@6
(@@6t@@6 ѷY@@6 ѷY@@6t@@6t@@6_o @@6 ѷY@@6 ѷY@@5ڹ@@6 ѷY@@5ڹ@@6 ѷY@@6t@@6 ѷY@@6 ѷY@@6t@@6 ѷY@@6t@@5ڹ@@5ڹ@@5C\@@6 ѷY@@5ڹ@@6 ѷY@@5ڹ@@5ڹ@@5ڹ@@5ڹ@@5ڹ@@5ڹ@@5!.@@5(@@5(@@5ᰉ@@5(@@5E@@5(@@5!.@@5E@@5E@@5!.@@5ڹ@@5C\@@5ڹ@@5!.@@5oiDg@@5ᰉ@@5,=@@5S@@5S@@5
qv@@5S@@5
qv@@5?@@5?@@5b@@5
qv@@5S@@5?@@5?@@5b@@5?@@5b@@5?@@5?@@5?@@5?@@5b@@5?@@5b@@5?@@5b@@58YK@@58YK@@5Ϫ͞@@5Ϫ͞@@5cA @@5cA @@5@@5\(@@5\(@@5H˒@@5H˒@@5n/@@5-V@@5%@@5+j@@5Xy=@@5@@5cA @@5Ϫ͞@@6,<@@8\)@@:a|Q@@;u%@@<PH@@='0@@=ce@@>Vu@@?3@@ADg8~@@C=K^@@E?@@G{J#:@@H@@H@@Je+@@Mᰉ@@N@@O)^@@OKƧ@@P
qu@@Q@@R{m@@S]cA@@T>@@W8}H@@X4m@@Y@N@@Y~($@@Yᰉ'@@Za|Q@@Z`A@@[	@@[Z@@[Mj@@[a@@@\M:@@]H˒@@_!-w1@@_[W>@@aQ@@cQ@@gFt@@j~"@@kݗ+k@@m'0@@nOv_@@oO;d@@q'RTa@@v.2@@yQ@@{wk@@+j@@n@@%1@@Mj@@Q@@L_@@6@@F
L0@@}Vm@@
=p@@k~(@@T`d@@#x@@($x@@@4n@@`A7L@@]cf@@rG@@2W@@9Xb@@sP@@2W@@@@1@@^5?}@@5?|@@ߤ?@@v_ح@@l@@$@@ŨXy=@@ǍO;d@@.H@@C,z@@dZ@@a@O@@C]@@SMj@@Ʌoi@@hr@@Ov_@@l"h	@@ҦL/{@@Ҭ>B@@J#9@@
qv@@\(@@@@|@@#w@@٠'RTa@@)y@@,<@@޾ߤ?@@ߤ?@@rGE9@@'RT`@@hۋq@@F@@:S@@R@@ⅇݘ@@9@@Mj@@#x@@@@8}H@@}H@@d8@@#w@@rGE8@@R<6@@o@@e@@lD@@#9@@d7@@'/@@/V@@C]@@!-w2@@m8@@?@@7@@*0@@Z@@D@@K]@@qu"@@%F
L@@Vl!@@m\@@}H@@힃%@@H˒@@(@@!.@@ ѷY@@ ѷY@@_o @@
L/@@zG@@1.@@BZc @@L/{J@@R<6@@Vu@@_ح@@s@@O;@@@@ȴ9X@@C-@@x@@Fs@@ hۋ@@)^@@
=p@@v@@1@@E84@@KƧ@@_o@@|hs@@$tS@@-V@@[W>@@@@;dZ@@rGE9@@6@@*0@@73@@D*@@l"h	@@|@@-
@@IQ@@𭫟U@@p:@@@@-w1@@7KƧ@@0
)@@-w1@@-w1@@0
)@@4J@@7KƧ@@:S@@7KƧ@@4J@@4J@@A [@@TɅo@@u!S@@񂩓@@7Kƨ@@񰉠'R@@D@@y@@_o@@N;6@@@@"`@@iB@@iB@@iB@@iB@@ᰉ'@@@@@@&IR@@a|Q@@u%F
@@@4@@p:@@ ě@@)_@@,<@@G{@@I^@@nP@@C,z@@33333@@J#9@@Z@@eO@@m]@@Z@@Ƨ@@Q@@A [@@@@L_@@2W@@9XbN@@I^5?@@]ce@@tSM@@qj@@*1@@O
M@@?@@*0@@֡a@@u@@F
L0@@\@@1@@?@@_o @@($x@@;5X@@fffff@@+J@@af@@af@@&I@@]cf@@Fs@@+I@@Xe,@@	@@@@ݗ+@@kP@@-V@@&@@bM@@Xy=@@r Ĝ@@˒:*@@-
@@{@@
(@@ěT@@)^@@ ѷ@@4J@@A [@@e+a@@@@B@@o@@e@@=p
@@^5?|@@p:@@>B@@Y@@)_@@䎊q@@/V@@C%@@F]c@@P{@@W>6z@@xF]@@wk@@Q@@%2@@@@!-w2@@`d@@?@@S@@hr@@S&@@w1@@$/@@!R@@@@\(@@(@@
(@@.2@@R<6@@_ح@@iB@@}Vl@@T@@'@@ߤ?@@ȴ9X@@҈p;@@Mj@@
=p@@;dZ@@4m@@&@@?@@@@䎊r@A *0U@A  ě@A K]c@A tj@A 4m@A TɅ@A @A@A:S@Au!S@A(@AN;6@A@Ae@A-@Aa|Q@AY@A)_@A,<@A䎊q@AI^@APH@A	@A/V@AdZ@Aߤ@Aq@Aa@O@Atj@AwkP@A?@AC@A*1@A*1@A#x@A?@A*0@A>B[@Ahr@AfA@Ash@A!.@AIQ@A-@AQ@A@AAs@AKƧ@ART`e@ART`e@A\(@A\(@Ab}V@AsPH@A@A?@A?@A͞@A3@A+@AF]d@A73@AbM@A@A-
@A{@A4m@A
(@A)^@A	#w@A	hr @A	@A	^5?}@A	>BZ@A	lD@A
	 @A
#9@A
{m@A
n@A
 ѷ@A
C,@A
~@As@A,zxl@Aqu!@A~$@AU=@Am]@A
=p@AA [@AL_@A!-w2@A<쿱@AC@A7@A>B[@A>@A
%F
L@A
IQ@A
Vl!@A
ce@A
w1@A
w1@A
$/@A
M:@A
!R@A
U=@A
!.@Al!-@Aߤ?@A]cf@A]cf@Aߤ?@A hۋ@A4֡a@AAs@AH˒:@AE84@AKƧ@Ab}V@Ao@AlC@AiDg8@AlC@A{J#:@A	k@A&@AzH@A3@Avȴ9@A@Ao @A+@AحV@A;dZ@ArG@ArG@A-@A-@A䎊r@A#@AbM@A'RT`@A*0@ANU@A'RT@ATɅ@A4֡b@A:S@AJE@ATɅo@AXbM@Ak~(@A@AR<6@Al@Ay@AlD@A:)y@Axl"h
@A)_@A ѷ@AG{@AC,@A74@AI^@AS&@A"`B@AC%@AMjO@AMjO@AJ#9@AS@A]cA@Aqu!@A@AA@Aq@AE@A5Xy@A
=p@As@A!-w2@A?@Aj~#@Aq@A~($x@Aqj@AS@Azxl"@AO
M@AɅoi@AK]@A[@Aqu"@A!.H@A%F
L@A/w@A84֡@AO;dZ@AY|@Ash@AH˒@A\(@AϪ͞@A?@AoiDg@Aڹ@At@AzG@A$/@AE@Ap:~@A+J@AO;@A-@A@AA@A+@A+@A쿱[W@A"@AFt@A
=p@A!-w1@AAs@AiDg8@A|hs@A	@A@AkP@A/V@AحV@ArG@A73@AD*@AH@A_F@Ar Ĝ@AYJ@AIQ@A4m@A*0U2a@A[W>6@Ao@As@AJL@Ad7@AnO@AC,@AU=@AL_@A@A%1@AM:@A!-w2@A2W@A<쿱@Atj@A$@An.@Aj~#@A@A+a@AϪ͞@Ab@A
qv@Aᰉ@A(@AE@Au@A8YJ@A\N<@Avȴ9X@Aqi@AFs@Aaf@AT@A@A6z@A}Vl@A'@Aߤ?@AQ@Aߤ?@Aߤ?@At@A쿱[W@AC-@AC-@A1@AC-@A@A
M;@AXe@AO
M@A@A#@A *0U@A 73@A @A!=b@A"Ov`@A"Zc@A"䎊q@A#,zxl@A#F]c@A#F]c@A#{J#9@A#҈@A$9XbN@A$Z1@A$cA \@A$q@A$~($x@A$C@A$쿱[@A$zxl"@A$@A$7@A$7@A$@A$/@A$JM@A$>@A%K]@A%'0@A%V@A%(@A%2a|@A%<64@A%?|h@A%<64@A%?|h@A%B@A%?|h@A%?|h@A%?|h@A%B@A%?|h@A%?|h@A%?|h@A%IQ@A%?|h@A%B@A%?|h@A%84֡@A%2a|@A%Q@A%[@A%o i@A%K]@A%Q@A%2a|@A%S&@A%m\@A%=K@A&
L/@A&u@A&t@A%oiDg@A%@A%
qv@A%(@A&_o @A&
(@A&u@A&;5X@A&c	@A&z@A&$t@A&m\@A&҈p;@A&A@A&t@A&Ϫ͟@A&C-@A' hۋ@A'!-w1@A'\(@A'O;d@A'zH@A'K]d@A'fA@A'@A'@@A'rG@A'-@A'rGE9@A(@A(bM@A(
qu@A(@A( ě@A('RT`@A($xG@A(-
q@A('RT`@A('RT`@A(-
q@A(4m9@A(4m9@A(:~ @A(D*@A(_F@A(r Ĝ@A(YJ@A(-
@A(@A(@A(4m@A(
(@A(ěT@A(p:@A(҈p@A(@A(C@A(\)@A($tT@A)rGE@A)_p@A)&x@A)4J@A)=b@A)=b@A)Gz@A)k~(@A)D@A*	 @A*e+@A*䎊@A*&IR@A*3@A*:)y@A*@4n@A*M@A*W'@A*a|Q@A*u%F
@A*~"@A*p:@A*wkQ@A*@A*Y@A*@A*͞&@A*fB@A+S&@A+҉@A+s@A+"`B@A+"`B@A+6z@A+P{@A+S@A+W>6z@A+]cA@A+n.3@A+tj~@A+{J#9@A+$@A+U=@A+*0U2@A+E@A+a@O@A+Ƨ@A+|@A+|@A+@A+@A+Q@A+lC@A+g@A+%2@A+g@A+s@A,n.@A,1&y@A,xF@A,ߤ@@A,L_@A,"h	ԕ@A,!-w2@A,,<@A,C,zx@A,I^5?@A,cA \@A,g8}@A,`d@A,cA \@A,zG@A,N;@A,_@A,3@A,?@A,?@A,Ʌoi@A,@A,@A,*0@A,>B[@A,Z@A,@A-:@A-K]@A-o i@A-Q@A-+a@A-5Xy>@A-<64@A-IQ@A-S&@A-O;dZ@A-\@A-w1@A-ݗ@A-ݗ@A-ݗ@A-hr!@A-%@A--V@A-H˒@A-S@A.t@A.
(@A.
(@A.4K@A.4K@A.4K@A.
(@A.zG@A.+jg@A.R<6@A.YJ@A.L/{J@A.R<6@A._ح@A.z@A.qi@A.@A.O;@A.af@A.'@A.t@A.Ϫ͟@A.Fs@A/$tS@A/\(@A/o@A/y@A/	@A/ݗ+@A/-V@A/?@A/͞@A/[W>@A//V@A/;dZ@A0@A0D*@A0Xy=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @r333333@r9@r333333@r6fffff@r6fffff@r;33333@r9@r4@r9@r6fffff@r8     @r9@r<@r4@r;33333@r;33333@r6fffff@r6fffff@r;33333@r;33333@r6fffff@r;33333@r<@r;33333@r9@r6fffff@r4@r;33333@r6fffff@r6fffff@r;33333@r6fffff@r9@r;33333@r;33333@r;33333@r4@r8     @r;33333@r;33333@r<@r;33333@r8     @r4@r6fffff@r      @rfffff@r)@r;33333@r6fffff@r>fffff@r9@r8     @r6fffff@r9@r8     @r0     @r4@r;33333@r333333@r333333@r6fffff@r333333@r4@r;33333@r.fffff@r>fffff@r0     @r6fffff@r4@r;33333@r4@r6fffff@r.fffff@r.fffff@r0     @r4@r4@r333333@r(     @r.fffff@r+33333@r0     @r0     @r+33333@r.fffff@r&fffff@r#33333@r!@r#33333@r	@qfffff@q陙@q     @q     @q@q@q     @qᙙ@q     @qfffff@q33333@q@q     @q@qy@qP     @qK33333@q@     @qp     @q@q~fffff@qp     @qc33333@qX     @q[33333@q@     @q4@qL@qVfffff@qH     @q333333@qD@qFfffff@qT@qK33333@qK33333@qNfffff@q9@q+33333@q!@q@p@p33333@p     @p33333@ps33333@pi@p^fffff@p>fffff@p     @o@o`     @o	@n33333@n@n`     @n&fffff@m@mٙ@mfffff@m	@l@lVfffff@l6fffff@l#33333@k33333@k     @kfffff@kVfffff@k@     @k@jfffff@j\@j&fffff@j@i@i@iffffff@ifffff@i     @h@h33333@h33333@hfffff@hI@h      @gٙ@g33333@g@gfffff@g     @g33333@gvfffff@g\@g@f33333@ffffff@f@f33333@f<@f@efffff@e33333@efffff@eY@efffff@d     @dfffff@d     @d     @d     @dy@d\@d<@dfffff@d33333@c     @cfffff@c     @ci@cFfffff@cfffff@b     @b     @bfffff@b     @b     @b     @bs33333@bl@b9@b@b33333@a     @a33333@a@a33333@a33333@a     @a33333@a     @a33333@afffff@a     @ap     @aY@a9@a<@a&fffff@a     @afffff@`33333@a@a@`fffff@a      @`@`@`fffff@`C33333@``     @`\@`P     @`333333@`#33333@`fffff@`@_@`     @`&fffff@`33333@_@_9@_&fffff@_@_      @^fffff@^y@^@^@^@]@]fffff@]Ffffff@]      @]      @\fffff@\     @\@\Y@\@     @\Y@\@[fffff@[@     @Z     @Zfffff@Z@Zy@Zl@Z@Zl@Z33333@Z@Zffffff@Z     @Z@     @Z9@Yfffff@Y@Yfffff@Y@Y     @Yl@Y9@Yy@Ys33333@Y     @Y33333@Ys33333@YL@Yy@YFfffff@Y@     @Y      @Y      @Xfffff@X@X33333@X33333@Xy@XFfffff@X9@X@X@X@W@Wfffff@W@W@Wffffff@W     @WL@WS33333@WL@WS33333@W9@W9@W33333@W      @W@V@V     @W@W,@Vffffff@Vl@VS33333@V,@V&fffff@U33333@Ufffff@Uy@U@     @U333333@U&fffff@U      @T33333@U@T     @T     @T     @T@T33333@TY@TL@T@T&fffff@T@     @T      @T@T      @S@S@Sffffff@S`     @SY@S@S@S      @S9@R@S      @R@R     @R33333@Rffffff@RY@RY@R@R      @Qfffff@Qٙ@Qٙ@Qfffff@Q     @Q     @Q     @Qfffff@Qfffff@Q`     @Q`     @QY@Q`     @Qfffff@Q&fffff@Q@Q33333@P33333@Pfffff@P@Py@P@     @PY@PS33333@PS33333@P@P33333@P@O@O     @Oٙ@Offfff@O     @Offffff@OL@Offffff@OY@OL@N33333@OL@N33333@Nfffff@NY@Nffffff@N&fffff@N&fffff@M33333@N@M@M@M@L33333@L33333@L@Ls33333@Lffffff@L      @Kfffff@L@     @L      @K@K@     @K      @J33333@J     @Jfffff@Js33333@J     @J@Jffffff@I     @J@     @I333333@Iffffff@I&fffff@Hffffff@HL@H@Hffffff@H33333@HL@H333333@H&fffff@H333333@H@G@G@Fffffff@Fffffff@Efffff@F@Es33333@E@Effffff@E     @E&fffff@E@Effffff@Es33333@EY@E     @D33333@EL@E333333@D@E@D     @D@DL@Cٙ@D@D@C33333@D&fffff@D@C@CY@C@     @Bٙ@B33333@B     @B33333@B@C&fffff@B&fffff@BL@A33333@B      @B      @B&fffff@A33333@A@As33333@Afffff@A@A@     @@@A&fffff@A@     @@@@     @@     @@ffffff@@ffffff@@fffff@?33333@@s33333@@333333@@L@@@@L@@      @?@>fffff@>@>L@>ffffff@>     @>333333@>@>      @>@>     @>fffff@>L@>     @>     @>L@>@>     @=33333@>@>@=L@>333333@>      @>@>L@=@=33333@>      @>      @=fffff@>333333@>333333@=@>@=333333@>L@=@=     @=     @<33333@=333333@<L@<L@<     @;fffff@<333333@;ffffff@;@;ffffff@;@;     @:     @:ffffff@9@9@9@9@9ffffff@9ffffff@9     @9L@9@9333333@9      @9@833333@9L@9L@833333@9fffff@933333@9      @9L@9333333@9ffffff@7@9333333@9      @8333333@833333@8ffffff@8@8ffffff@8ffffff@7333333@8ffffff@7fffff@8@7@7ffffff@7@7@7fffff@7@6fffff@7L@6fffff@7L@633333@7L@7L@7      @633333@6@633333@6@7333333@6@6@6@6     @5fffff@6ffffff@6     @6L@633333@5fffff@6ffffff@5@5fffff@6      @6L@5@6333333@5@5@5ffffff@5@533333@5L@433333@5      @5     @5ffffff@4@5@3fffff@2fffff@4      @3333333@2@3@233333@2L@133333@033333@2      @1@1@1@2L@2L@2@3      @1L@1fffff@0333333@1@0ffffff@0L@0fffff@0L@1      @1      @0@0fffff@0@0ffffff@033333@0      @0L@1      @0@0L@0ffffff@0     @1333333@.      @0@0     @0L@0ffffff@0ffffff@0     @0L@033333@/@0@0333333@.@0333333@.@/      @-ffffff@.ffffff@+333333@*ffffff@)      @)333333@)333333@)333333@)@'@'ffffff@'@'ffffff@(333333@(@%@&@(      @*ffffff@%      @'      @'ffffff@'@&ffffff@'      @'@'      @'      @'      @(      @$@(      @&      @'      @&@&@&@'      @(      @'333333@%@'      @(      @)      @'@(      @(      @'ffffff@(ffffff@'@)ffffff@(@(      @(      @(333333@(      @(      @'@&@'@%@(      @'333333@'@'@'333333@(ffffff@&@'ffffff@'      @&@%@&      @'      @'      @&@'333333@%@%@&      @&      @&      @&333333@%ffffff@$@&@&@$@&      @&      @&      @&      @&      @&      @&      @&      @&      @&      @%@%333333@%@'333333@$333333@'@&      @$@&333333@%@&333333@$333333@'@%333333@'@&      @$@&      @&      @'333333@$@&@$      @(333333@$      @&@%ffffff@%@$@&@$ffffff@%@%ffffff@%ffffff@%@$@&333333@$333333@&333333@%333333@&      @%@%333333@%333333@%@%@$ffffff@&@$@$@%ffffff@$@%ffffff@$@&      @$@%      @%      @&333333@$@%ffffff@%333333@%      @%@$@&      @$333333@&@$@%@$@%333333@$@%@%333333@%      @#@&      @$@%@%      @%333333@%ffffff@%@%ffffff@%333333@%@$333333@&      @%333333@$@%333333@%@%@$@%333333@%@%      @%333333@%333333@%@%@&      @$@&      @%333333@%333333@&@%@$@%333333@%333333@'@%333333@%      @&      @&      @$ffffff@%@&333333@&      @%@&      @$@%333333@%333333@%ffffff@&@$@%@'@#ffffff@%      @%333333@&@&      @%@&@#      @'@$@%ffffff@%ffffff@&@$@&333333@&ffffff@%333333@%      @%@'@%ffffff@%      @%ffffff@%      @%@%@'@$@&      @&ffffff@&333333@%ffffff@*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?zG{?GzH?$/?o?1&?-V?KƧ?
=p
?      ?Q?9XbN?Gz?O;d?zG{?vȴ9?-V?7KƧ?"`A?+I?vȴ9?`A7K?/w?S?C$?񙙙?S?-V?bM?r ě?I^5?}?`A7?j~"?O;d?ȴ9Xb?\(?7KƧ?tj?n?;dZ?Vt?`A7L?lC?+?E?\(?
=p?Z1'? ěT?tj?S?ffffff?7KƧ?I^5??\(?Q?zG?ffffff?1&?Q?tj?n? ěT?E?GzH?hr!?$/?
=p
?1&x?=p
=??|hs?Gz?9XbN?r ě?zG{?1&x?\(\?Gz?-V?M?
=p?zG{?~"?\(\?x?S?m?+I?"`?1&x?+I?1&x?l?Q?Q?O;dZ?7KƧ?7KƧ?dZ1?S?1&?^5?|?-V?`A7L?1&x?m?"`A?~"?E?j~"?(\)?I^5?I^5?}?lC?S?Ƈ+I?nO?Q?1&y?° ě?-V?bM?/v?1&?1&y?"`A?S?hr!?Gz?Gz?j~"?lC?1&?^5?|?"`A?hr!?"`A?+?E?Gz?vȴ9?"`B?1&?1&?lC?1&?1&?+J?lC?S?dZ1?+?XbM?lC?QR?+?KƧ?O;dZ?ȴ9Xb?dZ1?tj~?tj~?tj~?QR?QR?QR?KƧ?ȴ9Xb?
=p
?dZ1?+J?lC?tj~?1&?XbM??+?+?lC?lC?XbM?+??vȴ9?tj~?+J?+??QR?tj~?^5?|?+J?tj~?lC?1&?"`B?XbM?"`A?+?+?"`A?bM?XbM?O;dZ??lC?lC?lC?lC?XbM?lC??vȴ9?lC?1&?"`B?"`B?tj~?vȴ9?vȴ9?lC?lC?hr!?j~"?lC?lC?"`B?lC?lC?p
=q?j~"?XbM?"`B?^5?|?lC?j~"?Gz?S?lC?lC?lC?"`B?lC?^5?|?"`A?lC?S?^5?|?lC?lC?lC?lC?lC?lC?(\)?vȴ9?lC?lC?lC?lC?lC?Gz?(\)?"`B?lC?lC?lC?lC?lC?lC?lC?lC?1&?lC?lC?lC?lC?lC?lC?lC??lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?hr!?"`A?1&?lC?p
=q?lC?lC?lC?-V?E?(\)?hr!?lC?lC?lC?lC?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?+J?1&?lC?E?(\)?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?lC?E?lC?lC?lC?lC?lC?dZ1?Gz?lC?lC?lC?lC?lC?lC?lC?XbM?lC?lC?lC?lC?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?lC?lC?(\)?Q?lC?lC?lC?/v?j~"?"`?lC?lC?lC?lC?lC?E?lC?lC?lC?lC?E?lC?S?XbM?lC?lC?lC?lC?lC?E?/v?lC?lC?E?lC?lC?vȴ9?Gz?lC?lC?lC?-V?lC?lC?(\)?E?lC?Q?(\)?j~"?vȴ9X?lC?lC?lC?lC?vȴ9X?lC?lC?p
=q?lC?(\)?      ?lC?lC?-V?-V?lC?vȴ9X?lC?lC?p
=q?(\)?(\)?p
=q?lC?lC?E?E?E?/v?j~"?lC?E?lC?lC?vȴ9X?1&y?hr!?lC?-V?lC?XbM?lC?lC?/v?S?hr!?p
=q?&x?(\)?lC?lC?vȴ9X?hr!?(\)?-V?E?lC?lC?-V?/v?hr!?1&y?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?/v? ěT?Q?p
=q?lC?|hr?/v?lC?lC?lC?lC?j~"?E?"`A?dZ1?p
=q?hr!?Q?"`?lC?lC?lC?lC?lC?lC?lC?lC?-V?p
=q?lC?lC?lC?p
=q?lC?lC?XbM?"`A?Q?vȴ9X?(\)?/v?p
=q?lC?p
=q?lC?lC?lC?lC?Q?lC?/v?lC?lC?E?(\)?lC?lC?lC?(\)?/v?hr!?hr!?lC?/v?5?|h?lC?p
=q?lC?lC?lC?lC?E?lC?lC?p
=q?5?|h?"`?lC?E?lC?lC?lC?5?|h?-V?lC?lC?lC?Q?lC?5?|h?lC?lC?p
=q?lC?lC?1&y?E?-V?Q?lC?lC? ěT?lC?j~"?/v?"`?p
=q?vȴ9X?E?/v?E?lC?j~"?Q?E?hr!?;dZ?lC?lC?lC?lC?lC?E?5?|h?vȴ9X?E?(\)?lC?hr!?p
=q?/v?5?|h?(\)?Q?5?|h?(\)?5?|h?lC?E?dZ1?lC?lC?lC?lC?lC?lC?lC?lC?/v?(\)?      ?(\)?lC?5?|h?A7Kƨ?lC?lC?(\)?      ?hr!?j~"?hr!?vȴ9X?
=p?-V?;dZ?5?|h?5?|h?1&y?lC?E?(\)?E?lC?vȴ9X?lC?lC?lC?/v?lC?5?|h?E?-V?p
=q?A7Kƨ?-V?vȴ9X?      ?hr!?lC?lC?lC?lC?lC?E?1&y?p
=q?5?|h?nP?hr!?vȴ9X?Q?lC?vȴ9X?5?|h?-V?vȴ9X?      ?"`?5?|h?      ?      ?lC?hr!?      ?      ?      ?      ?5?|h?j~"?vȴ9X?lC?-V?      ?hr!?|hr?E?5?|h?E?lC?vȴ9X?      ?vȴ9X?lC?lC?nP?/v?ěS?      ?5?|h?;dZ?E?lC?lC?lC?vȴ9X?      ?-V?1&y?E?(\)?lC?5?|h?-V?vȴ9X?p
=q?5?|h?      ?nP?5?|h?vȴ9X?lC?
=p?&x?      ?      ?      ?5?|h?(\)?;dZ?lC?p
=q?/v?p
=q?-V?|hr?/v?lC?-V?5?|h?      ?vȴ9X?`A7L?lC?vȴ9X?n?-V?|hr?      ?lC?|hr?/v?vȴ9X?      ?-V?1&y?&x?      ?5?|h?vȴ9X?E?lC?E?-V?5?|h?;dZ?-V?lC?lC?5?|h?      ?|hr?lC?      ?E?j~"?vȴ9X?lC?E?lC?lC?-V?lC?p
=q?&x?      ?bM?Q?E?p
=q?lC?lC?"`?vȴ9X?1&y?      ?      ?-V?;dZ?1&y?vȴ9X?E?Q?lC?;dZ?      ?-V?lC?|hr?A7Kƨ?-V?;dZ?lC?/v?lC?E?lC?5?|h?      ?E?hr!?hr!?      ?      ?(\)?E?;dZ?      ?E?;dZ?-V?5?|h?5?|h?-V?/v?1&y?/v?5?|h?      ?-V?p
=q?vȴ9X?p
=q?lC?lC?Q?/v?p
=q?vȴ9X?;dZ?E?hr!?      ?Q?nP?j~"?vȴ9X?lC?lC?lC?E?lC?E?-V?p
=q?lC?lC?-V?vȴ9X?;dZ?|hr?      ?lC?hr!?/v?Q?;dZ?lC?1&y?      ?vȴ9X?vȴ9X?|hr?vȴ9X?hr!?Q?bM?vȴ9X?-V?;dZ?      ?"`?lC?/v?      ?(\)?lC?"`?p
=q?E?vȴ9X?;dZ?"`?(\)?E?vȴ9X?j~"?Q?      ?/v?      ?1&y?1&y?vȴ9X?`A7L?lC?|hr?p
=q?lC?Q?(\)?vȴ9X?lC?lC?lC?vȴ9X?      ?5?|h?hr!?E?5?|h?5?|h? ěT?5?|h?Q?Q?/v?;dZ?lC?p
=q?A7Kƨ?vȴ9X?lC?lC?      ?      ?      ?|hr?Q?1&y?p
=q?1&y?hr!?lC?|hr?/v?lC?      ?5?|h?/v?      ?E?hr!?vȴ9X?;dZ?|hr?p
=q?lC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@OY@O     @O@O@O     @O@O@O@O@O@O@O@O@O@O@O@O@O@O@O@O@O@O@Offfff@O@O@O@O@Offfff@O@O@O@O@Offfff@Offfff@Offfff@Offfff@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O@Offfff@Offfff@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@Offfff@O33333@O33333@Offfff@O33333@O33333@Offfff@O33333@Offfff@O     @O     @O     @O     @O     @O@O@Oٙ@Offfff@O33333@Pfffff@P33333@P33333@P@P33333@P@P&fffff@PL@P`     @Pffffff@Ps33333@Ps33333@Py@P     @Pfffff@P33333@Pfffff@P@P     @Pfffff@Pfffff@P33333@Pfffff@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@Q      @Q      @P@P@P@Q      @P@Q      @Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @Q      @Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Qfffff@Q33333@Q@Q33333@Q33333@Q33333@Qfffff@Q@Q33333@Q33333@Q33333@Q@Q33333@Q      @Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q@Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q      @Q@Q      @Q      @Q@Q@Q@Q      @Q@Q@Q@Q@Q@Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        P12                                     3                                       	fBC=3P