CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20140212   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P10    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:40.766070Z    ORIGINAL_HEADER      CTD,20250204CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20210615CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2014-07-09. CTD data from cruise 18DD20140212, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20140212. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2014-01/index.php. 
#
# The information in this file for the cruise 2014-01 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2014-01/donneesctddata/2014-01-0082.ctd
#
# Start of originator file comment header
#
#*2014/07/09 16:08:49.62
#*IOS HEADER VERSION 1.10 2011/10/26 2011/10/26
#
#*FILE
#    START TIME          : UTC 2014/02/23 16:30:20.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2081
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : ACD38923
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            3              2104
#       2 Temperature:CTD               deg_C_(ITS90)   1.8242         7.9261
#       3 Salinity:CTD                  PSS-78          32.3708        34.6182
#       4 Sigma-t:CTD                   kg/m^3          25.2476        27.7052
#       5 Transmissivity:CTD            %/m             61.5           68.4
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.2            6.7
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         8.5            291.8
#       8 Fluorescence:CTD:Wetlabs      mg/m^3          0.86E-01       1.414
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2014-01
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P5
#    EVENT NUMBER        : 82
#    LATITUDE            :  48  41.45000 N  ! (deg min)
#    LONGITUDE           : 127  10.04000 W  ! (deg min)
#    WATER DEPTH         : 2098
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0550
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove some records near the surface and many
#	records corrupted by shed wakes; salinity was cleaned.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except that
#	some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in the Sea-Bird
#	Application Note #64-2 of June 2012 (Sea-Bird_64-2_Jun2012.pdf), except that 
#	a small offset in the fit was allowed.
#
#    The Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.8 ml/l from 0 to 100 dbar.
#	±0.6 ml/l from 100 dbar to 300 dbar.
#	±0.2 ml/l from 300 dbar to 800 dbar.
#	±0.05 ml/l below 800 dbar.
#
#    The primary Salinity:CTD channel was used for events 0041 and 0043, so 
#	it was recalibrated to match the secondary channel which was selected for
#	all other casts.
#
#    For details on the processing see the report: 2014-01-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence: 
#!                                  vity: lved:  solve CTD:   
#!                                  CTD   CTD:   d:CTD Wetlabs
#!                                        Volume :Mass        
#!------ -------- -------- -------- ----- ------ ----- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @:         data_max      @:         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     7  .L   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?         data_max      @`        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      7  f   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      
     temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?n   data_max      @ !-w2   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       7     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      
     salinity                	long_name         salinity   units         PSS-78     data_min      @@.}Vl   data_max      @AJڹY   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      7     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      
 )t   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @ffffff   data_max      @rFfffff   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        7 7h   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      
 o8   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?KƧ   data_max      ?lD   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      7 },   CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      
    PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       7    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      
    	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @N33333   data_max      @Q&fffff   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     7    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      
 @   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( Nx   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( N   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      :   data_max      :   C_format      %10d       N   latitude               	long_name         latitude   units         	degrees_N      data_min      @Hr6;   data_max      @Hr6;   C_format      %9.4f          N   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `5g#$6   data_max      `5g#$6   C_format      %9.4f          N   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3P   data_max      3P   C_format      %8d        N   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        r   data_max        r   C_format      %4d        N@:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      @:      ?      @       @      @      @      @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e`     @e     @e     @e     @e     @f      @f@     @f`     @f     @f     @f     @g      @g@     @g`     @g     @g     @g     @h@     @h`     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @      @(     @0     @8     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @(     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @@     @H     @P     @X     @`     @h     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @H     @P     @X     @`     @h     @p     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @      @(     @0     @8     @@     @H     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @(     @0     @8     @@     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @(     @0     @4     @8     @<     @H     @L     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @D     @H     @L     @P     @T     @X     @\     @h     @l     @p     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @X     @\     @`     @d     @h     @l     @p     @t     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @T     @X     @\     @`     @d     @h     @l     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @`     @d     @h     @l     @p     @t     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @<     @@     @D     @H     @L     @P     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @4     @8     @<     @@     @D     @H     @L     @P     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @      @$     @(     @,     @<     @@     @D     @H     @L     @P     @`     @d     @h     @l     @p     @t     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @$     @(     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @$     @(     @,     @0     @4     @@     @D     @H     @L     @P     @T     @X     @\     @`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @ {m@ u!S@ sP@ J@ !-w2@ Vϫ@ iDg8@ iDg8@ o @ @ )^@ H@ -V@ 
=q@ hr @ |@ ͞@ v_ح@ rGE9@ r@ Vϫ@ U2a|@ @ U2a|@ -
q@ {J#:@ {J#:@ '/W@ Vϫ@ H@ oiDg8@ {@ |@ `A7@ -
q@ 1@ U2a|@ 
:@ qi@ U2a|@ r@ :~ @ zG@ 
\@ 
\@ 
\@ 
(@ 
\@ 
(@ 
(@ 
5Xy>@ 
5Xy>@ 
qu"@ 
hr!@ 
@ 
O;dZ@ Ƨ@ xF]@ a@@ ~($@ xF]@ 	@ E84@ ae@s@ ě@Q@ⶮ}Vm@qu!@ңS&@84֡@K]@S@y(@PbM@e+@<쿱[@	@_F@_@$Z1@&@֡a@}Vl@Ňݗ@yrGE8@poiDg8@tm8@I^5?}@Q@..2@(r Ĝ@)^@[W>6@ϐ@Ov_خ@ݗ+k@L_@[6@:S@ᰉ@?@5?|@n.@$tS@B@\>@)^@Xy=@84֡@qiC@څݘ@ᰊ@`A7@DJM@[6@a@N@e1@h>BZc@eO
@Zvȴ@YJE@glC@Z,<@)^@@1&x@?@	k@-w1@vȴ@/@~"@䎊q@KƧ@rG@#w@64@.H@Q@Ձ$/@L_@F]d@֡a@~($@쿱[W@As@*0U@O
M@@Vu@g,@73@ ěT@v@.2@wkQ@ֻ@ ѷ@āo h@'0@+a@>@$tT@@jfB@N;5X@:~@L_@q@!R<@"`B@@{J#9@73@Q@tSM@sh@s@|Q@sPH@o{J#:@Oo @H9Xb@A7Kƨ@m]@u!S@R<6@ƍ@~$@)y@Y|@Vϫ@C\@1@'/W@&I@dTɆ@Ϫ͟@n@Ϫ͟@@1@҈p;@޸Q@6@ݗ+k@sP@n@т@:)y@8YJ@̘_@7Kƨ@&x@h	ԕ@1'@a@O@'/W@o hی@q@mV@R:)y@EoiDg@=E@8F@3g@2䎊q@@ѷX@ae@eS@],=@g	k@ATɅo@:S&@8)@8}H@0'RT@Q@E@Z@-@Q_@S@y=b@weں@q&x@eO
@\u"@d/@p ě@ZY@B@+a@@(	ԕ+@G_o@TO
M@eڹ@d/@kU=@y~($@W$tS@-
@tj~@:)y@Q@)^@Ǔݗ+@Ƨ@(@͸@#9@_ح@	k@%@n.@fIQ@\1&@?˒:)@:)_@*JL@
=p@ᰉ@&@ߤ?@@
qu"@
5Xy>@@	^5?}@;5X@@N@*0@`d@:)y@T`d@/{J#@Mj@Ov_@JE@$Z1@(	ԕ+@)*0U2a@r@q@0
)@o@m\@=p
@(\@[@=K^@A7K@@G#@71@7Xe@.H@*d7@(ۋq
@&'@vȴ9@c	@<64@n@3|@#wk@+j@@@ ѷY@!R<6@'8}H@2GE85@2-V@>6z@FFs@Y|@\1&@a-w1@mw1@u%F
@yD@mhr!@jOv`@_!-w1@D*0@?@6C@iB@#eO@$qj@'8}H@)B@[@|@F]c@4K@Q@~@䎊q@H@\@
qv@>B[@?@ֻ@s@ʌL_@ï@@hr@D@4m@MjO@O
M@U=@͞&@Ov`@x@rGE@L/{J@/@wkQ@҈p@xF@1@A [@kP|@&@oiD@	 @y#w@kU=@g&@`[6@^@\1&@YJE@^ ѷY@Zc	@W&@U=K@Eݗ@=b@<쿱[@9(@.O;@Ϫ͟@E84@$/@#x@zxl"@思IQ@?@Gz@ޞ@"`B@t@N;6@@D@2W@@@2W@M:@%2@tj@I^5@\(@\(@\(@{J#9@ȴ9Xb@D@q@`A@$tT@s@|Q@vz@usg@u!R@u\(@wrG@yD@xF@wkP@x)@w4m@lq@l"h	ԕ@jd7@RnO@V@Vl!-@XPH@WO;d@RsP@Em\@A@?˒:)@@6@2 ě@|@<64@E@Q@E@ᰉ'R@а{@4m@kP@fA@C,zx@l!-@-
@>@m@'RTa@oiDg@@}!.H@{A@~($x@~$t@2W@|hr@be+@[qu!@M5Xy>@>"@<j~#@,<쿱@}H@H@)y@oiDg8@ae@֡af@҉@:)y@+I@v@Q@u!.@I@Qu@poiDg8@\(@K]c@-V@Y}@ǮzH@2W@-V@ߤ?@2W@4m9@t֡a@iy@g,@dTɆ@Xy=c@4j~@/r@+~($@ݘ@
qiC@ ѷX@-
@d7@TɆ@1.@,@Z@l!-@W@xF@ҽ<64@n@.H@@}H@ᰉ'@eO@SMj@)y@@Ϫ͞@Q@
(@r Ĝ@F
L0@%@V@jf@s@+jg@ќu@d7@8}H@lC@唯O
@JE@
=p@TɅo@"h	ԕ@fA@&@e@9@RT`e@d7@v@\(@XbM@$t@Zc@ȴ9Xb@e+@Xy=@w1@y@Ov`@d7@d7@C\@:~ @}Vl@zG@V@e@-w1@҈p;@ce@c	@zG@а{@\(@ ѷ@ [7@hr@(@4K@֡a@4֡a@C]@Ov`@8}H@?@M@
qu@JE@T@I^5?@
L/@@ѷX@NU@IQ@n@@{s@y	k~@}!.H@?@
L/@Zc@|64      @kC,z@_?@\1&@\u"@X_F@J=p
@@hۋq@?@?H˒:@:>B@+C]@$e@>BZ@_p@!R<@
D@L_@\(@p
=@3@}H@3@ 6@TɅo@ ѷX@ 6@#x@)_@s@J#9@C-@#@j~@}Vl@1.@Z@҈p@cA @Xe,@Ж@cA \@o hی@Q@Xe@B@B@ ѷY@Q@6@>BZ@+@Mj@|@y@@E84@@tj@tj@hۋq@{dZ@y"`@v!.I@t!-w2@r ě@r-V@qo@pU2a|@o{J#:@nt@nc	@nzG@m
qv@l1&y@jg	@j0U2a|@i*0U2a@h	ԕ+@d7@c9@^҈p;@\(\@Xe+@VR<6@T`d@Rm@R:)y@OrGE9@LL_@Ik~(@G_o@Eݗ@BZc@4֡a@0U2a|@/v@..2@-8Y@#A [@!ae@䎊r@%@S@+j@$tS@R<6@fA@$/@L_@zG@҉@T`d@)^@
5Xy>@	 ѷ@tj@o hی@ 4m@m]@{m@빌~($@C,z@䎊qj@|Q@A7K@iB@ҽ<64@y@8YK@@Zc@vȴ9X@}Vl@jf@*0U2a@zxl"h@o@+J@ݗ+k@@N@=p
@p:@YJ@$/@v_ح@yrGE8@weں@s@nt@dqj@_Ft@["`B@ZY@H@>BZc @<n.@74m@4m8@2a|Q@/Vϫ@.}Vl@#
=p@!-w1@ߤ@@$tT@
M:@҈@	 ѷ@($x@Gz@$@>6z@D@6@q@o@-
@!-w1@@e+a@%@vȴ9@,=@쿱[W@kP|@ڹY@y"`@v!.I@V8YJ@H@QX@a'R@cS@_o@W>6z@9Y}@8}H@!R<6@u"@$tS@I^5?@n.@
C\@
\(@
~"@

qu@
8YJ@
|@
#9@
a@N@
|hs@

(@
4m@
@
K]@
Y}@
m\@

qv@
S&@
PH@
wkP@
@
u@
Vu@
!R<@
u%F@
M:@
ݗ@
xF]@
7KƧ@
y	k~@
`u!@
W@
S&@
L/{J#@
I@
F-@
E@
G)^@
?H˒:@
8Q@
.2X@
&x@
	@
u%@
+j@
ߤ?@
o h@
Fs@Q@MjO@@*0U@#w@@*0@@-
q@r ě@ceO@M:@8Q@-V@'/V@%1@$/@!.H@Mj@1&x@Q@      @ڹZ@C%@&I@\(@	k~@ݗ@n.@ڹZ@#x@rGE8@,<@m@ѷX@JE@@4@7@1'@@a|Q@w1@a@@IQ@qu!@I^5?@|?@v_ح@sE@p
=q@lVϪ@ZY@JD@'RT`e@$TɆ@Q@_F@u%F@
m]@
حU@
C-@
$/@
kP|@
	@
R<6@
ߤ@@
h	ԕ@
|Q@
^҈p;@
Y>BZ@
b@4@
R䎊@
KƧ@
A [7@
@C@
MjOv@
H@
G)^@
JW'@
NT@
0 ě@
1&@
_o@
tj@
@
zG@
@
)^@

M:@
@
oiDg@
 IQ@	F]d@	-V@	c	@	Dg8~@	ߤ?@	e+@	ӎMj@	͞%@	]cA@	74@	\(@	\(@	*0@	n@	n.@	?@	-
@	Q@	PH@	sh@	0
)@	䎊r@	u"@	O;d@	O
M@	bM@	!R<@	7KƧ@	o h@	~"@	uY|@	\N;@	Z1'@	T*1@	K:)z@	Ca@N@	<n.@	7KƧ@	43@	1[W>6@	-U=@	쿱[W@	nO@	@	Vu@	
O;dZ@	L_@	xF]@~$@!.@%F
L@!R@{m@iDg8@	ԕ+@ᰉ'R@A7K@ᰉ'R@҈p@e@֡af@5Xy>@8YK@b@C-@m8@m\@-V@E@sg@'0@ ě@R<6@҉@qi@@~($x@~($x@L_@ԕ*@S&@?@S&@o h@}H˒@y	k~@q@lVϪ@g8}H@^@XD*@Q@K)^	@E8YK@C$@;/V@2m\@2-V@2W@3|@2-V@/{J#:@*0U2a|@$TɆ@"3@	@S@e+a@PH@*0@Ov_@*0U2@:)y@$tT@-
q@-
q@$tT@Mj@O;d@nO@
qiC@
O;dZ@@$tT@Mj@L_@	ԕ*@oiDg@n.@\N<@s@>B@4֡a@Z1@6@҈p:@_o @_o @_o @@As@;5X@҈p:@E@
=p@ڹY@?@;dZ@`A7L@	@e+@ѷX@J@S&@zG@:S@˒:)@4m9@e`A7L@Q@K)^	@KƧ@JW'@IoiD@H@K)^	@QR@Ks@IoiD@?H˒:@+U=@$/@$TɆ@ 	k@Ov_خ@@
ڹY@ݗ@Y|@iDg8@	ԕ+@iB@1'@حU@As@]cf@dZ@4m@YJ@)y@{@H@W@sg@YJ@#w@b@Ƨ@ߤ?@Ʌoi@@H˒:@m8@,@u%@L_@Z@'RT`@0U2a|@Vϫ@?@a|Q@6z@'RT`@eO@zC\@As@.1@'-@!-w1@#wk@"wkQ@vȴ9@~($x@F]c@#x@+@O;@	k@cA @`d@Z@84֡@)_@IQ@L_@qi@'RTa@o h@vȴ9X@t!-w2@u!R@vȴ9X@z>B@}E@IQ@$/@~($x@xF]d@qA [@sMjO@pD@lC@iB@f,<@dqj@de@V8YJ@Q@JD@I@I@HK]c@Dg8}@?@?H˒:@>6z@C$@E8YK@C@?|hs@?H˒:@?H˒:@=v@9Y}@2a|Q@,q@)*0U2a@"3@vȴ@@@Ov_@
@_o@Vl!@eں@s@-V@oiDg8@C\@Dg8~@حV@ڹY@8YJ@Z@*0U@a@O@2W@)_@4m@-V@
(@ߤ@|@z@6z@@Q@vȴ@e+a@_o@u%F@=K^@wkP@PH@qiC@n/@ѷX@sg@nO;@o@o@n.2@jfB@f1.@\?@W@V8YJ@S@Rm@S@QR@O;dZ@N+@L_@I@Em\@B@@4m@>ߤ?@?@Dg8}@As@@n@<64@:^5?|@7KƧ@.2X@&x@%u@ 'RT`@ߤ@@@ᰉ@@N@u%F
@lC@G{@䎊q@`A7L@o@҈p@Ʌoi@@@]cf@Ƨ-@ěS@s@n@4֡b@H@*0U2a@
=p@	@}H@u%F@O;d@sh@zG@ݗ+k@tj~@nO@:)y@O
M@$/@O;d@@~"@yrGE8@tj~@qiB@q@d%1@`A7K@^҈p;@^5?|@\]ce@Y>BZ@VϪ͟@V8YJ@Zݘ@["`B@P{@M:@J#9@Gy@Eo i@:)y@0
(@*0U2a|@*0
@/{J#:@,q@-U=@"`A@!.H@&IQ@Ov_خ@6C@PH@$tS@zG@҉@Z@4J@
qiC@K]d@@n/@tj@F]c@ 4m9@ڹZ@SMj@iDg8@O;@8Y@(@"h	ԕ@>BZc@`A7L@%1@e@y=c@`d@@
(@<64@p
=@BZc @XbM@4K@9XbN@|@o@U2a|@-V@{J#:@zG@
qv@w1@
qv@zxl"@y@-@&@TɅ@^@@zxl"h@wk@.H@wkP@C,zx@,<@sh@4J@qu"@qiC@ ѷ@@4n@y"`@nc	@m(@k~($@jg	@jOv`@gfA@g@ffffff@g8}H@eڹ@e`A7L@d%1@dZ1@b}Vm@be+@\]ce@XU@W&@Z1'@XbM@V8YJ@UfA@T,<@VϪ͟@Xe+@YJE@R䎊@K:)z@E@B74@ATɅo@5sg@/Vϫ@-B@+6z@*0U2a|@'/V@"3@Q@$/@
qu"@~($x@q@xF]@	 ѷ@F]c@hr@m]@rGE8@kP@_ح@SMj@GE85@ hۋ@O;@C\@\@!-w@"h	ԕ@Q@g	@C,z@x@唯O
@iB@?@$@$@"`B@+@Ϫ͞@ԕ*1@;dZ@/{J#@W'@@E84@
L/@
L/@84֡@@ěS@\N@74@\(@7Kƨ@6@n.@/V@#w@E@'0@ᰊ@Vϫ@1&y@TɆ@-V@o @Mj@ߤ?@qi@O;dZ@@'/@_o@ ѷ@@:S@4m9@~($x@y"`@nc	@irGE@h@h	ԕ+@glC@de@cZ@dqj@e+a@de@c	@bM@]ce@T*1@QR@RT`d@Rp:@P`A7@JD@IoiD@LcA \@L/{J#@IoiD@?|hs@-
qv@'&@%F
L0@#n.3@!-w1@ 'RT`@Ov_خ@0
)@ᰉ@L_@zG@zG@Z@Z@nO@rGE9@\(@qi@҈@
qiC@
	 @
ڹY@
qiC@K]d@K]d@_o@&I@YJ@S&@&I@	'RTa@ݗ@ m\@ J#9@ -
@ -
@ F]d@ PH@ 
=q@ @ iDg8@  hۋ@ O;@ Dg8~@ +a@ 1.@ %1@ |Q@ ޞ@ ]ce@ c	@ ٳ|@ 6@ ڹY@ #9@ Ƨ-@ 2W@ 6@ 6z@ @ 
(@ v@ ߤ?@ vȴ9X@ b@ A@ D@ 3@ Q@ '0@ 2W@  ě@ 2W@  ě@ r@ V@ a@@ I^@ 6z@ 1&y@ }Vl@ H@ ,@ ?@ 3@ !-w1@ u%F@ $tS@ @ @@ PH@ tj@ tj@ +J@ Z@ *0U2@ sP@ hr @ @N@ @N@ nO@ -
q@ M:@ 'RTa@ $/@ @4n@ |PH@ v+jg@ tD@ o@ l!-w@ hr Ĝ@ e@ dZ1@ d7@ bC,@ a@N@ _Ft@ ^@ _?@ ]/w@ Z1'@ VϪ͟@ Sa@O@ Sa@O@ Sa@O@ Q@ I@ @4m@ =b@ <Z@ 6z@ +I^@ &'@ $/@ !.H@ ,<@ 0
)@ R<6@ ݗ+k@ S&@ R<6@ R<6@ Ov_@ Z@ $/@ $/@ O;d@ sh@ zG@ *0U2@ u@ hr @ u@ \(@ Mj@ o @ Mj@ Mj@ o @ )^@ )^@ $tT@ )^@ 4J@ N;6@ o @ @ rGE9@ rGE9@ $tT@ o @ 4J@ sP@ ҉@ S&@ tj~@ tj~@ @N@ ݗ+k@ ݗ+k@ N;6@ qi@ xF]@ 	7KƧ@ ݗ+@ S&@ tj?!.H?"`?#?>BZ?䎊?|?*0U?͞%?n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @@.qi@@.qi@@.%@@.IQ@@.IQ@@.qi@@.qi@@.+J@@.IQ@@.+J@@.qi@@.@@.+J@@.%@@.%@@.@@.qi@@.+J@@.$t@@.qi@@.qi@@.qi@@.qi@@.$t@@.qi@@.@@.@@.qi@@.+J@@.qi@@.qi@@.qi@@.qi@@.qi@@.+J@@.%@@.qi@@.qi@@.+J@@.+J@@.IQ@@.+J@@.%@@.%@@.%@@.}Vl@@.%@@.%@@.@@.@@.qi@@.$t@@.@@.+J@@.@@.@@.,<@@.@@.,<@@.,<@@.@@.Q@@.҈p;@@/)^@@/>6z@@/?@@/+@@01&x@@0@@1 ѷ@@1(@@2䎊@@3C%@@5sg@@7>6z@@<_@@B\(@@Faf@@KP{@@O@@@S~$@@Vs@@\?@@^"@@e*0@@iu@@jS&@@l"h	ԕ@@o-@@r:)y@@s6@@x@@xd8@@y_o@@{S&@@|hr@@~($@@5?|@@@@q@@Ft@@@4n@@sh@@@@l"h	@@%@@ߤ?@@b}@@S&@@ߤ?@@
=p@@;dZ@@>BZ@@p
=@@o h@@;dZ@@@@TɅ@@iB@@h	ԕ@@Zc@@S&@@C]@@9XbN@@Ģ3@@}H@@,=@@sPH@@љ@@\N@@u@@U=@@@N@@Z@@wkP@@ܞ쿱[@@V@@S&@@zxl"h@@?@@@@R@@@@(@@eں@@	@@˒:)@@$xG@@n@@IQ@@)@@$/@@Q_@@Z@@qu"@@@@T@@Q@@!.I@@$xG@@@N@@ [7@@@@-w1@@e+@@>B@@n@@"`B@@S@@|@@s@@ݗ+k@@ߤ@@@J@@"h	ԕ@@/{J#@@9XbN@@:@@V@@O;dZ@@S&@@`A7L@@@@@@Ϫ͞@@?@@H˒@@+j@@sg@@fA@@jOv@@ݗ@@!R@@v@@%@@ݗ@@}H@@B@@N;@@_@@!R<@@$/@@c	@@ߤ?@@x@@C-@@x@@쿱[W@@Mj@@Mj@@!.I@@Ft@@1@@Xe,@@	k@@o @@+@@@@حV@@@@@䎊r@@NU@@@@fA@@@@3@@+@@䎊r@@Q@@$tT@@N;5@@rGE@@74@@"`B@@/V@@=K^@@ڹY@@S&@@7Kƨ@@A [@@rGE8@@oiD@@0
)@@4֡b@@@@0
)@@0
)@@TɅo@@u@@@@Q_@@Zc@@I^5@@e@@.H@@:)y@@ڹY@@%1@@o h@@Z@@O;dZ@@/@@eO@@D@@u%@@74@@qu!@@A@@҈@@tj@@tj@@<쿱@@tj@@%2@@6@@dZ@@s@@m\@@n@@W@@`A@@kP|@@xl"h
@@kP|@@^5?|@@M@@ᰊ@@ ě@@fB@@I^@@)^	@@MjO@@a@N@@qu!@@tj~@@~$@@$@@@@/{J#@@PH@@hr@@*0@@IQ@@u"@@|@@a@O@@9XbN@@?@@?@@*0@@%F
L@@*0@@/@@?@@o h@@SMj@@*1@@_@@@@@@Ʌoi@@hr@@e@@>@@2a|@@u@@p:~@@c	@@R<6@@p:~      @@Fs@@͞@@حV@A Xy=@A @ArGE@A#w@A:S@Au!S@AM@AL/{@AL/{@A@AL/{@As@ATɅo@ATɅo@A"`@A䎊@A-V@AT`d@AW@A ѷ@AڹY@A@AڹY@A=K^@AC%@AP{@Aqu!@A$@A5Xy@A\N@A,<@AZ1@A[W?@Ao i@AV@A\@A}H@Ahr!@A%@AH˒@A@A?@A,=@A(@Aᰉ@Aᰉ@AE@AC\@At@A_o @Aڹ@A!.@A
(@A($x@AL/{J@Al!-@A-@Aߤ?@A!.I@AFt@A.H@A>6z@AO
M@A_o@AU=@AXe,@AiDg8@A	@A@ArGE9@A     @A
qu@AF]d@AfA@A/V@AحV@A	ԕ+@A:~ @Atj@A@AIQ@A-
@A-
@A˒:*@Au!@AbM@AXy=@AXy=@A˒:*@A@@A4֡b@APH@A		k~@A	#w@A	#w@A	0
)@A	=b@A	TɅo@A	k~(@A	'R@A
n@A
1'@A
&IR@A
䎊@A	>BZ@A	"`@A	ᰉ'@A	iB@A	e@A	e@A
@A
6C@A
M@A
M@A
@4n@A
^5?|@A
p:@A
ᰊ@A
W@A
>B@Au%@A/V@Atj~@AS@Aqu!@Aa@N@An.3@AxF]@AZ@Am]@A@A{J#9@Ajf@AdZ@A@AZ@A"`B@A
䎊q@A
~@A
fB@A
~@A
74@A=K^@AW>6z@AJ#9@A=K^@AF]c@AP{@A]cA@A~($@AxF@A!-w2@Aj~#@AwkP@AJ@A@A҈@AƧ@Aa@@Aݗ+k@Aa@O@A@AS@AU=@AA@Aq@Aq@AMj@AQ@A)^	@A
n@A
S&@A
	 @A
GE85@A6z@Ag@AQ@A
Vl!@A
%@A
C\@A_o @A
1@A
!R@A
fA@A
O;dZ@A
2a|@A
!.H@A
!.H@A
+j@A

qv@A
\(@A
8Y@A
@A
@A
Y|@A
<64@A
5Xy>@A
`A7L@A
}H@A
hr!@A
%@A
%@A
!R@A
O;dZ@A
p
=@A@A}Vl@A%@A+@A|hs@A-@AbM@A@A	k~@A{@ATɅ@A@A@Ae+@A@A@A$/@A [7@Ae+@AQ_@AW@A5Xy@A
=p@A$@A\N@Am]@Aߤ@Aq@Awk@Aߤ@Aa@O@A5Xy@AƧ@A$@A1&y@A1&y@AcA \@A[W?@AD@Aqu"@AVl!@A?@Ac	@AA@A hۋ@A)^@A+I@AE84@Ay@A?@A[W>@A3@Ao @A     @A:~ @ANU@A[6@AeO@A-
@Ap:@A҈p@A@N@Ahr @An.@Ay@AR@AlD@A&IR@A6C@A@4n@AM@AZc@AkP|@A{m@A\(@AwkQ@AS&@AY@A<64@An@A<64@AY@An@AfB@A䎊q@AC,@AfB@AS@A@A2W@AC,zx      @A҈@Aߤ@@A?@A64@AVϪ@Ao h@A쿱[@ATɆ@A?@A#x@A1&@Aj~@AQ@Ace@Ahr!@AϪ͞@A.2@AH@AYJ@As@A,<@A'@AXe@AH˒:@ART`e@AU=@A_o@AsPH@A@AfA@A *0@A H@A H@A n@A ѷX@A ҈p@A!rGE@A!0
)@A!|Q@A!'RTa@A!|@A!@A!e@A"=p
@A"T`d@A"W'@A"a|Q@A"^5?|@A"d7@A"kP|@A"~"@A"g	@A"@A"C,@A"c	@A"G{@A"c	@A"74@A"D@A#u%@A#C,z@A#/V@A#9@A#C%@A#P{@A#Z@A#dZ@A#~$@A#eO@A#U=@A#S@A#S@A#*0U2@A#|@A#ݗ+k@A#҈@A#A [@A#\N@A$@A$"h	ԕ@A$?@A$M:@A$`d@A$q@A$o h@A$C@A$_@A$j~@A$/@A$D@A%K]@A%[@A%%F
L@A%zxl"h@A%hr!@A%%@A%@A%@A&($x@A&+jg@A&8YJ@A&E@A&_ح@A&IQ@A&qi@A&O;@A&af@A&af@A&af@A&}Vl@A&'@A&@A&ȴ9X@A'
=p@A'1@A'U=@A'eں@A'b}V@A'o@A'y@A'O;d@A'&@A( ě@A(1&x@A(4m9@A(73@A(Xy=@A(r Ĝ@A(YJ@A(-
@A(u%F@A({@A(ѷX@A)$/@A)rGE@A)&x@A)7KƧ@A)hr @A)|Q@A)~($@A)@A)R<6@A)o@A)7Kƨ@A)@A)'RTa@A)'R@A)D@A)iB@A*I^5@A*e+@A*&IR@A*C\@A*@4@A*\(@A*S&@A*ᰊ@A*0
@A*0
@A*L/{@A*>B@A*)_@A*,<@A*䎊q@A*m@A*D@A+I^@A+҉@A+'/@A+s@A+C,z@A+33333@A+F]c@A+P{@A+MjO@A+MjO@A+J#9@A+J#9@A+S@A+]cA@A+n.3@A+:)z@A+@A+@A+|@A+@A+Z@A+a@O@A+E@A+q@A+q@A,1&y@A,9XbN@A,M:@A,]ce@A,j~#@A,wkP@A,qj@A,qj@A,*1@A,S@A,3@A,zxl"@A,Ʌoi@A,?@A,Ʌoi@A,j~@A,Ʌoi@A,Ʌoi@A,*0@A,*0@A,Z@A,>B[@A,u"@A,/@A,Z@A-K]@A-K]@A-%F
L@A-<64@A-L_@A-IQ@A-fA@A-=K@A-@A-8Y@A-b@A-cA @A-1@A-sh@A-,=@A-ڹ@A.zG@A.$/@A.+jg@A.?@A.BZc @A.E@A.l!-@A.IQ@A.@A.A@A.쿱[W@A.Fs@A."@A/
=p@A/v@A/$tS@A/$tS@A/E84@A/[W>@A/˒:)@A0     @A/䎊r@A/@A/حV@A/;dZ@A/حV@A/Vϫ@A/+j@A0F]d@A0
qu@A06@A0 ě@A0 ě@A0}H@A0}H@A0Xy=@A0U2a|@A0_F@A0u!@A0-
@A0y=c@A0-
@A0
(@A0@A1#w@A1XbM@A1e+a@A1hr @A1x@A1rGE8@A1x@A1l@A1ԕ*@A21'@A2h	ԕ@A2ᰊ@A2}Vm@A2W@A2W@A2 ѷ@A2c	@A3nP@A3=K^@A3Z@A3qu!@A3{J#9@A3~$@A3eO@A3:)z@A3A@A3eO@A3~$@A3*0U2@A3*0U2@A3S@A3~$@A3Z@A3W>6z@A3nP@A3	@A3s@A3@N@A3C%@A3Z@A3@N@A2D@A3nP@A39@A3,zxl@A3&@A3&@A3=K^@A3@A3xF]@A3~$@A3jf@A3]cA@A3jf@A3tj~@A3tj~@A3~$@A3Q@A3:)z@A3ߤ@A3wk@A3$@A3:)z@A3S@A3@A3g@A4J@A4n.@A4@A4J@A3\N@A3$@A3s@A3\N@A4@A41&y@A4Q@A4<쿱@A49XbN@A4SMj@A4m8@A4#@A4_@A41&@A4j~@A4j~@A4TɆ@A4e@A5V@A5K]@A5[@A5'0@A5!.H@A5!.H@A5Q@A5qu"@A52a|@A5%F
L@A5*0@A5qu"@A5*0@A5/w@A55Xy>@A5F
L0@A5IQ@A5\@A5-V@A5U=@A5U=@A5U=@A5sh@A5n/@A5H˒@A6Ov_@A6!R<@A6?@A6R<6@A6\N<@A68YJ@A6Ov_خ@A6Ov_خ@A6_ح@A6l!-@A6p:~@A6iB@A6\N<@A6\N<@A6YJ@A6H@A6R<6@A6H@A6Ov_خ@A6R<6@A6L/{J@A6H@A6L/{J@A6L/{J@A6iB@A6}Vl@A6+J@A6qi@A6+J@A6qi@A6+J@A6$t@A6,<@A6,<@A6@A6af@A6ߤ?@A7 hۋ@A7Ft@A6"@A6Fs@A7 hۋ@A7
M;@A7
M;@A7!-w1@A7!-w1@A7$tS@A7O
M@A7\(@A7_o@A7_o@A7_o@A7iDg8@A7iDg8@A74m@A7$tS@A73@A7@A7+@A7حV@A7@A7fA@A7;dZ@A7@A7䎊r@A7䎊r@A7#@A8bM@A8}H@A8*0@A8H@A8Xy=@A8[6@A8eO@A8hۋq@A8[6@A8YJ@A8tj@A89Xb@A8
(@A8ěT@A8)^@A84֡b@A8C@A9	k~@A9	k~@A9@A9@N@A94J@A9Dg8~@A9A [@A9JE@A9XbM@A9^@A9^@A9hr @A9rGE8@A9b}@A9B@A9_o@A9s@A:0U2a|@A:C\@A:-V@A:)y@A:1'@A:@A9Y}@A9.H@A:	 @A:M@A:)y@A:Ov`@A:@A:䎊@A:#9@A:䎊@A:#9@A:-V@A:0U2a|@A::)y@A:T`d@A:T`d@A:M@A:d7@A:qiC@A:{m@A:ᰊ@A:L/{@A:S&@A:wkQ@A:wkQ@A:vȴ@A:͞&@A:,<@A:䎊q@A;I^@A;S&@A:c	@A:C,@A:~@A;nP@A;s@A;	@A;33333@A;)^	@A;/V@A;F]c@A;Z@A;Mj@A;s@A<!-w2@A<tj@A<xF@A<n.@A;g@A;ݗ+k@A;lC@A<%1@A<Fs@A<q@A<TɆ@A<Ʌoi@A<Z@A<Z@A<@A<Z@A<JM@A<*1@A<M:@A<2W@A<C,zx@A<3@A=K]@A=u@A=Q@A=2a|@A=%F
L@A=%F
L@A=[@A<E@A<D@A<hr@A<>@A=(@A=qu"@A='0@A=o i@A=:@A='0@A=Q@A=F
L0@A=IQ@A=F
L0@A=O;dZ@A=fA@A=fA@A=`A7L@A=zxl"h@A=v@A=@A=hr!@A=+j@A=1@A=-V@A=@A=\(@A=Ϫ͞@A=8Y@A> ѷY@A=ڹ@A>
L/@A>4K@A>4K@A>@A>!R<@A>1.@A>1.@A>;5X@A>p:~@A>fffff@A>}Vl@A>Q@A>Q@A>@A>m\@A>҈p;@A>x@A>!.I@A?
=p@A?$tS@A?,@A?'/W@A?!-w1@A?$tS@A?+I@A?8}H@A?H˒:@A?Xe,@A?_o@A?Xe,@A?_o@A?iDg8@A?sPH@A?o@A?iDg8@A?lC@A?b}V@A?\(@A?U=@A?O
M@A?RT`e@A?U=@A?b}V@A?|hs@A?	@A?|hs@A?y@A?|hs@A?|hs@A?sPH@A?v_ح@A?|hs@A?	@A?O;d@A?@A?O;d@A?-V@A?͞@A?͞@A?˒:)@A?@A?حV@A?@A?;dZ@A?@@A?-@A@F]d@A@	ԕ+@A@*0U@A@*0U@A@}H@A@$xG@A@1&x@A@>BZc@A@73@A@A7K@A@K]c@A@Q@A@U2a|@A@Xy=@A@[6@A@_F@A@[6@A@eO@A@YJ@A@'RT@A@@A@IQ@A@u%F@A@IQ@A@u%F@A@4m@A@)^@AA@AA@N@AA@AA [7@AA*0U2a@AA&x@AA7KƧ@AAGz@AAN;5@AAhr @AA7Kƨ@AAo@AA@AA@AAR<6@AAo@AAo@AA(@AA|@AA_o@AAԕ*@AA"`@AA"`@AA>BZ@AA@AB1'@AB#9@AB#9@AB&IR@AB-V@AB&IR@AB0U2a|@AB)y@AB䎊@ABZc@ABa|Q@ABa|Q@ABa|Q@ABd7@ABd7@ABu%F
@ABqiC@ABkP|@ABqiC@ABu%F
@ABxl"h
@AB~"@AB{m@AB{m@ABu%F
@ABL_@ABS&@ABS&@ABᰊ@ABwkQ@ABY@ABW@AB,<@AB,<@AB)_@AB͞&@ABfB@ABG{@ABڹY@ABڹY@ABfB@ABc	@ABc	@ABm@ABD@AB~@AC'/@ACI^@ACs@ACnP@ACnP@ACnP@ACPH@AC"`B@AC33333@AC9@ACS@ACW>6z@ACP{@ACP{@ACZ@ACZ@ACdZ@ACjf@ACg	l@ACn.3@ACQ@ACMj@AC*0U2@ACm]@ACm]@ACE@ACa@O@ACE@ACƧ@AC|@AC@AC
=p@AC
=p@AC|@ACݗ+k@ACݗ+k@AC҈@AC%2@ACQ@ACݗ+k@AClC@ACg@ACg@AClC@AClC@AClC@AC$@AC@AC@ADߤ@@ADn.@ADxF@ADL_@AD!-w2@AD%1@AD"h	ԕ@AD,<@AD2W@ADI^5?@ADg8}@ADcA \@ADcA \@ADj~#@ADg8}@ADm8@ADm8@ADq@ADo h@ADtSM@ADwkP@ADwkP@ADtSM@AD~($x@AD~($x@AD_@AD_@AD*1@ADC@ADqj@AD3@ADS@AD쿱[@ADS@ADqj@AD*1@AD?@AD[W?@AD@ADɅoi@ADj~@AD!-w@ADE@AE:@AE'0@AEu@AE*0@AE(@AE84֡@AE?|h@AEY|@AES&@AE\@AEY|@AEVl!@AEce@AEce@AEce@AEfA@AEm\@AEp
=@AEzxl"h@AEڹZ@AEXy=@AEXy=@AE@AEXy=@AE%@AEv@AEXy=@AE1@AEXy=@AE-V@AEH˒@AEH˒@AE8Y@AEcA @AEcA @AE@AE8YK@AE
qv@AE
qv@AE,=@AE(@AE(@AEoiDg@AE!.@AEڹ@AEڹ@AF ѷY@AF_o @AF_o @AFt@AF4K@AF@AFzG@AFu@AFOv_@AFu@AF1.@AF5?|@AF;5X@AF?@AFE@AFL/{J@AF_ح@AFs@AF+J@AFIQ@AFIQ@AF+J@AFqi@AF@AFFs@AF,<@AFT@AFT@AF6z@AF-@AF2X@AF&I@AF+@AFC-@AFC-@AFC-@AFߤ?@AF1@AF@AF쿱[W@AF쿱[W@AF쿱[W@AF@AF@AG hۋ@AG@AGv@AGv@AGXe@AG,@AG.H@AG+I@AG4֡a@AG8}H@AGE84@AG\(@AGv_ح@AGiDg8@AGsPH@AGlC@AGv_ح@AGv_ح@AG4m@AG{J#:@AG&@AGO;d@AG	@AG&@AG&@AG&@AG	@AG@AGO;d@AGݗ+@AGkP@AG	k@AG͞@AG	k@AG-V@AG?@AG	k@AG͞@AG͞@AGzH@AGzH@AGzH@AG&@AGzH@AGvȴ9@AG@AGK]d@AGo @AGK]d@AGحV@AG;dZ@AG@AG;dZ@AG;dZ@AG;dZ@AGVϫ@AG#@AH	ԕ+@AH	ԕ+@AH@AH*0U@AH@AH}H@AH$xG@AH}H@AH$xG@AHQ@AHD*@AHQ@AHeO@AHeO@AHeO@AHeO@AHeO@AHhۋq@AHoiDg8@AHbM@AHr Ĝ@AHr Ĝ@AH|@AHy=c@AH˒:*@AH'RT@AH-
@AH@AHtj@AH'RT@AHIQ@AHu%F@AH-
@AH
=q@AHIQ@AH@AHIQ@AHU@AH4m@AH4m@AHTɅ@AHѷX@AHF@AHD@AHD@AHѷX@AHѷX@AHF@AHۋq
@AH`A7@AHe+@AHe+@AHC@AH`A7@AH@AH\)@AH\)@AH	k@AI ѷ@AI	k~@AI_p@AI [7@AI7KƧ@AI:S@AIN;5@AIQ@AI^@AIe+a@AIe+a@AIo hی@AIk~(@AIrGE8@AIx@AIu!S@AIb}@AIb}@AI@AIoiD@AIR<6@AIR<6@AI@AIR<6@AI|@AID@AIo@AI_o@AIᰉ'@AI.H@AJ	 @AJOv`@AJ1'@AJ-V@AJ6C@AJ:)y@AJ=p
@AJC\@AJ=p
@AJ:)y@AJ@4n@AJ@4n@AJ:)y@AJC\@AJ=p
@AJC\@AJGE85@AJJL@AJJL@AJQ_@AJQ_@AJW'@AJZc@AJW'@AJ^5?|@AJZc@AJT`d@AJT`d@AJW'@AJZc@AJW'@AJW'@AJW'@AJZc@AJZc@AJ^5?|@AJZc@AJT`d@AJ^5?|@AJ^5?|@AJZc@AJ^5?|@AJ^5?|@AJT`d@AJ^5?|@AJW'@AJZc@AJW'@AJd7@AJqiC@AJu%F
@AJxl"h
@AJ~"@AJݘ@AJݘ@AJ0
@AJS&@AJwkQ@AJn@AJ)_@AJW@AJ͞&@AJsP@AJڹY                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @r1@r;33333@r<@r<@r;33333@r6fffff@r333333@r0     @r4@r<@rFfffff@r4@r8     @r1@r1@r<@rA@r;33333@r4@r<@r0     @r6fffff@r<@r8     @rFfffff@r333333@r0     @r;33333@r<@r8     @r;33333@r;33333@r4@r8     @r333333@r333333@r6fffff@r6fffff@r6fffff@r1@r)@r8     @r1@rA@r.fffff@r333333@r<@r333333@r1@r9@r+33333@r;33333@r1@r1@r1@r1@r0     @r,@r!@r@r      @r!@r@r@r!@r(     @r@q     @q     @q33333@q     @q@q33333@q33333@q33333@p     @pnfffff@pT@pNfffff@pFfffff@pl@pNfffff@n)@mٙ@m@mfffff@m@m     @m     @n33333@n	@mC33333@mI@mi@mi@ms33333@l@k     @ki@k,@j33333@kY@k33333@i@ifffff@ii@g33333@gS33333@gfffff@gfffff@f@fp     @f@f33333@dfffff@dfffff@d|@ds33333@dc33333@d`     @d33333@d33333@d\@c@c\@b@bS33333@bS33333@b33333@cfffff@aə@a@as33333@as33333@a@ap     @as33333@a33333@al@aS33333@`y@`Y@`     @`33333@`fffff@`fffff@`fffff@`@`@`fffff@`@`     @`i@`ffffff@`S33333@`i@`s33333@`i@_l@_     @_33333@_@_@`fffff@^33333@^33333@^@^     @_      @_@^@^@^y@^@^     @^33333@^ٙ@]fffff@^333333@]33333@]33333@^9@]s33333@]@]@]Y@],@]9@]`     @]l@]l@\ٙ@\33333@]@]9@]@]fffff@]ٙ@]@]     @[l@[9@[fffff@[@ZY@Z33333@Z@Z     @Zfffff@Z     @Z@Y@YS33333@YS33333@Y@Y333333@Y,@YY@Yy@Yfffff@Yٙ@XFfffff@Xl@Xl@X     @X@X     @X     @Xl@T33333@T@TFfffff@T33333@U,@U     @U@Ufffff@Vffffff@VFfffff@VS33333@V@Vfffff@V9@V`     @VS33333@U@U@U     @U33333@Vfffff@Tfffff@U,@T@U333333@U9@R@R33333@R@R33333@S9@Sy@S@S33333@S@Sffffff@S33333@R33333@Rfffff@R33333@S      @R     @R@R     @R     @Rfffff@Rٙ@R     @Rfffff@Rٙ@Rٙ@R     @R     @R     @Rfffff@Rfffff@Rfffff@Rl@R,@RS33333@RL@R@R9@RFfffff@Rl@QS33333@Q     @Q     @Q`     @Q@Qfffff@Q@Qfffff@Q      @P     @P@P     @P     @Q,@P33333@P@P33333@P,@P     @P     @P33333@PS33333@Pfffff@PS33333@Pfffff@Pl@P@     @P      @Os33333@O333333@O      @O&fffff@Offfff@O     @O@N&fffff      @M@     @Lfffff@L&fffff@L      @K33333@L@     @L@K33333@K      @J@I     @Jٙ@K      @K@KY@Ks33333@K333333@K      @J     @J33333@Jfffff@J@Is33333@Ifffff@I     @Iffffff@I      @I@I      @I      @H@Hfffff@IL@HL@Gfffff@F     @G@FY@G@F33333@FL@F&fffff@F@G      @G&fffff@Fٙ@Efffff@F@F@Fffffff@E@F333333@F@F      @E33333@E@Eٙ@F@E33333@E@D33333@Dٙ@D     @Dfffff@D     @Dfffff@Dfffff@D@DL@D      @Cfffff@C     @Cٙ@Cffffff@D      @C     @D&fffff@Cfffff@C333333@B33333@C     @Bfffff@C333333@C333333@C@Cs33333@Cs33333@Bfffff@C@     @CL@B@C@Bffffff@B@C&fffff@Bfffff@BL@B&fffff@B&fffff@B      @Bffffff@Afffff@B&fffff@B333333@A33333@A@A33333@A@A33333@Aٙ@Afffff@Affffff@A     @Afffff@Afffff@A@     @A@A&fffff@AY@@fffff@A@@ٙ@@fffff@@@     @@fffff@@@@ffffff@@Y@@     @@333333@?33333@@ffffff@@Y@@ffffff@?fffff@@L@@@     @@fffff@@L@@ٙ@@fffff@@&fffff@@fffff@@Y@@     @?fffff@?@?fffff@@&fffff@?33333@?@?@>ffffff@?@?L@?      @>@?L@>      @?     @@      @>@=fffff@@     @>@?@?@?L@?@?@?@?333333@@fffff@@L@?      @?L@?@?ffffff@?     @?     @<     @;     @;333333@;33333@<L@;33333@=      @<33333@<@=L@;fffff@<      @:@<33333@<     @;      @=333333@<     @<ffffff@<L@:@=ffffff@;      @=L@;33333@<@;fffff@:33333@9333333@933333@9L@8@9     @8fffff@9     @7      @7@7     @7     @7L@7333333@7ffffff@7fffff@6@533333@5@3fffff@4      @3333333@4@3333333@4@4@4L@3fffff@3     @4333333@3ffffff@1@4333333@3@3@4      @2ffffff@233333@1L@1L@233333@033333@2@2fffff@1      @0333333@0@.ffffff@/333333@033333@0@.@0     @0333333@-      @/333333@/      @,      @/ffffff@/ffffff@/ffffff      @.@/      @,333333@-@.333333@.      @-333333@,      @-@)333333@+@-333333@-      @,ffffff@,@-      @.@+333333@+@,@,333333@*      @-333333@,      @-333333@+      @*ffffff@)333333@*@+      @'@*@'@*333333@*ffffff@)      @)      @*333333@*      @)@)333333@)@(@(@)@(ffffff@(      @'333333@'ffffff@)333333@(333333@(@(ffffff@'@'333333@)      @(      @'333333@'333333@'@'333333@&@'      @&ffffff@&      @%      @&333333@'@&333333@&333333@)333333@%@&333333@$333333@%333333@$333333@%ffffff@%@&      @%333333@%@$      @$@%      @$      @&333333@$@%      @$ffffff@%ffffff@%      @%333333@%ffffff@%333333@$      @$@$      @$333333@'      @#333333@#@%@#@$@$ffffff@$@$@$@$@$ffffff@$333333@&@ @%@$@#@&@ ffffff@%@"      @$333333@$333333@333333@#ffffff@"333333@"@%@"@#@#ffffff@#@#333333@#333333@$      @"333333@#333333@$      @'333333@#ffffff@"@"@#333333@"      @#@#      @#@"      @#333333@#333333@#      @"@%333333@ 333333@#ffffff@$333333@!@!@#      @$      @!@"333333@"@"@"@"@"@"@"@"@"@"333333@#      @ @$      @"@"@!ffffff@"333333@$@!333333@#@"ffffff@"@"@!@$      @$@"333333@!@#@ ffffff@#333333@       @#@%      @ @ @"@#@"333333@!@ @#ffffff@"@!@#@"@       @%333333@!333333@%      @#ffffff@@$333333@!ffffff@#@ @#@&@$@333333@!@!@#@$ffffff@%      @ffffff@"@ 333333@#      @$@!ffffff@#      @!      @$333333@$ffffff@$@ ffffff@"      @!@#ffffff@&      @      @#ffffff@'@"@ @"@!@ ffffff@ffffff@$@@#@#ffffff@$ffffff@!333333@$@%333333@"      @$      @%333333@       @$333333@#333333@#      @#333333@#      @#ffffff@#      @#      @#333333@#333333@#333333@#333333@"ffffff@#333333@#ffffff@#333333@#333333@#333333@#333333@#333333@#333333@%      @"      @#@%333333@*@"@!@#@$@#@&      @!@&@(ffffff@$ffffff@#@#      @$333333@$      @$      @#@&333333@"ffffff@%@$@#ffffff@&      @#@%@$      @%333333@%ffffff@$@$@$@$@&      @%ffffff@$@$@%333333@%333333@%333333@%@'333333@$@%ffffff@%333333@'333333@&@'ffffff@&@$@&      @&      @&@#ffffff@%@(333333@%@%333333@&      @(ffffff@%333333@%333333@'@'@%@%ffffff@&@&      @&      @&      @&      @&@%333333@&333333@'      @&      @&      @&333333@%333333@'333333@)@"      @&@(      @'@&@'333333@!333333@$@*      @&      @'333333@'333333@&@%      @'@&@&@&333333@(      @&333333@&@'@&ffffff@&@*333333@%ffffff@(@(      @'@'ffffff@'333333@(333333@&@'333333@%ffffff@'      @'      @)ffffff@&@(333333@)      @&@&333333@(      @'@(ffffff@*333333@'333333@)@(ffffff@(333333@+      @%@+@'@+      @*@(@)ffffff@(@(@(@,@%ffffff@*      @(333333@(333333@(@(@(@(@(@(@)333333@)@(      @)      @)      @)@+333333@'@)@)333333@)@(@*333333@(ffffff@+333333@#@*ffffff@*333333@)@)@)@(@+@'@+@-      @+333333@*@*333333@)@)333333@+ffffff@*@*333333@,333333@)@*ffffff@+333333@-333333@0333333@*@+@+333333@*      @+      @*@,ffffff@(@.333333@*@.      @*@,      @+@+@,      @,      @,ffffff@,@.      @+@,@,@-ffffff@+333333@/333333@-@/333333@+ffffff@-333333@-ffffff@.333333@-@,333333@/ffffff@2333333@(@033333@0333333@,@-@1L@/      @.333333@.333333@.333333@/333333@/      @/@-@+@0@0     @-@.@1@*ffffff@1@.@0      @/      @.      @/      @/@,@0     @/      @0     @0fffff@.@0      @0      @0ffffff@/ffffff@0L@0      @1@0333333@/@0@0333333@0     @0     @0333333@0fffff@1ffffff@0@0     @0     @1      @1@3333333@1333333@1333333@1@1     @133333@3      @1fffff@2ffffff@2@2333333@0@0@2     @1fffff@2@2L@2@2L@1fffff@2fffff@2@5333333@2fffff@2fffff@2     @2     @2     @2@2@2@3333333@3@2@2@2fffff@3333333@4     @2fffff@2fffff@2fffff@333333@4333333@2fffff@3@3333333@3333333@3333333@2@3@2fffff@3@4ffffff@3L@4ffffff@433333@3fffff@3fffff@4333333@5fffff@2     @5@4@7fffff@4@4333333@5333333@5@6L@5@6333333@6L@6      @7      @6     @6     @5fffff@6333333@6333333@6fffff@7L@7333333@633333@7@6     @833333@7333333@5ffffff@7333333@7L@5333333@9     @6fffff@7L@5      @733333@7@633333@633333@7333333@7      @5@7333333@9333333@6@6@6     @6@7      @6@7333333@6@6333333@7@733333@7@7@7     @733333@7ffffff@7ffffff@7ffffff@8L@6@7@8@8     @7fffff@8      @:L@633333@933333@733333@833333@8@8@8@8@8fffff@8@8ffffff@7     @8L@9     @8ffffff@:     @9fffff@7     @:333333@9      @9@:     @:333333@9     @9     @9     @;      @;@:L@933333@933333@9@:ffffff@=@:L@:ffffff@=@;      @;33333@;@8fffff@<333333@<333333@;@:L@<@<fffff@>@;     @=333333@<@;      @=33333@;@=L@?     @;@=@<@>@<ffffff@=      @=      @=      @=      @=      @=L@=L@<@>@>ffffff@=ffffff@=ffffff@=ffffff@=ffffff@=ffffff@>      @<@>ffffff@>@=33333@=33333@<L@>33333@>     @>@>ffffff@>     @>      @@@     @=@@     @>     @>     @@@=@?@>      @@33333@?@@      @@s33333@?ffffff@>     @@fffff@?     @?333333@@      @@@?@@s33333@>fffff@@@     @@     @?fffff@@@@ٙ@@@?L@A333333@?L@@@Aٙ@@@@ffffff@?333333@@fffff@@@@s33333@@ٙ@@     @@fffff@@@@     @@     @@ٙ@@@@@A33333@@s33333@@33333@A@     @?ffffff@@fffff@A     @@     @A      @@33333@@     @A@A&fffff@A@     @AL@@fffff@A@     @A@     @A     @A     @AY@A@@ٙ@Afffff@AY@A@A@AL@A33333@A&fffff@Afffff@BY@Afffff@As33333@As33333@A@A     @BL@A@@33333@B333333@A     @A@     @A&fffff@B@B@     @AL@Afffff@Bfffff@B      @A@C@A33333@C      @BY@B33333@B@Bs33333@B&fffff@B@B@C      @B     @C333333@B33333@C     @A@     @Bٙ@C@CY@C@CL@B33333@C@B333333@C     @B     @B@B33333@D@C&fffff@Cffffff@C@     @C@CY@CY@CY@CY@CY@C@C33333@C@C@D@C@C@Ds33333@CY@C33333@Bٙ@E@C     @Cfffff@D      @C33333@C     @D@D333333@D@Effffff@Ds33333@DY@D@Dfffff@DL@Ds33333@D@Dٙ@Ds33333@E      @D@D@D     @EY@D     @E@     @D@F@D33333@E      @E@     @Effffff@D@Dٙ@E@     @E@     @D@Efffff@FL@E      @E&fffff@EL@E@Eٙ@D33333@E@Efffff@D@E33333@EL@F@E     @FY@F@Efffff@Efffff@E     @EL@F      @F&fffff@F@F&fffff@F@F@F333333@Eٙ@Fffffff@F@E@     @E33333@Eٙ@E@G&fffff@Fffffff@E@G      @F      @Fffffff@F33333@F333333@FY@G333333@G333333@F&fffff@G&fffff@Fs33333@F@F33333@F     @FY@G@Gs33333@F333333@D@F@G33333@F33333@Gs33333@Gffffff@F33333@F@FY@G@GY@Gs33333@H@G     @G@G&fffff@G     @E@G@Gs33333@G&fffff@G     @H@H@G     @H      @G@G333333@Hs33333@GY@H33333@Gٙ@Hffffff@Fٙ@F33333@H     @Gٙ@Gٙ@Gٙ@H@Hٙ@H@H333333@H@Hffffff@G33333@Hfffff@Gfffff@Hٙ@Gٙ@Hfffff@I      @G@F33333@I333333@E@I333333@I      @IY@G     @IY@Hffffff@H33333@I@J      @I@     @G     @Jٙ@Hٙ@JL@I@HL@J@I333333@Iٙ@Iٙ@Hfffff@I     @JY@Ifffff@I@JL@I@J333333@Iٙ@JL@Ifffff@Iٙ@JY@JY@K@I     @J     @I33333@K333333@K@J     @Jfffff@K@KL@J@K      @Ks33333@J333333@KY@Jfffff@Jٙ@Jٙ@Jٙ@Jٙ@Jٙ@Jٙ@Jٙ@K      @J     @J@K      @K&fffff@Jٙ@K@J333333@K33333@J@J@K&fffff@K     @K@KY@Is33333@KY@Jfffff@Jfffff@K@K      @J33333@Jٙ@K@I@J@Jfffff@Lfffff@I@Lffffff@K&fffff@KY@L@     @Kffffff@K@K@KY@KY@L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ?旍O;d?+I?旍O;d?+I?;dZ?+?\(?$/?`A7?`A7?+?dZ1?;dZ?1&x?1&x?`A7K?ěS?p
=q?S?$/?+I^?;dZ?vȴ9X?lC?lC?I^5?}?C%?E?\(?1&y?r ě?E?nO?p
=q?S?+I^?Q?XbM?-?1&?C%?`A7?zG{?
=p?n?lD?xF?1&?$/?j~"?~"?Q?r ě?(\)?\(?`A7L?M?-V?-V?`A7?ffffff?ffffff?`A7?E?Q?\(?=p
=?`A7K?C%?\(\?bM?
=p?bM??|hs?7KƧ?&x?9XbM?vȴ9X?S?&x??|hs?M?Q?`A7K?zG{?\(?333333?Q?Q?Q?GzH?|hr?`A7L?      ?hr!?"`A?+?1&?vȴ9?KƧ?^5?|??+J?+?+?QR??vȴ9?+?+???vȴ9?S?+?+?"`B?XbM?lC?lC?1&?dZ1?+J?QR?"`B?+?lC?QR?KƧ?1&?XbM?+J?+J?+?XbM?lC?bM?"`B?1&?vȴ9?lC?lC?E?"`B?+?dZ1??"`B?XbM?1&?E?dZ1?lC?lC?S?QR?^5?|?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?XbM?lC?lC?lC?lC?lC?lC?+?QR?lC?lC?lC?lC?lC?XbM?lC?lC?lC?lC?lC?lC?E?+J?S?+J?lC?lC?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC??lC?+?"`B?lC?lC?lC?lC?lC?lC?hr!?      ?hr!?lC?lC?lC?lC?lC?QR?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?lC?lC?lC?lC?lC?+?1&?lC?lC?lC?      ?Q?-V?hr!?lC?lC?lC?lC??1&y?hr!?E?lC?lC?Q?j~"?lC?lC?lC?lC?lC?lC?lC?lC?QR??lC?      ?-V?lC?lC?-V?1&y?lC?lC?lC?lC?lC?XbM?QR?lC?lC?lC?lC?lC?      ?-V?lC?QR?lC?lC?      ?j~"?lC?lC?lC?E?lC?lC?lC?p
=q?bM?lC?p
=q?|hr?lC?lC?"`?/v?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?hr!?lC?lC?lC?lC?lC?lC?lC?lC?lC?hr!?hr!?lC?lC?-V?lC?lC?vȴ9X?|hr?lC?lC?lC?/v?      ?-V?lC?lC?      ?      ?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?      ?-V?lC?lC?lC?lC?lC?lC?lC?j~"?Q?lC?1&y?vȴ9X?(\)?;dZ?lC?lC?lC?lC?lC?lC?vȴ9X?j~"?|hr?(\)?lC?vȴ9X?-V?j~"?      ?      ?/v?vȴ9X?hr!?1&y?p
=q?lC?lC?p
=q?(\)?lC?1&y?Q?lC?lC?lC?"`?|hr?lC?lC?/v?      ?-V?lC?5?|h?lC?lC?/v?lC?E?lC?lC?"`?lC?/v?vȴ9X?lC?1&y?p
=q?Q?|hr?j~"?vȴ9X?lC?lC?lC?(\)?-V?p
=q?Q?lC?-V?lC?lC?lC?E?-V?lC?lC?lC?lC?5?|h?/v?lC?lC?lC?lC?lC?-V?p
=q?lC?lC?lC?lC?lC?E?5?|h?p
=q?5?|h?/v?Q?lC?lC?lC?lC?lC?/v?hr!?      ?hr!?p
=q?      ?lC?lC?-V?Q?lC?lC?lC?lC?lC?lC?Q?"`?lC?vȴ9X?lC?/v?dZ1?lC?lC?lC?1&y?Q?lC?j~"?      ?      ?-V?lC?lC?lC?lC?lC?p
=q?      ?Q?lC?lC?lC?lC?vȴ9X?      ?/v?lC?lC?lC?-V?      ?vȴ9X?(\)?      ?lC?(\)?      ?hr!?lC?lC?Q?Q?j~"?lC?-V?      ?j~"?      ?lC?1&y?      ?      ?-V?-V?p
=q?lC?lC?lC?lC?Q?5?|h?j~"?vȴ9X?lC?Q?hr!?lC?"`?/v?lC?lC?lC?lC?1&y?"`?j~"?      ?lC?lC?5?|h?      ?;dZ?lC?lC?lC?lC?lC?      ?;dZ?lC?lC?      ?E?lC?lC?lC?vȴ9X?1&y?lC?lC?lC?lC?Q?hr!?Q?hr!?      ?      ?Q?(\)?"`?E?      ?E?p
=q?      ?lC?E?`A7L?      ?E?p
=q?/v?      ?-V?      ?vȴ9X?lC?Q?      ?      ?
=p?ěS?      ?      ?      ?      ?      ?      ?      ?j~"?^5?|?E?hr!?/v?ěS?j~"?Q?lC?5?|h?Q?      ?E?      ?-V?"`?
=p?1&y?      ?5?|h?lC?1&y?hr!?-V?j~"?-V?      ?Q?lC?Q?      ?5?|h?p
=q?      ?      ?E?"`?-V?      ?p
=q?-V?&x?E?lC?hr!?5?|h?lC?vȴ9X?lC?lC?"`?5?|h?lC?/v?      ?;dZ?hr!?      ?vȴ9X?lC?lC?|hr?hr!?Q?      ?      ?(\)?lC?lC?lC?lC?ěS?ěS?vȴ9X?"`?E?vȴ9X?hr!?5?|h?E?lC?vȴ9X?"`?lC?(\)?      ?"`?E?&x?lC?lC?vȴ9X?j~"?$/?Q?bM?1&y?lC?lC?vȴ9X?5?|h?      ?nP?`A7L?-V?E?      ?      ?      ?      ?lC?vȴ9X?E?lC?lC?lC?;dZ?      ?      ?      ?E?lC?lC?vȴ9X?      ?lC?;dZ?      ?E?1&y?vȴ9X?(\)?"`?lC?      ?p
=q?5?|h?lC?-V?      ?-V?"`?vȴ9X?vȴ9X?lC?lC?"`?5?|h?vȴ9X?;dZ?lC?      ?1&y?nP?`A7L?E?vȴ9X?      ?      ?      ?      ?Q?&x?      ?lC?lC?lC?vȴ9X?      ?      ?      ?      ?      ?"`?lC?lC?lC?lC?-V?      ?lC?lC?lC?1&y?      ?vȴ9X?lC?j~"?      ?hr!?lC?lC?lC?      ?      ?      ?      ?      ?vȴ9X?1&y?vȴ9X?Q?p
=q?lC?lC?      ?      ?      ?      ?-V?-V?E?hr!?      ?      ?|hr?lC?lC?lC?p
=q?      ?      ?      ?      ?"`?lC?;dZ?      ?5?|h?E?      ?      ?      ?lC?5?|h?      ?      ?1&y?lC?5?|h?      ?      ?;dZ?lC?|hr?lC?|hr?;dZ?p
=q?vȴ9X?E?      ?vȴ9X?      ?`A7L?E?lC?      ?hr!?ěS?E?lC?vȴ9X?      ?      ?E?(\)?Q?lC?lC?;dZ?GzH?7KƧ?      ?lC?lC?lC?lC?lC?lC?lC?lC?lC?      ?      ?      ?      ?hr Ĝ?GzH?      ?lC?      ?      ?      ?      ?/v?-V?-V?lC?lC?lC?lC?;dZ?lD?      ?p
=q?p
=q?5?|h?      ?lC?lC?lC?hr!?      ?lC?lC?lC?      ?      ?      ?      ?      ?      ?      ?lC?bM?5?|h?vȴ9X?lC?-V?/v?|hr?lC?lC?lC?lC?-V?      ?      ?hr!?p
=q?E?1&y?Q?lC?      ?      ?      ?      ?      ?      ?      ?      ?5?|h?lC?lC?j~"?      ?      ?(\)?vȴ9X?lC?lC?lC?lC?lC?lC?      ?hr Ĝ?lC?lC?lC?p
=q?      ?"`?lC?lC?      ?lC?vȴ9X?      ?      ?      ?-V?Q?1&y?Q?/v?      ?      ?vȴ9X?p
=q?lC?`A7L?|hr?hr!?j~"?lC?vȴ9X?lC?(\)?      ?lC?lC?lC?vȴ9X?Q?p
=q?lC?lC?E?      ?1&y?-V?|hr?-V?lC?lC?      ?      ?      ?/v?      ?lC?vȴ9X?      ?p
=q?      ?lC?hr!?5?|h?lC?hr!?|hr?lC?(\)?Q?j~"?5?|h?-V?lC?vȴ9X?lC?E?      ?lC?p
=q?A7Kƨ?p
=q?/v?      ?5?|h?-V?vȴ9X?lC?lC?lC?E?"`?lC?lC?j~"?      ?j~"?5?|h?      ?      ?lC?vȴ9X?      ?5?|h?lC?lC?lC?Q?5?|h?lC?lC?7KƧ?      ?lC?lC?lC?lC?lC?p
=q?      ?      ?      ?      ?Q?lC?7KƧ?E?lC?E?Q?      ?1&y?vȴ9X?lC?lC?lC?lC?;dZ?;dZ?lC?vȴ9X?Q?lC?-V?      ?      ?;dZ?lC?lC?      ?      ?      ?      ?"`?lC?lC?lC?p
=q?lC?lC?"`?      ?j~"?/v?      ?      ?Q?/v?Q?lC?lC?lC?      ?1&y?lC?lC?vȴ9X?hr!?lC?vȴ9X?j~"?Q?lC?Q?      ?p
=q?lC?/v?;dZ?1&y?      ?      ?      ?p
=q?lC?/v?vȴ9X?lC?lC?lC?Q?hr!?vȴ9X?lC?      ?      ?      ?      ?(\)?;dZ?lC?lC?p
=q?Q?lC?lC?(\)?"`?;dZ?-V?/v?vȴ9X?E?j~"?lC?lC?vȴ9X?vȴ9X?lC?p
=q?      ?p
=q?E?lC?      ?vȴ9X?lC?lC?lC?lC?"`?      ?      ?      ?      ?      ?5?|h?lC?lC?lC?lC?lC?lC?1&y?      ?      ?1&y?lC?lC?vȴ9X?lC?lC?lC?-V?j~"?      ?lC?E?1&y?lC?lC?lC?1&y?1&y?XbM?"`?lC?j~"?vȴ9X?lC?lC?vȴ9X?hr!?lC?lC?lC?lC?p
=q?|hr?lC?5?|h?      ?j~"?lC?lC?lC?|hr?bM?lC?hr!?"`?lC?lC?lC?5?|h?/v?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?/v?Q?lC?lC?lC?lC?hr!?      ?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?j~"?|hr?lC?lC?lC?lC?lC?lC?lC?Q?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?hr!?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?/v?      ?      ?      ?hr!?lC?lC?|hr?+J?lC?Q?lC?lC?lC?-V?vȴ9X?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?j~"?lC?vȴ9X?lC?lC?lC?(\)?5?|h?lC?-V?      ?"`?lC?lC?lC?lC?Q?-V?p
=q?E?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?vȴ9X?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?      ?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?vȴ9X?      ?p
=q?lC?lC?lC?lC?lC?lC?lC?vȴ9X?lC?|hr?"`?lC?lC?lC?lC?lC?lC?lC?lC?lC?(\)?Q?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?;dZ?lC?lC?lC?lC?lC?lC?-V?(\)?^5?|?lC?lC?lC?p
=q?lC?lC?lC?lC?lC?lC?lC?lC?lC?Q?lC?lC?lC?lC?lC?lC?lC?1&y?      ?j~"?lC?lC?lC?lC?lC?/v?5?|h?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?p
=q?"`?lC?lC?lC?lC?lC?lC?lC?lC?lC?"`B??lC?      ?/v?XbM?lC?+J?+?+?+J?lC?^5?|??|hr?lC?lC?1&y?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?E?lC?lC?lC?5?|h?lC?lC?lC?lC?lC?lC?lC?lC?E?Gz?lC?lC?lC?lC?lC?lC?1&?lC?lC?lC?lC?lC?lC?"`A?tj~?lC?lC?lC?|hr?-V?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?Gz?"`B?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?lC?dZ1??lC?lC?lC?lC?lC?E??lC?lC?lC?lC?lC?^5?|?dZ1?(\)?lC?XbM?/v?lC?lC?lC?lC?lC??"`B?"`A?lC?XbM?+?"`B?lC?lC?vȴ9?XbM?lC?lC?lC?lC?lC?lC?lC?lC?      ?vȴ9?lC?lC?lC?lC?E?vȴ9X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@O@O@O     @O333333@O&fffff@N33333@OL@O@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Oٙ@Offfff@O33333@O33333@O33333@Oٙ@O     @O@Offfff@O33333@O33333@O33333@P      @O33333@O33333@P      @P      @Pfffff@Pfffff@Pfffff@P      @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P33333@P33333@P@P@P,@P,@PS33333@P`     @Pfffff@P@P33333@P@P33333@P33333@Pٙ@Pٙ@P     @Pfffff@P@P@P@P@P33333@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@P@P@P@P@P@Q      @P@Qfffff@Qfffff@Qfffff@P@Q      @Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@Qfffff@P33333@P@Q      @Qfffff@Q      @Q      @Q      @P@Q      @Q      @P@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @Q      @P@P@P@P@P@Q      @P@P@Q      @P@P@P@P@Q      @Qfffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @P@P@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Qfffff@Qfffff@Q      @Qfffff@Qfffff@Qfffff@Q@Q@Q@Q@Qfffff@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q33333@Q@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q@Q@Q33333@Q33333@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q33333@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q33333@Q@Q@Q33333@Q33333@Q@Q@Q@Q@Q33333@Q33333@Q@Q33333@Q33333@Q@Q@Q33333@Q33333@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q@Q@Q@Q@Q33333@Q33333@Q33333@Q33333@Q33333@Q@Q@Q@Q33333@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Qfffff@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @P@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q33333@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q@Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @P33333@Pfffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q33333@Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q&fffff@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q@Q@Q@Q@Q      @Q      @Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q@Q      @Q@Q      @Q      @Q      @Q@Q      @Q33333@Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q      @Q      @Q      @Q      @Q      @Q      @Q@Q@Q@Q@Q@Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          P10                                     1                                       :BC93Pr