CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P25    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.349267Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @R@        data_max      @R@        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @_   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d            temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?O
M   data_max      @\ߤ@   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d        @   salinity                	long_name         salinity   units         PSS-78     data_min      @@Sq   data_max      @AKn.3   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      >    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G`   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @2        data_max      @s33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > W    	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d          CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?^5?|   data_max      ?O;d   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       > @   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       1   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @J   data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > A`   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      +   data_max      +   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HmǤ   data_max      @HmǤ   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      aY_a   data_max      aY_a   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @R@     @333333@333333@333333@ 333333@"      @$      @&      @(      @*333333@+@.      @0      @1      @2      @3      @4      @5      @5@6fffff@7@9@:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V33333@W33333@W@     @W     @W     @X      @X@     @X     @Xٙ@Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z@[      @[@     @[     @[     @\fffff@\@     @\     @\     @]      @]@     @]     @]     @^      @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`33333@`@a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f@g      @g      @g@     @g`     @gy@g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j33333@j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l33333@m	@m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @nc33333@n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pq@p~fffff@p     @p     @p     @p     @p     @p     @p     @q      @q@qfffff@q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q     @q     @r      @r     @r      @r1@r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @sfffff@s      @s0     @s@     @sP     @s`     @sp     @s     @s@s     @s     @s     @s     @s     @s     @t      @t     @t      @t,@t>fffff@tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @tfffff@t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v!@v333333@v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wNfffff@wffffff@wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x     @x     @x     @x     @y      @y     @y      @y0     @y@     @yQ@y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y񙙙@z@z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @zfffff@z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|fffff@|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~a@~nfffff@~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @>fffff@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @'33333@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @33333@@     @     @     @     @     @     @     @     @     @@fffff@     @      @     @     @     @      @(     @0     @8@@     @H     @P     @X     @`@h     @p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @@@     @     @     @      @(@-@8@@     @H     @P     @X     @`     @h@p     @x     @     @     @     @     @     @     @33333@     @     @     @     @     @@     @     @     @      @     @     @     @      @(     @0@8@@     @H     @P     @X     @`@g33333@p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @6fffff@@@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X@`@h     @p     @x@33333@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @ @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@p@x     @     @     @     @     @     @     @     @     @33333@ə@     @     @     @     @     @     @      @     @     @fffff@"fffff@(     @0     @8     @@     @H     @M@X     @`     @h     @o33333@y@     @     @     @     @     @@@     @     @     @     @     @     @@fffff@     @      @     @     @     @      @(     @0     @8     @?33333@I@P     @X     @`     @h     @p     @x     @     @@fffff@     @     @     @     @@     @     @     @     @     @     @     @      @     @     @     @      @(@/33333@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @@     @      @     @     @     @      @(     @0     @8     @?33333@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@fffff@@     @     @     @     @     @     @     @      @     @     @     @      @(     @.fffff@<     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@     @33333@      @     @     @     @ @(     @0     @8     @@     @H     @P     @X     @`@h     @p     @x     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @33333@     @     @ @33333@     @     @      @(     @0     @8     @@     @H     @Nfffff@[33333@`     @h     @p     @x     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @񙙙@     @      @     @     @     @      @(     @,@8@@     @H     @P     @X     @]@h     @p     @x     @     @fffff@     @     @     @     @     @     @     @     @33333@ٙ@     @     @     @     @      @     @     @fffff@33333@     @     @     @      @$     @(     @,     @0     @4     @733333@<fffff@@     @D     @H     @L     @P     @T     @W@a33333@d     @h     @l     @p     @t     @x     @|     @fffff@fffff@fffff@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @fffff@@     @     @fffff@@     @     @      @     @     @     @@fffff@     @     @      @$     @(     @,     @0     @4     @8     @;@?@D     @H     @L     @P     @T     @X     @\fffff@`fffff@d     @h     @l     @p     @t     @x     @|     @@33333@     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @ϙ@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @K33333@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @fffff@@@     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @fffff@33333@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,fffff@/@4     @8     @<     @@     @D     @Hfffff@J     @P     @T     @X     @\     @`     @d     @h     @l     @o33333@t@x     @|     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @ϙ@fffff@     @     @     @     @33333@     @     @     @     @     @ fffff@     @     @     @     @     @     @     @      @$     @(     @+@/@4     @7@<@@     @D     @H     @L     @P     @T     @X     @`@d     @h     @l     @p     @t     @x     @z@fffff@     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @@@     @     @     @     @     @     @ݙ@     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @      @$     @'33333@-@0     @4     @8     @<     @@     @D     @H     @M@P     @T     @X     @\     @`     @c@h@l     @p     @t     @x     @|     @@fffff@     @     @     @     @     @     @     @33333@@     @     @     @     @fffff@@@     @     @     @     @33333@     @     @     @     @     @     @33333@     @     @@fffff@     @     @     @     @@      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @      @fffff@	@     @     @     @     @     @      @#@(@,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @W@\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @@     @     @     @     @     @י@fffff@     @     @     @     @@     @     @     @      @     @@
33333@     @     @     @     @      @"fffff@(     @,     @0     @4     @8     @<     @@     @C33333@Hfffff@L     @P     @T     @X@\     @`     @d     @h     @l     @n@tfffff@x     @|     @     @     @     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@      @     @     @     @     @33333@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @J@P     @T     @X     @\     @`     @d     @h     @lfffff@pfffff@t     @x     @|     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @ϙ@     @     @     @     @     @     @     @     @󙙙@     @     @      @     @33333@@     @     @     @fffff@ @$     @(     @,     @0     @4     @8     @<     @@     @D     @Hfffff@K@P     @T     @X     @\     @^@dfffff@h     @l     @p     @t     @x     @|     @     @     @     @33333@     @     @     @     @     @fffff@     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @뙙@     @     @     @     @      @     @     @     @     @     @     @fffff@33333@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @R@X     @\     @`     @d     @h     @k@q33333@t     @x     @|     @@fffff@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @33333@33333@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @9@<     @@     @D     @H     @L     @P     @S33333@Y@\     @_@d     @h     @l     @p     @t     @x     @|     @     @33333@     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @@     @     @     @fffff@     @     @     @     @     @     @     @     @@      @     @     @     @     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @k33333@p@t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @癙@33333@     @     @     @     @      @     @     @     @     @     @     @     @ fffff@#@(     @,     @0     @4     @8     @<     @@     @D     @I33333@L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @@@     @     @     @     @     @     @ݙ@     @     @     @     @     @     @     @     @      @@     @     @     @     @     @     @      @#33333@)33333@,     @0     @4     @8     @<     @@     @C@I33333@L     @P     @T     @X     @\     @_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @Y|@Zu%F@Y_o@Z1'@ZkP|@Zݘ@[=K^@Zc	@[6@\ߤ@@Zc	@X*0@Xy=c@Y>BZ@ZkP|@Zc	@T,<@TFs@F]cf@&'@	oiD@l@@U=@͞&@fA@`A7L@@4@҈p@
qu@!-w1@iB@u@u@5?|@ce@?@C,zx@u%@ڹY@u%F@>BZ@PH@ؓtj@ק&@@ֻ@ᰉ@2a|@`d@҈p:@bM@@{J#9@C\@%@lC@|@qi@&x@Ϫ͟@\C,zx@&fffff@F]d@xF@5?|@#9@:~ @8}H@+a@҈p;@l!-@|@TɅo@pU2a|@kC,z@glC@W@@ѷX@+~($@@p:~@.H@Fs@E@8Y@䎊qj@R@Q@qiB@P)^@-V@9@
(@͞&@{lC@@6@ᰉ@ݲ-V@ɅoiD@s@ߤ?@P-
q@H1&x@8l"h	@ ěT@T`d@/V@5?|@6z@@S@N@N!R<@L@H@?|hs@G#@Em\@O\(@C{J#9@W@u?@mC\@kU=@ix@k~($@n1@q&x@o@nt@iB@b@4@Y0
)@Rm@O'/W@L@OrGE9@T@d/@>BZc@8Y@nP@Ft@+I^@/O
M@3ߤ@7eں@Ao hی@F]cf@^iB@Zvȴ@Sa@O@L@G)^@12W@(Xy=@(\@C\@x@>BZ@ƍ@\@U=@ߤ@@u%@@z~@xQ@weں@ov@c
=p@Vaf@N;5X@+I^@sPH@L_@˒:*@ [7@%F
L@*0U2a@Ft@l!-@̈́M:@qiC@ĵ?@@)_@v@x@-w1@$@+j@tj~@Mj@8YK@}K]@q&x@h\)@c
=p@Y>BZ@Oo @F]cf@DS@=ڹZ@3g	l@&IQ@$Z1@ ěT@Xe,@@
L/{@@!.H@!.@	@ӎMj@/{J#@@j~#@D@4K@S@u%@R<6@@     @hۋq@:S@yrGE8@qu!S@j~"@a|Q@T`d@JW'@<Z@0 ě@%zxl"h@1&@nO@
=p
@#@eO@	7KƧ@nP@Vl!@+@s@-V@O;@C\@.2@c	@t@4֡a@-V@Y|@_ح@iB@-V@C,z@Z@8YJ@
M;@s@)^@\N@@TɅo@@@p
=@5Xy@dZ@S&@)y@^5?|@~@Z@4m@m8@?|h@Xy=@sg@sg@sg@}Vl@b@n@6@ěS@E84@y@@ȴ9Xb@ɺ^5?}@n@Ƨ@Ƨ@@@W'@̘_@:@jOv@ȴ9Xb@E84@2W@s@s@˒:)z@҈p:@@ܑN;@fA@+@@;5X@͞%@v_ح@ҽ<64@N;5@*0U@
M;@͞%@As@fA@b}@W>6z@ۋq@حV@d8@حV@@N@䎊qj@fA@ hۋ@u!S@_ح@(@H˒@JM@+I@	k~(@'/W@4J@:)y@ݗ+k@ᰉ@6C@,=@vȴ9@"h	ԕ@#
=p@$TɆ@'RT`e@)lD@+a@@/r@2a|Q@5Xy=@7KƧ@5sg@0 ě@.H@.H@0
(@7KƧ@=<64@@6@C@F
L/@F-@J#9@K)^	@L@O͞@V8YJ@eڹ@poiDg8@rs@lC@nc	@e`A7L@`A7K@^ ѷY@T*1@P`A7@N;5X@L_@LcA \@K:)z@IQ@F?@@NU@>
(@?@C,zxl@C@D2W@C,zxl@;5Xy@;A@:^5?|@8YJ@8}H@64K@49XbN@3ߤ@3|@6E@64K@5?@5?@64K@8}H@9XbM@9~($@8Q@8}H@73@7KƧ@6C-@2m\@.H@,>B[@,<쿱@)*0U2a@%zxl"h@!R<6@U=@u@u%@PH@@$tS@@@O
M@nO@:)y@hr @rGE9@
ڹY@	ԕ*@	 ѷ@u%F@#@ݗ@u%F
@@$/@$tS@$t@Vl!@PH@~$@s@1@+jg@E@u!S@D@:~ @@ hۋ@O;@.2@(@JL@@	ԕ+@>BZc@fA@lC@8}H@A@1.@+a@Z@S@S@	@C,@@4@@4@M@e@ᰉ'R@ᰉ'R@Gz@d8@u!@u!@ߤ?@ܑN;@b}@حU@حU@e+@JE@>BZ@>6z@&@͞%@Q@]cf@š@g8}@,zxl@s@A@sg@W@2W@H@d7@9@u"@$tS@O
M@Mj@L/{@eO@JM@@~\N<@}ڹZ@}Vl!@zG{@y	k~@xl"h	@wkP@j~"@f1.@bC,@_;dZ@[q@XU@UfA@NT@E84֡@BZc@=<64@:)y@8)@8)@8)@7KƧ@1-@%F
L0@S@R<6@o @L_@	ԕ*@@
b}V@
"`@
A [@
VϪ@
rGE@
d8@
JE@
`d@
*0U@
@
ɺ^5?}@
ěS@
TɅo@
Y}@
ᰊ@
zG@
d7@
x@
h	ԕ@
-w1@
6C@
+J@
sh@
Vu@
YJ@
     @
{s@
u!.@
nt@
h>BZc@
d%1@
]+j@
W&@
QX@
H9Xb@
Ca@N@
B\(@
@C@
=v@
73@
2a|Q@
/{J#:@
)y@
!.H@
Q@
S@
Vu@
L/{@
F]c@
      @
      @s@#@.2@C,@D*@cA \@˒:*@Õ$@H˒:@n.@)y@o@*0U2a@wk@_o@$/@@qiC@Q@ѷX@{s@zC\@y(@xF]d@v_ح@u!.@u%F
L@tSMj@p
=q@iᰉ'@e+a@a'R@^ ѷY@Yb}@U2a|@RT`d@K:)z@G)^@A [7@9D@49XbN@2W@.}Vl@*d7@&IQ@"3@wkP@S&@bM@xF]@o hی@lC@1@A [@"h	ԕ@JL@`A7L@/w@
=p@@_p@;5X@s@ɺ^5?}@\N@6@BZc @p
=@)@ߤ@r@U=@/@	k@!-w1@S@vȴ@tj@*0@bM@@     @p
=q@k~($@g@ceO@^iB@SZ@N_o @KƧ@Eo i@<쿱[@74m@4֡a@3g	l@0U2a|@-
qv@-B@*0
@&L/{J@#
=p@%@e+a@҉@
(@#@{J#9@u%F
@I^5@ 4m9@
b}V@
E@
?@
-
@
䎊q@
VϪ@
lC@
Z1@
e@
t@

M;@
ǮzH@
n@
4K@
O
M@
2X@
<쿱@
$xG@
F
L0@
.H@
U=@
,=@
u"@
@
L_@
p:@
@
$/@
.H@
|PH@
v!.I@
poiDg8@
gfA@
ffffff@
d7@
^҈p;@
WsPH@
Rm@
OAs@
G@@
@C@
=<64@
-U=@
u%@
tj@
@
u@
Vu@
p:@
Q@	\N<@	H˒@	PH@	J#9@	>B@	(@	F]d@	_ح@	@	t@	Q@	>BZc@	1.@	e+@	(\@	JE@	`d@	H@	_o @	@	)^@	o i@	s@	
(@	~@	YJ@	m8@	
(@	>B[@	\)@	&@	R<6@	[@	S&@	҈@	+I@	˒:)@	~\N<@	zG{@	u!.@	t#@	tD@	r䎊q@	o@	mC\@	jfB@	_Ft@	Vl!-@	T`d@	S@	Rp:@	MjOv@	GzH@	C,zxl@	>vȴ9X@	9Y}@	5?@	3|@	/v@	*0U2a|@	&'@	#S&@	!-w1@	 -
@	䎊r@	!-w1@	@	*0@	sP@	u@	~($x@	&I@	%2@	 ѷ@	u%F
@	:S@G{@@t@c	@
qu@fA@|@ɅoiD@E84@@D@sg@o@{J#:@H@U=@@,@h	ԕ@Q@6C@@@O;d@@R<6@ᰉ@O
M@@tj~@:)y@)^@\(@ߤ?@L_@1&x@@z@u%F
L@t!-w2@r ě@kC]@g	k@eO
@ceO@`u!@S&@GzH@<j~#@8Q@49XbN@2ᰊ@/{J#:@,zxl"@'RT`e@&@$tSM@!o@C,zx@,<@u%F@@@
@q@
L/{@eO@+I@@ ѷX@hr@	k~@g@@c	@!-w@ᰉ'@+a@C,@cA @ܑN;@b}@@ěS@@n@BZc @Z@j~#@dZ@^5?|@XbM@3@m8@Vϫ@-
@Q@PH@nO@hr @bM@Mj@@$tS@xl"h	@weں@rs@mhr!@fA@dZ1@cA [@d7@bC,@a|Q@`d8@]+j@Xy=c@T*1@R<64@P`A7@O͞@N_o @L/{J#@NT@K]cA@GzH@Dg8}@B@>BZc @;/V@6z@1&x@2W@-w1@'-@$xF@vȴ9@[@=K^@Xe,@hr @o @
(@
qiC@S&@tj@I^5@ IQ@$tS@m\@#x@{m@O;@C@fA@eO@d8@ݗ+j@bM@т@]cA@)^@o i@|hs@64@)_@}H@֡a@2X@Xy=@zxl"h@Q@_o@O;d@ݗ+k@\(@!R<@@C%@p:@n/@}!.H@u!R@r䎊q@oiDg8@m8Y@h@g8}H@e+a@a|Q@]cA @XU@W>6z@U2a|@SMj@Rp:@P{@HK]c@F
L/@C@<Z@:~@9Y}@4֡a@/{J#:@,q@(TɅ@%u@"`A@[@@*0@*0U2@nO@hr @)^@o @@Mj@!R<@
L/{@Q@m\@#x@J#9@-
@E@u!S@8Y@x@䎊qj@e+@A7K@5?|@ۋq@m@
M;@_o @͞%@jOv@̘_@n@@@Ƨ-@|hs@D@4m@Xe@Xy=@|@ᰊ@
qv@U=@^@/V@%@kP|@+j@zG@hr @@qi@M:@qu"@qiC@eO@+I@Q@F]c@     @}ڹZ@{m]@xF@u%F
L@pD@poiDg8@p
=q@o-V@ix@g	k@h	ԕ+@g@bC,@bC,@_o@^ ѷY@\N;@Zݘ@Yb}@XbM@W@T*1@Q_p@O
M;@L_@I^5?}@F
L/@>
(@<64@8YJ@5?|h@4J@2W@0U2a|@-V@(TɅ@$/@#S&@䎊r@!-w1@kP|@Xe,@R<6@*0U2@4J@ߤ?@~($x@@o h@($x@m]@F]d@+@!.I@_ح@j~@@ ě@@8Y@Ov`@fffff@@N@6@ٳ|@l!-@@T`d@ѷX@`A7@v_ح@cA \@*0@C@NU@
(@64@Y}@?@֡a@|@W@{J#:@<쿱@jf@RT`e@u@R<6@'RT`@-
@'RT`@U=@Q@}H@u%@tj@S&@҈@k~(@eO@ݗ@o h@nP@@~m\@{lC@u\(@rGE85@q@poiDg8@o4֡a@o hۋ@l!-w@jJL@e@`u!@`d8@Zc	@ZQ_@Z1'@UϪ͞@Rp:@O͞@J#9@F-@C,zxl@A [7@ATɅo@@C@@n@?@?H˒:@?H˒:@=<64@:^5?|@9XbM@6z@2m\@1&x@.H@,>B[@+a@@*0
@(@($xG@&IQ@ 	k@U=@IQ@=K^@Xe,@sh@zG@@N@nO@:)y@:)y@u@@n/@I^5@ IQ@$tS@H˒@?@>B@=b@_ح@PH@oiDg8@쿱[W?@P{@rGE@Z@@N@;dZ@cA @?@6@+@D*@>6z@Ϫ͟@l!-@,<@ҽ<64@а{@˒:)z@Q@K]c@m\@*0@84֡@NU@v@K]@A@dZ@dZ@)_@/V@Y}@YJ@4m@Xe@}Vl@z@E@?@3@9XbN@g	l@o@U=@-@L/{J@
=p@3@	k@U=@}H@_o@+J@tj~@n@4J@)^@-
q@!R<@O;dZ@O;dZ@@I^5?@'/@7KƧ@u%F@u%F
@|Q@zG{@y(@x-
@w1@v_ح@vFs@t#@nO;@jfB@hۋq
@hr Ĝ@glC@g@e@cS@a|Q@`u!@`
qu@_?@^҈p;@]/w@[$@Z1'@W>6z@UfA@T*1@Sa@O@Rp:@Q@P*0U@M5Xy>@I@F
L/@C,zxl@B@BZc@>6z@;A@9D@9#w@8)@84֡b@84֡b@6C-@12W@/O
M@+U=@+I^@($xG@%S@$?@#wk@ [6@쿱[W@Ov_خ@-V@1&@wkP@6C@*0@Ov_@4J@
(@~($x@
	 @1&x@Q@o hی@E@xl"h
@j~@A [@t@C,z@Ov`@Ov`@x@@8}H@fffff@䎊qj@ߤ?@iB@ce@6@c	@e+@@sPH@
=p@՛=K@ӎMj@а{@s@Q@š@a@N@Zc@s@TɅo@@dZ@Xy=@J@-V@V@*0U2a@-@@/@?@3@[6@Ov_خ@IQ@u%@PH@O;d@$/@hr @bM@ߤ?@L_@YJ@ѷX@}ڹZ@{lC@zxl"h
@x-
@tj~@ql@o-V@nc	@k~($@iᰉ'@hۋq
@glC@f1.@dZ1@cZ@`҈p@_o@^ ѷY@\]ce@Zc	@Y|@Xy=c@W>6z@Vl!-@SMj@P*0U@Ov_ح@N;5X@MjOv@L_@LcA \@LcA \@K:)z@JW'@I@F]cf@Fs@E84֡@B\(@?@<j~#@:)y@8)@9#w@8YJ@6z@4֡a@/r@-U=@+U=@)*0U2a@'-@&IQ@$/@#S&@!-w1@쿱[W@@@*0@n@'/W@
=p
@	7KƧ@1&x@1&x@K]d@Fs@M:@@$t@~$@J#9@>B@@"`@eں@@\@빌~($@JL@ڹ@@4@حV@ޞ@cA @ݗ+j@"`B@b}@ק&@֡af@ҽ<64@;dZ@@ɅoiD@E84@?@8YK@o i@g8}@ěS@ěS@2W@\(@@쿱[@)_@S&@4֡b@'0@[W>6@}Vl@B@jf@^@/V@x@@zxl"h@/@wk@wkQ@-w1@U=@Ov_خ@-V@}H@wkP@Q@,<@@+J@hr @@L_@L_@q@q@L/{@k~(@eO@K]d@@S&@nP@˒:)@.H@~\N<@}ڹZ@{~$@zC\@y=b@z@y"`@x-
@v!.I@v+jg@u!R@u%F
L@tj~@r ě@nt@l[W?@kC]@jg	@irGE@h	ԕ+@dZ1@[6@ZY@Xe+@XbM@W@Vl!-@SMj@Q@Q_p@P`A7@P*0U@OAs@OAs@N+@NT@NT@M:@LcA \@J#9@HK]c@H@G@@D2W@A7Kƨ@A [7@@6@>vȴ9X@<Z@9Y}@8)@7KƧ@3|@.H@-w1@-V@*0
@&'@#
=p@!.H@!ae@U=@-V@=K^@@$tS@sh@L_@R<6@sh@O
M@zG@nO@@
qu"@@I^5?@҈@q@q@
ڹY@
ڹY@
L/{@	k~(@?@u%F
@I^5@ $tS@ ($x@ >B@ eں@ g@ GE85@ s@ u!S@ 4֡a@ 쿱[W?@ g	@ fA@ ,<@ ڹ@ `A7L@ @ Z1@ 	@ @4@ |Q@ ߤ?@ ҈p;@ 5?|@ ?@ 1'@ l!-@ Z@ T`d@ _p@ As@ @ @ ?@ 7Kƨ@ K]@ D@ 4m@ z@ sg@ |@ {@ Vϫ@  ě@ Vϫ@ O
M@ }Vl@ w1@ I^@ @ @ `A@ 	k@ 	@ u@ 1&@ kP|@ *0@ +J@ bM@ O;dZ@ O;dZ@ ڹY@ &I@ ݗ@ Q@ Q@ ?@ JM@ Q@ JM@ o hی@ ~"@ }Vl!@ {lC@ {m]@ {s@ zG{@ zxl"h
@ y(@ y=b@ v!.I@ sPH@ r䎊q@ r䎊q@ r䎊q@ r{m@ ql@ poiDg8@ m8Y@ l[W?@ j~"@ jOv`@ gfA@ bM@ ]cA @ [W>6z@ ["`B@ YJE@ W
=p@ TɅoi@ Sa@O@ R<64@ QN;5@ N+@ N_o @ LcA \@ JL_@ G)^@ E8YK@ Eo i@ DS@ Ca@N@ As@ @n@ >ߤ?@ =<64@ <쿱[@ <j~#@ <64@ <64@ ;5Xy@ ;dZ@ :S&@ 9~($@ 73@ 5?|h@ 49XbN@ 3ߤ@ 2a|Q@ 2a|Q@ 1o@ .1@ ,<쿱@ +jf@ *0
@ 'RT`e@ "h	ԕ@  	k@ u@ 1&@ qu!@ kP|@ u%F@ _o@ @ 0
)@ PH@ O;d@ $tS@ R<6@ sh@ Z@ ݗ+k@ ҉@ hr @ $tT@ )^@ @ $tT@ rGE9@ '/W@ ߤ?@ 
O;dZ@ L_@ '/@ 	k~(@ 	'RTa@ 	7KƧ@ $/@ M:@ n.?E?"`?c	?fA?Gz?҈p;?;dZ?҈p;?]ce?ۋq?"`B?֡af?҈p:?䎊?`A7?˒:)z?@?)^?8YK?a@N?C?rG?-V?1???'RT`?vȴ9?U=?-V?0
)??S&??L_?oiDg?~"?|hr?vȴ9X?p
=q?o hۋ?m\?kP{?jOv`?fA?a@N?_Ft?Zc	?PH?K]cA?IQ?F
L/?A7Kƨ??|hs?=K]?:S&?4֡a?1-?/{J#:?,<쿱?)^?&IQ?%F
L0?"`A? ěT?!-w1?!-w1?}H?qu!?*0??L_?4J?Vu?
=p
?u%F??tj?:S?      ?I^5?:S?:S?.H?s?rGE8?+?Fs?D?{m?c	?쿱[W??ᰉ'?1.?`A7L?䎊qj?S?ᰉ'R?҈p?]ce?Ϫ͞?a@O?m?Z?N;5??o i?&IR?6?H˒:?ߤ??ߤ??
(?
(?vȴ9X?
(?
(?
(?j~#?#w?O
M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @@S@@SZ@@S6@@S~($@@Sq@@Sa@O@@Sݗ+k@@Tn.@@TxF@@TL_@@T%1@@T/{J#@@T/{J#@@T"h	ԕ@@T%1@@T(\@@TFs@@T?@@TtSM@@T@@UK]@@U2a|@@U2a|@@U5Xy>@@U5Xy>@@U84֡@@U2a|@@U%F
L@@U!.H@@U(@@U(@@U/w@@U/w@@U/w@@U84֡@@U84֡@@U5Xy>@@U5Xy>@@U84֡@@U84֡@@U5Xy>@@U5Xy>@@U<64@@U<64@@U84֡@@U<64@@U84֡@@U<64@@U<64@@U<64@@U5Xy>@@UB@@UIQ@@U`A7L@@Usg@@UڹZ@@Uhr!@@U8YK@@VL/{J@@Wy@@XXy=@@X{@@Y	k~@@YrGE@@Y@N@@Y+@@Ye+a@@YD@@YR@@Y.H@@Z#9@@Z0U2a|@@Z6C@@Zd7@@Zp:@@ZY@@Z͞&@@ZsP@@ZD@@[&@@[S&@@[I^@@ZG{@@Z`A@@Z~@@[,zxl@@[g	l@@\"h	ԕ@@\SMj@@\1&@@\E@@]`A7L@@]v@@]@@^($x@@^O;@@_eں@@` ě@@a$/@@a0
)@@aae@@a"`@@bxl"h
@@bxl"h
@@bC,@@c@@dj~#@@f ѷY@@g͞@@j0U2a|@@k҈@@k{J#9@@kwk@@k6@@ln.@@l3@@oiDg8@@s	@@uu@@v@@y_o@@kP@@Y}@@҉@@!-w2@@1.@@3@@k~(@@@@A@@zxl"@@>@@m\@@Fs@@ěT@@L_@@33333@@SMj@@M@@k~(@@u%F@@x@@>B@@C,zx@@Ʌoi@@m\@@(@@8}H@@+j@@KƧ@@R<6@@Ȍ@@&x@@ɂ@@,zxl@@(\@@͞%@@ hۋ@@φ&@@}H@@4J@@a|Q@@Ӣwk@@VϪ@@Լj~@@5Xy>@@֫6z@@)^@@U=@@'RT`@@hۋq@@)^@@&x@@D@@	 @@)y@@M@@~"@@ڰ ě@@C,@@=K^@@W>6z@@tj~@@qu!@@ے:)z@@ۥS@@ݗ+k@@(\@@`d@@܋C@@ܬ1&@@7@@u"@@V@@L_@@݁$/@@ݥv@@ݼn/@@?@@1.@@l!-@@ޞ@@ޤT@@+@@!.I@@\(@@o@@߃{J#:@@@@@@-
q@@˒:*@@u%F@@{@@PH@@N;5@@~($@@l@@B@@|@@N;6@@1'@@JL@@d7@@ᰊ@@I^@@PH@@/V@@33333@@/V@@MjO@@tj~@@㹌~($@@%2@@xF@@64@@Z1@@tSM@@*1@@hr@@'0@@Q@@O;dZ@@\(@@C\@@5?|@@vȴ9X@@qi@@旍O;@@6z@@'@@Q@@滘@@m\@@x@@Xe,@@	@@睲-V@@?@@索3@@rGE9@@ ě@@|@@D@@PH@@A [@@o hی@@l@@N;6@@n@@䎊@@0U2a|@@C\@@Zc@@qiC@@p:@@ᰊ@@C,@@n.3@@Z@@a@@@g@@\N@@xF@@Q@@g8}@@쿱[W?@@/@@/w@@ڹZ@@n/@@n/@@\(@@Ϫ͞@@E@@+jg@@Vu@@z@@,<@@T@@af@@}Vl@@$tS@@U=@@ݗ+@@o @@@@F]d@@oiDg8@@4m@@$tT@@0
)@@@@u@@2W@@n@@e+@@T`d@@L_@@)_@@D@@'/@@/V@@g	l@@@@PH@@_@@#x@@Z@@(@@w1@@
qv@@ ѷY@@u@@H@@T@@]cf@@E84@@{J#:@@/V@@@@H@@bM@@
(@@`A7@@	k~@@ [7@@Dg8~@@@@e@@n@@0U2a|@@T`d@@h	ԕ@@ᰊ@@Y@@䎊q@@C,z@@F]c@@Q@@Ƨ@@%1@@tSM@@?@@1&@@[W?@@D@@%F
L@@O;dZ@@zxl"h@@-V@@ᰉ@@5?|@@H@@c	@@%@@&I@@8}H@@4m@@$tS@@vȴ9@@#@A -
q@A 4m9@A [6@A d8@A F@A 4֡b@A ѷ@A@A@AGz@Ahr @Ab}@A~($@AB@Ao@A-@AOv`@Au%F
@Aݘ@Aᰊ@Ac	@A"`B@A/V@AMjO@Ag	l@Atj~@A~$@Aq@Aa@O@A6@A5Xy@Aa@@AQ@AFs@Ag8}@Aqj@AN;@A_@A쿱[@Azxl"@AZ@Ahr@AE@A*0@A5Xy>@Ace@A8Y@AE@Au@Ap:~@AT@Aȴ9X@A1@A@A!.I@A+I@Ab}V@Aeں@Ay@A	k@AbM@A*0@A>BZc@AK]c@A[6@Au%F@A҈p@A@A	 ѷ@A	&x@A	A [@A	^@A	x@A	oiD@A	R<6@A	.H@A
䎊@A
ݘ@A
䎊q@As@A@N@AP{@A~$@Aq@A:)z@Am]@AJ@AFs@AzG@A?@Azxl"@A[W?@AZ@Ahr@A
'0@A
O;dZ@A
@A

qv@A
(@A
(@A
C\@A@A+jg@ABZc @A_ح@AiB@A}Vl@A6z@A+@A hۋ@A4֡a@AsPH@A$tS@A͞@A@AحV@A#@AbM@A}H@Atj@AѷX@APH@AJE@Au!S@Au@AD@AN;6@A>BZ@A0U2a|@AnO@Ap:@A\(@A ě@A͞&@A'/@AP{@A~$@Aߤ@A6@AQ@AlC@AJ@A!-w2@A9XbN@A<쿱@AFs@AZ1@A`d@Ag8}@Ag8}@A?@A>B[@A!-w@AV@A%F
L@A<64@AL_@AڹZ@An/@A@AS@AE@Aڹ@At@A_o @A4K@A1.@Avȴ9X@A2X@At@A쿱[W@A!.I@A
M;@A!-w1@AAs@A\(@A&@A-V@AzH@A@AVϫ@A     @AbM@A6@A*0@AA7K@AD*@Ahۋq@A˒:*@A
=q@A9Xb@AěT@AF@AD@A	k@A ѷ@A$/@A0
)@ATɅo@Ao hی@A@Ao@A(@Ay@Aᰉ'@AlD@A@A&IR@AQ_@Ah	ԕ@Ah	ԕ@AqiC@A~"@AS&@A@A`A@Ac	@A'/@AnP@A	@AS@An.3@A$@Awk@AU=@AZ@Aa@@Ag@AQ@AM:@A~($x@A*1@A1&@A[W?@A?@A*0@Ao i@A%F
L@AB@AjOv@Azxl"h@Ahr!@Av@A\(@Ab@AE@AC\@A!.@A ѷY@A ѷY@A ѷY@A ѷY@A
(@A!R<@A?@AOv_خ@A_ح@As@A%@A@A,<@Aߤ?@AϪ͟@A1@AFt@A)^@AXe@A$tS@A8}H@AH˒:@AXe,@AlC@Aݗ+@A-V@A3@A@ArG@A F]d@A  ě@A 4m9@A A7K@A NU@A l"h	@A n@A @A -
@A -
@A 
=q@A 9Xb@A p:@A ҈p@A ҈p@A ҈p@A 	k@A!rGE@A!_p@A!&x@A!=b@A!N;5@A!TɅo@A!ae@A!ae@A!hr @A!b}@A!o@A!'RTa@A!N;6@A!lD@A"u%F@A"e+@A"&IR@A":)y@A"h	ԕ@A"qiC@A"{m@A"ᰊ@A">B@A"Y@A"@A"W@A"ڹY@A"G{@A"G{@A"m@A#S&@A#nP@A#	@A#6z@A#F]c@A#Z@A#qu!@A#~$@A#{J#9@A#@A#q@A#Mj@A#A@A#A@A#*0U2@A#Z@A#
=p@A#lC@A#g@A#@A$%1@A$C,zx@A$cA \@A$o h@A$쿱[@A$1&@A$1&@A$@A$7@A$*0@A$/@A$Z@A$JM@A$hr@A%qu"@A%/w@A%<64@A%L_@A%F
L0@A%Y|@A%ce@A%w1@A%!R@A%Xy=@A%Xy=@A%-V@A%@A%,=@A%oiDg@A%!.@A&!R<@A&1.@A&?@A&z@A&2X@A&'@A&@A&t@A&Ϫ͟@A&C-@A&x@A'
=p@A'
M;@A'@A'@A'Xe@A'Xe@A'v@A',@A'+I@A'8}H@A'>6z@A'H˒:@A'Xe,@A'lC@A'y@A'	@A'$tS@A'ݗ+@A'3@A'r@A'@A'o @A'K]d@A'fA@A';dZ@A'@A'䎊r@A(     @A(*0U@A(6@A( ě@A(4m9@A(:~ @A(_F@A(r Ĝ@A(n@A(-
@A(@A(-
@A(4m@A(
(@A(
(@A(ěT@A(ѷX@A(D@A(D@A)_p@A)#w@A)&x@A)*0U2a@A)*0U2a@A):S@A)Gz@A)^@A)k~(@A)|Q@A)~($@A)@A)'RTa@A)|@A)D@A)ԕ*@A)@A)"`@A)@A)"`@A)s@A*n@A*	 @A*@A*&IR@A*3@A*=p
@A*@4n@A*@4n@A*JL@A*h	ԕ@A*\(@A*S&@A*S&@A*G{@A*m@A+I^@A+C,z@A+&@A+9@A+g	l@A+n.3@A+~$@A+~$@A+q@A+A@A+U=@A+q@A+E@A+6@A+|@A+
=p@A+Q@A+҈@A+lC@A+lC@A+A [@A+$@A+A [@A+@A+\N@A,n.@A,J@A,L_@A,%1@A,<쿱@A,Z1@A,j~#@A,cA \@A,m8@A,qj@A,S@A,쿱[@A,zxl"@A,O
M@A,/@A-o i@A-+a@A-?|h@A-O;dZ@A-Vl!@A-`A7L@A-m\@A-w1@A-ݗ@A-ݗ@A-+j@A-@A-v@A-U=@A-1@A-H˒@A-?@A-,=@A-ᰉ@A-(@A-(@A._o @A.
(@A.Ov_@A.$/@A.8YJ@A.L/{J@A.Ov_خ@A.Vu@A._ح@A.l!-@A.s@A.@A.$t@A.-@A.]cf@A.ߤ?@A.C-@A.쿱[W@A.Fs@A."@A.!.I@A/@A/
M;@A/)^@A/@A/,@A/8}H@A/sPH@A/y@A/4m@A/$tS@A/-V@A/?@A/͞@A/͞@A/䎊r@A/#@A0F]d@A0*0U@A0}H@A0*0@A01&x@A073@A04m9@A04m9@A0:~ @A0D*@A0NU@A0_F@A0hۋq@A0r Ĝ@A0|@A0˒:*@A0n@A0n@A0˒:*@A0@A0tj@A0@A0U@A0
(@A0@@A0F@A0ۋq
@A0{@A04֡b@A1 ѷ@A1	k~@A1+@A1_p@A1&x@A14J@A1Gz@A1Dg8~@A1JE@A1^@A1o hی@A1rGE8@A1u!S@A1|Q@A1x@A1x@A1@A1u@A1|@A1D@A1N;6@A1iB@A1ᰉ'@A1.H@A2Ov`@A2#9@A26C@A2@4n@A2JL@A2a|Q@A2a|Q@A2a|Q@A2h	ԕ@A2xl"h
@A2\(@A2S&@A2ᰊ@A2g	@A2}Vm@A2<64@A2͞&@A2䎊q@A2fB@A2D@A2D@A2~@A3҉@A3"`B@A3/V@A39@A3F]c@A3P{@A3a@N@A3a@N@A3g	l@A3g	l@A3qu!@A3q@A3:)z@A3ߤ@A3U=@A3wk@A3@A3@A3Ƨ@A3
=p@A3lC@A3C]@A3$@A4xF@A4tj@A4%1@A4/{J#@A4/{J#@A464@A4?@A4M:@A4Z1@A4`d@A4g8}@A4j~#@A4m8@A4q@A4m8@A4tSM@A4~($x@A4?@A4*1@A41&@A4?@A4j~@A4[W?@A4Z@A4>B[@A4JM@A4!-w@A5'0@A5K]@A5V@A5[@A5%F
L@A5B@A5S&@A5O;dZ@A5Vl!@A5Vl!@A5Y|@A5\@A5fA@A5fA@A5ݗ@A5%@A5@A5v@A5Xy=@A5U=@A5-V@A58Y@A5cA @A58YK@A5b@A5ڹ@A6
L/@A6zG@A6!R<@A6+jg@A6+jg@A61.@A65?|@A65?|@A6BZc @A6L/{J@A6Ov_خ@A6\N<@A6YJ@A6iB@A6p:~@A6vȴ9X@A6}Vl@A6@A6,<@A6@A6@A6af@A6ߤ?@A6ߤ?@A6&I@A6m\@A6t@A6t@A6ߤ?@A61@A6@A6@A6"@A6!.I@A6Fs@A7@A7)^@A7Xe@A7$tS@A7.H@A7H˒:@A7Xe,@A7U=@A7b}V@A7lC@A7sPH@A7y@A7&@A7O;d@A7kP@A7?@A7zH@A73@A7/V@A7˒:)@A7fA@A7fA@A7;dZ@A7-@A7#@A8F]d@A8*0U@A8}H@A873@A8:~ @A8D*@A8>BZc@A8H@A8Q@A8Xy=@A8Xy=@A8Xy=@A8_F@A8oiDg8@A8y=c@A8@A8@A8@A8{@A8
(@A8)^@A8ѷX@A8F@A8D@A8e+@A8`A7@A8$tT@A9@A9@N@A9+@A9@A9*0U2a@A9:S@A9A [@A9A [@A9Gz@A9XbM@A9[W>6@A9XbM@A9e+a@A9o hی@A9b}@A97Kƨ@A9@A97Kƨ@A9~($@A9~($@A9~($@A9@A9'RTa@A9|@A9o@A9@A9"`@A9e@A9>BZ@A9R@A9Y}@A9lD@A:u%F@A:䎊@A:0U2a|@A:-V@A:0U2a|@A:6C@A::)y@A:GE85@A:M@A:a|Q@A:kP|@A:kP|@A:@4@A:~"@A:@4@A:0
@A:S&@A:>B@A:<64@A:W@A:`A@A:ڹY@A:sP@A: ѷ@A: ѷ@A:䎊q@A:䎊q@A:G{@A:C,@A:74@A:m\@A;I^@A;'/@A;PH@A;"`B@A;"`B@A;&@A;,zxl@A;6z@A;33333@A;9@A;S@A;W>6z@A;]cA@A;]cA@A;qu!@A;xF]@A;~$@A;Q@A;Q@A;~$@A;Q@A;q@A;$@A;~($@A;6@A;6@A;6@A;5Xy@A;|@A;a@@A;Q@A;lC@A;@A;s@A<1&y@A<xF@A<ߤ@@A<(\@A<2W@A<2W@A<<쿱@A<?@A<C,zx@A<PH@A<SMj@A<VϪ@A<VϪ@A<PH@A<g8}@A<j~#@A<tSM@A<?@A<#@A<?@A<*1@A<qj@A<N;@A<쿱[@A<1&@A<O
M@A<#x@A<#x@A<#x@A<@A<@A<#x@A<[W?@A<7@A<7@A<Ʌoi@A<Ʌoi@A<?@A<Ʌoi@A<Z@A<Z@A<>B[@A</@A<JM@A<>@A=:@A=V@A=[@A=qu"@A=%F
L@A=%F
L@A=5Xy>@A=84֡@A=B@A=B@A=O;dZ@A=L_@A=O;dZ@A=Vl!@A=Vl!@A=Y|@A=\@A=\@A=`A7L@A=ce@A=$/@A=!R@A==K@A==K@A=%@A=@A=@A=%@A=%@A=U=@A=8Y@A=@A=8YK@A=8YK@A=8YK@A=8YK@A=S@A=(@A=E@A=!.@A=!.@A=oiDg@A=ڹ@A>t@A>_o @A>
(@A>@A>Ov_@A>Ov_@A>Ov_@A>u@A>.2@A>.2@A>BZc @A>L/{J@A>Vu@A>YJ@A>R<6@A>_ح@A>iB@A>z@A>}Vl@A>vȴ9X@A>vȴ9X@A>z@A>IQ@A>+J@A>@A>T@A>T@A>-@A>'@A>@A>ߤ?@A>&I@A>A@A>+@A>+@A>]cf@A>]cf@A>1@A>x@A>@A>Fs@A?@A?Ft@A?
M;@A?Xe@A?v@A?'/W@A?4֡a@A?E84@A?RT`e@A?_o@A?eں@A?o@A?y@A?|hs@A?4m@A?4m@A?	@A?@A?O;d@A?ݗ+@A??@A?zH@A?zH@A?[W>@A?3@A?/V@A?@A?@A?o @A?o @A?fA@A?@A?-@A?rGE9@A@F]d@A@@A@@A@@A@	ԕ+@A@bM@A@$xG@A@4m9@A@:~ @A@:~ @A@NU@A@U2a|@A@[6@A@l"h	@A@l"h	@A@r Ĝ@A@y=c@A@|@A@˒:*@A@˒:*@A@@A@-
@A@@A@-
@A@{@A@{@A@9Xb@A@)@A@F@A@҈p@A@C@A@4֡b@A@{@A@\)@AA	k~@AA@N@AA@AA [7@AA#w@AA&x@AA-w1@AA4J@AA7KƧ@AAA [@AAA [@AAJE@AAN;5@AATɅo@AA[W>6@AA^@AA^@AAe+a@AAhr @AAk~(@AAx@AA@AA7Kƨ@AAo@AAo@AA~($@AAo@AAR<6@AA@AA'RTa@AAn.@AAl@AA'RTa@AAl@AA^5?}@AAD@AAo@AAN;6@AA_o@AAԕ*@AA@AAe@AA>BZ@AA-@AAY}@ABu%F@ABI^5@AB@ABs@ABe+@AB1'@AB)y@AB3@ABGE85@ABM@ABW'@ABW'@ABZc@ABu%F
@ABqiC@ABqiC@ABqiC@AB{m@AB~"@ABp:@ABݘ@ABwkQ@ABS&@ABS&@ABvȴ@AB@AB@AB<64@AB,<@AB,<@AB,<@AB`A@ABc	@AB74@ACI^@ACI^@ACI^@ACI^@AC҉@ACs@ACC,z@ACPH@AC)^	@AC6z@AC9@ACC%@ACMjO@ACS@ACW>6z@ACS@ACS@ACW>6z@ACZ@ACZ@AC]cA@ACjf@ACtj~@AC{J#9@AC{J#9@AC@ACMj@ACߤ@AC*0U2@ACq@ACq@ACm]@AC6@ACƧ@ACƧ@AC5Xy@AC@AC@AC5Xy@AC5Xy@ACQ@ACݗ+k@AC%2@AC҈@AC%2@AC%2@AClC@ACC]@AC$@ADxF@AD!-w2@ADtj@ADtj@AD"h	ԕ@AD%1@AD,<@AD,<@AD%1@AD(\@AD/{J#@AD64@AD<쿱@ADI^5?@ADPH@ADSMj@ADSMj@ADVϪ@ADcA \@AD]ce@AD]ce@AD]ce@ADcA \@ADcA \@ADcA \@ADj~#@ADq@ADq@ADwkP@AD~($x@ADqj@ADqj@ADN;@AD_@AD*1@ADzxl"@AD[W?@ADɅoi@AD*0@ADZ@AD*0@ADZ@AD>B[@ADZ@ADu"@AD@ADD@ADe@ADD@ADD@ADhr@AD!-w@AD>@AE:@AEK]@AEo i@AEK]@AE'0@AEqu"@AE%F
L@AE!.H@AE!.H@AE(@AE/w@AE<64@AE?|h@AE<64@AEL_@AEce@AEce@AEfA@AEm\@AEw1@AEM:@AEڹZ@AEڹZ@AEO
@AEO
@AE%@AE@AE1@AE1@AE1@AEsh@AE@AE@AEH˒@AE8Y@AEϪ͞@AEϪ͞@AEH˒@AEb@AE8YK@AEb@AE8YK@AE8YK@AE@AE8YK@AE
qv@AEoiDg@AE!.@AEoiDg@AF ѷY@AF_o @AFzG@AFu@AF!R<@AF+jg@AF+jg@AF.2@AF5?|@AF8YJ@AF?@AFL/{J@AFOv_خ@AFOv_خ@AFR<6@AFYJ@AFc	@AF_ح@AFYJ@AFfffff@AFl!-@AFp:~@AFp:~@AFp:~@AF}Vl@AF@AFFs@AFO;@AFO;@AFaf@AF6z@AF}Vl@AF&I@AF҈p;@AFC-@AF쿱[W@AFMj@AFx@AFMj@AF"@AGFt@AG@AG hۋ@AG@AG
=p@AG
M;@AGXe@AGXe@AG,@AG$tS@AG1@AG4֡a@AG>6z@AGAs@AGAs@AGO
M@AGRT`e@AG\(@AGsPH@AGv_ح@AGo@AG4m@AG@AGݗ+@AG@AGݗ+@AG@AG@AG@AGݗ+@AG-V@AG?@AG3@AG[W>@AG3@AG[W>@AG[W>@AGr@AGr@AGr@AG@AG+@AG+@AG+@AG@AG@AGfA@AGحV@AG@AGVϫ@AG-@AG+j@AHF]d@AH6@AH}H@AH ě@AH'RT`@AH$xG@AH'RT`@AH73@AH>BZc@AH:~ @AHD*@AHK]c@AHH@AHNU@AHNU@AH_F@AHeO@AHhۋq@AHl"h	@AHr Ĝ@AHu!@AHu!@AH|@AH˒:*@AH|@AHn@AHYJ@AHYJ@AH@AH@AH@AH@AHtj@AH-
@AH@AH@AH@AH
=q@AHU@AH)@AHěT@AH
(@AHTɅ@AH)^@AHD@AHD@AH`A7@AH4֡b@AH\)@AH	k@AH\)@AH{@AH	k@AH	k@AH\)@AHPH@AI ѷ@AI$/@AI$/@AI	k~@AIrGE@AI@AI@N@AI+@AI@N@AI@N@AI+@AI [7@AI [7@AI#w@AI&x@AI-w1@AI-w1@AI0
)@AI*0U2a@AI4J@AIA [@AIDg8~@AIJE@AIN;5@AIXbM@AIk~(@AIu!S@AIx@AIb}@AIoiD@AIoiD@AI~($@AI~($@AIoiD@AI'RTa@AIu@AI'RTa@AIu@AIl@AI(@AIl@AIl@AIB@AI|@AIo@AIN;6@AIԕ*@AIe@AI>BZ@AIR@AI@AIs@AIlD@AIlD@AIlD@AJu%F@AJn@AJ@AJ1'@AJ䎊@AJ-V@AJ6C@AJ0U2a|@AJ3@AJ:)y@AJ=p
@AJ@4n@AJM@AJT`d@AJ^5?|@AJh	ԕ@AJnO@AJkP|@AJqiC@AJxl"h
@AJxl"h
@AJ~"@AJp:@AJS&@AJᰊ@AJ0
@AJwkQ@AJvȴ@AJvȴ@AJS&@AJ@AJ ě@AJ ě@AJ}Vm@AJ}Vm@AJY@AJn@AJ<64@AJ͞&@AJ͞&@AJsP@AJڹY@AJڹY@AJG{@AJG{@AJG{@AJG{@AJC,@AJC,@AJc	@AJD@AJ~@AJ74@AJm@AJ~@AJ~@AKI^@AKS&@AK҉@AK'/@AKnP@AKnP@AK'/@AKnP@AKs@AK	@AK)^	@AK/V@AK/V@AK/V@AK33333@AK6z@AK@N@AKJ#9@AKMjO@AKP{@AKS@AKW>6z@AKW>6z@AKW>6z@AKS@AKW>6z@AKW>6z@AKW>6z@AKS@AKZ@AKdZ@AKn.3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @sH     @sH     @s@     @s@     @sH     @sH     @sH     @sFfffff@sH     @sK33333@sL@sI@sD@sA@sH     @sH     @sK33333@sNfffff@sK33333@sNfffff@sS33333@sX     @sY@s^fffff@s`     @s^fffff@s^fffff@sY@sY@sX     @s[33333@s[33333@s[33333@sY@sVfffff@sY@s^fffff@s^fffff@sY@sVfffff@sT@sY@sY@sY@sX     @sX     @sY@sY@sX     @sT@sL@sH     @sFfffff@s>fffff@s9@s333333@s      @s.fffff@sVfffff@sy@s33333@s@s33333@s33333@s     @sfffff@s     @s@s33333@s33333@s@sfffff@s     @s33333@s@s~fffff@s     @s     @s33333@s@s@s@s33333@s33333@s@s33333@svfffff@sT@sa@s`     @sVfffff@sK33333@sH     @s>fffff@s@s@s33333@s@s33333@sfffff@s     @s	@rfffff@r@r     @r     @r33333@r33333@r|@r@r     @r@r     @r~fffff@rX     @rfffff@qfffff@q     @qFfffff@q33333@pᙙ@p     @pfffff@py@pC33333@p@p	@o@o陙@offfff@o@o|@o33333@n33333@n@nC33333@mfffff@ll@k      @j33333@is33333@i333333@ifffff@ifffff@hfffff@hfffff@h     @h6fffff@g@g6fffff@gfffff@f33333@f@fc33333@f)@e     @e     @e@e9@dfffff@d@dvfffff@dP     @d#33333@c@c@c33333@cfffff@cP     @bٙ@b@b33333@bvfffff@bffffff@bY@bI@b&fffff@a陙@a     @a@a     @a33333@a@a@a`     @a@     @a)@afffff@afffff@`fffff@`陙@`     @`@`@`     @`l@`\@`6fffff@`     @`      @_@_fffff@_33333@_Y@_      @^ٙ@^@^fffff@^`     @^333333@^@]ٙ@]     @]ffffff@]333333@]33333@]fffff@]fffff@\@\fffff@\Y@\&fffff@\@\33333@\&fffff@\333333@\33333@[fffff@[`     @[@     @[@Z@Zfffff@Z33333@Zl@ZL@Z333333@Z@Y@Yfffff@Yfffff@Y@     @Y@X33333@X@Y      @Y      @X     @X     @X@Xfffff@X33333@Xs33333@XY@XL@XFfffff@X@     @X@     @Xfffff@W     @WL@W33333@V@Vٙ@V@V33333@V     @V33333@Vy@VS33333@V9@V&fffff@V      @V      @V      @U@U33333@Us33333@UY@UFfffff@U9@U&fffff@U      @T     @T33333@T@T     @Ty@T`     @T`     @TS33333@TS33333@T9@T      @S@S@S     @Sfffff@S     @S     @S@Sy@SL@S,@S@R@Rٙ@Rfffff@R33333@R@Ry@R`     @R9@R33333@R33333@R@R@Rfffff@Qٙ@Q     @Qfffff@Qffffff@QFfffff@Q333333@Q&fffff@Q@Q@Qfffff@Pfffff@Pfffff@P@P@Ps33333@Pffffff@PFfffff@P&fffff@P&fffff@P,@P&fffff@P33333@O@O@O@Os33333@OL@O&fffff@O&fffff@O&fffff@O333333@O      @N@Nfffff@N@N     @Nffffff@NL@N@     @N&fffff@N@Mfffff@MY@M@L33333@M      @L33333@M      @M@M@L33333@Ls33333@Lffffff@LY@LL@L@     @L@     @L&fffff@L@K33333@Kfffff@K     @Ks33333@KL@J33333@J@Jfffff@J@J     @Js33333@JL@J333333@J@J      @Ifffff@I@I     @Ifffff@Iffffff@IY@IY@IL@I@Hٙ@H33333@H@H@H@Hs33333@Hs33333@Hs33333@H     @Hs33333@H&fffff@H&fffff@H@H      @G33333@H      @H      @Gfffff@Gfffff@Gٙ@G@Gs33333@GL@G&fffff@G@F33333@F33333@F@Fs33333@Fffffff@FY@F@     @F333333@F@E33333@E33333@Eٙ@E33333@E@E@Es33333@Effffff@Effffff@EL@E@E@E@D33333@Dٙ@D@D     @D33333@D33333@D@D     @Ds33333@Dffffff@D@     @D&fffff@D&fffff@D@D@D&fffff@D@D      @Cfffff@C@C33333@C33333@Cfffff@Cfffff@C@C@C@Cs33333@Cffffff@Cs33333@Cffffff@CY@Cs33333@CY@CL@CL@CL@CL@CL@C@     @C333333@C@C@C@C      @C      @B33333@B33333@B33333@Bfffff@Bfffff@Bٙ@B     @B33333@B@B@B     @B@B     @Bs33333@BY@B@     @B333333@B333333@B333333@B333333@B&fffff@B@A@A@A     @A@A@A33333@A33333@A@A@A@A     @A@A@As33333@Affffff@Affffff@AL@A@     @A@     @A&fffff@A&fffff@A@@33333@A      @@33333@@33333@@fffff@@33333@@ٙ@@ٙ@@@@     @@fffff@@@@@@@@     @@s33333@@     @@     @@s33333@@ffffff@@@     @@@@@@@@@@      @@      @?fffff@@      @@      @?@?@?@?ffffff@?333333@?333333@?L@?ffffff@?     @?     @?@>fffff@>@>@>@>33333@>     @>ffffff@>333333@>ffffff@>333333@>333333@>333333@>@>333333@>      @=fffff@=fffff@=33333@=@=33333@=@=33333@=@=@=333333@=L@=     @=L@=L@=333333@=ffffff@<fffff@<@<fffff@<@<@<33333@<33333@<     @<ffffff@<     @<ffffff@<L@<L@<333333@<333333@<@<@<333333@<@<333333@<333333@<@<@<333333@;fffff@;fffff@;fffff@;fffff@;fffff@;fffff@;fffff@;fffff@;33333@;33333@;@;@;@;@;     @;@;ffffff@;L@;L@;333333@;333333@;333333@;333333@;@;@;      @;@;      @:fffff@:fffff@:fffff@:fffff@:fffff@:@:33333@:33333@:@:@:@:33333@:@:@:@:     @:     @:@:     @:     @:ffffff@:ffffff@:ffffff@:@:L@:L@:333333@:333333@:333333@:      @:      @9fffff@9fffff@9fffff@9@9@9fffff@9@9@9@9@9@9@933333@933333@933333@933333@9@9@9@9@9@9@9@9     @9@9ffffff@9     @9     @9     @9ffffff@9     @9ffffff@9333333@9333333@9333333@9333333@9L@9333333@9333333@9@9@9@9@9@9      @9      @8fffff@8fffff@9      @9      @9      @9      @8@833333@8@833333@8fffff@833333@833333@833333@833333@8@8@8     @8L@8L@8333333@8L@8ffffff@8333333@8L@8L@8ffffff@8L@8L@8333333@8      @8333333@8L@8333333@8@8@8@8@8@7fffff@7fffff@7fffff@7fffff@8@8      @7fffff@7@733333@733333@733333@733333@7@733333@7@733333@7@7@7@7ffffff@7     @7L@7L@7L@7ffffff@7333333@7@7333333@7@7@7333333@7333333@7@7333333@7333333@6fffff@6fffff@6fffff@6fffff@6fffff@6fffff@6@633333@6@633333@633333@6@6     @6@6@6@6@6     @6     @6     @6     @6ffffff@6L@6L@6L@6ffffff@6L@6L@6L@6L@6333333@6333333@6@6      @6L@6333333@6      @5fffff@5@5fffff@6      @5fffff@5fffff@5fffff@5@5fffff@533333@533333@533333@5@5@533333@533333@533333@533333@5@533333@5@5@5@5@5@5     @5@5@5     @5     @5@5     @5ffffff@5ffffff@5     @5ffffff@5ffffff@5333333@5333333@5333333@5333333@5333333@5@5333333@5333333@5333333@5333333@5      @5      @5      @4fffff@4fffff@4@433333@4@433333@4fffff@433333@4@4     @4@4@4@4     @4ffffff@4ffffff@4L@4ffffff@4ffffff@4L@4@4      @3fffff@3fffff@3fffff@3fffff@333333@333333@333333@333333@3     @3@3@333333@3@3L@3ffffff@3333333@3      @3      @3      @3@3@3@3      @233333@2@2@233333@233333@233333@2@2@2@2@2@2@2@2@233333@233333@2@2@2@2@2fffff@233333@2@2@2@2fffff@2fffff@233333@2@3@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@2fffff@3      @3      @3333333@3333333@3333333@3@3L@3@3@3      @3333333@3      @2fffff@2@2@233333@233333@2@3@3@3333333@3333333@3ffffff@3     @3     @3     @3@4      @3@3@3@333333@3@333333@3@333333@3@3fffff@3fffff@4      @3fffff@4      @4      @4333333@4333333@4      @4@4333333@4333333@4L@4333333@4333333@4333333@4333333@4333333@4      @4      @4      @4      @4L@4333333@4333333@4333333@4@4333333@4ffffff@4     @4ffffff@4     @4ffffff@4333333@4ffffff@4L@4L@4L@4ffffff@4333333@4L@4ffffff@4ffffff@4L@4333333@4@4333333@4333333@4333333@4333333@4333333@4333333@4@4333333@4      @4      @4@3fffff@4@4@4@4@4      @3fffff@3fffff@3@3@3fffff@333333@3fffff@3fffff@3@3@333333@333333@333333@3     @3@3@3@3@3@3@3ffffff@3     @3ffffff@3@3     @3     @3@3ffffff@3@3     @3ffffff@3ffffff@3L@3ffffff@3L@3333333@3L@3ffffff@3ffffff@3L@3L@3L@3L@3L@3333333@3333333@3ffffff@3ffffff@3333333@3333333@3L@3L@3ffffff@3333333@3ffffff@3ffffff@3ffffff@3ffffff@3ffffff@3     @3     @3@3@3@3     @3     @3     @3@333333@3     @3@3@3     @3L@3     @3     @3     @3@3ffffff@3     @3     @3@3     @3     @3     @3     @3ffffff@3     @3     @3ffffff@3L@3ffffff@3L@3ffffff@3L@3L@3     @3ffffff@3333333@3L@3333333@3L@3333333@3333333@3333333@3333333@3L@3ffffff@3ffffff@3L@3333333@3333333@3@3333333@3333333@3333333@3333333@3333333@3333333@3333333@3333333@3L@3333333@3L@3L@3333333@3@3L@3333333@3333333@3333333@3@3@2fffff@3@3@2fffff@2fffff@3      @3      @2fffff@2fffff@233333@2@233333@233333@2@233333@2@2@233333@2@2@2@2@233333@2@2@233333@2     @2@233333@2@2@2fffff@233333@2@233333@233333@2@233333@2@233333@233333@2@233333@233333@233333@2@2@2@233333@2fffff@2fffff@2@2fffff@2fffff@2fffff@3      @3      @3      @2fffff@2fffff@3      @2fffff@2fffff@3@3      @3      @3@2fffff@3      @3@3@3@3333333@3333333@3@3      @3@3333333@3L@3L@3L@3333333@3333333@3L@3L@3333333@3L@3333333@3     @3ffffff@3L@3333333@3ffffff@3ffffff@3ffffff@3     @3L@3ffffff@3ffffff@3ffffff@3ffffff@3ffffff@3L@3@3@3ffffff@3@3ffffff@3ffffff@3@3@333333@3@333333@3@3@3     @3     @3@3fffff@4      @333333@333333@3fffff@3fffff@4      @3fffff@333333@4@4@4333333@4@4333333@4@4333333@4@4@4333333@4333333@4333333@4L@4ffffff@4333333@4333333@4ffffff@4@4     @4ffffff@4ffffff@4     @4@4     @4@4@4@433333@4@4ffffff@4     @4@433333@4@5      @4@433333@433333@5@5@5@5@4fffff@5@5L@5333333@5ffffff@5333333@5333333@5333333@5333333@5L@5L@5L@5@5     @5     @5     @5ffffff@5     @5fffff@5@533333@5fffff@5@5fffff@6      @5fffff@6@6      @6333333@6ffffff@6ffffff@6ffffff@6     @6     @6     @6     @633333@6@633333@633333@6@633333@6fffff@7      @6fffff@7      @7      @7      @7      @6fffff@7      @7@7333333@7L@7ffffff@7     @7     @7ffffff@7ffffff@7     @7@733333@7fffff@8      @7fffff@8@8      @8@8L@8333333@8333333@8     @8     @8ffffff@8L@8ffffff@833333@8@8@8@8fffff@8@8@8fffff@9L@9L@9ffffff@9ffffff@9ffffff@9     @9     @933333@9@933333@9@933333@:      @9fffff@9fffff@:      @:333333@:@:@:333333@:ffffff@:L@:333333@:L@:     @:ffffff@:     @:@:@:@:@:     @:33333@:33333@:@;      @:@:@:@;@;333333@;333333@;@;@;@;     @;     @;L@;ffffff@;@;33333@;33333@;@;fffff@;@;@;fffff@<333333@<333333@<ffffff@<     @<L@<@<333333@<@<33333@<33333@=      @<fffff@<@<fffff@=      @=333333@=@=      @=333333@=     @=     @=     @=33333@=     @=     @=     @>      @=fffff@>333333@>@>      @>L@>L@>L@>     @>     @>     @>@>fffff@>33333@>fffff@?      @>33333@?      @?      @>fffff@?      @?@?333333@?333333@?L@?ffffff@?33333@?     @?@?@?@?@?33333@?@@@@      @?fffff@@      @@@@@@&fffff@@@@&fffff@@@     @@333333@@&fffff@@@     @@@     @@@     @@Y@@ffffff@@ffffff@@ffffff@@Y@@s33333@@@@s33333@@s33333@@@@     @@@@@@@@fffff@@     @@33333@@     @@     @@     @@33333@@     @@@@fffff@@ٙ@@ٙ@@fffff@@33333@@33333@A      @A      @A@A@A&fffff@A333333@A@A&fffff@A@     @AY@A     @A     @A     @As33333@A@A@A     @A@A@A@Afffff@A@A@A@A     @A     @Afffff@A33333@A33333@A@A@Afffff@A@Afffff@Afffff@A33333@B      @B@B@B@B333333@B@     @B@     @B&fffff@B&fffff@B@     @Bs33333@Bs33333@B     @B     @B@B@Bfffff@B33333@B@B@Bfffff@B33333@B@B@B33333@B33333@B     @B@Bٙ@Bٙ@Bٙ@Bٙ@Bfffff@Bfffff@B33333@C      @C@C@C&fffff@C&fffff@CL@C333333@C333333@CY@CY@Cs33333@C     @C@C@Cfffff@C@C@C@C33333@C33333@C33333@C33333@C33333@C     @C33333@C@Cٙ@Cfffff@D      @D@D      @D@D&fffff@D@D@D@D     @Ds33333@D@Dffffff@Ds33333@D     @D33333@D33333@D33333@D@D@D     @D@Dٙ@Dٙ@Dٙ@Dٙ@E      @E      @E@E@E&fffff@E333333@EY@EY@EY@E@     @E333333@EL@E@E@E@E33333@E33333@E@E@E@Efffff@Efffff@E@Eٙ@E     @E     @Eٙ@Eٙ@Efffff@F      @E33333@E33333@F@F@F@F      @F@F&fffff@F@F333333@FL@Fffffff@F     @FY@FY@FY@FY@Fs33333@F@F33333@F33333@F     @F33333@F@F     @Fٙ@Fٙ@F     @G      @G@G      @F33333@G&fffff@G333333@G&fffff@G@G@G&fffff@G333333@G333333@G@     @G@     @G@     @G333333@GL@GY@GY@Gffffff@G     @Gs33333@GY@G     @G@G33333@G33333@G33333@Gٙ@G     @G@G33333@Gfffff@G33333@H      @H@H      @H@H      @H      @H@H@H@H@H333333@H333333@H333333@H@     @H@     @HL@H&fffff@HY@HL@H@     @HY@Hs33333@HY@HY@Hffffff@H     @H@Hfffff@Hfffff@H33333@H@Hٙ@H33333@Hfffff@H33333@I@I      @I@I      @Hfffff@H33333@I&fffff@I&fffff@I&fffff@I@     @IL@IL@IL@IY@Is33333@I@Ifffff@Ifffff@Ifffff@Ifffff@I     @I@Iٙ@Iٙ@Ifffff@I33333@I33333@I33333@J      @J&fffff@J@     @JL@J@     @JL@JY@JY@Jffffff@Js33333@J     @J@Jfffff@J@J@J33333@Jٙ@Jٙ@J33333@K      @K@K@K@K@K&fffff@K333333@K&fffff@KL@K@     @KL@KL@KY@Kffffff@Kffffff@Kffffff@KY@Kffffff@Kfffff@Kfffff@K@K@K@Kfffff@Kfffff@Kfffff@Kfffff@K     @K33333@K@K33333@K     @K     @K33333@Kٙ@K33333@Kٙ@K33333@L      @L      @L@L@L@L@L@L&fffff@L333333@LY@LL@L@     @LL@LL@L333333@L     @L@L@L@L     @L     @L@L     @L     @L@L@L     @L33333@L33333@Lfffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ?bM?ěS?o?+?9XbM?;dZ?A7Kƨ?`A7L?$/?9XbN?Z1'?1&x?(\)?tj~?
=p?/v?홙?
=p?-V?7KƧ?\(?hr ?웥S?\(?7KƧ?ffffff?n?
=p
?n?
=p
?7KƧ?\(?I^5??^5?|?vȴ9X?vȴ9X?zG{?KƧ?nO?lC? ěT?;dZ?ȴ9Xb?ffffff?$/?O;dZ?E?9XbM?tj?O;d?Z1'?lC?hr ?"`B?E?zG?+I?9XbN?zG?E?m?Q?E?`A7L?E?vȴ9X?l?333333?lC?n?^5?|?;dZ?zG?\(?1&?hr ?o?`A7K?n?5?|h?GzH?
=p?E?5?|h?-?+I^?333333?ffffff?I^5??ߝ-V?+I^?-V?I^5?}?r ě?O;dZ?n?S?+J?r ě?+I^?r ě?1&?lC?m?ղ-V?"`?ԛS?|hr?zG{?r ě?\(?E?ϝ-V?ΗO;d?GzH?"`?"`?7KƧ?Gz?xF?˥S?ȓtj~?ffffff?x?ǮzG?\(?S?$/??|hs?Ł$/?$/?/w?E?vȴ9X?\(?\(?ļj~#?nO;?° ě?7KƧ?I^5??Q?zG{?zG{?7KƧ?S?`A7?l?I^5??;dZ?333333?E?-V? ěT?`A7?bM?
=p?vȴ9X?$/?bM?M?lD?333333?333333?-V?
=p?
=p?Q?vȴ9X? ěT?vȴ9X?|hr?"`?dZ1?Q?nO?n?ěS?bM?A7Kƨ?333333?Q?-V?&x?nO?333333?M?Q?ěS?vȴ9X?`A7L?nP?GzH?`A7L?l?-V?GzH?$/?-V?lD?
=p?-V?&x?nO?7KƧ?&x?`A7?nO?&x?`A7?7KƧ?E?nP?hr Ĝ?Q?&x?
=p?Q?lD?$/?Q?bM?Q?l?`A7L?I^5??lD?nO;?-V?ěS?\(?M?E?zG{?      ?;dZ?Õ$/?+?lD?nO;?nO?n?-V?öE?nO;?&x?hr Ĝ?nP?\(?I^5??7KƧ?p
=q?nO;?7KƧ?&x?A7Kƨ?Q? ěT?° ě?I^5??lD?333333?° ě?A7Kƨ?hr Ĝ?nO?333333?7KƧ?7KƧ?M?\(?
=p?Q?$/?`A7L?+?Q?° ě?nO?ěS?nO;?$/?A7Kƨ?`A7L?`A7L?tj~?\(?9XbM?M?M??|hs?lD?A7Kƨ?nO?Q?Q?Q?ěS?M?zG{?° ě?n?n?\(?hr Ĝ?GzH?n?nP?nO;?tj?M?
=p?lD?\(?öE?Q?Q?-V?\(?öE?-V?Z1'?+?hr Ĝ?333333?&x?° ě?&x?nO?
=p?`A7?ļj~#?\(?lD?öE?Õ$/?-V?E?nO?nO;?`A7?&x?I^5??7KƧ?GzH?l?l?&x?° ě?GzH?zG{?GzH?° ě?tj?nO?`A7L?lD?° ě?`A7?nO?nO;?S?`A7L?vȴ9X?&x?nO;?+?n?nO?/v?GzH?&x?nO;?$/?° ě?&x?`A7?l?7KƧ?l?`A7?\(?7KƧ?tj?I^5??
=p?ěS?nP?M?° ě?Q?S?`A7L?S?hr Ĝ?M?/w?nO;?ěS?&x?° ě?nO;?S?I^5??M?+?nO;?GzH?hr Ĝ?nO?l?nO?7KƧ?l?nO? ěT?tj~?333333?I^5??7KƧ?I^5??l?
=p?lD?M?333333?tj?nO?      ?hr Ĝ?-V?`A7?A7Kƨ?Q?nO;?bM?öE?-V?333333?l?`A7?S?333333?`A7?S?l?vȴ9X?nO?lD?-V?hr Ĝ?+?333333?l?I^5??I^5??-V?Z1'?\(?Q?n?-V?lD?öE?+?\(?GzH?M?lD?333333?S?nO;?M?hr Ĝ?Õ$/?
=p?$/?\(?vȴ9X?M?nO?nO?
=p?l?° ě?\(?tj~?nO?lD?-V?nO;?$/?l?S?`A7?$/?Õ$/?
=p?l?E?7KƧ?Õ$/?ěS?M?öE?
=p?`A7?I^5??\(?nO?333333?tj~?ěS?nO;?
=p?&x?° ě?`A7?hr Ĝ?\(?tj?-V?hr Ĝ?7KƧ?333333?I^5??Q?7KƧ?Q?l?tj~?hr Ĝ?nO;?M?M?
=p?l?vȴ9X?I^5??333333?+?M?333333?I^5??I^5??7KƧ?
=p?nO;?nO?Q?l?&x?\(?-V?`A7?n?n?n?bM?9XbM?n?
=p?l?-V?l?-V?öE?I^5??333333?+?7KƧ?öE?tj~?tj~?hr Ĝ?lD?S?nO?KƧ?Õ$/?`A7?
=p?tj~?zG{?l?Õ$/?`A7?GzH?M?
=p?
=p?öE?`A7?ffffff?tj~?333333?tj~?nO?nO?ěS?7KƧ?M?-V?nO?-V?öE?öE?9XbM?ļj~#?+?`A7?`A7?nO?M?Õ$/?nO;?nO;?\(?nO?Ł$/?öE??|hs?\(?n?M?M?333333?`A7?&x?M??|hs?M?
=p?tj?-V?l?nO?`A7?
=p?öE?333333?A7Kƨ?öE?l? ěT?7KƧ?lD?\(?\(?S?lD?öE?GzH?öE?l?`A7L?hr Ĝ?hr Ĝ?$/?° ě?M?333333?S?`A7?\(?tj?ěS?Õ$/?° ě?tj~?+?öE?n?+?
=p?° ě?l?
=p?M?+?n?Q?lD?+?S?-V?\(?
=p?nO?Z1'?9XbM?M?S?`A7?`A7?333333?S?nO?333333?nO?/w?° ě?+?GzH?ěS?nP?S?tj~?nO?
=p?
=p?ěS?nO?S?333333?hr Ĝ?I^5??l?GzH?-V?Z1'?I^5??-V?Õ$/?-V?-V?l?° ě?E?° ě?hr Ĝ?`A7?tj?-V?° ě?$/?333333?n?`A7L?° ě?l?+?/w?Z1'?
=p?nO?I^5??tj?I^5??° ě?nO;?M?nO;?lD?`A7?
=p?&x?+?
=p?ļj~#?`A7K?
=p?`A7?° ě?-V?S?333333?nO;?GzH?lD?Q?GzH?° ě?ěS?Q?tj~?-V?M?nO;?nO;?ļj~#?\(?E?`A7?S?ļj~#?S?tj~?`A7L?\(?Q?lD?\(?nO;?S?-V?Õ$/?M?hr Ĝ?n?
=p?333333?nO;?`A7?tj?333333?tj?-V?ěS?$/?7KƧ?ěS?l?333333?tj~?E?-V?`A7?-V?zG{?M?nO;?
=p?zG{?° ě?333333?lD?lD?Ł$/?9XbM?Ł$/?`A7?\(?lD?M?9XbM?ěS?Õ$/?
=p?nO?° ě?\(?S?333333?7KƧ?A7Kƨ?-V?333333?+?nO;?9XbM?I^5??7KƧ?9XbM?ļj~#?S?^5?|?nO?S?l?ļj~#?+?
=p?n?n?`A7?nO;?öE?tj?&x?\(?/w?tj~?`A7?ļj~#?öE?ěS?öE?ěS?GzH?Z1'?tj~?l?nO?nO;?° ě?-V?öE?Q?`A7?GzH?`A7L?tj?`A7?nO?zG{?9XbM?9XbM?öE?`A7L?GzH?öE?$/?n?9XbM?l?tj?+?nO;?7KƧ?nO;?hr Ĝ?/w?I^5??öE?nO;?zG{?Õ$/?333333?M? ěT?nO;?ěS?Z1'?M?`A7?Õ$/?\(?&x?E?nP?ěS?M?-V?7KƧ?nO;?tj~?öE?Z1'?&x?S?nO;?|hr?Õ$/?`A7?333333?° ě?Õ$/?\(?l?nO;?/w?&x?n?+?`A7?° ě?M?Z1'?M?nO;?Õ$/?l?Q?`A7?-V?333333?ěS?7KƧ?`A7L?nO?9XbM?333333?`A7?-V?GzH?hr Ĝ?hr Ĝ?Õ$/?ěS?nO;?
=p?šo?\(?hr Ĝ?l?nO?öE?M?n?zG{?nO?$/?lD?hr Ĝ?tj?A7Kƨ?GzH?
=p?`A7?° ě?Õ$/?Q?&x?tj~?7KƧ?M?`A7?333333?`A7?öE?nO;?-V?Õ$/?° ě?tj?I^5?? ěT?GzH?nO?šo?hr Ĝ?\(?lD?-V?nO;?$/?+?`A7L?° ě?vȴ9X?`A7?7KƧ?E?`A7L?333333?öE?-V?-V?-V?n?      ?&x?nO?333333?° ě?tj~?S?333333?öE?lD?Q?n?n?Q?tj?-V?tj~?M?n?tj?° ě?GzH?`A7L?9XbM?n?tj~?&x?-V?`A7?tj~?° ě?
=p?+?bM?333333?&x?$/?j~"?ěS?Õ$/?nO?-V?tj~?-V?ļj~#?bM?tj~?9XbM?GzH?nO;?
=p?lD?$/?ěS?Z1'?\(?Q?öE?bM?lD?Q?zG{?      ?Q?7KƧ?\(?I^5??I^5??GzH?`A7?° ě?Õ$/?l?-V?hr Ĝ?tj?zG{?ļj~#?-V?S?`A7?Q?\(?hr Ĝ?-V?l?
=p?9XbM?tj?tj?&x?I^5??-V?° ě?-V?+?333333?hr Ĝ?n?S?`A7L?Q?$/?S?l?`A7?-V?nP?`A7?&x?+?
=p?\(?hr Ĝ?\(?Õ$/?-V?M?tj~?`A7?
=p?n?nO;?Ł$/?Õ$/?9XbM?l?lD?lD?Z1'?ļj~#?S?zG{?p
=q?GzH?l?M?tj~?333333?7KƧ?nO?nO;?nO;?`A7?`A7?ļj~#?Q?Q?° ě?l?S?/w?tj~?M?lD?Q?n?Q?tj~?° ě?ěS?Q?Q?
=p?Q?+?$/?l?nO?l?° ě?/w?ěS?nO;?tj~?GzH?ěS?hr Ĝ?`A7?Q?öE?zG{?\(?+?Õ$/?° ě?/w?-V?GzH?lD?nO?ěS?öE?Õ$/?333333?nO?öE?öE?° ě?ěS?333333?333333?/w?Õ$/?M?zG{?Q?-V?ěS?° ě?zG{?öE?nO?`A7?nO?S?M?+?tj~?nO;?° ě?nO?lD?Q??|hs?+?hr Ĝ?A7Kƨ?° ě?Q?+?nO?nO;?lD?9XbM?lD?7KƧ?lD?S?Z1'?333333?tj~?Õ$/?`A7L?M?$/?lD?hr Ĝ?$/?Z1'?333333?öE?9XbM?ļj~#?Õ$/?
=p?ěS?7KƧ?Õ$/?Õ$/?-V?l?A7Kƨ?Q?l?tj?ěS?-V?`A7L?hr Ĝ?nO?$/?-V?lD?333333?nO;?333333?ěS?
=p?+?`A7?9XbM?Q?333333?+?S?-V?° ě?333333?ļj~#?nO?/w?nO?öE?7KƧ?E?9XbM?° ě?+?\(?ěS?lD?Z1'?`A7L? ěT?S?-V?
=p?° ě?+?`A7L?nO;?S?-V?/w?+?7KƧ?7KƧ?vȴ9X?nO?-V?nO?n?Q?7KƧ? ěT?      ?GzH?nO;?&x?° ě?° ě?A7Kƨ?$/?GzH?\(?
=p?|hr?I^5??+?zG{?`A7?Q?nO?öE?+?S?Õ$/?;dZ?
=p?`A7?
=p?nO;?&x?lD?ěS?\(?nO;?`A7?Q?I^5??n?9XbM?Q?+?l?lD?l?I^5??7KƧ?`A7L?nO;?° ě?M?n?      ?n?M?`A7?-V?+?n?\(?M?&x?° ě?Q?7KƧ?nO?l?-V?lD?-V?l?333333?nO;?Õ$/?hr Ĝ?
=p?-V?vȴ9X?1&y?\(?tj?nO?öE?nO;?tj?Õ$/?ěS?`A7?° ě?M?S?nP?&x?tj~?lD?-V?tj?nO;?ěS?&x?A7Kƨ?hr Ĝ?7KƧ?`A7?-V?`A7?nO?-V?`A7L?\(?zG{?lD?hr Ĝ?S?9XbM?n?Q?n?hr Ĝ?l?Õ$/?nO;?Q?
=p?&x?&x?333333?GzH?9XbM?
=p?n?nO;?lD?&x?A7Kƨ? ěT?333333?l?+?lD?lD?nP?I^5??$/?I^5??\(?° ě?7KƧ?tj~?lD?\(?nO;?`A7?S?ļj~#?öE?I^5??lD?|hr?&x?lD??|hs?
=p?`A7L?M?9XbM?`A7L?`A7L?A7Kƨ?
=p?;dZ?nO;?l?-V?-V?öE?      ?-V?vȴ9X?nO?\(?\(?lD?"`?
=p?-V?+?tj~?Q?nO;?nO;?nO?nO?l?ěS?+?M?n?Õ$/?S?Q?$/?nO;?$/?nO? ěT?lD?`A7?-V?Õ$/?&x?ěS?S?I^5??tj~?&x?I^5??M?M?GzH?Õ$/?° ě?333333?tj?M?M?-V?S?Q?+?\(?nO?Õ$/?l?lD?-V?Õ$/?öE?nO;?M?333333?lD?&x?öE?`A7L? ěT?° ě?Q?Õ$/?nO;?n?I^5??nO;?° ě?$/?l?tj~?
=p?`A7L?Õ$/?I^5??tj~?-V?
=p?I^5??l?n?l?-V?Q?\(?I^5??lD?\(?ļj~#?
=p?S?lD?M?+?\(?&x?hr Ĝ?&x?&x?n?I^5??bM?7KƧ?\(?Q?ěS?ěS?tj~?+?`A7?n?hr Ĝ?&x?Z1'?n?hr Ĝ?tj?-V?333333?$/?l?n?ěS?I^5??I^5??-V?lD?9XbM?`A7L?`A7L?lD?
=p?"`?`A7L?M?7KƧ?tj?-V?vȴ9X?n?nP?lD?A7Kƨ?° ě?nO;? ěT?nO;?-V?n?lD?333333?S?tj~?ěS?\(?ļj~#?lD?Q?° ě?° ě?ěS?lD?I^5??$/?\(?`A7L?Q?° ě?7KƧ?-V?GzH?hr Ĝ?      ?A7Kƨ?nO?n?
=p?tj~?ļj~#?&x?\(?;dZ?nO;?;dZ?l?nO;?hr Ĝ?M?M?° ě?M?lD?+?M?$/?
=p?$/?GzH?
=p?nO;?° ě?      ?"`?lD?+?ěS?nO;?ļj~#?      ?\(?° ě?l?lD?&x?I^5??hr Ĝ?Õ$/?5?|h?`A7L?ěS?ěS?nO?ěS?7KƧ?I^5??GzH?+?nP?&x?lD?l?&x?I^5??&x?\(?n?tj?Õ$/?$/?I^5??-V?Q?Q?&x?\(?|hr?lD?333333?A7Kƨ?n?I^5??S?-V?\(?nO?-V?lD?
=p?"`?hr Ĝ?n?lD?lD?7KƧ?$/?
=p?° ě?I^5??$/?-V?\(?333333?`A7L?7KƧ?l?7KƧ?lD?n?`A7L?° ě?° ě?ěS?nP?GzH?M?j~"?333333?$/?`A7?nO;?tj~?p
=q?A7Kƨ?lD?lD?-V?-V? ěT?ěS?I^5??Q?
=p?-V?M?GzH?l?I^5??ěS?      ?nP?hr Ĝ?nO;?333333?nP?nP?vȴ9X?7KƧ?GzH?`A7L?"`?`A7L?"`?5?|h?° ě?$/?dZ1?bM?hr Ĝ?hr Ĝ?Z1'?&x?
=p?lD?S?&x?ěS?      ?nO;?ěS?GzH?lD?-V?      ?nO;?;dZ?`A7L?A7Kƨ?`A7L?n?      ?
=p?Q?lD?-V?nO?vȴ9X?A7Kƨ?;dZ?      ?Q?° ě?-V?$/?S?\(?A7Kƨ?GzH?333333?nO;?`A7L?`A7L?A7Kƨ?ěS?l?5?|h?|hr?nP?-V?|hr?`A7L?I^5??      ?M?
=p?Q?n?hr Ĝ?5?|h?
=p?;dZ?&x?`A7L?`A7L?-V?`A7L?Q?\(?ěS?nP?A7Kƨ?S?GzH?Q?`A7?      ?`A7L?lD?ěS?° ě?      ?hr!?lD?|hr?hr Ĝ?`A7?`A7L?j~"?|hr?;dZ?j~"?hr Ĝ?Q?hr Ĝ?Q?7KƧ?Q?bM?|hr?dZ1?GzH?M?7KƧ?|hr?hr Ĝ? ěT?7KƧ?      ?nO?hr Ĝ?A7Kƨ?nO?&x?GzH?GzH?hr Ĝ?Z1'?|hr?A7Kƨ?nO;?ěS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@Nffffff@N@N@N     @N@N@N@N     @N     @N@N     @N@N     @N     @N     @N     @N     @N     @N     @N@Ns33333@N     @N@Nfffff@Nfffff@Ns33333@Ns33333@N     @J@N@Nfffff@Nfffff@Nfffff@Nfffff@N@N@N@N@Nfffff@Nfffff@N@Nfffff@N@N@Nfffff@Nfffff@N33333@Nfffff@N33333@N33333@N     @N@N@Nٙ@N33333@O      @O@O@     @Offffff@Offfff@Oٙ@P@P&fffff@P,@P9@P9@P9@P333333@P333333@P&fffff@P9@PFfffff@PFfffff@PFfffff@PS33333@PL@P@     @PFfffff@PS33333@PY@P`     @P@     @PY@Pffffff@Pffffff@Pl@P`     @Pl@Pl@Pl@Pl@Pl@Ps33333@P     @Pfffff@Pfffff@P@P33333@P@P     @P@P@P33333@Pfffff@P@P@P     @Pfffff@P@P@P33333@P33333@P@P@P@P@P@P@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@P@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P@P@P     @P     @P     @P     @P     @P@P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@P     @P     @P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@Pٙ@P33333@P33333@P@P33333@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P     @Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@Pfffff@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@Pٙ@P33333@P@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @P     @P33333@Pٙ@Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pٙ@Pٙ@P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P@P@P33333@P@P@P33333@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P@P@P33333@P33333@P@P@Pٙ@P33333@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P@P@P@P33333@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P@P33333@P33333@P33333@P@P@P@P33333@P@P@P33333@P@P@P33333@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@Pٙ@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P@P@P33333@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P33333@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P@P@P@P33333@P@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                P25                                     1                                       +BG3