CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P14    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:48.108806Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @C        data_max      @C        C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     =  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @333333   data_max      @_   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      =  k   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      h  `   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?e   data_max      @!s33333   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       =     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      h  h   salinity                	long_name         salinity   units         PSS-78     data_min      @@RD   data_max      @AKwk   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      =    salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      h Cp   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @&   data_max      @sk33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        = R   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      h x   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?^5?|   data_max      @	lC   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      =    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      h ݀   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       =    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      h *   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @L33333   data_max      @Q         C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     = 9   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      h w   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (     time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      G   data_max      G   C_format      %10d       H   latitude               	long_name         latitude   units         	degrees_N      data_min      @H٩T!   data_max      @H٩T!   C_format      %9.4f          L   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `Jb#   data_max      `Jb#   C_format      %9.4f          P   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        T   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min        ?   data_max        ?   C_format      %4d        X@C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @C     @333333@      @ffffff@      @      @       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @C33333@D     @E      @E     @F      @F     @G      @Gs33333@H&fffff@H     @I      @I     @J      @J     @K      @K     @L@LL@M&fffff@M     @N      @N     @O      @O     @P      @P@     @Ps33333@Qfffff@QFfffff@Q     @Q     @R      @R@     @Rs33333@R@S      @S@     @S     @S     @T      @T@     @Ty@T@U      @U@     @U     @U     @V      @V@     @Vy@W      @W@     @W     @W     @X      @X@     @X     @Xfffff@Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[fffff@[     @\      @\@     @\     @\     @]      @]@     @]     @]fffff@]@^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`@`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b     @b     @b     @c      @c      @c6fffff@ci@c     @c     @c     @c     @d      @d      @dC33333@dP     @d@d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e@f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @iy@i     @i@i     @j      @j      @j@     @j`     @j     @j     @j     @k	@k      @k@     @k`     @k     @k     @k     @k     @l      @l@l@     @l`     @l|@l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @nٙ@o@o      @o@     @o`     @o     @o     @o     @o     @o33333@p      @p0     @p@     @pP     @p`     @pp     @p     @p33333@p@p     @p     @p     @p     @q      @qfffff@q      @q0     @q@     @qNfffff@qa@qp     @q33333@q     @q     @q     @q     @q     @q     @q     @r     @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r33333@r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @sfffff@t@t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @tfffff@t     @t     @t     @t     @u      @u     @u      @u0     @u<@uNfffff@u`     @up     @u     @u     @u     @u     @u     @u33333@u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w33333@w      @w0     @w@     @wP     @w`     @wq@w33333@w     @w     @w     @w     @w     @w     @w     @x@x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x@xfffff@xfffff@x     @x     @x     @x     @y      @y     @y!@y(     @yFfffff@yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @zfffff@zfffff@z     @{      @{     @{      @{0     @{Ffffff@{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|fffff@|      @|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}     @}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~@~     @~     @~     @~     @~     @~񙙙@~fffff@@      @0     @@     @P     @`     @p     @@     @fffff@fffff@     @     @     @     @      @     @@@      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@o33333@x     @     @     @     @     @fffff@     @     @     @     @     @     @@@     @     @     @      @     @33333@     @      @(     @0     @8     @@     @H     @P     @X     @\     @i@p     @x     @     @     @     @     @     @     @     @     @     @     @     @@33333@     @     @     @      @     @     @     @@*fffff@0     @8     @@     @H     @P     @X     @_33333@k33333@p     @x     @     @     @     @     @     @     @@     @     @     @     @     @     @@     @@      @     @     @     @ @%@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@	@     @     @      @(@0     @8     @>fffff@H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @      @     @@fffff@      @(     @0     @8     @@     @H     @P     @X     @`     @g33333@p@x     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @@      @     @33333@     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @      @     @     @     @      @(     @-@I@P     @X     @`     @h     @p     @x     @@     @     @     @     @     @@@ə@     @     @     @     @     @     @      @     @
@@      @(     @0     @8     @@     @H     @P     @X     @`     @h     @nfffff@y@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @      @     @33333@     @      @(     @0     @8     @@     @H     @P@T@a@h     @p     @x     @     @     @     @@33333@     @     @     @     @     @33333@ٙ@     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @_33333@h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@fffff@      @     @     @     @      @(     @0     @4     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @fffff@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @      @     @     @     @@(     @0     @8     @@     @H     @P     @Vfffff@a@h     @p     @x     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @@      @33333@     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @~fffff@@     @     @     @     @     @     @     @     @͙@fffff@     @     @     @     @      @     @33333@"fffff@(     @0     @8     @@     @H     @P     @W33333@c33333@g33333@p     @x     @     @     @     @     @     @     @@@33333@     @     @     @     @     @@      @     @     @     @      @(     @0     @8@@     @H     @P     @X     @`     @h     @p     @x     @     @     @@     @     @     @     @     @     @     @fffff@33333@     @     @     @     @ fffff@@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\fffff@`     @d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @fffff@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @c33333@hfffff@l     @p     @t     @x     @|     @     @fffff@@     @     @     @     @     @     @fffff@@     @     @     @     @@     @     @     @     @     @     @     @     @@噙@     @     @     @     @     @     @      @33333@     @     @     @     @     @      @#@,     @0     @4     @8     @<     @@     @D     @H     @L     @Pfffff@T@X     @\     @`     @d     @h     @l     @p     @y33333@|     @     @     @     @     @     @@@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @fffff@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @7@<     @@     @D     @H     @L     @O@Tfffff@X     @\     @`     @d     @h     @l     @p     @t     @x     @@     @     @     @     @fffff@fffff@@     @     @     @@     @     @     @     @     @     @     @˙@     @     @     @     @     @     @     @fffff@     @     @     @     @      @     @     @     @     @     @fffff@@@$     @(     @,     @0fffff@4     @8     @<     @@     @D     @H     @L     @P     @S@X     @\     @`     @d     @h     @l     @p     @tfffff@v@fffff@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @fffff@     @홙@     @     @     @     @      @     @fffff@
     @@     @     @      @$     @(     @+33333@4fffff@8     @<     @@     @D     @H     @K33333@Pfffff@Tfffff@X     @\     @`     @d     @h     @l     @p     @t     @x@{@     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @Ǚ@33333@     @     @     @     @     @     @     @@@     @      @     @     @     @     @     @fffff@ @$     @(     @,     @0     @4     @8     @:fffff@Dfffff@H     @L     @P     @T     @X     @[33333@d@h     @l     @p     @t     @x     @{@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @@@     @     @      @     @     @fffff@fffff@33333@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@I33333@K@P     @T     @X     @\     @`     @d     @f@n     @p     @t     @x     @|     @     @@fffff@     @     @@     @     @     @     @@fffff@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @홙@     @     @     @@ @     @     @     @     @     @@!33333@$     @(     @,     @0     @4     @7@<fffff@@     @D     @H     @L     @P     @T     @X     @\     @a33333@d     @h     @l     @p     @t     @x     @|     @     @33333@fffff@     @     @     @     @     @@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @     @fffff@@     @@     @     @      @$     @(     @,     @0fffff@4fffff@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @@@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @fffff@     @     @     @     @@     @     @      @$fffff@'33333@,     @0     @4     @8     @<     @@     @D     @H     @M@P     @T     @X     @\     @`     @d     @h     @l     @n@tfffff@x     @|     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @33333@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @@
     @     @     @     @     @     @      @"@,     @0     @4     @8     @<     @@     @D     @G33333@Lfffff@P     @T     @X     @\     @`     @d     @h     @l     @p     @r@z     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @Ǚ@     @     @fffff@     @     @     @     @     @     @@     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@fffff@D     @H     @K@P     @T     @X     @\     @`     @d     @j     @l     @p     @t     @x     @|     @     @     @@fffff@     @     @     @     @@     @     @fffff@@     @     @Ù@Ǚ@     @     @     @fffff@     @33333@@     @     @     @     @     @     @@	@     @     @     @fffff@fffff@      @$fffff@)@,     @0     @4     @8     @<     @@     @D     @M@P     @T     @X     @\     @`fffff@b     @hfffff@l     @p     @t     @x     @|     @fffff@     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @@     @     @     @     @     @fffff@     @     @     @     @     @     @@      @     @     @     @     @33333@     @     @      @$     @(fffff@,     @0     @4     @8     @<     @@     @D     @Hfffff@J     @P     @T     @X     @\     @`     @d     @g33333@p@t     @x     @|     @     @     @     @     @     @fffff@fffff@@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @fffff@㙙@     @     @     @     @     @     @      @     @     @
     @@     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @Lfffff@N     @Tfffff@X     @\     @_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @!qN;6@!r:)y@!s33333@!sPH@!sPH@!s҉@!q-@!qR@!q2W@!nT@!ov@!nVu@!l@!l1&y@!g	k@!TZ@!Gy@!?.H@!;m]@!6l!-@!4Ʌoi@!2䎊q@!12W@!0'RT@!/o @!-
qv@!+'/@!'_o@!&
L/@!#%2@!/w@!|@!$/@!p:~@ D*@ 6@ Ӂ@ ǮzH@ Z@ p:~@ -w1@ 5Xy>@ v4K@ -hr!@W>6z@h\)@0
(@ڹZ@t@D*0@^5?|@o@y=c@ؓtj@@@т@Țu%F@,=@*0U@+@@<64@bM@U=@wKƧ@-\@~($@E@Ƨ@JL@S@An.@&x@]cA@vȴ9X@D@d7@@S@ڟvȴ@%1@I@/-V@!R<6@*1@
:@&I@ᰉ'R@ԯO
M@b@-@ěT@ěT@@xF]@o h@?@k~(@7Kƨ@|hr@k~(@6@>BZ@$tS@N;@`A7L@Dg8~@Fs@ʌL_@5?|@6z@m8@F@lC@TɅo@2W@/{J#@+C]@>
(@JL_@LI^5?@N!R<@Stj~@aR<6@h@xl"h	@JM@L_@(@*0@S@wkP@qu!@y=c@@$/@q@tj@L_@Ϫ͞@Ϫ͞@E@u@͞@:@!R<@tj@w1@a-w1@RnO@-V@2a|@$t@2W@?@m@@@lq@e1@`ěT@P-
q@2{m@q@&x@,=@Zc@'0@c	@	@O;d@F]c@`'RT`@?@6z@3g	l@"}Vm@*0@\@Ft@t@Ƨ-@b}V@2W@N;@^5?}@$@~\N<@y~($@g/V@TɅoi@MjOv@HK]c@C$@>BZc @:)_@9rGE8@73@6ȴ9X@2{m@.c	@#Z@ A7K@u%@D*@Ϫ͞@`d@u@+@]cA@D@?@`A7@xl"h
@q@$xG@e@ae@JE@|@%@oiDg@}<64@y#w@tm8@nzG@d?@O
M;@>vȴ9X@9"`@,[W?@,<@Xe,@!R<@o hی@fA@fA@+I@	k@S@qiC@s33333@kjf@dxF@a-w1@\1&@Z6C@V@TZ@QX@Gݗ+@A@-V@>6z@2W@o@ƍ@?@1&y@|@v4K@pU2a|@hۋq
@aGz@b3@L@;s@8F@5sg@1-@"`A@JE@Fs@N;5@~($x@ ѷ@73@o@c	@lD@ڹ@Q@ԯO
M@ԕ*@NU@m]@1@ hۋ@iDg8@zxl"@lD@%1@ae@5?|@Mj@_o@w1@iy@\u"@O@2W@E@I^5?@@ 4m@)y@Fs@[W>6@~"@}H@ќu@͸@ʦL/{@š@F@:~ @c	@P{@x@[6@Q_@O;dZ@n@x-
@xl"h	@{/V@{J#9@vC-@o{J#:@g&@b@4@]ce@WXe,@Sa@O@Oo @JqiC@@ѷX@=ڹZ@;lC@:xl"h
@873@6ȴ9X@6E@4D@3E@1[W>6@,VϪ@&,<@Q@=K@p:@͞@-@ NU@p
=@rGE8@c	@1.@e+@u!@cA @u%F@u%F@@և+J@@hr @Vu@=p
@@1@l@Vϫ@.2@U=@rGE@-@Gz@d8@A7K@@ce@"`B@@Ʌoi@҉@`A7@rGE9@qi@L_@ [7@.H@}b@{5Xy@u!.@q&x@oiDg8@lq@jJL@i*0U2a@i*0U2a@irGE@h\)@kP{@o hۋ@nzG@Y_o@ZQ_@f1.@f'@d%1@dxF@d7@d?@bwkQ@`҈p@_䎊r@`
qu@_	@]/w@\ߤ@@[6@TɅoi@Np:~@FYJ@B@4n@@6@;A@:~@;dZ@:G{@9rGE8@6C-@3g	l@0D@/-V@,VϪ@$7@!o@%@(\@6C@Q_@Xe,@;5X@8YK@a@N@<64@rG@C\@)_@^5?|@"`@#w@Xy=@ᰊ@4֡a@c	@x@L/{J@ڹ@e@@4@ܬ1&@L_@̲@ˬq@ˬq@#9@8YK@{J#9@|hs@rGE8@E@|@[W>6@@1@B@"h	ԕ@7@o@>BZ@҉@$tT@_o@74@@4m@NU@}p
=@|PH@{5Xy@zC\@t!-w2@oiDg8@nO;@m
qv@m8Y@lq@e@`d8@^iB@]-V@\u"@[S@[=K^@ZQ_@Y_o@W+j@Vl!-@TE@Qhr @Np:~@LI^5?@G+I@EQ@A@>6z@<n.@:G{@8}H@5Y|@2W@0{@0
(@/v@,"h	ԕ@'lC@$TɆ@!ae@҈p;@Q@u%F@&@Z@tj~@;dZ@)^	@҈@	'RTa@$/@o i@%2@ IQ@hr@s@MjO@ hۋ@hr!@	@6@+@
=p@,<@*0U@Ƨ@]cf@ěS@TɅo@C@C@6@|hs@n.@}Vl@Vϫ@6z@\)@F
L0@'RT`@kP|@O;dZ@eO@~"@uY|@r{m@j~"@\(\@SZ@JD@H˒:*@C,zxl@A@?@?H˒:@:^5?|@*0U2a|@vȴ9@Xe,@:)y@hr @
qiC@ݗ@u%F
@lC@F]d@1@#@PH@!-w2@8Y@~"@rGE@fA@eO@+@Z@;dZ@:@n@,zxl@64@Xy=@֡a@|@W@r@v@zG@w1@I^@S@䎊r@PH@L_@ݗ@{J#9@}!.H@|?@z@u!.@sE@ql@nc	@kP{@jfB@g@_o@^@^@Z1'@P*0U@K]cA@I@H˒:*@Gy@B&IR@;/V@:)y@<64@=K]@=b@:^5?|@7KƧ@5Xy=@5sg@4J@/Vϫ@,<쿱@'-@!-w1@@kP|@1&@-V@u"@u%F@PH@+j@O
M@@N@Mj@	 ѷ@M:@ ѷX@
H˒@
m]@
(@
@
Dg8~@
A@
ⶮ}Vm@
ڹY@
=p@
Ϫ͞@
;dZ@
s@
ɺ^5?}@
g8}@
4m@
j~#@
C-@
ߤ@
{@

qv@
}Vl@
v@
a@@
TɅ@
@
1&y@
ae@
@
_F@
@
sh@
sP@
Vu@
ݗ@
~$t@
}ڹZ@
{lC@
y=b@
y=b@
y	k~@
x73@
w1@
rGE85@
kQ@
eڹ@
c	@
]cA @
YJE@
WsPH@
R<64@
Np:~@
JW'@
I@
As@
>BZc @
9#w@
84֡b@
8YJ@
4J@
3g	l@
7rG@
49XbN@
333333@
0'RT@
/O
M@
,>B[@
+a@@
%u@
,=@
PH@
ݗ+k@
@
 ѷ@G{@ȴ9X@ۋq
@Z1@;dZ@JE@D*@l!-@ҽ<64@n@@@y@
L/@8YK@\N@7Kƨ@p
=@}H@4K@9XbN@x@9@_F@ᰉ@sP@Mj@I^5?@L_@L_@҈@oiDg@{J#9@}!.H@sg@qA [@o hۋ@nO;@gfA@de@_?@Xe+@R<64@LcA \@A@;5Xy@6z@5'0@1o@(Xy=@%1@vȴ9@+J@$/@Fs@u@
O;dZ@1&x@b}V@"`@ȴ9X@{m@@r Ĝ@ޞ@As@&IR@)y@3@sg@o@2X@B@q@<쿱@a@@&@o@u@@7KƧ@n/@n.@}H˒@zG{@t#@nc	@^҈p;@XD*@W@W@W>6z@Vl!-@TE@SMj@P*0U@Ks@IQ@HK]c@Fs@B74@A7Kƨ@?[W>@<Z@9D@4m8@1-@/Vϫ@/{J#:@.H@,zxl"@)lD@'&@',@%S@wkP@@bM@
(@	 ѷ@ hۋq@
PH@
xl"h
@
F@
rGE8@
F@
_ح@
{m@
x@
u!@
c	@
@
а{@
_o @
cA \@
*0@
s@
TɅo@
7Kƨ@
7Kƨ@
|hs@
~($@
3@
?@
d7@
&@
@@
sP@
N;6@
@
Vu@
#@
JM@
%2@
@
ѷX@
s@
ceO@
`u!@
_Ft@
\>@
Vl!-@
M%@
KƧ@
F]cf@
As@
>vȴ9X@
;5Xy@
9D@
5'0@
1&x@
+U=@
-V@
O;d@
)^@
?@
@	˒:)@	hr@	-
@	!-w2@	D@	c	@	ڹ@	@N@	҈p@	ߤ?@	՛=K@	Ƨ@	Q@	?@	|hs@	v@	^5?|@	~($@	YJ@	?@	|@	H@	C,zx@	qu"@	4m9@	u!R@	tD@	r ě@	mhr!@	cZ@	]ce@	Z1'@	W
=p@	Sa@O@	P{@	OAs@	Rm@	L/{J#@	I^5?}@	F
L/@	B74@	@n@	A@	>ߤ?@	<64@	:~@	73@	<n.@	(TɅ@	+a@@	2m\@	-U=@	,1&y@	$tSM@	u%@	u%F@	*0@	ߤ?@	$/@	YJ@	eO@	Fs@+@7@cA @sPH@҈p:@As@@D@ǮzH@a@N@@A@Xy=@zG@,@
=p@Ov_خ@kP|@@N@:)y@@@O;dZ@M:@qu"@@bM@-
q@qu"@M:@C%@qiC@k~(@ڹY@@0
)@	@,=@Q@qu!@vȴ@_o@e+a@kP|@@ߤ?@#@     @mC\@a@N@Y+@SZ@P`A7@O
M;@Np:~@I@@6@2m\@%u@vȴ9@qu!@PH@R<6@nO@Mj@\(@
(@S&@@4n@n.@g@C,z@	ԕ+@@u!@y=c@t@fA@m@#9@Ƨ-@\(@ [7@@vȴ9X@b@D@{@S&@쿱[W@6C@@O
M@@N@hr @)^@ԕ*@ݗ@%2@F]c@hۋq@{~$@z@y=b@y	k~@x-
@w1@rs@kP{@eO
@QR@E84֡@A7Kƨ@?@>vȴ9X@=<64@;A@:)y@73@43@1&x@%F
L0@wkP@e+a@bM@tj@n.@$tS@\N<@xl"h
@F]d@\(@:~ @8Y@Z1@Gz@u!@ ѷY@(\@W>6z@1'@JE@+@bM@՛=K@,<@H@
L/@@
(@A@Q@4K@ߤ@ ě@.H@u"@6C@R<6@\(@@L_@nP@$tS@|PH@y(@yrGE8@x-
@wkP@w+@v!.I@u!R@p:~ @nc	@irGE@^҈p;@ZY@W&@W@YJE@U2a|@R<64@O͞@M5Xy>@H9Xb@B74@@4m@<쿱[@8Q@/{J#:@)*0U2a@ [6@ߤ@@6C@*0@sP@4J@bM@Vu@q@'/@
	 @
L/{@1&x@n.@"@b}V@˒:)@.H@E@73@j~@SMj@g@%F
L@D@hr!@빌~($@@ⶮ}Vm@cA @m@+@͞%@s@ȴ9Xb@@BZc @/V@2X@0
@&@F
L0@9@-w1@%@@O
M@n@qi@u%F
@$tS@~m\@zxl"h
@oiDg8@k~($@kC,z@hr Ĝ@be+@\>@ZY@Z1'@W&@Rm@PH@O
M;@M@K)^	@I@IoiD@H@HK]c@G@@H@I@Dg8}@>vȴ9X@84֡b@7Xe@4J@,q@(\)@$tSM@!-w1@ߤ@@vȴ@Xe,@bM@qi@
@
@@@q@
	 @+I@YJ@o h@I^5@73@E@MjO@g@@C]@e@6@y=c@>6z@̘_@@]cf@*0@@Zc@4m@4m@2W@Q@6C@sh@)^@qu"@=p
@eO@Fs@n/@~m\@x73@v_ح@qu!S@mhr!@l"h	ԕ@jJL@gfA@g8}H@g	k@e`A7L@cA [@_o@Zc	@XbM@S@P|@U2a|@I@>ߤ?@3ߤ@/v@-w1@*͞&@&x@%zxl"h@"`A@[@e+a@@O
M@ߤ?@L_@Q@m\@rGE8@F@-
@-
@F@	k~@ ě@쿱[W?@Dg8~@fA@@fffff@fffff@@`A7L@e@C,@
qu@ ѷY@]ce@+@y=c@@8YJ@jOv@YJ@m\@o@o@U2a|@v@d7@TɆ@3@ěT@%@+j@zG@@@N@sP@nO@hr @rGE9@Vu@K]d@u%F
@     @yrGE8@u%F
L@r ě@pD@p:~ @l!-w@l"h	ԕ@kQ@iB@hr Ĝ@e+a@a'R@`d8@\]ce@[W>6z@[6@Zc	@Z1'@Y+@W&@S@Rp:@RT`d@QR@O͞@N+@L_@GE84@C$@>ߤ?@=p
=@;A@73@5?|h@43@3|@2-V@-
qv@-V@*0U2a|@%F
L0@䎊r@tj@rGE9@
=p
@ݗ+@+I@ݗ@n/@S&@S&@M:@˒:)@rGE8@F]d@_ح@E@D@JL@A@M@ܑN;@v_ح@W'@]cf@74@[W>@A@4֡b@?@9XbN@33333@&x@zG@1&y@,@zxl"h@u@S&@h	ԕ@o@[6@vȴ9@,=@ߤ@@u%@PH@ᰉ@O
M@sP@n@@\(@O;dZ@C%@	 @L/{@qiC@p:@&I@M:@F]c@nP@@.H@|Q@y"`@xF@vFs@uY|@tj~@r{m@p
=q@mC\@m(@lC@lVϪ@l"h	ԕ@kQ@h@bC,@a|Q@a@N@^@[W>6z@XU@XD*@Vl!-@U2a|@P|@N_o @H9Xb@ATɅo@@C@A7Kƨ@As@B&IR@C@@n@=v@;/V@64K@/Vϫ@,1&y@'RT`e@%u@ ěT@,=@ߤ@@kP|@@Z@Z@Fs@n@ߤ?@@
qiC@p:@eO@K]d@ݗ+@ݗ+@_o@Fs@S&@:S@"@ڹZ@>B@	k~@(@73@SMj@u!S@oiDg8@4֡a@c	@!-w@빌~($@g	@Dg8~@+a@ޞ@b}@Ʌoi@`d@ӎMj@ҽ<64@T`d@т@N;5@`A7@*0U@As@;5X@͞%@ʌL_@*0@74@n@6z@<64@5Xy@~($@}H@C-@z@ߤ@2W@V@q@TɅ@@tSM@
=p@h	ԕ@-
@䎊r@Q@vȴ@L_@҉@bM@bM@)^@Vu@~($x@҈@҈@L_@L_@҈@'/@ڹY@ԕ*@qiC@p:@_o@_o@n/@?@JM@tj@JM@@ ѷ@I^5@:S@y=b@w1@v+jg@tj~@s@r䎊q@rGE85@pD@mC\@lC@kQ@iᰉ'@ffffff@e@e+a@de@ceO@b}Vm@d7@cS@bM@a'R@aGz@`҈p@`
qu@^5?|@ZY@XU@UϪ͞@S@S&@QN;5@P|@OAs@M5Xy>@Jn@IoiD@Gy@F?@D2W@ATɅo@?@>6z@=v@<n.@9~($@73@2W@0{@.1@.H@-U=@,<쿱@*0U2a|@+6z@(@&'@%1@$TɆ@$?@#n.3@!R<6@vȴ9@Q@U=@ߤ@@kP|@@@Z@nO@hr @rGE9@qi@҈@	'RTa@K]d@n/@M:@@@ IQ@ \N<@ J#9@ kP@ \(@ %F
L@ @ l@ :~ @ iDg8@ 8Y@ g	@ B@ ᰉ'@ Dg8~@ `A7L@ d8@ ?@ 6@ W>6z@ >BZ@ Ϫ͞@ @ *0U@ jOv@ /{J#@ s@ s@ )^	@ ȴ9Xb@ @ @ y@ ]cf@ )^@ s@ ?@ 8YK@ ěS@ \N@ @ n@ n@ ߤ?@ 
(@ XbM@ 9XbN@ g	l@ W@ W@ {@ B@ <쿱@ I^@ d7@ @ L/{J@ u@ F
L0@ zxl"h@ 1@ @ @ tSM@ S&@ -
@ wkP@ PH@ O
M@ *0U2@ *0U2@ Mj@ L/{@ JM@ u%F
@ @ ѷX@ ~$t@ |#x@ tSMj@ pD@ poiDg8@ oiDg8@ n.2@ m(@ irGE@ c	@ ae@ `A7K@ \>@ Zc	@ Xy=c@ P{@ Ks@ K]cA@ E@ B\(@ A [7@ @4m@ ?|hs@ >vȴ9X@ <Z@ <n.@ 9#w@ 6}Vl@ 6E@ 49XbN@ *0U2a|@ $/@ #n.3@ "wkQ@  	k@ !-w1@ ,<@ @ 6C@ sh@ O
M@ S&@ \(@ L_@ 	ԕ*@ #@ K]d@ M:@ {J#9@ @ :S@  ѷX@ :S?+?Fs?!.I?MjO?D?4֡a?(?쿱[W??JL?fA??Gz?
qu?/w?ڹY?ڹY?+?b}?8YJ?Z?*0U?)^	?y?8YK?m\?o i?&IR?Z?ᰊ? ě?O
M?1&y?&?TɆ?ae?S?O;d??O
M?N;6?N;6?Mj?C%?q?eO???nP??4m9?}H˒?|Q?xF?xl"h	?u%F
L?qiB?p:~ ?oiDg8?o?qiB?oiDg8?kP{?g	k?eڹ?c	?a|Q?\N;?[W>6z?Zݘ?Z1'?Xe+?U2a|?T`d?RT`d?P{?Ov_ح?PH?N;5X?JD?F]cf?D*0?C$?A7Kƨ?@NU?A [7?=b?;dZ?:S&?84֡b?64K?333333?0U2a|?/v?.H?-V?,zxl"?*0U2a|?&?!.H?	?Ov_خ?C,zx?*0?@N?u?)^?	k~(?Fs??Fs??F]c?$tS?lC?73?MjO?s?D??4֡a?(?C,z?g	?x?x?fA?e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@RD@@R74@@R74@@R~@@Rm\@@Rm\@@Rm\@@R~@@Rm\@@SS&@@Rm\@@Su%@@S҉@@Su%@@S)^	@@S@N@@SMjO@@SF]c@@SC%@@S=K^@@S6z@@S33333@@S6z@@S33333@@S33333@@S6z@@S6z@@S33333@@S,zxl@@S33333@@S6z@@S6z@@S6z@@SC%@@S~$@@S@@S:)z@@SS@@S
=p@@T1&y@@T?@@T?@@TE@@U(@@Vz@@W@@Wݗ+@@W+@@XQ@@X@@YGz@@YXbM@@Y*0U2a@@Y@N@@YrGE@@Ye+a@@Y@@Y@@YrGE8@@Yhr @@YrGE8@@Y^@@Ye+a@@Yx@@Y@@Z1'@@Zu%F@@YX@@YB@@YiB@@YN;6@@Z)y@@Z6C@@ZGE85@@ZQ_@@Z^5?|@@ZQ_@@ZGE85@@ZC\@@Zd7@@Z@4@@Zu%F
@@ZZc@@Zd7@@Zd7@@ZkP|@@Zu%F
@@ZL_@@ZS&@@Z@@[@@\(\@@\/{J#@@\`d@@\wkP@@]-V@@_,@@arGE8@@bL_@@c|@@eϪ͞@@h4m@@ie@@jn@@k6@@mڹ@@n"@@q@@vߤ?@@|hr@@@@iB@@`A@@W>6z@@#x@@m\@@sPH@@@@@@1@@;dZ@@A [@@P{@@-
@@G{@@F]d@@,<@@
=p@@2a|@@tj@@ᰉ@@[W>@@%1@@ƃ%@@Q@@-@@s@@,@@`A7@@u%F
@@ܞ쿱[@@ޞ@@rGE8@@fB@@䄵?@@8Y@@)^@@lD@@)_@@n.3@@m\@@
L/@@@@5?|@@iB@@af@@Fs@@v@@!-w1@@iDg8@@kP@@@@E84@@@@1@@&I@@6z@@6z@@T@@T@@af@@@@fffff@@YJ@@R<6@@s@@qi@@}Vl@@s@@z@@}Vl@@IQ@@Fs@@@@@@IQ@@s@@p:~@@fffff@@Ov_خ@@E@@L/{J@@Vu@@R<6@@L/{J@@Ov_خ@@L/{J@@L/{J@@L/{J@@H@@E@@BZc @@E@@E@@H@@?@@BZc @@BZc @@BZc @@BZc @@5?|@@8YJ@@$/@@t@@E@@(@@oiDg@@ ѷY@@oiDg@@(@@C\@@ڹ@@ ѷY@@C\@@ڹ@@C\@@S@@\(@@sh@@\(@@-V@@+j@@힃%@@v@@@@+j@@1@@픯O
@@}H@@zxl"h@@jOv@@ce@@M:@@}H@@p
=@@fA@@\@@Vl!@@Vl!@@L_@@Y|@@\@@O;dZ@@ce@@w1@@$/@@p
=@@}H@@M:@@M:@@M:@@Xy=@@(@@IQ@@L/{J@@Ov_@@!R<@@!R<@@8YJ@@IQ@@%@@s@@vȴ9X@@z@@vȴ9X@@IQ@@vȴ9X@@s@@}Vl@@}Vl@@$t@@T@@ߤ?@@C-@@x@@
M;@@v@@v@@$tS@@'/W@@4֡a@@8}H@@>6z@@b}V@@o@@4m@@	k@@͞@@K]d@@䎊r@@4m9@@D*@@D*@@U2a|@@bM@@l"h	@@y=c@@u%F@@C@@&x@@:S@@Dg8~@@N;5@@oiD@@N;6@@e@@I^5@@&IR@@3@@C\@@^5?|@@0
@@}Vm@@`A@@c	@@C,z@@,zxl@@a@N@@Q@@U=@@~($@@Q@@C]@@J@@/{J#@@g8}@@tSM@@zG@@?@@qj@@qj@@*1@@쿱[@@3@@@@@@hr@@!.H@@Vl!@@m\@@M:@@\(@@,=@@ ѷY@@!R<@@l!-@@Fs@@6z@@}Vl@@&I@@A@@+@@C-@@쿱[W@@ hۋ@@
=p@@!-w1@@4֡a@@o@@[W>@@@@-@@F]d@@}H@@4m9@@D*@@|@@n@@YJ@@IQ@@@@
(@@C@@{@@	k~@@_p@@@@0
)@@hr @@@@e@@lD@@I^5@@C\@@xl"h
@@p:@@<64@@G{@@'/@@nP@@	@@/V@@MjO@@tj~@@ߤ@@
=p@@A [@@PH@@C@@JM@@Q@@<64@@%@@1@@\(@@?@@ᰉ@@E@@
L/@@@@$/@@Fs@@!.I@@O;d@@fA@@-@A H@A NU@A K]c@A U2a|@A _F@A n@A @A p:@A `A7@A_p@Ax@Au@Ao@A>BZ@A-@AY}@Ae+@AQ_@A@AڹY@A"`B@A"`B@Ajf@Awk@A@AE@AZ@Aa@@A҈@AC]@A@Aj~#@Azxl"@AO
M@A/@Aqu"@Am\@A-V@Aڹ@At@At@Au@AR<6@A%@A-@A+@AFt@A$tS@AE84@AU=@AXe,@ART`e@A_o@Aݗ+@AkP@A@A'RT`@AH@A-
@A)^@AF@AD@AѷX@A\)@A	$/@A	@A	#w@A	x@A	@A	'RTa@A	'RTa@A	n.@A	|@A
n@A
:)y@A
T`d@A
W'@A
^5?|@A
kP|@A
qiC@A
u%F
@A
{m@A
S&@A
L/{@A
g	@A
ڹY@A
74@A'/@AF]c@AZ@A~$@Awk@A6@A@Ag@AJ@A!-w2@A/{J#@A/{J#@AFs@Aq@A1&@A?@A@A
o i@A
2a|@A
S&@A
m\@A
ݗ@A
hr!@A
Xy=@A
b@A.2@AOv_خ@Ac	@Al!-@A,<@AQ@Aȴ9X@A hۋ@A+I@A1@A1@A|hs@AkP@A	k@A?@AzH@A@A@A@A-@AF]d@AF]d@A@A
qu@AbM@A}H@AK]c@A_F@Ay=c@AYJ@A-
@AU@A)@A)^@AD@A*0U2a@A:S@AJE@Ae+a@AR<6@AN;6@Ae+@A䎊@AZc@Ad7@Au%F
@A~"@A@AS&@A33333@AS@Ag	l@Aqu!@Aߤ@A*0U2@AZ@A%2@AJ@Aߤ@@Atj@A@A(\@A9XbN@AFs@AI^5?@AI^5?@AZ1@A#@AN;@A쿱[@A1&@A#x@A/@Ae@A[@A[@A*0@AQ@A+a@A/w@A5Xy>@A84֡@AB@AS&@Am\@AM:@AcA @AC\@A
(@A1.@AE@AiB@A%@A$t@A,<@AT@A'@A҈p;@A@AH˒:@AH˒:@AE84@A_o@A	@A&@A˒:)@A@ArG@A
qu@A*0@A73@AK]c@AXy=@A[6@Ar Ĝ@Au!@Ar Ĝ@Au!@An@AU@A@@A@A$tT@A@ATɅo@Au!S@Ab}@AR<6@A(@A(@A^5?}@Aԕ*@A"`@As@A1'@A6C@AC\@AQ_@Ah	ԕ@AqiC@A@A͞&@A ѷ@AD@APH@A33333@A=K^@AP{@AZ@Aa@N@A@A:)z@Am]@A҈@A@Aߤ@@A/{J#@AM:@AcA \@AcA \@A?@A*1@A֡a@Ao i@A(@AQ@AQ@A+a@A<64@AY|@AU=@A@A?@AoiDg@A@A5?|@A8YJ@AL/{J@AYJ@A%@A@AT@Aaf@Aaf@A@A@AO;@AO;@A@A@A,<@At@Ax@A"@A@Av@A'/W@A#@A $xG@A *0@A :~ @A >BZc@A K]c@A K]c@A y=c@A @A IQ@A 9Xb@A ѷX@A `A7@A 	k@A! ѷ@A!JE@A!hr @A!x@A!o@A!@A!@A!l@A!_o@A!ԕ*@A!ԕ*@A!>BZ@A!R@A!@A!-@A"n@A"#9@A"-V@A"6C@A"xl"h
@A"ᰊ@A"@A"@A"}Vm@A"@A",<@A" ѷ@A"fB@A"m@A#C,z@A#"`B@A#9@A#dZ@A#tj~@A#~$@A#~$@A#q@A#~($@A#
=p@A#s@A$@A$/{J#@A$VϪ@A$q@A$zG@A$~($x@A$#@A$O
M@A$#x@A$Z@A$D@A$hr@A%K]@A%*0@A%5Xy>@A%S&@A%}H@A%!R@A%+j@A%@A%@A%b@A&_o @A&BZc @A&p:~@A&+J@A&Fs@A&O;@A&T@A&-@A&}Vl@A&'@A&'@A&'@A&ȴ9X@A&]cf@A&1@A' hۋ@A'4֡a@A';dZ@A'O
M@A'Xe,@A'eں@A'|hs@A'ݗ+@A'fA@A'Vϫ@A'Vϫ@A'@A'Vϫ@A'+j@A'rGE9@A'#@A(
qu@A(}H@A($xG@A(-
q@A(4m9@A(A7K@A(H@A(NU@A(Xy=@A(bM@A(u!@A(n@A('RT@A('RT@A(-
@A(IQ@A(@A(U@A(9Xb@A(
(@A(D@A(@A) ѷ@A)	k~@A)_p@A):S@A)Gz@A)JE@A)JE@A)TɅo@A)XbM@A)ae@A)u!S@A)u@A)|@A)@A)D@A)"`@A)"`@A)iB@A)Y}@A)Y}@A)lD@A)lD@A).H@A*	 @A*Ov`@A*s@A*#9@A*@4n@A*M@A*ݘ@A*L_@A*L_@A*p:@A*S&@A*vȴ@A*>B@A* ě@A*}Vm@A*<64@A*G{@A*m\@A+I^@A+S&@A+u%@A+s@A+=K^@A+@N@A+S@A+]cA@A+a@N@A+jf@A+n.3@A+xF]@A+~$@A+Mj@A+E@A+a@O@A+
=p@A+A [@A+$@A+@A+\N@A,ߤ@@A,!-w2@A,,<@A,/{J#@A,I^5?@A,SMj@A,SMj@A,SMj@A,zG@A,qj@A,C@A,N;@A,zxl"@A,?@A,[W?@A,7@A,?@A,Ʌoi@A,֡a@A,/@A,hr@A,e@A-K]@A-o i@A-K]@A-V@A-+a@A-<64@A-L_@A-Vl!@A-fA@A-p
=@A-sg@A-zxl"h@A-}H@A-M:@A-ڹZ@A-O
@A-@A-1@A-@A-
qv@A-(@A-!.@A.t@A.zG@A.vȴ9X@A.}Vl@A.'@A.'@A.҈p;@A.]cf@A.A@A.Ϫ͟@A.Ϫ͟@A.ȴ9X@A.m\@A.1@A/ hۋ@A/)^@A/
=p@A.Mj@A.쿱[W@A.C-@A.x@A.쿱[W@A.Mj@A/@A/Xe@A/+I@A/1@A/RT`e@A/\(@A/sPH@A/{J#:@A/	@A/@A/	k@A/͞@A/zH@A/vȴ9@A/[W>@A/3@A/r@A/˒:)@A/+@A/˒:)@A/@A/@A/Vϫ@A/+j@A/+j@A/rGE9@A0	ԕ+@A06@A0bM@A0'RT@A0-
@A0d8@A0{@A04m@A04m@A0{@A0d8@A0)^@A0F@A0e+@A04֡b@A0D@A0D@A0F@A0ۋq
@A0e+@A0\)@A1$/@A1@A1&x@A1=b@A1N;5@A1Q@A1e+a@A1k~(@A1hr @A1hr @A1o hی@A1x@A1@A1l@A1X@A12W@A1ᰉ'@A1Y}@A2u%F@A2	 @A2䎊@A2&IR@A23@A2:)y@A2GE85@A2{m@A2S&@A2g	@A2}Vm@A2n@A2@A2)_@A2sP@A274@A333333@A3@N@A3F]c@A3C%@A3MjO@A3P{@A3W>6z@A3]cA@A3{J#9@A3~$@A3Q@A3U=@A36@A3҈@A3lC@A3g@A3C]@A3C]@A3@A4xF@A4ߤ@@A4@A4"h	ԕ@A4(\@A42W@A49XbN@A42W@A4<쿱@A4C,zx@A4PH@A4VϪ@A4cA \@A4cA \@A4wkP@A4tSM@A4wkP@A4N;@A4O
M@A4@A4@A4j~@A4Ʌoi@A4*0@A4>B[@A4hr@A4e@A5u@A5[@A5[@A5!.H@A5!.H@A5(@A5/w@A52a|@A55Xy>@A5?|h@A5?|h@A5?|h@A5Vl!@A5zxl"h@A5ڹZ@A5+j@A5+j@A5@A5Xy=@A5Xy=@A5-V@A5S@A5oiDg@A5C\@A6t@A6@A6@A6@A6BZc @A6Ov_خ@A6\N<@A6c	@A6l!-@A6vȴ9X@A6%@A6@A62X@A6m\@A6ߤ?@A6Mj@A6!.I@A7 hۋ@A6Fs@A6"@A7 hۋ@A7)^@A7!-w1@A7!-w1@A74֡a@A7>6z@A7As@A7E84@A7>6z@A7Xe,@A7RT`e@A7\(@A7o@A7	@A7O;d@A7$tS@A7[W>@A7/V@A7vȴ9@A7vȴ9@A7@A7@A7䎊r@A7䎊r@A7rGE9@A8@A8
qu@A8@A8@A8@A8}H@A8 ě@A8 ě@A8-
q@A8-
q@A8*0@A8*0@A81&x@A8>BZc@A8H@A8[6@A8[6@A8l"h	@A8u!@A8y=c@A8|@A8YJ@A8-
@A8{@A84m@A8҈p@A9 [7@A9 [7@A9&x@A94J@A94J@A97KƧ@A9=b@A9Gz@A9N;5@A9TɅo@A9^@A9hr @A9e+a@A9e+a@A9o hی@A9hr @A9oiD@A9@A97Kƨ@A97Kƨ@A9n.@A9u@A9u@A9l@A9X@A9@A9D@A9o@A9>BZ@A9R@A9@A9s@A9s@A9@A9R@A9R@A9.H@A:Ov`@A:1'@A:䎊@A:1'@A:&IR@A:-V@A:)y@A:0U2a|@A::)y@A:GE85@A:W'@A:kP|@A:nO@A:qiC@A:qiC@A:qiC@A:nO@A:nO@A:qiC@A:~"@A:@4@A:p:@A:ݘ@A:wkQ@A:>B@A: ě@A:}Vm@A:͞&@A:ڹY@A:䎊q@A:C,@A:fB@A:c	@A;nP@A;s@A;&@A;,zxl@A;/V@A;,zxl@A;33333@A;J#9@A;MjO@A;eO@A;:)z@A;wk@A;q@A;6@A;@A;
=p@A;Q@A;lC@A<n.@A<@A<tj@A<!-w2@A<,<@A<,<@A<,<@A<(\@A<(\@A<9XbN@A<Fs@A<VϪ@A<cA \@A<q@A<q@A<~($x@A<?@A<qj@A<1&@A<Ʌoi@A<Z@A<hr@A<hr@A<e@A<E@A<>@A=V@A=%F
L@A=+a@A=%F
L@A=2a|@A=B@A=B@A=ce@A=m\@A=zxl"h@A=$/@A=zxl"h@A=zxl"h@A=w1@A=w1@A=ݗ@A=hr!@A==K@A=v@A=v@A=U=@A=U=@A=1@A=U=@A=U=@A=1@A=n/@A=8Y@A=cA @A=b@A=8YK@A=
qv@A=,=@A>t@A>?@A>BZc @A>L/{J@A>H@A>H@A>R<6@A>c	@A>l!-@A>s@A>p:~@A>@A>$t@A>,<@A>,<@A>af@A>@A>T@A>-@A>-@A>@A>A@A>Ϫ͟@A>C-@A>"@A?@A?
=p@A?Ft@A?Ft@A?,@A?!-w1@A?!-w1@A?+I@A?1@A?1@A?1@A?4֡a@A?O
M@A?KƧ@A?KƧ@A?O
M@A?U=@A?U=@A?Xe,@A?iDg8@A?iDg8@A?lC@A?lC@A?y@A?y@A?|hs@A?ݗ+@A?-V@A?&@A?&@A?zH@A?/V@A?vȴ9@A?/V@A?@A?K]d@A?حV@A?@A?rG@A?-@A?+j@A@	ԕ+@A@'RT`@A@>BZc@A@A7K@A@>BZc@A@K]c@A@K]c@A@K]c@A@H@A@Q@A@hۋq@A@˒:*@A@˒:*@A@|@A@@A@u%F@A@d8@A@9Xb@A@TɅ@A@ѷX@A@{@A@PH@AA$/@AArGE@AA_p@AA@AA [7@AA0
)@AA4J@AA4J@AA:S@AADg8~@AAQ@AA[W>6@AA[W>6@AA^@AAhr @AAk~(@AArGE8@AArGE8@AArGE8@AAu!S@AAb}@AA|Q@AA@AA@AA@AA'RTa@AA'RTa@AA(@AAn.@AA'R@AA@AA2W@AAD@AAD@AAy@AA_o@AA"`@AA"`@AA"`@AA>BZ@AA@AA-@AA-@AA.H@ABn@ABu%F@ABn@AB@AB#9@AB-V@AB-V@AB-V@AB0U2a|@AB3@AB:)y@AB=p
@ABJL@ABM@ABQ_@ABT`d@ABW'@ABa|Q@ABa|Q@ABu%F
@ABxl"h
@AB@4@ABL_@ABvȴ@ABL/{@AB@ABL/{@ABL/{@ABL/{@ABL/{@AB>B@AB ě@AB}Vm@ABW@ABsP@ABC,@ABm@ABm@AB~@ACI^@ACu%@ACs@AC	@AC"`B@AC	@AC"`B@AC,zxl@AC/V@AC9@ACF]c@ACJ#9@ACMjO@ACMjO@ACMjO@ACJ#9@ACMjO@ACP{@ACZ@ACn.3@ACqu!@ACtj~@AC~$@AC~$@AC{J#9@AC{J#9@AC$@ACߤ@ACwk@ACwk@AC*0U2@AC*0U2@ACq@AC@AC~($@ACƧ@AC҈@AC\N@ADL_@AD!-w2@ADQ@ADQ@ADtj@ADQ@AD!-w2@AD%1@AD(\@AD%1@AD,<@AD/{J#@AD64@ADC,zx@ADFs@ADI^5?@ADPH@ADZ1@AD`d@AD`d@ADcA \@ADg8}@ADg8}@ADtSM@ADwkP@ADo h@AD#@ADN;@AD3@AD3@ADTɆ@ADTɆ@AD@AD@ADj~@AD?@AD>B[@AD/@AD@AD/@ADZ@ADhr@ADD@ADhr@ADJM@ADJM@ADD@ADD@ADD@ADe@AD!-w@AD>@ADe@AD>@ADe@ADE@AE:@AEK]@AE:@AEK]@AEK]@AEu@AEu@AEV@AE5Xy>@AE84֡@AE<64@AE?|h@AE?|h@AEB@AEIQ@AEIQ@AEL_@AEY|@AE`A7L@AEfA@AEm\@AEsg@AEsg@AEw1@AEڹZ@AEhr!@AE!R@AE+j@AE+j@AE=K@AE=K@AE%@AE%@AEXy=@AE-V@AE1@AEH˒@AEH˒@AE\(@AE\(@AE@AE@AE@AEb@AES@AES@AE
qv@AEE@AE!.@AE!.@AE!.@AEC\@AEڹ@AEڹ@AF
(@AF4K@AFzG@AFu@AFu@AFu@AF!R<@AF!R<@AFOv_@AF.2@AF5?|@AF5?|@AF;5X@AF8YJ@AF?@AFE@AFL/{J@AFH@AFYJ@AF_ح@AFc	@AFfffff@AFfffff@AFvȴ9X@AF}Vl@AF}Vl@AFIQ@AF@AFO;@AF@AFaf@AFT@AF-@AF6z@AF2X@AFQ@AFQ@AFm\@AFϪ͟@AF+@AF]cf@AFC-@AFx@AF쿱[W@AF@AG@AG
=p@AG
M;@AG)^@AGXe@AG'/W@AG1@AG1@AG1@AG1@AG;dZ@AGRT`e@AGU=@AGb}V@AGeں@AGlC@AGo@AGlC@AGo@AGsPH@AGy@AG|hs@AG4m@AG{J#:@AGy@AG{J#:@AG	@AG	@AGO;d@AG	@AG@AG$tS@AGkP@AG	k@AG-V@AGzH@AGr@AG/V@AGvȴ9@AG/V@AG@AG+@AG+@AGحV@AG@AG;dZ@AGrG@AGVϫ@AG䎊r@AG-@AGrG@AGrG@AGrG@AGrGE9@AG#@AHF]d@AHbM@AH6@AH$xG@AH ě@AH1&x@AH73@AHD*@AH[6@AHeO@AHeO@AHeO@AHl"h	@AHoiDg8@AH@AH
=q@AHd8@AHU@AHU@AHU@AHTɅ@AHp:@AH)^@AHѷX@AH҈p@AH`A7@AH@AI ѷ@AI@N@AI@N@AI*0U2a@AI#w@AI#w@AI&x@AI4J@AI7KƧ@AI:S@AI=b@AIGz@AIJE@AIN;5@AIN;5@AIx@AIb}@AIb}@AIb}@AI@AIoiD@AIR<6@AI@AIl@AIn.@AIn.@AIl@AI'R@AIX@AI^5?}@AI^5?}@AI@AIN;6@AI_o@AIN;6@AIN;6@AIo@AI^5?}@AIᰉ'@AIe@AIᰉ'@AIe@AI>BZ@AI>BZ@AI>BZ@AIR@AI@AIY}@AIY}@AJu%F@AI.H@AJu%F@AJn@AJ	 @AJ	 @AJn@AJ	 @AJs@AJe+@AJ&IR@AJ)y@AJ)y@AJ&IR@AJ)y@AJ0U2a|@AJ:)y@AJJL@AJJL@AJJL@AJT`d@AJZc@AJ^5?|@AJa|Q@AJqiC@AJu%F
@AJu%F
@AJ{m@AJ@4@AJ@4@AJp:@AJL_@AJL_@AJ\(@AJᰊ@AJ0
@AJwkQ@AJ0
@AJ0
@AJvȴ@AJS&@AJL/{@AJ>B@AJg	@AJ}Vm@AJ ě@AJ@AJg	@AJY@AJ@AJ)_@AJ)_@AJ`A@AJW@AJ,<@AJsP@AJڹY@AJ ѷ@AJڹY@AJG{@AJ䎊q@AJC,@AJC,@AJC,@AJfB@AJc	@AJ74@AJm\@AKS&@AKS&@AKu%@AKS&@AKI^@AK҉@AK҉@AKnP@AKs@AKC,z@AKC,z@AK	@AK"`B@AK&@AK)^	@AK&@AK,zxl@AK9@AK@N@AKC%@AKC%@AKJ#9@AKS@AK]cA@AKW>6z@AKZ@AKn.3@AKn.3@AKn.3@AKn.3@AKtj~@AKtj~@AKxF]@AKxF]@AK@AKQ@AKq@AKMj@AK:)z@AK$@AKA@AKA@AKߤ@AKߤ@AKU=@AKwk@AKwk                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @r@r@r@rfffff@r@rfffff@r33333@r     @r     @r@r@r33333@r     @r33333@r@r     @rfffff@r33333@r33333@r@rfffff@r@r     @r@r33333@r33333@rfffff@r@rfffff@r33333@rfffff@rfffff@r     @r     @rə@r33333@rfffff@r     @r     @r33333@r     @s33333@s	@s33333@sfffff@sfffff@sfffff@s@sfffff@s9@sL@s\@sk33333@si@sT@rfffff@r33333@r     @r33333@s33333@s33333@s(     @s1@s1@r@r33333@r@r@r     @rٙ@r33333@r@r33333@rə@r     @rљ@r@r33333@r33333@r     @rfffff@r     @r33333@r     @r33333@r33333@r@r33333@r33333@r33333@r@r@r@r     @r     @rK33333@r.fffff@r33333@q     @q@q@q33333@qfffff@q@q     @q@q񙙙@pfffff@p@p33333@py@pt@p~fffff@pfffff@pᙙ@p33333@oy@o      @n     @n33333@nP     @n@mfffff@m@m0     @m@lfffff@k@k@j     @jffffff@j)@i@iFfffff@hٙ@h33333@hp     @h333333@g@g33333@g     @gI@g     @ffffff@f\@fVfffff@f     @f@ffffff@g0     @e33333@e      @e33333@e     @e)@eI@ey@e@efffff@dp     @dffffff@dc33333@d\@dS33333@dP     @dL@d@     @d<@d9@d33333@c     @c@c@c@c33333@c33333@c33333@c@cl@cS33333@c9@c#33333@c33333@c     @c	@c33333@b@b@b@b     @b     @b33333@b33333@bfffff@bfffff@bfffff@b@b@bə@b@b@b     @b@bfffff@b@bfffff@b@b     @b@b@b&fffff@b&fffff@b&fffff@b&fffff@b#33333@b@b     @b@b33333@a@a@afffff@afffff@a     @a@afffff@a33333@a@afffff@a33333@a@a@a@a33333@`fffff@`33333@`fffff@`33333@`33333@`     @a      @a,@`33333@`33333@`|@`|@`|@`@`     @`@`@_@_ffffff@_L@_`     @_@_fffff@_@^Ffffff@^33333@]33333@]ٙ@]@]     @]@]y@]Y@]@     @]      @]333333@]l@]9@\@\@\fffff@\@\@\33333@\fffff@\@[@[     @[33333@[     @[@[     @[fffff@[@[@[fffff@[Ffffff@[      @Z@Z@Z     @ZS33333@Z&fffff@Yfffff@Y33333@YL@Y&fffff@Y@Yfffff@Xfffff@X@X@XL@X      @X@X33333@X,@X9@X&fffff@Wffffff@W9@W      @W      @V@V33333@V@Vfffff@Vs33333@Vffffff@VS33333@V333333@V@Ufffff@Ufffff@U@U@U@U     @U@U333333@U@U@U33333@U33333@U&fffff@U,@U,@T     @T@T@Tfffff@Tffffff@T`     @TS33333@T@     @T333333@T@Sfffff@S33333@S     @Sl@Sffffff@SS33333@SFfffff@SS33333@Ss33333@Sy@S      @S      @R@R@R@S33333@S@Rfffff@RS33333@RFfffff@R9@R9@R,@R33333@R33333@R@R33333@R      @Qfffff@Qٙ@Q@Qfffff@Q@Qfffff@Qfffff@Q@Qffffff@QS33333@Q9@Q&fffff@Q&fffff@Q9@QFfffff@QL@Q@     @P@Pfffff@Pfffff@P@P@P33333@P     @Ps33333@PY@PS33333@PL@P,@P@P@Offfff@Offfff@O@O@O     @OY@OL@OL@O@     @O333333@N     @M33333@Ms33333@Mffffff@M@Mfffff@M     @M@M@L33333@L     @Lfffff@L     @LL@L&fffff@K33333@K33333@K@K@Kfffff@K     @K&fffff@Js33333@J333333@J@J@I33333@Iٙ@Iٙ@I     @I33333@I@I@IY@I333333@Hfffff@H@H@Hfffff@Hs33333@H&fffff@Gٙ@G@Gs33333@Gs33333@GL@G&fffff@G      @F@F33333@F@Fffffff@F@     @F&fffff@F333333@F@F&fffff@F      @E@Efffff@Efffff@Effffff@D33333@D     @D     @D     @Dٙ@D33333@E      @Dffffff@D333333@D@D      @D@D      @D@C33333@C33333@C@Cffffff@CL@CL@CL@CL@CY@CY@Cs33333@CY@C      @Bfffff@B@B     @B@B@B     @B     @Bfffff@BY@B@B      @A33333@A33333@B@B@A33333@Afffff@As33333@Affffff@Affffff@AY@AY@A@     @A@@fffff@@ٙ@@     @@33333@@fffff@@@@s33333@@L@@@     @@@?fffff@?fffff@@      @@@@&fffff@@&fffff@?L@?333333@?@?@?      @>fffff@>fffff@>@>@>33333@>@>@>33333@>33333@>@>      @>      @>      @>333333@>      @>333333@>L@>L@>L@=L@=333333@<fffff@<@<fffff@=      @=333333@=L@<      @;fffff@;     @;L@;333333@;@;      @;@;333333@;333333@:     @:L@:333333@:333333@:L@:     @:@:@:@:      @9fffff@9fffff@:@:      @:@933333@9@9@9ffffff@9ffffff@9     @9     @9ffffff@9ffffff@9ffffff@9ffffff@9L@9L@9L@9333333@9      @8fffff@833333@8     @8L@8      @7fffff@733333@733333@7@7fffff@7@6fffff@633333@6@6@6@6@6     @6L@5@5fffff@5@533333@5@5@5ffffff@5333333@5@5@4fffff@5L@5@5@5@5      @433333@4     @4L@4      @3@3@3@3@3@3@3@3@3      @2fffff@2fffff@2@233333@2@2@2@2@2L@2L@2333333@2L@2333333@2@2@2@2333333@2333333@133333@1     @1@1@133333@1@1ffffff@1L@1ffffff@1333333@1      @0fffff@0@0fffff@0fffff@0fffff@0@0@0@0ffffff@0ffffff@0L@0333333@0@0@0@/@/@/@/@/@/@0      @0@0L@0333333@0ffffff@0L@0L@0L@0L@0@0@0@0@0      @0@.      @-ffffff@-@-@.333333@.ffffff@.333333@-333333@-333333@-333333@-      @-      @-333333@-333333@-333333@,ffffff@,333333@,333333@,333333@,333333@,ffffff@,333333@,      @,ffffff@,ffffff@,      @,      @,      @+@,      @+@+@+@+ffffff@+ffffff@+@+ffffff@+      @+333333@+333333@+      @+      @+      @+333333@+      @*@*@*@*@*ffffff@*@*@*ffffff@*ffffff@*333333@*333333@*333333@)@)@*      @*      @)@*      @*      @*      @*      @)ffffff@)@)@)ffffff@)@)@)@)ffffff@)      @)      @)333333@)333333@)333333@)333333@)333333@)333333@)333333@)333333@(@)333333@)333333@)      @(@(@(@(@(ffffff@(@(ffffff@(@(@(ffffff@(ffffff@(ffffff@(333333@(333333@(ffffff@(333333@(ffffff@(333333@(333333@(333333@(      @(333333@(      @(333333@(      @(333333@(333333@(      @(      @(      @(      @'@(      @'@'@'@(      @(      @(      @'@'ffffff@'@'ffffff@'@'@'ffffff@'@'@'ffffff@'@'ffffff@'333333@'ffffff@'ffffff@'ffffff@'ffffff@'ffffff@'@'@'@'@'@'@'@'@'@'@'@'@'ffffff@'333333@'@'@'@'ffffff@'ffffff@'ffffff@'ffffff@'333333@'ffffff@'@'ffffff@'@'@'ffffff@'ffffff@'333333@'333333@'ffffff@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'ffffff@'      @'ffffff@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'      @'333333@'      @'      @'333333@'333333@'333333@'      @'333333@'ffffff@'ffffff@'333333@'333333@'ffffff@'ffffff@'333333@'ffffff@'333333@'@'ffffff@'333333@'ffffff@'333333@'@'333333@'333333@'ffffff@'333333@'333333@'ffffff@'333333@'333333@'333333@'333333@'333333@'      @&@&@&@&@&@&@'      @'      @&@&@&@&@&@&@'      @'      @'333333@'333333@'      @'ffffff@'      @'333333@'333333@'333333@'      @'333333@'333333@'333333@'333333@'      @'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'ffffff@'      @'333333@'333333@'333333@'333333@'333333@'      @'333333@'      @&@&@&@&@&@&@&@&@&@&@&@&@'      @&@'      @'      @'333333@'      @&@'333333@'      @'333333@'      @'333333@'333333@'333333@'333333@'ffffff@'333333@'333333@'333333@'      @'333333@'333333@'333333@'333333@'333333@'333333@'ffffff@'333333@'ffffff@'ffffff@'333333@'ffffff@'ffffff@'333333@'333333@'@'ffffff@'ffffff@'ffffff@'@'ffffff@'@'@'@'ffffff@'@'@'@'@(      @'@'@'@(      @'@'@'@'@'@(      @'@(      @(333333@(      @'@(ffffff@(333333@(333333@(333333@(333333@(ffffff@(333333@(333333@(@(333333@(ffffff@(ffffff@(@(@(ffffff@(ffffff@(@(@(@(@(@)333333@)      @(@)      @)      @)      @)333333@)      @)      @)333333@)333333@)333333@(@(@)333333@)ffffff@)ffffff@)333333@)333333@)ffffff@)ffffff@)@)333333@)ffffff@)@)@)@)@)@)ffffff@*      @)@*      @*333333@)@*      @*      @*333333@*333333@*333333@*@*ffffff@*@*333333@*ffffff@*@*ffffff@*ffffff@*@*@*@*@+      @*@*@+333333@+      @+ffffff@+333333@+333333@+ffffff@+333333@+@+333333@+ffffff@+ffffff@+333333@+@+@+@+@+@+@+@+@+@+@+@+@+@+@+@,      @,333333@,      @,333333@,333333@,ffffff@,333333@,ffffff@,ffffff@,ffffff@,@,@-      @,@-      @-333333@-ffffff@-@-ffffff@-333333@-ffffff@-@-@-@-@-@-@-@-@-@-@.      @-@.333333@.333333@.333333@-@-@.ffffff@.ffffff@.333333@.ffffff@.@.@.@.@.@.@.@.@/      @.@/      @.@/      @/333333@/      @/333333@/333333@/333333@/333333@/ffffff@/ffffff@/ffffff@/ffffff@/@/333333@/@/@/@/@/@/@/@/@/@0      @0@0      @0333333@0333333@0@0@0333333@0333333@0L@0ffffff@0ffffff@0ffffff@0     @0@0     @0ffffff@0     @0fffff@1@1@1333333@1      @1      @1      @1@1@1@1@1@1@1@1@1@1     @1     @1@1@1fffff@2      @2      @1@133333@133333      @2@233333@2@2@2ffffff@2ffffff@2     @2@3@2@2@2fffff@3@2fffff@2fffff@3L@3     @3L@3333333@3333333@3333333@3L@3L@3ffffff@3@3@3@333333@333333@3@3@3@3@3@3fffff@3fffff@3fffff@3fffff@3fffff@4333333@4ffffff@4L@4@3fffff@4     @433333@4fffff@4@4@4@4@4@4fffff@5      @5      @5333333@5333333@5@5333333@5@5      @5ffffff@5     @5     @5     @533333@5@5@5ffffff@5ffffff@5fffff@5fffff@6@6      @6      @6@5fffff@5fffff@6333333@6L@6L@6333333@6L@6L@6333333@6@6     @6L@6@6@6     @6@6@6fffff@7      @7@6fffff@6fffff@7333333@7@7      @7L@7333333@7L@7ffffff@7@7@7@7fffff@7@7fffff@733333@8      @8@8333333@8L@8L@8     @8     @8L@8L@9      @8fffff@9@9L@9333333@9      @8fffff@9@9     @9@9fffff@9@9fffff@:      @:@9fffff@:@:333333@:333333@:      @:333333@:ffffff@:L@:ffffff@:     @:@:     @:     @:ffffff@:     @;      @:@:@;@;      @:@:@;333333@;@:fffff@;@;L@;L@;333333@;L@;ffffff@;@;@;@;33333@;@;@;33333@;@<      @<@<@<@<@<ffffff@<333333@<333333@<ffffff@<L@<@<     @<     @<     @<@<@=      @<@<@<@=333333@=@=333333@=     @=333333@=333333@=@=L@=ffffff@=     @=@=@=fffff@=@=@=@>@>333333@>L@>L@>L@>ffffff@>@>     @>     @>ffffff@>@>@>@>fffff@>@>@>fffff@>@?333333@?      @?@?ffffff@?L@?333333@?333333@?L@?     @?@?33333@?@?@?33333@?@?fffff@?@@@@@     @@Y@@     @@     @@@@     @@@@s33333@@@@@@@@@@@@33333@@fffff@@33333@@     @@     @@ٙ@@@@fffff@@33333@@33333@@33333@A      @A      @A@A@A@A&fffff@A@     @A@     @A@     @AL@AY@Affffff@AY@Affffff@AY@A@A@A@A33333@A@A33333@A@A33333@A33333@Afffff@A33333@A33333@A33333@A33333@A     @A33333@A     @A33333@A33333@A     @A     @A@Aٙ@Aٙ@Aٙ@Afffff@Aٙ@A     @B@B@B@B@B@B&fffff@B333333@B333333@B&fffff@B333333@BL@BY@Bffffff@Bs33333@B     @B     @Bs33333@BY@B@B@B@B@B33333@B@B33333@B33333@B33333@B33333@Bٙ@Bٙ@Bfffff@Bfffff@B33333@Bfffff@C      @C@C@B33333@C      @C@C@C333333@C@     @C333333@C@C&fffff@C@     @CL@CY@CY@CY@Cs33333@Cs33333@Cs33333@Cs33333@Cs33333@C@C@C@C@Cfffff@Cfffff@C@C@C@C     @C     @Cfffff@D@C33333@Cٙ@C33333@D&fffff@D@D@D&fffff@D333333@D@     @D&fffff@D333333@DL@Dffffff@Dffffff@D     @D@D@D@Dfffff@Dfffff@D@D@Dٙ@Dٙ@E      @E@E@E      @D33333@E@E333333@E@EL@EL@EY@Effffff@Es33333@Effffff@Es33333@Es33333@E     @E@E@E@E@E@E@Efffff@Efffff@E@E@Efffff@E33333@E33333@E     @E@E     @Efffff@Eٙ@F      @Efffff@E33333@F@F@F&fffff@F@F&fffff@F333333@F333333@F@     @F@     @F@     @F@     @FL@FL@Fffffff@Fs33333@F     @F@F@F@Fs33333@Fٙ@F33333@F33333@G      @G@G@G@G@G@G@G@G     @G     @G@Gffffff@Gٙ@G33333@Gٙ@H      @G33333@G33333@H@H@     @HY@Hs33333@Hs33333@H@Hs33333@H333333@H     @Hfffff@H     @H33333@Hfffff@Hfffff@Hfffff@Hfffff@Hfffff@I      @I@Hfffff@I@IL@IL@I&fffff@I333333@I333333@IY@IY@IY@Iffffff@Is33333@IY@Is33333@I@I@I@Ifffff@I     @I     @Ifffff@I33333@I     @Iٙ@I@I     @I     @I     @I@Ifffff@Iٙ@Iٙ@I33333@I33333@J      @J      @I33333@J@J@J&fffff@J333333@J&fffff@J@J&fffff@J@     @J@     @Jffffff@Jffffff@Js33333@Js33333@Js33333@J     @Jfffff@Jfffff@J     @J     @J     @Jfffff@Jٙ@Jfffff@J33333@Jfffff@Jfffff@Jfffff@J33333@K&fffff@K@K      @K      @K@K@K&fffff@K333333@K&fffff@K333333@K333333@K@     @K@KL@KY@KL@Ks33333@Kffffff@Kffffff@KY@Ks33333@K     @K@K@K@K@K33333@Kfffff@Kfffff@K     @Kfffff@Kfffff@K@K@Kٙ@Kٙ@K@K     @K     @K@Kfffff@L      @L      @L@L@L      @L333333@L@L      @L&fffff@L@     @L333333@LL@LL@Ls33333@Lffffff@Ls33333@Ls33333@Lffffff@L@     @L@Lfffff@L@Lfffff@L     @L     @L     @L@Lfffff@L@L33333@L33333@Lfffff@L33333@M      @Lfffff@L@M@M&fffff@M&fffff@M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ?\(?`A7L?7KƧ?333333?Gz?Q?KƧ?
=p
?hr ?Gz?/v?`A7?&x?^5?|?|hr?      ?E?=p
=?vȴ9X?nO?nO?hr ?m?=p
=?vȴ9X?I^5?\(\?tj?9XbM?5?|h?;dZ?O;d?xF?/w@ Vu@ 
=p@ +@ "`@ ȴ9Xb@M@
=p@9XbM@bM@zG@1&y@GzH@`A7L@	Ƨ-@	hr @	lC@I^5?@Vt@/w@$/@	tj@Q@M@lC@Vt@1&x@$/?+?nO?Q?I^5?}?1&?+?nO;?~"?7KƧ?7KƧ?-?`A7L?E?-V?hr Ĝ?"`B?lC?tj~?nP?lD?5?|h?|hr?+I?O;dZ?n?
=p?hr Ĝ?+I^?lC?^5?|?ۥS?ۅQ?(\)?j~"?xF?hr Ĝ?׍O;dZ?+?ӕ$/?I^5??333333?nO;?7KƧ?xF?I^5?=p
=?+J?p
=q?n?͑hr ?͑hr ?vȴ?+?;dZ?vȴ9X?̋C%?/v?dZ1?I^5?lC?hr!?Ƨ-?Gz?+J?QR?E?-V?`A7?nO;?l?S?9XbM?Z1'?nO?`A7?`A7L?      ?`A7L?
=p?M?nO;?7KƧ?A7Kƨ?nP?&x?tj?|hr?|hr?7KƧ?ěS?1&y?1&y?-V?-V?7KƧ?p
=q?;dZ?E?`A7K?;dZ?E?A7Kƨ?/v?E?A7Kƨ?5?|h?bM?;dZ?
=p?bM?1&y?|hr?;dZ?(\)?|hr?vȴ9X? ěT?n?vȴ9X?lD?vȴ9X?hr Ĝ?ěS?I^5??;dZ?&x?Q?nP?ěS?`A7L?
=p?      ? ěT?Q?$/?M?vȴ9X?nP?;dZ?
=p?7KƧ?vȴ9X?bM?A7Kƨ?$/?GzH?`A7L?-V?Q?E?nO;?5?|h?^5?|?333333?&x? ěT?/v?;dZ?S?Q?&x?n?-V?&x?Q?5?|h?\(?hr!?-V?7KƧ?A7Kƨ?A7Kƨ?`A7L?GzH?
=p?vȴ9X?;dZ?hr Ĝ?l?GzH?-V?A7Kƨ?|hr?Q?zG{?lD?&x?7KƧ?n?ěS?ěS?° ě?\(?lD?lD?-V?S?I^5??
=p?`A7?$/?tj?I^5??Q?
=p?lD?`A7L?nP?-V?/w?Q?nP?nO;?`A7L?M?bM?`A7L?A7Kƨ?ěS?
=p?vȴ9X?M?n?GzH?S?ěS?bM?GzH?ěS?7KƧ?\(?`A7?Q?-V?
=p?333333?l?M?GzH?nO;?tj~?bM?`A7L?\(?lD?
=p?A7Kƨ?nO;?GzH?-V?GzH?333333?GzH?Q?`A7K?7KƧ?hr Ĝ?\(?ěS?nO;?
=p?7KƧ?I^5??-V?$/?-V?nO;?&x?lD?&x?`A7L?333333?hr Ĝ?7KƧ?nO;?\(?;dZ?hr Ĝ?A7Kƨ?\(?-V?ěS?Q?zG{?l?tj~?9XbM?
=p?M?Q?7KƧ?nO;?tj?A7Kƨ?nO;?Z1'?\(?M?/w?Q?-V?M?+?E?+?A7Kƨ?Q?nO;?° ě?;dZ?hr Ĝ?l?M?° ě?M?lD?\(?l?GzH?+?nO;?nO?zG{?`A7?\(?`A7?S?Õ$/?7KƧ?lD?nP?tj~?° ě?I^5??-V?-V?I^5??l? ěT? ěT?
=p?nO;?hr Ĝ?tj?° ě?nO;?333333?Q?`A7L?M?-V?ěS?öE?hr Ĝ?M?7KƧ?S?ļj~#?`A7?n?S?l?I^5??\(?7KƧ?
=p?hr Ĝ?zG{?ěS?Z1'?I^5??-V?-V?nO;?GzH?M?7KƧ?nO;?l?n?hr!?bM?nO;?-V?&x?333333?tj?lD?-V?7KƧ?333333?bM?M?333333?M?n?Q?333333?n?nO?nO?
=p?° ě?\(?-V?Q?&x?&x?l?° ě?\(?`A7?I^5??tj~?lD?I^5??l?\(?-V?S?\(?S?`A7?Q?|hr?GzH?-V?+?lD?I^5??n?$/?9XbM?`A7?tj~?lD?l?
=p?Q?`A7?I^5??ěS?      ?A7Kƨ?bM?7KƧ?Õ$/?7KƧ?hr Ĝ?šo?
=p?S?333333?-V?+?Q?`A7L?I^5??nO;?
=p?\(?-V?`A7L?1&y?`A7?`A7L?lD?° ě?nO;?lD?333333?Q?nO;?-V?I^5??
=p?zG{?`A7?333333?/w?nO?S?Q?/v?
=p?lD?tj~?-V?-V?+?nO?° ě?-V?`A7?Q?nO?9XbM?\(?-V?333333?° ě?333333?ěS?öE?öE?nO?-V?7KƧ?öE?n?7KƧ?-V?&x?"`?l?9XbM?nO;?bM?M?GzH?-V?
=p?bM?Q?öE?I^5??7KƧ?$/?Z1'?Q?tj~?nP?7KƧ?ěS?ěS?hr Ĝ?333333?-V?n?ěS?\(?I^5??`A7K?öE?Õ$/?7KƧ?M?° ě?n?tj~?zG{?$/?n?\(?l?nO?l?9XbM?E?I^5??&x?M?° ě?ěS?nO?Q?Q?\(?bM?lD?Q?° ě?Z1'?l?+?7KƧ?l?\(?`A7?° ě?l?Ł$/?nP?zG{?7KƧ?nO;?-V?Õ$/?I^5??tj?° ě?GzH?nO?/w?333333?öE?I^5??M?GzH?I^5??Õ$/?l?tj~?Z1'?M?nO?-V?lD?
=p?Q?`A7K?9XbM?nO;?`A7?l?\(?GzH?bM?-V?nO?I^5??öE?GzH?ěS?nO;?M?I^5??l?-V?nO;?+?hr Ĝ?333333?öE?Õ$/?
=p?M?-V?° ě?S?n?-V?Õ$/?° ě?-V?nO?° ě?° ě?l?7KƧ?333333?GzH?-V?nO;?S?I^5??333333?\(?öE?333333?7KƧ?`A7?öE?n?° ě?333333?ěS?
=p?+?Õ$/?tj?-V?zG{?+?`A7?S?Q?`A7L?nO?
=p?GzH?`A7?
=p?n?E?+?bM?
=p?-V?tj~?tj~?Z1'?-V?/w?° ě?nO;?$/?-V?tj~?Õ$/?n?tj?&x?
=p?ěS?nO?M?nO;?nO;?nO;?E?tj?ffffff?`A7L?Q??|hs?nO?lD?A7Kƨ?öE?S?nO?tj~?Q?+?-V?Õ$/?/w?I^5??333333?öE?l?tj?Q?hr Ĝ?ěS?l?9XbM?öE?nP?+?9XbM?-V?vȴ9X?Q?tj?tj~?
=p?° ě?nO;?lD?`A7?öE?lD?\(?`A7?hr Ĝ?n?Z1'?Q?nO;?° ě?7KƧ?`A7?nO;?nO;?ěS?Q?öE?Q?S?Q?M?Q?l?n?\(?lD?
=p?\(?Õ$/?I^5??\(?`A7?Q?M?ļj~#?l?Õ$/?öE?öE?/w?° ě?333333?\(?Q?bM?A7Kƨ?      ?333333?Z1'?&x?nO;?`A7?`A7?l?Q?bM?nO?$/?7KƧ?ļj~#?tj?`A7?Q?nO;?Õ$/?° ě?333333?S?I^5??tj~?n?Õ$/?lD?l?`A7?Q??|hs?tj?333333?S?hr Ĝ?zG{?n?7KƧ?S?nO;?l?333333?n?-V?Z1'?öE?l?Q?+?
=p
?Ł$/?S?nO?nO? ěT?I^5??\(?ļj~#?9XbM?tj?M?M?° ě?nO?l?9XbM?° ě?\(?öE?
=p?333333?+?öE?Q?zG{?nO?lD?hr Ĝ?tj~?n?n?hr Ĝ?hr Ĝ?l?`A7L?E?\(?E?333333?ěS?M?bM?333333?S?Q?tj~?n?hr Ĝ?ěS?\(?tj~?
=p?333333?-V?nP?\(?tj~?S?-V?
=p?° ě?`A7?nO;?9XbM?S?\(?E?
=p?hr Ĝ?ěS?n?&x?nO;?hr Ĝ?nO?`A7?° ě?öE?Õ$/?nO?M?S?\(?tj~?öE?zG{?7KƧ?333333?333333?tj~?I^5??
=p?Z1'?+?l?333333?öE??|hs?333333?A7Kƨ?Q?Q?tj~?I^5??333333?M?I^5??9XbM?° ě?ļj~#?nO?`A7?l?ěS? ěT?Q?+?ěS?tj?\(?333333?9XbM?333333?öE?M?\(?nO;?9XbM?S?M?tj?nO?M?ěS?
=p?\(?nO?E?bM?nO;?
=p?nO;?I^5??-V?9XbM?S?9XbM?tj~?n?nO;?tj~?lD?+?tj?ěS?\(?9XbM?tj~?-V?nO;?zG{?tj?° ě?Z1'?E?bM?333333?Õ$/?333333?9XbM?tj?Õ$/?S?Z1'?Õ$/?GzH?7KƧ?S?\(?ěS?\(?7KƧ?7KƧ?öE?Õ$/?I^5??Z1'?I^5??lD?-V?7KƧ?`A7?Õ$/?-V?lD?° ě?Õ$/?l?tj~?`A7?° ě?ěS?&x?tj~?nO?$/?7KƧ?\(?nO?
=p?Z1'?öE?l?E?9XbM?nO;?
=p?l?-V?tj~?9XbM?l?Õ$/?ěS?-V?I^5??\(?S?Z1'?Ł$/?l?nO;?nO?nO;?l?333333?7KƧ?l?öE?`A7?333333?n?-V?GzH?° ě?\(?Õ$/?nO;?° ě?Õ$/?Q?Q?`A7?M?Z1'?E?nO?Ł$/?öE?E?E?\(?l?7KƧ?+?zG{?° ě?7KƧ?GzH?&x?/w?nO?ļj~#?n?9XbM?n?GzH?Õ$/?+?nO?I^5??Q?\(?333333?
=p?tj~?šo?`A7?333333?nO?n?
=p?Z1'?tj~?S?Q?$/?Q?`A7?S? ěT?lD?M?nO;?° ě?nO?`A7L?\(?nO;?9XbM?9XbM?\(?M?+?-V?nO;?Z1'?-V?Õ$/?\(?`A7?M?Ł$/?+?S?-V?/w?7KƧ?° ě?`A7?lD?M?Õ$/?nO;?\(?hr Ĝ?l?7KƧ?`A7?Õ$/?nO;?-V?Õ$/?E?+?l?n?tj~?nO;?I^5??\(?`A7?I^5??
=p?Q?\(?M?I^5??tj~?n?tj~?-V?-V?`A7L?`A7?Q?M?öE?n?tj?° ě?Õ$/?bM?tj~?7KƧ?° ě?I^5??
=p?l?-V?Õ$/?Q?n?\(?|hr?nO;?-V?nO?I^5??l?hr Ĝ?I^5??\(?Q?nO?-V?
=p?\(?M?-V?-V?° ě?7KƧ?-V?öE?vȴ9X?/v?nO?lD?n?-V?333333?n?M??|hs?öE?Q?bM?7KƧ?E?Q?tj?tj~?&x?tj?+?l?I^5??l?nO;?333333?&x?lD?öE?333333?nO;?`A7?° ě?nO?\(?7KƧ?&x?|hr?333333?-V?I^5??-V?lD?-V?ěS?7KƧ?nP?n?/w?E?`A7? ěT?nO?Q?-V?nO?+?ļj~#?l?nP?ěS?7KƧ?nO?n?
=p?Z1'?nO?öE?nP?$/?9XbM?° ě?+?\(?I^5??I^5??-V?-V?tj?bM?-V?`A7L?-V?9XbM?\(?I^5??GzH?ļj~#?\(?`A7?hr Ĝ?lD?-V?öE?l?nP?A7Kƨ?nO;?l?° ě?
=p?° ě?nP?\(?-V?Q?333333?n?7KƧ?`A7K?tj?l?l?333333?7KƧ?-V?-V?&x?&x?Q?nO? ěT?`A7?nO;?nO;?n?n?
=p?A7Kƨ?nO?Q?nP?333333?hr Ĝ?nP?$/?nP?$/?lD?bM?+?Q?tj~?n?-V?GzH?-V?GzH?hr Ĝ?M?333333?tj~?hr Ĝ?`A7?9XbM?-V?M?nO;?-V?n?l?-V?A7Kƨ?I^5??nO;?tj?`A7?M?° ě?
=p?bM?`A7L?5?|h?S?`A7?nP?° ě?ěS?lD?hr Ĝ?I^5??-V?öE?tj~?
=p?-V?n?I^5??hr Ĝ?\(?9XbM?
=p?333333?° ě?
=p?° ě?I^5??-V?I^5??hr Ĝ?&x?-V?n?Q?Õ$/?M?I^5??n?-V?hr Ĝ?Õ$/?`A7L?GzH?n?S?ěS?333333?° ě?I^5??333333?hr Ĝ?S?nP?;dZ?&x?
=p?lD?nO;?7KƧ?nP?$/?I^5??-V?tj~?`A7L?tj~?° ě?9XbM?$/?nO;?nO?I^5??
=p?I^5??I^5??A7Kƨ?hr!?A7Kƨ?$/?Q? ěT?$/?nP?
=p?&x?ěS?&x?n?öE?`A7L?`A7?Q?lD?-V?° ě?° ě?`A7?+?tj~?-V?hr Ĝ?lD?M?\(?\(?M?
=p?nO;?`A7L?\(?Õ$/?nO?lD?GzH?`A7?nO;?tj~?lD?I^5??hr Ĝ?lD?ěS?S?hr!?A7Kƨ?\(?l?-V?A7Kƨ?;dZ?l?&x?`A7L?333333?nO?-V?hr Ĝ?\(?I^5??$/?vȴ9X?-V?ěS?`A7?$/?5?|h?      ?Q?nP?° ě?l?`A7L?I^5??ěS?lD?lD?M?ļj~#?&x?Q?-V?`A7L?&x?      ?n?S?Q?n?lD?-V?&x?$/?I^5??Q?nP?I^5??GzH?nO?9XbM?-V?l?&x?`A7L?ěS?I^5??bM?n?nO;?|hr?j~"?GzH?-V?\(?nP?I^5??lD?hr Ĝ??|hs?$/?l?ěS?nO;?M?bM?&x?-V?M?I^5??`A7L?-V?7KƧ?Q?7KƧ?7KƧ?I^5??-V?ěS?Z1'?nO;?° ě?ěS?A7Kƨ?bM?hr Ĝ?(\)?I^5??zG{?\(?Q?333333?GzH?-V?\(?hr Ĝ?&x?/v?5?|h?nP?lD?
=p?hr Ĝ?
=p?-V?n?\(?n?nO?nO;?nO;?nP?A7Kƨ?hr Ĝ?-V?-V?n?nO;?\(?1&y?$/?n?M?hr Ĝ?&x?Õ$/?-V?7KƧ?lD?n?
=p?&x?lD?I^5??&x?333333?|hr?bM?      ?-V?7KƧ?
=p?-V?-V?`A7L?`A7L?GzH?`A7L?      ?ěS?hr Ĝ?vȴ9X?lD?M?lD?lD?ěS?\(?hr Ĝ?hr Ĝ?-V?&x?E?7KƧ?9XbM?l?&x?tj~?7KƧ?\(?nP?vȴ9X?l?;dZ?      ?      ?      ?M?bM?n?"`?nO?-V?$/?      ?"`?GzH?bM?A7Kƨ?Q?n?hr Ĝ?7KƧ?-V?`A7L?      ?l?Q?S?A7Kƨ?Q?A7Kƨ?`A7L?\(?"`? ěT?A7Kƨ? ěT?
=p?-V?-V?-V?`A7L?$/?\(?nP?-V?-V?M?
=p?nO;?9XbM?° ě?j~"?E?$/?Q?nO;?7KƧ?|hr?$/?bM?A7Kƨ?&x?Q? ěT? ěT?n?&x?ěS?$/?bM?$/?nO;?GzH?Q?$/?ěS?-V?M?nP?`A7?E?n?lD?° ě?5?|h?`A7L?bM?vȴ9X?ěS?`A7L?$/?A7Kƨ?7KƧ?tj?GzH?7KƧ?;dZ?vȴ9X?
=p?`A7L? ěT?hr Ĝ?`A7L?1&y?Q?;dZ?Õ$/?lD?`A7L?^5?|?vȴ9X?nO;?nO;?333333?&x?A7Kƨ?\(?hr Ĝ?nO?&x?lD?lD?vȴ9X?7KƧ?|hr?lD?$/?hr Ĝ?-V?-V?nP?A7Kƨ?hr Ĝ?S?vȴ9X?Õ$/?hr Ĝ?n?n?7KƧ?      ?-V?`A7?
=p?-V?lD?
=p?
=p?
=p?nP?|hr?7KƧ?&x?
=p?A7Kƨ? ěT?-V?
=p?&x?Q?j~"?n?GzH?I^5??-V?Q?$/?I^5??nO?n? ěT?lD?A7Kƨ?-V?hr Ĝ?
=p?5?|h?A7Kƨ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@M     @M     @Ms33333@M     @Mffffff@M     @ML@M      @M     @M@     @M@M     @M     @M@M     @Ms33333@Ms33333@MY@Ms33333@MY@Mffffff@M&fffff@M@M333333@M@     @ML@Mffffff@MY@M@     @ML@MY@MY@MY@MY@Ms33333@Ms33333@Ms33333@Ms33333@M     @M     @M     @M@M@Ms33333@M@     @M@M@M@M      @L33333@M      @ML@M@M33333@M33333@Mٙ@Mfffff@N      @Nffffff@Ns33333@NL@N@Nٙ@O      @O@     @Offffff@Os33333@OY@O@Oٙ@O33333@P33333@P@P      @P&fffff@P&fffff@P,@P,@P&fffff@P,@P333333@P@     @PFfffff@PFfffff@PL@PL@PL@PL@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PS33333@PY@P`     @P`     @P`     @P`     @PY@Pffffff@Pffffff@Pffffff@Pffffff@Pffffff@Pffffff@Pffffff@Pl@Ps33333@Ps33333@Ps33333@Py@Py@Pl@Pl@Py@Py@Py@Py@P     @P     @Pfffff@P     @Pfffff@Pfffff@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@Pfffff@Pfffff@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P@P@P@P@P@P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P@P@P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@Pٙ@P33333@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @Pٙ@P     @P     @P     @P     @P     @Pٙ@P     @P     @Pٙ@P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@Pfffff@P@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P@P33333@P@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P33333@P@P@P33333@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P     @Pfffff@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@Pfffff@P@P@P33333@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P     @P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P33333@P@P33333@P@P@P@P@P33333@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@Q      @P@Q      @P@P@Q      @P@P@Q      @Q      @P@Q      @Q      @Q      @P@P@P@Q      @Q      @Q      @Q      @Q      @P@P@P@P@P@Q      @Q      @P@P@P@P@P@P@Q      @Q      @Q      @P@P@Q      @P@Q      @P@Q      @P@P@P@P@P@Q      @P@P@P@Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@Q      @Q      @P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P14                                     1                                       GBD~S3?