CDF       
      pressure     time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20120522   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P10    CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:47.989623Z    ORIGINAL_HEADER      sCTD,20250210CCHSIOWB
#Renamed 'CTDFLUOR_TSG' to 'CTDFLUOR_ALT_1' with units 'MG/M^3'
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2018-11-29. CTD data from cruise 18DD20120522, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20120522. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2012-12/index.php. 
#
# The information in this file for the cruise 2012-12 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2012-12/donneesctddata/2012-12-0072.ctd
#
# Start of originator file comment header
#
#*2018/11/29 14:22:51.16
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2012/06/01 08:02:46.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 2006
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : C44EDC1F
#    NUMBER OF CHANNELS  : 9
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            2.3            2006.7
#       2 Temperature:CTD               deg_C_(ITS90)   1.9166         6.6907
#       3 Salinity:CTD                  PSS-78          32.6639        34.5892
#       4 Sigma-t:CTD                   kg/m^3          25.6458        27.6748
#       5 Transmissivity:CTD            %/m             61.4           67.9
#       6 Oxygen:Dissolved:CTD:Volume   ml/l            0.41           7.23
#       7 Oxygen:Dissolved:CTD:Mass     µmol/kg         17.9           314.7
#       8 Fluorescence:CTD:Seapoint     mg/m^3          0.24E-01       0.74
#       9 Fluorescence:CTD:Wetlabs      mg/m^3          0.102          1.096
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        6  F       ' '     1
#       6  -99   ' '        7  F       ' '     2
#       7  -99   ' '        6  F       ' '     1
#       8  -99   ' '        8  F       ' '     3
#       9  -99   ' '        8  F       ' '     3
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2012-12
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P24
#    EVENT NUMBER        : 72
#    LATITUDE            :  49  50.17000 N  ! (deg min)
#    LONGITUDE           : 142  40.04000 W  ! (deg min)
#    WATER DEPTH         : 3989
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    CTDEDIT was used to remove surface records and records corrupted by shed
#	wakes; salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Transmissivity, Fluorescence and PAR data are nominal and unedited except
#	that some records were removed in editing temperature and salinity.
#
#    For details on how the transmissivity calibration parameters were calculated
#	see the document Transmissivity_Calculation.pdf.
#
#    The Oxygen:Dissolved:CTD calibration was done using the method described in 
#	the Sea-Bird Application Note #64-2 (Sea-Bird_64-2_Jun2012.pdf).
#
#    The Oxygen:Dissolved:CTD data are considered, roughly, to be:
#	±0.1 ml/l from 0 to 125 dbar.
#	±0.06 ml/l from 125 to 500 dbar.
#	±0.04 ml/l from 500 to 2000 dbar.
#	±0.02 ml/l below 2000 dbar.
#
#    For details on the processing see processing report: 2012-12-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5-- --6--- --7-- ---8--- ---9---
#!Pressu Temperat Salinity Sigma-t: Trans Oxygen Oxyge Fluores Fluores
#!re:CTD ure:CTD  :CTD     CTD      missi :Disso n:Dis cence:  cence: 
#!                                  vity: lved:  solve CTD:    CTD:   
#!                                  CTD   CTD:   d:CTD Seapoin Wetlabs
#!                                        Volume :Mass t              
#!------ -------- -------- -------- ----- ------ ----- ------- -------
#*END OF HEADER
    WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @9         data_max      @9         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     >  .    pressure                	long_name         pressure   positive      down   units         decibar    data_min      @ffffff   data_max      @Z   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      >  l   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d        `   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?6C   data_max      @"xU   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       >     temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d           salinity                	long_name         salinity   units         PSS-78     data_min      @@S,zxl   data_max      @AKm]   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      > 	P   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d       G   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @#333333   data_max      @r   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        > W   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d       8   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?QR   data_max      @\(\   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      >    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d          PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       > (   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d       2   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min      @M        data_max      @P   C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     > Bp   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d          station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      	   data_max      	   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @HrX/D   data_max      @HrX/D   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      `5RC   data_max      `5RC   C_format      %9.4f             	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d           	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @9      @ffffff@@      @      @       @!@$      @&      @'@*333333@,@.      @0      @1      @133333@3      @4      @5      @6      @7      @8@8fffff@9fffff@;      @<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N      @N     @O      @O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R     @S      @S@     @Sy@S     @T      @T@     @T     @T     @U      @U@     @U     @U     @Vfffff@V9@V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Yfffff@Y@Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\@     @\     @\     @]      @]@     @]     @]     @^      @^Ffffff@^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b33333@b@b<@b`     @b     @b     @b33333@b     @b@c      @c@     @c`     @c33333@c     @c@c     @d      @d      @dC33333@dc33333@d|@d     @d     @d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g      @g@     @g`     @g     @g@g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i     @j      @j      @j@     @j`     @j     @j     @j     @j     @k      @k      @k@     @k`     @k     @k     @k     @k     @l      @l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @mc33333@m     @m     @m     @m     @n      @n      @nC33333@n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q~fffff@q     @q     @q     @q     @q     @qᙙ@q     @r      @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @s     @s     @s     @s     @t      @t     @t      @t0     @t@     @tP     @t`     @tp     @t     @t     @t     @t     @t     @t     @t     @t     @u      @u     @u      @u0     @u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @vfffff@v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @w     @w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x`     @xp     @x     @x     @x     @x     @x@x     @x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{     @{      @{1@{@     @{P     @{`     @{p     @{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|      @|.fffff@|C33333@|P     @|`     @|p     @|     @|     @|     @|     @|     @|љ@|33333@|     @}      @}     @}!@}1@}@     @}P     @}`     @}p     @}     @}     @}     @}     @}     @}     @}ᙙ@}     @~      @~     @~      @~0     @~@     @~P     @~`     @~p     @~     @~     @~     @~     @~     @~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @     @񙙙@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x@33333@     @     @     @     @@@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @/33333@8     @@     @H     @P@X@_33333@h     @p     @x     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H@O33333@X     @`     @h     @p     @x     @     @     @@     @@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8@<     @H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @fffff@ə@     @     @     @     @     @@      @     @     @     @      @(     @1@8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @?33333@Jfffff@P     @X     @`     @h     @p     @vfffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @@33333@     @     @     @     @     @     @     @     @     @     @     @33333@     @     @      @     @     @     @      @$@0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @      @(     @0     @8     @@@Jfffff@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @33333@      @     @     @     @@(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @@33333@      @(     @0     @8     @<@H@P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @@fffff@     @     @     @     @     @@33333@     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @@33333@     @     @     @     @@33333@     @     @     @     @@     @      @     @     @@33333@(     @0     @8     @<@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @@33333@      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @hfffff@k@p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @fffff@33333@     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(fffff@,@0     @4     @8     @<     @@     @D     @H     @Lfffff@O@T     @X     @\     @`fffff@d     @h     @l     @p     @t     @x     @|     @     @     @     @     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @˙@     @     @     @     @33333@㙙@     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @Dfffff@G@L     @P     @T     @X     @\     @`     @dfffff@g@l     @p     @t     @x     @|     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @י@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @'33333@+@0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @fffff@@     @     @     @     @     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @33333@ߙ@     @     @fffff@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<fffff@?@D     @H     @L     @P     @T     @X     @\     @`     @dfffff@ffffff@lfffff@p     @t     @x     @|fffff@     @     @     @     @     @     @     @fffff@     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @fffff@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @c@h     @l     @p     @t     @x     @|     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @fffff@     @      @     @     @     @     @     @     @     @      @"@'@,     @0     @4     @8fffff@<     @@     @D     @H     @L     @P     @T     @X     @\fffff@`fffff@d     @h     @l     @p     @t     @x     @|     @fffff@@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4@8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`fffff@d     @g@l     @p     @t     @x     @|fffff@@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @fffff@Ù@     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @O@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @fffff@     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @@˙@     @     @     @     @     @     @     @     @     @     @     @fffff@      @     @     @fffff@     @     @     @     @      @$     @(     @,     @.@4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @fffff@@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @@     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4fffff@8     @<     @@     @D     @H     @Lfffff@O@S@X     @\     @_33333@e@h     @k@o@t     @x     @|     @     @     @     @     @     @     @fffff@@     @     @     @     @33333@fffff@     @     @     @     @     @͙@     @     @     @     @     @     @癙@홙@@     @     @     @ fffff@@     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @w@|     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @fffff@@     @     @     @     @     @     @@!@#@(     @,     @0     @4     @7@>     @@     @D     @H     @K@Q33333@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @     @@fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @˙@     @     @fffff@     @     @     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @ fffff@"fffff@)33333@,     @0     @4     @8     @<     @?33333@D@H     @L     @P     @T     @X     @Zfffff@a33333@d     @h     @l     @p     @r@xfffff@|     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @fffff@     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @2@8fffff@<     @@     @D     @Hfffff@L     @P     @T     @X     @\     @`     @c@h     @l     @p     @t     @w@}@     @     @     @     @     @@@     @     @     @     @fffff@@     @     @     @     @     @     @     @љ@     @     @     @     @     @     @     @     @fffff@@     @      @     @@
@     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @?@D     @H     @L     @P     @T     @X     @Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @"xtj@"xU@"xYJ@"x73@"w+j@"u!.@"u'0@"usg@"tɅoi@"t3@"t*1@"t`d@"u*0@"s*0U2@"qo@"qu@"p*0U@"or@"n+@"m
qv@"mB@"iB@"i@"ka@@"kC,z@"jڹY@"i ѷ@"g+I@"f$/@"aTɅo@"Z)y@"W&@"M\@"Ezxl"h@"8D*@"0:~ @")rGE@"!n.@"ݗ+k@"*0@!?@!_p@!R@!	k~(@ r Ĝ@ 6_ح@ a@N@ᰉ@~ߤ?@@d7@s@m(@,[W?@zxl"h@0U2a|@E@5Xy>@s@ql@^u@Y_o@Y@OrGE9@:>B@+@73@U=@7@ݲ-V@R@p:@"`@u!S@ᰉ'@N;@e+a@2W@p ě@a|Q@U$/@C{J#9@2W@,"h	ԕ@%@Ft@)^@b@9XbN@H@"@!.H@S&@	k~@xF@vȴ9@q@D*@L_@8YJ@u"@lD@
qv@
qv@(@\@-V@-@-V@:~ @[W>6@MjO@kP@E@'/@y=c@b@I7KƧ@ۋq@҈p;@A@`[6@o4֡a@yD@jOv@JE@d8@IQ@(@:@-w1@7@zxl"@PH@nP@S&@hr @4J@N;5@N;6@T`d@m@zG@*1@҉@`A7@qi@
n@@@9Xb@@K]@-@U=@8}H@
=p@-w1@䎊r@A7K@e@,<@RT`e@S@@$xG@D@<64@eں@{m@GE85@a|Q@-@Xy=@҈p;@@?@h	ԕ@ݘ@n@:@z)_@[qu!@Kq@/@_o@C%@oiDg@H˒@C-@y@-
@ܬ1&@JE@ԕ*1@
L/@#@ ѷY@u@&IR@sg@`ěT@L@:@|@@H˒@C\@Xy=@2a|@Xy=@	k@2a|@@n@l"h	ԕ@A@*JL@
L/@b@64@dZ@!.I@sPH@lC@A [@|@-@m\@`[6@U$/@>m\@2ᰊ@ [6@L_@p:~@o h@	ԕ+@@R@As@ʦL/{@p:@ȴ9X@n.3@-
q@]cf@hۋq@z)y@weں@s@nO;@]-V@Y0
)@WO;d@5\(@J#9@jf@h	ԕ@_F@hr @ȴ9Xb@ [7@~@{m@&@2a|@@X*0@0:~ @6C@n.@v@>@K]c@*0@:S@m8@c	@\)@[6@U@Z@rGE9@@^ ѷY@TO
M@;lC@҈p;@=K@:)y@Ƨ@	7KƧ@7Kƨ@Y}@_ح@v@@D*@zG@s@74@$tS@($x@dZ@hr!@af@As@|#x@s33333@jd7@c	@O'/W@4!-w2@"C,@fA@@
M;@:)z@	oiD@ [7@MjO@ۋq@ɺ^5?}@$tS@{m@'@h	ԕ@a@O@T`d@zH@kC]@j~"@d/@V@Fs@1[W>6@8YJ@;5X@?@v@ڹY@Ov_@͞%@@)@\(@[W>6@^@҈p@@/{J#@Fs@tSMj@h\)@h>BZc@eu@M:@;~$@*fB@#9@sPH@Z@qi@	@@@˒:)@Y}@\(@o@U=@`A7L@ce@Ձ$/@sP@҈p:@nO@=p
@@@Q@_ح@t@@@4@'RT`@-
@u!@u!@'RT`@PH@jOv@[W>@q&x@l>B[@jd7@gfA@fx@fIQ@bC,@Zvȴ@Ush@Q4J@E8YK@:)_@6}Vl@3MjO@,>B[@'&@?@qu!@_o@@@_F@=K@)^@	'RTa@@~$@-
@C-@!-w2@C\@y@rGE@Z1@u@ce@Q@"`B@qu!@ٳ|@8YJ@bM@̘_@qiC@,zxl@Vl!@A@xl"h
@+@䎊q@lD@	k@l!-@*0U2@:)y@X@\(@@:)z@9Xb@@ѷX@~vȴ9X@|j~#@{/V@zC\@wkP@v}Vl@v_ح@v4K@u!.@v_ح@v_ح@vz@sMjO@pU2a|@mhr!@ka@@mw1@kC]@fL/{J@eF
L0@cA [@_حV@T`d@SZ@QN;5@L@G#@D*0@DM:@DM:@C@>BZc @<64@6z@3PH@1-@1A [@.O;@*0U2a|@'@҈p;@b}@
=p@Ϫ͟@@Ϫ͟@@af@Ov_@*0@
M;@!R<@
@eO@@:S@j~#@n.@s@}Vl@%F
L@3@MjO@&x@t@H@C\@q@思IQ@h	ԕ@ۋq@fA@`d@ө*0U2@ҽ<64@v_ح@Ƨ@˒:*@s@ï@     @m]@(@#w@}H@}H@}H@4m@A [@%F
L@!.I@ѷX@ěS@Țu%F@Ƨ@'/@n@W'@=p
@ȴ9Xb@cA \@bM@ңS&@L_@Ov_@>6z@e+a@ٙ@0
)@_F@+j@@8YJ@յsh@յsh@յsh@՛=K@E@@a@O@m@R@|@+@͞%@@#@'/@L_@/{J#@)^	@ ѷ@E84@Ňݗ@@&IR@o hی@$/@n@hۋq@.H@)y@)y@ᰊ@Ov`@M@'RT`@d8@@4@/@h	ԕ@حV@C,zx@*0@@u@*0U@D@_o@&I@m\@JM@_o@x4֡b@iDg8~@f,<@dqj@dZ1@_حV@]}H@Ao hی@9~($@3PH@,>B[@'RT`e@%ڹ@%F
L0@$?@#9@!Gz@حV@Q@ce@C,zx@ߤ@@q@$/@*0U2@`A7@_p@p:~@	k~(@E84@ 4m9@xl"h
@%1@;dZ@[W>@
(@1@84֡@C\@m\@!.H@4֡a@@	ԕ+@"`B@Q@*0@@n.@BZc @˒:)z@*0@Õ$@s@C@,zxl@@4m@A@}Vl@/V@?|h@dZ@^5?|@A@n.@Z@Xy=@zxl"@͞&@IQ@n.3@ěT@,<@O;d@O
M@$tT@rGE9@-
q@@'RTa@$/@n/@S&@o h@$/@~\N<@}Vl!@}!.H@}H˒@}ڹZ@|hr@|#x@zxl"h
@vȴ9X@u!R@p@g@ae@bM@d%1@cS@]+j@[q@ZY@["`B@XU@QX@L/{J#@>BZc @*d7@ [6@u%F@U=@#
=p@%S@%1@$tSM@ 	k@	@U=@쿱[W@wkP@O;d@$/@O
M@O
M@L_@L_@O
M@@ݗ+k@@N@N;6@rGE9@~($x@	7KƧ@F]c@F]d@fA@	@҈p@bM@&@Ϫ͞@+@5Xy>@]cA@n@ʌL_@?@[W>6@xF@ae@*0@	 @qiC@u%F@	 @1&x@@|Q@v_ح@jJL@e+a@aGz@Z1'@QX@K:)z@GE84@?[W>@9#w@7Xe@-w1@+I^@(Xy=@%S@!ae@6C@$tT@1&x@
MjO@
B@
fA@
As@
p:~@
jOv@
ɅoiD@
)^@
NU@
a|Q@
ߤ@@
Z@
ݗ+k@
zG@
sh@
@
Z@
&I@
o hی@
{J#9@
sg@
oiDg8@
\N;@
Vaf@
U=K@
U2a|@
U=K@
U=K@
TɅoi@
M@
GE84@
?@
2W@
(@
#S&@
Q@
*0@
@
ݗ+k@
)^@
'/W@

M:@
q@
	7KƧ@
M:@F@\@~"@>BZc@1.@+a@A [@W>6z@ӎMj@jOv@͞%@jOv@Q@@@s@m\@4m@9XbN@o@1@
qv@>B[@<쿱@1&y@lD@Xy=@IQ@-
@	@쿱[W@Ov_خ@sh@Mj@q@L_@@'/@_o@ݗ@?@tj@ ѷ@}E@y=b@weں@sg@sMjO@qu!S@qiB@qu!S@qA [@o4֡a@mC\@hr Ĝ@\(\@N_o @I^5?}@H@H9Xb@E84֡@?@73@6E@6z@7KƧ@6C-@6}Vl@74m@8Q@:)_@8}H@9~($@9~($@6C-@333333@&L/{J@"`A@%@=K^@zG@$tT@p:@m\@A [@g	@+a@@N@&@v_ح@̘_@E84@6z@XbM@4m@m8@{@U=@&@F
L0@3@Q@wkP@=K^@,<@vȴ@@$/@҉@sP@sP@nO@!R<@qiC@p:@oiDg@@$/@˒:)@}ڹZ@z@s@p:~ @m\@e@[6@UϪ͞@P|@JW'@GzH@DS@8}H@/v@'&@$TɆ@!ae@Ov_خ@C,zx@S@u%@u%F@PH@+j@Xe,@Ov_@
qu"@n.@
Q@
eں@
@
Z@

qu@
6@
ٳ|@
ۋq@
1'@
"`B@
c	@
c	@
c	@
ڹY@
+@
Ϫ͞@
N;5@
Ϫ͞@
@
Ƨ@
ȴ9Xb@
쿱[@
I^@
tSM@
R<6@
[6@
-V@
,<@
@@
O
M@
rGE9@
C%@
#@
$/@
{J#9@
nP@
o hی@
zG{@
ceO@
Q_p@
M@
O;dZ@
P`A7@
P*0U@
QN;5@
T,<@
M5Xy>@
E8YK@
IoiD@
C,zxl@
:)y@
2a|Q@
1o@
#@
#@
@
n@
L_@
K]d@
+I@
$/@
ݗ@
Q@
M:@
u%F
@	H˒@	J#9@	xl"h
@	73@	!.@	{m@	fB@	Gz@	ٳ|@	fA@	R@	@	E84@	NU@	64@	~($@	YJ@	֡a@	 ě@	0U2a|@	'RT`@	C,zx@	*0U2@	~($x@	qu!S@	ceO@	Vl!-@	Rp:@	K)^	@	>
(@	;5Xy@	0{@	#9@	e+a@	ᰉ@	nO@	
qiC@	 IQ@#@@C,z@r Ĝ@ⶮ}Vm@Ϫ͞@˒:)z@vȴ9X@֡a@jf@TɆ@u"@N;6@M:@xF]@#@YJ@&I@&I@I^5@$tS@}!.H@xF]d@tj~@p:~ @jJL@g@`
qu@Z1'@Vt@UfA@T`d@MjOv@GE84@C$@@4m@<Z@;5Xy@=b@;/V@;dZ@;5Xy@;A@<n.@:S&@6E@.}Vl@$/@U=@%@wkP@u%F@$tS@:)y@Mj@1&x@n/@@rGE8@l@oiDg8@4֡a@쿱[W?@fB@ڹ@A [@d8@cA @Q_@fA@,<@҈p:@v_ح@̘_@Ƨ@@2W@TɅo@sg@U=@&@'RT`@1&@Ov_@n@nO@n@(@xF]@qiC@p:@p:@#@oiDg@tj@F]c@@x73@sg@sPH@iB@["`B@V8YJ@Rp:@JL_@I^5?}@F?@@n@=p
=@-V@	@u@e+a@Ov_@*0@Ov_@@҉@bM@\(@qi@I^5?@
ڹY@&I@$tS@PH@rGE8@E@8Y@唯O
@fA@]cA@ȴ9Xb@s@a@N@7Kƨ@ [7@K]@XbM@4֡b@Q@&x@.H@,=@PH@zG@*0U2@)^@@(@K]d@@~"@xF]d@u!.@u!R@q@lC@bM@]+j@\]ce@Xe+@VϪ͟@SZ@Np:~@IoiD@>6z@:)_@8Q@7Xe@6C-@6}Vl@4֡a@3ߤ@2W@1[W>6@%S@!.H@%@@$tS@$/@tj~@\(@ݗ@Vl!@F]d@ȴ9X@+jg@!-w2@{m@O;@빌~($@C,z@P{@빌~($@Q@fB@fffff@	@$@JE@2a|@;5X@ěS@TɅo@6z@ߤ?@BZc @b@H˒:@Q@{@U2a|@O
M@r@{J#:@2X@w1@u@S@vȴ@O;d@@nO@:)y@ߤ?@M:@@@~($x@L_@'/@Q@%2@{J#9@F]c@nP@ ѷ@n.@}Vl!@xF@v+jg@r{m@m\@jg	@e@e`A7L@dZ1@ae@\]ce@XU@SZ@QX@N+@F?@BZc@@NU@?@5?@)lD@"`A@ 	k@Ov_خ@PH@$tS@'/W@~($x@xF]@	 ѷ@Fs@nP@Vl!@_ح@ᰉ'@1.@@C,@M@u!@]ce@څݘ@fA@*0U@˒:)z@@@
L/@*0@*0@74@C@NU@@6z@Z@~@XbM@?@\)@
=p@S@R<6@Fs@ݗ+k@nO@@eO@@4n@~m\@}E@}Vl!@z>B@xl"h	@v+jg@sE@q@poiDg8@lVϪ@h@eڹ@b@4@_o@[6@YJE@WsPH@VϪ͟@Vaf@R<64@I@H9Xb@H˒:*@H9Xb@H˒:*@F-@E84֡@>vȴ9X@;A@73@-
qv@Ov_خ@_F@Vu@.H@#@iDg8@C@A@e+@ߤ?@҈p;@iB@5?|@5?|@5?|@ ѷY@>@c	@E@т@H@;dZ@+@;5X@_o @@͞%@:@̘_@cA \@/{J#@s@s@s@#9@]cf@m\@84֡@TɅo@64@/V@~($@Xe@1&y@?@R<6@ߤ@@Ov_@O
M@Z@ᰉ@@@Q@1&@}H@IQ@kP|@Xe,@O
M@o @=p
@k~(@ԕ*@JM@{lC@tSMj@nO;@n.2@m(@lVϪ@kQ@jg	@hr Ĝ@fA@eڹ@bC,@^ ѷY@TɅoi@MjOv@D2W@<쿱[@=p
=@;5Xy@;/V@;dZ@;dZ@9D@73@6z@5Xy=@0 ě@+a@@"`A@kP|@Ov_@)^@!R<@~($x@q@
=p
@	k~(@	ԕ*@.H@F]d@4֡a@Dg8~@,<@ᰉ'R@u!@ce@ٳ|@т@:@s@s@5Xy>@5Xy>@@@̘_@˒:)z@ʌL_@@E84@@YJ@3@)@XbM@Y}@)_@~($@4m@Xy=@ߤ@-@'RT@
qv@*0U2a@F
L0@%@=K^@tj@@@N@qu"@@҈@L/{@p:@#@p:@=p
@=p
@'/@@qu"@@	 @#@oiDg@?@%2@IQ@~"@}!.H@yrGE8@vFs@vFs@u!R@nc	@jJL@h	ԕ+@glC@e`A7L@d7@cS@\>@Vt@RT`d@P|@MjOv@L/{J#@K]cA@IQ@HK]c@GE84@D*0@>vȴ9X@:)_@49XbN@7Xe@6}Vl@)y@Q@6C@@@*0@@Q@ ѷX@kP@@@JL@	k@@4@A7K@حV@o@ݗ+j@ܑN;@D*@ѷX@H@p:~@@n@n@ʌL_@)^	@#9@@Ƨ-@Ƨ-@a@N@TɅo@H˒:@ߤ?@ߤ?@64@XbM@)@}Vl@?|h@3@m8@m8@o@0U2a|@'@F
L0@xF@[6@-V@S@u%F@0
)@+J@tj~@@o h@F]c@     @wkP@v+jg@u%F
L@s@o hۋ@l[W?@mhr!@l[W?@kP{@kC,z@kP{@kP{@jg	@jJL@iDg8~@h	ԕ+@h	ԕ+@g	k@g	k@g	k@glC@eڹ@e+a@cZ@bC,@be+@["`B@O;dZ@JL_@H˒:*@GzH@HK]c@H9Xb@F]cf@E84֡@D*0@Ca@N@As@>ߤ?@;/V@6E@4m8@4֡a@5'0@5sg@64K@6E@43@1-@1&x@/O
M@+6z@-V@+j@+J@sh@L_@-
q@@҈@C%@'/@
ڹY@	 ѷ@n/@%2@ IQ@ H˒@ hr@ G{@ F@ F]d@ D@ s@ C\@ C]@ Ov`@ @ Z1@ ᰉ'R@ ҈p@ A7K@ 
qu@ ߤ?@ iB@ $@ @ ՛=K@ Ʌoi@ Ϫ͞@ t@ l!-@ >6z@ 
=p@ t@ ՛=K@ As@ ͞%@ ̘_@ cA \@ cA \@ /{J#@ Ƨ@ D@ n@ #9@ @ ˒:*@ ǮzH@ ]cf@ 
L/@ š@ *0@ \N@ Õ$@ @ ěS@ @ )y@ C-@ J@ W@ U2a|@ zxl"@ 0U2a|@ y@ *0U2a@ /V@ RT`e@ RT`e@ '@ h	ԕ@ [6@ !-w1@ IQ@ u"@ @ @@ _F@ Xe,@ *0U2@ n@ $tT@ @ _o@ M:@ :S@ .H@ ~m\@ }H˒@ |?@ wkP@ uY|@ uY|@ rGE85@ o4֡a@ mhr!@ j~"@ e@ dZ1@ cZ@ cS@ ae@ a@N@ aGz@ _?@ \?@ XbM@ TE@ T,<@ S&@ NT@ MjOv@ L@ L@ M:@ Ks@ K]cA@ Jn@ JW'@ F]cf@ B@ A@ >ߤ?@ <쿱[@ ;dZ@ 9D@ 7Xe@ 4J@ /r@ .1@ /r@ /v@ -B@ )*0U2a@ #wk@ !o@ !-w1@  	k@  -
@ ߤ@@ u%@ u%@ O;d@ sh@ ݗ+k@ *0U2@ ݗ+k@ @N@ hr @ 
(@ ~($x@ 
qiC@ '/@ xF]@ '/@ 
ڹY@ 
ڹY@ 
L/{@ 	 ѷ@ $/@  ѷ@  4m9?"`?E?{m?쿱[W??@4??fA?fA?E?ԕ*1?*0U??)^	???K]c?K]c?m\?\(?&IR?6?6?ߤ??j~#?Q?sg?9XbN?g	l?ᰊ?'RT?'RT? ě?{?}Vl?1?}Vl?>B[?Xy=?L/{J?'?S?S?
=p?wkQ?'RT`?wkP?Fs?S&?qi?qiC?$/?u!R?tj~?u%F
L?u%F
L?tSMj?s?r ě?r ě?n.2?jfB?cA [?`d8?_o?\N;?U=K?S&?M?L_?M:?KƧ?KƧ?JD?I^5?}?H?E84֡?@NU?:S&?9D?9XbM?73?6C-?6z?2W?2W?2W?1&x?-w1?&x?$xF?#wk?"`A?[?6C                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @@S,zxl@@S33333@@S6z@@S9@@S9@@SP{@@SS@@SS@@SW>6z@@SZ@@S]cA@@SdZ@@S]cA@@Stj~@@SxF]@@SxF]@@SQ@@SMj@@S$@@S:)z@@SU=@@Sq@@S@@Swk@@Sq@@SE@@SƧ@@S@@S
=p@@SA [@@TQ@@T"h	ԕ@@TI^5?@@Tg8}@@TS@@T_@@T쿱[@@TTɆ@@T/@@T>@@U(@@Uw1@@U@@ViB@@VϪ͟@@VOv_@@U,=@@V@@WXe@@Wb}V@@Weں@@W.H@@W8}H@@WU=@@W{J#:@@W&@@W͞@@W;dZ@@X}H@@Xhۋq@@X@@XIQ@@XIQ@@XěT@@X	k@@Y$/@@Y@@Y@@Y4J@@YTɅo@@Yk~(@@Yu!S@@Yb}@@Yx@@Y~($@@Y(@@Y|@@Yᰉ'@@Y>BZ@@Zs@@Z3@@Z^5?|@@ZqiC@@Zxl"h
@@Z{m@@Z0
@@[u%@@[/V@@[=K^@@[wk@@[$@@\tj@@\I^5?@@\C@@]sg@@]8Y@@]E@@^!R<@@^l!-@@^,<@@_@@bh	ԕ@@dߤ@@@dFs@@dM:@@d*0@@esg@@f4K@@f+J@@fFs@@f@@gH˒:@@h:~ @@ie@@m`A7L@@p˒:*@@sg	l@@y*0U2a@@m\@@sPH@@*1@@-
q@@)^	@@YJ@@ݘ@@zG@@^@@j~#@@@@@N@@oiDg@@YJ@@|@@>B@@쿱[W@@m\@@'0@@^5?}@@&IR@@ݘ@@Üߤ@@įO
M@@ńM:@@;dZ@@rG@@	k@@d7@@˜ߤ@@֡a@@?@@iDg8@@*0U2a@@C%@@lC@@D@@Ov_خ@@׷r@@ěT@@@N@@ق@@&IR@@҈@@2a|@@C\@@ޱ2X@@)^@@ߍO;d@@rGE8@@N;6@@.H@@s@@s@@0U2a|@@kP|@@xl"h
@@'/@@~($x@@+@@薻@@k~(@@)y@@m@@:)z@@a@O@@g8}@@>@@L_@@sg@@퇓ݗ@@픯O
@@-V@@n/@@H˒@@b@@C\@@;5X@@l!-@@ȴ9X@@+@@C-@@"@@!-w1@@'/W@@b}V@@iDg8@@_o@@Xe,@@\(@@iDg8@@&@@	k@@y@@eں@@U=@@O
M@@iDg8@@|hs@@ﴢ3@@͞@@ݗ+@@@@$tS@@-V@@/V@@ﴢ3@@@@@@@@@-@@-@@#@@䎊r@@䎊r@@F]d@@*0U@@*0U@@1&x@@A7K@@'RT`@@6@@'RT`@@*0@@*0@@H@@Q@@[6@@Xy=@@Xy=@@U2a|@@[6@@eO@@hۋq@@u!@@eO@@l"h	@@d8@@TɅ@@
=q@@d8@@4m@@
(@@
(@@9Xb@@
(@@p:@@C@@\)@@@@@@@4֡b@@e+@@ۋq
@@ۋq
@@e+@@)@@
=q@@𭫟U@@{@@4m@@)@@TɅ@@9Xb@@d8@@d8@@@@@e+@@e+@@rGE@@@@$tT@@$tT@@$/@@ ѷ@@ ѷ@@	k@@$tT@@ ѷ@@rGE@@$/@@$/@@ [7@@_p@@+@@rGE@@+@@4J@@-w1@@0
)@@=b@@e+a@@|Q@@|Q@@b}@@TɅo@@rGE8@@@@@@e+@@W'@@d7@@@4@@\(@@0
@@\(@@Y@@W@@,<@@c	@@~@@m@@S&@@ ѷ@@ ѷ@@c	@@m\@@I^@@74@@c	@@	@@J#9@@6z@@'/@@S&@@~@@I^@@D@@m@@74@@҉@@a@N@@jf@@tj~@@~$@@$@@$@@:)z@@S@@A [@@Q@@SMj@@zG@@zxl"@@@@>B[@@e@@u@@%F
L@@+a@@84֡@@IQ@@m\@@+j@@@@oiDg@@!.@@!.@@ڹ@@?@@YJ@@\N<@@m\@@Ϫ͟@@"@@Ft@@$tS@@>6z@@As@@H˒:@@H˒:@@RT`e@@sPH@@[W>@@73@@4m9@@D*@@K]c@@[6@@eO@@oiDg8@@IQ@@D@@C@@ ѷ@@XbM@@'RTa@@^5?}@@"`@@.H@@)y@@d7@@@4@@\(@@0
@@wkQ@@g	@@䎊q@@"`B@@qu!@@~($@@\N@@<쿱@@?@@D@@Q@@/w@@O;dZ@@$/@@$/@@ݗ@@=K@@sh@@cA @@oiDg@@zG@@?@@H@@Vu@@Fs@@m\@@m\@@m\@@]cf@@>6z@@?@A F]d@A  ě@A 'RT`@A $xG@A [6@A |@A @A U@A e+@A $tT@A#w@AQ@ArGE8@Ab}@Al@A@A_o@Aԕ*@Aᰉ'@As@A.H@A:)y@AS&@A}Vm@A}Vm@AW@A䎊q@A'/@AF]c@AMjO@AMjO@Atj~@Ag@A\N@A!-w2@A?@Am8@Aqj@AS@AO
M@A*0@AZ@A@A@Ahr@A!-w@Ae@AV@AB@AY|@A1@AE@A!R<@A$/@A($x@A($x@A.2@A8YJ@AL/{J@Ac	@A2X@A&I@AϪ͟@AFt@A+I@A>6z@AO
M@ART`e@AiDg8@A	k@A͞@A[W>@A/V@A@A-@A-@A+j@AbM@A4m9@ANU@Atj@A)^@AF@Aۋq
@A`A7@A		k~@A	:S@A	ae@A	|Q@A	n.@A	@A
-V@A
nO@A
ݘ@A
vȴ@A
@A
fB@A)^	@An.3@A@A҈@A/{J#@Aq@A3@A
%F
L@A
2a|@A
84֡@A
5Xy>@A
B@A
ce@A
@A
L/@A;5X@A$t@A@A&I@A'/W@ART`e@AzH@AحV@A@A@A6@A ě@A ě@A ě@A$xG@A4m9@ANU@A[6@Ar Ĝ@A@Ad8@AěT@AD@A_p@A^@AX@A@A"`@AI^5@A6C@AJL@AM@AT`d@AZc@AZc@Ad7@Axl"h
@Aݘ@A ě@A͞&@AfB@Am\@Am@AnP@AP{@AZ@Aq@A|@AL_@A2W@APH@AtSM@A?@A쿱[@A3@A1&@A@ATɆ@A?@AZ@A:@AV@Ao i@AK]@A'0@Au@A[@Au@Ao i@A:@Aqu"@A/w@AB@AB@AF
L0@AIQ@AL_@AO;dZ@AVl!@A`A7L@AjOv@AjOv@Ap
=@A$/@A@AU=@An/@AcA @A
qv@AS@A(@Aڹ@A!.@A.2@ABZc @A1.@A$/@A_ح@Aȴ9X@Aeں@AK]c@AH@AD*@A>BZc@A:~ @ANU@AbM@AbM@Ahۋq@AeO@Al"h	@A4m@A	k~@A@A#w@A*0U2a@A=b@AJE@AA [@ADg8~@A4J@AN;5@Aԕ*@A@A䎊@A3@A:)y@AC\@Ad7@Ah	ԕ@Ap:@A>B@A<64@An@AڹY@Am\@A҉@A33333@A=K^@AF]c@AZ@A{J#9@A:)z@AMj@AU=@A*0U2@Aa@O@A|@AQ@AQ@A%2@A%2@Ag@AA [@AxF@A2W@A64@ASMj@Aj~#@A_@ATɆ@AO
M@A֡a@A:@Aqu"@AB@Ace@AڹZ@AH˒@AϪ͞@A?@A8YK@A?@AoiDg@A\N<@A+J@AT@AQ@A҈p;@AFs@A hۋ@A!.I@A@A
M;@A@A,@A$tS@A+I@A1@A1@A4֡a@A4֡a@A8}H@A;dZ@AH˒:@AKƧ@AXe,@AXe,@AsPH@A&@Avȴ9@A@AK]d@A@@A䎊r@A#@A *0U@A :~ @A hۋq@A y=c@A ˒:*@A IQ@A U@A 9Xb@A {@A TɅ@A ѷX@A ۋq
@A ҈p@A {@A!+@A!@N@A!&x@A!:S@A!Q@A!TɅo@A![W>6@A!k~(@A!@A!u@A!|@A!l@A!B@A!ᰉ'@A"n@A"1'@A")y@A"@4n@A"Zc@A"u%F
@A"S&@A">B@A"䎊q@A"74@A#"`B@A#"`B@A#,zxl@A#33333@A#6z@A#9@A#F]c@A#S@A#$@A#U=@A#wk@A#S@A#q@A#@A#Ƨ@A$L_@A$/{J#@A$64@A$<쿱@A$SMj@A$o h@A$#@A$o h@A$o h@A$#@A$?@A$C@A$_@A$O
M@A$?@A$e@A%Q@A%84֡@A%S&@A%ce@A%m\@A%$/@A%!R@A%+j@A%%@A%U=@A%1@A%\(@A%(@A&Ov_@A&1.@A&?@A&E@A&L/{J@A&R<6@A&s@A&@A&&I@A&m\@A&ȴ9X@A&ߤ?@A&x@A&@A'@A'@A'E84@A'	@A'$tS@A'	k@A'	k@A'[W>@A'3@A'r@A'K]d@A'@A'@@A(*0U@A(6@A(*0@A(4m9@A(@A(9Xb@A(
(@A(4m@A(9Xb@A(ěT@A(e+@A(\)@A) ѷ@A)$/@A)rGE@A)4J@A)XbM@A)ae@A)ae@A)ae@A)[W>6@A)ae@A)[W>6@A)XbM@A)TɅo@A)TɅo@A)N;5@A)TɅo@A)[W>6@A)[W>6@A)k~(@A)oiD@A)o@A)(@A)X@A)@A)_o@A)R@A*s@A*䎊@A*GE85@A*M@A*Zc@A*Q_@A*kP|@A*xl"h
@A*S&@A*@A* ѷ@A*G{@A*C,@A*D@A+nP@A+nP@A+)^	@A+9@A+P{@A+Z@A+dZ@A+tj~@A+@A+Q@A+@A+:)z@A+A@A+U=@A+wk@A+S@A+~($@A+
=p@A+A [@A,1&y@A,tj@A,(\@A,,<@A,/{J#@A,/{J#@A,9XbN@A,PH@A,`d@A,cA \@A,cA \@A,j~#@A,tSM@A,*1@A,TɆ@A,O
M@A,@A,j~@A,j~@A,7@A,Ʌoi@A,/@A,hr@A,!-w@A,>@A-qu"@A-?|h@A-L_@A-Vl!@A-Y|@A-Y|@A-ce@A-zxl"h@A-ݗ@A-@A-1@A-n/@A-@A-cA @A-Ϫ͞@A-8YK@A-8YK@A-b@A-
qv@A-
qv@A-S@A.
L/@A.$/@A.($x@A..2@A.H@A.fffff@A.iB@A.l!-@A.s@A.$t@A.Fs@A.6z@A.6z@A.T@A.af@A.T@A.&I@A.x@A/
=p@A/,@A/1@A/As@A/Xe,@A/	k@A/vȴ9@A//V@A/@A/fA@A/@A/Vϫ@A/-@A/+j@A0F]d@A0	ԕ+@A0*0U@A0@A0 ě@A0 ě@A0$xG@A0>BZc@A0eO@A0bM@A0l"h	@A0y=c@A0YJ@A0'RT@A0-
@A04m@A0{@A0-
@A09Xb@A0U@A0
=q@A0u%F@A0u%F@A0@A0d8@A0ěT@A0@A0\)@A0PH@A0PH@A1$/@A1$/@A1$/@A1	k~@A1@N@A1*0U2a@A17KƧ@A14J@A1Dg8~@A1JE@A1[W>6@A1hr @A1u!S@A1b}@A1@A17Kƨ@A1@A1n.@A1^5?}@A1D@A1D@A12W@A1_o@A1@A1e@A1lD@A1.H@A2I^5@A2e+@A2&IR@A2C\@A2@4n@A2C\@A2GE85@A2:)y@A2GE85@A2h	ԕ@A2u%F
@A2kP|@A2h	ԕ@A2kP|@A2h	ԕ@A2^5?|@A2T`d@A2W'@A2h	ԕ@A2xl"h
@A2S&@A2S&@A20
@A2 ě@A2)_@A2 ѷ@A2C,@A2m\@A3)^	@A39@A3@N@A3@N@A3MjO@A3a@N@A3{J#9@A3~$@A3@A3~$@A3eO@A3:)z@A3wk@A3~($@A36@A3
=p@A3ݗ+k@A3ݗ+k@A3a@@A3Q@A3g@A3@A4J@A4J@A4L_@A4"h	ԕ@A42W@A4?@A4M:@A4M:@A4VϪ@A4`d@A4]ce@A4`d@A4Z1@A4Z1@A4`d@A4g8}@A4j~#@A4j~#@A4m8@A4?@A4C@A4_@A4_@A4zxl"@A47@A4/@A4u"@A4u"@A4Z@A4JM@A4>@A5'0@A5[@A5Q@A52a|@A5O;dZ@A5Y|@A5`A7L@A5ce@A5sg@A5M:@A5O
@A5v@A5Xy=@A58YK@A5,=@A5S@A5(@A5!.@A6_o @A64K@A6zG@A6@A6u@A6@A6u@A6Ov_@A6!R<@A6!R<@A6!R<@A6($x@A6($x@A6($x@A68YJ@A6;5X@A6BZc @A6\N<@A6s@A6s@A6IQ@A6Fs@A6$t@A6,<@A6T@A66z@A6A@A6C-@A61@A6Mj@A6Fs@A6Fs@A6Mj@A7 hۋ@A7@A7Ft@A7)^@A7)^@A7Xe@A7v@A7$tS@A7;dZ@A7H˒:@A7U=@A7b}V@A7o@A7	@A7r@A7@A7حV@A7@A7@A7@A7@A7+j@A7#@A7rGE9@A7#@A8bM@A873@A8D*@A8Xy=@A8[6@A8[6@A8hۋq@A8l"h	@A8oiDg8@A8n@A8@A8tj@A8@A8{@A8)@A8TɅ@A8ѷX@A8C@A8C@A8{@A8$tT@A9	k~@A9@N@A9&x@A90
)@A9N;5@A9[W>6@A9^@A9ae@A9hr @A9o hی@A9u!S@A9u!S@A9rGE8@A9b}@A9B@A9|@A9^5?}@A9o@A9"`@A9iB@A9e@A9Y}@A:e+@A:0U2a|@A:6C@A:6C@A:@4n@A:JL@A:JL@A:W'@A:Zc@A:T`d@A:Zc@A:^5?|@A:a|Q@A:d7@A:nO@A:xl"h
@A:\(@A:0
@A:vȴ@A:>B@A:)_@A:ڹY@A: ѷ@A:ڹY@A:ڹY@A:ڹY@A: ѷ@A;I^@A;u%@A;҉@A;u%@A;I^@A;҉@A;҉@A;'/@A;6z@A;F]c@A;P{@A;S@A;Z@A;g	l@A;jf@A;tj~@A;tj~@A;qu!@A;xF]@A;xF]@A;xF]@A;{J#9@A;Mj@A;:)z@A;:)z@A;$@A;:)z@A;$@A;ߤ@A;*0U2@A;m]@A;~($@A;Ƨ@A;|@A;|@A;
=p@A;Q@A;ݗ+k@A;lC@A;$@A<n.@A<xF@A<1&y@A<tj@A</{J#@A<2W@A<64@A<9XbN@A<SMj@A<m8@A<zG@A<wkP@A<?@A<qj@A<*1@A<쿱[@A<zxl"@A<zxl"@A<TɆ@A<1&@A<@A<[W?@A<֡a@A<!-w@A<e@A<>@A=o i@A<E@A=K]@A=*0@A=Q@A=2a|@A=84֡@A=<64@A=L_@A=O;dZ@A=Vl!@A=Y|@A=`A7L@A=`A7L@A=fA@A=fA@A=fA@A=m\@A=sg@A=zxl"h@A=M:@A=v@A=Xy=@A=8Y@A=@A=b@A=b@A=8YK@A=?@A=ڹ@A>
L/@A>4K@A>4K@A>4K@A>Ov_@A>.2@A>1.@A>?@A>E@A>L/{J@A>c	@A>p:~@A>s@A>}Vl@A>qi@A>Fs@A>af@A>T@A>af@A>,<@A>2X@A>ߤ?@A>Q@A>@A>ߤ?@A>&I@A>m\@A>@A>҈p;@A>C-@A>@A?@A?.H@A?KƧ@A?eں@A?O;d@A?-V@A?	k@A?&@A?/V@A?o @A?˒:)@A?K]d@A?K]d@A?fA@A?حV@A?حV@A?fA@A?@A?@A@bM@A@1&x@A@4m9@A@K]c@A@hۋq@A@u!@A@y=c@A@˒:*@A@-
@A@-
@A@
=q@A@@A@d8@A@{@A@9Xb@A@4m@A@ѷX@A@`A7@A@C@A@{@AA	k~@AA [7@AA-w1@AAA [@AA[W>6@AAXbM@AATɅo@AATɅo@AAXbM@AA^@AAe+a@AAo hی@AAb}@AA@AAn.@AA(@AAl@AAB@AA^5?}@AAD@AAo@AAo@AAԕ*@AAiB@AAs@AB1'@AB0U2a|@AB=p
@ABJL@ABM@ABM@ABQ_@ABT`d@AB^5?|@AB^5?|@ABa|Q@AB^5?|@ABh	ԕ@ABkP|@AB~"@ABL_@ABwkQ@ABL/{@ABg	@AB ě@AB ě@AB ě@AB ě@ABg	@ABg	@ABY@AB}Vm@AB<64@AB͞&@ABsP@AB䎊q@ABC,@ABm@AB~@ACI^@AB~@ACI^@ACI^@ACS&@ACS&@ACPH@AC	@AC	@ACPH@ACPH@ACPH@ACPH@ACPH@AC	@AC,zxl@ACMjO@ACdZ@ACdZ@AC{J#9@ACq@ACq@ACeO@AC:)z@ACߤ@ACߤ@ACU=@ACwk@ACwk@ACߤ@ACE@AC6@ACa@O@ACƧ@AC@ACQ@AClC@ACA [@AC$@ACA [@ACC]@AC@ACs@ACs@ACC]@AC҈@AC҈@AC҈@AClC@AClC@ACg@ACA [@AC@AC\N@AD@ADtj@AD%1@AD,<@AD?@ADFs@ADFs@ADSMj@ADZ1@ADZ1@AD]ce@ADVϪ@ADVϪ@AD]ce@AD]ce@AD]ce@AD]ce@AD`d@ADg8}@ADj~#@ADzG@ADzG@ADo h@AD*1@ADS@ADN;@AD쿱[@AD1&@ADzxl"@ADS@AD쿱[@AD_@AD쿱[@ADS@AD_@AD*1@ADS@AD3@AD_@AD쿱[@AD_@ADTɆ@AD?@AD?@AD?@AD1&@ADTɆ@ADO
M@AD?@ADO
M@AD?@ADZ@ADZ@AD@ADD@ADD@AD>@ADE@AE:@AE'0@AE[@AEQ@AE5Xy>@AEF
L0@AEL_@AES&@AE\@AE`A7L@AE`A7L@AEce@AEce@AEjOv@AEp
=@AEp
=@AEm\@AEzxl"h@AEM:@AEڹZ@AE!R@AEݗ@AEO
@AE=K@AE=K@AEU=@AEU=@AEXy=@AEU=@AEU=@AE@AE8YK@AE?@AES@AEᰉ@AEE@AEڹ@AF ѷY@AF ѷY@AF ѷY@AF
(@AF4K@AF+jg@AF;5X@AF5?|@AFBZc @AFVu@AF_ح@AFiB@AFp:~@AFIQ@AFIQ@AFz@AF}Vl@AF+J@AFFs@AF$t@AFqi@AF,<@AF-@AF&I@AFߤ?@AFm\@AF@AF&I@AFȴ9X@AFȴ9X@AF҈p;@AF҈p;@AFϪ͟@AFϪ͟@AF+@AFMj@AG
=p@AG
=p@AG)^@AG
M;@AG
=p@AG@AGXe@AG@AGv@AGv@AGXe@AG!-w1@AG4֡a@AG>6z@AG>6z@AG>6z@AG8}H@AG8}H@AG4֡a@AG4֡a@AG>6z@AGAs@AGAs@AGE84@AGH˒:@AGRT`e@AG\(@AGb}V@AGlC@AGo@AG&@AG	@AG&@AG	@AG	@AGO;d@AG$tS@AG	k@AG-V@AG-V@AG?@AGzH@AGr@AGK]d@AGK]d@AG+@AG@AG;dZ@AG@@AG-@AG䎊r@AG+j@AG#@AHF]d@AH@AH	ԕ+@AHF]d@AH@AH	ԕ+@AH}H@AH$xG@AH'RT`@AH'RT`@AH'RT`@AH'RT`@AH ě@AH ě@AH*0@AH4m9@AHK]c@AHNU@AHNU@AHK]c@AHK]c@AHK]c@AHQ@AHXy=@AHXy=@AHU2a|@AHU2a|@AHU2a|@AHXy=@AHXy=@AH_F@AHeO@AHhۋq@AHl"h	@AHl"h	@AHhۋq@AHhۋq@AHn@AH@AHtj@AH-
@AH@AHu%F@AH@AHU@AHd8@AHU@AHU@AHU@AHU@AH4m@AHěT@AH)^@AHp:@AHѷX@AH)^@AHF@AHۋq
@AHۋq
@AH҈p@AH`A7@AH@AHC@AH\)@AH$tT@AI$/@AI$/@AIrGE@AI@N@AI_p@AI_p@AI@AI#w@AI&x@AI-w1@AI0
)@AI4J@AI=b@AIQ@AIQ@AIQ@AIQ@AITɅo@AIXbM@AITɅo@AI[W>6@AIk~(@AIu!S@AI|Q@AIx@AI@AIo@AIR<6@AI@AIR<6@AI@AIu@AI'RTa@AIu@AI@AIl@AI|@AI@AI2W@AIN;6@AI_o@AI@AI"`@AIᰉ'@AI@AIs@AIR@AIs@AI-@AI.H@AJs@AJs@AJe+@AJe+@AJOv`@AJ#9@AJ#9@AJ#9@AJ0U2a|@AJ0U2a|@AJ6C@AJ:)y@AJ:)y@AJ@4n@AJC\@AJGE85@AJJL@AJM@AJQ_@AJQ_@AJQ_@AJQ_@AJT`d@AJW'@AJT`d@AJW'@AJd7@AJnO@AJxl"h
@AJu%F
@AJqiC@AJ~"@AJS&@AJvȴ@AJvȴ@AJvȴ@AJS&@AJS&@AJ@AJ>B@AJg	@AJ}Vm@AJg	@AJg	@AJ<64@AJ<64@AJ@AJn@AJ)_@AJW@AJ`A@AJ`A@AJ,<@AJ,<@AJڹY@AJ ѷ@AJG{@AJG{@AJڹY@AJ ѷ@AJG{@AJfB@AJ䎊q@AJ䎊q@AJ䎊q@AJG{@AJc	@AJc	@AJ74@AJD@AJD@AJD@AJ~@AKS&@AK҉@AK҉@AK҉@AK҉@AKC,z@AK,zxl@AK/V@AK,zxl@AK/V@AK33333@AK/V@AK/V@AK33333@AK=K^@AKC%@AKMjO@AKF]c@AKJ#9@AKMjO@AKW>6z@AKZ@AKa@N@AKa@N@AKg	l@AKjf@AKjf@AKjf@AKqu!@AKqu!@AKxF]@AK@AKeO@AK@AK@AKq@AKMj@AK:)z@AKA@AK$@AK:)z@AKA@AKߤ@AKS@AKS@AKwk@AK*0U2@AKm]@AKm]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @r[33333@r\@r`     @ra@rffffff@rd@r`     @r^fffff@ra@rd@rffffff@rh     @rffffff@rffffff@rffffff@ra@rd@rffffff@rk33333@rnfffff@rk33333@rc33333@rd@rffffff@rk33333@rl@rl@rp     @rnfffff@rh     @ri@rvfffff@r     @r@r33333@r@r     @r{33333@rp     @rl@rp     @r@r     @r@rfffff@r     @r@r33333@rfffff@rfffff@r@rfffff@r@r@r     @r     @r@r33333@r33333@r33333@r     @r     @r@rfffff@r@r@r@r33333@r@r33333@r33333@r@rfffff@r33333@r33333@r33333@rfffff@rfffff@r@r@r@r33333@rfffff@r@r@r{33333@rvfffff@rq@rk33333@rl@ri@rc33333@rY@rY@rVfffff@rS33333@rQ@rNfffff@rD@rfffff@r@r	@r@q@q@q陙@qᙙ@q     @q33333@q33333@q@q@q@q^fffff@q	@p     @pt@p8     @o33333@nfffff@nfffff@nL@n     @mfffff@m33333@m&fffff@lfffff@l<@l33333@k     @k@k@     @j     @j@j\@j)@j33333@i@i33333@i@ifffff@i33333@iffffff@iY@iP     @iC33333@i333333@h@h33333@h     @h@h     @h|@hS33333@h333333@h333333@h333333@h)@h@g     @g@gl@g`     @gS33333@gC33333@g<@g<@g9@g333333@g,@g)@g0     @g0     @g      @g33333@f@f@f\@f     @e@e     @e     @e@e     @e     @e     @evfffff@evfffff@ep     @effffff@e`     @e`     @e\@eI@e@     @e333333@e)@e@d@d@d@d     @d     @d     @d|@ds33333@d`     @d,@c     @c     @c@c     @c33333@cffffff@c<@c@cfffff@cfffff@c@c@b@b@b@bfffff@bfffff@bi@bP     @b@     @b6fffff@b,@b)@b33333@afffff@afffff@afffff@a33333@a     @a@a@a33333@a33333@afffff@ay@ap     @al@ai@affffff@ac33333@aVfffff@aC33333@a9@a333333@a@`     @`@`33333@`     @`y@`p     @`p     @`p     @`i@`I@`&fffff@`)@`333333@`)@`fffff@`fffff@_@_ٙ@_     @_ٙ@_33333@_33333@_     @_fffff@_33333@_fffff@_     @_y@_l@_9@^@^l@^9@^@^fffff@^      @^      @]33333@]@]fffff@]     @]     @]fffff@]33333@]     @]l@]Y@]L@]@     @],@]33333@\33333@\@\@\L@\&fffff@\@\33333@[     @[ffffff@[,@Z@Z33333@Zs33333@Z@     @Z@Y33333@Y@Y     @Ys33333@YS33333@Y9@Y@X@X33333@X@Xfffff@X33333@X33333@X     @X33333@Xfffff@Xl@X333333@X      @X      @X,@X&fffff@X,@X&fffff@X      @X@Xfffff@Wٙ@W@W@W@W@Wffffff@W@     @W33333@V33333@Vfffff@Vfffff@V@Vffffff@V&fffff@Vfffff@Ufffff@Ufffff@U@Ufffff@U@U33333@Uy@UL@U,@U33333@T@T@Tfffff@Tٙ@T33333@T     @TY@T@     @T,@T&fffff@T@S33333@Sfffff@S     @Sٙ@Sٙ@S@S33333@S     @SY@S9@S9@S&fffff@S      @S@S@R     @R     @Rfffff@R@Rfffff@RY@R&fffff@Q@Q     @Q@Qfffff@Q33333@Qfffff@Q     @Q@Qs33333@QFfffff@Q&fffff@Qfffff@Pfffff@P@P@Pffffff@PFfffff@P333333@P&fffff@P33333@P      @O@O@O     @Offfff@O@Offffff@O@     @O      @Nٙ@Nfffff@Ns33333@Ns33333@NY@N@     @N      @M     @ML@Lfffff@L@Lfffff@M@M@L     @L@K33333@Kٙ@Kٙ@Kfffff@K     @Ks33333@Ks33333@Kffffff@K333333@J33333@J33333@J33333@Jfffff@J@Js33333@J@     @J@J@J@Ifffff@I33333@I@Ifffff@I@Iffffff@I@H33333@Hfffff@Hs33333@HL@H&fffff@H@H@G33333@Gfffff@Gfffff@G@G     @G@G     @G@Gffffff@G@F@Ffffff@F@Ffffff@F@F     @F     @Fs33333@FY@F&fffff@E33333@Eٙ@Efffff@E@Efffff@E@Es33333@EL@E333333@E&fffff@E      @E@D33333@Dfffff@D@D     @D     @D@D@DY@D&fffff@C33333@C33333@Cfffff@C@Cfffff@C     @Cs33333@CL@C&fffff@Bٙ@B@Bs33333@BL@BL@B      @Aٙ@Afffff@Affffff@AL@A@@     @@@@333333@@@?fffff@?fffff@?33333@?     @?333333@>@>@>L@=@<fffff@<@<@<ffffff@<@;@;      @:fffff@:@:@:@:33333@:@:@:ffffff@:L@:@9fffff@9@9@9     @9333333@8ffffff@8L@8ffffff@8     @8L@7@7@7     @7ffffff@7ffffff@7L@7ffffff@7L@7333333@6fffff@6@633333@633333@6@6@6L@6@533333@5@5ffffff@5333333@4fffff@4fffff@433333@433333@433333@433333@433333@433333@4@4     @4L@4ffffff@4L@4ffffff@4ffffff@4ffffff@4ffffff@4ffffff@4@4@4     @4ffffff@4ffffff@4     @4ffffff@4ffffff@4     @4ffffff@4ffffff@4L@4L@4L@4L@4333333@4@4      @4      @3fffff@3fffff@3fffff@3fffff@3fffff@3fffff@333333@3@3@3@333333@3      @2      @133333@1@133333@1@133333@133333@133333@133333@133333@1@1@1ffffff@1333333@1      @1      @0fffff@1      @1      @0fffff@1      @1      @0fffff@0fffff@0333333@0@0333333@0      @0      @0      @0      @/@/@/@/333333@/333333@/333333@/333333@/      @/      @.@.ffffff@.ffffff@.@.@.@.333333@.333333@.      @.      @-@.      @.      @-@-@-@-ffffff@-333333@-ffffff@-333333@-      @,@,@,ffffff@,ffffff@,333333@,      @,      @+@+ffffff@+ffffff@+ffffff@+@+ffffff@+333333@*@*@*ffffff@*ffffff@*ffffff@*333333@*333333@*      @*      @*      @*      @*      @*      @*      @*      @*      @*      @)@)@*      @)@*      @)@)@)@)@)333333@)@)ffffff@)ffffff@)ffffff@)ffffff@)      @)333333@)      @(@(@)      @(@(@(@)      @(@(@(@(@(@(@(@(@(ffffff@(ffffff@(ffffff@(      @(333333@(ffffff@(333333@(      @(      @(      @'@(      @'@'@'@'ffffff@'ffffff@'@'ffffff@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'333333@'      @'      @'      @&@'      @'      @&@&@&@&@&@&@&ffffff@&@&ffffff@&ffffff@&ffffff@&ffffff@&@&ffffff@&333333@&ffffff@&333333@&      @&      @&      @%@&      @&      @&      @%@%@%@%@%@%@%@%ffffff@%333333@%ffffff@%333333@%333333@%ffffff@%      @%333333@%333333@%      @%333333@$@$@%333333@%      @%      @$@$@$@$ffffff@$@$@$@$ffffff@$ffffff@$@$ffffff@$ffffff@$333333@$333333@$      @$      @$333333@$333333@$      @$      @#@$      @$      @#@$      @#@#@#@#@#@#@$      @#@#@#@#@$      @$      @#@#@$      @$      @#@#@$      @#@#@$      @#@#@#@#333333@#@#@#@#ffffff@#@#ffffff@#@#@#333333@#333333@#@#333333@#@#ffffff@#ffffff@#ffffff@#@#@#ffffff@#@#@#ffffff@#@#ffffff@#@#@#ffffff@#@#ffffff@#ffffff@#ffffff@#ffffff@#@#ffffff@#@#ffffff@#@#@#ffffff@#ffffff@#ffffff@#@#ffffff@#ffffff@#@#@#ffffff@#ffffff@#@#ffffff@#@#ffffff@#ffffff@#@#@#ffffff@$      @#@#ffffff@#ffffff@#@#@#ffffff@#@#@#@#@$      @#@#@#@#@#@#@#@#@#@#@#@$      @#@$      @$      @$      @#@#@$333333@#@#@$      @$      @$      @#@$      @$      @$      @$333333@$      @$      @$333333@$ffffff@$      @$ffffff@$333333@$333333@$333333@$@$333333@$333333@$@$ffffff@$333333@$@$ffffff@$ffffff@$@$ffffff@$@$@$@$@$@%      @$@$@$@$@$@$@$@$@%      @$@%      @$@$@$@%      @%333333@%333333@%      @%      @$@%ffffff@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%333333@%ffffff@%ffffff@%333333@%333333@%ffffff@%ffffff@%ffffff@%ffffff@%ffffff@%@%@%@%@%@&      @&      @&      @%@&333333@&ffffff@&      @&333333@&      @&ffffff@&ffffff@&      @&ffffff@&333333@&@&ffffff@&333333@&333333@&@&@&333333@&@&@&ffffff@&@&@&@&@&@&@'      @'      @'      @'      @'333333@'333333@'333333@&@'ffffff@'      @'333333@'ffffff@'333333@'ffffff@'333333@'333333@'ffffff@'333333@'@'ffffff@'333333@'ffffff@'ffffff@'@'@'@'@'@'@'@'@'@'@'@(      @(      @'@'@'@'@'@(      @(      @(      @(333333@(ffffff@(ffffff@(ffffff@(ffffff@(333333@(ffffff@(@(ffffff@(@(@(@)      @(@(@(@(@)333333@)333333@)333333@)333333@)333333@)333333@)ffffff@)ffffff@)@)@)333333@)ffffff@)@)ffffff@)ffffff@)ffffff@)@)ffffff@)@)@)ffffff@)@)@)@)@)@*      @)@*      @*      @*      @*333333@*333333@*ffffff@*@*ffffff@*ffffff@*@*ffffff@*@*@*@*@*@*@*@*@+      @+333333@+      @+333333@+ffffff@+      @+333333@+333333@+ffffff@+ffffff@+@,      @+@+@+@,      @+@+@,333333@,333333@,333333@,ffffff@,ffffff@-      @,ffffff@,@,@-      @,@,@-      @-333333@-      @-333333@-ffffff@-ffffff@-ffffff@-ffffff@-@-@-@-@.      @.ffffff@.      @.333333@.333333@.@.@-@.@.@.333333@.@.@/      @/      @/      @/333333@/@/ffffff@/@/@0      @/@0      @0      @0      @0      @0@0      @0@0@0@0@0      @0333333@0333333@0L@0     @0ffffff@0@0@033333@0@0@0     @0     @033333@033333@033333@0@0@0fffff@0fffff@0fffff@1      @1333333@1333333@1L@1333333@1L@1ffffff@1L@1L@1ffffff@1L@1L@1L@1ffffff@1     @1     @1     @1     @1     @1     @133333@1@133333@133333@1@133333@1fffff@1fffff@1@1fffff@1fffff@1fffff@2      @2333333@2@2@2333333@2     @2L@2L@2ffffff@2@2@2@2@2@2fffff@2@233333@2fffff@2fffff@2@3      @3      @3333333@3L@3ffffff@3333333@3ffffff@3ffffff@3ffffff@3     @333333@3@333333@3@333333@3@3fffff@3fffff@4      @3fffff@4      @4      @4      @4      @4      @4333333@4L@4L@4333333@4L@4@4@4     @4@4@4fffff@5      @5      @5333333@5@5@5333333@5333333@5@5ffffff@5     @5@5@5@5@5     @5fffff@6@6      @5fffff@6@6@6@6@6@6333333@6333333@6333333@6L@6L@6ffffff@6@6fffff@7333333@7L@733333@733333@7     @733333@8@7fffff@8      @8333333@8      @7fffff@7fffff@8L@8333333@8L@8     @8     @833333@9      @9333333@9@9ffffff@9ffffff@9ffffff@9     @9@933333@933333@9fffff@9fffff@9@9fffff@:@:333333@:333333@:ffffff@:ffffff@:     @:fffff@;      @;      @;@;      @;333333@;L@;ffffff@;L@;333333@;ffffff@;33333@<      @;@;@;fffff@<      @;fffff@<@<L@<L@<333333@<ffffff@<@<fffff@=@=L@=L@=L@=L@=L@=ffffff@=     @=ffffff@=ffffff@=ffffff@=     @=@>      @>@>@>L@>333333@>ffffff@>     @>L@>L@>     @>     @>ffffff@>     @>     @>33333@>@>fffff@?      @?333333@?@?333333@?333333@?333333@?     @?L@?ffffff@?     @?ffffff@?     @?     @?@?@?33333@?@?@@      @@&fffff@@&fffff@@@     @@Y@@L@@Y@@L@@ffffff@@ffffff@@ffffff@@ffffff@@s33333@@s33333@@@@@@@@@@33333@@@@@@ٙ@@ٙ@@@@@@     @@fffff@@ٙ@@fffff@@     @@fffff@@ٙ@@ٙ@@fffff@@fffff@@fffff@@33333@@fffff@A@A@A&fffff@A&fffff@A@     @A@     @A&fffff@A333333@AY@AL@Affffff@A     @Affffff@AY@As33333@Affffff@Affffff@A     @A     @A@A@A@Afffff@A33333@A     @A     @Afffff@A33333@A     @A@A@A@A@A@Aٙ@Aٙ@Aٙ@Afffff@Aٙ@Aٙ@Afffff@A33333@B      @B@B@B@B@A33333@Afffff@B@B@     @Bffffff@Bffffff@BY@Bs33333@Bs33333@B@B     @B@B@B@B33333@B@B@B@B@B     @C      @C@C@C&fffff@C@C@C&fffff@C&fffff@C@C@Cffffff@CY@Cffffff@CL@CL@Cffffff@C     @C     @Cs33333@C     @C     @Cfffff@Cfffff@C     @C     @C33333@Cfffff@D      @D      @C33333@Cٙ@Cfffff@D@D@     @D&fffff@D333333@D333333@DL@Dffffff@D     @D@D     @Dfffff@D@D     @D@Dٙ@D@Dٙ@D     @Dٙ@E      @E@E@E      @E@E      @E&fffff@E@E@E&fffff@E@E&fffff@EL@EY@E@E@E@E     @E     @Es33333@E     @Efffff@E33333@E@E@Efffff@E     @E@Eٙ@Eٙ@E@Efffff@Eٙ@Eٙ@Eٙ@Efffff@Efffff@F      @F@F@F333333@F333333@F333333@FL@Fs33333@Fffffff@Fffffff@Fs33333@Fffffff@Fs33333@F     @F@F@F     @F     @Ffffff@F@F     @F@Fٙ@Ffffff@Ffffff@G      @G@G@F33333@G@G&fffff@G&fffff@G333333@G@     @G333333@G333333@GY@Gs33333@GY@GY@GY@Gffffff@G     @GY@G@     @G     @G@G@G     @Gfffff@G@G@Gfffff@Gfffff@G33333@G@Gfffff@G33333@G33333@Gfffff@G     @G@G     @G33333@G@Gٙ@G     @H      @G33333@G33333@H      @H@H333333@H@     @H333333@H333333@H333333@H333333@HY@H@     @HY@Hffffff@Hs33333@Hs33333@H     @H     @H     @H@H     @H@Hfffff@H@H33333@Hٙ@Hٙ@Hٙ@Hٙ@H33333@Hfffff@I      @H33333@H33333@I      @I@I333333@I333333@I333333@I333333@IL@IY@IY@Iffffff@Iffffff@Is33333@IY@I     @I@I@Ifffff@Ifffff@I     @I@I@Ifffff@I     @I33333@Iٙ@Ifffff@J      @J@I33333@Ifffff@Ifffff@J@J333333@J@     @J@     @J@     @J333333@J@     @J     @J     @J     @Jffffff@Js33333@Jffffff@J     @Jfffff@J33333@J     @J@J@Jٙ@Jٙ@Jfffff@Jٙ@K      @J33333@K      @K@K      @K&fffff@K&fffff@K&fffff@K@     @K@K&fffff@K&fffff@K@K&fffff@K333333@KY@KY@Kffffff@KL@KY@K     @Kfffff@K33333@K@Kfffff@K     @K@K     @K@Kٙ@K@K@Kٙ@Kfffff@L      @Kfffff@K33333@Kٙ@L@L@L      @L      @L&fffff@L@L333333@L333333@L&fffff@L@L&fffff@L333333@L333333@L&fffff@LL@L333333@L&fffff@L333333@L@     @Lffffff@LY@L@     @LL@LY@L     @Ls33333@L     @L     @L@Lfffff@Lfffff@L33333@L@L     @L33333@L     @L33333@L33333@L33333@L33333@Lfffff@L33333@M      @M      @M@M@M      @M&fffff@M&fffff@M&fffff@M333333@M333333@M@ML@ML@MY@ML@ML@Mffffff@Ms33333@M     @M     @M     @M     @M@M     @Mfffff@M@M@Mfffff@M33333@M@M     @M                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ? ě?"`?1&?+I^? ě?vȴ9?tj~?nP?Vu?&x?\(?Q?Z1'?\(?
=p
?+I^?$/?-V?tj~?nO;?QR?+J?hr!?zG{?=p
=?;dZ?C$?S?1&?S?nO;? ěT?      ?1&y?1&?
=p?I^5?/v?$/?E?r ě?Q?nO?-V@ xF@ěS@\(\@ ě?
=p?"`A?ffffff?1&y?n?E?bM?Q?Q?j~#?+?n?$/?      ?+??|hs?r ě?zG??|hs?+?O;dZ?I^5?A7Kƨ?Z1'?tj?E?      ?~"?^5?|?o?hr ?O;dZ?-V?nP?1&x?zG?tj~?\(\?r ě?lC?QR?~"?&x?QR?I^5?}?ާ-?hr!?lC?tj~?nO?5?|h?S?$/?lC?+I^?r ě?-V?+J?ffffff?ם-V?֧-?A7Kƨ?
=p
?KƧ?QR?"`?աo?tj~?+?I^5?1&?;dZ?̬1&y?+?p
=q?zG?O;dZ?+?C$?dZ1?\(?-V?lC?+J?+?x?Ƨ-?KƧ?tj~?Q?
=p?`A7?ļj~#?9XbM?n?M?$/?° ě?I^5??lD?n?&x?nO?ěS?lD?I^5??vȴ9X?      ?vȴ9?Gz?I^5??
=p?      ?nO?ěS?&x?lD?A7Kƨ?vȴ9X?ěS?bM?|hr? ěT?l?
=p?|hr?A7Kƨ?ěS?(\)?p
=q?"`?`A7L?$/?dZ1?Q?Q?^5?|?vȴ9?S?nP?E?hr!?vȴ9X?"`?5?|h?vȴ9X?`A7L?      ?Q?A7Kƨ? ěT?&x? ěT?vȴ9X? ěT?"`?5?|h?"`?      ?I^5??Q?tj~?"`?A7Kƨ?Q?E?
=p?vȴ9X?p
=q?n?nP?|hr?vȴ9X?`A7L?vȴ9X?hr!?|hr?
=p?5?|h?$/?      ?n?lD?lD?GzH?hr!?|hr?-V?ěS?S?I^5??bM?$/?$/? ěT?GzH?
=p?nP?7KƧ?p
=q?
=p?ěS?$/?&x?;dZ?
=p?      ? ěT?      ?;dZ?hr Ĝ?nP?nP?ěS?A7Kƨ?&x?$/?|hr?-V?M?-V?A7Kƨ?|hr?nP?7KƧ?vȴ9X?|hr?vȴ9X?hr Ĝ?333333?A7Kƨ?"`?GzH?A7Kƨ?E?bM?M?`A7?"`?;dZ?Õ$/?° ě?p
=q?"`? ěT?nP?A7Kƨ?;dZ?A7Kƨ?Q?lD?GzH?nP?$/?GzH?A7Kƨ?&x?;dZ?-V?I^5??&x?nP?;dZ?hr Ĝ?l?"`?GzH?      ?Q?n? ěT?7KƧ?lD? ěT?
=p?tj?GzH?$/?n?n?n?l?nP?I^5??hr Ĝ?Z1'?|hr?Q?bM?lD?;dZ?-V?Õ$/? ěT?n?;dZ?hr!?öE?nO;?tj~?nO?
=p?GzH?7KƧ?° ě?j~"?$/?S?bM?333333?nO?I^5??n?      ?bM?nO;?nO;?`A7L?-V?I^5??S?nO;?333333?`A7? ěT?Z1'?tj~?nO;?I^5??
=p?E?Õ$/?hr Ĝ?hr Ĝ?lD?
=p?nP?nO;?I^5??l?ěS?&x?Q?7KƧ?A7Kƨ?n?&x?nP?$/?ěS?Q?lD?n?&x?GzH?`A7L?&x?Q?° ě?M?hr Ĝ?nP?M?
=p?öE?n?333333?bM?n?|hr?+?hr Ĝ?° ě?GzH?7KƧ?`A7?ěS?
=p?Õ$/?$/?I^5??lD?$/?bM?Q?nO;?zG{?nO;?&x?l?nO;?Q?hr Ĝ?333333?`A7?I^5??nP?lD?$/?ěS?n?GzH?$/?&x?I^5??\(?$/?l?hr Ĝ? ěT? ěT?
=p?l?+?ěS?nO;?333333?lD?`A7L?tj~?      ?A7Kƨ?
=p?p
=q?E?$/?nP?I^5??      ?tj?7KƧ?$/?Q?+?tj?-V?333333?S?`A7?&x?n?Õ$/?7KƧ?I^5??"`?Q?+?7KƧ?nO;?bM?I^5??M?9XbM?nO;?Z1'?$/?333333?
=p?`A7?M?° ě?nO?"`?° ě?
=p?\(?lD?M?öE?+?n?öE?-V?M?lD?S?hr Ĝ?nO?\(?7KƧ?
=p?9XbM?l?Q?
=p?hr Ĝ?lD?Q?nO?`A7?n?|hr?      ?M?`A7?\(?I^5??&x?nP?\(?lD?$/?l?S?
=p?nO?° ě?nO;?`A7?Q?S?"`?$/?ěS?GzH?Õ$/?Õ$/?ļj~#?\(?\(?`A7?lD?nO?n?      ?+?n?S?GzH?ěS?hr Ĝ?\(?`A7L?nO;?n?° ě?333333?nO;?E?(\)?hr Ĝ?-V?ěS?tj~?nO?tj~?Q?° ě?7KƧ?hr Ĝ?tj?l?M?Q?nO?GzH?° ě?333333?-V?l?M?-V?nO?7KƧ?öE?\(?+?`A7?
=p?-V?&x?GzH?I^5??\(?333333?+?tj~?n?$/?l?7KƧ?&x?öE?° ě?nO?S?öE?l?-V?Q?
=p?$/?nO?S?hr Ĝ?Q?öE?Õ$/?\(?-V?-V?Q?° ě?lD?9XbM?zG{?Q?
=p?7KƧ?Õ$/?I^5??$/?bM?9XbM?Q? ěT?&x?333333?333333?7KƧ?&x?`A7?l?° ě?-V?ěS?S?`A7L?-V?
=p?ěS?\(?`A7L?$/?ěS?`A7L?\(?M?ěS?nO;?ěS?ěS?333333?GzH?`A7L?lD?-V?9XbM?lD?M?n?`A7?-V?&x?öE?Q?zG{?I^5??° ě?lD?l?Q?nO?lD?Q?\(?n?° ě?9XbM?° ě?bM?|hr?Õ$/?nO?° ě?      ?Q?tj?Z1'?l?7KƧ?l?lD?tj~?Õ$/?Z1'?tj~?
=p?+?zG{?zG{?\(?9XbM?9XbM?zG{?nO;?M?Q?9XbM?tj~?-V?tj~?tj?M?GzH?I^5??l?öE?-V?Q?bM?Q?lD?nO?`A7?+?/w?ěS?Õ$/?S?
=p?&x?zG{?° ě?7KƧ?öE?I^5??I^5??333333?l?n?° ě?7KƧ?bM?ļj~#?$/?9XbM?\(?bM?\(?tj?öE?`A7L?\(?+?`A7?
=p?öE?9XbM?S?
=p?Õ$/?333333?° ě?Q?-V?+?M?I^5??$/?-V?`A7?l?`A7?-V?Q?`A7?° ě?nO?nO?ěS?nO?l?tj~?I^5??\(?\(?`A7?öE?333333?nO;?nO;?tj?l?öE?öE?I^5??GzH?`A7L?&x?-V?-V?&x?nO;?+?nO?lD?Ł$/?öE?Q?nO;?nO;?l?M?\(?tj?M?S?Õ$/?S?7KƧ?-V?vȴ9X?-V?-V?° ě?-V?° ě?333333?lD?Z1'?lD?-V?I^5??333333?l?tj~?l?tj~?M?I^5??S?Õ$/?tj~?ļj~#?
=p?+?333333?M?Q?S?l?M?nO;?nO?öE?° ě?`A7?-V?7KƧ?Q?S?
=p??|hs?öE?tj?Q?n?Õ$/?M?° ě?
=p?nO;??|hs?M?Õ$/?tj?ěS?ěS?nO?l?hr Ĝ?9XbM?° ě?/w?zG{?\(?`A7?zG{?M?
=p?M?+?M?`A7?-V?tj~?333333?nO;?öE?+?° ě?+?Ł$/?S?nO;?ļj~#?7KƧ?9XbM?Õ$/?9XbM?Õ$/?Q?I^5??\(?tj?Z1'?S?333333?nP?S?tj~?zG{?E?Õ$/?-V?333333?lD?öE?M?S?`A7?zG{?`A7?M?Q?ļj~#?öE?n?I^5??l?tj~?n?tj?lD?Z1'?+?nO?öE?+?\(?9XbM?-V?/w?Õ$/? ěT?\(?öE?`A7?hr Ĝ?-V?öE?Ł$/?-V?Õ$/?Õ$/?öE?`A7?-V?
=p?nO?Õ$/?lD?zG{?333333?öE?ěS?S?Z1'?I^5??öE?Õ$/?
=p?7KƧ?nO?tj~?tj?Z1'?öE?l?öE?Q?ěS?9XbM?Q?Z1'?ěS?tj?hr Ĝ?I^5??+?Z1'?n?I^5??öE?Q??|hs?S?9XbM?-V?öE?$/?Q?I^5??333333?\(?tj?° ě?nO?tj~?tj~?\(?S?-V?$/?° ě?ěS?S?I^5??
=p?tj?lD?E?nO?Õ$/?9XbM?333333?tj~?Z1'?&x?E?° ě?7KƧ?333333?Z1'?lD?$/?Õ$/?S?l?° ě?Q?l?öE?ěS?ļj~#?Q?Õ$/?-V?$/?7KƧ?öE?
=p?Õ$/?S?tj?\(?9XbM?S?-V?I^5??&x?$/?Q?GzH?öE?tj~?Q?tj?tj~?S?`A7K?S?333333?° ě?/w??|hs?333333?nO;?7KƧ?nP?l?l?öE?
=p?-V?I^5??n?° ě?S?Q?ěS?hr Ĝ?Q?° ě?öE?-V?tj~?lD?ěS?lD?nO?vȴ9X?hr Ĝ?ěS?9XbM?° ě?/w?M?333333?Q?/w?tj?ěS?
=p?\(?° ě?+?\(?
=p?-V?nO?hr Ĝ?$/?nO;?M?
=p?nO?
=p?Õ$/?9XbM?7KƧ?l?9XbM?Õ$/?ěS?7KƧ?tj~?9XbM?zG{?° ě?tj?nO;?nO;?&x?S?S?vȴ9X?$/?Q?9XbM?tj~?+?tj~?I^5??ěS?nO?Õ$/?\(?`A7?tj?Z1'?&x?lD?Q?+?l?GzH?nO?tj?A7Kƨ?bM?nO;?
=p?
=p?`A7?\(?`A7?\(?lD?lD?nO;?`A7?Õ$/?333333?Q?tj~?Q?-V?333333?Q?l?Õ$/?nO;?S?&x?-V?333333?l?Q?$/?7KƧ?l?9XbM?tj?I^5??tj~?A7Kƨ?l?Ƈ+I?Q?`A7L?`A7?\(?lD?tj?tj?l?tj~?7KƧ?GzH?M?&x?Õ$/?\(?öE?Q?\(?333333?M?Q?tj?hr Ĝ?`A7?-V?l?I^5?? ěT?`A7?`A7?Q?Q?-V?`A7?`A7?hr Ĝ?öE?\(?n?`A7?
=p?`A7L?-V?9XbM?\(?$/?° ě?Q?-V?S?333333?`A7?-V?öE?ffffff?Õ$/?7KƧ?`A7?\(?-V?
=p?I^5??nO;?nO?° ě?7KƧ?tj?l?° ě?n?`A7?333333?° ě?l?GzH?I^5??° ě?\(?hr Ĝ?
=p?
=p?öE?nP?Q?öE?I^5??`A7?333333?7KƧ?Q?nP?lD?nO?nO;?I^5??nO;?+?Q?hr Ĝ?zG{?
=p?nO;?Õ$/?`A7?`A7?Z1'?zG{?-V?Q?nO?-V?tj?nO;?I^5??-V?-V?9XbM?tj~?S?`A7?333333?hr Ĝ?l?Q?l?333333?GzH?&x?`A7?
=p?tj~?`A7?S?`A7?\(?I^5??M?&x?333333?° ě?\(?Q?bM?n?GzH?-V?nP?GzH?lD?tj~?ěS?öE?
=p?tj~?nO;?I^5??I^5??n?lD?`A7K?öE?l?M?Q?333333?GzH?333333?+?\(?nO;?7KƧ?I^5??`A7?šo?333333?I^5??S?Q?&x?-V?nO;?M?l?-V?
=p?A7Kƨ?7KƧ?nO;?\(?bM?-V?Q?-V?hr Ĝ?333333?hr Ĝ?Q?`A7L?bM?333333?Q?`A7?E?`A7L?I^5??`A7?7KƧ?`A7?+?öE?ļj~#?nO?GzH?hr Ĝ?\(?bM?-V?`A7?nP?`A7L?&x?hr Ĝ?&x?&x?Q?+?nP?nO;?M?lD?ěS?7KƧ?GzH?I^5??l?ěS?7KƧ?öE?ļj~#?öE?I^5??Q?ěS?nO?S?zG{?tj?nO?M?GzH?+?n?bM?GzH?GzH?7KƧ?7KƧ?I^5??&x?\(?bM?nO?l?&x?Q?Q?I^5??n?° ě?S?Õ$/?S?öE?ěS?° ě?`A7L?nP?GzH?zG{?lD?`A7L?`A7?I^5??\(?A7Kƨ?M?`A7?l?S?\(?-V?I^5??I^5??-V?`A7?9XbM?S?° ě?n?`A7?`A7?nO?I^5??S?
=p?333333?l?nO;?GzH?öE?ěS?nO;?° ě?nO?\(?I^5??I^5??$/?Q?nP?|hr? ěT?`A7L?S?Õ$/?n?-V?333333?nO?bM?vȴ9X?A7Kƨ?7KƧ?vȴ9X?vȴ9X?bM?Q?nO;?bM?A7Kƨ?Q?`A7L?
=p?;dZ?bM?Q?M?hr Ĝ?A7Kƨ?7KƧ?nO?n?$/?hr Ĝ?&x?\(?n?° ě?
=p?I^5??Q?n?-V?n?      ?I^5??bM?-V?nO?-V?lD?hr Ĝ?\(?&x?bM?n?      ?n?      ?7KƧ?A7Kƨ?Õ$/?nO?nP?GzH?;dZ?I^5??n?n?nO;?öE?Q?° ě?`A7L?nO?bM?
=p?`A7L?Q?° ě?S?
=p?
=p?      ?      ?tj~?nO?7KƧ?$/?I^5??hr Ĝ?GzH?ěS?hr Ĝ?hr Ĝ?n?M?S?hr Ĝ?nO;?-V?|hr?Q?tj~?
=p?-V?tj~?-V?GzH? ěT?° ě?nP? ěT?$/?nP?&x?n?`A7?-V?333333?° ě?7KƧ?Q?
=p?-V?`A7L?hr Ĝ?333333?$/?n?n?l?-V?A7Kƨ?nO?`A7?Õ$/?nP?/v?GzH?M?A7Kƨ?Q?A7Kƨ?Q?-V?l?I^5??-V?S?A7Kƨ?lC?\(?bM?M?
=p?7KƧ?vȴ9X?$/?$/?7KƧ?      ?`A7?M?`A7?$/?&x?bM?-V?n?n?A7Kƨ?&x?M?° ě?l?$/?-V?&x?nO;?
=p?Õ$/?n?n?-V?dZ1?-V?`A7L?lD?hr Ĝ?-V?bM?I^5??`A7?;dZ?`A7?7KƧ?I^5??tj~?bM?\(?`A7L?bM?nP?vȴ9X?$/?tj~?° ě?I^5??-V?lD?;dZ?lD?$/?GzH?nP?333333?nO;?nP?"`?-V?nP?\(?A7Kƨ?`A7?-V?7KƧ?öE?$/?GzH?lD?lC?"`B? ěT?bM?hr Ĝ?|hr?7KƧ?° ě?`A7?lD?Õ$/?nO;?7KƧ?&x?7KƧ?GzH?nO?bM?l?333333?E? ěT?nP? ěT?GzH?
=p?      ?-V?&x?5?|h?GzH?šo?M?nO;?I^5??$/?|hr?A7Kƨ?`A7L? ěT?`A7L?$/?
=p?`A7L?&x?&x?lD?Q?GzH?-V? ěT?hr!?QR??bM?"`?&x?nO?S? ěT?GzH?S?+?-V?I^5??nP?nP?Õ$/?;dZ?tj?vȴ9X?I^5??`A7?Õ$/?nP?7KƧ?`A7L?`A7L?bM?&x?nO?
=p?vȴ9X?&x?      ?\(?lD?bM?hr Ĝ?&x?bM?$/?lD?n?7KƧ?\(?`A7?M?lD?lD?Q?$/?tj~?° ě?hr Ĝ?A7Kƨ?7KƧ?\(?7KƧ?vȴ9X?lD?ěS?-V?`A7L?7KƧ?7KƧ?(\)?ěS?l?n?bM?;dZ?&x?-V?333333?;dZ?GzH?ěS?hr Ĝ?M?7KƧ?&x?° ě?$/?$/?ěS?A7Kƨ?I^5??E?nO;?nP?Q?7KƧ? ěT?vȴ9X?|hr?Q?-V?"`?Q?`A7L?Q?ěS?`A7L? ěT?`A7L?7KƧ?M?öE?nO;?$/?9XbM?lD?lD?GzH?;dZ?7KƧ?7KƧ?$/?`A7L?&x?l?
=p?I^5??j~"?ěS?lD?ěS?
=p?5?|h?7KƧ?`A7?\(?ěS?$/?bM?-V?n?7KƧ?° ě?-V?vȴ9X?bM?|hr?"`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	@M     @NY@Nffffff@Nffffff@NY@Nffffff@Nffffff@Ns33333@Ns33333@Nffffff@Ns33333@Ns33333@Ns33333@Ns33333@Ns33333@M@Mfffff@N333333@N     @N@N@N&fffff@Nfffff@N@N@N     @N     @N     @N@Nfffff@Nfffff@N     @N@N@Nٙ@Nٙ@Nfffff@Nٙ@NY@Nfffff@Nfffff@N@Nٙ@N33333@Nffffff@N333333@N@     @N@     @Ns33333@O@O333333@OL@OL@OY@Offffff@O     @O@Offfff@O33333@O     @O@Oٙ@Offfff@O33333@O33333@Pfffff@P33333@P@P      @P      @P      @P      @P      @P,@P,@P,@P333333@P,@P9@P@     @P@     @PFfffff@PFfffff@PL@PS33333@PS33333@PY@P`     @P`     @Pl@Pl@Pl@Ps33333@Ps33333@Ps33333@Ps33333@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@Py@P     @Py@P     @P     @P     @P     @P     @Pfffff@P33333@P33333@P@P@P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P     @P@P@P@P@P@P33333@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P33333@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P@P@P@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P@P33333@P@P33333@P@P33333@P33333@P33333@P@P@P@P@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P@P     @P     @P     @P     @P     @Pfffff@P     @Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@P@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@Pٙ@P33333@P33333@Pٙ@P33333@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P33333@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@Pٙ@P     @P     @Pٙ@P     @P     @Pٙ@P     @P     @Pٙ@P     @P     @Pٙ@P     @P     @P     @P     @Pٙ@P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @P     @Pfffff@Pfffff@Pfffff@Pfffff@P     @Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pٙ@Pٙ@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P33333@P@P@P33333@P@P33333@P33333@Pfffff@P@P     @Pٙ@P33333@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P33333@P@P@P@P@P@P@P@P33333@P@Pfffff@P@P@P@P@P33333@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@P@Pfffff@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@Pfffff@P@Pfffff@P@Pfffff@Pfffff@P     @P@P@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@Pfffff@Pfffff@Pٙ@P@P@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P     @Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@Pfffff@Pfffff@Pfffff@P@Pfffff@P@Pfffff@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@Pfffff@P@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@Pfffff@Pfffff@P@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@Pfffff@P@P@P@P@P@Pfffff@P@P@P@P@Pfffff@P@P@P@Pfffff@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P     @P@P@P33333@P@P@P@P@P@P@P33333@P@P@P@P33333@P@P33333@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@Pfffff@P     @P@P@P@P@P@P@P@P@P@P@P@P@Pfffff@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P@P@P33333@P@P@P33333@P33333@P33333@P33333@P@P33333@P@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P33333@P@P33333@P33333@P33333@P33333@P33333@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P33333@P@P@P33333@P@P@P33333@P33333@P33333@P@P33333@P33333@P@P@P@P@P@P@P@P@P33333@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P33333@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@Pfffff@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P33333@Pfffff@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P33333@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P@P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P10                                     1                                       	BC3