CDF       
      pressure  >   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P26    CAST_NUMBER       4      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:34.849435Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @I         data_max      @I         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     y  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      @	   data_max      @        C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      y     pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      | &   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      ?ߤ?   data_max      @sߤ   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       y E@   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      | 0   salinity                	long_name         salinity   units         PSS-78     data_min      @@\C,zx   data_max      @AWkP   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      y ݬ   salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      | W   oxygen                  	long_name         oxygen     units         ?mol/kg    data_min      @0333333   data_max      @s33333   C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        y v   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      |    CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?O;dZ   data_max      ?I^5   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      y    CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      | t   PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min               data_max               C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       y    PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      |     	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     y ?\   CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      | L   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         (    cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         (    time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      )   data_max      )   C_format      %10d          latitude               	long_name         latitude   units         	degrees_N      data_min      @I 8\   data_max      @I 8\   C_format      %9.4f             	longitude                  	long_name         	longitude      units         	degrees_E      data_min      b{   data_max      b{   C_format      %9.4f              	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        $   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        (@I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @I      @	@@@       @"      @$      @&      @(      @*      @,      @.      @0      @1      @2      @3@3fffff@4fffff@6      @7      @8      @9@:      @:@<333333@=      @>      @>fffff@@      @@     @A      @As33333@B@C      @C     @D      @D     @E      @E     @F      @F     @F@Gs33333@H      @Hs33333@I@     @IL@J@Js33333@K33333@L      @L     @M      @M     @N      @N     @O333333@O     @P      @P@     @P     @P     @Q      @Q@     @Q     @Q     @R      @R@     @R     @R33333@S33333@S@     @S     @S     @T      @T@     @T     @T     @U      @U@     @U     @U     @V      @V@     @V     @V@W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y@Z      @Z@     @Z     @Z     @Z33333@[L@[     @[     @\      @\@     @\     @\@],@]@]     @^      @^@     @^     @^     @^@_,@_     @_     @`      @`      @`@     @``     @`     @`     @a33333@a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @bVfffff@bfffff@b     @b     @c      @c      @c@     @c`     @c33333@c     @c     @d      @d      @d@     @d`     @d     @d     @d     @d     @e      @e)@e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f|@f     @f     @g      @g      @g@     @g`     @gvfffff@g33333@h      @h      @h@     @h`     @h     @hfffff@hfffff@i      @i      @i@     @i`     @i     @i     @i     @j&fffff@j@     @j`     @j     @j     @j     @j@k@     @k`     @k     @k     @k     @k     @l      @l@l33333@l     @l     @l     @m      @m      @m@     @m@m@m33333@n      @nfffff@nL@n`     @n     @n     @n33333@n33333@o      @o      @o@     @offffff@o|@o     @o     @o     @p      @p     @p      @p0     @p@     @pP     @p[33333@p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q6fffff@q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @q33333@r     @r     @r      @r0     @r@     @rP     @r`     @rp     @r     @r     @r     @r@rfffff@r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @sa@snfffff@sfffff@sfffff@s     @s@s     @s     @s     @s     @t      @t     @t      @t0     @t<@tNfffff@t`     @tp     @t     @t     @t     @t@t33333@t     @t     @u      @u     @u      @u0     @u@     @uQ@u\@up     @u     @u33333@u@u     @u     @u     @u     @u     @v@vfffff@v#33333@v.fffff@v@     @vP     @v`     @vp     @v     @v@vfffff@v     @v     @v     @v     @v     @w      @w	@w$@w0     @w@     @wP     @w`     @wp     @w     @w     @w@w     @w     @w     @w     @x      @x     @x      @x0     @x<@xS33333@x`     @xp     @x     @x     @x     @x     @xfffff@x@x@y     @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y@y     @y     @z      @z     @z      @z0     @z@     @zP     @z`     @zp     @z     @zfffff@z     @z     @z     @z     @{      @{     @{      @{0     @{@     @{P     @{fffff@{     @{     @{     @{     @{     @{     @{     @|&fffff@|0     @|@     @|P     @|`     @|p     @|     @|     @|     @|     @|     @|     @|@}fffff@}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}33333@}     @}     @}     @}     @~      @~     @~      @~0     @~>fffff@~ffffff@~p     @~     @~     @~     @~     @~     @~     @~fffff@fffff@     @      @0     @@     @P     @`     @p     @     @     @33333@@     @     @     @ @     @     @     @      @(     @0     @8     @@@H     @O33333@\     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @      @     @     @     @      @&fffff@8     @@     @H     @P     @bfffff@h     @p     @x     @     @     @     @     @     @     @@     @@     @     @     @     @     @     @     @     @     @     @     @      @&fffff@0     @8     @@     @H     @P     @Vfffff@\     @i@p     @x     @     @     @     @     @     @     @@33333@     @     @     @     @     @     @     @ @     @     @      @(     @0     @8     @@     @H     @L@X     @`     @h     @p     @t@     @     @     @     @     @     @     @fffff@љ@     @     @     @     @     @      @     @     @     @33333@A@H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @ @     @     @     @      @(     @1@8     @@     @H     @P     @X     @`     @h     @p     @vfffff@     @     @     @     @     @     @     @@@     @     @     @     @     @33333@fffff@     @      @(     @0     @8     @@     @H     @`@h     @p     @x     @33333@fffff@     @     @     @fffff@     @     @     @     @     @     @     @     @33333@@     @     @      @(     @0     @8     @@     @H     @P     @i@p     @x     @     @     @     @     @     @     @@@     @     @     @     @     @     @      @     @     @33333@      @(@/33333@8     @@     @H     @P     @X     @`@d     @t     @x     @~fffff@@     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @      @     @     @     @      @(     @A@H     @P     @X     @`     @h     @p     @t@     @fffff@     @     @     @     @     @     @     @     @     @33333@fffff@     @fffff@33333@      @     @     @     @      @(     @0     @8     @=@X     @`     @h     @p     @x     @     @     @@@33333@     @     @     @     @     @     @     @fffff@     @      @@33333@     @      @(     @0     @8     @@     @H     @P     @Vfffff@p@x     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @      @     @fffff@fffff@@0@8     @@     @H     @P     @X     @`     @h     @o33333@     @     @     @     @     @     @     @@fffff@     @     @     @     @     @fffff@@     @     @     @      @(     @0     @4@A@H     @P     @U@bfffff@h     @p     @x     @     @     @     @     @     @     @     @@     @     @     @     @     @@     @     @     @     @fffff@,     @0     @8     @@     @H     @P     @bfffff@h     @p     @vfffff@@     @     @     @     @     @     @     @     @@     @     @     @     @     @      @     @     @@33333@(     @0     @8     @@     @E@Rfffff@X     @`     @h     @p     @x     @     @     @     @@     @     @     @     @     @33333@     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @(     @,     @0     @2@8fffff@<     @@     @D     @H     @L     @O@Y@\     @`     @c33333@hfffff@l     @p     @t     @x     @}33333@     @     @     @fffff@@     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @󙙙@      @     @     @     @     @     @     @     @33333@(@,     @133333@4     @8     @<     @@     @D     @H     @J@Tfffff@X     @\     @`     @c33333@i@l     @p     @t     @x     @|     @     @fffff@     @     @     @@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @fffff@     @     @     @     @      @     @     @     @     @@$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @J@T@X     @\     @`     @dfffff@h     @pfffff@t     @xfffff@|     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @fffff@     @fffff@     @     @     @     @     @     @     @33333@     @     @      @     @     @     @     @     @     @     @      @#33333@133333@4     @8     @<     @@     @D     @H     @L     @P     @T     @\fffff@`     @d     @h     @lfffff@p@t     @x     @|     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @@fffff@     @     @     @     @@     @     @     @     @fffff@     @     @      @     @     @     @     @@     @      @$     @(     @,     @0     @2@8@<     @@     @D     @H     @L@P@T     @X     @\     @`     @d     @h     @l     @p     @t     @x     @|     @     @fffff@     @     @     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @@@     @
@     @     @     @     @      @$     @(     @,     @0     @3@@     @D     @H     @L     @P     @T     @X     @\     @`     @c@tfffff@x     @}@     @     @     @     @@@     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @י@噙@     @     @     @     @     @     @      @	@     @     @     @     @33333@$     @(     @,     @0     @6     @8     @<     @@     @D     @H     @L     @Pfffff@S@`     @d     @h     @l     @p     @t     @x     @|     @     @@     @     @     @     @     @     @33333@fffff@     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @
@33333@     @     @     @      @$     @(     @,     @0     @4     @8     @<     @?@Hfffff@L     @P     @T     @X     @\     @`     @d     @f@pfffff@t     @x     @|     @     @     @     @fffff@     @     @     @@     @     @     @     @     @     @     @     @@ř@     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @      @     @     @     @     @     @     @     @      @$     @'33333@-33333@0     @4     @6fffff@>     @@     @D     @H     @L     @P     @T     @X     @\     @`     @c@l@p     @t     @x     @|     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @fffff@fffff@ @     @     @     @     @     @     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @R     @\@`     @b@lfffff@p     @t     @x     @|     @     @     @@33333@     @     @     @     @     @     @@@     @     @     @     @     @     @@fffff@     @ۙ@fffff@     @     @     @     @     @fffff@@     @     @     @     @     @     @     @@$fffff@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @P     @S33333@]33333@`     @d     @h     @l     @p     @t     @x     @|     @33333@     @     @     @     @     @     @     @     @33333@fffff@     @33333@33333@     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @     @     @     @@%33333@(     @,     @0     @4     @8     @<     @@     @D     @H     @L     @X     @\     @`     @d     @g@q@t     @x     @|     @     @     @     @     @fffff@33333@     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @     @fffff@fffff@@     @     @      @     @     @     @@     @@33333@$fffff@(     @,     @0     @4     @8     @<     @?33333@L@P     @T     @X     @\     @`     @d     @h     @l     @r@}@~@@     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @33333@33333@ۙ@ᙙ@     @     @     @     @     @     @     @      @     @     @@33333@     @     @      @$     @(     @,     @0     @4     @8     @<     @@     @C33333@Lfffff@P     @T     @X     @\     @`     @d     @h     @l     @p     @t     @w@@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @      @$     @&@5@8     @<     @@     @D     @H     @L     @P     @Rfffff@]@`     @d     @h     @l     @p     @s@@     @     @     @@     @     @     @     @     @     @     @@     @     @     @     @     @     @     @fffff@ݙ@     @     @     @     @     @     @     @     @      @fffff@     @     @     @     @     @      @$     @(     @,     @/@<     @@     @D     @H     @L     @P     @T     @X     @[@e@h     @l     @p     @t     @x     @|     @~fffff@33333@     @     @     @     @     @     @     @     @@33333@33333@     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @      @     @     @     @     @
33333@33333@@     @     @     @     @     @     @     @     @@"@$     @&     @(     @*     @,     @.     @0     @2     @4     @6     @8     @:     @<33333@Bfffff@D     @F     @H     @J     @L     @N     @O@T@V     @X     @Z     @[@`fffff@b     @d     @f     @h     @j     @l     @n     @o@v@x     @z33333@|     @}@     @     @     @@@     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @33333@fffff@     @     @fffff@     @     @     @     @     @     @     @     @     @     @噙@@     @     @     @     @     @     @     @     @     @33333@@     @     @     @
33333@     @33333@@@@     @     @     @fffff@!     @"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @533333@:@<     @>     @@     @B     @D     @F     @H     @P33333@R     @T33333@V     @X     @Y33333@`@b     @d     @f     @h     @j     @l     @m@t33333@v     @x     @z     @|     @~     @     @     @     @33333@     @     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @@33333@     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @     @@ܙ@     @     @     @     @     @     @     @     @     @     @񙙙@@     @     @     @33333@      @@     @     @     @	fffff@33333@     @     @     @     @     @     @     @33333@     @$fffff@&     @(     @*     @,     @.     @0     @2     @4     @5@:@<     @>     @@     @B     @D     @F     @H     @I33333@N@P     @R     @T     @V     @X33333@Z33333@\     @^     @_33333@bfffff@d     @f     @h     @j     @l     @n     @p     @r     @t     @v     @x33333@y33333@~fffff@     @     @     @     @     @33333@     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@33333@     @     @     @     @     @ə@@33333@     @     @     @     @     @     @     @ݙ@33333@     @     @     @     @     @     @     @33333@󙙙@fffff@     @     @      @     @     @     @33333@	     @@     @     @     @     @     @fffff@"fffff@$     @&     @(     @*     @+@0@2     @4     @533333@8@9@<     @>     @@     @B33333@Cfffff@H33333@J     @L     @N     @O@Tfffff@V     @X     @Z     @\     @^     @`     @b     @c@i     @j     @l     @n     @p     @r     @t33333@u     @zfffff@|     @~     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @     @     @     @fffff@@     @     @     @     @     @     @     @@33333@     @     @
     @     @     @     @     @@     @     @     @     @     @      @"33333@$33333@&     @(     @*     @,     @.     @/@4@6     @8     @:     @<33333@>     @E     @F     @H33333@N@P     @R     @T     @V     @X     @Z     @\     @`@b     @c@f     @h     @j     @l     @n     @p     @r     @t     @v     @w@~fffff@     @     @     @     @33333@33333@33333@     @33333@     @     @     @     @     @     @     @fffff@fffff@     @     @     @     @     @33333@     @     @     @     @     @     @33333@     @     @33333@     @     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @     @33333@     @     @     @      @     @     @@33333@     @     @     @     @     @     @     @fffff@ fffff@"     @$     @&     @(     @*     @,     @-@0     @2     @4     @6     @8     @:     @;33333@@     @B     @D     @F     @H     @J     @L     @N     @P     @R     @S33333@V@X     @Z     @\     @^     @`     @b     @d     @f     @h     @i@n@p     @r     @t     @v     @x33333@y33333@|33333@~     @     @     @     @     @     @     @     @     @33333@fffff@     @     @     @33333@     @     @     @     @     @@@@     @     @     @     @     @@@     @     @     @     @     @     @     @Ǚ@     @     @     @     @     @     @     @     @     @33333@♙@     @     @     @     @     @     @     @@     @     @     @     @      @     @     @     @fffff@@     @     @     @     @     @     @33333@     @fffff@      @"     @$     @&     @(     @*     @,     @.     @0     @1@4@5@8     @:     @<     @>     @@     @B     @D     @E@Lfffff@N     @P     @R     @T     @V     @X     @Y@`@b     @d     @f     @h     @j     @kfffff@pfffff@r     @t     @v     @x     @z     @|33333@}33333@fffff@     @     @     @     @     @@     @     @33333@@     @     @     @@33333@     @     @     @     @@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @љ@fffff@     @     @     @ݙ@@     @     @     @     @     @33333@     @     @     @33333@33333@@     @
     @     @     @     @     @     @     @     @     @      @"     @$     @&     @(     @*     @+33333@033333@2     @4     @6     @8     @:     @<     @>     @@     @B     @D     @Hfffff@J     @L     @N     @P     @R     @T     @V     @X     @Z@\     @^     @`     @b     @d     @f     @h     @j     @l     @n     @o@t33333@v     @x     @z     @|     @~     @     @     @33333@     @     @     @     @     @     @     @     @33333@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @33333@fffff@fffff@     @     @@     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @      @     @33333@33333@     @
     @     @     @     @     @     @     @fffff@33333@     @      @"     @$     @&     @(     @.33333@0     @2     @4     @6     @8     @:     @<     @>33333@?33333@B@D     @F     @H     @J     @L     @N     @P     @Q@Vfffff@X     @Z     @\     @^     @`     @a@d     @f     @h     @j     @l     @n     @p     @r     @s33333@z     @|     @~     @     @     @     @33333@     @     @     @@     @     @     @     @@@@     @     @     @     @     @     @@@     @     @     @     @     @@     @     @     @Ǚ@@     @     @     @     @     @     @     @ۙ@@     @     @     @     @     @     @     @fffff@33333@     @     @     @     @     @      @@@33333@
     @     @     @     @     @@@     @     @      @"     @$     @&     @(     @*     @,     @.     @/33333@6     @8     @:     @<     @>     @@     @B     @D     @E@L33333@N     @P     @R     @T     @V     @X     @^33333@`     @b     @d     @f     @h     @j     @l     @n     @p     @r     @v33333@x     @z     @|     @~     @     @     @     @     @@fffff@     @     @     @     @     @     @     @@fffff@     @     @     @     @     @     @     @@33333@     @     @     @     @@     @     @     @     @33333@@     @     @     @     @     @     @     @33333@     @     @     @     @     @     @     @홙@33333@     @     @     @@     @     @      @     @     @     @@@     @     @     @     @     @     @     @fffff@&fffff@(     @*     @,     @.     @/@7     @8     @:     @<     @>     @@     @B     @C@Jfffff@L     @N     @P     @R     @T     @V     @X     @Z     @\     @^@_33333@b@d     @f     @h     @j     @l     @n     @p     @r     @t     @|     @~     @     @     @     @     @33333@33333@     @     @     @     @     @     @     @33333@33333@@     @     @     @     @33333@@     @     @     @     @     @     @     @     @33333@33333@@     @     @@     @     @     @     @     @     @     @     @     @33333@fffff@     @     @     @     @     @     @fffff@     @     @     @     @      @     @     @     @
@     @     @     @     @     @     @@fffff@      @"     @$     @&     @'fffff@.33333@0     @1fffff@3@6     @8     @:     @<     @>     @@     @A@D     @F     @H     @I@Nfffff@P     @R     @T     @V     @X     @Z     @\33333@]33333@d     @f     @h     @j     @l     @n     @p     @vfffff@x     @z     @|     @~     @@fffff@     @     @@     @     @     @     @     @33333@     @     @33333@@@     @     @     @     @     @     @     @     @@@     @     @     @     @     @     @33333@Й@     @     @     @     @ٙ@fffff@     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @      @@@
     @     @     @     @     @33333@33333@fffff@     @      @"     @$     @%@.     @0     @2     @4     @6     @8     @:     @;fffff@@@B     @D     @F     @H     @J     @L     @N     @P     @R     @T     @U@Zfffff@\     @^     @`     @b     @d     @efffff@jfffff@l     @n     @p     @r     @t     @v33333@w@~fffff@     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @fffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@̙@     @     @     @     @     @     @     @     @     @     @     @     @噙@@     @     @     @     @     @     @     @@@      @     @     @     @     @
     @     @     @@fffff@     @@     @     @      @"33333@#fffff@*fffff@,     @.     @0     @2     @4     @6     @8     @9fffff@B@D     @F     @H     @J     @L     @V     @X     @Z     @\     @^     @_@ffffff@h     @j     @l     @n     @o@r@t     @v     @x     @z     @|     @~     @     @     @     @fffff@     @     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @@@     @     @     @     @@33333@     @     @     @     @@     @     @     @     @     @fffff@fffff@     @癙@@     @     @     @     @     @     @     @fffff@fffff@     @     @     @
     @     @     @     @     @fffff@     @     @     @      @"     @#33333@(@*     @,     @.     @0     @233333@333333@833333@:     @<     @>     @@     @B     @C@J33333@L     @N     @P     @R     @T     @Ufffff@Zfffff@\     @^     @`     @b     @d     @f     @h     @i@n33333@p     @r     @t     @v     @x     @z     @|     @~     @     @fffff@@     @     @     @     @     @     @     @@@     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @@     @     @     @     @     @     @     @33333@@     @     @     @     @     @     @     @     @      @     @     @     @@33333@     @     @     @     @     @     @     @33333@"     @$     @&     @(     @*     @,     @.     @0     @2     @4     @6     @8     @:     @<     @>     @@     @B     @D     @F     @H     @J     @L     @N     @P     @R     @S@V     @X     @Z     @\     @^     @`     @b     @d     @f     @h33333@lfffff@n     @p     @r     @t     @v     @x     @z     @{fffff@@     @     @     @     @     @33333@@@     @     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @@     @     @     @     @33333@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @     @     @     @      @     @     @     @     @     @     @     @     @	     @
     @     @     @
     @     @     @     @     @     @@ffff@     @     @     @     @     @     @     @     @     @@ffff@      @!     @"@"ffff@$     @%     @&     @'     @(     @)     @*     @+@,     @-     @.     @/     @0     @1     @2     @3     @4     @5     @6     @7     @7ffff@8ffff@:     @;     @<     @=     @>     @?     @@     @A     @B     @C@C@F33333@G     @H     @I     @J     @K     @L     @M     @M@Q@R     @S     @T     @U     @V     @W     @X     @Y     @Z     @[     @\     @]     @^     @_     @`     @a     @b     @c     @d     @e     @f     @g     @h     @i     @j@k     @l     @m     @n     @o     @p     @q     @r     @s     @t     @u     @v     @vffff@x     @y     @z     @{     @|     @}     @~     @     @     @     @     @     @     @     @     @     @ffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @ffff@33333@     @     @     @     @     @     @     @     @     @     @@ffff@     @     @     @     @     @     @     @     @     @     @ffff@ffff@     @     @     @     @@     @     @     @     @     @@     @     @     @     @     @     @     @     @     @     @     @@ffff@     @     @     @     @     @     @@@ffff@ffff@     @     @     @     @     @     @     @     @     @     @     @@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @U=@҈p@n.3@wk@n.3@S@	@'R@e@3@C,@}Vm@o@Gz@A7K@o@(\@S@$@ߤ@@=K^@]ce@}H@?@>@5?|@%@ ѷY@N;@Y@c	@sPH@Xe,@>6z@*0@e+@+@e+a@@@tj@&@Mj@
L/@zH@1&x@?@[qu!@P)^@H@HeO@G)^@G+I@F]cf@F-@G)^@En/@EQ@DS@DM:@Dtj@C@B74@Bu%F
@BI^5@An.@A@B@4n@A7Kƨ@A:S@An.@A [7@@C@@IQ@@hۋq@@4m9@?b}V@>($x@=ڹZ@=!.H@<j~#@<n.@;5Xy@;A@;m]@;J#9@:)y@8)@8}H@7rG@71@6_ح@6+jg@6_ح@6Fs@6!.I@6Fs@6}Vl@6!.I@7rG@8Q@8)@9	k~@<Z@?@CF]c@A@TFs@@@4m@MO;dZ@^Ov_خ@sߤ@_ح@sg@Xy=@lC@@IQ@(@-w1@D*@cA \@@@b}V@yY}@t֡a@3E@%+a@D*@$/@!.I@ᰊ@VϪ@JE@o @ǮzH@D@ ě@:~ @bM@h\)@N+@0
=q@
W'@.H@ѷX@:@JE@PH@`d@@]ce@PH@Gz@n.3@~($@GE85@R<6@`d@PH@Xy=@d7@+@zC\@W@7rG@(\)@,>B[@%S@7KƧ@@ѷX@DJM@I@BZc@2䎊q@'lC@ݗ+j@R@ԕ*@($x@0U2a|@M@u%F@ ѷ@z@u?|h@nH@ix@g/V@Zvȴ@84֡b@ݗ+@)^@9Xb@u%F@?@@($x@zxl"@1'@ߤ?@sg@d7@@%1@wkQ@2a|@҈@~vȴ9X@wKƧ@sE@o4֡a@iy@@n@=ڹZ@C,zxl@4D@!.H@"M@&@"C,@S@,<@$xF@,zxl"@-(@&1.@"}Vm@ -
@@@4@@dZ@)@C-@-V@P{@e@ěT@o h@z)_@{/V@|Q@zxl"h
@usg@bM@H@8)@,VϪ@#
=p@!R<6@	@IQ@>BZ@	 ѷ@v@8YK@oiDg@@F]d@oiDg8@MjO@S&@N+@_䎊r@a@N@[S@TZ@UL_@R:)y@PH@NVu@K]cA@F-@CF]c@?@<?@7eں@/iDg8@(>BZc@&L/{J@ A7K@=K@@L_@*0@nP@n.@ C@b}V@<64@!.I@?@#@ ě@쿱[W?@빌~($@fB@xF@1'@՛=K@kP|@Z@&@_p@
M;@y@nP@Y}@֡a@-@:~ @l@o@@:~ @>B[@fA@@N@6C@Ʌoi@_p@@k~(@$/@@,zxl@\N@~m\@w1@o hۋ@n.2@mU=@eu@_?@XbM@F?@;5Xy@3MjO@-(@'&@%O
@#	@vȴ9@?@ ěT@L_@;dZ@
O;dZ@9Xb@@:S@+jg@s@O;@U=@1.@M@	k@޸Q@/w@e+a@+@Q@,zxl@@4m9@v@:S@D@C-@_ح@S@iB@[@qu!@O;d@Ϫ͞@4J@Mj@#9@E84@yXbM@wrG@u'0@rGE85@o hۋ@nH@lC@iy@hۋq
@g8}H@fx@eO
@c	@`[6@_o@^@^Ov_خ@^Ov_خ@^Ov_خ@],=@]}H@][@\wkP@Y_o@Xtj@WsPH@RsP@Rn@RsP@Q_p@M@M:@L_@K:)z@I7KƧ@F-@Ca@N@B&IR@An.@An.@Ao hی@?[W>@=p
=@9rGE8@8Q@5?@2a|Q@/@.1@-
qv@-w1@,[W?@+~($@)ᰉ'@(Xy=@%F
L0@"@4@ 'RT`@Ov_خ@u"@e+a@sPH@R@
5Xy>@	^5?}@?@Q@74@n.@$/@H˒@GE85@`A7L@Q_@fA@@R@*0U@jOv@@ [7@XbM@TɅ@n.3@u"@=K^@@@+J@*0U2@ݗ+k@*0U2@S&@n@u@!R<@@L_@ԕ*@eO@ݗ+@_o@@y"`@sg@o4֡a@h>BZc@dZ1@^ ѷY@Vaf@P|@MjOv@JL_@H˒:*@A [7@?|hs@>vȴ9X@>
(@7KƧ@-
qv@+6z@&IQ@!-w1@!-w1@IQ@Ov_@bM@
=p
@oiDg@ڹZ@ȴ9X@oiDg8@rGE@7@C,@ٳ|@fA@Z@|@cA \@ʌL_@˒:*@74@@H˒:@K]@A@YJ@֡a@J@V@S@`A@-V@_o@L_@ݗ+k@҉@nO@!R<@O;dZ@(@|PH@xl"h	@vFs@v_ح@uY|@p:~ @lVϪ@hۋq
@f,<@e`A7L@`d8@UfA@N+@L/{J#@G@@B@?@5?@/v@,q@'/V@u@@@$tS@sh@O
M@N;6@bM@p:@
hr@
A [@
fffff@
Ft@
fA@
a@O@
a@O@
Z@
ҽ<64@
_p@
;dZ@

M;@
)^	@
ěS@
 [7@
j~#@
}H@
33333@
͞&@
n.3@
	@
*0U2@
n/@
{~$@
sg@
pD@
o hۋ@
jJL@
h	ԕ+@
fA@
f,<@
gfA@
d%1@
^@
Y|@
Yb}@
XU@
W
=p@
RT`d@
Np:~@
H@
ATɅo@
6E@
.1@
+a@@
'&@
 ěT@
S@
Xe,@
:)y@
qiC@
Q@\N<@?@%F
L@@!-w@>BZc@%1@	@e@@N@҈p@l!-@|@@)^	@Õ$@Z@)@?|h@?@}H@Q@S@Q@u%@u%F@R<6@qi@˒:)@vȴ9X@qu!S@o hۋ@iB@cA [@N+@IoiD@DS@=v@9XbM@0{@,>B[@'-@($xG@$?@Ov_خ@u%@PH@$/@hr @rGE9@
@q@	7KƧ@H˒@1@@A [@@eO@e+@u!@Ft@Ft@
M;@ɅoiD@#9@Ƨ-@m\@8YK@C@A@Q@9XbN@}Vl@lD@IQ@S@1@1@zxl"h@
=p@3@_o@@u@-
q@xF]@S&@S&@M:@@zC\@w1@wkP@u!.@l!-w@h>BZc@bC,@_?@_Ft@ZQ_@R䎊@O
M;@JW'@Gy@E@C,zxl@@4m@<Z@6C-@,>B[@'RT`e@$/@,<@@	ԕ*@YJ@tj@
m\@
J#9@
F]d@
_ح@
MjO@
@
	k@
唯O
@
6@
,<@
,<@
ҽ<64@
͞%@
@
s@
n@
@
s@
@
n@
64@
~($@
o@
ߤ@
V@
0
@

=p@
	@
-V@
u%@
L_@
\(@
~($x@
u%F
@
~\N<@
}E@
}Vl!@
|PH@
{m]@
y(@
v+jg@
vFs@
qu!S@
jfB@
f,<@
e+a@
b@4@
aGz@
`
qu@
_o@
TE@
K)^	@
F]cf@
E8YK@
C\N@
B\(@
?H˒:@
<64@
64K@
2-V@
-U=@
*0U2a|@
)@
(Xy=@
'RT`e@
"`A@
%@
_F@
ݗ+k@
Fs@
Fs@
S&@
ߤ?@
q@	?@	.2@	r Ĝ@	+a@	u!@	bM@	p:~@	Q@	@	s@	4m@	4m@	
(@	}Vl@	V@	V@	>B[@	U=@	lD@	L/{J@	9@		@	u"@	sh@	hr @	@	q@	ݗ+@	 ѷ@	zG{@	xl"h	@	v!.I@	u!.@	tSMj@	r䎊q@	lVϪ@	ix@	eڹ@	a'R@	^ ѷY@	Y>BZ@	W&@	XbM@	S@	S&@	RT`d@	P`A7@	O;dZ@	N_o @	Ks@	H9Xb@	G)^@	BZc@	@4m@	=b@	:S&@	9XbM@	5'0@	/O
M@	%S@	$xF@	,=@	+j@	$/@	@N@	҉@	'/W@	@	C%@	1&x@	o h@	I^5@	      @"@!.H@xl"h
@GE85@.2@@eO@5?|@ݗ+j@څݘ@т@Ƨ@ɺ^5?}@ɅoiD@)^@@s@5Xy@)@9XbN@2X@\)@-
@	@-V@C,zx@u%@e+a@O;d@@N@rGE9@qu"@oiDg@b}V@{~$@v+jg@rs@l!-w@g	k@dqj@aGz@]+j@YJE@U=K@R<64@JW'@Eo i@84֡b@333333@/r@+U=@!R<6@0
)@@4J@@
M:@	ԕ*@ݗ@ IQ@"@?@s@s@F@!R@䎊q@:~ @VϪ@8}H@C,@حV@/w@Ʌoi@@Ƨ-@g8}@&IR@3@{@
qv@IQ@wk@9@U=@kP|@_o@0
)@@@Ov_@ݗ+k@u@)^@I^5@|#x@|PH@sMjO@k~($@j~"@h@e@ceO@`u!@\?@Vl!-@UfA@R<64@N;5X@M5Xy>@K]cA@I@D*0@=v@5'0@0U2a|@(@%u@"`A@!o@=K^@_o@@@*0@$tT@-
q@҈@
qiC@	'RTa@@nP@o hی@#x@C\@ȴ9X@@쿱[W?@B@A@`A7L@`A7L@e+@>@ӎMj@m@m@p:~@)^	@W'@p
=@dZ@^5?|@XbM@YJ@KƧ@sg@a|Q@O
M@
(@B@@Xy=@&@'@zxl"h@?@-
@R<6@Q@rGE85@kC]@glC@b}Vm@^5?|@Y|@Vaf@SMj@P*0U@F]cf@Fs@G)^@Fs@As@@n@>vȴ9X@<j~#@;/V@:^5?|@:)y@7KƧ@2-V@0{@.zG@+I^@'RT`e@ [6@u"@6C@@+J@tj~@4J@'/W@
qu"@eO@nP@:S@PH@g@Dg8~@5?|@>BZ@JE@@՛=K@@&@R@а{@@Ƨ-@m\@Zc@H˒:@BZc @Z@^5?|@jf@*0U2a@^@\)@&@x@.H@Ov_خ@1&@qu!@_o@$/@n@!R<@O;dZ@ ѷ@ ѷ@b}V@z>B@w1@sg@d7@[q@W&@T`d@Rm@O͞@N_o @IQ@E84֡@C$@As@>
(@:)_@73@73@5?|h@1[W>6@-V@(TɅ@',@$?@!R<6@	@[@C,zx@C,zx@=K^@kP|@@@@N@u@-
q@eO@oiDg@S&@@      @C\@	k~@l"h	@l"h	@eں@E@쿱[W?@Z1@A [@eO@Z@S@M@|Q@@N@d8@W>6z@@t@,<@҈p:@D@@@ȴ9Xb@K]c@E84@2W@s@vȴ9X@64@A@)_@S&@XbM@W@
qv@w1@q@y@@L/{J@/@xF@`A@h	ԕ@䎊r@,=@wkP@PH@tj~@-
q@Vu@@@ߤ?@Vu@@q@ڹY@	 @ ѷ@?@˒:)@}E@}E@{s@vȴ9X@qu!S@iᰉ'@bM@^ ѷY@Y|@Vl!-@U2a|@KƧ@C\N@>
(@9Y}@8Q@5?@3ߤ@+a@@&IQ@$?@"`A@S@4J@@
M:@q@
	 @u%F@Q@tj@:S@m\@hr@-
@j~@
=q@O;@JL@@Z1@ⶮ}Vm@Gz@>@ԕ*1@҈p:@]cA@Q@@@o i@4m@/V@4K@3@4K@ᰊ@
qv@I^@I^@d7@\)@*0U2a@TɅ@Xy=@x@RT`e@-@,@zxl"h@tSM@`A@	@[@tj~@qi@qu"@C%@7KƧ@o hی@~$t@}E@z>B@weں@mC\@k~($@jfB@jOv`@h>BZc@g@eڹ@d%1@b@4@b@4@a'R@a|Q@a|Q@_?@]+j@Zݘ@XU@Vaf@U2a|@R䎊@O͞@L@Ks@Jn@GE84@Fs@F
L/@F?@Dg8}@C$@A7Kƨ@>6z@7rG@0
(@*d7@'/V@&'@!ae@C,zx@PH@Xe,@R<6@ᰉ@tj~@Mj@I^5?@	'RTa@u%F@&I@$/@@n.@($x@!.H@?@(@kP@E@s@@c	@>BZc@@`A7L@%1@	@|Q@d8@o@>@1'@y=c@t@T`d@;dZ@;5X@̘_@/{J#@)^	@#9@ȴ9Xb@ʌL_@Q@š@Õ$@ߤ?@)y@rG@Xe@{@a@@0
@^@zxl"h@u@tSM@TɆ@S&@h	ԕ@n.3@ěT@u"@S@6C@PH@$tS@Ov_@zG@bM@L_@p:@ݗ+@oiDg@&I@Fs@4m9@{~$@xl"h	@tSMj@kC]@h	ԕ+@e@de@cZ@bC,@_Ft@[$@W@W
=p@VϪ͟@VϪ͟@U2a|@Sa@O@RT`d@Q_p@N+@K:)z@HK]c@B@>
(@<Z@;dZ@:)y@6C-@5sg@3ߤ@-w1@+6z@(TɅ@&L/{J@%1@%F
L0@$tSM@$?@#
=p@"3@vȴ9@IQ@e+a@zG@@tj~@@N@rGE9@I^5?@
=p
@	7KƧ@u%F@{J#9@ 4m9@      @#x@C\@@(@=b@73@+jg@@c	@C]@Ov`@x@ۋq
@唯O
@M@e@ⶮ}Vm@ߤ?@"`B@ԕ*1@т@_p@H@
M;@+@:@n@jOv@@̘_@/{J#@@E84@84֡@@@ [7@ [7@H˒:@b@Z@j~#@5Xy@A@dZ@~@D@rG@KƧ@}Vl@z@J@9XbN@{@
qv@0
@a@@jf@I^@͞&@/V@S@1@zxl"h@
=p@[6@-V@@Ov_@nO@\(@M:@xF]@=p
@u%F@@M:@$/@|PH@y(@xF]d@u!.@sg@oiDg8@kQ@g	k@f1.@de@b}Vm@`d8@^҈p;@^@^҈p;@^@\>@]/w@ZY@U=K@QX@N+@M:@JD@IoiD@I@IQ@H9Xb@GzH@GE84@F-@F?@C\N@>ߤ?@:^5?|@9#w@9~($@8)@7rG@6z@1[W>6@.2X@+I^@)lD@'-@$?@"wkQ@'/V@ 'RT`@-V@6C@Xe,@bM@
(@
@
qu"@1&x@Fs@n/@n/@{J#9@ ڹZ@ ڹZ@ xl"h
@ G{@ C\@ J#9@ 	k~@ F]d@ eں@ !.I@ !.@ %F
L@ SMj@ 䎊q@ g@ -V@ 빌~($@ C,z@ C,z@ C,z@ ~"@ ۋq
@ ,<@ 7@ eO@ ᰉ'R@ ߤ?@ ҈p;@ /w@ څݘ@ >6z@ `d@ ҽ<64@ т@ _o @ @ ]cA@ @ ǮzH@ g8}@ \(@ s@ 4m@ H˒:@ 
(@ 쿱[@ ~@ }H@ E@ ߤ@ H@ jf@ 0U2a|@ Xy=@ F
L0@ tSM@ 
=p@ wk@ n.3@ h	ԕ@ 	k@ vȴ9@ 쿱[W@ IQ@ Q@ kP|@ 0
)@ +j@ sh@ @N@ :)y@ @ M:@ ҈@ eO@ o h@ F]c@ @ :S@ ~"@ |?@ |PH@ v!.I@ u!R@ tD@ tD@ t#@ qiB@ nO;@ k~($@ iᰉ'@ h	ԕ+@ f,<@ eڹ@ a|Q@ _?@ ^iB@ ]cA @ ]cA @ \(\@ Zݘ@ Vt@ S@ P`A7@ MjOv@ L/{J#@ LcA \@ K)^	@ I^5?}@ GE84@ D*0@ C,zxl@ @4m@ >ߤ?@ :~@ 8Q@ 73@ 7Xe@ 64K@ 4֡a@ 3g	l@ 1o@ 1&x@ 2-V@ 0
(@ .1@ ,1&y@ (@ &L/{J@ $/@ #S&@  -
@ Ov_خ@ PH@ @ sh@ *0U2@ hr @ \(@ 
(@ 
M:@ I^5?@ -
q@ Vu@ 
M:@ @ 
=p
@ #@ {J#9?$tS?lC?s?rGE8?73?MjO?oiDg8?VϪ?C,z?JL?x?>BZc?fA?䎊qj?҈p?"`B?,<?҈p:?N;5?|?+?|?5Xy>?ěS?\(??H˒:?Z?j~#?#w?9XbN?3?9XbN?m\?[W>6?}Vl?zG?B?q?6z?͞&?lD?Xy=?TɅ?*0U2a?lD?d7?͞&?Xy=?zxl"h?
=p?'RT`?kP|?*0?$tT??~($x?q?	 ?YJ???{J#9??4m9?~"?~"?}H˒?{J#9?v_ح?u%F
L?u!R?u%F
L?sg?p:~ ?jOv`?iDg8~?h	ԕ+?e+a?dZ1?ceO?a|Q?]cA ?U=K?S?L/{J#?Fs?As?A [7?>6z?:~?8YJ?6C-?64K?4֡a?6C-?4J?4J?3ߤ?0
(?,zxl"?!R<6?Ov_خ?Q?e+a?Ov_?sP?rGE9?I^5??$/?tj?u%F
?m\?	k~?\(?!-w2?!-w2?E?{m?s?쿱[W??g	?>BZc?䎊qj????,<?Ϫ͞?`A7?N;5?҈p:?䎊?䎊?p:~?p:~?+?*0U?cA \?)^	??m\?74?o i?2W?a@N?\(?n?H˒:?v?<64?A?Y}?Q?Xe?3?m\?2W?O
M?1&y?-?L/{J?3?ae?	k?vȴ9?U=?-V?=K^??IQ?-
?-
?,<?ݗ+k???L_?+I?@4n?IQ?˒:)?b}V?~($x?~($x?}H˒?{J#9?xF]d?u!.?sg?s?r ě?p
=q?m8Y?jOv`?fA?b}Vm?`d8?]ce?]cA ?]cA ?\N;?Y|?W>6z?Vt?W>6z?S?QR?PH?O
M;?L/{J#?I^5?}?F
L/?=b?<쿱[?:~?6C-?4֡a?333333      ?.H?,<쿱?,zxl"?+a@?+jf?)y?'/V?'RT`e?%F
L0?!.H? [6?"h	ԕ? [6?	?[?u%?tj?sh?nO?*0U2?4J?
(?I^5??	ԕ*?_o?#x?73?eں?+?\(?D?!-w2?A [?t?(?C,z???e?ᰉ'R?;dZ???/w?>BZ?E?҈p:?|?͞%?W'?Ƨ-?m\??C?ߤ??)_?Q?|?[W>6?O
M?'RT?U=?>B[?lD?-?S?S&?'RT`?IQ?_F?*0?҉?$tT?qi?qiC?7KƧ?&I?nP?~"?|hr?{m]?xl"h	?v_ح?tj~?u!R?tSMj?rGE85?p
=q?o?qiB?o?nO;?m\?jfB?iDg8~?g8}H?eڹ?dZ1?c	?ae?bM?ae?`d8?[6?YJE?Vl!-?TɅoi?S&?QR?Q?K]cA?H˒:*?E84֡??|hs?84֡b?5?|h?/{J#:?'RT`e?䎊r?C,zx??Xe,?sh?@N?Vu?xF]?	 ѷ?1&x?Fs?_o???u%F
?\N<?PH?!.I?MjO?c	?C]?{m?l?s?D?t?C\?(?hr!?(?C]?ᰉ'?>BZc?VϪ?ᰉ'?,<?ᰉ'R?;dZ???Q_?,<?m?͞%?s?ȴ9Xb?74?C?<64?sg?1&y?6z?d7?Xy=?L/{J?S&?ae?u?=K^?0
)?tj~?-
q??q?C%?'RTa?p:?#?ݗ?YJ?nP?o hی???b}V?xF?u!R?u!.?u!.?qiB?q?q?o?o hۋ?nO;?l"h	ԕ?j~"?hۋq
?h	ԕ+?e+a?bM?^5?|?\>?[6?W&?TɅoi?RT`d?Q_p?PH?NT?JD?IQ?H?H?F
L/?C,zxl?@4m?@4m??|hs?>6z?;5Xy?=p
=?=K]?;5Xy?:)y?6C-?4֡a?/Vϫ?-
qv?+I^?$tSM?"`A?!R<6?Q?6C?e+a?*0?*0?tj?+J?sh?L_?zG?*0U2??*0U2?sh?Z??@N?4J?ߤ??
qu"??
(?I^5??xF]?
L/{?	ԕ*?	ԕ*?	 ѷ?$/?o h?o h??? ѷ?I^5? ѷX? ѷX? ѷX?      ?.H?\N<?m\?#x?	k~?#?hr!?쿱[W??Q?fA?e?iB???ڹY?֡af?As?cA \?˒:)z?)^	?ɅoiD?K]c?Ƨ-?\(???C?[W>?Z?n.?~($???g	l?ᰊ?-V?{?U=?TɅ?,?-?-?'?ae?IQ?R<6?҉?o ?q?qiC?p:?&I?o hی?o hی????nP?nP?{J#9?%2?nP?~"?b}V?IQ?4m9?{m]?wkP?u!.?tj~?sg?rGE85?p
=q?p:~ ?p:~ ?oiDg8?h	ԕ+?hۋq
?hr Ĝ?iB?hr Ĝ?h	ԕ+?ffffff?e+a?d7?d7?dZ1?_حV?[6?Vl!-?TɅoi?QR?QR?NT?L/{J#?H?C\N?A7Kƨ?>BZc ???>BZc ?=K]?84֡b?73?5Xy=?2W?1&x?/{J#:?.H?,<쿱?*0U2a|?+jf?+a@?+a@?*0
?(\)?'RT`e?&x?!-w1? [6? ěT? [6?!-w1?!-w1?!-w1?"h	ԕ?!-w1?!-w1?,=?Q?vȴ?vȴ?e+a?*0?PH?}H?1&?[?,=?[?[?qu!?u%?*0?u?bM?bM?4J?u????ߤ??
(?	k~(?JM?tj?o h?n.?.H?ڹZ?#x?rGE8?D?s?A [?c	?C]?g	?JL?C,z?ᰉ'?ᰉ'??fA?,<???`A7L?C,?ᰉ'R?ᰉ'R?
qu?ڹY?>BZ?Ϫ͞?E?ԕ*1?ԕ*1?E?Ϫ͞?֡af?֡af?fA?,<?ԕ*1?䎊?|?_o ??o i?ěS?8YK?o i?74?TɅo?C?m\?\(?74?&IR?n?
(?
(?
(?
(?vȴ9X?
(?vȴ9X?v?/V?^5?|?Q?'0?ᰊ?-V?O
M?lD?TɅ?-?&?&?'?
=p?
=p?3?쿱[W?쿱[W?%?u"?S??_F??O;d?S&?!R<??~($x?L_?'RTa?&I?nP?}H˒?|hr?|Q?zxl"h
?y(?xl"h	?w1?v_ح?tSMj?qu!S?oiDg8?jfB?hr Ĝ?h	ԕ+?h	ԕ+?g8}H?eO
?ceO?a|Q?_o?]cA ?\(\?Vt?S?QR?PH?Ov_ح?M:?J#9?J#9?I^5?}?H˒:*?IQ?H˒:*?Fs?C$?D*0?C\N?BZc?A7Kƨ??|hs???>6z?>6z?;5Xy?:~?8}H?2a|Q?+a@?+I^?*0
?*0
?(\)?'RT`e?&IQ?%1?$/?$tSM?"`A? ěT?䎊r?䎊r?!-w1?[?C,zx?C,zx?u%?L_?)^??ߤ??
L/{?	 ѷ?1&x??n/?n/?tj?u%F
?u%F
?S&?S&?tj??      ?ڹZ?#x?~$?s?rGE8?Fs?+jg?Y|??쿱[W??x?fA??rGE?lC?e?҈p?ݗ+j?$?"`B?"`B?Q_?b}?sPH?a@O?ѷX?,<?Z?m?ѷX?N;5?`A7?+?͞%?p:~??s?W'?y???2W??\(?TɅo?6?v?<64?j~#?)_?~($?)?rG?)?rG?rG?rG?4m?Xe?4m?Xe?}Vl?Y}?Y}?#w?)?Xe?E?sg?3?'0?}Vl???sg?'0?g	l?g	l?m\?ᰊ?2W?[W>6?'RT?ᰊ?2W?{? ě?1?}Vl?B?TɅ?'?L/{J?o?-
?'RT`?vȴ9?쿱[W?u?wkP?ߤ@?ߤ@?ߤ@?,<?@?R<6?O
M?N;6?-
q?qi??!R<???!R<?O;dZ??C%?eO?ݗ?M:?%2??IQ?b}V?~$t?}Vl!?{J#9?y(?xF?xF?xl"h	?wkP?wkP?w1?u%F
L?sg?sg?sPH?rGE85?sPH?qu!S?oiDg8?k~($?j~"?hۋq
?e+a?e+a?dZ1?a@N?`A7K?_Ft?^5?|?]cA ?]cA ?]ce?\(\?\N;?[6?Zݘ?YJE?U2a|?SMj?R<64?Q_p?O;dZ?MjOv?MjOv?MjOv?MjOv?O
M;?O;dZ?O;dZ?Ov_ح?M?L/{J#?L/{J#?IQ?GE84?GzH?H?H˒:*?GE84?F
L/?Dg8}?C,zxl?BZc?=b?<64?8}H?5Xy=?4m8?4J?3ߤ?333333?2W?6z?2W?2W?2a|Q?1o?1o?1o?1-?1-?1-?2W?/Vϫ?/v?.2X?-w1?-
qv?.2X?/v?/v?/Vϫ?.2X?-V?+jf?*0U2a|?(?&x?*0
?(\)?'/V?&?%F
L0?$tSM?"`A?䎊r?!-w1?qu!?6C?*0??zG?sP?n?u?4J?4J?u?nO?bM?'/W?
qu"?xF]?xF]?
=p
?	ԕ*?K]d?Fs?n/??Fs?$/?S&?o h?S&?tj? ѷ? ѷX?      ?\N<?m\?\N<?!.H?m\?~$?>B?	k~?73?!.I?+jg?\(?Y|?+?	k~?	k~?	k~?+?Fs?#?MjO?+?\(?D?MjO?E?{m?s?l??c	?Q?ᰉ'?ᰉ'?x??>BZc?,<?1.?,<?`A7L?䎊qj?S?e+?Gz?҈p?u!?ߤ??҈p;?ݗ+j?$?ڹY?ڹY?ڹY?b}?حU??fA?E?,<?Z?ѷX?As?As?As?As?p:~?5Xy>?ɅoiD??@?8YK?m\???)^?ȴ9Xb?@?)^?ȴ9Xb?ȴ9Xb?ȴ9Xb?K]c?y?)^?)^?Ƨ-?m\?m\?o i?ěS?ěS?a@N?C?
(?v?<64?Z?Z?)_?~($?~($?Y}?^5?|?^5?|?Y}?)?rG?rG?E?3?'0?3?-V?2W?[W>6?'RT?'RT?r?1?O
M?r?}Vl?U=?1&y?lD??*0U2a?TɅ?TɅ??d7?6z?6z?d7???lD?-?'?L/{J?'?
=p?S&?S&?3?u?
=p?3?	k?vȴ9?쿱[W?-
?-V?u"?S?u%F?R<6?Fs?-
q?hr ?$tT?hr ?o ?-
q?hr ?$tT?Mj??q?	 ?7KƧ?7KƧ?'RTa?qiC?'RTa?'RTa?7KƧ?+I?ݗ?nP?@4n??o hی?4m9?4m9?~$t?~($x?|??y=b?wkP?vȴ9X?w1?u!R?u%F
L?tj~?tj~?tj~?u!.?sg?sPH?sPH?q?o hۋ?o hۋ?n.2?m\?k~($?kP{?k~($?k~($?k~($?k~($?k~($?kP{?kP{?kP{?jfB?iB?k~($?j~"?iB?iB?iDg8~?hr Ĝ?g	k?g8}H?g8}H?ffffff?e+a?fA?fA?g	k?h	ԕ+?fA?eڹ?ceO?b}Vm?d7?dZ1?ceO?ae?a|Q?`d8?`A7K?_o?dZ1?ae?bM?a|Q?_حV?]ce?\(\?[W>6z?_Ft?^?]cA ?\(\?[W>6z?YJE?Xy=c?XbM?Xy=c?Y|?YJE?Y|?YJE?XbM?W>6z?U=K?U2a|?U2a|?U2a|?U2a|?TɅoi?Vl!-?Vt?Vt?U2a|?TɅoi?TɅoi?S?R<64?QR?U=K?U=K?U=K?U2a|?S?QR?P{?SMj?RT`d?Q_p?O;dZ?N;5X?L/{J#?K]cA?K]cA?K]cA?K]cA?JD?JL_?IQ?H˒:*?GzH?H?GE84?E?E84֡?Fs?GE84?GzH?GzH?H?H?GzH?GE84?F
L/?D*0?C$?F]cf?E84֡?C\N?As?@NU?????>6z???>6z?>BZc ?=p
=?=K]?<쿱[?<64?<64?<64?<쿱[?<쿱[?<쿱[?<쿱[?<쿱[?<쿱[?=p
=?=p
=?=p
=?=b?=b?>BZc ???>BZc ?=K]?;dZ???=p
=?=p
=?<쿱[?;5Xy?;dZ?:)y?9XbM?>6z?>BZc ?=K]?;5Xy?:S&?73?6z?6C-?5Xy=?4֡a?4֡a?4m8?4J?2W?2a|Q?1o?1&x?1o?1&x?1&x?0
(?/Vϫ?/{J#:?/{J#:?/{J#:?/v?1o?1&x?1&x?0
(?0U2a|?/{J#:?.2X?2W?2a|Q?2a|Q?0
(?/Vϫ?/v?/v?-
qv?0
(?0
(?0U2a|?/{J#:?.H?.H?.2X?/v?.2X?/v?/v?/v?.H?-
qv?,zxl"?*0
?)^?(\)?(\)?(?($xG?(\)?($xG?($xG?(\)?*0U2a|?*0
?*0
?*0
?+I^?*0
?*0
?+I^?+I^?,<쿱?,<쿱?*0
?*0
?*0
?+jf?+jf?+I^?*0
?+I^?,<쿱?+jf?,<쿱?+a@?+I^?+jf?+I^?*0U2a|?)^?)y?(\)?(?(?'/V?'RT`e?&x?&x?&IQ?(?'/V?'RT`e?'/V?($xG?(?($xG?'/V?&IQ?%F
L0?,zxl"?,zxl"?,<쿱?+a@?+a@?*0
?)^?)y?+I^?+jf?+a@?,zxl"?,zxl"?,<쿱?+a@?+I^?*0U2a|?-V?+a@?+I^?(?($xG?&x?(\)?)y?(?&x?%F
L0?$xF?$xF?!R<6? [6?	?Q?Q?!-w1?!-w1?!-w1?!-w1?Q?,=?,=?}H?,=?,=?Ov_خ?#wk?#wk?"h	ԕ?"h	ԕ?!R<6?!-w1?䎊r?Ov_خ?C,zx?Ov_خ?,=?}H?[?C,zx?qu!?u%?6C?Ov_خ?,=?1&?u%?6C?_o?Q?qu!?u%?6C?PH?*0?e+a?PH?tj?*0?+J??PH??Ov_?tj?*0?*0?Xe,??Ov_?sh?L_?zG?Z??zG?L_?L_?Z?Z??*0U2?Ov_?L_?*0U2?sP?n?bM?)^?u?nO?sP?nO?nO?nO?nO?Z?*0U2?*0U2?*0U2?sP?4J?4J?sP?@N?@N?sP?n??'/W?n?4J?)^?rGE9?rGE9?rGE9?'/W?ߤ??ߤ???sP?@N?sP?sP?nO?n?u?4J?bM?bM?sP?u?4J?4J?u?4J?4J?rGE9?ߤ??ߤ??ߤ??ߤ??ߤ??'/W???'/W?'/W?rGE9?bM?)^?)^?bM?bM?bM?4J?4J?u?bM?bM?rGE9?rGE9?)^?bM?4J?sP?zG?Z?Z?zG?@N?sh?+J?Ov_?+J?+J?+J?L_?zG?*0U2?zG?Ov_?L_?L_?L_?Z?L_?sh?Ov_?+J???+J?Ov_?sh?tj?tj?tj??Xe,??+J?+J???Xe,?Ov_?Ov_?L_?L_?Z?sh?Ov_?+J?+J?+J????Xe,??tj?PH?_o?_o?e+a?tj?*0?_o?Q?vȴ?vȴ?u%?vȴ?vȴ?u%?qu!?qu!?u%?C,zx?,=?Ov_خ?Q?Q?Q?Ov_خ?,=?}H?[?Q?!-w1?!-w1?Q?!-w1?Ov_خ?Q?Ov_خ?[?,=?Ov_خ?Ov_خ?,=?,=?,=?,=?Q?!-w1?!-w1?Q?!-w1?!-w1?	?	?䎊r?䎊r?	?	?,=?Ov_خ?}H?Ov_خ?Q?Q?Q?Q?Q?!-w1?Q?,=?Ov_خ?,=?Ov_خ?,=?Q?Q?!-w1?!-w1?	?Q?Ov_خ?Q?!-w1?!-w1?!-w1?!-w1?!-w1?!-w1?!-w1?	?!-w1? [6? [6?	?䎊r?䎊r?䎊r?䎊r?䎊r?䎊r?	? [6? ěT?!.H?#9?$tSM?%F
L0?%F
L0?%F
L0?$/?#wk?#wk?"`A?#9?&x?$tSM?$xF?$/?%F
L0?%1?%1?%F
L0?$/?$tSM?%F
L0?%F
L0?&?%1?$/?%1?'RT`e?($xG?(?($xG?'RT`e?&IQ?&?&?)^?(?(?(\)?(?'/V?'/V?'/V?'RT`e?&x?&IQ?&IQ?'/V?(\)?(\)?)^?*0U2a|?+I^?+jf?+a@?+a@?+I^?+jf?*0U2a|?+jf?/v?.2X?-
qv?.H?.H?-
qv?,zxl"?+a@?+a@?,<쿱?+a@?+I^?+I^?+jf?+jf?+a@?+a@?,<쿱?,zxl"?,zxl"?-w1?-V?-V?-w1?.H?.H?/v?/Vϫ?1&x?2a|Q?333333?3ߤ?333333?2W?1-?3ߤ?7KƧ?5Xy=?64K?64K?64K?5Xy=?5?|h?4m8?4m8?4J?4m8?5Xy=?6z?7KƧ?8}H?8}H?73?7KƧ?8}H?8YJ?8YJ?9D?:~?;5Xy?<64?<쿱[?<64?;5Xy?<64?>BZc ?=b?=b?=b?>BZc ?>6z???????@NU???@NU?@4m?A [7?As?C,zxl?C\N?E84֡?Fs?F]cf?Fs?F]cf?F]cf?F]cf?Fs?E?E84֡?H?I^5?}?H?H?H?H?I^5?}?J#9?JL_?JL_?J#9?JL_?L_?M:?L_?M:?L/{J#?L/{J#?M:?N;5X?NT?NT?MjOv?M:?M:?M:?MjOv?N;5X?PH?Q_p?Q_p?Q?Q?Q?Q?QR?SMj?T`d?T`d?TɅoi?U2a|?U2a|?U2a|?U=K?Vl!-?Vt?XbM?YJE?Z1'?Z1'?Z1'?Y|?Zc	?^5?|?]ce?]ce?\N;?\(\?\N;?\>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @@\C,zx@@\I^5?@@\PH@@\PH@@\SMj@@\PH@@\SMj@@\VϪ@@\VϪ@@\SMj@@\VϪ@@\VϪ@@\Z1@@\Z1@@\Z1@@\VϪ@@\Z1@@\Z1@@\SMj@@\VϪ@@\Z1@@\VϪ@@\PH@@\Z1@@\VϪ@@\SMj@@\PH@@\VϪ@@\VϪ@@\SMj@@\VϪ@@\VϪ@@\VϪ@@\SMj@@\VϪ@@\VϪ@@\]ce@@\Z1@@\Z1@@\Z1@@\VϪ@@\SMj@@\`d@@\g8}@@\j~#@@\j~#@@\cA \@@\`d@@\C@@\C@@\qj@@\N;@@\N;@@\N;@@\N;@@\*1@@\*1@@\*1@@\*1@@\*1@@\*1@@\*1@@\S@@\쿱[@@\S@@\쿱[@@\S@@\쿱[@@\zxl"@@\_@@\3@@\쿱[@@\3@@\3@@\3@@\zxl"@@\1&@@\TɆ@@\TɆ@@\TɆ@@\O
M@@\O
M@@\@@\@@\j~@@\[W?@@\7@@\7@@\7@@\7@@\@@\֡a@@\u"@@\JM@@\e@@\>@@]:@@]V@@][@@]qu"@@]2a|@@]B@@]w1@@]?@@^$t@@`K]c@@dSMj@@|hr@@?@@PH@@cA @@E@@S@@ȴ9X@@Xe@@ٺ^5?}@@6@@9XbN@@ ѷY@@'/W@@@@C@@-w1@@n.@@2W@@	 @@㯷@@㹌~($@@!-w2@@wkP@@TɆ@@TɆ@@7@@/w@@IQ@@Y|@@`A7L@@凓ݗ@@Ov_@@R<6@@Ϫ͞@@L_@@>B[@@(\@@㢜wk@@,<@@C@@@@u@@$/@@?@@ڹ@@ȴ9X@@@@YJ@@Gz@@x@@:S@@	k@@譫U@@{@@艠'RT@@*0@@/V@@y@@U=@@U=@@	k@@bM@@e+@@JE@@|Q@@|@@D@@馵(@@oiD@@@@	 @@lD@@I^5@@	 @@@@u%F@@GE85@@GE85@@-V@@3@@-V@@)y@@1'@@0U2a|@@)^	@@/V@@)^	@@33333@@/V@@,zxl@@"`B@@33333@@"`B@@҉@@"`B@@s@@S&@@74@@c	@@9@@,zxl@@MjO@@dZ@@a@O@@\N@@!-w2@@1&y@@SMj@@E@@[@@F
L0@@}H@@hr!@@힃%@@=K@@@@ڹ@@\N<@@2X@@
M;@@O
M@@eں@@H˒:@@+@@}Vl@@;5X@@E@@p:~@@YJ@@+J@@T@@ȴ9X@@Ϫ͟@@Ϫ͟@@҈p;@@1@@x@@Ϫ͟@@ߤ?@@l!-@@H@@H@@}Vl@@%@@%@@+J@@,<@@A@@v@@?@@o @@fA@@+j@@*0@@4m@@ѷX@@/V@@wk@@S@@m]@@5Xy@@@@(\@@(\@@64@@Z1@@PH@@cA \@@wkP@@?@@S@@@@e@@:@@V@@/w@@/w@@F
L0@@sg@@sg@@zxl"h@@ݗ@@ڹZ@@%@@sh@@@@,=@@u@@?@@E@@YJ@@vȴ9X@@p:~@@z@@Ϫ͟@@
=p@@)^@@!-w1@@8}H@@sPH@@-V@@+@@;dZ@@@@Vϫ@@@@bM@@$xG@@73@@[6@@˒:*@@{@@TɅ@@`A7@@@@7KƧ@@e+a@@x@@R<6@@@@|@@N;6@@e@@iB@@Y}@@Ov`@@T`d@@u%F
@@~"@@u%F
@@h	ԕ@@W'@@Zc@@h	ԕ@@wkQ@@@@Y@@<64@@ ѷ@@m@@sP@@W@@ڹY@@D@@Z@@~$@@:)z@@wk@@E@@
=p@@g@@C]@@xF@@tj@@2W@@tSM@@*1@@?@@֡a@@Q@@Y|@@cA @@\(@@!.@@t@@_o @@_o @@
(@@!R<@@?@@E@@p:~@@+J@@2X@@x@@&@@͞@@@A 	ԕ+@A K]c@A _F@A u!@A @A U@A )^@A ѷX@A 4֡b@A*0U2a@Ao hی@AoiD@A'RTa@A(@Al@AB@A|@A@AD@An@A^5?|@Ap:@AL/{@AD@AMjO@Ag	l@AS@AQ@A2W@A?@Ag8}@A1&@A>B[@AV@AB@AfA@Asg@AM:@AU=@A
qv@AL/{J@Afffff@A@A@A]cf@A1@AFs@AFs@A"@A
M;@A$tS@A8}H@Ab}V@A&@A	k@A[W>@A@ArG@A@AU2a|@Ay=c@A@Ad8@A{@A@@AѷX@Aۋq
@A	k@A	N;5@A	'RTa@A	iB@A
u%F@A
s@A
&IR@A
@4n@A
W'@A
u%F
@A
wkQ@A
,<@A	@A6z@AdZ@Aqu!@A@A$@AS@Aq@A@A~($@A6@AZ@AQ@A%2@AC]@As@Aߤ@@AL_@Atj@A?@AwkP@Azxl"@A7@AD@A
'0@A
5Xy>@A
jOv@A
O
@A
-V@A
8Y@A
b@AzG@AOv_@A($x@A+jg@A\N<@Aaf@A'@Ax@A!-w1@Av@A'/W@Ab}V@A&@AzH@A+@A*0U@A-
q@A[6@A-
@Ad8@A9Xb@AC@A$tT@A	k~@A+@A:S@AA [@ATɅo@Ao hی@A|Q@A~($@A@An.@A'R@Ao@AiB@AlD@A-V@A@4n@A^5?|@AnO@A@4@A\(@AS&@AS&@AL/{@Ag	@Ag	@Am\@As@A)^	@A/V@AJ#9@Aa@N@A]cA@Ag	l@Atj~@A{J#9@AE@A@Atj@A,<@AC,zx@AcA \@Aj~#@AS@A7@A/@A!-w@A+a@AF
L0@AS&@A\@A`A7L@AjOv@Azxl"h@AO
@A@Aڹ@A+jg@AH@Afffff@Ap:~@As@A}Vl@Az@A%@A%@A@Aaf@A&I@AϪ͟@A쿱[W@A!.I@A@A.H@AO
M@A_o@A&@A͞@A@@A-@A+j@AF]d@A6@A'RT`@A*0@A*0@A1&x@A73@ANU@A_F@AeO@AeO@Ahۋq@Ay=c@A-
@A
=q@A
(@AF@A{@A$tT@ArGE@A&x@AQ@A[W>6@Aae@Ab}@AoiD@A@AB@AD@A@Aᰉ'@AY}@A.H@Au%F@A	 @As@A1'@A=p
@AJL@AQ_@A^5?|@A~"@Aᰊ@AwkQ@A ě@A33333@AP{@AP{@AP{@AMjO@AS@AZ@Aa@N@A@A@A|@A
=p@AQ@AlC@As@AM:@Aj~#@AtSM@Aqj@A?@A/@A>@A(@AO;dZ@AS&@AjOv@Aw1@Aݗ@A%@A-V@A@AH˒@AϪ͞@Ab@A4K@A.2@AiB@A@At@AXe@A$tS@A.H@A8}H@AO
M@A/V@A@A˒:)@A@@A䎊r@A 'RT`@A :~ @A H@A U2a|@A r Ĝ@A tj@A )@A p:@A D@A e+@A {@A \)@A!$/@A!_p@A!JE@A![W>6@A!hr @A!rGE8@A!7Kƨ@A!X@A!@A!2W@A!_o@A!@A!s@A!ᰉ'@A!R@A"䎊@A"0U2a|@A"GE85@A"M@A"T`d@A"^5?|@A"{m@A"@4@A"S&@A"0
@A"L/{@A"L/{@A"g	@A"<64@A",<@A"C,@A"m\@A#u%@A#/V@A#a@N@A#dZ@A#dZ@A#g	l@A#$@A#A@A#U=@A#S@A#@A#m]@A#%2@A$tj@A$,<@A$Q@A$Q@A$(\@A$<쿱@A$<쿱@A$?@A$C,zx@A$PH@A$]ce@A$zG@A$qj@A$S@A$1&@A$?@A$>B[@A$JM@A$>@A%!.H@A%84֡@A%B@A%Vl!@A%sg@A%!R@A%@A%
qv@A%!.@A%E@A%C\@A%!.@A%ڹ@A&t@A&zG@A&4K@A&?@A&Vu@A&vȴ9X@A&z@A&%@A&+J@A&qi@A&@A&'@A&Ϫ͟@A&]cf@A&]cf@A&@A&@A&Fs@A&!.I@A'@A'!-w1@A'.H@A'8}H@A'8}H@A'>6z@A'KƧ@A'\(@A'iDg8@A'y@A'O;d@A'O;d@A'	@A'ݗ+@A'kP@A'&@A'+j@A($xG@A(:~ @A(:~ @A(Q@A(|@A(@A(@A(@A(ěT@A(ěT@A(PH@A(PH@A) ѷ@A)$/@A) ѷ@A)@A)@N@A)@N@A)#w@A):S@A)A [@A)Gz@A)k~(@A)|Q@A)@A)o@A)'RTa@A)B@A)ԕ*@A)"`@A)e@A)>BZ@A)>BZ@A)Y}@A*I^5@A*s@A*1'@A*0U2a|@A*3@A*@4n@A*JL@A*JL@A*T`d@A*W'@A*^5?|@A*d7@A*nO@A*qiC@A*qiC@A*@4@A*ݘ@A*0
@A*vȴ@A*@A*g	@A*g	@A*W@A*䎊q@A*m\@A+I^@A+	@A+6z@A+9@A+J#9@A+F]c@A+dZ@A+jf@A+tj~@A+@A+ߤ@A+m]@A+Z@A+6@A+Ƨ@A+5Xy@A+A [@A+@A,n.@A,@A,"h	ԕ@A,(\@A,/{J#@A,I^5?@A,cA \@A,g8}@A,m8@A,zG@A,~($x@A,_@A,1&@A,1&@A,#x@A,?@A,֡a@A,!-w@A,!-w@A,e@A-:@A,>@A-o i@A-o i@A-u@A-Q@A-(@A-?|h@A-S&@A-`A7L@A-fA@A-}H@A-$/@A-+j@A-=K@A-Xy=@A-n/@A-H˒@A-@A-@A-,=@A-!.@A..2@A.;5X@A.E@A.H@A.iB@A.qi@A.,<@A.T@A.-@A.'@A.&I@A.A@A.ߤ?@A.1@A.@A.Mj@A.Fs@A/ hۋ@A/
=p@A/@A/!-w1@A/+I@A/As@A/RT`e@A/U=@A/_o@A/y@A/zH@A/?@A/	k@A/[W>@A/@A/@A/-@A0     @A0@A0@A0}H@A0*0@A0*0@A073@A0-
q@A04m9@A0>BZc@A0H@A0D*@A0u!@A0n@A0YJ@A0@A0)@A0TɅ@A0@@A0F@A0ۋq
@A0e+@A0C@A1@N@A1@A1_p@A1 [7@A1#w@A1*0U2a@A14J@A1=b@A1XbM@A1|Q@A17Kƨ@A1n.@A1B@A1^5?}@A1^5?}@A1N;6@A1_o@A1ᰉ'@A1ᰉ'@A1R@A1Y}@A1-@A2I^5@A2@A2s@A2䎊@A2)y@A23@A2=p
@A2JL@A2T`d@A2W'@A2qiC@A2~"@A2\(@A2S&@A2\(@A20
@A2 ě@A2W@A2W@A2,<@A2fB@A2C,@A274@A3s@A3	@A3"`B@A3)^	@A3)^	@A3,zxl@A333333@A3=K^@A3W>6z@A3S@A3Z@A3dZ@A3jf@A3n.3@A3n.3@A3qu!@A3n.3@A3~$@A3wk@A4J@A4(\@A464@A4C,zx@A4M:@A4`d@A4g8}@A4m8@A4tSM@A4o h@A43@A4zxl"@A4zxl"@A4TɆ@A4j~@A4j~@A4?@A4@A4֡a@A4Z@A4֡a@A4D@A4e@A4>@A4E@A5o i@A5[@A5(@A584֡@A5B@A5F
L0@A5L_@A5Vl!@A5`A7L@A5fA@A5m\@A5w1@A5ݗ@A5Xy=@A5v@A5@A5S@A6 ѷY@A6zG@A64K@A6zG@A6u@A6($x@A6Ov_خ@A65?|@A68YJ@A68YJ@A6R<6@A6YJ@A6c	@A6s@A6p:~@A6IQ@A6qi@A6'@A6@A6Q@A6Q@A6ߤ?@A6m\@A6]cf@A6C-@A61@A6x@A6@A7 hۋ@A7Ft@A7,@A7,@A7$tS@A7>6z@A7H˒:@A7Xe,@A7_o@A7lC@A7-V@A7vȴ9@A7K]d@A7˒:)@A7@A7@A7@A7+j@A8@A8
qu@A8@A8}H@A8'RT`@A8-
q@A81&x@A8D*@A8K]c@A8Q@A8bM@A8l"h	@A8r Ĝ@A8|@A8n@A8@A8-
@A8-
@A8tj@A8u%F@A8-
@A8@A89Xb@A89Xb@A8TɅ@A8ۋq
@A8`A7@A8`A7@A84֡b@A8	k@A9 ѷ@A9rGE@A9@N@A9@N@A9@N@A9 [7@A9Dg8~@A9^@A9[W>6@A9^@A9XbM@A9^@A9ae@A9hr @A9e+a@A9hr @A9|Q@A9~($@A9~($@A9@A9'RTa@A9@A9^5?}@A9^5?}@A9^5?}@A9@A9D@A9o@A9N;6@A9iB@A9e@A9R@A9s@A9s@A9-@A:	 @A:䎊@A:䎊@A:&IR@A:-V@A:3@A:=p
@A:=p
@A:C\@A:GE85@A:Q_@A:a|Q@A:d7@A:d7@A:nO@A:@4@A:p:@A:L_@A:L_@A:ᰊ@A:ᰊ@A:S&@A:0
@A:vȴ@A:wkQ@A:L/{@A:@A:<64@A:͞&@A:ڹY@A:`A@A:G{@A:c	@A:m\@A;nP@A;,zxl@A;6z@A;J#9@A;MjO@A;W>6z@A;~$@A;:)z@A;*0U2@A;E@A;~($@A;6@A;5Xy@A;ݗ+k@A;g@A;A [@A;$@A<@A<!-w2@A<%1@A<(\@A</{J#@A<2W@A<?@A<PH@A<SMj@A<]ce@A<`d@A<g8}@A<tSM@A<wkP@A<o h@A<?@A<쿱[@A<쿱[@A<zxl"@A<TɆ@A<@A<?@A<*0@A<JM@A<Z@A<@A<JM@A<!-w@A<E@A='0@A=[@A=*0@A=!.H@A=+a@A=<64@A=<64@A=<64@A=F
L0@A=IQ@A=IQ@A=F
L0@A=L_@A=O;dZ@A=L_@A=L_@A=S&@A=O;dZ@A=Y|@A=\@A=fA@A=p
=@A=ڹZ@A=+j@A=+j@A=@A=v@A=n/@A=H˒@A=H˒@A=@A=b@A=oiDg@A=!.@A> ѷY@A>_o @A>
L/@A>
L/@A>@A>@A>!R<@A>$/@A>($x@A>+jg@A>$/@A>.2@A>5?|@A>;5X@A>BZc @A>H@A>E@A>?@A>E@A>Ov_خ@A>Ov_خ@A>R<6@A>_ح@A>c	@A>iB@A>iB@A>l!-@A>s@A>vȴ9X@A>IQ@A>,<@A>T@A>@A>ߤ?@A>&I@A>+@A>x@A>"@A? hۋ@A?@A?Ft@A?@A?,@A?'/W@A?1@A?+I@A?8}H@A?8}H@A?As@A?U=@A?U=@A?_o@A?_o@A?eں@A?lC@A?y@A?4m@A?&@A?&@A??@A?zH@A?͞@A?3@A?r@A?vȴ9@A?/V@A?@A?+@A?حV@A?@A?Vϫ@A?-@A?#@A@     @A@	ԕ+@A@@A@
qu@A@bM@A@}H@A@
qu@A@@A@$xG@A@'RT`@A@A7K@A@Q@A@[6@A@bM@A@n@A@'RT@A@'RT@A@tj@A@IQ@A@IQ@A@-
@A@
=q@A@@A@@A@
=q@A@U@A@)@A@TɅ@A@
(@A@@@A@p:@A@ѷX@A@D@A@e+@A@C@A@	k@A@	k@AA ѷ@AA$/@AA@AA@AA&x@AA-w1@AA4J@AATɅo@AAae@AAk~(@AAk~(@AAo hی@AArGE8@AAoiD@AA@AA@AAn.@AAn.@AA'RTa@AAB@AAB@AAX@AA@AA2W@AAo@AA@AA-@AA.H@ABu%F@AB	 @AB	 @ABOv`@ABs@AB䎊@AB6C@ABC\@ABC\@ABT`d@ABZc@ABZc@ABh	ԕ@ABnO@ABnO@ABu%F
@AB~"@AB~"@ABL_@ABvȴ@ABL/{@ABS&@ABL/{@AB}Vm@AB<64@AB@ABW@AB͞&@ABG{@ABC,@ABD@ABm\@ACS&@ACu%@ACS&@ACu%@AC҉@AC'/@ACPH@AC)^	@AC33333@AC9@AC@N@AC@N@ACJ#9@ACW>6z@AC]cA@ACS@ACdZ@ACtj~@ACq@AC:)z@AC:)z@AC:)z@ACߤ@ACA@ACU=@AC*0U2@ACS@AC*0U2@ACS@AC*0U2@ACm]@ACZ@ACZ@ACZ@AC@AC5Xy@AC|@ACa@@AC
=p@AC҈@AC҈@AClC@AC҈@AC%2@ACg@ACC]@ACA [@AC@AC@AC@AD1&y@ADn.@AD1&y@ADtj@AD"h	ԕ@AD!-w2@AD!-w2@AD"h	ԕ@AD"h	ԕ@AD,<@AD/{J#@AD2W@AD64@AD9XbN@ADI^5?@ADVϪ@ADcA \@ADm8@AD~($x@AD?@ADC@ADC@AD#@AD_@ADS@AD3@ADO
M@AD[W?@AD7@ADɅoi@ADZ@AD/@AD@AD!-w@ADE@AEo i@AE'0@AEu@AE*0@AE!.H@AE!.H@AE(@AE!.H@AE(@AE(@AE/w@AE?|h@AEL_@AES&@AE\@AEce@AEjOv@AEm\@AEfA@AEp
=@AEp
=@AEp
=@AEw1@AEw1@AEzxl"h@AEO
@AE@AE@AEv@AEv@AEXy=@AEXy=@AEH˒@AEcA @AE8YK@AE@AE8YK@AE
qv@AEᰉ@AEE@AEC\@AF ѷY@AF4K@AFzG@AF!R<@AF+jg@AF+jg@AF1.@AFOv_خ@AFL/{J@AFR<6@AFR<6@AFYJ@AFl!-@AF_ح@AFs@AFl!-@AFp:~@AFIQ@AF%@AF+J@AFqi@AF%@AFIQ@AF+J@AF+J@AF$t@AF+J@AF@AF-@AF6z@AF6z@AF-@AF-@AF'@AFQ@AF&I@AFȴ9X@AFt@AFA@AF+@AFC-@AF1@AF쿱[W@AFFs@AFMj@AFFs@AG hۋ@AG
M;@AG
M;@AGXe@AG,@AG+I@AG1@AG4֡a@AG4֡a@AG8}H@AG8}H@AGAs@AGH˒:@AGU=@AGU=@AG\(@AGlC@AGv_ح@AGv_ح@AG|hs@AG@AG@AG@AGݗ+@AGݗ+@AGݗ+@AG-V@AG?@AG	k@AG?@AG͞@AG[W>@AG3@AGr@AG@AGK]d@AG+@AG@AGحV@AG;dZ@AGVϫ@AG䎊r@AG#@AGrGE9@AHF]d@AH@AH
qu@AHbM@AH ě@AH$xG@AH'RT`@AH$xG@AH'RT`@AH1&x@AH73@AHA7K@AHD*@AHNU@AHQ@AHXy=@AHhۋq@AHl"h	@AHl"h	@AHoiDg8@AHoiDg8@AHu!@AHy=c@AH'RT@AH-
@AH@AH
=q@AHd8@AH
=q@AHU@AHU@AH4m@AH
(@AHěT@AHѷX@AHF@AH҈p@AH@AH@AH@AHC@AH4֡b@AH{@AHPH@AH$tT@AI	k~@AI ѷ@AIrGE@AI [7@AI&x@AI [7@AI&x@AI&x@AI0
)@AI:S@AIN;5@AIQ@AIQ@AI[W>6@AI^@AIe+a@AIhr @AIk~(@AIrGE8@AI[W>6@AIo hی@AIo hی@AIrGE8@AI|Q@AI|Q@AI~($@AI@AIn.@AI'RTa@AI'RTa@AIn.@AI(@AI'R@AIX@AI^5?}@AI^5?}@AI^5?}@AID@AI@AI2W@AI_o@AI@AI"`@AI"`@AI"`@AIe@AIR@AIR@AI>BZ@AIY}@AI-@AIY}@AI-@AJu%F@AJu%F@AJ	 @AJI^5@AJs@AJ#9@AJe+@AJOv`@AJ1'@AJ1'@AJ1'@AJ䎊@AJ#9@AJ#9@AJ&IR@AJ&IR@AJ)y@AJ&IR@AJ)y@AJ)y@AJ)y@AJ)y@AJ0U2a|@AJ6C@AJ@4n@AJ@4n@AJJL@AJM@AJQ_@AJT`d@AJT`d@AJ^5?|@AJa|Q@AJa|Q@AJd7@AJa|Q@AJkP|@AJh	ԕ@AJkP|@AJnO@AJu%F
@AJqiC@AJxl"h
@AJxl"h
@AJ{m@AJ{m@AJ@4@AJp:@AJp:@AJ\(@AJ\(@AJ\(@AJᰊ@AJwkQ@AJvȴ@AJ>B@AJ@AJ}Vm@AJ<64@AJ)_@AJ@AJW@AJ`A@AJ,<@AJڹY@AJڹY@AJ ѷ@AJڹY@AJ ѷ@AJ ѷ@AJ䎊q@AJfB@AJ䎊q@AJ~@AJm\@AKI^@AKS&@AKs@AKPH@AKs@AKs@AK"`B@AK"`B@AK)^	@AK)^	@AK33333@AK9@AK=K^@AK=K^@AK@N@AKC%@AK@N@AKJ#9@AKJ#9@AKMjO@AKW>6z@AK]cA@AKdZ@AKg	l@AKtj~@AKtj~@AKtj~@AKqu!@AKtj~@AKtj~@AK~$@AK{J#9@AKxF]@AKxF]@AK~$@AK~$@AK@AKq@AKq@AKq@AK:)z@AKA@AK$@AKߤ@AK$@AKU=@AK$@AKU=@AKq@AKwk@AKS@AK*0U2@AK*0U2@AKq@AKq@AKE@AK~($@AKa@@AKƧ@AKƧ@AKƧ@AK@AK5Xy@AK@AK5Xy@AKa@@AK|@AK@AKƧ@AK
=p@AKݗ+k@AK%2@AKlC@AK%2@AKA [@AK@AKs@AKs@AK\N@AKs@AK\N@AK\N@ALJ@AL1&y@ALxF@AL@AL@ALߤ@@AL@ALtj@AL!-w2@AL%1@AL(\@AL,<@AL,<@AL/{J#@AL/{J#@AL2W@AL64@AL<쿱@AL?@AL9XbN@ALC,zx@ALC,zx@ALM:@ALPH@ALM:@ALSMj@ALZ1@AL]ce@AL]ce@ALg8}@ALm8@ALq@ALq      @ALo h@AL~($x@AL~($x@AL~($x@AL~($x@AL?@AL#@AL?@ALC@ALN;@ALqj@AL_@AL*1@AL_@AL쿱[@ALS@AL3@AL3@ALO
M@ALTɆ@AL#x@AL@AL?@AL#x@AL?@AL@AL֡a@ALZ@AL֡a@AL֡a@AL֡a@AL/@ALZ@ALu"@ALJM@AL@ALD@ALD@ALD@ALe@ALe@AMK]@AM:@AMu@AM[@AMu@AM[@AM%F
L@AM!.H@AM%F
L@AM!.H@AM%F
L@AM+a@AM+a@AM5Xy>@AM<64@AM?|h@AMB@AMF
L0@AMB@AMIQ@AML_@AMS&@AMS&@AMS&@AM\@AM\@AMce@AMce@AMp
=@AMsg@AMsg@AMsg@AM$/@AM$/@AMݗ@AMݗ@AMhr!@AMO
@AM+j@AM+j@AM=K@AM@AMv@AMv@AMXy=@AMXy=@AMU=@AM%@AM1@AM1@AMU=@AM-V@AM-V@AMsh@AM@AMH˒@AMH˒@AMH˒@AMH˒@AM8Y@AM8Y@AMϪ͞@AMcA @AM8YK@AMϪ͞@AMb@AM?@AMᰉ@AM,=@AMᰉ@AM(@AM!.@AN ѷY@ANt@AN
L/@ANzG@AN!R<@AN!R<@AN.2@AN.2@AN1.@AN5?|@AN?@AN?@ANE@ANBZc @ANL/{J@ANOv_خ@ANL/{J@ANH@ANR<6@AN\N<@ANVu@ANl!-@ANiB@ANl!-@ANl!-@ANp:~@ANl!-@ANfffff@ANp:~@ANl!-@ANvȴ9X@ANs@ANl!-@ANs@ANvȴ9X@ANvȴ9X@AN}Vl@ANz@AN+J@AN@ANFs@ANFs@ANFs@AN@AN,<@AN@AN'@ANaf@AN-@AN2X@AN'@AN@ANȴ9X@ANϪ͟@AN҈p;@AN҈p;@AN]cf@AN+@AN1@ANߤ?@ANx@AN쿱[W@AN@ANFs@AO hۋ@AO
=p@AO@AOFt@AO
=p@AO
=p@AO
=p@AO@AO@AO@AO@AOXe@AOXe@AO,@AO,@AO'/W@AO$tS@AO'/W@AO+I@AO1@AO1@AO1@AO4֡a@AO4֡a@AO1@AO;dZ@AO;dZ@AO>6z@AOE84@AOH˒:@AORT`e@AOO
M@AOO
M@AOU=@AO\(@AO_o@AOeں@AOeں@AOeں@AOlC@AOlC@AOiDg8@AOlC@AOo@AOy@AO|hs@AOv_ح@AO|hs@AOy@AO&@AOy@AO&@AO&@AO&@AO	@AOO;d@AO$tS@AOkP@AO-V@AO?@AOzH@AO&@AOzH@AO3@AO3@AO/V@AO/V@AO/V@AO/V@AOvȴ9@AOvȴ9@AO@AOK]d@AO@AO@AOK]d@AOo @AOo @AOK]d@AOK]d@AO+@AO@AOfA@AO˒:)@AO@AO@AOfA@AOحV@AOfA@AOfA@AO;dZ@AO;dZ@AO;dZ@AO@@AO@AO@@AO@@AOrG@AOrG@AO@AOrG@AOrG@AO-@AOVϫ@AO䎊r@AO+j@AO#@APF]d@AP@AP	ԕ+@AP
qu@AP
qu@AP6@AP}H@AP}H@AP-
q@AP*0@AP4m9@AP4m9@AP4m9@AP:~ @AP:~ @AP>BZc@AP>BZc@APA7K@APD*@APD*@APK]c@APH@APK]c@APQ@APXy=@AP[6@APXy=@AP[6@APbM@APeO@APeO@APhۋq@APl"h	@APhۋq@APoiDg8@APy=c@AP|@AP˒:*@AP@AP-
@AP@APtj@APu%F@APu%F@AP-
@APIQ@AP-
@AP
=q@AP
=q@APIQ@AP-
@AP
=q@AP
=q@AP@APU@AP
=q@AP
=q@APU@AP{@AP9Xb@AP9Xb@AP)@AP)@APěT@APTɅ@APěT@APTɅ@APěT@APF@APѷX@APp:@AP)^@APp:@APp:@APF@APD@APD@APD@APۋq
@APD@AP`A7@APC@AP4֡b@AP{@AP{@AP	k@AP	k@AP$tT@AQ$/@AQ$/@AQ@AQrGE@AQ@N@AQ+@AQ_p@AQ@AQ@AQ@AQ#w@AQ#w@AQ#w@AQ-w1@AQ-w1@AQ*0U2a@AQ-w1@AQ*0U2a@AQ-w1@AQ0
)@AQ4J@AQ0
)@AQ=b@AQA [@AQA [@AQA [@AQA [@AQA [@AQA [@AQ=b@AQ:S@AQA [@AQDg8~@AQJE@AQJE@AQJE@AQJE@AQJE@AQN;5@AQA [@AQGz@AQJE@AQGz@AQGz@AQGz@AQN;5@AQQ@AQTɅo@AQae@AQ^@AQae@AQ[W>6@AQae@AQ^@AQe+a@AQe+a@AQe+a@AQe+a@AQk~(@AQrGE8@AQo hی@AQrGE8@AQx@AQ|Q@AQb}@AQb}@AQb}@AQ~($@AQ~($@AQ~($@AQ@AQR<6@AQ@AQ'RTa@AQu@AQu@AQu@AQ'RTa@AQ'RTa@AQ(@AQn.@AQ'RTa@AQn.@AQl@AQB@AQl@AQB@AQ|@AQ@AQ^5?}@AQ^5?}@AQ@AQD@AQD@AQD@AQ@AQ@AQD@AQ2W@AQ^5?}@AQy@AQo@AQo@AQN;6@AQ@AQ@AQ@AQ@AQ"`@AQ"`@AQ"`@AQᰉ'@AQiB@AQ"`@AQiB@AQᰉ'@AQe@AQ>BZ@AQiB@AQe@AQ>BZ@AQ>BZ@AQe@AQ>BZ@AQ@AQ@AQs@AQ-@AQlD@AQY}@AQ-@ARu%F@AR	 @AR	 @ARn@ARu%F@ARn@ARI^5@ARI^5@AR@AROv`@AR@AROv`@ARe+@ARe+@AR#9@AR䎊@AR&IR@AR䎊@AR&IR@AR-V@AR0U2a|@AR0U2a|@AR3@AR3@AR:)y@AR@4n@ARC\@ARGE85@ARGE85@ARM@ARGE85@ARGE85@ARQ_@ARM@ART`d@ARZc@ART`d@ARa|Q@ARd7@ARd7@ARd7@ARd7@ARnO@ARkP|@ARnO@ARqiC@ARqiC@ARu%F
@AR{m@AR~"@ARݘ@ARL_@ARp:@ARp:@ARᰊ@AR\(@AR\(@ARS&@ARᰊ@ARᰊ@ARᰊ@ARwkQ@ARS&@ARᰊ@ARwkQ@ARS&@ARvȴ@ARS&@AR@ARS&@ARL/{@AR>B@AR>B@AR}Vm@AR<64@ARY@AR<64@ARn@ARn@AR)_@AR@AR)_@ARW@AR͞&@AR͞&@AR`A@AR,<@AR,<@AR`A@ARsP@ARsP@ARG{@AR ѷ@AR䎊q@ARfB@ARC,@ARC,@ARm@AR74@AR74@AR~@AR~@AR74@AR~@ARm\@ARm\@ARm\@AR~@AR~@ARm\@ASS&@ASS&@ARm\@ASS&@AS҉@AS'/@ASnP@AS'/@AS'/@ASPH@AS	@AS"`B@AS&@AS"`B@AS	@AS&@AS)^	@AS/V@AS@N@AS9@AS6z@AS6z@AS9@AS=K^@AS@N@ASC%@ASJ#9@AS@N@ASF]c@ASF]c@ASF]c@ASF]c@ASJ#9@ASP{@ASP{@ASP{@ASS@ASS@ASW>6z@ASW>6z@ASZ@ASW>6z@ASZ@AS]cA@ASa@N@ASdZ@ASg	l@ASjf@ASn.3@ASn.3@ASqu!@ASn.3@ASxF]@ASqu!@AStj~@AStj~@AStj~@AStj~@ASxF]@AStj~@AS{J#9@AStj~@ASxF]@ASxF]@AS{J#9@ASxF]@AS{J#9@AS~$@AS@AS~$@AS@AS~$@ASQ@AS@AS@ASeO@ASeO@ASQ@ASeO@ASq@ASeO@ASeO@ASq@ASq@ASq@ASeO@AS:)z@AS:)z@AS$@ASU=@ASߤ@AS:)z@ASߤ@ASS@ASS@ASS@ASwk@AS*0U2@ASq@AS*0U2@AS@ASq@ASq@AS@ASE@ASE@ASZ@ASZ@AS~($@ASZ@AS6@ASa@O@ASZ@ASZ@AS6@ASa@O@ASƧ@AS5Xy@AS5Xy@AS|@AS5Xy@AS
=p@AS|@ASQ@AS
=p@AS
=p@AS҈@ASݗ+k@AS%2@AS%2@AS%2@AS%2@AS҈@AS%2@ASg@ASg@ASg@ASC]@ASA [@ASg@ASA [@ASA [@AS@AS@ATn.@ATJ@ATn.@ATn.@ATn.@ATJ@ATxF@ATߤ@@ATߤ@@ATxF@AT@ATߤ@@ATߤ@@ATߤ@@AT@AT@ATtj@ATQ@ATQ@AT"h	ԕ@AT!-w2@AT(\@AT(\@AT%1@AT(\@AT"h	ԕ@AT"h	ԕ@AT(\@AT%1@AT,<@AT,<@AT,<@AT,<@AT2W@AT/{J#@AT,<@AT/{J#@AT9XbN@AT64@AT9XbN@AT9XbN@AT9XbN@ATC,zx@ATFs@ATI^5?@ATSMj@ATM:@ATM:@ATPH@ATSMj@ATSMj@ATM:@ATSMj@ATSMj@ATSMj@ATVϪ@ATVϪ@ATVϪ@ATSMj@ATVϪ@ATVϪ@ATVϪ@AT]ce@AT]ce@AT]ce@AT`d@AT`d@AT]ce@ATZ1@AT`d@ATVϪ@ATcA \@ATcA \@ATcA \@ATg8}@ATg8}@ATm8@ATq@ATm8@ATj~#@ATq@ATtSM@ATtSM@ATwkP@ATzG@ATwkP@ATo h@ATo h@ATo h@ATo h@ATC@ATqj@ATqj@ATqj@AT#@ATqj@ATqj@ATqj@ATN;@AT*1@AT_@AT_@AT_@AT_@AT쿱[@ATS@AT3@AT3@AT3@AT3@ATzxl"@ATzxl"@ATzxl"@ATzxl"@ATzxl"@ATTɆ@ATTɆ@ATTɆ@AT@ATO
M@ATO
M@AT?@ATO
M@AT@AT?@AT#x@ATj~@AT#x@ATj~@ATj~@AT[W?@AT#x@AT?@ATj~@AT#x@AT[W?@AT7@AT?@AT?@AT[W?@AT?@ATɅoi@AT?@ATɅoi@ATɅoi@AT@AT*0@AT*0@ATZ@AT֡a@AT֡a@AT֡a@AT>B[@AT/@AT/@AT/@ATu"@AT/@AT/@ATZ@AT@ATZ@AT@AT@AT@ATJM@ATJM@AThr@AT!-w@ATD@AT!-w@ATe@AT!-w@ATe@AT!-w@AU:@AT>@AU:@AU:@AUo i@AUo i@AU:@AUo i@AUo i@AU'0@AU'0@AUV@AUV@AUu@AU[@AU[@AU*0@AU*0@AUu@AU*0@AU*0@AUu@AUu@AUu@AU[@AU*0@AU*0@AUqu"@AUqu"@AUqu"@AUQ@AUQ@AU!.H@AUQ@AUQ@AU!.H@AU+a@AU+a@AU(@AU/w@AU+a@AU2a|@AU2a|@AU(@AU/w@AU2a|@AU5Xy>@AU84֡@AU5Xy>@AU5Xy>@AU84֡@AU5Xy>@AU?|h@AU?|h@AU<64@AU?|h@AUF
L0@AUB@AUB@AUB@AU<64@AUB@AUF
L0@AUB@AUL_@AUIQ@AUIQ@AUO;dZ@AUO;dZ@AUO;dZ@AUO;dZ@AUL_@AUO;dZ@AUO;dZ@AUO;dZ@AUO;dZ@AUS&@AUS&@AUS&@AUS&@AUY|@AUY|@AUVl!@AUS&@AU\@AU`A7L@AU`A7L@AUce@AU\@AUfA@AUfA@AUfA@AUjOv@AUjOv@AUce@AUm\@AUm\@AUp
=@AUp
=@AUsg@AU}H@AU}H@AU}H@AU$/@AU}H@AUM:@AU$/@AUM:@AUM:@AU$/@AUM:@AUڹZ@AUݗ@AUݗ@AUڹZ@AUݗ@AUڹZ@AUڹZ@AU!R@AU!R@AU!R@AUhr!@AU=K@AU+j@AU=K@AU%@AU+j@AU=K@AUv@AU@AUv@AU@AUU=@AU1@AUU=@AU1@AU1@AU-V@AU-V@AU1@AU-V@AUsh@AUsh@AUU=@AUsh@AUsh@AUH˒@AUn/@AUn/@AU\(@AU\(@AU\(@AU\(@AUH˒@AU\(@AU8Y@AU8Y@AU8Y@AUH˒@AU\(@AU8Y@AUϪ͞@AU8Y@AU8Y@AU8Y@AU8Y@AU@AUcA @AUcA @AUcA @AUcA @AU@AU@AU8YK@AUϪ͞@AUϪ͞@AUϪ͞@AU@AUb@AU?@AUb@AUb@AUb@AUb@AU?@AU?@AU?@AUS@AU?@AU?@AU?@AU
qv@AU?@AU,=@AU,=@AUᰉ@AUS@AUᰉ@AU,=@AUᰉ@AUoiDg@AUE@AUE@AUoiDg@AUoiDg@AUᰉ@AUoiDg@AUoiDg@AU(@AU!.@AU!.@AUC\@AUC\@AU!.@AUC\@AUC\@AUڹ@AU!.@AU!.@AUC\@AV ѷY@AV ѷY@AUC\@AUڹ@AV ѷY@AV ѷY@AUڹ@AV ѷY@AVt@AVt@AVt@AV_o @AV_o @AVt@AV_o @AV_o @AV_o @AV4K@AV4K@AVzG@AV4K@AV4K@AVzG@AVzG@AV@AVu@AV@AVOv_@AV@AVu@AV!R<@AV$/@AVOv_@AV@AVu@AV!R<@AVu@AVOv_@AV!R<@AVOv_@AV($x@AV($x@AV+jg@AV($x@AV+jg@AV($x@AV($x@AV.2@AV1.@AV5?|@AV8YJ@AV1.@AV8YJ@AV1.@AV8YJ@AV8YJ@AV;5X@AV5?|@AV8YJ@AV8YJ@AV;5X@AV;5X@AV?@AV;5X@AV?@AV?@AV8YJ@AV;5X@AV;5X@AV?@AV;5X@AVBZc @AV8YJ@AVBZc @AVBZc @AVE@AVBZc @AVE@AVE@AVBZc @AVE@AV?@AVH@AVR<6@AVBZc @AVE@AVE@AVL/{J@AVH@AVR<6@AVVu@AVR<6@AVVu@AVVu@AVR<6@AVVu@AVVu@AVVu@AVYJ@AV\N<@AV\N<@AVYJ@AV\N<@AV_ح@AV_ح@AV_ح@AV_ح@AVc	@AV\N<@AVc	@AV_ح@AV\N<@AVfffff@AV_ح@AVc	@AVfffff@AViB@AVc	@AV_ح@AVfffff@AVc	@AVfffff@AVl!-@AViB@AVl!-@AVfffff@AVfffff@AVl!-@AVl!-@AVp:~@AVp:~@AVl!-@AVl!-@AVs@AVp:~@AVp:~@AVl!-@AVs@AVvȴ9X@AVs@AVvȴ9X@AVz@AVIQ@AV}Vl@AVIQ@AV}Vl@AVvȴ9X@AVIQ@AVIQ@AVz@AV}Vl@AVz@AVIQ@AV}Vl@AVz@AV}Vl@AVIQ@AVIQ@AVIQ@AV}Vl@AV%@AV%@AV%@AV%@AVz@AVIQ@AVIQ@AV%@AVIQ@AVIQ@AV%@AV%@AV+J@AVqi@AV+J@AV+J@AVqi@AV@AVqi@AV@AV@AV@AV$t@AV$t@AV$t@AVFs@AVFs@AV$t@AVFs@AVO;@AVO;@AVFs@AVFs@AV,<@AV,<@AV,<@AV,<@AVFs@AVO;@AVO;@AVO;@AV$t@AVO;@AV,<@AV@AV,<@AV,<@AV,<@AVO;@AV,<@AVO;@AV,<@AV@AV@AVT@AVT@AV@AVT@AVT@AV-@AVT@AVT@AV-@AV6z@AV}Vl@AV}Vl@AV2X@AV2X@AV'@AVQ@AVQ@AV@AV'@AV}Vl@AV'@AV'@AVQ@AV@AVQ@AVߤ?@AV@AVߤ?@AVߤ?@AV&I@AV2X@AVߤ?@AVߤ?@AV&I@AVߤ?@AVߤ?@AVm\@AVt@AV&I@AV&I@AVȴ9X@AVm\@AVȴ9X@AVȴ9X@AVt@AVA@AVt@AVȴ9X@AVt@AVA@AVA@AVA@AVA@AVA@AVA@AV҈p;@AV҈p;@AVϪ͟@AV҈p;@AVϪ͟@AVϪ͟@AVϪ͟@AVߤ?@AV]cf@AVϪ͟@AV]cf@AVߤ?@AV+@AV]cf@AVϪ͟@AVߤ?@AV]cf@AVߤ?@AVC-@AVߤ?@AV1@AV1@AVC-@AV1@AVߤ?@AV1@AVC-@AV1@AV쿱[W@AVx@AV1@AV1@AVx@AV쿱[W@AV쿱[W@AV쿱[W@AVMj@AV@AV@AVMj@AVMj@AVMj@AVMj@AV@AV@AV쿱[W@AV@AV@AVMj@AV"@AV"@AV"@AV"@AVFs@AVFs@AVFs@AW@AW hۋ@AV!.I@AV!.I@AW@AW hۋ@AW hۋ@AV!.I@AW hۋ@AW
=p@AW@AV!.I@AV!.I@AW hۋ@AW hۋ@AW hۋ@AW hۋ@AW@AW@AWFt@AW
=p@AW
=p@AW@AW
=p@AW
=p@AWFt@AWFt@AW
=p@AW
=p@AW)^@AW@AWXe@AW@AW)^@AW@AW@AW@AW)^@AWXe@AW)^@AW)^@AW
=p@AW)^@AW)^@AW@AWXe@AWXe@AW@AW@AWXe@AWv@AWv@AWXe@AWXe@AWXe@AWv@AWXe@AWXe@AW@AW@AWXe@AWv@AWv@AW@AW@AWXe@AWv@AWv@AWXe@AWv@AW,@AW!-w1@AW,@AW,@AW@AW,@AW!-w1@AW!-w1@AW!-w1@AW!-w1@AW$tS@AW!-w1@AW!-w1@AW!-w1@AW$tS@AW$tS@AW$tS@AW!-w1@AW,@AW$tS@AW'/W@AW'/W@AW+I@AW+I@AW+I@AW'/W@AW'/W@AW+I@AW+I@AW+I@AW+I@AW+I@AW+I@AW.H@AW+I@AW.H@AW1@AW1@AW1@AW1@AW1@AW1@AW1@AW.H@AW1@AW.H@AW+I@AW1@AW4֡a@AW4֡a@AW4֡a@AW'/W@AW1@AW4֡a@AW4֡a@AW4֡a@AW8}H@AW8}H@AW4֡a@AW4֡a@AW8}H@AW4֡a@AW1@AW1@AW4֡a@AW8}H@AW4֡a@AW8}H@AW4֡a@AW8}H@AW;dZ@AW;dZ@AW;dZ@AW8}H@AW8}H@AW;dZ@AWAs@AW>6z@AW>6z@AW8}H@AW>6z@AW>6z@AW;dZ@AW>6z@AWAs@AWAs@AW>6z@AW>6z@AWE84@AWAs@AWE84@AW>6z@AWAs@AWE84@AWH˒:@AWE84@AWH˒:@AWH˒:@AWE84@AWH˒:@AWH˒:@AWAs@AWH˒:@AWKƧ@AWKƧ@AWKƧ@AWKƧ@AWH˒:@AWH˒:@AWO
M@AWO
M@AWO
M@AWRT`e@AWRT`e@AWU=@AWRT`e@AWRT`e@AWRT`e@AWRT`e@AWRT`e@AWO
M@AWRT`e@AWU=@AWU=@AWU=@AWU=@AWU=@AWXe,@AWXe,@AW\(@AWU=@AWRT`e@AWO
M@AWXe,@AWXe,@AW\(@AWXe,@AWXe,@AW_o@AW_o@AW_o@AWb}V@AW\(@AW\(@AWXe,@AWU=@AWXe,@AWU=@AW\(@AW_o@AWXe,@AWb}V@AWb}V@AW_o@AWb}V@AW\(@AWb}V@AWb}V@AWb}V@AWb}V@AWb}V@AWb}V@AWeں@AWiDg8@AWeں@AWeں@AWb}V@AWeں@AWeں@AWiDg8@AWeں@AWb}V@AWiDg8@AWb}V@AWlC@AWlC@AWiDg8@AWo@AWsPH@AWeں@AWeں@AWlC@AWiDg8@AWiDg8@AWlC@AWo@AWsPH@AWo@AWlC@AWsPH@AWsPH@AWo@AWiDg8@AWo@AWsPH@AWo@AWo@AWo@AWo@AWsPH@AWv_ح@AWo@AWv_ح@AWo@AWsPH@AWsPH@AWsPH@AWsPH@AWsPH@AWv_ح@AWy@AWy@AWv_ح@AW|hs@AW|hs@AW|hs@AW4m@AW4m@AW4m@AW4m@AW{J#:@AW&@AW4m@AW{J#:@AW&@AW&@AW&@AW{J#:@AW4m@AW&@AW{J#:@AW4m@AW&@AW4m@AW4m@AW4m@AW{J#:@AW&@AW	@AW{J#:@AW|hs@AW4m@AW&@AW{J#:@AW&@AW{J#:@AW&@AW	@AW&@AWO;d@AWO;d@AW	@AW{J#:@AWO;d@AW	@AW	@AWO;d@AW@AW&@AW&@AW	@AW	@AW	@AW	@AW	@AW	@AWO;d@AWO;d@AWO;d@AW&@AWO;d@AWO;d@AW@AWO;d@AWO;d@AW@AW@AWO;d@AW@AW@AW@AW@AW@AWO;d@AW&@AW&@AW	@AW	@AWO;d@AWO;d@AW	@AWݗ+@AWO;d@AWO;d@AWݗ+@AW$tS@AW	@AWO;d@AW@AW@AW@AWO;d@AW@AWݗ+@AW@AWݗ+@AWݗ+@AWݗ+@AW	@AWO;d@AWݗ+@AW@AW$tS@AW$tS@AW@AW@AW@AWݗ+@AWݗ+@AW$tS@AWݗ+@AW$tS@AWkP@AWݗ+@AW@AWݗ+@AW$tS@AWݗ+@AWݗ+@AWkP@AW$tS@AWݗ+@AWݗ+@AW@AW$tS@AW$tS@AW$tS@AW$tS@AW$tS@AW$tS@AWݗ+@AWkP@AW	@AWݗ+@AW@AW$tS@AWݗ+@AWkP@AWݗ+@AW@AW@AWݗ+@AW$tS@AWkP@AW$tS@AW$tS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              @s@sfffff@r     @r     @r     @rfffff@rfffff@s33333@s@s	@s@s	@s@s@s     @s33333@s33333@s      @r33333@s      @s@s     @s     @s     @s@s33333@s      @s      @s33333@s	@s33333@s@s      @s@s     @sfffff@s@s33333@s33333@s@s@sfffff@s     @s33333@r33333@r@s      @s33333@s     @s33333@s@s     @s@s     @sfffff@s	@s33333@s33333@s@s33333@s33333@s@s	@s@sfffff@s	@s@s      @s33333@s     @s     @s@s33333@s@s@s@s      @r@s@sfffff@s@s     @s33333@s     @s33333@r     @r33333@s      @s@s33333@s@sfffff@s@s@s      @s	@s      @r33333@r@r@r     @rfffff@r@r񙙙@rfffff@rfffff@r@qNfffff@oi@k@l333333@j@j9@i@iI@i@i33333@i     @ifffff@h     @h     @h@h@h@h@h@h`     @h&fffff@g陙@g@gfffff@g33333@g     @gl@g\@gS33333@gFfffff@g@     @g0     @g	@f陙@f33333@f     @fٙ@f陙@f     @f     @fy@ffffff@e33333@efffff@efffff@ep     @e,@d     @di@dC33333@dffffff@dy@d33333@d33333@d     @d33333@d@d@d33333@dl@dC33333@d#33333@cٙ@c33333@cffffff@cL@cC33333@c@     @c6fffff@c      @b33333@b|@bVfffff@b@     @b,@b&fffff@b\@b,@b      @a     @a@a     @afffff@a     @a333333@`33333@`@`     @`33333@`33333@`     @`@`i@`L@`333333@`&fffff@`&fffff@`)@`#33333@`@`@_ٙ@_@_,@^fffff@^33333@^fffff@^@     @]     @]ffffff@]S33333@]@\@\     @\33333@\     @\33333@\l@\@     @\@\fffff@[@[33333@[fffff@[s33333@[S33333@[333333@[33333@[      @Z33333@Z     @Z33333@[      @Z     @Z33333@Zl@ZS33333@Z@     @Z9@Z@Z      @Y@Z&fffff@Y33333@Y@Y@Y33333@Y`     @Y      @Xfffff@X33333@X     @Xy@Xy@X33333@X     @X@W33333@Wٙ@W@W@Wfffff@W@W     @W     @Wfffff@W33333@Wl@WFfffff@W9@W&fffff@W33333@V@V@V     @V33333@V33333@V     @Vfffff@Vs33333@V`     @VY@VL@V@     @V333333@V&fffff@V@V@U@Ufffff@Ufffff@Ufffff@U@U@Uy@Uffffff@Ul@Uffffff@UY@UFfffff@U333333@T@Tٙ@Tfffff@T33333@T     @T@T     @T@T33333@T@Ts33333@Tffffff@TL@T9@T&fffff@T33333@S@S@S@Sfffff@S33333@S33333@Sfffff@S     @S33333@S     @SL@S9@S33333@R33333@R     @R@R33333@R33333@R@R33333@R@R@Ry@Rffffff@RL@RL@RFfffff@R@R&fffff@Qfffff@Qfffff@Q33333@Qfffff@Q@Qy@Qy@Q33333@Qffffff@QS33333@Q9@Q33333@Q      @Pfffff@P     @P     @P33333@P     @P     @Pffffff@P`     @PS33333@P@     @P333333@P      @P@O33333@O33333@Offfff@Oٙ@O     @O&fffff@Nfffff@N@Nffffff@Nffffff@Ns33333@NY@NL@N&fffff@N@N@M@M     @Mfffff@Mfffff@M@M@M@Ms33333@Mffffff@ML@M@     @M333333@M@Lfffff@Lfffff@L@Ls33333@LY@L333333@Kfffff@K     @K@KY@KL@K@K      @K@J33333@J@J     @J33333@J     @J@JY@J333333@J@J      @Ifffff@I@Iٙ@Ifffff@Iٙ@Ifffff@I     @Iffffff@Iffffff@IL@I333333@I@I@H33333@H     @H@HY@Hffffff@H333333@H@H333333@HL@H      @G@GL@G@G&fffff@G&fffff@G&fffff@G@F33333@Ffffff@F33333@F@FL@FY@F@     @FL@F@     @F@F      @F@F@F@F@F@E33333@F@E33333@E33333@Efffff@Eٙ@E@E33333@E     @Effffff@EY@E333333@E@D33333@D@D@D33333@Dfffff@D@D33333@D@D     @Ds33333@DL@D&fffff@D@D333333@D@D&fffff@D@C33333@C@C@C33333@C     @Cffffff@C@     @C@C@C&fffff@C&fffff@C&fffff@C      @C      @C      @B@B@B     @Bٙ@B@B     @B33333@B33333@B     @B@Bs33333@BL@B333333@BL@B@     @B333333@B@     @B333333@B&fffff@B@B@     @B&fffff@B@B@A33333@A@A     @A     @A33333@A     @A33333@Afffff@A33333@Afffff@A     @A     @As33333@AY@AL@AL@A@     @AL@A@     @A@A@A@@33333@@fffff@A&fffff@A      @@     @@33333@@fffff@@@@@@s33333@@ffffff@@ffffff@@@@@@     @@ffffff@@ffffff@@ffffff@@ffffff@@Y@@L@@@     @@Y@@@     @@@@      @@333333@@@?33333@?@?@?@?     @?     @?@?@?@?ffffff@?L@?     @?ffffff@?L@?333333@?L@>fffff@>@>fffff@>@>ffffff@>@>ffffff@>ffffff@>ffffff@>     @>333333@=fffff@>@=33333@=@=@=@=     @=@=@=     @=     @=@=ffffff@=333333@=333333@=333333@=      @<fffff@<@<@<33333@<33333@<33333@<@<ffffff@<@=      @<33333@<     @<333333@<333333@<      @<      @<      @;@;fffff@;33333@;@;@;ffffff@;@;     @;@;33333@;@;ffffff@;     @;@;@;@;     @;ffffff@;     @;     @;@;ffffff@;333333@;      @;333333@;@;33333@;     @;L@;@;L@;333333@;L@;L@;333333@;333333@;@;333333@;333333@;333333@;333333@;333333@;333333@;@;L@;L@;      @:fffff@;      @;      @:fffff@:fffff@;      @;      @:@:     @:ffffff@:     @:@:L@:@:     @:333333@:333333@:L@:L@:@:@:@:      @:      @9@9fffff@933333@9@9@9@9fffff@9333333@9333333@9@9333333@8fffff@9@9      @9333333@9L@9333333@9      @9      @9@9333333@9333333@9@9      @9@9      @8fffff@8fffff@9      @8fffff@8@8@833333@8@8     @8333333@8@8@8     @8     @8333333@8333333@8      @8      @8      @7fffff@7fffff@7fffff@7fffff@7@7333333@7      @7333333@7L@7ffffff@7L@7L@7333333@6@6333333@6L@6@6     @6@6     @6     @633333@633333@6@633333@633333@633333@6@6fffff@6fffff@633333@6fffff@6@6@6@633333@6@6     @633333@6@633333@6fffff@633333@6@6@6     @6L@6@5@5fffff@5@5fffff@533333@533333@5     @5@533333@533333@5@5ffffff@5L@5L@5     @5@5     @5L@5@433333@4     @4L@4L@4ffffff@4ffffff@4L@3fffff@3fffff@4333333@4L@4ffffff@4@3@3ffffff@3@4@4@4333333@4      @333333@4      @4      @3fffff@333333@333333@4      @333333@3     @3@3fffff@4      @4      @3@4      @4@4      @333333@3L@2fffff@3      @2fffff@2fffff@2@2ffffff@133333@1@1fffff@1@1@1@1@1     @1L@1L@1      @1L@1@1      @1L@1L@1333333@0fffff@1@1L@1@0fffff@1      @1@1      @0@0fffff@0fffff@1      @1      @1      @1      @1@1@1@1L@1333333@0fffff@0fffff@1@1333333@1L@1L@1      @1L@1ffffff@1@0fffff@1@0fffff@0fffff@1@1L@1333333@0@1@1      @0fffff@1333333@0fffff@1@0fffff@0fffff@1333333@0fffff@033333@0@1333333@1333333@0fffff@0fffff@0fffff@0@1      @1      @1      @0fffff@0@033333@0@0fffff@0fffff@0fffff@033333@0@033333@0@0     @0@1@0@0fffff@0fffff@0fffff@0@033333@033333@0fffff@0fffff@033333@0fffff@1      @033333@033333@0@0@033333@0fffff@0@033333@033333@033333@0fffff@033333@0@0fffff@0@033333@0@0     @0ffffff@0L@0L@0ffffff@0@0     @0@0@033333@0@0     @0@0@0     @0     @0@033333@0@0ffffff@0ffffff@0@0@0     @0     @0ffffff@0L@0L@0L@0     @0L@0     @0     @0L@0ffffff@0ffffff@0@0ffffff@0L@0L@0L@033333@0333333@0ffffff@0L@0333333@0ffffff@0     @0@0L@0333333@0ffffff@0@0     @0     @0ffffff@0     @0L@0L@0333333@0333333@0333333@0L@0     @0ffffff@0ffffff@0333333@0     @0     @0@0ffffff@0L@0333333@0ffffff@0L@0     @0ffffff@0ffffff@033333@033333@0ffffff@0     @0@0ffffff@0@0@0ffffff@0@033333@0L@0     @033333@033333@0@0@0ffffff@0ffffff@0     @0fffff@033333@0ffffff@0@0@033333@033333@0@0@0@0@0ffffff@0@0@0@0@0     @0ffffff@0ffffff@033333@0@0@0ffffff@0@0fffff@0@0     @0fffff@033333@0@0@0@0@0     @0@0fffff@033333@0     @1      @0@033333@1      @0fffff@033333@033333@0@0@0@1@0fffff@0@0@0@0@033333@1      @0@0fffff@0@0@1      @0fffff@033333@033333@0fffff@0fffff@033333@0fffff@1@0fffff@0@1      @0@0fffff@0fffff@0@0@0@033333@033333@0@0@0@0fffff@033333@0@0@1333333@0@0     @0@1      @0@033333@0@0fffff@1@1      @0@033333@033333@0@0fffff@0@1@0@0ffffff@0fffff@033333@0fffff@0fffff@033333@0     @0@033333@0@0@1      @033333@0fffff@0@033333@033333@0@0@033333@0fffff@0fffff@1      @1      @033333@0L@0@0fffff@0@0@033333@0@033333@0@0@033333@0fffff@0fffff@033333@033333@0@1      @0fffff@033333@0@033333@1@1ffffff@1@1@1@1ffffff@1@1@2333333@2L@233333@233333@2      @2      @2@2333333@2ffffff@2     @2@2L@2ffffff@2     @2@3      @3      @3      @3      @3333333@3L@3     @3@333333@3fffff@4      @4333333@4333333@4L@4     @4@4333333@433333@5@4@4L@433333@433333@433333@4@5@4fffff@4fffff@433333@4fffff@4fffff@4@4@4@4@4@5333333@5333333@5333333@5L@5     @5@5ffffff@533333@5@6@5fffff@5fffff@5fffff@6@533333@6      @5fffff@5@5@6      @5fffff@533333@533333@5@5fffff@6      @6L@6ffffff@633333@6fffff@7      @7      @6fffff@7333333@7     @7333333@7@7@7333333@7      @7@7L@733333@7L@7     @7     @7fffff@733333@733333@7ffffff@7@7@7ffffff@733333@7fffff@7fffff@7@8@8      @8333333@8@7fffff@7@7fffff@7fffff@8333333@8333333@8@8L@8L@8@8L@8     @8     @8L@8L@8333333@8     @8     @8     @8L@8333333@8L@8@833333@8@833333@8     @8     @833333@8@8@8@833333@8L@8@8333333@8L@8      @8333333@8L@8     @8L@8L@8ffffff@8@8     @8fffff@8fffff@8     @8     @8ffffff@8     @8@9      @8@8@9@9ffffff@9ffffff@9333333@9     @9ffffff@9@9L@9L@9     @933333@:333333@:ffffff@:      @:      @:ffffff@:@:     @:@:      @:L@:     @:     @:333333@9fffff@9fffff@:@:@:@:     @:L@:     @:     @:333333@:L@:@:@:@:     @:L@:33333@:33333@:     @:L@:333333@:@:@9fffff@:      @:ffffff@:     @:      @933333@:@:     @:ffffff@:L@:@:ffffff@:     @:     @:     @:L@:ffffff@:33333@:@:fffff@:33333@:     @:33333@:     @:@:@;333333@;      @;      @;333333@;333333@;@:fffff@;L@;@;@;     @;333333@;     @;@;@;@;@;33333@<      @;@;     @;L@;@<@;@;@<L@<333333@<@<@<ffffff@<      @<@<ffffff@<ffffff@<ffffff@<L@<ffffff@<L@<@<     @<@<ffffff@<ffffff@<     @<33333@<     @<     @<     @<     @<@=      @=@=@<@=333333@=333333@<@<@<@=      @=ffffff@=@=fffff@=     @=@>      @>     @>333333@>     @>L@>333333@>     @>33333@>@>fffff@?      @>ffffff@?      @?L@?@?ffffff@?ffffff@?333333@?@?@?L@?33333@?L@?@?33333@@      @?fffff@?@@@@      @?@@@@333333@@@@@@@@      @@&fffff@@L@@@     @@@     @@s33333@@     @@ffffff@@@     @@L@@@@@@33333@@@@s33333@@s33333@@     @@ٙ@A      @A333333@AY@A      @A      @A333333@AY@AL@AY@A@AY@A     @Affffff@Afffff@A@As33333@A     @Affffff@Affffff@A     @A@A@A33333@Afffff@Afffff@A@B      @Aٙ@A@A@A@A@Afffff@Afffff@A33333@A33333@A33333@B      @B333333@B333333@B333333@B@     @B33333@B@B@B     @B     @B@B     @B@B@B@C      @C      @C      @B@B@Bfffff@C&fffff@C@C&fffff@Cffffff@C@C@     @C333333@C33333@C     @C@     @Cffffff@Cs33333@Cs33333@Cs33333@Cs33333@C@C     @C@C33333@C@C33333@C33333@C33333@C@D&fffff@D@DL@D333333@D333333@D333333@DY@Dffffff@Ds33333@D     @D     @Dfffff@D@DY@D33333@Dfffff@D     @D     @E      @Dٙ@D@Dfffff@Dٙ@E@E333333@E@E333333@E333333@EL@E&fffff@Es33333@E     @E@     @EY@E@E33333@E33333@E@E@E33333@E33333@F      @F@F@F@F&fffff@F&fffff@F&fffff@F@     @F@F@F@F&fffff@F@     @Fffffff@Fs33333@Fs33333@Fffffff@FY@F     @F33333@F@F@Fٙ@Fٙ@Ffffff@G      @G@     @Fٙ@Fٙ@F33333@F33333@G333333@Gffffff@GY@GY@GY@Gs33333@G     @G33333@G     @G@G     @G@Gٙ@H      @H      @G@G     @Gٙ@H@G33333@H      @H      @H      @H      @H@     @HY@HL@H@     @H333333@HY@Hs33333@H@Hs33333@H     @Hfffff@H      @H333333@HY@H@H@H@H@Hfffff@H@H33333@H     @Hٙ@Hfffff@H@Hfffff@H@Hٙ@Hٙ@I&fffff@H@H@Hٙ@H33333@I      @I@I@I@I@     @I333333@IL@I@     @I     @I@IY@I&fffff@I@     @I@I@I33333@Ifffff@I     @I@Iffffff@Ifffff@Iٙ@I@I@Iٙ@J      @Ifffff@I     @J&fffff@J333333@J@J&fffff@JY@J333333@J@JL@J     @J@Js33333@J@J33333@J33333@J     @JY@J@J@Jfffff@J     @J33333@Jٙ@Jٙ@K@K@K&fffff@K@     @K333333@Ks33333@Kffffff@KL@KY@K@K     @K     @K&fffff@K     @Kffffff@K     @Kfffff@K33333@K33333@K@Kٙ@K@K33333@L@L      @Kٙ@L&fffff@L&fffff@L@L      @Kٙ@Kfffff@K33333@L      @L      @L&fffff@L&fffff@L@L      @L&fffff@L333333@L@     @LY@Lffffff@LL@LL@Lffffff@Ls33333@L@L@L@L     @Ls33333@L     @L@L33333@M      @Lfffff@L33333@L     @Lfffff@M      @Lٙ@Lٙ@L     @L@Lfffff@M      @M@M      @M@M&fffff@M333333@M@ML@Mffffff@ML@M     @M     @MY@Mffffff@M     @M     @M     @M@M     @Mffffff@Ms33333@Mfffff@Mfffff@M@Mٙ@M     @Mfffff@M@N&fffff@N@     @Mfffff@Mfffff@M@Mfffff@M@Mfffff@N&fffff@Nffffff@NL@Nffffff@N@     @NL@N333333@N&fffff      @NL@NY@N     @Nfffff@N     @N     @N     @N@N@N@N@N     @N@N     @N     @N@Nٙ@Nfffff@N@N33333@O&fffff@O&fffff@O333333@O@N@O@     @O      @O@OL@Os33333@Os33333@O@Offffff@O333333@OL@O     @O33333@O     @O     @O@O33333@Oٙ@O@O33333@Offfff@Offfff@O33333@O@Oٙ@O33333@P@P@P@P9@PFfffff@P9@P      @P333333@PL@P333333@P9@P@     @PS33333@PY@PS33333@PL@PS33333@Py@P`     @Pl@Pffffff@Pfffff@Py@Py@Py@Pfffff@P     @P33333@P@P@P@P     @P     @P33333@P@P@P     @P@P@P@P     @Pfffff@P@P33333@P@P@Pfffff@P33333@P@P     @P     @Pٙ@Pfffff@P@Qfffff@Pfffff@P@Q      @Q&fffff@Q@Q@Qfffff@Q@Q9@Q&fffff@QFfffff@QY@QY@QL@Qffffff@Q`     @QY@QS33333@Q     @Q33333@Qs33333@Qffffff@Qy@Ql@Qs33333@Ql@Q     @Q@Q     @Q@Q@Q@Q33333@Q33333@Q33333@Qfffff@Q@Qٙ@Qfffff@Q@Q@Q@Qٙ@Q@Qfffff@Q     @Q33333@Q     @Qfffff@Q33333@Q33333@Q     @Q@Qٙ@Qٙ@Q@R@R      @R333333@R      @R&fffff@R9@RS33333@RL@Rl@Rfffff@Rffffff@RS33333@Ry@Rfffff@Rs33333@Rs33333@Rs33333@Rs33333@Rffffff@R`     @Rffffff@Rl@R     @Rfffff@R@R@Rfffff@Rfffff@Rfffff@R     @R     @R@R@Rfffff@R33333@R@R33333@R@R     @Rfffff@Rfffff@R@R     @R     @S@R33333@Rٙ@R@R@R33333@S      @R@R@S333333@S@S      @R33333@S      @S      @S&fffff@S33333@S333333@S`     @SS33333@S@     @S9@SFfffff@S333333@S9@S`     @SL@SL@SFfffff@SS33333@S@     @SL@S`     @Ss33333@Ss33333@Sy@S     @S     @S@Sfffff@S@Sy@S@S     @Sfffff@S@S     @S@S     @S@S     @S     @S@S@S33333@S@S@Sfffff@S     @S     @S     @S33333@Sٙ@S33333@S@Sٙ@S33333@S     @Sfffff@S     @S     @S     @Sfffff@S@S@Sٙ@S@Sfffff@S33333@Sfffff@Sfffff@T      @T33333@T@T333333@T333333@T      @T,@T      @T333333@TL@TL@TY@Ty@Ty@T`     @TS33333@TY@Ts33333@TS33333@Ts33333@T@T@Ts33333@Tffffff@Ty@Tfffff@T@T@T@Tfffff@Ts33333@Tffffff@Ty@T@T33333@Tfffff@Tfffff@T     @T33333@T@Ufffff@U      @T33333@T33333@U      @U@U      @T@U33333@U@U33333@U@U@U&fffff@U      @Ufffff@U      @U@U@U@Ufffff@U@Ufffff@U33333@U&fffff@U9@U9@US33333@UL@UFfffff@U,@U,@U`     @US33333@UFfffff@US33333@UFfffff@U`     @U333333@Ufffff@Uy@U`     @Ul@Ul@U@U@Ul@U@U33333@U@UY@U@U@U33333@Ufffff@U33333@U33333@U     @U33333@Ufffff@Ufffff@U33333@U33333@U@Ufffff@Ufffff@U33333@Uٙ@U@Uٙ@V      @U33333@U     @U@U@U33333@V33333@V33333@V33333@U33333@V@V@V33333@V@V      @Vfffff@V@V&fffff@V      @V@U@Vfffff@V      @V33333@V333333@V,@V@     @V333333@V@V@V      @V333333@V9@V@V333333@V&fffff@V@     @VFfffff@VL@VL@V9@Vffffff@Vfffff@Vs33333@V     @VY@Vffffff@Vfffff@V@V@V     @Vfffff@V@Vs33333@V     @V@V     @V33333@V33333@V33333@V@V     @V@V     @V33333@V@V     @Vfffff@Vfffff@V     @V33333@V     @V     @Vfffff@Vfffff@V@Wfffff@Vfffff@Vfffff@V33333@V33333@V33333@Vٙ@V     @W      @W      @V@W      @W,@W33333@Vٙ@V33333@W@W@V@V33333@Wfffff@W,@W&fffff@W@W@W&fffff@Wfffff@W@     @W33333@W333333@W@     @WL@WFfffff@WL@W@     @W`     @WY@WL@Wffffff@WS33333@WS33333@WY@W     @W     @WS33333@WL@Wffffff@Ws33333@W@W`     @Ws33333@W33333@W33333@Ws33333@Wfffff@Wfffff@W@W@Wfffff@W@W33333@Wfffff@W@W@W@W33333@W33333@W33333@Wٙ@W@W@W33333@W@W@Wfffff@W@X      @W@Wٙ@Xfffff@X,@X33333@W@X333333@XFfffff@X33333@X@X@XFfffff@XS33333@X,@X      @XFfffff@X`     @Xl@X&fffff@X333333@XS33333@XS33333@X     @X     @X     @Xl@XY@Xl@Xl@Xy@X     @X33333@X     @X     @X     @X     @X33333@Xfffff@Xfffff@X     @X33333@X     @X@X     @Xfffff@X     @X     @X@X33333@Xfffff@X     @Xfffff@X     @X@X     @X     @Yfffff@Y33333@Xfffff@Y33333@Y@Y33333@Yfffff@X33333@Y      @Y33333@Y      @Y&fffff@Y333333@Y@Y&fffff@Y@YY@Y@     @YFfffff@Y@     @Y@     @YY@Y333333@Y,@Y9@Y`     @YS33333@Y@     @Yffffff@YS33333@YY@Yffffff@Yl@Y     @Y@Yy@Yffffff@YY@Ys33333@Y@Y@Yy@Yfffff@Y33333@Y     @Y@Y33333@Yfffff@Y     @Y33333@Y@Y33333@Y@Y@Yfffff@Y33333@Yfffff@Yfffff@Y@Yfffff@Yfffff@Y     @Yfffff@Yfffff@Y@Y33333@Yfffff@Y@Yfffff@Y@Y33333@Y@Y     @Y@Yٙ@Y@Z@Y     @Y@Y@Z      @Zfffff@Yfffff@Y33333@Z@Zfffff@Y33333@Y@Z      @Z9@Z33333@Z33333@Z@Z@Z      @Z@Z@Z&fffff@Z&fffff@Z333333@Z333333@Z`     @Zffffff@Z,@Z&fffff@Z@     @ZS33333@ZL@ZFfffff@ZS33333@Zfffff@Z@     @Z`     @Zffffff@Zl@Zs33333@Zl@Zl@Zs33333@Z     @Z@Z     @Z@Zfffff@Zy@Zs33333@Z@Z33333@Z33333@Z     @Zfffff@Z@Zffffff@Z33333@Zfffff@Z33333@Z     @Z     @Z@Z@Z@Z33333@Zfffff@Zfffff@Zٙ@Zfffff@Z@Z@Zfffff@Z     @Z     @Z     @Z@Zfffff@Z@Z@[@[      @Z33333@[@[@[      @[33333@[33333@[&fffff@[      @[      @[33333@[@[@[&fffff@[9@[&fffff@[Ffffff@[L@[S33333@[Ffffff@[ffffff@[S33333@[L@[L@[@     @[`     @[S33333@[S33333@[9@[@     @[y@[y@[ffffff@[s33333@[L@[@     @[S33333@[ffffff@[`     @[y@[fffff@[33333@[     @[33333@[33333@[@[     @[fffff@[@[@[@[@[@[@[33333@[@[fffff@[fffff@[fffff@[fffff@[@[33333@[fffff@[     @[     @[fffff@[fffff@[fffff@[fffff@[fffff@[fffff@[@[@[     @[33333@[@[@[fffff@[fffff@[     @[     @[33333@[33333@\      @\fffff@\@\,@[     @\@\      @\&fffff@\33333@\9@\9@\333333@\,@\,@\&fffff@\      @\@\L@\s33333@\9@\      @\9@\S33333@\Y@\@     @\@\,@\@     @\L@\Ffffff@\L@\ffffff@\9@\Ffffff@\9@\9@\@     @\L@\`     @\ffffff@\`     @\fffff@\s33333@\`     @\l@\fffff@\33333@\L@\L@\y@\fffff@\s33333@\@\     @\     @\     @\     @\fffff@\     @\@\fffff@\@\     @\fffff@\@\@\fffff@\@\33333@\     @\fffff@\@\ٙ@\33333@\@\@\fffff@\@\33333@\fffff@\33333@\@\fffff@\@\fffff@\fffff@\fffff@\33333@\fffff@\fffff@\@]      @]@]fffff@]@]@]@],@]&fffff@]&fffff@]@]      @]Y@]ffffff@]@]      @],@]333333@]9@]L@]333333@]33333@]@]333333@]@],@]@     @]L@]333333@]333333@]L@]9@]333333@]S33333@]L@]9@]      @]S33333@]s33333@]     @]ffffff@]ffffff@]Y@]Ffffff@]s33333@]@]s33333@]@]@]Y@]s33333@]@]y@]l@]y@]     @]     @]33333@]@]     @]@]     @]     @]     @]@]33333@]@]@]@]@]@]33333@]     @]     @]@]33333@]fffff@]fffff@]     @]     @]@]33333@]@]33333@]fffff@]@]@]fffff@]33333@]     @]     @]fffff@]fffff@]33333@]ٙ@]33333@]fffff@]33333@]@]@]@^@^&fffff@^,@]33333@^      @^33333@^33333@^@^333333@^333333@^333333@^33333@^@^&fffff@^9@^&fffff@^      @^33333@^33333@^@^Ffffff@^333333@^@     @^`     @^ffffff@^333333@^9@^s33333@^L@^s33333@^`     @^fffff@^fffff@^Y@^S33333@^`     @^s33333@^`     @^s33333@^y@^s33333@^s33333@^`     @^fffff@^33333@^@^33333@^@^33333@^@^@^@^     @^@^33333@^@^     @^fffff@^fffff@^fffff@^@^@^@^33333@^@^33333@^     @^     @^ٙ@^@^@^33333@^@^fffff@^     @^33333@^fffff@^fffff@^fffff@^33333@^33333@^33333@^fffff@^@^fffff@^ٙ@^     @^     @^     @^ٙ@^@^33333@^ٙ@^@^fffff@^@^ٙ@_@^@^@^33333@_      @^33333@_33333@_      @^@^@_fffff@_333333@_@_fffff@_@_@_      @_@_,@_,@_33333@_fffff@^@_      @_      @_@     @_,@_@_@_@_@_&fffff@_9@_@^fffff@_@_9@_9@_ffffff@_S33333@_S33333@_Y@_S33333@_s33333@_S33333@_333333@_l@_`     @_@_l@_l@_@_Y@_s33333@_fffff@_s33333@_s33333@_ffffff@_s33333@_ffffff@_`     @_Y@_y@_33333@_@_33333@_S33333@_s33333@_s33333@_`     @_33333@_33333@_@_fffff@_Y@_fffff@_33333@_33333@_@_fffff@_     @_     @_@_fffff@_33333@_@_@_@_@_33333@_     @_s33333@_@_fffff@_     @_@_@_ffffff@_y@_fffff@_     @_     @_33333@_@_fffff@_fffff@_@_fffff@_33333@_33333@_fffff@_@_ٙ@_@_33333@_     @_     @_33333@_fffff@_@`fffff@_@_@`      @`33333@`33333@`33333@_fffff@_@`	@`33333@_ٙ@_33333@_@`     @`@_@_@_@`      @`33333@`33333@_33333@_@`     @`@`@`	@_33333@`@`@`33333@`fffff@`33333@`     @`@`     @`fffff@`     @`&fffff@`@`     @`@`@`fffff@`)@`&fffff@`@`#33333@`@`,@`#33333@`@`,@`@`@`0     @`0     @`fffff@`#33333@`@`@`#33333@`#33333@`@`&fffff@`333333@`,@`&fffff@`6fffff@`P     @`0     @`33333@`	@`@`#33333@`6fffff@`@     @`6fffff@`#33333@`#33333@`333333@`,@`&fffff@`fffff@`9@`333333@`333333@`333333@`C33333@`333333@`@     @`I@`6fffff@`&fffff@`9@`0     @`333333@`6fffff@`C33333@`,@`@`,@`C33333@`333333@`@     @`C33333@`<@`6fffff@`333333@`6fffff@`#33333@`&fffff@`6fffff@`9@`C33333@`L@`C33333@`#33333@`L@`C33333@`Ffffff@`C33333@`P     @`L@`\@`c33333@`I@`L@`S33333@`S33333@`S33333@`vfffff@``     @`s33333@`Y@`c33333@`l@`i@`S33333@`y@`\@`s33333@`i@`ffffff@`L@`6fffff@`I@`C33333@`P     @`l@`vfffff@`vfffff@`vfffff@`y@`ffffff@`Vfffff@`\@`s33333@``     @`c33333@`c33333@`Vfffff@`c33333@`p     @`p     @`vfffff@`c33333@`l@`s33333@`vfffff@`     @`@`l@`i@`p     @`y@`fffff@`l@`vfffff@`@`fffff@`fffff@`vfffff@`y@`y@`33333@`     @`@`     @`33333@`     @`p     @`|@`@`     @`@`fffff@`fffff@`fffff@`33333@`     @`@`33333@`@`33333@`33333@`33333@`     @`@`@`33333@`@`fffff@`fffff@`     @`y@`@`     @`fffff@`@`     @`fffff@`33333@`     @`@`@`33333@`@`     @`@`33333@`     @`     @`fffff@`     @`@`fffff@`     @`     @`@`@`fffff@`@`@`33333@`fffff@`33333@`fffff@`@`     @`fffff@`@`33333@`@`ə@`     @`ٙ@`     @`fffff@`ə@`@`     @`fffff@`     @`@`33333@`@`33333@`@`     @`@`     @`     @`fffff@`     @`     @`@`33333@`@`fffff@`fffff@`fffff@`@`ٙ@`     @`fffff@`@`陙@`fffff@`     @`@`fffff@`33333@`@`fffff@`33333@`     @`@`@`33333@`@`33333@`ٙ@`@`fffff@`@`@`@`@`@`     @`33333@`@`fffff@`ə@`fffff@`33333@`@`@`33333@`     @`陙@`fffff@`     @`     @`ٙ@`     @`fffff@`@`33333@`@`33333@`@`@`陙@`33333@`ٙ@`@`fffff@`@`     @`@`     @`     @`33333@`fffff@afffff@`@`33333@`fffff@`     @`     @afffff@`@`fffff@`ٙ@`     @`fffff@`fffff@`33333@`     @`fffff@`fffff@afffff@a33333@`@`fffff@`ٙ@`fffff@`@`@`fffff@`fffff@`33333@a      @a33333@a33333@`33333@`@a      @`fffff@`陙@`     @a      @`@`@`fffff@a	@`     @`陙@a33333@`@`33333@a@`@a	@`@`陙@a@a33333@`@a	@a	@`fffff@a@afffff@a      @a	@a	@afffff@a@a      @afffff@a33333@a33333@a33333@afffff@afffff@a     @a	@`@a@afffff@a	@a	@a@a@a33333@a33333@a33333@`@a33333@a      @afffff@a33333@`@a      @a)@a      @a@afffff@a@a@a     @`@a      @a     @a     @afffff@a33333@a      @afffff@a33333@a@afffff@a      @a@afffff@a      @afffff@a#33333@a#33333@a@afffff@a33333@a#33333@a&fffff@a6fffff@afffff@a	@a      @a@a@a@a     @a,@a@a@a@a      @a     @a)@a#33333@afffff@a0     @a      @a#33333@a     @a@a@a)@a)@a&fffff@a@a      @a33333@a@a)@a,@a333333@a&fffff@a#33333@a@afffff@a      @a@a	@a      @a@aFfffff@a&fffff@a	@aI@a      @a9@a#33333@a	@a#33333@a<@a)@a@     @a      @a,@a6fffff@a333333@a@a@aFfffff@aL@a#33333@afffff@a#33333@a,@aS33333@a<@afffff@a)@a@     @a0     @a@a0     @a&fffff@a&fffff@a)@a     @a0     @a9@a@a)@a333333@a)@a@a,@a)@a)@aI@a0     @afffff@a@a#33333@a,@a      @a)@a      @a6fffff@a333333@a@a,@a#33333@a,@a)@afffff@a@a)@a#33333@a)@a#33333@a333333@a9@a      @a@a0     @a)@a#33333@a#33333@a&fffff@afffff@a     @a      @a)@aFfffff@a      @a@a@     @aFfffff@a     @a33333@a@     @a,@a@a333333@a<@a,@a6fffff@a&fffff@a      @a)@a333333@a@afffff@a)@a<@a&fffff@a6fffff@a@a)@a9@a,@a@a#33333@a)@a0     @a&fffff@afffff@a<@afffff@a<@aP     @a6fffff@afffff@`@a333333@a6fffff@a0     @a&fffff@a,@aC33333@a&fffff@a)@a)@afffff@a6fffff@aC33333@afffff@a33333@a#33333@a6fffff@a#33333@a&fffff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ?I^5?vȴ9X?zG?zG?zG?⟾vȴ9?n?⟾vȴ9?lC?M?E?lC?E?5?|h?1&?5?|h?5?|h?m?⟾vȴ9?~"?m?Q?tj?Q?I^5??^5?|?-V?ffffff?I^5??-V?zG?$/?hr ?tj?\(?Q?hr ?m?lD?$/?XbM?7KƧ?S?`A7K?7KƧ?7KƧ?9XbN?zG{?ާ-?|hr?ffffff?E?\(?Vt?\(?ȴ9Xb?vȴ9X?+?\(\?ȴ9Xb?KƧ?߮zG?ffffff?ݲ-V?ݑhr ?vȴ9X?ffffff?އ+I?ffffff?ާ-?vȴ?Vt?-V?;dZ?$/?x?vȴ?޸Q?ާ-?ݲ-V?-V?S?E?އ+I?އ+I?O;dZ?ݑhr ?
=p
?ݡo?/w?ݲ-V?tj?݁$/?O;dZ?`A7K?/v?ݡo?ݲ-V?E?/w?܋C%?tj?"`A?ۅQ?-V?ٙ?ם-V?9XbM?1&x?Ł$/?7KƧ?vȴ9X?(\)?"`B?E?ȴ9Xb??|hs?9XbM?j~#?E?tj~? ě?nO;?nO;?nO;?E?E? ě?-V?Q?-V?nO;?Q?lD?nO;?-V?lD?-V?hr Ĝ?hr Ĝ?lD?lD?lD?-V?-V?-V?Q?nO;? ě?`A7L?lD?
=p?lD?lD?&x?&x?`A7L?`A7L?`A7L?
=p?`A7L?bM?hr Ĝ?&x?
=p?bM?vȴ9X?
=p?bM?bM?bM?
=p? ěT?
=p? ěT?bM? ěT?
=p?
=p?
=p?&x?`A7L?`A7L?`A7L?bM?bM? ěT?vȴ9X? ěT? ěT? ěT?vȴ9X?`A7L?&x?hr Ĝ?&x?Q?bM?bM?bM? ěT? ěT? ěT?vȴ9X?bM?vȴ9X?bM? ěT?vȴ9X? ěT? ěT?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?bM? ě?vȴ9X?lD?vȴ9X?vȴ9X? ěT? ěT?vȴ9X?vȴ9X? ěT?bM?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?5?|h?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?/v?5?|h?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?Q?;dZ?Q? ěT?Q?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?vȴ9X?;dZ?Q?Q?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ? ěT?vȴ9X?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?`A7L? ěT?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X? ěT?vȴ9X?;dZ?bM? ěT?;dZ?vȴ9X?`A7L?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?bM?bM?bM?bM?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ? ěT?vȴ9X?Q?Q?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ? ěT?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?5?|h?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?Q?Q?Q?Q?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ? ěT?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?vȴ9X?vȴ9X?Q?;dZ?vȴ9X?;dZ?vȴ9X?Q?;dZ?;dZ?vȴ9X?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?vȴ9X? ěT?vȴ9X?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?vȴ9X?vȴ9X?;dZ?Q?;dZ?Q?;dZ?Q?Q?;dZ?Q?5?|h?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?hr Ĝ? ěT?;dZ?Q?;dZ?;dZ?Q?Q?Q?bM?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?vȴ9X?;dZ?Q?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?Q?vȴ9X?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?5?|h?Q?Q?vȴ9X?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?Q?;dZ?Q?;dZ?5?|h?Q?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?5?|h?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?Q?;dZ?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?;dZ?Q?5?|h?Q?Q?;dZ?;dZ?Q?Q?Q?Q?;dZ?5?|h?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?;dZ?5?|h?Q?Q?Q?Q?5?|h?Q?;dZ?;dZ?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?;dZ?Q?;dZ?Q?;dZ?5?|h?Q?;dZ?Q?Q?;dZ?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?Q?5?|h?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?-V?5?|h?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?Q?;dZ?Q?Q?;dZ?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?-V?5?|h?-V?5?|h?/v?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?-V?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?Q?Q?Q?5?|h?5?|h?-V?Q?-V?5?|h?Q?Q?5?|h?Q?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?-V?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?5?|h?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?5?|h?-V?5?|h?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?-V?5?|h?5?|h?Q?5?|h?5?|h?/v?-V?5?|h?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?5?|h?/v?-V?5?|h?/v?-V?5?|h?-V?/v?5?|h?5?|h?5?|h?-V?-V?5?|h?-V?-V?5?|h?5?|h?Q?5?|h?5?|h?-V?-V?5?|h?5?|h?5?|h?/v?5?|h?5?|h?5?|h?-V?/v?-V?-V?/v?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?/v?/v?5?|h?-V?-V?5?|h?5?|h?-V?-V?5?|h?-V?/v?5?|h?-V?/v?/v?/v?/v?5?|h?5?|h?-V?/v?5?|h?5?|h?5?|h?-V?-V?-V?-V?/v?1&y?1&y?-V?/v?-V?5?|h?1&y?/v?-V?5?|h?5?|h?/v?/v?/v?5?|h?1&y?/v?/v?/v?1&y?/v?/v?/v?/v?5?|h?5?|h?-V?-V?5?|h?/v?/v?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?/v?5?|h?-V?1&y?-V?-V?/v?5?|h?-V?1&y?1&y?/v?/v?/v?/v?/v?/v?5?|h?1&y?1&y?-V?5?|h?-V?5?|h?/v?1&y?/v?/v?1&y?1&y?/v?/v?/v?/v?/v?5?|h?/v?5?|h?1&y?1&y?1&y?/v?/v?1&y?1&y?1&y?/v?/v?/v?/v?/v?/v?/v?1&y?/v?/v?/v?1&y?/v?/v?1&y?/v?1&y?1&y?/v?/v?/v?-V?1&y?/v?1&y?1&y?1&y?1&y?1&y?-V?-V?/v?-V?/v?/v?1&y?/v?/v?-V?/v?1&y?1&y?/v?-V?1&y?1&y?1&y?1&y?/v?/v?/v?1&y?1&y?1&y?/v?/v?1&y?1&y?(\)?1&y?1&y?/v?/v?(\)?(\)?1&y?1&y?1&y?1&y?(\)?/v?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?/v?1&y?(\)?1&y?1&y?/v?1&y?/v?1&y?1&y?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?/v?/v?(\)?1&y?(\)?/v?-V?/v?1&y?1&y?1&y?(\)?(\)?/v?1&y?1&y?/v?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?1&y?/v?1&y?/v?1&y?1&y?(\)?1&y?(\)?1&y?(\)?1&y?(\)?(\)?1&y?(\)?1&y?1&y?1&y?(\)?/v?/v?(\)?1&y?1&y?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?(\)?1&y?1&y?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?1&y?1&y?(\)?(\)?1&y?1&y?(\)?(\)?1&y?1&y?1&y?(\)?1&y?1&y?1&y?(\)?1&y?(\)?(\)?(\)?1&y?1&y?1&y?(\)?(\)?(\)?1&y?1&y?1&y?1&y?1&y?1&y?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?1&y?1&y?1&y?1&y?1&y?(\)?(\)?1&y?(\)?1&y?1&y?(\)?(\)?(\)?S?(\)?(\)?S?1&y?1&y?(\)?1&y?1&y?(\)?(\)?(\)?1&y?1&y?(\)?/v?(\)?(\)?(\)?(\)?1&y?1&y?1&y?(\)?1&y?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?S?S?S?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?1&y?(\)?(\)?1&y?(\)?1&y?1&y?(\)?(\)?(\)?(\)?1&y?1&y?1&y?(\)?(\)?S?S?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?1&y?S?"`A?(\)?1&y?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?(\)?S?(\)?(\)?1&y?S?(\)?(\)?(\)?(\)?(\)?S?S?S?(\)?(\)?(\)?(\)?(\)?S?S?S?S?S?S?(\)?(\)?S?"`A?(\)?(\)?(\)?(\)?S?(\)?S?S?S?(\)?(\)?S?S?S?(\)?S?S?S?(\)?S?S?(\)?S?(\)?(\)?(\)?(\)?1&y?S?(\)?(\)?S?S?S?S?(\)?1&y?(\)?S?S?S?S?(\)?S?S?(\)?(\)?S?S?S?S?S?S?(\)?S?S?(\)?(\)?(\)?S?S?(\)?(\)?S?S?S?S?(\)?S?(\)?S?(\)?S?S?S?S?(\)?1&y?(\)?(\)?S?S?S?S?S?S?S?S?(\)?S?"`A?S?(\)?S?(\)?(\)?(\)?S?"`A?S?S?S?(\)?S?S?(\)?S?(\)?(\)?S?S?(\)?S?S?S?S?S?S?"`A?S?S?(\)?S?S?S?S?S?S?S?S?"`A?S?"`A?S?"`A?S?S?S?S?"`A?"`A?"`A?S?S?S?S?S?"`A?"`A?S?S?S?S?vȴ9?S?S?(\)?S?S?(\)?(\)?S?"`A?S?S?"`A?vȴ9?"`A?(\)?"`A?S?S?"`A?S?S?S?"`A?S?"`A?"`A?S?"`A?S?S?S?S?S?S?S?"`A?S?S?"`A?"`A?S?"`A?"`A?S?S?"`A?S?"`A?S?S?(\)?S?"`A?"`A?S?S?(\)?S?S?"`A?S?S?S?S?S?(\)?S?"`A?S?S?"`A?S?"`A?"`A?"`A?"`A?S?S?"`A?"`A?vȴ9?"`A?S?S?"`A?S?S?"`A?"`A?vȴ9?"`A?vȴ9?S?"`A?"`A?S?S?S?S?S?S?S?S?"`A?S?S?"`A?S?"`A?S?S?"`A?"`A?"`A?S?"`A?S?"`A?"`A?vȴ9?"`A?"`A?S?"`A?S?"`A?S?S?"`A?"`A?"`A?S?S?"`A?"`A?S?S?"`A?"`A?"`A?vȴ9?vȴ9?S?S?"`A?vȴ9?"`A?S?S?S?"`A?S?"`A?"`A?vȴ9?"`A?"`A?S?S?"`A?S?"`A?S?S?"`A?vȴ9?"`A?S?"`A?"`A?S?"`A?"`A?"`A?S?S?"`A?S?"`A?vȴ9?"`A?"`A?"`A?vȴ9?"`A?S?S?vȴ9?"`A?"`A?"`A?"`A?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?vȴ9?"`A?vȴ9?"`A?vȴ9?"`A?"`A?"`A?"`A?"`A?vȴ9?"`A?S?S?"`A?"`A?vȴ9?S?S?"`A?vȴ9?1&?S?vȴ9?"`A?"`A?S?"`A?"`A?vȴ9?S?"`A?1&?1&?vȴ9?1&?"`A?"`A?"`A?S?"`A?"`A?1&?"`A?vȴ9?"`A?1&?"`A?vȴ9?"`A?"`A?vȴ9?vȴ9?"`A?"`A?"`A?S?vȴ9?S?vȴ9?vȴ9?"`A?S?S?vȴ9?"`A?"`A?"`A?"`A?S?"`A?"`A?"`A?"`A?"`A?"`A?"`A?1&?"`A?"`A?1&?"`A?S?"`A?"`A?vȴ9?vȴ9?1&?"`A?"`A?vȴ9?1&?"`A?vȴ9?"`A?vȴ9?"`A?1&?vȴ9?vȴ9?vȴ9?1&?1&?"`A?vȴ9?vȴ9?vȴ9?vȴ9?vȴ9?1&?vȴ9?S?vȴ9?vȴ9?vȴ9?1&?vȴ9?vȴ9?S?vȴ9?"`A?vȴ9?"`A?"`A?"`A?"`A?1&?vȴ9?1&?"`A?vȴ9?vȴ9??vȴ9?1&?vȴ9?1&?"`A?vȴ9?"`A?1&?vȴ9?1&?vȴ9?"`A?vȴ9?vȴ9?1&??vȴ9?"`A?1&?vȴ9?1&?vȴ9?vȴ9?1&?vȴ9?1&?1&?1&?1&?"`A?1&?1&?1&??"`A?1&?"`A?"`A?"`A?1&?1&?1&??vȴ9?1&?vȴ9?1&?1&?vȴ9?vȴ9?1&?vȴ9?1&?vȴ9?vȴ9?1&?1&?1&?1&?1&?vȴ9?1&??1&??vȴ9?vȴ9?"`A?vȴ9?vȴ9?1&??vȴ9?1&???1&?vȴ9?1&?vȴ9?"`A?vȴ9?vȴ9?vȴ9?"`A?1&?vȴ9?1&?1&?vȴ9??1&?1&?vȴ9??1&?vȴ9?1&?1&?1&?1&?vȴ9?1&?1&?vȴ9?1&?vȴ9?vȴ9?"`A?vȴ9?1&?1&?"`A?vȴ9??1&?1&?vȴ9?1&?1&?vȴ9?1&?1&?vȴ9?1&??1&??vȴ9?1&?1&??1&?vȴ9?1&?1&?1&?1&??1&?1&?"`A?vȴ9?1&?1&?vȴ9?vȴ9?vȴ9?vȴ9?1&?vȴ9?vȴ9?1&?1&?1&?1&?vȴ9?vȴ9?1&?1&?1&?vȴ9?1&?vȴ9?1&?1&?vȴ9?1&?1&?1&?1&?1&?1&?vȴ9?1&?1&?1&?1&?1&?1&?vȴ9?1&?1&?1&?1&????1&?1&?1&???1&?1&?1&?1&?1&?1&?1&?1&???1&?1&??1&?1&??1&?1&?1&?vȴ9??1&??1&?1&?1&????1&?1&?1&????vȴ9?1&??1&?1&?1&?1&?1&?1&?vȴ9?????1&?1&???vȴ9?1&??????1&??1&?1&?1&?1&?1&?1&????1&?1&???1&???1&???1&???+J??1&??vȴ9??1&?1&??????1&?1&?1&?vȴ9??1&?1&??1&??1&???1&????1&?1&?+J??????1&?1&?1&??????1&??1&????1&??1&????1&?1&??+J?1&????+J???1&?1&??1&??+J?????1&?????+J????1&?vȴ9?????1&?1&???1&?????????+J???+J?????1&?????1&??????1&??+J??1&?1&??1&??1&????1&?1&??????1&??1&?????????????????1&???1&???1&??1&???1&???+J????+J???????+J?1&???1&?1&?"`A?vȴ9????1&??+J????????+J??1&????+J?+J??+J?+J???+J?+J???tj~?+J?+J??+J??+J?1&?+J?+J????+J?+J?+J?+J?+J?+J??+J?+J?+J?tj~?+J??+J??1&??+J?????+J?1&??+J????????+J?+J??+J???????1&???+J??+J?+J???+J?tj~??+J?+J?+J???+J?+J???+J???+J??+J?????????+J?+J??+J?+J?+J??1&???+J??+J?tj~?+J????+J?+J??+J??????+J?+J??????+J?+J??+J?+J???+J???+J??+J?+J?+J?+J??+J????+J?+J??+J?+J?+J?+J?+J?+J?+J?+J?+J?????+J?+J?+J?+J?+J??+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J????+J?+J?+J?+J???+J?+J???+J?+J??+J?+J?+J?+J?+J?+J?+J?????+J?+J?+J?+J??+J?+J??+J?+J???+J?+J??+J?tj~?+J??+J??+J?+J?+J??+J?+J?tj~?+J?+J???+J?+J?+J?+J?+J?+J??+J???+J???+J??+J?????+J?+J??+J??+J??+J?+J?+J?tj~?+J?+J?+J?+J??+J?+J?+J?+J??+J?+J?+J?+J?+J?+J?+J?+J???+J??+J??+J?+J?+J?+J?+J?+J?+J??+J???+J??+J??+J?+J??+J?+J?+J?+J?+J?+J?+J??+J??+J?+J?+J???+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J??+J?+J?+J??+J?+J??tj~?+J?+J???+J???+J?+J????+J?+J?+J?+J??+J?+J?+J??+J??+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J??+J??+J?+J?+J?+J?tj~?O;dZ?tj~?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?tj~?tj~?tj~?+J?+J?+J?+J?O;dZ?tj~?+J?+J?+J?+J?+J??+J?tj~?+J?+J?+J?+J?+J?+J?+J?bM?tj~?tj~?+J?+J?+J?tj~??+J?tj~?+J?+J?+J?tj~?+J?+J?+J?+J?tj~?+J?+J?+J?+J?tj~?bM?+J?+J?+J?+J?tj~?+J??tj~?+J?+J?+J?+J?+J?+J??+J?+J?+J?+J?tj~?+J?+J?tj~?tj~?tj~?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J??+J?tj~?tj~?tj~?+J?+J?+J?tj~?tj~?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?tj~?tj~?tj~?+J?+J??tj~?+J?+J??+J?+J?+J?+J?tj~?+J?tj~?tj~?+J?tj~?+J?+J?bM?+J?+J?+J?tj~?bM??+J?tj~?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?+J?+J?bM?tj~?tj~?+J?+J?+J?+J?+J??+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?+J?+J?tj~?tj~?+J?tj~?+J?+J?tj~?+J?+J?tj~?tj~?tj~?+J?+J?tj~?tj~?+J?tj~?+J?+J?tj~?+J?+J?+J?tj~?+J?tj~?bM?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?tj~?+J???tj~?+J?tj~?tj~?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?tj~?+J?+J?+J?tj~?tj~?+J?tj~?+J?+J?tj~?+J?tj~?tj~?+J?tj~?+J?tj~?tj~?tj~?tj~?bM?tj~?tj~?+J?+J?+J?+J?+J?+J?+J?+J?tj~?tj~?+J??+J?tj~?tj~?tj~?tj~?tj~?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?tj~?+J?tj~?tj~?+J?+J?tj~?+J?tj~?+J?+J?+J?+J?+J?+J?tj~?tj~?tj~?tj~??tj~?tj~?+J?+J?+J?tj~?tj~?+J?+J?+J?+J?tj~?+J?+J?tj~?+J?tj~?tj~?tj~?+J?tj~?+J?+J?+J?+J?+J?+J?tj~?tj~?tj~??tj~?+J?tj~?+J?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?+J?tj~?+J?+J?tj~?tj~?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?tj~?+J?+J?+J?+J?+J?+J?+J?+J?+J?+J?bM?+J?+J?+J?bM?+J?+J?+J?+J?tj~?tj~?+J?tj~?+J?+J?+J?tj~?+J?+J?tj~?+J?tj~?tj~?+J?+J?tj~?tj~?+J?tj~?+J?+J?tj~?tj~?+J?+J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P26                                     4                                       )BH -3