CDF       
      pressure  %   time      latitude      	longitude         string_dimension   (      
   EXPOCODE      18DD20170205   Conventions       COARDS/WOCE    WOCE_VERSION      3.0    	DATA_TYPE         WOCE CTD   STATION_NUMBER        P3     CAST_NUMBER       1      BOTTOM_DEPTH_METERS       8        
Creation_Time         2025-02-15T13:53:33.732016Z    ORIGINAL_HEADER      6CTD,20250210CCHSIOWB
#Removed 'CTDFLUOR_TSG' as it's filled with -999
#For information on how to cite this dataset, please visit cchdo.ucsd.edu
#CTD,20201211CCHSIOLM
#
# Please cite as follows:
#
# DFO Institute of Ocean Sciences Data Archive; Ocean Sciences Division; Department of Fisheries and Oceans Canada (http://www.pac.dfo-mpo.gc.ca/science/oceans/data-donnees/index-eng.html). 2017-06-29. CTD data from cruise 18DD20170205, [format version used, e.g. NetCDF, Exchange, etc.]. Accessed from CCHDO https://cchdo.ucsd.edu/cruise/18DD20170205. Access date [date of download from CCHDO].
#
#
# This Exchange data file was created using an originator supplied
# concatenated file of all the individual files, where the concatenated
# file is located at
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-ctd-cruise.csv
# on the originator cruise page 
# https://www.waterproperties.ca/linep/2017-001/index.php. 
#
# The information in this file for the cruise 2017-001 is 
# from the individual file content contained in the concatenated file. 
# An individual file contains a single STNNBR and a single EVENT_NUMBER.
# The concatenated file allowed for faster processing of all the stations. 
#
# The EVENT_NUMBER is an identifier for station, position, dates, 
# and sampling as noted in a table on the originator cruise page. 
# The originator used EVENT_NUMBERs instead of a CASTNO that Exchange 
# formated files use, so CCHDO assigned a CASTNO in addition to an 
# EVENT_NUMBER for each STNBR by starting the CASTNO at 1 for the first
# EVENT_NUMBER and incrementing by 1 for each sequential EVENT_NUMBER.
#
# Not all parameters were used in the conversion to the Exchange format.
# The following parameters were used and renamed for the Exchange format 
# where exchange_name is the Exchange format name and original_name 
# is the originator name: 
# exchange_name: CTDPRS, original_name: Pressure:CTD,
# exchange_name: CTDTMP, original_name: Temperature:CTD,
# exchange_name: CTDSAL, original_name:Salinity:CTD,
# exchange_name: CTDSAL, original_name: Salinity:Practical:CTD,
# exchange_name: CTDOXY, original_name: Oxygen:Dissolved:CTD:Mass,
# exchange_name: CTDBEAMCP, original_name: Transmissivity:CTD,
# exchange_name: CTDFLUOR, original_name:  Fluorescence:CTD:Seapoint,
# exchange_name: CTDFLUOR, original_name: Fluorescence:CTD,
# exchange_name: CTDFLUOR_TSG, original_name:Fluorescence:CTD:Wetlabs,
# exchange_name: PAR, original_name: PAR:CTD
#
# The following header comments are from the individual originator file 
# for one STNNBR and one EVENT_NUMBER
# https://www.waterproperties.ca/linep/2017-001/donneesctddata/2017-001-0036.ctd
#
# Start of originator file comment header
#
#*2017/06/29 15:26:50.02
#*IOS HEADER VERSION 2.0      2016/04/28 2016/06/13 IVF16
#
#*FILE
#    START TIME          : UTC 2017/02/10 06:17:38.000
#    TIME INCREMENT      : 0 0 0 0.416667E-01 0  ! (day hr min sec ms)
#    NUMBER OF RECORDS   : 198
#    DATA DESCRIPTION    : CTD
#    FILE TYPE           : ASCII
#    CRC                 : CE9F1F72
#    NUMBER OF CHANNELS  : 8
#
#    $TABLE: CHANNELS
#    ! No Name                          Units           Minimum        Maximum
#    !--- ----------------------------- --------------- -------------- --------------
#       1 Pressure:CTD                  dbar            0.3            202.1
#       2 Temperature:CTD               deg_C_(ITS90)   5.6248         6.8697
#       3 Salinity:CTD                  PSS-78          32.78          33.8432
#       4 Sigma-t:CTD                   kg/m^3          25.7461        26.7106
#       5 Oxygen:Dissolved:CTD:Volume   ml/l            3.4            6.87
#       6 Oxygen:Dissolved:CTD:Mass     µmol/kg         147.7          299
#       7 Fluorescence:CTD:Seapoint     mg/m^3          0.66E-01       1.162
#       8 PAR:CTD                       µE/m^2/sec      0              0.3
#    $END
#
#    $TABLE: CHANNEL DETAIL
#    ! No  Pad   Start  Width  Format  Type  Decimal_Places
#    !---  ----  -----  -----  ------  ----  --------------
#       1  -99   ' '        7  F       ' '     1
#       2  -99   ' '        9  F       ' '     4
#       3  -99   ' '        9  F       ' '     4
#       4  -99   ' '        9  F       R4      4
#       5  -99   ' '        7  F       ' '     2
#       6  -99   ' '        6  F       ' '     1
#       7  -99   ' '        8  F       ' '     3
#       8  -99   ' '        7  F       ' '     1
#    $END
#
#*ADMINISTRATION
#    MISSION             : 2017-001
#    AGENCY              : IOS, Ocean Sciences Division, Sidney, B.C.
#    COUNTRY             : Canada
#    PROJECT             : Line P
#    SCIENTIST           : Robert M.
#    PLATFORM            : John P. Tully
#
#*LOCATION
#    GEOGRAPHIC AREA     : North-East Pacific
#    STATION             : P21
#    EVENT NUMBER        : 36
#    LATITUDE            :  49  38.00000 N  ! (deg min)
#    LONGITUDE           : 139  39.97000 W  ! (deg min)
#    WATER DEPTH         : 3961
#
#*INSTRUMENT
#    TYPE                : Sea-Bird CTD
#    MODEL               : SBE-911plus
#    SERIAL NUMBER       : 0506
#    LOCATION            : Mid-ship                              ! custom item
#
#*COMMENTS
#    The descent rate of the CTD was very noisy with some complete reversals
#	of direction.
#    CTDEDIT was used to remove many records corrupted by shed wakes;
#	salinity was cleaned lightly.
#
#    Data Processing Notes:
#    ----------------------
#    Fluorescence and PAR data are nominal and unedited except that some records were
#	removed in editing temperature and salinity and a large spike in
#	fluorescence was removed from file 0032.
#
#    The Transmissivity channel was removed because of frequent shifts in values during
#	casts and large variations between values during repeat casts.
#	The data are available, by request, from the chief scientist.
#
#    NOTE: While the Fluorescence:CTD data are expressed in concentration units, they
#	do not always compare well to extracted chlorophyll samples, particularly for
#	casts far from shore. It is recommended that users check extracted chlorophyll
#	values where available.
#
#    Oxygen:Dissolved:CTD was calibrated using the method described in Sea-Bird
#	Application Note #64-2, June 2012 revision (Sea-Bird_64-2_Jun2012.pdf), except 
#	that a small offset in the fit was allowed.
#
#    The Dissolved Oxygen sensor used in files 0001, 0002 and 0016 malfunctioned so the 
#	Oxygen:Dissolved:CTD channels were removed from those files.
#
#    The Oxygen:Dissolved:CTD sensor has a fairly long response time so data accuracy 
#	is not as high when it is in motion as it is during stops for bottles. This will be
#	especially true when vertical dissolved oxygen gradients are large. To get an estimate
#	of the accuracy of the Oxygen:Dissolved:CTD data during downcasts (after recalibration)
#	a rough comparison was made between downcast Oxygen:Dissolved:CTD data and upcast 
#	titrated samples. Some of the difference will be due to problems with flushing of 
#	Niskin bottles and/or analysis errors, so the following statement likely underestimates 
#	Oxygen:Dissolved:CTD accuracy.
#
#    Downcast (CTD files) Oxygen:Dissolved:CTD data are considered, very roughly, to be:
#	±0.25 ml/l from 0 to 125 dbar.
#	±0.2 ml/l from 125 to 400 dbar.
#	±0.1 ml/l from 400 to 600 dbar.
#	±0.05 ml/l from 600 to 1500 dbar.
#	Low by up to 0.08 ml/l below 1500 dbar.
#
#    For details on the processing see document: 2017-001-proc.pdf.
#
#!--1--- ---2---- ---3---- ---4---- --5--- --6-- ---7--- --8---
#!Pressu Temperat Salinity Sigma-t: Oxygen Oxyge Fluores PAR:  
#!re:CTD ure:CTD  :CTD     CTD      :Disso n:Dis cence:  CTD   
#!                                  lved:  solve CTD:          
#!                                  CTD:   d:CTD Seapoin       
#!                                  Volume :Mass t             
#!------ -------- -------- -------- ------ ----- ------- ------
#*END OF HEADER
     WOCE_CTD_FLAG_DESCRIPTION         ::1 = Not calibrated:2 = Acceptable measurement:3 = Questionable measurement:4 = Bad measurement:5 = Not reported:6 = Interpolated over >2 dbar interval:7 = Despiked:8 = Not assigned for CTD data:9 = Not sampled:
            EVENT_NUMBER                	long_name         EVENT_NUMBER   units         unspecified    data_min      @0         data_max      @0         C_format      %f     WHPO_Variable_Name        EVENT_NUMBER     (  2   pressure                	long_name         pressure   positive      down   units         decibar    data_min      ?   data_max      @G33333   C_format      %8.1f      WHPO_Variable_Name        CTDPRS     OBS_QC_VARIABLE       pressure_QC      (  L   pressure_QC                 	long_name         pressure_QC_flag   units         
woce_flags     C_format      %1d      L  e4   temperature                 	long_name         temperature    units         ?C (ITS-90)    data_min      @%O
   data_max      @#[W?   C_format      %8.4f      WHPO_Variable_Name        CTDTMP     OBS_QC_VARIABLE       temperature_QC       (  k   temperature_QC                  	long_name         temperature_QC_flag    units         
woce_flags     C_format      %1d      L     salinity                	long_name         salinity   units         PSS-78     data_min      @@DD   data_max      @A$qj   C_format      %8.4f      WHPO_Variable_Name        CTDSAL     OBS_QC_VARIABLE       salinity_QC      (     salinity_QC                 	long_name         salinity_QC_flag   units         
woce_flags     C_format      %1d      L     oxygen                  	long_name         oxygen     units         ?mol/kg    data_min               data_max               C_format      %9.4f      WHPO_Variable_Name        CTDOXY     OBS_QC_VARIABLE       	oxygen_QC        (  h   	oxygen_QC                   	long_name         oxygen_QC_flag     units         
woce_flags     C_format      %1d      L  Ð   CTDFLUOR                	long_name         CTDFLUOR   units         MG/M^3     data_min      ?S   data_max      ?lC   C_format      %f     WHPO_Variable_Name        CTDFLUOR   OBS_QC_VARIABLE       CTDFLUOR_QC      (     CTDFLUOR_QC                 	long_name         CTDFLUOR_QC_flag   units         
woce_flags     C_format      %1d      L     PAR                 	long_name         PAR    units         UMOL/M^2/SEC   data_min                 data_max      ?   C_format      %f     WHPO_Variable_Name        PAR    OBS_QC_VARIABLE       PAR_QC       (  P   PAR_QC                  	long_name         PAR_QC_flag    units         
woce_flags     C_format      %1d      L x   	CTDBEAMCP                   	long_name         	CTDBEAMCP      units         /METER     data_min               data_max               C_format      %f     WHPO_Variable_Name        	CTDBEAMCP      OBS_QC_VARIABLE       CTDBEAMCP_QC     (    CTDBEAMCP_QC                	long_name         CTDBEAMCP_QC_flag      units         
woce_flags     C_format      %1d      L !   station                	long_name         STATION    units         unspecified    C_format      %s     	_Encoding         utf-8         ( (8   cast               	long_name         CAST   units         unspecified    C_format      %s     	_Encoding         utf-8         ( (`   time               	long_name         time   units         !minutes since 1980-01-01 00:00:00      data_min      ){   data_max      ){   C_format      %10d       (   latitude               	long_name         latitude   units         	degrees_N      data_min      @HO-   data_max      @HO-   C_format      %9.4f          (   	longitude                  	long_name         	longitude      units         	degrees_E      data_min      _`A7L   data_max      _`A7L   C_format      %9.4f          (   	woce_date                  	long_name         	WOCE date      units         yyyymmdd UTC   data_min      3   data_max      3   C_format      %8d        (   	woce_time                  	long_name         	WOCE time      units         hhmm UTC   data_min           data_max           C_format      %4d        (@0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      @0      ??ffffff@      @      @      @      @      @ 333333@"      @#@&      @(      @*      @,      @.      @0      @1      @2      @3      @4      @5      @6      @7      @8      @9      @:      @;@<      @=      @>      @?      @@      @@     @A      @A     @B      @B     @C      @C     @D      @D     @E      @E     @F      @F     @G      @G     @H      @H     @I      @I     @J      @J     @K      @K     @L      @L     @M      @M     @N333333@N     @O      @O     @P      @P@     @P     @P     @Q      @QFfffff@Q     @Q     @R      @R@     @R     @R     @S      @S,@Sy@S@T      @T@     @T     @T     @Ufffff@UFfffff@Uy@U     @V      @V@     @V     @V     @W      @W@     @W     @W     @X      @X@     @X     @X     @Y      @Y@     @Y     @Y     @Z      @Z@     @Z     @Z     @[      @[@     @[     @[     @\      @\9@\     @\     @]      @]@     @]     @]     @^@     @^     @^     @_      @_@     @_     @_     @`      @`      @`@     @``     @`     @`     @`     @`     @a      @a      @a@     @a`     @a     @a     @a     @a     @b      @b      @b@     @b`     @b     @b@bfffff@b     @c      @c      @c@     @c`     @c     @c     @c     @c     @d      @d      @d@     @d`     @d     @d33333@də@d     @e      @e      @e@     @e`     @e     @e     @e     @e     @f      @f      @f@     @f`     @f     @f     @f     @f     @g      @g#33333@g@     @g`     @g     @g     @g     @g     @h      @h      @h@     @h`     @h     @h     @h     @h     @i      @i      @i@     @i`     @i     @i     @i     @i@j33333@j      @j@     @j`     @j     @j     @j33333@j     @kfffff@k      @k@     @k`     @k     @k     @k     @k33333@k@l      @l@     @l`     @l     @l     @l     @l     @m      @m      @m@     @m`     @m     @m     @m     @m     @n      @n      @n@     @n`     @n     @n     @n     @n     @o      @o      @o@     @o`     @o     @o     @o     @o     @p      @p     @p      @p0     @p>fffff@pNfffff@p`     @pp     @p     @p     @p     @p     @p     @p     @p     @p     @q      @q     @q      @q0     @q@     @qP     @q`     @qp     @q     @q     @q     @q     @q     @q     @qᙙ@q     @r      @r     @r      @r0     @r@     @rP     @r\@rq@r     @r     @r     @r     @r     @r     @r     @r     @s      @s     @s      @s0     @s@     @sP     @s`     @sp     @s     @s     @s     @s     @sfffff@s     @s     @s     @t@t	@t!@t0     @t@     @tP     @t`     @tp     @t     @t     @t33333@t@t     @t     @t     @t     @u      @u     @u!@u.fffff@u@     @uP     @u`     @up     @u     @u     @u     @u     @u     @u     @u     @u     @v      @v     @v      @v0     @v@     @vP     @v`     @vp     @v     @v     @v     @v     @v     @v     @v     @v     @w      @w     @w      @w0     @w@     @wP     @w`     @wp     @w     @wfffff@w     @w     @w     @w     @w     @w     @x      @x     @x      @x0     @x@     @xP     @x^fffff@xvfffff@x     @x     @x     @x     @x     @xљ@x     @x     @y      @y     @y      @y0     @y@     @yP     @y`     @yp     @y     @y     @y     @y     @y     @y     @y     @y     @z      @z     @z      @z0     @z9@zQ@z^fffff@zp     @z     @z     @z     @z     @z     @z     @z     @z     @{      @{33333@{      @{0     @{@     @{P     @{`     @{l@{     @{     @{     @{     @{     @{     @{     @{     @|      @|     @|fffff@|0     @|@     @|P     @|`     @|p     @|     @|@|     @|     @|     @|     @}      @}     @}      @}0     @}@     @}P     @}`     @}p     @}     @}     @}     @}     @}@}     @}     @}     @~      @~     @~      @~(     @~Ffffff@~P     @~`     @~p     @~     @~     @~     @~     @~fffff@~     @~     @~     @      @     @      @0     @@     @P     @`     @p     @     @     @     @     @     @     @33333@񙙙@      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @@     @     @     @     @     @     @     @ @     @     @     @      @(     @0     @5@@@H     @P     @X     @`     @h     @p     @vfffff@@     @     @     @     @     @     @     @     @@33333@     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @@@     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @Nfffff@X     @`     @h     @p     @x     @     @     @     @     @     @     @     @     @@     @     @     @     @     @@33333@      @     @     @     @      @(     @0     @8     @@     @H     @S33333@X     @`     @h     @p     @zfffff@     @     @     @     @     @     @     @     @     @     @     @     @     @     @33333@     @      @     @     @     @@(     @0     @8     @?33333@M@X@`     @h     @p     @x     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @w33333@     @     @     @     @     @     @@     @     @     @     @     @     @     @     @     @      @     @     @     @      @(     @0     @8     @@     @H     @P     @X     @`     @h     @p     @x     @     @     @     @     @@     @@     @     @     @     @     @33333@@     @     @      @33333@     @@      @'33333@1@8     @Bfffff@G33333                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @"FA@"JfB@"Nt@"D7@"I'RTa@"Ov@"LI^5?@"IrGE@"G	k@"Jn@"K6z@"MB@"MO;dZ@"NO;@"MC\@"Fs@"F'@"IQ@"Rᰊ@"SZ@"UY|@"W@"\u"@"^$t@"_o@"`4m9@"an.@"cn.3@"a$/@"bh	ԕ@"bI^5@"b&IR@"cS@"be+@"a@"b`A@"f1.@"h1&x@"i'RTa@"jOv`@"lC@"o;dZ@"o;dZ@"oo @"n+@"o'/W@"o{J#:@"p
=q@"p{@"pD@"p{@"q_p@"q4J@"v}Vl@"y"`@"z1'@"y(@"{qu!@"~u@"}[@"}!.H@"y"`@"xYJ@"xF]d@"yrGE8@"}<64@"|#x@"|PH@"{~$@"{A@"{A@"yY}@"u$/@"p-
q@"kƧ@"n.2@"o\(@"p{@"p@"pD@"p`A7@"p{@"r<64@"stj~@"ush@"|j~#@"eO@"C\@"sh@"$t@"+I@"+I@"@"
(@"\(@"حV@#Ƨ@#[W?@#M:@")_@"*1@"oiDg@"Z@"zG@"x@"D@"@"X@"I^5?@"?@"xy=c@"r-V@"nT@"lcA \@"k:)z@"f@"`ѷX@"\Q@"Rs@"K'/@"Cwk@">6z@":Y@"4D@"/@".!R<@"._o @"_ح@"
=p@!"@!0U2a|@!`A7@!o@!n@!W@!IQ@!{5Xy@!Fx@!!e@!%2@ ]cA@ m@ @ /@ 8YK@ nP@ Zc@ .H@ W'@ ~($x@ ךkP@ xl"h
@ 5Xy@ ۘA@ Ft@ @N@ ѷX@ hr@ )y@ 
=p@ 8Y@ Ƶ'@ ,zxl@ u!@ dZ@ ~@ L_@ 	k~@ R@ bM@ zc	@ w3@ ka@@ WkP@ G@@ /4֡a@ %u@ ! [7@ H˒:@ 
(@ Xe@ sP@ )^	@}H@ԯO
M@̲@nO@TɅo@u!@wKƧ@aae@]ce@[=K^@^%@a'R@e@jfB@z~@@+@hۋq@WsPH@DJM@5?@"3@
ڹY@#x@G{@5Xy@5Xy@lC@lC@n.@rG@a@O@\N<@~($@"`@eں@[W>6@<쿱@]ce@:@a@N@{/V@RT`d@Mqu"@74m@)^@Q_@
	 @@:S@o@ק&@
M;@oiDg@6@rGE8@TɆ@ڹY@|Z@mC\@\wkP@N+@MM:@N!R<@L@J=p
@Kq@Dg8}@2a|Q@PH@p:@zxl"@@,zxl@>B[@n.3@@@`d@~\N<@kU=@[S@;A@䎊r@JE@ hۋq@ⶮ}Vm@t@zG@
=p@u%F@e+a@@cA \@ˬq@ʦL/{@ɠ'RTa@āo h@쿱[@KƧ@"h	ԕ@tj@]cf@{lC@uY|@nO;@[S@En/@<PH@5?|h@2s@,>B[@#S&@6C@nO@]cf@@N;6@C@g@Ov`@ݘ@x4֡b@mhr!@c9@W@N+@<PH@ 
qu@K]d@@ NU@($x@sg@'RT@U=@	k@ ѷY@O;dZ@\)@q@;5X@C%@y@?@?@~m\@S@N@D2W@Do h@DM:@C@B74@>"@<#x@:@:^5?|@:S&@8)@6Fs@5?@3@.1@'&@}H@@#@K]c@	^5?}@
O;dZ@tj@O;@L/{J@Vu@^@:)y@7KƧ@8YK@nP@hۋq@~6z@}E@}E@ѷX@m\@F]c@~BZc @|쿱[@{/V@z@t9XbN@m8Y@bh	ԕ@Ye+a@P*0U@Ca@N@:S&@1-@#wk@kP|@@@@X@p:~@
M:@
#9@kP@?|h@g	@ᰉ'R@,=@حU@Z@*0U@@@o i@ï@@nP@{J#9@a@N@A@m8@o@y@L/{J@`A@
qu@5?|@y=c@JM@ [7@@jJL@cZ@_䎊r@QN;5@GE84@=E@9~($@7KƧ@4#@+C]@,=@M:@$xG@.H@߾vȴ9@+@n@|hs@S&@6C@+j@sP@:)z@ݗ+@84֡@:S@z)_@o@a.H@U=K@QN;6@Nߤ?@M(@KxF]@GE84@=E@_@ߤ?@D@s@@t@g	@+@o i@ڹZ@5Xy@'0@6z@eO@䎊r@>BZ@n@:)z@yrGE8@n}Vl@d%1@U2a|@T*1@TZ@Sa@O@OrGE9@?[W>@'	k@M:@PH@빌~($@bM@~($x@Q@7KƧ@Ж@Q_@޸Q@?@6C@,=@빌~($@?|h@#x@l!-@,zxl"@/-V@
@[W>@D@*0U2a@C,@Q@[W>6@L/{@\N;@aGz@\?@ce@Q_@@Fs@C,z@A@fA@E84@z@fx@T`d@i@weں@{lC@~"@74@n@S&@>@($xG@+U=@2a|Q@5Y|@5!.@$?@a@O@1&x@H˒@
=q@@A@[W>@_o@S@7Kƨ@u%F@
D@:)z@
qu"@o h@F@Y|@	@s@2W@
ڹY@s@p:@%2@F]c@@4֡b@W@lD@A@@"`B@Ϫ͞@C%@`A7@:)y@ɺ^5?}@$/@#w@@w1@zG@q@C]@fB@L/{J@A [@n.3@3@u!@/w@q@`d@y@6@n.@o@cn.3@be+@cS@cn.3@dxF@cwk@c	@bwkQ@be+@aGz@aR<6@`
qu@\?@Xy=c@W@S@B&IR@'8}H@
qiC@\)@
qu@qu!@y=c@ۥS@ěT@U2a|@~($@74@BZc @	oiD@:)z@	k~(@	^5?}@S&@u%F
@ 6@쿱[@	k~@s@fA@'RT`@ԕ*1@K]d@E@"`@4֡b@4K@-V@h	ԕ@|Q@Gz@	k@PH@\N@y=b@xF@{dZ@z)y@xF]d@xF]d@w3@}b@Zc@@s@L_@5Xy>@Ϫ͞@1&@ěT@(\@vȴ@@ߤ?@qiC@|#x@u?@tJ@qA [@bwkQ@\u"@K҈@@C@;~$@5'0@*g	@"@4@,<@C%@[W>6@8YJ@͸@qu"@I^5?@(@qu"@@qu"@:@ΤT@ќu@@E@쿱[@~$@4֡b@Y|@oiDg8@U=@C,z@͞&@lD@A [@wkP@S@c	@1'@>BZ@_o@&@&@nO@<64@p:@:)y@|@qiC@Q@n.@     @~($x@|hr@zC\@t֡a@t3@t!-w2@o-V@nH@nzG@h@bM@`d8@]+j@[qu!@YJE@V@VOv_@S@S@N@QX@K҈@J	 @JqiC@G+I@F&I@DM:@F&I@DM:@Dg8}@DJM@A$/@?$tS@=K]@:G{@:)_@;s@;s@;s@:S&@9XbM@73@0
=q@+a@@&IQ@Ft@c	@$/@nO@
jOv@Fs@a@N@o hی@3@
(@ hۋ@V@d7@x@e+@s@:)y@or@],=@Xe+@Sa@O@R䎊@P)^@MM:@L@I'RTa@F&I@Eo i@DS@C%2@Ca@N@?˒:)@>
(@;5Xy@:@.1@,1&y@'&@%O
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @@E?|h@@EIQ@@E\@@EQ@@E/w@@E`A7L@@E?|h@@Eu@@Eu@@Eu@@EK]@@EQ@@Equ"@@E84֡@@E5Xy>@@DD@@D>@@Eo i@@Ece@@Ece@@Eݗ@@E%@@E,=@@EE@@Ft@@F@@F8YJ@@FBZc @@F@@F+jg@@F+jg@@F1.@@FL/{J@@F5?|@@F1.@@F?@@Fs@@FO;@@FQ@@FQ@@F]cf@@G
M;@@G
M;@@G
=p@@G hۋ@@G@@G@@G,@@G,@@G$tS@@G,@@G$tS@@G>6z@@G{J#:@@G[W>@@G͞@@Gr@@G;dZ@@HF]d@@G@@GVϫ@@Go @@Gr@@G͞@@G+@@H@@H
qu@@H*0U@@H     @@G#@@G#@@GrGE9@@G@@Gvȴ9@@G͞@@G@@@G#@@H
qu@@H@@H ě@@H1&x@@H:~ @@HoiDg8@@HYJ@@Hn@@I-w1@@J)y@@K*0U2@@L@@N8YJ@@P	ԕ+@@Pu%F@@Q|Q@@Y-w1@@[F]c@@^8YJ@@`-
@@cu%@@fߤ?@@i&x@@jxl"h
@@m?|h@@n҈p;@@q|Q@@v&I@@}<64@@?@@N;6@@:@@	k@@{J#:@@kP@@D@@'RTa@@Ƨ@@y@@g	l@@zG@@@@kP|@@|@@M:@@1@@-@@e+a@@JL@@u%@@ƀIQ@@Ȍ@@@N@@M@@L_@@ѷX@@ҏ\(@@,zxl@@Ӣwk@@>@@եv@@տH˒@@ֵ'@@KƧ@@KƧ@@@@p:@@\)@@e+@@ۋq
@@PH@@_o@@u%F
@@L_@@ܕ*1@@!-w@@O;dZ@@$tS@@-@@
=q@@_o@@^5?|@@D@@@@/{J#@@<쿱@@q@@zxl"@@?@@e@@Ϫ͞@@ᰉ@@@@_ح@@%@@af@@A@@)^@@,@@	@@#@@>BZc@@˒:*@@ ѷ@@@@A [@@hr @@ ѷ@@^5?}@@h	ԕ@@~"@@ڹY@@s@@@N@@dZ@@eO@@5Xy@@@@9XbN@@#@@Vl!@@ڹ@@2X@@zH@@@@TɅ@@)^@@$tT@@0
)@@^5?}@@@@e+@@䎊@@)y@@-V@@:)y@@kP|@@74@@	@@P{@@jf@@:)z@@q@@5Xy@@ߤ@@@/{J#@@I^5?@@wkP@@Z@@u@@o i@@>@@u@@!.H@@84֡@@O
@@!R@@?@@4K@@R<6@@s@@,<@@!.I@@sPH@@r@@6@@$xG@@>BZc@@D*@@D*@@4m9@@73@@NU@@D*@@D*@@hۋq@@tj@@)^@@$tT@@	k~@@#w@@~($@@u@@'R@@ԕ*@@	 @@)y@@a|Q@@Q_@@3@@M@@S&@@}Vm@@u%@@PH@@)^	@@]cA@@g	l@@jf@@jf@@jf@@n.3@@{J#9@@Mj@@@@Ƨ@@ݗ+k@@J@@g@@A [@@J@@VϪ@@o h@@o h@@N;@@#x@@[W?@@j~@@[W?@@֡a@@e@@IQ@@$/@@sg@@hr!@@=K@@-V@@cA @@\(@@H˒@@
qv@@!.@@u@@$/@@;5X@@H@@Ov_خ@@L/{J@@R<6@@_ح@@YJ@@fffff@@%@@qi@@+J@@qi@@@@$t@@@@Q@@A@@1@@6z@@2X@@Q@@Q@@@@m\@@Ϫ͟@@C-@@1@@1@@x@@쿱[W@@x@@@@Fs@@@@Xe,@@b}V@@͞@@@A 	ԕ+@A *0@A U2a|@A y=c@A n@A )^@A ѷX@A @A hۋq@A @A U@A TɅ@A p:@A `A7@A \)@A $tT@A@A=b@Aae@Au!S@A7Kƨ@A@AiB@A6C@AW'@Au%F
@AS&@Aᰊ@AS&@A@AY@A<64@A)_@A`A@A`A@A,<@A ѷ@A`A@A,<@AG{@A74@AC,@A'/@A/V@A=K^@AF]c@AJ#9@AdZ@Aa@N@AdZ@Ajf@Ajf@Aqu!@Atj~@AxF]@AMj@AA@AU=@Aq@AE@A6@A6@AƧ@A|@A@A\N@A\N@A2W@ASMj@AzG@AC@Aj~@AJM@A!-w@AK]@Au@Au@Ae@A@A7@AZ@A>B[@A!-w@AJM@A!-w@A:@A֡a@AZ@Ae@A'0@Ae@Ao i@Au@A2a|@A<64@A`A7L@AS&@AjOv@AM:@Am\@Ap
=@A!R@A+j@A@A쿱[@Ao h@Am8@AwkP@Ag8}@Am8@A1&y@Aa@O@AJ@A<쿱@AI^5?@A(\@A?@A64@AQ@A\N@AlC@A~($@Aa@O@Aa@O@A@Ag8}@AC@A_@AN;@AS@Am8@AlC@AƧ@AA@Aa@N@AP{@A]cA@Ajf@Aa@@Atj@ASMj@A]ce@A64@AC@Aqu"@Am\@A@A}Vl@AE84@AحV@AVϫ@AحV@Ar@A[W>@A@AO;d@A	k@AH˒:@AQ@A!.I@AFs@A$/@Aڹ@AϪ͞@A[@Ahr@A>@A?@A#x@ATɆ@Am8@A쿱[@A}H@A?@A
L/@A;5X@A}Vl@Ad8@A
,<@Ag	l@AU=@A
=p@A%1@Aݗ+k@AFs@A"h	ԕ@A%2@Aq@Aqu!@A	@A
m\@A
h	ԕ@A
@AnP@A5Xy@A3@A/@Ahr@Ae@A
'0@A>@AZ@A
o i@A
\(@A
8YK@A
(@Ac	@A,<@A-@At@A+@A1@A@Ax@Aߤ?@Aߤ?@A!.I@Am\@AA@A!.I@A4֡a@Ay@AK]d@A@A@AK]c@A ě@A1&x@AK]c@A[6@AU2a|@A[6@AD*@AU2a|@Al"h	@A-
@A-
@A'RT@A@A
=q@A9Xb@A@@A
(@A\)@AC@A$/@A ѷ@A$tT@A:S@Ao hی@AN;5@AXbM@Ae+a@Ao hی@ArGE8@Ahr @ATɅo@AXbM@AQ@A\)@Au%F@ANU@A ě@A6@A4m9@AeO@A{@A_p@AB@A@Ah	ԕ@Aݘ@As@A6z@A6z@Au%@A=K^@AS@AdZ@AZ@A=K^@A/V@A33333@AC,z@AI^@A@AwkQ@AS&@AS&@AL_@Au%F
@AJL@A^5?|@Ap:@A>B@A,<@Avȴ@AJL@AT`d@AS&@AY@AY@A ě@A͞&@A~@AJ#9@A@A҈@An.@AJ@A]ce@A@A<64@A}H@AM:@A%@A-V@A\(@A!R<@A!R<@A.2@AYJ@Ap:~@AiB@A+J@AQ@A!.I@A+I@A>6z@Ab}V@AO
M@Av_ح@A6@ATɅ@AN;5@AXbM@A~($@A~($@A7Kƨ@A~($@A|Q@Ab}@Ab}@An.@Au%F@A^5?|@AZc@Ad7@A~"@A@4@A~"@AS&@AL/{@A}Vm@A)_@AfB@Am@Am@Am\@As@A~@A)^	@A6z@AMjO@A@N@AJ#9@AW>6z@AZ@AZ@A~$@AU=@A*0U2@A@Aa@O@A|@AE@A|@Ag@A\N@AQ@Atj@AQ@AFs@A2W@AVϪ@A~($x@AN;@A*1@A_@A쿱[@A#x@A#x@Azxl"@Au"@A>@AE@AV@A:@A!.H@A>@Ahr@A:@A*0@AB@AS&@AVl!@A`A7L@AF
L0@AS&@Ace@Am\@Am\@Asg@Azxl"h@AXy=@AXy=@A@AzG@A$/@A?@AYJ@A}Vl@Avȴ9X@Aaf@AQ@AFs@A!-w1@A+I@AAs@AO
M@AH˒:@Ay@A YJ@A!rGE8@A"0U2a|@A")_@A"C,@A#PH@A#/V@A#9@A#W>6z@A#Z@A#~$@A#$@A#S@A#U=@A#*0U2@A#Z@A#5Xy@A#Q@A#g@A$n.@A$I^5?@A$cA \@A$?@A$qj                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	?-V?
=p?7KƧ?E?I^5?}?QR? ěT?
=p?睲-V?      ?Z1'?I^5?}?睲-V?vȴ?\(\?C$?睲-V?-V?E?1&x?
=p?A7Kƨ?bM?E?QR?1&x?j~"?蛥S??|hs?1&y?$/?tj?bM?bM?+?      ?bM?Z1'?(\)?+?(\)?A7Kƨ?      ?QR?A7Kƨ?Q?lC?O;dZ?ěS?nP?r ě?tj?zG{?j~"?;dZ?+I^?nO?tj~?n?lD?zG?=p
=?C$?vȴ9X?zG?Q?lD?lD?Q?GzH?`A7K?hr Ĝ?$/?7KƧ?I^5??$/?O;dZ?xF?7KƧ?+J?\(?$/?`A7L??j~"?1&x? ě?lC?nP?      ?zG?/w?nO;?E?Ѻ^5?|?/v?ȓtj~?ȴ9Xb?zG{?nO?-V?n?Q?$/?&x?bM?bM?5?|h?E?-V?-V?j~"?S?E?"`B?Gz?+J?QR?
=p
?E?+I?$/??|hs?E??|hs?zG{?j~#?E?9XbM?tj~?333333? ě? ě?lD?Q?&x?&x?
=p?bM?bM? ěT?;dZ?;dZ?vȴ9X?Q?5?|h?5?|h?-V?-V?5?|h?5?|h?Q?/v?5?|h?/v?1&y?/v?-V?/v?1&y?/v?-V?1&y?(\)?1&y?1&y?1&y?1&y?1&y?/v?5?|h?1&y?S?/v?1&y?(\)?/v?-V?5?|h?(\)?(\)?1&y?-V?/v?1&y?(\)?1&y?/v?/v?1&y?/v?(\)?/v?1&y?1&y?1&y?1&y?1&y?/v?/v?1&y?/v?/v?5?|h?Q?5?|h?/v?1&y?1&y?/v?/v?/v?1&y?-V?-V?/v?-V?/v?1&y?1&y?-V?/v?Q?5?|h?1&y?/v?/v?/v?(\)?1&y?1&y?/v?1&y?1&y?1&y?1&y?1&y?/v?1&y?1&y?-V?/v?5?|h?Q?/v?5?|h?/v?-V?5?|h?1&y?/v? ěT?-V?/v?/v?1&y?-V?-V?/v?-V?-V?/v?-V?5?|h?5?|h?5?|h?5?|h?-V?-V?/v?;dZ?Q?5?|h?5?|h?-V?-V?5?|h?Q?-V?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?-V?-V?-V?-V?5?|h?/v?5?|h?5?|h?-V?5?|h?-V?-V?5?|h?-V?-V?5?|h?-V?5?|h?-V?-V?Q?5?|h?5?|h?5?|h?/v?-V?5?|h?5?|h?/v?-V?5?|h?5?|h?5?|h?5?|h?5?|h?-V?5?|h?-V?5?|h?5?|h?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?5?|h?-V?Q?5?|h?Q?5?|h?5?|h?5?|h?;dZ?Q?Q?Q?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?Q?5?|h?5?|h?Q?5?|h?5?|h?5?|h?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?Q?5?|h?5?|h?Q?;dZ?Q?5?|h?Q?5?|h?5?|h?5?|h?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?Q?Q?Q?5?|h?Q?;dZ?Q?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?5?|h?Q?5?|h?5?|h?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?5?|h?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?-V?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?Q?5?|h?5?|h?Q?Q?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?5?|h?Q?Q?Q?5?|h?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?Q?Q?5?|h?Q?5?|h?Q?;dZ?-V?;dZ?;dZ?Q?Q?Q?;dZ?Q?
=p?lD?Q?Q?5?|h?5?|h?Q?5?|h?Q?Q?Q?Q?Q?;dZ?Q?Q?5?|h?Q?Q?Q?5?|h?5?|h?5?|h?5?|h?5?|h?Q?;dZ?Q?Q?5?|h?5?|h?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?5?|h?Q?Q?5?|h?5?|h?5?|h?Q?Q?;dZ?Q?Q?;dZ?;dZ?5?|h?Q?;dZ?5?|h?Q?;dZ?Q?Q?5?|h?Q?Q?Q?Q?Q?5?|h?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?Q?Q?Q?Q?Q?;dZ?;dZ?Q?Q?Q?Q?Q?Q?Q?5?|h?Q?Q?Q? ěT?Q?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?Q?;dZ?Q?Q?Q?Q?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?5?|h?Q?Q?5?|h?Q?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?Q?;dZ?Q?Q?;dZ?Q?Q?Q?;dZ?Q?;dZ?Q?Q?Q?Q?Q?Q?;dZ?Q?5?|h?5?|h?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?Q?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?Q?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?5?|h?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?Q?Q?;dZ?Q?;dZ?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?Q?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?;dZ?Q?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?;dZ?vȴ9X?Q?Q?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?;dZ?Q?;dZ?;dZ?;dZ?;dZ?;dZ?Q?;dZ?vȴ9X?vȴ9X?vȴ9X?vȴ9X?;dZ?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?;dZ?;dZ?vȴ9X?;dZ?;dZ?vȴ9X?vȴ9X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ??                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	 	P3                                      1                                       ){BB}3